/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2006 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: $
 */

/*
 *  JSP-1.4.2 ʹߤѹ줿ߥϥɥؤб
 */

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#include <tinet_defs.h>
#include <tinet_config.h>

/*
 *  fec_inter_init -- åȰ¸γߤν
 */

int
memcmp(const void* s1, const void* s2, int n) {
  char* a1 = (char*)s1;
  char* a2 = (char*)s2;
  
  while (n--)
    if (*a1++ != *a2++)
      return *(a1 - 1) - *(a2 - 1);
  return 0;
}


void*
memset(char *s, int c, int n) 
{
  char* p = s;
  while (n--) {
    *p++=c;
  }
  return s;
}


void*
memcpy(void* dest, void* src, int n) {
  char *p1 = dest;
  const char *p2 = src;
  int i;

  for (i = 0; i < n; i++) {
    *(p1++) = *(p2++);
  }

  return dest;
}

void *
memmove (void *d, void *s, int n)
{
    char *dst = d;
    char *src = s;
    void *ret = dst;

    if (src < dst) {
	src += n;
	dst += n;
	while (n--)
	    *--dst = *--src;
    }
    else if (dst < src)
	while (n--)
	    *dst++ = *src++;
    return ret;
}

#if TKERNEL_PRVER >= 0x1042u	/* JSP-1.4.2 ʹ */

/*
 * fec_dis_inter -- ߤػߤ롣
 */
IPM
fec_dis_inter(void)
{
  IPM	ipm;
  
  syscall(get_ipm(&ipm));
  syscall(chg_ipm(if_fec_handler_intmask));
  return ipm;
}

/*
 *  fec_bus_init -- åȰ¸ΥХν
 */

void
fec_bus_init (void)
{
}

/*
 *  fec_inter_init -- åȰ¸γߤν
 */

void
fec_inter_init (void)
{
  int i;
  /* NIC γߤĤ롣*/
  for (i = TBIT_FEC_XINF; i <= TBIT_FEC_BABR; i++) {
    sil_wrb_mem (MCF_INTC_ICR(MCF_INTC0, i), ((FEC_INT_LEVEL) << 3) | (FEC_INT_PRI));
    if (i < 32)
      sil_wrw_mem (MCF_INTC_IMRL(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRL(MCF_INTC0)) & (~(1 << i)));
    else
      sil_wrw_mem (MCF_INTC_IMRH(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRH(MCF_INTC0)) & (~(1 << (i-32))));
  }
}

#endif	/* of #if TKERNEL_PRVER >= 0x1042u */
