/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2006 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: $
 */

#ifndef _TINET_CPU_CONFIG_H_
#define _TINET_CPU_CONFIG_H_

/*
 *  TCP/IP ˴ؤ
 */

/* TCP ˴ؤ */

/*
 *  MAX_TCP_SND_SEG: ȥκ
 *
 *    ꤫ MSS ץǥȥꤵƤ⡢
 *    ͤǡȥ¤Ǥ롣
 */

#ifndef MAX_TCP_SND_SEG
#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
#endif	/* of #ifndef MAX_TCP_SND_SEG */

/*
 *  DEF_TCP_RCV_SEG: ȥε
 */

#ifndef DEF_TCP_RCV_SEG
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
#endif	/* of #ifndef DEF_TCP_RCV_SEG */

/* 
 *  Ȥν֤ؤȤ˿˥ͥåȥХåեƤơ
 *  ǡ򥳥ԡ륵Τ
 */
#define MAX_TCP_REALLOC_SIZE	1024	

#define TCP_CFG_OPT_MSS		/* ͥ߻ˡȥץĤ롣*/
#define TCP_CFG_DELAY_ACK	/* ACK ٤餻ȤϥȤ򳰤			*/
#define TCP_CFG_ALWAYS_KEEP	/* ˥ץ饤֤ϥȤ򳰤		*/

/* UDP ˴ؤ */

#define UDP_CFG_IN_CHECKSUM	/* UDP ϥåԤϥȤ򳰤	*/
#define UDP_CFG_OUT_CHECKSUM	/* UDP νϥåԤϥȤ򳰤	*/

/* ICMPv4/v6 ˴ؤ */

#define ICMP_REPLY_ERROR		/* ICMP 顼åϥȤ򳰤*/

/* IPv4 ˴ؤ */

//#define IP4_CFG_FRAGMENT		/* ǡʬ䡦ƹԤϥȤ򳰤*/
#define NUM_IP4_FRAG_QUEUE	2	/* ǡƹ塼			*/
#define IP4_CFG_FRAG_REASSM_SIZE	4096	/* ƹХåե				*/

/* IPv6 ˴ؤ */

#define NUM_IP6_DAD_COUNT	1	/* ʣɥ쥹Фβ		*/
					/*  0 ꤹȡʣɥ쥹ФԤʤ	*/
#define NUM_ND6_CACHE_ENTRY	10	/* ٥åΥȥ			*/

#ifdef SUPPORT_ETHER

#define IP6_CFG_AUTO_LINKLOCAL		/* 󥯥륢ɥ쥹μưԤϥȤ򳰤*/

/*
 *  ǥեȥ롼ꥹȤΥȥ
 *  0 ꤹȥ롼Τʤ
 */
#define NUM_ND6_DEF_RTR_ENTRY	2

/*
 *  ưΥ롼ϲ
 *  0 ꤹȥ롼Ϥʤ
 */
#define NUM_ND6_RTR_SOL_RETRY	3	

#endif	/* of #ifdef SUPPORT_ETHER */

/*
 *  ǡ (ͥåȥ󥿥ե) ˴ؤ
 */

/*
 *  PPPǥ˴ؤ
 */

#define MODEM_CFG_DIAL		"ATD"	/* 륳ޥʸ			*/
#define MODEM_CFG_RETRY_CNT	3	/* ȥ饤			*/
#define MODEM_CFG_RETRY_WAIT	10000	/* ȥ饤ޤǤԤ [ms]	*/

/*
 *  PPPHDLC ˴ؤ
 */

#define DEF_LOCAL_ACCM		0x000a0000	/* ʬ ACCMXON  XOFF ΤѴ	*/
#define DEF_REMOTE_ACCM		0xffffffff	/*  ACCMͤѴ		*/

/*
 *  PPPLCP ˴ؤ
 */

#define LCP_CFG_MRU		0x0001	/* MRU					*/
#define LCP_CFG_ACCM		0x0002	/* ACCM					*/
#define LCP_CFG_MAGIC		0x0004	/* ޥåֹ				*/
#define LCP_CFG_PCOMP		0x0008	/* ץȥ̵ǽ			*/
#define LCP_CFG_ACCOMP		0x0010	/* ɥ쥹			*/
#define LCP_CFG_PAP		0x0020	/* PAP					*/
/*#define LCP_CFG_CHAP		0x0040	   CHAP ϼͽ			*/

#ifdef LCP_CFG_MAGIC

#define LCP_ECHO_INTERVAL	(20*NET_TIMER_HZ)	/* 󥿡Х		*/
#define LCP_ECHO_FAILS		9			/* 			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

/*
 *  PPPPAP ˴ؤ
 */

#define DEF_PAP_TIMEOUT		(3*NET_TIMER_HZ)
#define DEF_PAP_REQTIME		(30*NET_TIMER_HZ)	/* ॢȽԤȤϥȤ򳰤*/
#define MAX_PAP_REXMT		10			/* ǧ׵κ	*/

/*
 *  ARP ˴ؤ
 */

#define NUM_ARP_ENTRY		10			/* ARP å奨ȥ	*/

/*
 *  DHCP ˴ؤ
 *
 *    : TINET ϡDHCP Ƥʤѥץǡ
 *            DHCP å뤿Ǥ롣
 *            ޤߤ IPv4 ΤͭǤ롣
 */

/*#define DHCP_CFG					 DHCP ϥȤ򳰤*/

/*
 *  Ethernet ˴ؤ
 */

/*#define ETHER_CFG_ACCEPT_ALL		 ޥ㥹ȡ顼ե졼ȤϥȤ򳰤	*/
/*#define ETHER_CFG_UNEXP_WARNING	 󥵥ݡȥե졼ηٹɽȤϥȤ򳰤		*/
/*#define ETHER_CFG_802_WARNING		 IEEE 802.3 ե졼ηٹɽȤϥȤ򳰤		*/
/*#define ETHER_CFG_MCAST_WARNING	 ޥ㥹ȤηٹɽȤϥȤ򳰤		*/

/*
 *  ѥͥåȥ˴ؤ
 */

/* ͥåȥХåե */

#ifdef SUPPORT_PPP

/*
 *  PPP ǤϡѤ ͥåȥХåե PDU (1502) 
 *  ƤʤФʤʤΤ PDU ¿˳ݤ롣
 */

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	2	/* IF + IP + TCP2 ʾ*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	0	/* 64 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	2	/* IF  PDU 	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_REASSM
#define NUM_MPF_NET_BUF_REASSM	2	/* ƹХåե	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_REASSM */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*
 *  ͥåȤξΥͥåȥХåեγ
 */

/*
 *  !!
 *
 *  NE2000 ߴ NIC ΥǥХɥ饤Сif_edˤκĹ
 *  60ʥ饤󤷤 62˥ƥåȤΤ IF + IP +TCP 
 *  64 ƥåȤΥͥåȥХåեŬǤ롣
 */

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	0	/* IF + IP + TCP	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	2	/* 64 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#if defined(SUPPORT_INET4)

#ifndef NUM_MPF_NET_BUF_IP_MSS
#define NUM_MPF_NET_BUF_IP_MSS	0	/* IF + 576 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IP_MSS */

#endif	/* of #if defined(SUPPORT_INET4) */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#if defined(SUPPORT_INET6)

#ifndef NUM_MPF_NET_BUF_IPV6_MMTU
#define NUM_MPF_NET_BUF_IPV6_MMTU	0	/* IF + 1280	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IPV6_MMTU */

#endif	/* of #if defined(SUPPORT_INET6) */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* IF  PDU 	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_REASSM
#define NUM_MPF_NET_BUF_REASSM	2	/* ƹХåե	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_REASSM */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	2	/* IF + IP + TCP	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	0	/* 64 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 ƥåȡ2 ʾ	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 ƥå	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* IF  PDU 	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#endif	/* of #ifdef SUPPORT_PPP */

/*
 *  ͥåȥ׾η¬
 *
 *  ͥåȥ׾η¬Ԥϡtinet/include/net/net.h
 *  Ƥץȥ뼱̥ե饰ꤹ롣
 */

#if 1

#ifdef SUPPORT_INET4

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_ARP		\
				| PROTO_FLG_IP4		\
				| PROTO_FLG_ICMP4	\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET4 */

#ifdef SUPPORT_INET6

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_IP6		\
				| PROTO_FLG_ICMP6	\
				| PROTO_FLG_ND6		\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET6 */

#else	/* of #if 0 */

#define NET_COUNT_ENABLE	(0			\
				)

#endif	/* of #if 0 */

#endif /* _TINET_CPU_CONFIG_H_ */
