/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.17 2007/03/23 07:22:15 honda Exp $
 */
#define _MACRO_ONLY
#include <t_config.h>
	
/*
 *   H8ѥȥåץ⥸塼
 *   ͥϥץꥱȥ󥯤ƻѤΤ
 *   Υȥåץ⥸塼JSPͥǤΤ߻Ѥ롣	
 */
	.h8300h

	.text
	.align 2

	.global	_start
_start:

	/*
	 * 󥿥ƥѥåSTACKTOP˽
	 * STACKTOPϡsys_config.h
	 * _hardware_init_hookƤӽФˤSTACKTOPؤRAM
	 * ΰ褬ǽˤʤäƤɬפ롣ʲȡ
	 */
	mov.l	#STACKTOP, sp
	
	/*  ػ  */
	orc.b  #H8INT_DIS_ALL, ccr

	/*
	 *  _hardware_init_hook ƤӽФ(0Ǥʤ)
	 *
	 *  ϡɥ¸ɬפʽϡ
	 *  hardware_init_hook ȤؿѰդФ褤
	 *  ŪˤROMκݡRAMѲǽˤ뤿
	 *  ХȥνԤ
	 *  sys_support.S  hardware_init_hook Ƥ
	 *  롥
	 *  
	 *  hardware_init_hookǤϥХơȥȥ
	 *  ԤΤǡΥ롼ƤӽФΤRAM
	 *  åΰ˻ѤΤϤ
         *Υ֥롼ƤӽФǤϡ
         *֤ΤޤޥǤ¢RAMޤ
         *˥ˤꥢǤ֤ˤ볰RAM
         *򥹥åΰ˻ѤƤ롣
	 */
start_0:
	mov.l  	#_hardware_init_hook, er0
	beq	start_1
	jsr	@er0
	
	/*
         * bss򥯥ꥢ
	 */
start_1:		
	mov.l	#__bss_start, er0
	mov.l	#_end, er1
	sub.l	er2, er2
start_2:
        mov.l	er2, @er0
	add.l	#4, er0
 	cmp.l	er1, er0
 	blo	start_2		/* er1 > er0 */

	/*
	 *  dataROMбˡ
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ롥
	 *  
	 *  eepmov.w̿ȤΨŪžХȿ
	 *  65,535ХȤ¤뤿ᡢѤƤʤ
	 */
	mov.l	#__idata_start, er0
	mov.l	#__idata_end, er1
	mov.l	#__data_start, er2
start_4:
	mov.l	@er0+, er4	/* *er2++ = *er0 ++; */
	mov.l	er4, @er2
	add.l	#4, er2
	cmp.l	er1, er0
	blo	start_4		/* er1 > er0 */

	/*
	 *  software_init_hook ƤӽФ0 Ǥʤˡ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
	mov.l	#_software_init_hook, er0
	beq	start_6		
	jsr	@er0
		
	/*	
         *  ͥư
	 */
start_6:
	jmp	@_kernel_start

