/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: makeoffset.c,v 1.2 2007/03/23 07:59:26 honda Exp $
 */


#include "jsp_kernel.h"
#include "task.h"

#define OFFSETOF(structure, field) \
                        ((INT) &(((structure *) 0)->field))

/*  OFFSET_DEF()Υ󥿡ե  */
#define INTERFACE1(TYPE, FIELD)                                         \
          INT JOINT4(OFFSET_DEF_,TYPE,_,FIELD)(void)

#define OFFSET_DEF(TYPE, FIELD)                                         \
          extern INTERFACE1(TYPE, FIELD);                               \
          INTERFACE1(TYPE, FIELD)                                       \
          {                                                             \
                return OFFSETOF(TYPE, FIELD);                           \
          }

/*  OFFSET_DEF2()Υ󥿡ե  */
#define INTERFACE2(TYPE, FIELD, FIELDNAME)                              \
          INT JOINT4(OFFSET_DEF_,TYPE,_,FIELDNAME)(void)

#define OFFSET_DEF2(TYPE, FIELD, FIELDNAME)                             \
          extern INTERFACE2(TYPE, FIELD, FIELDNAME);                    \
          INTERFACE2(TYPE, FIELD, FIELDNAME)                            \
          {                                                             \
                return OFFSETOF(TYPE, FIELD);                           \
          }

#define BIT_LABEL(TYPE, FIELD)  JOINT4(BIT_FIELD_OFFSET_,TYPE,_,FIELD)


OFFSET_DEF (TCB, tinib)
OFFSET_DEF2(TCB, tskctxb.sp, sp)
OFFSET_DEF2(TCB, tskctxb.pc, pc)
OFFSET_DEF (TINIB, task)
OFFSET_DEF (TINIB, exinf)
OFFSET_DEF (TCB, texptn)


TCB     BIT_LABEL(TCB, enatex) = {
                { NULL, NULL }, NULL, 0, 0,
                FALSE, FALSE, TRUE,
                0, NULL, { NULL, NULL }
        };

