/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _MINET_H8S_2339F_H_
#define _MINET_H8S_2339F_H_

/*
 *  MiSPO MiNET-H8S/2339F
 */

#define MINET_H8S_2339F

/*
 *  SYSCRν
 *  INTM1=1,INTM0=0⡼ɣ
 *  NMIEG=0NMIϤΩꥨåǳ׵ȯ
 *  IRQPASIRQüҥ쥯
 *  RAME=1¢RAMͭ
 */
#define	SYS_SYSCR	(INT_MODE2 | RAME)

/*
 *  CPU å
 */
#define CPU_CLOCK	24576			/* kHzñ 24.576MHz*/

/*
 *  ޤ˶뤵륯å (å/4ǥ)
 */
#define TIMER_CLOCK	((CPU_CLOCK)/4)		/* kHzñ */

/*
 *  ꥢݡȤBRR쥸ͤ
 *    ׻Ѥˡ⤢뤬Ƚ꤬ɬפʤΤǡ
 *̤˥ޥƤ롣
 *BRR_RATEޥϥޥ˥奢Nб롣
 *n=0Ǥ롣
 *BAUD_RATEuser_config.h롣
 */
#if CPU_CLOCK != 24576
#error CPU_CLOCK is invalid value.
#else /*  CPU_CLOCK != 24576  */

/*  SCI0  */
#if BAUD_RATE0 == 9600		/* ӥåȥ졼ȡ 9600[bps] */
	#define BRR0_RATE	79
#elif BAUD_RATE0 == 19200	/* ӥåȥ졼ȡ19200[bps] */
	#define BRR0_RATE	39
#elif BAUD_RATE0 == 38400	/* ӥåȥ졼ȡ38400[bps] */
	#define BRR0_RATE	19
#endif /* BAUD_RATE0 == 9600  */

/*  SCI1  */
#if BAUD_RATE1 == 9600		/* ӥåȥ졼ȡ 9600[bps] */
	#define BRR1_RATE	79
#elif BAUD_RATE1 == 19200	/* ӥåȥ졼ȡ19200[bps] */
	#define BRR1_RATE	39
#elif BAUD_RATE1 == 38400	/* ӥåȥ졼ȡ38400[bps] */
	#define BRR1_RATE	19
#endif /* BAUD_RATE1 == 9600  */

/*  SCI1  */
#if BAUD_RATE2 == 9600		/* ӥåȥ졼ȡ 9600[bps] */
	#define BRR2_RATE	79
#elif BAUD_RATE2 == 19200	/* ӥåȥ졼ȡ19200[bps] */
	#define BRR2_RATE	39
#elif BAUD_RATE2 == 38400	/* ӥåȥ졼ȡ38400[bps] */
	#define BRR2_RATE	19
#endif /* BAUD_RATE1 == 9600  */

/*
 *  SCR쥸CKS0,CKS1ӥå
 *ܡ졼ȷ׻n=0б
 *ܡ졼ͤۤʤ礬Τ
 */
#define SCR0_CKS		0	/*  SCI0  */
#define SCR1_CKS		0	/*  SCI1  */
#define SCR2_CKS		0	/*  SCI2  */

#endif /* CPU_CLOCK != 24576 */

/*
 *  DDR쥸νͤ
 */
#define P1DDR0		0xf0
#define P2DDR0		DUMMY
#define P3DDR0		DUMMY
/*  ݡȣDDRʤᡢ  */
#define P5DDR0		DUMMY
#define P6DDR0		0xc3
#define P7DDR0		DUMMY
#define P8DDR0		DUMMY
#define P9DDR0		0xe0
#define PADDR0		0xff
#define PBDDR0		0xff
#define PCDDR0		0xff
#define PDDDR0		DUMMY
#define PEDDR0		DUMMY
#define PFDDR0		0xff
#define PGDDR0		0x1f




#endif /* _MINET_H8S_2339F_H_ */
