/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _H8S_SIL_H_
#define _H8S_SIL_H_

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

/*
 *  H8SѰ̥󥿥ե
 */
#define h8s_reb_mem(x)		sil_reb_mem( (VP)(H8S_BASE_ADDR + x) )
#define h8s_wrb_mem(x, y)	sil_wrb_mem( (VP)(H8S_BASE_ADDR + x), y )

#define h8s_reh_mem(x)		sil_reh_mem( (VP)(H8S_BASE_ADDR + x) )
#define h8s_wrh_mem(x, y)	sil_wrh_mem( (VP)(H8S_BASE_ADDR + x), y )

/*
 *  H8SѰ̥쥸ؿ
 */
#define h8s_orb( mem, val )	h8s_wrb_mem( mem, h8s_reb_mem( mem ) | val )
#define h8s_andb( mem, val )	h8s_wrb_mem( mem, h8s_reb_mem( mem ) & val )

#define h8s_orh( mem, val )	h8s_wrh_mem( mem, h8s_reh_mem( mem ) | val )
#define h8s_andh( mem, val )	h8s_wrh_mem( mem, h8s_reh_mem( mem ) & val )

#endif /* _H8S_SIL_H_ */
