/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.2 2006/08/03 04:14:02 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼M3029ѡ
 */

#include "jsp_kernel.h"
#include <sil.h>
#include "m3029.h"

/*
 *  åȥƥ¸ 롼
 */

void
sys_initialize(void)
{
	VB * p;

	/* 
	 * üҳ쥸ν
	 * ԤޤǰüҤưʤ 
	 */
	/* å */
	sil_wrb_mem((VP)(TADR_SFR_PRCR), TVAL_PACR_PRCR);
#ifdef PIN80 
	sil_wrb_mem((VP)(TADR_SFR_PACR), TVAL_80_PACR);
#else /* PIN64 */
	sil_wrb_mem((VP)(TADR_SFR_PACR), TVAL_64_PACR);
#endif
	/* å */
	sil_wrb_mem((VP)(TADR_SFR_PRCR), 0x00);
		
	/* ȥ#2쥸ν */
	p = (VB*)TADR_SFR_UART0_BASE;
	sil_wrb_mem((VP)(p+TADR_SFR_UC2_OFFSET), 0x00);
	
#if CONSOLE_PORTID == 1
	p = (VB*)TADR_SFR_UART0_BASE;
#else	/* CONSOLE_PORTID == 2 */
	p = (VB*)TADR_SFR_UART1_BASE;
#endif	
	
	/* ⡼ɥ쥸ν */
	sil_wrb_mem((VP)(p+TADR_SFR_UMR_OFFSET), 0x05);	/* ݥɥ쥸 å,*/
													/* Ʊ8ӥåȡѥƥʤ	*/
													/* ꡼פʤ						*/
	/* 쥸ν */
	sil_wrb_mem((VP)(p+TADR_SFR_UC0_OFFSET), 0x10);	/* 쥸0 åf1 */
	/* ž®٥쥸ν (38400bps32) */
	sil_wrb_mem((VP)(p+TADR_SFR_UBRG_OFFSET), 32);	/* ž®٥쥸(19200bps)		*/
	/* 쥸ν */
	sil_wrb_mem((VP)(p+TADR_SFR_UC1_OFFSET), (TBIT_UiC1_TE | TBIT_UiC1_RE));
													/* 쥸 	*/

	/* ݡ0ν */
	sil_wrb_mem((VP)TADR_SFR_P0, 0xff);				/* ݡ0ǡ				*/
	sil_wrb_mem((VP)TADR_SFR_PD0, 0xff);			/* ݡ0					*/
}

/*
 *  åȥƥνλ롼
 */

void
sys_exit(void)
{
  while (1)
  	;
}

void
sys_putc(char c)
{
	if(c == '\n'){
	    m3029_putc( '\r' );
	}
    m3029_putc( c );
}


