/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mpc860_smc.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *   MPC860¢ꥢ롦ޥ͡ȥȥSMC ʰץɥ饤
 *
 *smc.{c,h}hw_serial.hʬδ
 *smc.{c,h}ꥢǥХ˰¸ʬΤߵ
 *hw_serial.hꥢǥХʳ˵
 * hw_serial.h˵Ҥ
 *ߥȥ¸ʤ
 */

#ifndef _MPC860_SMC_H_
#define _MPC860_SMC_H_

#include <mpc860_sil.h>

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void	smc_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	smc_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*smc_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	smc_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	smc_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	smc_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	smc_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	smc_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	smc_isr(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	smc_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	smc_ierdy_rcv(VP_INT exinf);

#endif /* _MPC860_SMC_H_ */
/*  end of file  */
