/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼MPC860T TB6102Sѡ
 *ͥǻѤ
 *Cؿμ
 */

#include "jsp_kernel.h"
#include <mpc860_sil.h>

/*
 *  ȯ˥å򤵤줿֤IPMΥǡ¤
 *    4Хȶݻ뤿ᡢߡΰ褬
 */
typedef struct ipm_stack {
	UH	ipm;
	UH	dummy;
} IPM_STACK;

/*
 *  ߥޥѵ٥ơ֥
 *	ipm_tableΤ$(CPU)ȤΥ󥿡ե˴ޤޤʤ
 *define_ipmˤꡢäƤ
 */
IPM ipm_table[TMAX_EXCNO];

/*
 *  SILѤȤΥǽ
 */
#ifdef SIL_DEBUG

BOOL sil_debug_on = FALSE;
char sil_buffer[SIL_BUFFER_SIZE];
int sil_pos = -1;
UW sil_log_id = 0;

#endif	/* SIL_DEBUG */

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
    	INHNO j;
	
	/*
	 *  ̿ץåCPMν
	 */
	
	/*  ꥻåȡޥɤȯ  */
    	mpc860_wrh_mem(CPCR, CPCR_RST | CPCR_FLG);
	
	/*
	 *  ߥȥν
	 *IRLSIUФߥ٥
	 *IEN=1CPMߥ֥͡
	 */
	mpc860_wrw_mem(CICR, CICR_IRL0 | CICR_IEN);

	/*  IPMνCPMߤε  */
	mpc860_wrh_mem(SIMASK, ENABLE_CPM);


	/*
	 *  ǡν
	 */

    	/* IPMơ֥ν */
    	for( j = 0; j < TMAX_EXCNO; j++ ) {
        	ipm_table[j] = DEFAULT_IPM;
    	}
    	
    	/*  CPMߤIPM  */
    	ipm_table[INHNO_CPM] = IPM_CPM;
	
	/*
	 *  ץå̤Τѿν
	 */
	/*  ̤  */
}

/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	tb6102s_exit();
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		tb6102s_putc('\r');
	}
	tb6102s_putc(c);
}

/*
 * ϿƤʤȯΥ
 * ޥPROC_ICUǸƤӽФ
 * ؿ̾ηϥץå˷ɤ
 *
 *     MPC860Ǥϳߥȥ餬³Ƥ뤿ᡢ
 * ƳߥȥѤδؿѰդ
 *
 */

/*  SIUߡCPM߰ʳ  */
void no_reg_SIU_interrupt(INHNO intno, UW *sp)
{
    syslog(LOG_EMERG, "SIU interrupt error occurs.");
    syslog(LOG_EMERG, "Interrupt No.=%d", intno);
    syslog(LOG_EMERG, "IPM=0x%04x", ((IPM_STACK *)sp)->ipm);

    /*  
     *  åΥǡɽ
     *    ߥޥ򥹥åѤǤΤ
     *  ʬåפ
     */
    ++sp;
    syslog_data_on_stack((EXCSTACK *)sp);
    
    while(1);
}

/*  CPM  */
void no_reg_CPM_interrupt(INHNO intno, UW *sp)
{
    syslog(LOG_EMERG, "CPM interrupt error occurs.");
    syslog(LOG_EMERG, "Interrupt No.=%d(total %d)", 
           intno, intno + TMAX_SIU_INTNO);
    syslog(LOG_EMERG, "IPM=0x%04x", ((IPM_STACK *)sp)->ipm);

    /*  
     *  åΥǡɽ
     *    ߥޥ򥹥åѤǤΤ
     *  ʬåפ
     */
    ++sp;
    syslog_data_on_stack((EXCSTACK *)sp);
    
    while(1);
}

/*  end of file  */
