/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼MPC860T TB6102Sѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  桼
 */
#include <user_config.h>

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  åȥƥΥϡɥ񸻤
 */
#include <tb6102s.h>
#include <mpc860t.h>


/*
 *  ưåΥåȥƥ̾
 */
#define	TARGET_NAME	"TANBAC TB6102S CompactPCI CPU Board"

/*
 *  ԤΤ
 */
#ifdef DOWNLOAD_TO_RAM      /*  ǥХå  */

#define	SIL_DLY_TIM1	1425
#define	SIL_DLY_TIM2	 350

#else /* DOWNLOAD_TO_RAM */ /*  ROM  */

#define	SIL_DLY_TIM1	3445
#define	SIL_DLY_TIM2	 867

#endif /* DOWNLOAD_TO_RAM */

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 *ROM˥GDB STUBƽФ̤
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 *ROM˥GDB STUBƽФ̤
 */
extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*
 * CPMؤγ׵Υꥢ
 * CPMߥ󥵡ӥ쥸CISRγӥåȤˣ򥻥åȤ
 * ꥢ롣
 */
#define CLEAR_IRQ_TO_ICU(device)		\
	mpc860_wrw_mem(CISR, CISR_BIT(device))	


/*
 * ϿƤʤSIUߤˤ
 * ʤγߤ¿ųߤǡspμФۤʤ
 */
#define SET_NO_REG_SIU_INTERRUPT_ARG_FROM_TASK	\
	lwz	r4, 0(sp)	/*  ߥåsp  */

#define SET_NO_REG_SIU_INTERRUPT_ARG_FROM_INT	\
	addi	r4, sp, 8	/*  sp+8  */

/*
 * ϿƤʤCPMߤˤ
 * ʤγߤ¿ųߤǡspμФۤʤ
 */
#define SET_NO_REG_CPM_INTERRUPT_ARG_FROM_TASK	\
	lwz	r4, 8(sp)	/*  ߥåsp  */

#define SET_NO_REG_CPM_INTERRUPT_ARG_FROM_INT	\
	addi	r4, sp, 16	/*  sp+16  */


#ifndef _MACRO_ONLY
/*
 * ϿƤʤȯΥ
 * ޥPROC_ICUǸƤӽФ롣
 *     ؿ̾ηϥץå˷ɤ
 *
 *     MPC860Ǥϳߥȥ餬³Ƥ뤿ᡢ
 * ƳߥȥѤδؿѰդ
 *
 */

/*  SIUߡCPM߰ʳ  */
extern void     no_reg_SIU_interrupt(INHNO intno, UW *sp);

/*  CPM  */
extern void     no_reg_CPM_interrupt(INHNO intno, UW *sp);

#endif /* _MACRO_ONLY */

#define EXCEPTION_VECTOR_START_SRC	0x10000100
#define EXCEPTION_VECTOR_END_SRC	0x10002000
#define EXCEPTION_VECTOR_START_DST	0x100



/*  --------------------------------------------------------------  */
/*
 * PowerPCȤΥ󥿡ե
 */

/*
 *   MSRν
 */
#define INIT_MSR    	0

/*
 *  ߽ICU¸ʬ
 *  
 *  װȽ
 *  ߥޥ
 *  ߵ
 *  C롼ƤӽФ
 *  ߶ػ
 *  ɬפǤС˳׵ե饰Υꥢ
 *  
 *  
 *    label٥뼱ʸ
 *    ʣսǤΥޥѤǤ褦ˤ뤿
 *  
 *
 *  MPC860γߥƥ
 *  ƥࡦ󥿡ե˥åSIU
 *  ̿ץå⥸塼CPM
 *  2ؤˤʤäƤ
 *  
 *  MPC860Ǥϥƥ।󥿡ե˥åSIUγߥޥ
 *  SIUߥޥ쥸SIMASKˤΤߤ򥫡ͥǴ롣
 *  ̿ץå⥸塼CPMγߥޥδϤ٤
 *  ϡɥԤäƤ롣
 *  
 *  CPMߥȥʥϡɥˤư
 *    ߤȯ
 *    α쥸CIPRγӥåȤγӥåȤ򥻥å
 *    ȯߤͥ٤
 *    ߥޥ쥸CIMR
 *    󥵡ӥ쥸CISR
 *    ӤƤSIU
 *    ٥쥸CIVRIACKӥåȤ򥻥åȤ
 *    SIUؤγ׵򥯥ꥢ
 *    ٥쥸CIVR˥٥ֹ򥻥å
 *    ٥쥸CIVRIACKӥåȤ򥯥ꥢ
 *    α쥸CIPRγӥåȤ򥯥ꥢ
 *    󥵡ӥ쥸CISRγӥåȤ򥻥å
 *    ʸ塢겼̤γߤޥ
 *    CPMˤĤƤϥեȥˤޥɬפʤ
 *    
 *  CPMߤ˴ؤƤϡSIUIPM˰礷Ʊͤꤹ
 *    
 *  
 *  쥸ơ
 *    SPRG1:٥ơ֥Ƭɥ쥹int_table
 *    SPRG3:IPMơ֥Ƭɥ쥹ipm_table
 *    r0ͣ
 *    r3쥸ΰƬɥ쥹
 *    r4ߥ٥ֹߣ
 *  
 */
#define _PROC_ICU(label)                                                \
    /*  SIUγװȽ  */                                         \
    lis     r3, IMMR_UPPER_2BYTE; /* 쥸ΰƬɥ쥹 */  \
        /*  ٥ֹɤ߽Ф  */                                    \
        /*  SIVEC쥸ˤ"٥ֹ4"ǼƤ  */        \
    lbz     r4, TADR_SIU_SIVEC(r3); /*  r4٥ֹ4  */           \
                                                                        \
    /*  ߥޥ  */                                          \
    /*  SIUߡװͤIPMꤹ  */      		\
    /*  CPMߡ礷ƱͤSIUIPMꤹ  */   		\
    mfspr   r5, SPRG3;      /*  r5ipm_table  */                       \
    srwi    r6, r4, 1;      /*  r6r4>>1ʳֹ2ܡ  */        \
    lhzx    r7, r5, r6;     /*  r7ߥޥ  */                    \
    	/*  ߤγߥޥǧơ  */				\
    	/*  ĤƤʤߤϵĤʤ褦ˤ  */	\
    lhz     r8, TADR_SIU_SIMASK(r3);					\
    and     r9, r8, r7;							\
    sth     r9, TADR_SIU_SIMASK(r3);/*  ߥޥ  */            \
                                                                        \
    /*  CPMߤʤʬ  */                                         \
    cmpwi   crf0, r4, INHNO_CPM*4;                                      \
    beq     label##_CPM_INTERRUPT;                                      \
                                                                        \
    /*  SIUߡCPM߰ʳˤξ  */                            \
    /*  SIUľܡ³ƤǥХγߤξ  */     \
    mfspr   r8, SPRG1;  /*  r8SPRG1int_table  */                    \
                        /*  r4ֹ4  */                       \
    lwzx    r9, r8, r4; /*  r9C롼Ƭɥ쥹  */         \
    mtctr   r9;         /*  CTRr9  */                                 \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EEӥåȤ򥻥å  */                \
    mtmsr   r11;                /*  ߵ  */                      \
    cmpwi   crf0, r9, 0;	/*  ߥϥɥ餬ϿƤ뤫 */ \
    beq     label##_call_no_reg_SIU_interrupt; /*  å  */         \
    bctrl;                      /*  C롼ƤӽФ  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EEӥåȤ򥯥ꥢ  */                \
    mtmsr   r11;        /*  ߶ػ  */                              \
    b       label##_exit;/*  PROC_ICUޥνиإ  */         \
                                                                        \
    /*                                                                  \
 *SIUߡCPM߰ʳˤǳߥϥɥ餬                  \
 *ϿƤʤ                                          \
 */                                                                 \
label##_call_no_reg_SIU_interrupt:;                                     \
    srwi    r3, r4, 2;          /*  r3ֹ  */                  \
    SET_NO_REG_SIU_INTERRUPT_ARG_##label;                               \
    LI32(r9, no_reg_SIU_interrupt);                                     \
    mtctr   r9;         /*  CTRr9  */                                 \
    bctr;                                                               \
    /*  ˤäƤʤ  */                                        \
                                                                        \
    /*                                                                  \
 *CPMߤǳߥϥɥ餬                                   \
 *ϿƤʤ                                          \
 */                                                                 \
label##_call_no_reg_CPM_interrupt:;                                     \
    srwi    r3, r4, 2;          /*  r3ֹ  */                  \
    SET_NO_REG_CPM_INTERRUPT_ARG_##label;                               \
    LI32(r9, no_reg_CPM_interrupt);                                     \
    mtctr   r9;         /*  CTRr9  */                                 \
    bctr;                                                               \
    /*  ˤäƤʤ  */                                        \
                                                                        \
                                                                        \
    /*  CPMߤξ  */                                             \
    /*  SIUIPMѤ  */                                      \
    /*  CPMIPMϥϡɥԤ  */                        \
label##_CPM_INTERRUPT:;                                                 \
    /*  CIVR쥸IACKӥåȤ򥻥å  */                            \
    li      r5, TA_CPM_CIVR_IACK;                                       \
    sth     r5, TADR_CPM_CIVR(r3);                                      \
    /*  CPMߥ٥ֹɤ߽Ф  */                                 \
            /*  ߥ٥쥸CIVRˤϥ٥ֹ椬  */            \
            /*  11ӥåȺեȤ줿֤ǳǼƤ  */          \
    lhz     r6, TADR_CPM_CIVR(r3);  /*  r6٥ֹ<<11  */          \
    srwi    r4, r6, 9;  /*  r4r6>>9ʳֹ4ܡ  */            \
    stwu    r4, -STACK_MARGIN(sp); /*  ٥ֹ¸  */             \
    		/*  sp8ХȤ餹ΤϡC롼  */		\
    		/*  sp+4Ϥ˽񤭹ߤԤ  */			\
        /*  CPMΥ٥ֹSIUΤΥ٥ֹѴ  */      \
    addi    r5, r4, TMAX_SIU_INTNO*4;                                   \
    mfspr   r8, SPRG1;  /*  r8SPRG1int_table  */                    \
                        /*  r4ֹ4  */                       \
    lwzx    r9, r8, r5; /*  r9C롼Ƭɥ쥹  */         \
    mtctr   r9;         /*  CTRr9  */                                 \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EEӥåȤ򥻥å  */                \
    mtmsr   r11;                /*  ߵ  */                      \
    cmpwi   crf0, r9, 0;	/*  ߥϥɥ餬ϿƤ뤫 */ \
    beq     label##_call_no_reg_CPM_interrupt; /*  å  */         \
    bctrl;                      /*  C롼ƤӽФ  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EEӥåȤ򥯥ꥢ  */                \
    mtmsr   r11;        /*  ߶ػ  */                              \
    /*  󥵡ӥ쥸CISRγӥåȤ򥯥ꥢ  */                \
    /*      ʣ񤭹ȥꥢ  */                          \
    lwz     r4, 0(sp);  /*  ٥ֹ4ɤ߽Ф  */                 \
    addi    sp, sp, STACK_MARGIN;                                       \
    srwi    r5, r4, 2;  /*  r5r4>>2ʳֹ  */                 \
    li      r6, 1;                                                      \
    slw     r7, r6, r5; /*  r71<<(ֹ)  */                     \
    lis     r3, IMMR_UPPER_2BYTE; /* 쥸ΰƬɥ쥹 */  \
    stw     r7, TADR_CPM_CISR(r3);                                      \
label##_exit:    /*  PROC_ICUνи٥  */

/* ޥlabelμ¤Ÿ뤿ᡢޥ2ŤˤƤ */
#define PROC_ICU(label) _PROC_ICU(label)


/*
 * ߥȥΥޥIPMϢ
 *  MPC860Ǥϥƥ।󥿡ե˥åSIUγߥޥ
 *  SIUߥޥ쥸SIMASKˤΤߥͥǴ롣
 *  ̿ץå⥸塼CPMγߥޥδϤ٤ƥϡ
 *  ԤäƤ롣
 */

/*  IPM  */
#define PUSH_ICU_IPM                	\
    lis     r4, IMMR_UPPER_2BYTE;      	\
    lhz     r5, TADR_SIU_SIMASK(r4);    \
    sthu    r5, -4(sp)
    /*  ȥspι1̿Ǽ¹Ԥ  */
    /*  ¸ǡ2ХȤǤ뤬  */
    /*  sp4Хȶ˰ݻ뤿ᡢեåȤ-4ȤƤ  */

/*  IPM  */
#define POP_ICU_IPM                 			\
    lhz     r4, 0(sp);              			\
    lis     r5, IMMR_UPPER_2BYTE;   			\
    addi    sp, sp, 4;           /*  嵭  */	\
    sth     r4, TADR_SIU_SIMASK(r5) 


#ifdef SUPPORT_CHG_IPM
/*
 * ICUꤹIPMѥ᡼Υå
 *
 *C
 *  if (ipmͤ) {
 *	ercd = E_PAR;
 *	goto exit;
 *    }
 *ƱνԤޥ
 */
#define CHECK_IPM(ipm)
	/*  MPC860Ǥϲåʤ  */

/*
 * ߥȥΥޥ
 */
#define GET_IPM(p_ipm)	*(p_ipm) = sil_reh_mem((VP)SIMASK)

/*
 * ߥȥΥޥ
 */
#define CHG_IPM(ipm)	sil_wrh_mem((VP)SIMASK, ipm)

#endif	/*  SUPPORT_CHG_IPM  */


#ifndef _MACRO_ONLY

/*
 *  ߥޥѵ٥ơ֥
 *	ipm_tableΤ$(CPU)ȤΥ󥿡ե˴ޤޤʤ
 *define_ipmˤꡢäƤ
 */
extern IPM ipm_table[];

/*
 *  ߥ٥
 *	ֹinhnoγߤդȤ˳ߥȥ
 *	IPMꤹͤ롣
 *	ǥХɥ饤ФνǻѤ뤳ȤꤷƤ롣
 *
 *
 *inhnoߥϥɥֹ
 *ipmߥޥ
 *
 */
Inline void
define_ipm(INHNO inhno, IPM ipm)
{
	ipm_table[inhno] = ipm;
}

#endif /* _MACRO_ONLY */

/*  
 *  ϥ⡼ɤؤΰܹԤȳߵ
 *  ¹Ԥ٤ʤƳԤˤʤȤ
 *  ǥѥåǻѤ롣
 *
 *  ߤäƤ˳߶ػߤԤ
 *  r0r4Ƥ˲ƤϤʤʤ
 *  
 *  MCP860Ǥϥɡ⡼ɤѤ
 *  
 *  쥸
 *  r0ͣ
 *  r5쥸Ƭɥ쥹
 *  r6å0x55ccaa33
 */ 
#define SAVE_POWPER                                                 \
    lis     r5, IMMR_UPPER_2BYTE;                                   \
    LI32(r6, UNLOCK_KEY);                                           \
    stw     r6, TADR_SCCRK(r5);   /* SCCRå */              \
                                                                    \
    /* CRQEN=1CPưȤɡϥ⡼ɤ    */      \
    /* PRQEN=1׵ǥΡޥ롦ϥ⡼ɤ        */      \
    lwz     r7, TADR_SCCR(r5);                                      \
    oris    r7, r7, (SCCR_CRQEN | SCCR_PRQEN)>>16;                  \
    stw     r7, TADR_SCCR(r5);                                      \
                                                                    \
    stw     r0, TADR_SCCRK(r5);     /* SCCRå */                \
                                                                    \
    stw     r6, TADR_PLPRCRK(r5);   /* PLPRCå */           \
                                                                    \
    /* PLPRCR                                   */                  \
    /*    TMIST=0ߥ򥯥ꥢƤ   */                  \
    /*           ɡ⡼ɤʤ */                  \
    lwz     r8, TADR_PLPRCR(r5);                                    \
    ori     r8, r8, PLPRCR_TIMIST;                                  \
    xori    r8, r8, PLPRCR_TIMIST;                                  \
    stw     r8, TADR_PLPRCR(r5);                                    \
                                                                    \
    /* ɡ⡼ɤܤ뤿   */              \
    /*      CSRC=1                                */              \
    /*      LPM=01                                */              \
    ori     r8, r8, (PLPRCR_CSRC | PLPRCR_LPM);                     \
    xori    r8, r8, PLPRCR_LPM10;                                   \
    stw     r8, TADR_PLPRCR(r5);                                    \
                                                                    \
    stw     r0, TADR_PLPRCRK(r5);   /* PLPRCå */               \
                                                                    \
    /* ߵĤȥɡ⡼ɤؤΰܹ */                  \
    mfmsr   r9;                                                     \
    ori     r9, r9, MSR_EE;         /*  EEӥåȥå  */          \
    oris    r9, r9, MSR_POW>>16;    /*  POWӥåȥå  */         \
    mtmsr   r9;                                                     \
    /*  ǳߤʥɡ⡼ɤԤġ  */        \
    /*  ߤäȤr9⸵ͤˤʤäƤ  */          \
                                                                    \
    /*  ߶ػ  */                                              \
    xori    r9, r9, MSR_EE;         /*  EEӥåȥꥢ  */          \
    xoris   r9, r9, MSR_POW>>16;    /*  POWӥåȥꥢ  */         \
    mtmsr   r9


/*
 * ץơͭ㳰0x01000νƤޥ
 * 
 * ޥIMPLEMENT_EXCEPTION_01000ƤΤͭȤʤ롣
 * ƤϥץåΥץơͭΤΤʤΤǡ
 * ͥˤ줺ΥޥƤ
 * ľܸƤӽФ롣ʤĤޤꡢͥδ
 * ΤᡢνǥͥεǽƤӽФư̤
 * 롣
 * 
 * եå0x01000ʹߤ֤㳰װϣĤȤϸ¤ʤ2İʾ
 * 㳰٥֤硢եåȤλˡդ뤳ȡ
 * Ūˤ
 *     .org եå - EXCEPTION_VECTOR_BASE
 * Τ褦˻ꤹ롣ܤcpu_support.SγĽ򻲾ȡ
 * 
 */
#define MAKE_EXCEPTION_VECTOR(offset, name)	\
    .org offset - EXCEPTION_VECTOR_BASE;	\
name:;						\
  MAKE_EXCEPTION_ENTRY(offset)


#define IMPLEMENT_EXCEPTION_01000_PROC				\
software_emulation:;						\
  MAKE_EXCEPTION_ENTRY(0x1000);					\
								\
MAKE_EXCEPTION_VECTOR(0x1100, instruction_TLB_miss);		\
MAKE_EXCEPTION_VECTOR(0x1200, data_TLB_miss);			\
MAKE_EXCEPTION_VECTOR(0x1300, instruction_TLB_error);		\
MAKE_EXCEPTION_VECTOR(0x1400, data_TLB_error);			\
MAKE_EXCEPTION_VECTOR(0x1c00, data_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1d00, instruction_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1e00, peripheral_break_point);		\
MAKE_EXCEPTION_VECTOR(0x1f00, non_maskable_developement_port)


#endif /* _SYS_CONFIG_H_ */

/*  end of file  */
