/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.7 2003/12/04 08:25:44 honda Exp $
 */


#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include "c54x.h"
#include "tl16c550cfn.h"
/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO   INT1_VEC

/*
 *  ꥢI/OݡȤν
 */
#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize  uart_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = uart_openflag();

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = uart_opn_por(siopid, exinf);
      
	/*
	 * ߴϢ
	 */
	/* Enable Interrupt Rx */
	if (!openflag) {
		/* ߥե饰Υꥢ */
		sil_wrh_mem((VP) IFR,
			    (sil_reh_mem((VP) IFR) | (0x1 << INT1)));
		/* ߥޥ쥸 */
		sil_wrh_mem((VP) IMR,
			    (sil_reh_mem((VP) IMR) | (0x1 << INT1)));
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	uart_cls_por(siopcb);

	/*
	 *  ꥢI/Oߤޥ롥
	 */
	if (!uart_openflag()) {
		/*
		 *  ꥢI/Oߤޥ롥
		 */
		sil_wrh_mem((VP) IMR,
			    (sil_reh_mem((VP) IMR) & ~(0x1 << INT1)));
		sil_wrh_mem((VP) IFR,
			    (sil_reh_mem((VP) IFR) | (0x1 << INT1)));
	}
}

/*
 *  SIOγߥϥɥ
 */
#define sio_handler uart_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define sio_snd_chr uart_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   uart_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
