/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Kunihiko Ohnaka
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.12 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼
 */

#include "jsp_kernel.h"
#include <sil.h>

/*
 *  åȥƥ¸ 롼
 */

void
sys_initialize(void)
{
}

/*
 *  åȥƥνλ롼
 */

void
sys_exit(void)
{
  while (1)
  	;
}

#ifdef REDBOOT
/*
 *  RedbootѤߥ٥
 */
/*  ߥ٥  */
void
load_vector(TMP_VECTOR *p) {
	UW *redboot_trap_vector = (UW *)VECTOR_TABLE_ADDR + TRAP8;
	UW *pirq5 = (UW *)VECTOR_TABLE_ADDR + IRQ_EXT5;
	
	/* ٥ơ֥⡢trapa̿ʬ */
	memcpy(&(p->trap_vector), redboot_trap_vector, TRAP_VECTOR_SIZE*4);

	/*  IRQ5:EthernetߤƬɥ쥹  */
	p->irq5 = sil_rew_mem((VP)pirq5);		
}

/*  ߥ٥  */
void
save_vector(TMP_VECTOR *p) {
	UW *redboot_trap_vector = (UW *)VECTOR_TABLE_ADDR + TRAP8;
	UW *pirq5 = (UW *)VECTOR_TABLE_ADDR + IRQ_EXT5;
	
	/*  IRQ5:EthernetߤƬɥ쥹  */
	sil_wrw_mem((VP)pirq5, p->irq5);		

	/* ٥ơ֥⡢trapa̿ʬ */
	memcpy(redboot_trap_vector, &(p->trap_vector), TRAP_VECTOR_SIZE*4);
}

#endif	/* of #ifdef REDBOOT */

