/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/* ˤѤƤ롢MAX_IPM  cpu_config.h  */

#ifndef _MACRO_ONLY

/*
 *  쥸ؿ
 */

#include <machine.h>	/*  ϤȤ߹ߴؿ  */

/*
 *  ǥ󥳡ɥ쥸CCRˤθͤɽФ
 *UB current_ccr(void);
 *unsigned char get_ccr(void);
 */
#define current_ccr	get_ccr

/*
 *  ǥ󥳡ɥ쥸CCRˤθͤѹ
 *Ȥ߹ߴؿset_ccr()򤽤Τޤ޻Ȥ
 *void set_ccr(unsigned char ccr);
 */

/*
 *  ƥɥ쥸EXRˤθͤɽФ
 *UB current_exr(void);
 *unsigned char get_exr(void);
 */
#define current_exr	get_exr

/*
 *  ƥɥ쥸EXRˤθͤѹ
 *Ȥ߹ߴؿset_exr()򤽤Τޤ޻Ȥ
 *void set_exr(unsigned char exr);
 */

/*
 *  ߥޥ饤֥ (ߥ⡼ɣ)
 */

/*
 *  ߥޥθͤɽФ
 *IPM current_intmask(void);
 *unsigned char get_imask_exr(void);
 */
#define current_intmask		(IPM)get_imask_exr

/*
 *  ߥޥ
 *intmaskϰϥåϾάƤ롣
 */
#define set_intmask(intmask)	set_imask_exr(intmask)

/* Ѹ
 *ͥγ  ߥ٥뤬MAX_IPM ʲγ
 *ͥγ  ץ饤ƥ٥(MAX_IPM+1)
 *ʾγߤNMI
 */

/*
 *  ͥγߤػ
 *EXR쥸Υȥ졼ӥåT¸ϾάƤ롣
 */
#define disint()	set_intmask( (UB)MAX_IPM )

/*
 *  ͥγߤ
 *EXR쥸Υȥ졼ӥåT¸ϾάƤ롣
 *νϡ¾塢̵ͥͭ鷺
 *٤ƤγߤĤ뤳ȤˤʤäƤ롣
 */
#define enaint()	set_intmask( (UB)0 )

/*
 *  ߥå֤Ѵؿ
 */

/*
 *  ͥޤƤ٤Ƥγߤػ (NMI)
 *EXR쥸Υȥ졼ӥåT¸ϾάƤ롣
 */
#define _disint_()	set_exr( EXR_I_MASK )


#endif /* _MACRO_ONLY */

#endif /* _CPU_INSN_H_ */
