/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _H8S_TPU_H_
#define _H8S_TPU_H_

#include <s_services.h>		/* ǥХɥ饤ɸ।󥯥롼ɥե */
#include <h8s_sil.h>

/*
 *  H8S¢16ӥåȥޥѥ륹˥å(TPU)Ϣ
 */

/* TPU쥸Υɥ쥹 */

/* ͥ룰 */
#define TCR0		0xffd0		/* ޥȥ쥸 */
#define TMDR0		0xffd1		/* ޥ⡼ɥ쥸 */
#define TIOR0H		0xffd2		/* I/Oȥ쥸 */
#define TIOR0L		0xffd3		/* I/Oȥ쥸 */
#define TIER0		0xffd4		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR0		0xffd5		/* ޥơ쥸 */
#define TCNT0		0xffd6		/* ޥ󥿣 */
#define TGR0A		0xffd8		/* ޥͥ쥸 */
#define TGR0B		0xffda		/* ޥͥ쥸 */
#define TGR0C		0xffdc		/* ޥͥ쥸 */
#define TGR0D		0xffde		/* ޥͥ쥸 */

/* ͥ룱 */
#define TCR1		0xffe0		/* ޥȥ쥸 */
#define TMDR1		0xffe1		/* ޥ⡼ɥ쥸 */
#define TIOR1		0xffe2		/* I/Oȥ쥸 */
#define TIER1		0xffe4		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR1		0xffe5		/* ޥơ쥸 */
#define TCNT1		0xffe6		/* ޥ󥿣 */
#define TGR1A		0xffe8		/* ޥͥ쥸 */
#define TGR1B		0xffea		/* ޥͥ쥸 */

/* ͥ룲 */
#define TCR2		0xfff0		/* ޥȥ쥸 */
#define TMDR2		0xfff1		/* ޥ⡼ɥ쥸 */
#define TIOR2		0xfff2		/* I/Oȥ쥸 */
#define TIER2		0xfff4		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR2		0xfff5		/* ޥơ쥸 */
#define TCNT2		0xfff6		/* ޥ󥿣 */
#define TGR2A		0xfff8		/* ޥͥ쥸 */
#define TGR2B		0xfffa		/* ޥͥ쥸 */

/* ͥ룳 */
#define TCR3		0xfe80		/* ޥȥ쥸 */
#define TMDR3		0xfe81		/* ޥ⡼ɥ쥸 */
#define TIOR3H		0xfe82		/* I/Oȥ쥸 */
#define TIOR3L		0xfe83		/* I/Oȥ쥸 */
#define TIER3		0xfe84		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR3		0xfe85		/* ޥơ쥸 */
#define TCNT3		0xfe86		/* ޥ󥿣 */
#define TGR3A		0xfe88		/* ޥͥ쥸 */
#define TGR3B		0xfe8a		/* ޥͥ쥸 */
#define TGR3C		0xfe8c		/* ޥͥ쥸 */
#define TGR3D		0xfe8e		/* ޥͥ쥸 */

/* ͥ룴 */
#define TCR4		0xfe90		/* ޥȥ쥸 */
#define TMDR4		0xfe91		/* ޥ⡼ɥ쥸 */
#define TIOR4		0xfe92		/* I/Oȥ쥸 */
#define TIER4		0xfe94		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR4		0xfe95		/* ޥơ쥸 */
#define TCNT4		0xfe96		/* ޥ󥿣 */
#define TGR4A		0xfe98		/* ޥͥ쥸 */
#define TGR4B		0xfe9a		/* ޥͥ쥸 */

/* ͥ룵 */
#define TCR5		0xfea0		/* ޥȥ쥸 */
#define TMDR5		0xfea1		/* ޥ⡼ɥ쥸 */
#define TIOR5		0xfea2		/* I/Oȥ쥸 */
#define TIER5		0xfea4		/* ޥ󥿥ץȥ֥͡쥸 */
#define TSR5		0xfea5		/* ޥơ쥸 */
#define TCNT		0xfea6		/* ޥ󥿣 */
#define TGR5A		0xfea8		/* ޥͥ쥸 */
#define TGR5B		0xfeaa		/* ޥͥ쥸 */

/*  */
#define TSTR		0xffc0		/* ޥơȥ쥸 */
#define TSYR		0xffc1		/* ޥ󥯥쥸 */

/* ƥ쥸Υӥåȥѥ */

/* TCR */
#define CCLR2		BIT7		/* ͥ룰Τ */
#define CCLR1		BIT6
#define CCLR0		BIT5
#define CKEG1		BIT4
#define CKEG0		BIT3
#define TPSC2		BIT2
#define TPSC1		BIT1
#define TPSC0		BIT0

/* TMDR */
#define BFB		BIT5		/* ͥ룰Τ */
#define BFA		BIT4		/* ͥ룰Τ */
#define MD3		BIT3
#define MD2		BIT2
#define MD1		BIT1
#define MD0		BIT0

/* TIOR */
/* TIORxޤϡTIORxH */
#define IOB3		BIT7
#define IOB2		BIT6
#define IOB1		BIT5
#define IOB0		BIT4
#define IOA3		BIT3
#define IOA2		BIT2
#define IOA1		BIT1
#define IOA0		BIT0

/* TIORxL */
#define IOD3		BIT7
#define IOD2		BIT6
#define IOD1		BIT5
#define IOD0		BIT4
#define IOC3		BIT3
#define IOC2		BIT2
#define IOC1		BIT1
#define IOC0		BIT0

/* TIER */
#define TTGE		BIT7
#define TCIEU		BIT5		/* ͥ룱Τ */
#define TCIEV		BIT4
#define TGIED		BIT3		/* ͥ룰Τ */
#define TGIEC		BIT2		/* ͥ룰Τ */
#define TGIEB		BIT1
#define TGIEA		BIT0

/* TSR */
#define TCFD		BIT7
#define TCFU		BIT5		/* ͥ룱Τ */
#define TCFV		BIT4
#define TGFD		BIT3		/* ͥ룰Τ */
#define TGFC		BIT2		/* ͥ룰Τ */
#define TGFB		BIT1
#define TGFA		BIT0

/* TCNT, TGR */
/* ٤Τϡä̵ */

/* TSTR */
#define CST5		BIT5
#define CST4		BIT4
#define CST3		BIT3
#define CST2		BIT2
#define CST1		BIT1
#define CST0		BIT0

/* TSYR */
#define SYNC5		BIT5
#define SYNC4		BIT4
#define SYNC3		BIT3
#define SYNC2		BIT2
#define SYNC1		BIT1
#define SYNC0		BIT0

#endif /* _H8S_TPU_H_ */
