/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.2 2007/05/30 08:38:51 honda Exp $
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СM32102¢Ʊꥢѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <sil.h>
#include <s_services.h>

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND    1u              /* ǽХå */
#define SIO_ERDY_RCV    2u              /* ΥХå */

/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define INHNO_SERIAL_IN		(48 + ((CONSOLE_PORTID-1)*2))
#define INHNO_SERIAL_OUT	(49 + ((CONSOLE_PORTID-1)*2))

#define SIO_TYP(x)				( (x) & 0x000000ff )
#define SIO_TYP_M32RUART	0x00000001

#define SIO_STS(x)				( (x) & 0xffff0000 )
#define SIO_STS_SENDING		0x80000000

typedef struct
{
	int		flags;
	int		port;
	VP_INT	exinf;
} SIOPCB;

//extern SIOPCB siopcb_table[TNUM_PORT];

extern void sio_handler_in(void);
extern void sio_handler_out(void);

/*
 *  ꥢݡȤν
 */
extern void sio_initialize(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB * sio_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void sio_cls_por(SIOPCB *siopcb);

/*
 *  ʸ
 */
Inline BOOL
sio_snd_chr(SIOPCB * siopcb, INT chr)
{
	if((siopcb->flags & SIO_STS_SENDING) != 0)
		return FALSE;

	switch(SIO_TYP(siopcb->flags))
	{
	case SIO_TYP_M32RUART:	
		if((sil_reb_mem((void *)(SIOSTS(siopcb->port)+3)) & 0x3) != 0)
		{
			siopcb->flags |= SIO_STS_SENDING;
			sil_wrb_mem((void *)(SIOTXB(siopcb->port)+3), (char)chr);
		} else
			return FALSE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


/*
 *  ꥢI/OݡȤؤʸ
 */
extern INT	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  SIOγߥӥ롼
 */
extern void	sio_isr(void);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sio_ena_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sio_dis_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤؤʸλХå
 */
extern void sio_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤؤʸλХå
 */
extern void sio_ierdy_rcv(VP_INT exinf);

/*
 *  ꥢI/OݡȤʸΥХå
 */
extern void	sio_ercv_chr(ID siopid, INT chr);

#endif /* _HW_SERIAL_H_ */
