/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.2 2007/05/28 02:03:55 honda Exp $
 */

/*
 *  åȥƥ¸⥸塼 ֥m3a_za36ѡ
 */

#define	_MACRO_ONLY

#include <m32rasm.inc>

/*
 *  ѤSFR
 */
#define BSEL0CR		0x00ef5000	/* BSEL0쥸 */
#define SDRF0		0x00ef6000	/* SDRAMեå쥸0 */
#define SDRF1		0x00ef6004	/* SDRAMեå쥸1 */
#define SDIR0		0x00ef6008	/* SDRAM쥸0 */
#define SDIR1		0x00ef600c	/* SDRAM쥸1 */
#define SD0ADR		0x00ef6020	/* SDRAM0ɥ쥹쥸 */
#define SD0ER		0x00ef6024	/* SDRAM0֥͡쥸 */
#define SD0TR		0x00ef6028	/* SDRAM0ߥ󥰥쥸 */
#define SD0MOD		0x00ef602c	/* SDRAM0⡼ɥ쥸 */
#define SD1ADR		0x00ef6040	/* SDRAM1ɥ쥹쥸 */
#define SD1ER		0x00ef6044	/* SDRAM1֥͡쥸 */
#define SD1TR		0x00ef6048	/* SDRAM1ߥ󥰥쥸 */
#define SD1MOD		0x00ef604c	/* SDRAM1⡼ɥ쥸 */
#define MCCR		0xfffffffc	/* å쥸 */
#define ICUIMASK	0x00eff01c	/* ߥޥ쥸	*/

/*
 *	SDRAMޥ
 */
#define SDRF1_VAL	0x00010017	/* SDRAMեå쥸1	*/
#define	SDIR0_VAL	0x00000001	/* SDRAM쥸0			*/
#define	SD0ADR_VAL	0x04000004	/* SDRAM0ɥ쥹쥸			*/
#define SD0TR_VAL	0x00020102	/* SDRAM0ߥ󥰥쥸		*/
#define SD0MOD_VAL	0x00000020	/* SDRAM0⡼ɥ쥸			*/

/*
 *	֥å쥯ȥȥ
 */
#define BSEL0CR_VAL	0x01011100

/*
 *  ϡɥ
 *
 *  databssSDRAMΰ֤ˤϡǥХå¦
 *  SDRAM롥ξϡhardware_init_hookǤϲ⤷ʤ
 */
#if 0
Function hardware_init_hook

	/*
	 * ֥å쥯ȥȥ
	 */
	mLdadr	r2, BSEL0CR_VAL
	ld24	r3, #BSEL0CR
	st		r2, @r3

	/*
	 *  å⡼ɤ
	 */
	ldi	r0, #0x00   /* åOFF */
	ldi	r2, #MCCR	/* ĥƥɥ쥹 */
	st	r0, @r2		/* ̿/ǡå⡼ */

	/*
	 *  SDRAM 
	 */
	/* --- SDRAM -- */
	ld24	r2, #SDIR0		/* SDRAM쥸0 */
	mLdadr	r3, SDIR0_VAL	/* ץ㡼奦(DPC)       3BCLK	*/
							/* ȥեå(DARFC)     8		*/
							/* ȥեå׵ֳ(DARFI) 8BCLK	*/
	st		r3, @r2		/* 	*/

	ld24	r2, #SDIR1			/* H'00EF600c	*/
	ldi		r3, #0x00000001		/* 	*/
	st		r3, @r2

	/* --- SDRAM󥹴λԤ -- */
wait_sdram:
	ldh		r3, @r2
	bnez	r3, wait_sdram		/* λ */

	/* -- SDRAM⡼ɥ쥸åȥޥȯ */
	ld24	r2, #SD0MOD			/* SDRAM0⡼ɥ쥸					*/
	mLdadr	r3, SD0MOD_VAL			/* Сȥ⡼						*/
								/* CL=2									*/
								/* Сȥס󥷥		*/
								/* СĹ							*/
	st		r3, @r2				/* 	*/

	/* ---- SDRAMߥ󥰥쥸 -- */
	ld24	r2, #SD0TR			/* SDRAMߥ󥰥쥸							*/
	mLdadr	r3, SD0TR_VAL		/* RASƥִ(DRAS)             3BCLK		*/
								/* RAS-CAS졼ƥ(DRCD)             1BCLK		*/
								/* RASץ㡼(DPCG)               1BCLK		*/
								/* 饤ȥꥫХ(DWR)             2BCLK		*/
								/* SDRAMȥCAS졼ƥ(DCL) 2BCLK		*/
	st      r3, @r2			/* 	*/

	/* --- SDRAMΰ(H'0400000032MХ,32bitBUS)	*/
	ld24	r2, #SD0ADR		/* SDRAM0ɥ쥹쥸							*/
	mLdadr	r3, SD0ADR_VAL		/* Ƭɥ쥹(DADR)         H'0400 xxxx			*/
								/* ǡХ(DBSZ)     32ӥå				*/
								/* ͥ륵(DSZ)    64MХ				*/
	st		r3, @r2			/* 	*/

	/* ---- ȥեåͭ׵ֳ:1344å	*/
	ld24	r2, #SDRF1		/* SDRAMեå쥸1					*/
	mLdadr	r3, SDRF1_VAL		/* ȥեå(DRFEN)	1(ͭ			*/
								/* ȥեå奦(DREFW) 8BCLK			*/
								/* ȥեå׵ֳ(DRFC)  1344BCLK		*/
	st		r3, @r2

	/* SDRAMͭ */
	ld24	r2, #SD0ER			/* SDRAM֥͡쥸	*/
	ldi		r3, #0x01			/* ͤ쥸˳Ǽ			*/
	st		r3, @r2
	rts
#endif
		
Function software_init_hook
	ld24 	r0, ICUIMASK + 1
	ldi 	r1, 7
	stb 	r1, @r0 			/* ߥޥĤ */
	rts
