/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#ifndef _MACRO_ONLY

/*  ƥȥ֥å  */
typedef struct task_context_block {
        VP	sp;             /* åݥ */
        FP	pc;             /* ץ५ */
} CTXB;

#endif /* _MACRO_ONLY */

/*  TCB ΥեɤΥӥå  */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */

/*
 *  ƥֻ
 */

#ifndef _MACRO_ONLY

/*
 *  ƥȻ
 *    ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢äȤˤ
 *    ƥȤ⸵äƤ롣
 */
Inline BOOL sense_context() {

	UW intnest;

	Asm("move %0, "str_k0 :"=r"(intnest));

	return(intnest > 0);
}

Inline BOOL sense_lock() {

	return(!(current_sr() & SR_IE));
}

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *    CPUå֤ȽǤϡơ쥸IEӥåȤѤȽǤƤ롣
 */

#ifndef _MACRO_ONLY

Inline void t_lock_cpu() {

	disint();		/* cpu_insn.h */
}

Inline void t_unlock_cpu() {

	enaint();		/* cpu_insn.h */
}

#endif /* _MACRO_ONLY */

/*
 *  CPUåȤβ󥿥ƥѡ
 */

#define i_lock_cpu	t_lock_cpu
#define i_unlock_cpu	t_unlock_cpu

/*
 *  ǥѥå
 */

#ifndef _MACRO_ONLY

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *    dispatch ϡƥȤƤӽФ줿ӥǡ
 *    CPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *    exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*  ߥϥɥ顿ߥޥơ֥  */
extern INT_TABLE int_table[ TMAX_ALL_INTNO ];

/*  㳰ϥɥ鵼ơ֥  */
extern FP	 exc_table[ TMAX_CORE_EXCNO ];

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ(װֹ)intno γߥϥɥεưϤinthdrꡣ
 */

Inline void define_inh(INTNO intno, FP inthdr) {

	int_table[intno].inthdr = inthdr;
}

/*
 *   CPU㳰ϥɥ
 */

Inline void define_exc(EXCNO excno, FP exchdr) {

	exc_table[excno] = exchdr;
}

#endif /* _MACRO_ONLY */

/*
 *  ߥϥɥνޥ
 */

#define	INTHDR_ENTRY(inthdr)  extern void inthdr(void)
#define INT_ENTRY(inthdr) inthdr

/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define	EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)
#define	EXC_ENTRY(exchdr)     exchdr

/*
 *  CPU㳰ȯΥƥ֤λ
 */

#ifndef _MACRO_ONLY

/*
 *  CPU㳰ȯΥƥȽ
 */
Inline BOOL exc_sense_context(VP p_excinf) {

	UW  nest;

	Asm( "move %0, "str_k0 : "=r"(nest) );

	return( nest > 1 );
		/* 1ӤΤϡ߼¹CPU㳰ʬߥͥ
		   󥿤󥯥ȤƤ뤿 */
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL exc_sense_lock(VP p_excinf) {

	/* Status쥸ϡå22ܤѤޤƤ롣
	   exc_stack(mips3.h), cpu_support.S  */
	return( !( *((UW *)p_excinf + 21) & SR_IE) );
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*  ץåܳߥȥꤹߥޥΥå  */
#define CHECK_IPM(ipm)	     CHECK_CORE_IPM( (ipm.core >> 8) & 0xff );	\
			     CHECK_ICU_IPM( ipm.icu )

#ifndef _MACRO_ONLY

/*
 *  ߥ٥ʶϸƤӽФʤ
 */

Inline void all_set_ilv(INTNO intno, IPM *ipm) {

	/*  MIPS intmask ơ֥  */
	int_table[intno].intmask = SR_BEV | (ipm->core) | SR_IE;
			/* ߥ٥kseg1˻äƤ뤿ᡢBEV=1 */

	/*  ߥȥγߥޥơ֥  */
	/*  ʳߥ٥  */
	icu_set_ilv( intno, &(ipm->icu) );
}

#endif /* _MACRO_ONLY */

/*
 *  Ѥδؿ
 */

#ifndef _MACRO_ONLY

/* ϿƤʤߡ㳰ȯΥ (cpu_config.c, cpu_support.S) */
extern void     cpu_experr( EXCSTACK *sp, UW SR, UW CR );

#endif /* _MACRO_ONLY */

#endif /* _CPU_CONFIG_H_ */
