/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *   ޥɥ饤СVR4131¢RTCTClockѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <vr4131_rtc.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	INTNO_TCLK

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UH		CLOCK;

#endif /* _MACRO_ONLY */

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCKϡܡɴطΥإåե˵ܤƤ롣
 */
/* 1ߥü(isig_tim ƤӽФ;1kHz)ȯ뤿Υȿ */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
/* clock  usec ñ̤Ѵޥ */
#define	TO_USEC(clock)		((clock) * 1000u / TIMER_CLOCK)

/*
 *  ޼ñ̤ɽѴ
 *  (Ѥ륿ޤ󥫥󥿤ʤΤǡΥޥ)
 */
#define CLOCK_PER_TICK		((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK		((CLOCK) 0x1ffffff)	/*  25ӥå  */

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE		100u	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ߤޤǤλ֡nsecñ̡
 *  ͤ˺Ϥʤ
 */
#define	TIMER_STOP_DELAY	200u

#ifndef _MACRO_ONLY
/*
 *  ޳׵Υꥢ
 */
Inline void hw_timer_int_clear() {

	vr4131_wrh_mem( (VP) RTCINTREG, RTCINTR3 );
}

/*
 *  ޤεư
 *    ޤŪʥ޳׵ȯ롥
 */
Inline void hw_timer_initialize() {

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert( CLOCK_PER_TICK <= MAX_CLOCK );

	vr4131_wrh_mem( (VP) TCLKLREG, (UH) LO16(CLOCK_PER_TICK) );
	vr4131_wrh_mem( (VP) TCLKHREG, (UH) HI16(CLOCK_PER_TICK) );

	/*
	 *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	all_set_ilv( INHNO_TIMER, &((IPM) IPM_TIMER) );	/* ߥ٥ */

	hw_timer_int_clear();				/* ׵򥯥ꥢ */

	/* ޥ(٥룱٥룲쥸̵) */
	vr4131_orh( (VP) MSYSINT2REG, TCLKINTR );
}

/*
 *  ޤ߽
 *  ޤưߤ롥
 */
Inline void hw_timer_terminate() {

	/*  ޤưߤ  */
	vr4131_wrh_mem( (VP) TCLKLREG, 0 );
	vr4131_wrh_mem( (VP) TCLKHREG, 0 );

	/*
	 *  ޳ߤޥ׵򥯥ꥢ롥
	 */
	/* ޥ(٥룱٥룲쥸̵) */
	vr4131_andh( (VP) MSYSINT2REG, ~TCLKINTR );

	hw_timer_int_clear();				/* ׵򥯥ꥢ */
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK hw_timer_get_current() {

	UH 	count;
	UH	hi1, lo1, hi2, lo2;

	/* ͤɤ߽Ф */
	/* 2ɤ߽ФƤͳϡϡɥp261 */
	lo1 = vr4131_reh_mem( (VP) TCLKCNTLREG );
	hi1 = vr4131_reh_mem( (VP) TCLKCNTHREG );

	lo2 = vr4131_reh_mem( (VP) TCLKCNTLREG );
	hi2 = vr4131_reh_mem( (VP) TCLKCNTHREG );

	if( hi2 == hi1 )
		count = JOIN16( hi1, lo1 );
	else
		count = JOIN16( hi2, lo2 );

	return (CLOCK_PER_TICK - count);
}

/*
 *  ޳׵Υå
 */
Inline BOOL hw_timer_fetch_interrupt() {

	return( ( vr4131_reh_mem( (VP) RTCINTREG ) & RTCINTR3 ) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
