/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ץåü̿Υ饤ؿPowerPCѡ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  쥸ؿ
 */

/*
 *  ޥ󥹥ơ쥸MSRˤθͤɽФ
 */
Inline UW
current_msr(void)
{
	UW msr;
	Asm("mfmsr %0" : "=r"(msr));
	return(msr);
}


/*
 *  ޥ󥹥ơ쥸MSRˤθͤѹ
 */
Inline void
set_msr(UW msr)
{
	Asm("mtmsr %0" : : "r"(msr) );
}


/*
 *  NMI٤Ƥγߤػ
 */
Inline void
disint(void)
{
#if !defined(IBM_PPC_EMB_ENV)
	/*  
	 *   ꥸʥPowerPCƥξ
	 *   ȥMPC꡼IPM PowerPC6xx/7xx꡼
	 *   ˳롣
	 */   
	UW msr;
	
	msr = current_msr();
	msr |= MSR_EE;
	msr ^= MSR_EE;
	set_msr(msr);

#else	/*  IBM_PPC_EMB_ENV  */
	/*  
	 *   The IBM PowerPC Embedded Environmentξ
	 *   IBMPowerPC40x꡼б
	 *   wrteei̿ľEEӥåȤ򥯥ꥢǤ롣
	 */   
	Asm("wrteei 0" : );	/*  MSR.EE0  */

#endif	/*  IBM_PPC_EMB_ENV  */
}


/*
 *  ߤ
 */
Inline void
enaint()
{
#if !defined(IBM_PPC_EMB_ENV)
	/*  
	 *   ꥸʥPowerPCƥξ
	 *   ȥMPC꡼IPM PowerPC6xx/7xx꡼
	 *   ˳롣
	 */   
	UW msr;
	
	msr = current_msr();
	msr |= MSR_EE;
	set_msr(msr);

#else	/*  IBM_PPC_EMB_ENV  */
	/*  
	 *   The IBM PowerPC Embedded Environmentξ
	 *   IBMPowerPC40x꡼б
	 *   wrteei̿ľEEӥåȤ򥻥åȤǤ롣
	 */   
	Asm("wrteei 1" : );	/*  MSR.EE1  */

#endif	/*  IBM_PPC_EMB_ENV  */
}


/*
 *  ڥ롦ѡѥ쥸SPRˤθͤɽФ
 *     no :쥸ֹ
 *     dst:ɤ߽ФͤǼѿ
 */

#define _current_spr(no, dst)	Asm("mfspr %0," #no : "=r"(dst))
#define current_spr(no, dst)	_current_spr(no, dst)


/*
 *  ڥ롦ѡѥ쥸SPRˤθͤѹ
 *     no :쥸ֹ
 *     src:ꤹ
 */
#define set_spr(no, src)	_set_spr(no, src)
#define _set_spr(no, src)	Asm("mtspr "#no", %1" : : "r"(src) )

/*
 *  SPRG0θͤɽФ
 */
Inline UW
current_sprg0()
{
    UW sprg0;
    
    current_spr(SPRG0, sprg0);	/*  sprg0  SPRG0  */
    return(sprg0);
}



/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *¸ѰդؿѤΤ
 *CPU_BITMAP_SEARCHޥʤ
 */


#endif /* _CPU_INSN_H_ */
/*  end of file  */
