/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: pit.h,v 1.1 2004/09/03 16:39:56 honda Exp $
 */

/*
 *	ޥɥ饤ФΥץ
 */

#ifndef _PIT_H_
#define _PIT_H_

/*  ܡSILѰդ  */
//#include <sil_mpc860.h>


/*
 *  ͤɽη
 */
typedef UH	CLOCK;

/*
 *	ޤ˶뤵륯åȿ[kHz]
 */

#define TIMER_CLOCK	12500

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *TIMER_CLOCKtb6102s.hƤ
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) (TO_CLOCK(TIC_NUME, TIC_DENO) - 1))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffffu)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ȥ쥸
 */


#ifndef _MACRO_ONLY

/*
 *  ޥ
 */
Inline void
pit_start()
{
}

/*
 *  ް
 */
Inline void
pit_stop()
{
}

/*
 *  ޳׵Υꥢ
 *          PISCR쥸PSӥåȤ1񤭹
 */
Inline void
pit_int_clear()
{
}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
pit_initialize()
{
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
pit_terminate()
{
}

/*
 *  ޤθͤɽФ
 *߶ػ߶ǸƤӽФ
 */
Inline CLOCK
pit_get_current()
{
	return ((CLOCK)0);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
pit_fetch_interrupt()
{
	return (TRUE);
}

#endif /* _MACRO_ONLY */
#endif /* _PIT_H_ */
/*  end of file  */
