/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼Υץ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  桼
 */
#include <user_config.h>

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  åȥƥΥϡɥ񸻤
 */
//#include <******.h>
//#include <******.h>


/*
 *  ưåΥåȥƥ̾
 */
#define	TARGET_NAME	"Target name"

/*
 *  ԤΤ
 */
#define	SIL_DLY_TIM1	1425
#define	SIL_DLY_TIM2	 350

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 *ROM˥GDB STUBƽФ̤
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 *ROM˥GDB STUBƽФ̤
 */
extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*  --------------------------------------------------------------  */
/*
 * PowerPCȤΥ󥿡ե
 */

/*
 *   MSRν
 */
#define INIT_MSR    	0

/*
 *  ߤܿ
 */
#define TMAX_INTNO       10

/*
 *  ߽ICU¸ʬ
 *  
 *  װȽ
 *  ߥޥ
 *  ߵ
 *  C롼ƤӽФ
 *  ߶ػ
 *  ɬפǤС˳׵ե饰Υꥢ
 *  
 *  
 *    label٥뼱ʸ
 *    ʣսǤΥޥѤǤ褦ˤ뤿
 */
#define _PROC_ICU(label)

/* ޥlabelμ¤Ÿ뤿ᡢޥ2ŤˤƤ */
#define PROC_ICU(label) _PROC_ICU(label)


/*
 * ߥȥΥޥIPMϢ
 */

/*  IPM  */
    /*  աsp4Хȶ˰ݻ  */
#define PUSH_ICU_IPM

/*  IPM  */
    /*  աsp4Хȶ˰ݻ  */
#define POP_ICU_IPM


#ifdef SUPPORT_CHG_IPM
/*
 * ICUꤹIPMѥ᡼Υå
 *
 *C
 *  if (ipmͤ) {
 *	ercd = E_PAR;
 *	goto exit;
 *    }
 *ƱνԤޥ
 */
#define CHECK_IPM(ipm)

/*
 * ߥȥΥޥ
 */
#define GET_IPM(p_ipm)	

/*
 * ߥȥΥޥ
 */
#define CHG_IPM(ipm)

#endif	/*  SUPPORT_CHG_IPM  */


#ifndef _MACRO_ONLY

/*
 *  ߥޥѵ٥ơ֥
 *	ipm_tableΤ$(CPU)ȤΥ󥿡ե˴ޤޤʤ
 *define_ipmˤꡢäƤ
 */
extern IPM ipm_table[];

/*
 *  ߥ٥
 *	ֹinhnoγߤդȤ˳ߥȥ
 *	IPMꤹͤ롣
 *	ǥХɥ饤ФνǻѤ뤳ȤꤷƤ롣
 *
 *
 *inhnoߥϥɥֹ
 *ipmߥޥ
 *
 */
Inline void
define_ipm(INHNO inhno, IPM ipm)
{
	ipm_table[inhno] = ipm;
}

#endif /* _MACRO_ONLY */

/*  
 *  ϥ⡼ɤؤΰܹԤȳߵ
 *  ¹Ԥ٤ʤƳԤˤʤȤ
 *  ǥѥåǻѤ롣
 */ 
#define SAVE_POWPER	/*  Ƥ򥢥֥ǵҤ  */


/* ----------------------------------------------------------------- */
/*
 * The IBM PowerPC Embedded EnvironmentѤ
 */

/*
 * 㳰롼ɬʬ
 */

/*
 *  Critical Interrupt
 *  եåȡ0x100
 *  Critical Interruptϥץơ¸ʤΤ
 *  ƤϥޥƤ
 *  ޥ̾CRITICAL_INTERRUPT_EXCEPTION_PROC
 *  νƤ0x100ХȤĶƤϤʤ
 *  ĶϻĤʬ̤ξ֤ơ
 *  ʬ뤳ȡ
 *
 *  Critical Interruptϥͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 */
#define CRITICAL_INTERRUPT_EXCEPTION_PROC	rfci
				/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */


/*
 *  ޥ󡦥å㳰
 *  νƤ0x100ХȤĶƤϤʤ
 *  ĶϻĤʬ̤ξ֤ơ
 *  ʬ뤳ȡ
 *
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 */
#define MACHINE_CHECK_PROC	rfci
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  Programmable Interval timer
 *  եåȡ0x1000
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
#define PROGRAMMABLE_INTERVAL_TIMER_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  Fixed Interval timer
 *  եåȡ0x1010
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
#define FIXED_INTERVAL_TIMER_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  Watchdog timer
 *  եåȡ0x1020
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 *
 *  0x10ХȤΰ褬ƤƤʤΤ
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 */
#define WATCHDOG_TIMER_PROC	rfci
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  Data TLB miss
 *  եåȡ0x1100
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
#define DATA_TLB_MISS_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  Instruction TLB miss
 *  եåȡ0x1200
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
#define INSTRUCTION_TLB_MISS_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */


/*
 *  Debug㳰
 *  եåȡ0x2000
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 *  
 *  װϰʲ7
 *  Trap
 *  Instruction address compare
 *  Data address compare
 *  Instruction complete
 *  Branch taken
 *  Exception
 *  Unconditional debug event
 *  
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *  
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
#define DEBUG_PROC	rfci
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 *  ץơѤνʥեåȡ0xd00-0xff0
 *    ץơͭ㳰٥
 *  եåȤλˡդ뤳ȡ
 *  Ūˤ
 *     .org եå - EXCEPTION_VECTOR_BASE
 *  Τ褦˻ꤹ롣ܤ¾㳰װγĽ򻲾ȡ
 *    㤨СPowerPC405Ǥϥեå0xf20
 *    APU Unavailable㳰ν֤
 */
//#define IMPLEMENT_EXCEPTION_D00_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */

/*
 * 㳰롼ʥץʬ
 */
/*
 *  ץơѤνʥեåȡ0x2010-0x2ff0
 *    ץơͭ㳰٥ʣĤȤϸ¤ʤˤ
 *    ¾Ӥ˻Ѥ
 *  եåȤλˡդ뤳ȡ
 *  Ūˤ
 *     .org եå - EXCEPTION_VECTOR_BASE
 *  Τ褦˻ꤹ롣ܤ¾㳰װγĽ򻲾ȡ
 */
// #define IMPLEMENT_EXCEPTION_02010_PROC
						/*  ֥ǵҤ  */
/*  ΥޥϥǥХ˹碌ƳƼ񤭴Ʋ  */


#endif /* _SYS_CONFIG_H_ */

/*  end of file  */
