/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *   SH1¢ꥢ륳ߥ˥󥤥󥿥եSCI ʰץɥ饤
 *
 *SCI0/1ݡ
 *
 *sh1sci.{c,h}hw_serial.hʬδ
 *sh1sci.{c,h}ꥢǥХ˰¸ʬΤߵ
 *hw_serial.hꥢǥХʳ˵
 * hw_serial.h˵Ҥ
 *ߥȥ¸ʤ
 */

#ifndef _SH1SCI2_H_
#define _SH1SCI2_H_

#include <t_services.h>
#include <sh1_sil.h>

/*
 *  ꥢݡȥ󥿡ե
 */
#define	PORT1			1
#define	PORT2			2

#define RS232C_INTERFACE	0	/* RS232C I/Fξ硢 */
#define RS485_INTERFACE		1	/* RS485 I/Fξ硢 */

/*
 *  ꥢݡȤν֥å
 */
typedef struct sio_port_initialization_block {
	UW 	base;		/* SCI Υ١ɥ쥹		*/
	UW	baudrate;	/* ܡ쥤			*/	
	VH  	*ipr;		/* ߥȥ饢ɥ쥹 */
	UH	shift;		/* ߥȥ饷ե	*/
	UB	smr_init;	/* SMR 			*/
	UINT	delay;		/* ܡ졼ȤԤ	*/
	UB	rs485if;	/* RS232C | RS485		*/
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 *  2ch˳ĥ
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*inib;		/* ѤΥǡ 	*/
	VP_INT		exinf;		/* ĥ 		*/
	BOOL		openflag;	/* ץѤߥե饰 	*/
} SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void	sh1sci_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	sh1sci_openflag(ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*sh1sci_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	sh1sci_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	sh1sci_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	sh1sci_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	sh1sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	sh1sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	sh1sci_isr_in(void);
extern void	sh1sci_isr_out(void);

/*
 *  SIOμ顼ߥӥ롼
 */
extern void	sh1sci_isr_error(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	sh1sci_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	sh1sci_ierdy_rcv(VP_INT exinf);



#endif /* _SH1SCI2_H_ */
