/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.6 2003/12/04 08:25:44 honda Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include "c54x.h"

#define INHNO_TIMER TINT0_VEC

#ifndef _MACRO_ONLY

#define TO_CLOCK(nume,deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

#define MAX_CLOCK ((CLOCK) 0xffff)

#define GET_TOLERANCE 100

#define BEFORE_IREQ(clock) \
  ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


typedef UH CLOCK;

Inline void
hw_timer_initialize()
{
	CLOCK	c = TO_CLOCK(TIC_NUME,TIC_DENO);

	/* 0.25 secǥȤ */
	sil_wrh_mem((VP) TMU0_TCR, TCR_TSS | 0x0009);
//	sil_wrh_mem((VP) TMU0_TCR, TCR_TSS | 0x0001);
	/* 󥿤 */
	sil_wrh_mem((VP) TMU0_PRD, c - 1);
	/* 󥫥󥿤ν */
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) | TCR_TRB));
	/* ޤεư */
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) & ~TCR_TSS));

	sil_wrh_mem((VP) IFR, (sil_reh_mem((VP) IFR) | (0x1 << TINT0)));
	sil_wrh_mem((VP) IMR, (sil_reh_mem((VP) IMR) | (0x1 << TINT0)));
}

Inline void
hw_timer_int_clear()
{
}

Inline void
hw_timer_terminate()
{
	sil_wrh_mem((VP) TMU0_TCR, (sil_reh_mem((VP) TMU0_TCR) | TCR_TSS));
	sil_wrh_mem((VP) IMR, (sil_reh_mem((VP) IMR) & ~(0x1 << TINT0)));
	sil_wrh_mem((VP) IFR, (sil_reh_mem((VP) IFR) | (0x1 << TINT0)));
}

Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME,TIC_DENO) - sil_reh_mem((VP) TMU0_TIM));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP) IFR) & (0x1 << TINT0));
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
