
/****************************************************************************************************//**
 * @file     LPC18xx.h
 *
 * @status   RELEASE
 *
 * @brief    CMSIS Cortex-M3 Core Peripheral Access Layer Header File for
 *           default LPC18xx Device Series
 *
 * @version  V19
 * @date     9. December 2011
 * 
 * @note     Generated with SVDConv V2.6 Build 6c  on Friday, 09.12.2011 13:49:19
 *
 *           from CMSIS SVD File 'LPC18xxv19.xml' Version 19,
 *           created on Friday, 09.12.2011 21:49:13, last modified on Friday, 09.12.2011 21:49:13
 *
 *******************************************************************************************************/



/** @addtogroup Template
  * @{
  */

#ifndef __LPC18XX_H__
#define __LPC18XX_H__

#ifdef __cplusplus
extern "C" {
#endif



/********************************************
** Start of section using anonymous unions **
*********************************************/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma push
  #pragma language=extended
#else
  #error Not supported compiler type
#endif


 /* Interrupt Number Definition */

typedef enum {
// -------------------------  Cortex-M3 Processor Exceptions Numbers  -----------------------------
  Reset_IRQn                        = -15,  /*!<   1  Reset Vector, invoked on Power up and warm reset */
  NonMaskableInt_IRQn               = -14,  /*!<   2  Non maskable Interrupt, cannot be stopped or preempted */
  HardFault_IRQn                    = -13,  /*!<   3  Hard Fault, all classes of Fault */
  MemoryManagement_IRQn             = -12,  /*!<   4  Memory Management, MPU mismatch, including Access Violation and No Match */
  BusFault_IRQn                     = -11,  /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory related Fault */
  UsageFault_IRQn                   = -10,  /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition */
  SVCall_IRQn                       = -5,   /*!<  11  System Service Call via SVC instruction */
  DebugMonitor_IRQn                 = -4,   /*!<  12  Debug Monitor                    */
  PendSV_IRQn                       = -2,   /*!<  14  Pendable request for system service */
  SysTick_IRQn                      = -1,   /*!<  15  System Tick Timer                */
// ---------------------------  LPC18xx Specific Interrupt Numbers  -------------------------------
  DAC_IRQn                          = 0,    /*!<   0  DAC                              */
  RESERVED0_IRQn                    = 1,    /*!<   1  M0a                              */
  DMA_IRQn                          = 2,    /*!<   2  DMA                              */
  RESERVED1_IRQn                    = 3,    /*!<   3  EZH/EDM                          */
  RESERVED2_IRQn                    = 4,
  ETHERNET_IRQn                          = 5,    /*!<   5  ETHERNET                         */
  SDIO_IRQn                         = 6,    /*!<   6  SDIO                             */
  LCD_IRQn                          = 7,    /*!<   7  LCD                              */
  USB0_IRQn                         = 8,    /*!<   8  USB0                             */
  USB1_IRQn                         = 9,    /*!<   9  USB1                             */
  SCT_IRQn                          = 10,   /*!<  10  SCT                              */
  RITIMER_IRQn                      = 11,   /*!<  11  RITIMER                          */
  TIMER0_IRQn                       = 12,   /*!<  12  TIMER0                           */
  TIMER1_IRQn                       = 13,   /*!<  13  TIMER1                           */
  TIMER2_IRQn                       = 14,   /*!<  14  TIMER2                           */
  TIMER3_IRQn                       = 15,   /*!<  15  TIMER3                           */
  MCPWM_IRQn                        = 16,   /*!<  16  MCPWM                            */
  ADC0_IRQn                         = 17,   /*!<  17  ADC0                             */
  I2C0_IRQn                         = 18,   /*!<  18  I2C0                             */
  I2C1_IRQn                         = 19,   /*!<  19  I2C1                             */
  RESERVED3_IRQn                    = 20,
  ADC1_IRQn                         = 21,   /*!<  21  ADC1                             */
  SSP0_IRQn                         = 22,   /*!<  22  SSP0                             */
  SSP1_IRQn                         = 23,   /*!<  23  SSP1                             */
  USART0_IRQn                       = 24,   /*!<  24  USART0                           */
  UART1_IRQn                        = 25,   /*!<  25  UART1                            */
  USART2_IRQn                       = 26,   /*!<  26  USART2                           */
  USART3_IRQn                       = 27,   /*!<  27  USART3                           */
  I2S0_IRQn                         = 28,   /*!<  28  I2S0                             */
  I2S1_IRQn                         = 29,   /*!<  29  I2S1                             */
  RESERVED4_IRQn                    = 30,
  RESERVED5_IRQn                    = 31,
  PIN_INT0_IRQn                     = 32,   /*!<  32  PIN_INT0                         */
  PIN_INT1_IRQn                     = 33,   /*!<  33  PIN_INT1                         */
  PIN_INT2_IRQn                     = 34,   /*!<  34  PIN_INT2                         */
  PIN_INT3_IRQn                     = 35,   /*!<  35  PIN_INT3                         */
  PIN_INT4_IRQn                     = 36,   /*!<  36  PIN_INT4                         */
  PIN_INT5_IRQn                     = 37,   /*!<  37  PIN_INT5                         */
  PIN_INT6_IRQn                     = 38,   /*!<  38  PIN_INT6                         */
  PIN_INT7_IRQn                     = 39,   /*!<  39  PIN_INT7                         */
  GINT0_IRQn                        = 40,   /*!<  40  GINT0                            */
  GINT1_IRQn                        = 41,   /*!<  41  GINT1                            */
  EVENTROUTER_IRQn                  = 42,   /*!<  42  EVENTROUTER                      */
  C_CAN1_IRQn                       = 43,   /*!<  43  C_CAN1                           */
  RESERVED6_IRQn                    = 44,
  RESERVED7_IRQn                    = 45,   /*!<  45  VADC                             */
  ATIMER_IRQn                       = 46,   /*!<  46  ATIMER                           */
  RTC_IRQn                          = 47,   /*!<  47  RTC                              */
  RESERVED8_IRQn                    = 48,
  WWDT_IRQn                         = 49,   /*!<  49  WWDT                              */
  RESERVED9_IRQn                    = 50,
  C_CAN0_IRQn                       = 51,   /*!<  51  C_CAN0                           */
  QEI_IRQn                          = 52,   /*!<  52  QEI                              */
} IRQn_Type;

 /* Event Router Input (ERI) Number Definitions */
typedef enum {
  WAKEUP0_ERIn                      = 0,
  WAKEUP1_ERIn                      = 1,
  WAKEUP2_ERIn                      = 2,
  WAKEUP3_ERIn                      = 3,
  ATIMER_ERIn                       = 4,
  RTC_ERIn                          = 5,
  BOD1_ERIn                         = 6,  /* Bod trip 1 */
  WWDT_ERIn                         = 7,
  ETH_ERIn                          = 8,
  USB0_ERIn                         = 9,
  USB1_ERIn                         = 10,
  SDIO_ERIn                         = 11,
  CAN_ERIn                          = 12, /* CAN0/1 or'ed */
  TIM2_ERIn                         = 13,
  TIM6_ERIn                         = 14,
  QEI_ERIn                          = 15,
  TIM14_ERIn                        = 16,
  RESERVED0_ERIn                    = 17, /* M0s */
  RESERVED1_ERIn                    = 18, /* M3/M4 */
  RESET_ERIn                        = 19
}ERIn_Type;

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/* Processor and Core Peripheral Section */ /* Configuration of the Template Processor and Core Peripherals */

#define __CM3_REV              		0x0101		/*!< Cortex-M3 Core Revision               */
#define __MPU_PRESENT           	1         	/*!< MPU present or not                    */
#define __NVIC_PRIO_BITS          	3         	/*!< Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    	0         	/*!< Set to 1 if different SysTick Config is used */
/** @} */ /* End of group Configuration_of_CMSIS */

#include <core_cm3.h>                       /*!< Cortex-M3 processor and core peripherals */
#include "system_LPC18xx.h"                 /*!< LPC18xx System                        */

/** @addtogroup Device_Peripheral_Registers
  * @{
  */


// ------------------------------------------------------------------------------------------------
// -----                                          SCT                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx State Configurable Timer (SCT) Modification date=1/18/2011 Major revision=0 Minor revision=7  (SCT)
  */

#define CONFIG_SCT_nEV   (16)            /* Number of events */
#define CONFIG_SCT_nRG   (16)            /* Number of match/compare registers */
#define CONFIG_SCT_nOU   (16)            /* Number of outputs */

typedef struct
{
    __IO  uint32_t CONFIG;              /* 0x000 Configuration Register */
    union {
        __IO uint32_t CTRL_U;           /* 0x004 Control Register */
        struct {
            __IO uint16_t CTRL_L;       /* 0x004 low control register */
            __IO uint16_t CTRL_H;       /* 0x006 high control register */
        };
    };
    __IO uint16_t LIMIT_L;              /* 0x008 limit register for counter L */
    __IO uint16_t LIMIT_H;              /* 0x00A limit register for counter H */
    __IO uint16_t HALT_L;               /* 0x00C halt register for counter L */
    __IO uint16_t HALT_H;               /* 0x00E halt register for counter H */
    __IO uint16_t STOP_L;               /* 0x010 stop register for counter L */
    __IO uint16_t STOP_H;               /* 0x012 stop register for counter H */
    __IO uint16_t START_L;              /* 0x014 start register for counter L */
    __IO uint16_t START_H;              /* 0x016 start register for counter H */
         uint32_t RESERVED1[10];        /* 0x018-0x03C reserved */
    union {
        __IO uint32_t COUNT_U;          /* 0x040 counter register */
        struct {
            __IO uint16_t COUNT_L;      /* 0x040 counter register for counter L */
            __IO uint16_t COUNT_H;      /* 0x042 counter register for counter H */
        };
    };
    __IO uint16_t STATE_L;              /* 0x044 state register for counter L */
    __IO uint16_t STATE_H;              /* 0x046 state register for counter H */
    __I  uint32_t INPUT;                /* 0x048 input register */
    __IO uint16_t REGMODE_L;            /* 0x04C match - capture registers mode register L */
    __IO uint16_t REGMODE_H;            /* 0x04E match - capture registers mode register H */
    __IO uint32_t OUTPUT;               /* 0x050 output register */
    __IO uint32_t OUTPUTDIRCTRL;        /* 0x054 Output counter direction Control Register */
    __IO uint32_t RES;                  /* 0x058 conflict resolution register */
    __IO uint32_t DMA0REQUEST;          /* 0x05C DMA0 Request Register */
    __IO uint32_t DMA1REQUEST;          /* 0x060 DMA1 Request Register */
         uint32_t RESERVED2[35];        /* 0x064-0x0EC reserved */
    __IO uint32_t EVEN;                 /* 0x0F0 event enable register */
    __IO uint32_t EVFLAG;               /* 0x0F4 event flag register */
    __IO uint32_t CONEN;                /* 0x0F8 conflict enable register */
    __IO uint32_t CONFLAG;              /* 0x0FC conflict flag register */

    union {
        __IO union {                    /* 0x100-... Match / Capture value */
            uint32_t U;                 /*       SCTMATCH[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCH[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCH[i].H  Access to H value */
            };
        } MATCH[CONFIG_SCT_nRG];
        __I union {
            uint32_t U;                 /*       SCTCAP[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAP[i].L  Access to H value */
                uint16_t H;             /*       SCTCAP[i].H  Access to H value */
            };
        } CAP[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED3[32-CONFIG_SCT_nRG];      /* ...-0x17C reserved */

    union {
        __IO uint16_t MATCH_L[CONFIG_SCT_nRG];       /* 0x180-... Match Value L counter */
        __I  uint16_t CAP_L[CONFIG_SCT_nRG];         /* 0x180-... Capture Value L counter */
    };
         uint16_t RESERVED4[32-CONFIG_SCT_nRG];      /* ...-0x1BE reserved */
    union {
        __IO uint16_t MATCH_H[CONFIG_SCT_nRG];       /* 0x1C0-... Match Value H counter */
        __I  uint16_t CAP_H[CONFIG_SCT_nRG];         /* 0x1C0-... Capture Value H counter */
    };
         uint16_t RESERVED5[32-CONFIG_SCT_nRG];      /* ...-0x1FE reserved */

    union {
        __IO union {                    /* 0x200-... Match Reload / Capture Control value */
            uint32_t U;                 /*       SCTMATCHREL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCHREL[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCHREL[i].H  Access to H value */
            };
        } MATCHREL[CONFIG_SCT_nRG];
        __IO union {
            uint32_t U;                 /*       SCTCAPCTRL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAPCTRL[i].L  Access to H value */
                uint16_t H;             /*       SCTCAPCTRL[i].H  Access to H value */
            };
        } CAPCTRL[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED6[32-CONFIG_SCT_nRG];      /* ...-0x27C reserved */

    union {
        __IO uint16_t MATCHREL_L[CONFIG_SCT_nRG];    /* 0x280-... Match Reload value L counter */
        __IO uint16_t CAPCTRL_L[CONFIG_SCT_nRG];     /* 0x280-... Capture Control value L counter */
    };
         uint16_t RESERVED7[32-CONFIG_SCT_nRG];      /* ...-0x2BE reserved */
    union {
        __IO uint16_t MATCHREL_H[CONFIG_SCT_nRG];    /* 0x2C0-... Match Reload value H counter */
        __IO uint16_t CAPCTRL_H[CONFIG_SCT_nRG];     /* 0x2C0-... Capture Control value H counter */
    };
         uint16_t RESERVED8[32-CONFIG_SCT_nRG];      /* ...-0x2FE reserved */

    __IO struct {                       /* 0x300-0x3FC  SCTEVENT[i].STATE / SCTEVENT[i].CTRL*/
        uint32_t STATE;                 /* Event State Register */
        uint32_t CTRL;                  /* Event Control Register */
    } EVENT[CONFIG_SCT_nEV];

         uint32_t RESERVED9[128-2*CONFIG_SCT_nEV];   /* ...-0x4FC reserved */

    __IO struct {                       /* 0x500-0x57C  SCTOUT[i].SET / SCTOUT[i].CLR */
        uint32_t SET;                   /* Output n Set Register */
        uint32_t CLR;                   /* Output n Clear Register */
    } OUT[CONFIG_SCT_nOU];

         uint32_t RESERVED10[191-2*CONFIG_SCT_nOU];  /* ...-0x7F8 reserved */

    __I  uint32_t MODULECONTENT;        /* 0x7FC Module Content */

} LPC_SCT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         GPDMA                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx General Purpose DMA (GPDMA) controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (GPDMA)
  */

typedef struct {                            /*!< (@ 0x40002000) GPDMA Structure        */
  __I  uint32_t INTSTAT;                    /*!< (@ 0x40002000) DMA Interrupt Status Register */
  __I  uint32_t INTTCSTAT;                  /*!< (@ 0x40002004) DMA Interrupt Terminal Count Request Status Register */
  __O  uint32_t INTTCCLEAR;                 /*!< (@ 0x40002008) DMA Interrupt Terminal Count Request Clear Register */
  __I  uint32_t INTERRSTAT;                 /*!< (@ 0x4000200C) DMA Interrupt Error Status Register */
  __O  uint32_t INTERRCLR;                  /*!< (@ 0x40002010) DMA Interrupt Error Clear Register */
  __I  uint32_t RAWINTTCSTAT;               /*!< (@ 0x40002014) DMA Raw Interrupt Terminal Count Status Register */
  __I  uint32_t RAWINTERRSTAT;              /*!< (@ 0x40002018) DMA Raw Error Interrupt Status Register */
  __I  uint32_t ENBLDCHNS;                  /*!< (@ 0x4000201C) DMA Enabled Channel Register */
  __IO uint32_t SOFTBREQ;                   /*!< (@ 0x40002020) DMA Software Burst Request Register */
  __IO uint32_t SOFTSREQ;                   /*!< (@ 0x40002024) DMA Software Single Request Register */
  __IO uint32_t SOFTLBREQ;                  /*!< (@ 0x40002028) DMA Software Last Burst Request Register */
  __IO uint32_t SOFTLSREQ;                  /*!< (@ 0x4000202C) DMA Software Last Single Request Register */
  __IO uint32_t CONFIG;                     /*!< (@ 0x40002030) DMA Configuration Register */
  __IO uint32_t SYNC;                       /*!< (@ 0x40002034) DMA Synchronization Register */
  __I  uint32_t RESERVED0[50];
  __IO uint32_t C0SRCADDR;                  /*!< (@ 0x40002100) DMA Channel Source Address Register */
  __IO uint32_t C0DESTADDR;                 /*!< (@ 0x40002104) DMA Channel Destination Address Register */
  __IO uint32_t C0LLI;                      /*!< (@ 0x40002108) DMA Channel Linked List Item Register */
  __IO uint32_t C0CONTROL;                  /*!< (@ 0x4000210C) DMA Channel Control Register */
  __IO uint32_t C0CONFIG;                   /*!< (@ 0x40002110) DMA Channel Configuration Register */
  __I  uint32_t RESERVED1[3];
  __IO uint32_t C1SRCADDR;                  /*!< (@ 0x40002120) DMA Channel Source Address Register */
  __IO uint32_t C1DESTADDR;                 /*!< (@ 0x40002124) DMA Channel Destination Address Register */
  __IO uint32_t C1LLI;                      /*!< (@ 0x40002128) DMA Channel Linked List Item Register */
  __IO uint32_t C1CONTROL;                  /*!< (@ 0x4000212C) DMA Channel Control Register */
  __IO uint32_t C1CONFIG;                   /*!< (@ 0x40002130) DMA Channel Configuration Register */
  __I  uint32_t RESERVED2[3];
  __IO uint32_t C2SRCADDR;                  /*!< (@ 0x40002140) DMA Channel Source Address Register */
  __IO uint32_t C2DESTADDR;                 /*!< (@ 0x40002144) DMA Channel Destination Address Register */
  __IO uint32_t C2LLI;                      /*!< (@ 0x40002148) DMA Channel Linked List Item Register */
  __IO uint32_t C2CONTROL;                  /*!< (@ 0x4000214C) DMA Channel Control Register */
  __IO uint32_t C2CONFIG;                   /*!< (@ 0x40002150) DMA Channel Configuration Register */
  __I  uint32_t RESERVED3[3];
  __IO uint32_t C3SRCADDR;                  /*!< (@ 0x40002160) DMA Channel Source Address Register */
  __IO uint32_t C3DESTADDR;                 /*!< (@ 0x40002164) DMA Channel Destination Address Register */
  __IO uint32_t C3LLI;                      /*!< (@ 0x40002168) DMA Channel Linked List Item Register */
  __IO uint32_t C3CONTROL;                  /*!< (@ 0x4000216C) DMA Channel Control Register */
  __IO uint32_t C3CONFIG;                   /*!< (@ 0x40002170) DMA Channel Configuration Register */
  __I  uint32_t RESERVED4[3];
  __IO uint32_t C4SRCADDR;                  /*!< (@ 0x40002180) DMA Channel Source Address Register */
  __IO uint32_t C4DESTADDR;                 /*!< (@ 0x40002184) DMA Channel Destination Address Register */
  __IO uint32_t C4LLI;                      /*!< (@ 0x40002188) DMA Channel Linked List Item Register */
  __IO uint32_t C4CONTROL;                  /*!< (@ 0x4000218C) DMA Channel Control Register */
  __IO uint32_t C4CONFIG;                   /*!< (@ 0x40002190) DMA Channel Configuration Register */
  __I  uint32_t RESERVED5[3];
  __IO uint32_t C5SRCADDR;                  /*!< (@ 0x400021A0) DMA Channel Source Address Register */
  __IO uint32_t C5DESTADDR;                 /*!< (@ 0x400021A4) DMA Channel Destination Address Register */
  __IO uint32_t C5LLI;                      /*!< (@ 0x400021A8) DMA Channel Linked List Item Register */
  __IO uint32_t C5CONTROL;                  /*!< (@ 0x400021AC) DMA Channel Control Register */
  __IO uint32_t C5CONFIG;                   /*!< (@ 0x400021B0) DMA Channel Configuration Register */
  __I  uint32_t RESERVED6[3];
  __IO uint32_t C6SRCADDR;                  /*!< (@ 0x400021C0) DMA Channel Source Address Register */
  __IO uint32_t C6DESTADDR;                 /*!< (@ 0x400021C4) DMA Channel Destination Address Register */
  __IO uint32_t C6LLI;                      /*!< (@ 0x400021C8) DMA Channel Linked List Item Register */
  __IO uint32_t C6CONTROL;                  /*!< (@ 0x400021CC) DMA Channel Control Register */
  __IO uint32_t C6CONFIG;                   /*!< (@ 0x400021D0) DMA Channel Configuration Register */
  __I  uint32_t RESERVED7[3];
  __IO uint32_t C7SRCADDR;                  /*!< (@ 0x400021E0) DMA Channel Source Address Register */
  __IO uint32_t C7DESTADDR;                 /*!< (@ 0x400021E4) DMA Channel Destination Address Register */
  __IO uint32_t C7LLI;                      /*!< (@ 0x400021E8) DMA Channel Linked List Item Register */
  __IO uint32_t C7CONTROL;                  /*!< (@ 0x400021EC) DMA Channel Control Register */
  __IO uint32_t C7CONFIG;                   /*!< (@ 0x400021F0) DMA Channel Configuration Register */
} LPC_GPDMA_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         SDMMC                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx SD/MMC Modification date=n/a Major revision=n/a Minor revision=n/a  (SDMMC)
  */

typedef struct {                            /*!< (@ 0x40004000) SDMMC Structure        */
  __IO uint32_t CTRL;                       /*!< (@ 0x40004000) Control Register       */
  __IO uint32_t PWREN;                      /*!< (@ 0x40004004) Power Enable Register  */
  __IO uint32_t CLKDIV;                     /*!< (@ 0x40004008) Clock Divider Register */
  __IO uint32_t CLKSRC;                     /*!< (@ 0x4000400C) SD Clock Source Register */
  __IO uint32_t CLKENA;                     /*!< (@ 0x40004010) Clock Enable Register  */
  __IO uint32_t TMOUT;                      /*!< (@ 0x40004014) Timeout Register       */
  __IO uint32_t CTYPE;                      /*!< (@ 0x40004018) Card Type Register     */
  __IO uint32_t BLKSIZ;                     /*!< (@ 0x4000401C) Block Size Register    */
  __IO uint32_t BYTCNT;                     /*!< (@ 0x40004020) Byte Count Register    */
  __IO uint32_t INTMASK;                    /*!< (@ 0x40004024) Interrupt Mask Register */
  __IO uint32_t CMDARG;                     /*!< (@ 0x40004028) Command Argument Register */
  __IO uint32_t CMD;                        /*!< (@ 0x4000402C) Command Register       */
  __I  uint32_t RESP0;                      /*!< (@ 0x40004030) Response Register 0    */
  __I  uint32_t RESP1;                      /*!< (@ 0x40004034) Response Register 1    */
  __I  uint32_t RESP2;                      /*!< (@ 0x40004038) Response Register 2    */
  __I  uint32_t RESP3;                      /*!< (@ 0x4000403C) Response Register 3    */
  __I  uint32_t MINTSTS;                    /*!< (@ 0x40004040) Masked Interrupt Status Register */
  __IO uint32_t RINTSTS;                    /*!< (@ 0x40004044) Raw Interrupt Status Register */
  __I  uint32_t STATUS;                     /*!< (@ 0x40004048) Status Register        */
  __IO uint32_t FIFOTH;                     /*!< (@ 0x4000404C) FIFO Threshold Watermark Register */
  __I  uint32_t CDETECT;                    /*!< (@ 0x40004050) Card Detect Register   */
  __I  uint32_t WRTPRT;                     /*!< (@ 0x40004054) Write Protect Register */
  __IO uint32_t GPIO;                       /*!< (@ 0x40004058) General Purpose Input/Output Register */
  __I  uint32_t TCBCNT;                     /*!< (@ 0x4000405C) Transferred CIU Card Byte Count Register */
  __I  uint32_t TBBCNT;                     /*!< (@ 0x40004060) Transferred Host to BIU-FIFO Byte Count Register */
  __IO uint32_t DEBNCE;                     /*!< (@ 0x40004064) Debounce Count Register */
  __IO uint32_t USRID;                      /*!< (@ 0x40004068) User ID Register       */
  __I  uint32_t VERID;                      /*!< (@ 0x4000406C) Version ID Register    */
  __I  uint32_t RESERVED0;
  __IO uint32_t UHS_REG;                    /*!< (@ 0x40004074) UHS-1 Register         */
  __IO uint32_t RST_N;                      /*!< (@ 0x40004078) Hardware Reset         */
  __I  uint32_t RESERVED1;
  __IO uint32_t BMOD;                       /*!< (@ 0x40004080) Bus Mode Register      */
  __O  uint32_t PLDMND;                     /*!< (@ 0x40004084) Poll Demand Register   */
  __IO uint32_t DBADDR;                     /*!< (@ 0x40004088) Descriptor List Base Address Register */
  __IO uint32_t IDSTS;                      /*!< (@ 0x4000408C) Internal DMAC Status Register */
  __IO uint32_t IDINTEN;                    /*!< (@ 0x40004090) Internal DMAC Interrupt Enable Register */
  __I  uint32_t DSCADDR;                    /*!< (@ 0x40004094) Current Host Descriptor Address Register */
  __I  uint32_t BUFADDR;                    /*!< (@ 0x40004098) Current Buffer Descriptor Address Register */
} LPC_SDMMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          EMC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx External Memory Controller (EMC) Modification date=1/19/2011 Major revision=0 Minor revision=7  (EMC)
  */

typedef struct {                            /*!< (@ 0x40005000) EMC Structure          */
  __IO uint32_t CONTROL;                    /*!< (@ 0x40005000) Controls operation of the memory controller. */
  __I  uint32_t STATUS;                     /*!< (@ 0x40005004) Provides EMC status information. */
  __IO uint32_t CONFIG;                     /*!< (@ 0x40005008) Configures operation of the memory controller. */
  __I  uint32_t RESERVED0[5];
  __IO uint32_t DYNAMICCONTROL;             /*!< (@ 0x40005020) Controls dynamic memory operation. */
  __IO uint32_t DYNAMICREFRESH;             /*!< (@ 0x40005024) Configures dynamic memory refresh operation. */
  __IO uint32_t DYNAMICREADCONFIG;          /*!< (@ 0x40005028) Configures the dynamic memory read strategy. */
  __I  uint32_t RESERVED1;
  __IO uint32_t DYNAMICRP;                  /*!< (@ 0x40005030) Selects the precharge command period. */
  __IO uint32_t DYNAMICRAS;                 /*!< (@ 0x40005034) Selects the active to precharge command period. */
  __IO uint32_t DYNAMICSREX;                /*!< (@ 0x40005038) Selects the self-refresh exit time. */
  __IO uint32_t DYNAMICAPR;                 /*!< (@ 0x4000503C) Selects the last-data-out to active command time. */
  __IO uint32_t DYNAMICDAL;                 /*!< (@ 0x40005040) Selects the data-in to active command time. */
  __IO uint32_t DYNAMICWR;                  /*!< (@ 0x40005044) Selects the write recovery time. */
  __IO uint32_t DYNAMICRC;                  /*!< (@ 0x40005048) Selects the active to active command period. */
  __IO uint32_t DYNAMICRFC;                 /*!< (@ 0x4000504C) Selects the auto-refresh period. */
  __IO uint32_t DYNAMICXSR;                 /*!< (@ 0x40005050) Selects the exit self-refresh to active command time. */
  __IO uint32_t DYNAMICRRD;                 /*!< (@ 0x40005054) Selects the active bank A to active bank B latency. */
  __IO uint32_t DYNAMICMRD;                 /*!< (@ 0x40005058) Selects the load mode register to active command time. */
  __I  uint32_t RESERVED2[9];
  __IO uint32_t STATICEXTENDEDWAIT;         /*!< (@ 0x40005080) Selects time for long static memory read and write transfers. */
  __I  uint32_t RESERVED3[31];
  __IO uint32_t DYNAMICCONFIG0;             /*!< (@ 0x40005100) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS0;             /*!< (@ 0x40005104) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED4[6];
  __IO uint32_t DYNAMICCONFIG1;             /*!< (@ 0x40005120) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS1;             /*!< (@ 0x40005124) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED5[6];
  __IO uint32_t DYNAMICCONFIG2;             /*!< (@ 0x40005140) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS2;             /*!< (@ 0x40005144) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED6[6];
  __IO uint32_t DYNAMICCONFIG3;             /*!< (@ 0x40005160) Selects the configuration information for dynamic memory chip select n. */
  __IO uint32_t DYNAMICRASCAS3;             /*!< (@ 0x40005164) Selects the RAS and CAS latencies for dynamic memory chip select n. */
  __I  uint32_t RESERVED7[38];
  __IO uint32_t STATICCONFIG0;              /*!< (@ 0x40005200) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN0;             /*!< (@ 0x40005204) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN0;             /*!< (@ 0x40005208) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD0;              /*!< (@ 0x4000520C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG0;             /*!< (@ 0x40005210) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR0;              /*!< (@ 0x40005214) Selects the delay from chip select n to a write access. */
  __IO uint32_t STATICWAITTURN0;            /*!< (@ 0x40005218) Selects bus turnaround cycles */
  __I  uint32_t  RESERVED8;
  __IO uint32_t STATICCONFIG1;              /*!< (@ 0x40005220) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN1;             /*!< (@ 0x40005224) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN1;             /*!< (@ 0x40005228) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD1;              /*!< (@ 0x4000522C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG1;             /*!< (@ 0x40005230) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR1;              /*!< (@ 0x40005234) Selects the delay from chip select n to a write access. */
  __IO uint32_t  STATICWAITTURN1;           /*!< (@ 0x40005238) Selects bus turnaround cycles */
  __I  uint32_t  RESERVED9;
  __IO uint32_t STATICCONFIG2;              /*!< (@ 0x40005240) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN2;             /*!< (@ 0x40005244) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN2;             /*!< (@ 0x40005248) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD2;              /*!< (@ 0x4000524C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG2;             /*!< (@ 0x40005250) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR2;              /*!< (@ 0x40005254) Selects the delay from chip select n to a write access. */
  __IO uint32_t  STATICWAITTURN2;           /*!< (@ 0x40005258) Selects bus turnaround cycles */
  __I  uint32_t  RESERVED10;
  __IO uint32_t STATICCONFIG3;              /*!< (@ 0x40005260) Selects the memory configuration for static chip select n. */
  __IO uint32_t STATICWAITWEN3;             /*!< (@ 0x40005264) Selects the delay from chip select n to write enable. */
  __IO uint32_t STATICWAITOEN3;             /*!< (@ 0x40005268) Selects the delay from chip select n or address change, whichever is later, to output enable. */
  __IO uint32_t STATICWAITRD3;              /*!< (@ 0x4000526C) Selects the delay from chip select n to a read access. */
  __IO uint32_t STATICWAITPAG3;             /*!< (@ 0x40005270) Selects the delay for asynchronous page mode sequential accesses for chip select n. */
  __IO uint32_t STATICWAITWR3;              /*!< (@ 0x40005274) Selects the delay from chip select n to a write access. */
  __IO uint32_t  STATICWAITTURN3;           /*!< (@ 0x40005278) Selects bus turnaround cycles */
} LPC_EMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         USB0                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USB0 Host/Device/OTG controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (USB0)
  */

typedef struct {                            /*!< (@ 0x40006000) USB0 Structure         */
  __I  uint32_t RESERVED0[64];
  __I  uint32_t CAPLENGTH;                  /*!< (@ 0x40006100) Capability register length */
  __I  uint32_t HCSPARAMS;                  /*!< (@ 0x40006104) Host controller structural parameters */
  __I  uint32_t HCCPARAMS;                  /*!< (@ 0x40006108) Host controller capability parameters */
  __I  uint32_t RESERVED1[5];
  __I  uint32_t DCIVERSION;                 /*!< (@ 0x40006120) Device interface version number */
  __I  uint32_t RESERVED2[7];

  union {
    __IO uint32_t USBCMD_H;                 /*!< (@ 0x40006140) USB command (host mode) */
    __IO uint32_t USBCMD_D;                 /*!< (@ 0x40006140) USB command (device mode) */
  };

  union {
    __IO uint32_t USBSTS_H;                 /*!< (@ 0x40006144) USB status (host mode) */
    __IO uint32_t USBSTS_D;                 /*!< (@ 0x40006144) USB status (device mode) */
  };

  union {
    __IO uint32_t USBINTR_H;                /*!< (@ 0x40006148) USB interrupt enable (host mode) */
    __IO uint32_t USBINTR_D;                /*!< (@ 0x40006148) USB interrupt enable (device mode) */
  };

  union {
    __IO uint32_t FRINDEX_H;                /*!< (@ 0x4000614C) USB frame index (host mode) */
    __IO uint32_t FRINDEX_D;                /*!< (@ 0x4000614C) USB frame index (device mode) */
  };
  __I  uint32_t RESERVED3;

  union {
    __IO uint32_t PERIODICLISTBASE;         /*!< (@ 0x40006154) Frame list base address (host mode) */
    __IO uint32_t DEVICEADDR;               /*!< (@ 0x40006154) USB device address (device mode) */
  };

  union {
    __IO uint32_t ASYNCLISTADDR;            /*!< (@ 0x40006158) Address of endpoint list in memory */
    __IO uint32_t ENDPOINTLISTADDR;         /*!< (@ 0x40006158) Address of endpoint list in memory */
  };
  __IO uint32_t TTCTRL;                     /*!< (@ 0x4000615C) Asynchronous buffer status for embedded TT (host mode) */
  __IO uint32_t BURSTSIZE;                  /*!< (@ 0x40006160) Programmable burst size */
  __IO uint32_t TXFILLTUNING;               /*!< (@ 0x40006164) Host transmit pre-buffer packet tuning (host mode) */
  __I  uint32_t RESERVED4[3];
  __IO uint32_t BINTERVAL;                  /*!< (@ 0x40006174) Length of virtual frame */
  __IO uint32_t ENDPTNAK;                   /*!< (@ 0x40006178) Endpoint NAK (device mode) */
  __IO uint32_t ENDPTNAKEN;                 /*!< (@ 0x4000617C) Endpoint NAK Enable (device mode) */
  __I  uint32_t RESERVED5;

  union {
    __IO uint32_t PORTSC1_H;                /*!< (@ 0x40006184) Port 1 status/control (host mode) */
    __IO uint32_t PORTSC1_D;                /*!< (@ 0x40006184) Port 1 status/control (device mode) */
  };
  __I  uint32_t RESERVED6[7];
  __IO uint32_t OTGSC;                      /*!< (@ 0x400061A4) OTG status and control */

  union {
    __IO uint32_t USBMODE_H;                /*!< (@ 0x400061A8) USB mode (host mode)   */
    __IO uint32_t USBMODE_D;                /*!< (@ 0x400061A8) USB device mode (device mode) */
  };
  __IO uint32_t ENDPTSETUPSTAT;             /*!< (@ 0x400061AC) Endpoint setup status  */
  __IO uint32_t ENDPTPRIME;                 /*!< (@ 0x400061B0) Endpoint initialization */
  __IO uint32_t ENDPTFLUSH;                 /*!< (@ 0x400061B4) Endpoint de-initialization */
  __I  uint32_t ENDPTSTAT;                  /*!< (@ 0x400061B8) Endpoint status        */
  __IO uint32_t ENDPTCOMPLETE;              /*!< (@ 0x400061BC) Endpoint complete      */
  __IO uint32_t ENDPTCTRL0;                 /*!< (@ 0x400061C0) Endpoint control 0     */
  __IO uint32_t ENDPTCTRL1;                 /*!< (@ 0x400061C4) Endpoint control       */
  __IO uint32_t ENDPTCTRL2;                 /*!< (@ 0x400061C8) Endpoint control       */
  __IO uint32_t ENDPTCTRL3;                 /*!< (@ 0x400061CC) Endpoint control       */
  __IO uint32_t ENDPTCTRL4;                 /*!< (@ 0x400061D0) Endpoint control       */
  __IO uint32_t ENDPTCTRL5;                 /*!< (@ 0x400061D4) Endpoint control       */
} LPC_USB0_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         USB1                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USB1 Host/Device controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (USB1)
  */

typedef struct {                            /*!< (@ 0x40007000) USB1 Structure         */
  __I  uint32_t RESERVED0[64];
  __I  uint32_t CAPLENGTH;                  /*!< (@ 0x40007100) Capability register length */
  __I  uint32_t HCSPARAMS;                  /*!< (@ 0x40007104) Host controller structural parameters */
  __I  uint32_t HCCPARAMS;                  /*!< (@ 0x40007108) Host controller capability parameters */
  __I  uint32_t RESERVED1[5];
  __I  uint32_t DCIVERSION;                 /*!< (@ 0x40007120) Device interface version number */
  __I  uint32_t RESERVED2[7];

  union {
    __IO uint32_t USBCMD_H;                 /*!< (@ 0x40007140) USB command (host mode) */
    __IO uint32_t USBCMD_D;                 /*!< (@ 0x40007140) USB command (device mode) */
  };

  union {
    __IO uint32_t USBSTS_H;                 /*!< (@ 0x40007144) USB status (host mode) */
    __IO uint32_t USBSTS_D;                 /*!< (@ 0x40007144) USB status (device mode) */
  };

  union {
    __IO uint32_t USBINTR_H;                /*!< (@ 0x40007148) USB interrupt enable (host mode) */
    __IO uint32_t USBINTR_D;                /*!< (@ 0x40007148) USB interrupt enable (device mode) */
  };

  union {
    __IO uint32_t FRINDEX_H;                /*!< (@ 0x4000714C) USB frame index (host mode) */
    __I  uint32_t FRINDEX_D;                /*!< (@ 0x4000714C) USB frame index (device mode) */
  };
  __I  uint32_t RESERVED3;

  union {
    __IO uint32_t PERIODICLISTBASE;         /*!< (@ 0x40007154) Frame list base address */
    __IO uint32_t DEVICEADDR;               /*!< (@ 0x40007154) USB device address     */
  };

  union {
    __IO uint32_t ASYNCLISTADDR;            /*!< (@ 0x40007158) Address of endpoint list in memory (host mode) */
    __IO uint32_t ENDPOINTLISTADDR;         /*!< (@ 0x40007158) Address of endpoint list in memory (device mode) */
  };
  __IO uint32_t TTCTRL;                     /*!< (@ 0x4000715C) Asynchronous buffer status for embedded TT (host mode) */
  __IO uint32_t BURSTSIZE;                  /*!< (@ 0x40007160) Programmable burst size */
  __IO uint32_t TXFILLTUNING;               /*!< (@ 0x40007164) Host transmit pre-buffer packet tuning (host mode) */
  __I  uint32_t RESERVED4[2];
  __IO uint32_t ULPIVIEWPORT;               /*!< (@ 0x40007170) ULPI viewport          */
  __IO uint32_t BINTERVAL;                  /*!< (@ 0x40007174) Length of virtual frame */
  __IO uint32_t ENDPTNAK;                   /*!< (@ 0x40007178) Endpoint NAK (device mode) */
  __IO uint32_t ENDPTNAKEN;                 /*!< (@ 0x4000717C) Endpoint NAK Enable (device mode) */
  __I  uint32_t RESERVED5;

  union {
    __IO uint32_t PORTSC1_H;                /*!< (@ 0x40007184) Port 1 status/control (host mode) */
    __IO uint32_t PORTSC1_D;                /*!< (@ 0x40007184) Port 1 status/control (device mode) */
  };
  __I  uint32_t RESERVED6[8];

  union {
    __IO uint32_t USBMODE_H;                /*!< (@ 0x400071A8) USB mode (host mode)   */
    __IO uint32_t USBMODE_D;                /*!< (@ 0x400071A8) USB mode (device mode) */
  };
  __IO uint32_t ENDPTSETUPSTAT;             /*!< (@ 0x400071AC) Endpoint setup status  */
  __IO uint32_t ENDPTPRIME;                 /*!< (@ 0x400071B0) Endpoint initialization */
  __IO uint32_t ENDPTFLUSH;                 /*!< (@ 0x400071B4) Endpoint de-initialization */
  __I  uint32_t ENDPTSTAT;                  /*!< (@ 0x400071B8) Endpoint status        */
  __IO uint32_t ENDPTCOMPLETE;              /*!< (@ 0x400071BC) Endpoint complete      */
  __IO uint32_t ENDPTCTRL0;                 /*!< (@ 0x400071C0) Endpoint control 0     */
  __IO uint32_t ENDPTCTRL1;                 /*!< (@ 0x400071C4) Endpoint control       */
  __IO uint32_t ENDPTCTRL2;                 /*!< (@ 0x400071C8) Endpoint control       */
  __IO uint32_t ENDPTCTRL3;                 /*!< (@ 0x400071CC) Endpoint control       */
} LPC_USB1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          LCD                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx LCD Modification date=1/19/2011 Major revision=0 Minor revision=7  (LCD)
  */

typedef struct {                            /*!< (@ 0x40008000) LCD Structure          */
  __IO uint32_t TIMH;                       /*!< (@ 0x40008000) Horizontal Timing Control register */
  __IO uint32_t TIMV;                       /*!< (@ 0x40008004) Vertical Timing Control register */
  __IO uint32_t POL;                        /*!< (@ 0x40008008) Clock and Signal Polarity Control register */
  __IO uint32_t LE;                         /*!< (@ 0x4000800C) Line End Control register */
  __IO uint32_t UPBASE;                     /*!< (@ 0x40008010) Upper Panel Frame Base Address register */
  __IO uint32_t LPBASE;                     /*!< (@ 0x40008014) Lower Panel Frame Base Address register */
  __IO uint32_t CTRL;                       /*!< (@ 0x40008018) LCD Control register   */
  __IO uint32_t INTMSK;                     /*!< (@ 0x4000801C) Interrupt Mask register */
  __I  uint32_t INTRAW;                     /*!< (@ 0x40008020) Raw Interrupt Status register */
  __I  uint32_t INTSTAT;                    /*!< (@ 0x40008024) Masked Interrupt Status register */
  __O  uint32_t INTCLR;                     /*!< (@ 0x40008028) Interrupt Clear register */
  __I  uint32_t UPCURR;                     /*!< (@ 0x4000802C) Upper Panel Current Address Value register */
  __I  uint32_t LPCURR;                     /*!< (@ 0x40008030) Lower Panel Current Address Value register */
  __I  uint32_t RESERVED0[115];
  __IO uint32_t PAL[256];					/*!< (@ 0x40008200) 256x16-bit Color Palette registers */
  __I  uint32_t RESERVED1[128];
  __IO uint32_t CRSR_IMG[256];              /*!< (@ 0x40008800) Cursor Image registers */
  __IO uint32_t CRSR_CTRL;                  /*!< (@ 0x40008C00) Cursor Control register */
  __IO uint32_t CRSR_CFG;                   /*!< (@ 0x40008C04) Cursor Configuration register */
  __IO uint32_t CRSR_PAL0;                  /*!< (@ 0x40008C08) Cursor Palette register 0 */
  __IO uint32_t CRSR_PAL1;                  /*!< (@ 0x40008C0C) Cursor Palette register 1 */
  __IO uint32_t CRSR_XY;                    /*!< (@ 0x40008C10) Cursor XY Position register */
  __IO uint32_t CRSR_CLIP;                  /*!< (@ 0x40008C14) Cursor Clip Position register */
  __I  uint32_t RESERVED2[2];
  __IO uint32_t CRSR_INTMSK;                /*!< (@ 0x40008C20) Cursor Interrupt Mask register */
  __O  uint32_t CRSR_INTCLR;                /*!< (@ 0x40008C24) Cursor Interrupt Clear register */
  __I  uint32_t CRSR_INTRAW;                /*!< (@ 0x40008C28) Cursor Raw Interrupt Status register */
  __I  uint32_t CRSR_INTSTAT;               /*!< (@ 0x40008C2C) Cursor Masked Interrupt Status register */
} LPC_LCD_Type;


// ------------------------------------------------------------------------------------------------
// -----                                       ETHERNET                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Ethernet Modification date=12/9/2011 Major revision=1.1 Minor revision=not available  (ETHERNET)
  */

typedef struct {                            /*!< (@ 0x40010000) ETHERNET Structure     */
  __IO uint32_t MAC_CONFIG;                 /*!< (@ 0x40010000) MAC configuration register */
  __IO uint32_t MAC_FRAME_FILTER;           /*!< (@ 0x40010004) MAC frame filter       */
  __IO uint32_t MAC_HASHTABLE_HIGH;         /*!< (@ 0x40010008) Hash table high register */
  __IO uint32_t MAC_HASHTABLE_LOW;          /*!< (@ 0x4001000C) Hash table low register */
  __IO uint32_t MAC_MII_ADDR;               /*!< (@ 0x40010010) MII address register   */
  __IO uint32_t MAC_MII_DATA;               /*!< (@ 0x40010014) MII data register      */
  __IO uint32_t MAC_FLOW_CTRL;              /*!< (@ 0x40010018) Flow control register  */
  __IO uint32_t MAC_VLAN_TAG;               /*!< (@ 0x4001001C) VLAN tag register      */
  __I  uint32_t RESERVED0;
  __I  uint32_t  MAC_DEBUG;                 /*!< (@ 0x40010024) Debug register         */
  __IO uint32_t MAC_RWAKE_FRFLT;            /*!< (@ 0x40010028) Remote wake-up frame filter */
  __IO uint32_t MAC_PMT_CTRL_STAT;          /*!< (@ 0x4001002C) PMT control and status */
  __I  uint32_t RESERVED1[2];
  __I  uint32_t  MAC_INTR;                  /*!< (@ 0x40010038) Interrupt status register */
  __IO uint32_t MAC_INTR_MASK;              /*!< (@ 0x4001003C) Interrupt mask register */
  __IO uint32_t MAC_ADDR0_HIGH;             /*!< (@ 0x40010040) MAC address 0 high register */
  __IO uint32_t MAC_ADDR0_LOW;              /*!< (@ 0x40010044) MAC address 0 low register */
  __I  uint32_t RESERVED2[430];
  __IO uint32_t MAC_TIMESTP_CTRL;           /*!< (@ 0x40010700) Time stamp control register */
  __IO uint32_t  SUBSECOND_INCR;            /*!< (@ 0x40010704) Sub-second increment register */
  __I  uint32_t  SECONDS;                   /*!< (@ 0x40010708) System time seconds register */
  __I  uint32_t  NANOSECONDS;               /*!< (@ 0x4001070C) System time nanoseconds register */
  __IO uint32_t  SECONDSUPDATE;             /*!< (@ 0x40010710) System time seconds update register */
  __IO uint32_t  NANOSECONDSUPDATE;         /*!< (@ 0x40010714) System time nanoseconds update register */
  __IO uint32_t  ADDEND;                    /*!< (@ 0x40010718) Time stamp addend register */
  __IO uint32_t  TARGETSECONDS;             /*!< (@ 0x4001071C) Target time seconds register */
  __IO uint32_t  TARGETNANOSECONDS;         /*!< (@ 0x40010720) Target time nanoseconds register */
  __IO uint32_t  HIGHWORD;                  /*!< (@ 0x40010724) System time higher word seconds register */
  __I  uint32_t  TIMESTAMPSTAT;             /*!< (@ 0x40010728) Time stamp status register */
  __IO uint32_t  PPSCTRL;                   /*!< (@ 0x4001072C) PPS control register   */
  __I  uint32_t  AUXNANOSECONDS;            /*!< (@ 0x40010730) Auxiliary time stamp nanoseconds register */
  __I  uint32_t  AUXSECONDS;                /*!< (@ 0x40010734) Auxiliary time stamp seconds register */
  __I  uint32_t  RESERVED3[562];
  __IO uint32_t DMA_BUS_MODE;               /*!< (@ 0x40011000) Bus Mode Register      */
  __IO uint32_t DMA_TRANS_POLL_DEMAND;      /*!< (@ 0x40011004) Transmit poll demand register */
  __IO uint32_t DMA_REC_POLL_DEMAND;        /*!< (@ 0x40011008) Receive poll demand register */
  __IO uint32_t DMA_REC_DES_ADDR;           /*!< (@ 0x4001100C) Receive descriptor list address register */
  __IO uint32_t DMA_TRANS_DES_ADDR;         /*!< (@ 0x40011010) Transmit descriptor list address register */
  __IO uint32_t DMA_STAT;                   /*!< (@ 0x40011014) Status register        */
  __IO uint32_t DMA_OP_MODE;                /*!< (@ 0x40011018) Operation mode register */
  __IO uint32_t DMA_INT_EN;                 /*!< (@ 0x4001101C) Interrupt enable register */
  __I  uint32_t  DMA_MFRM_BUFOF;            /*!< (@ 0x40011020) Missed frame and buffer overflow register */
  __IO uint32_t DMA_REC_INT_WDT;            /*!< (@ 0x40011024) Receive interrupt watchdog timer register */
  __I  uint32_t RESERVED4[8];
  __I  uint32_t  DMA_CURHOST_TRANS_DES;     /*!< (@ 0x40011048) Current host transmit descriptor register */
  __I  uint32_t  DMA_CURHOST_REC_DES;       /*!< (@ 0x4001104C) Current host receive descriptor register */
  __I  uint32_t  DMA_CURHOST_TRANS_BUF;     /*!< (@ 0x40011050) Current host transmit buffer address register */
  __I  uint32_t  DMA_CURHOST_REC_BUF;       /*!< (@ 0x40011054) Current host receive buffer address register */
} LPC_ETHERNET_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        ATIMER                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Alarm timer Modification date=1/7/2011 Major revision=0 Minor revision=6  (ATIMER)
  */

typedef struct {                            /*!< (@ 0x40040000) ATIMER Structure       */
  __IO uint32_t DOWNCOUNTER;                /*!< (@ 0x40040000) Downcounter register   */
  __IO uint32_t PRESET;                     /*!< (@ 0x40040004) Preset value register  */
  __I  uint32_t RESERVED0[1012];
  __O  uint32_t CLR_EN;                     /*!< (@ 0x40040FD8) Interrupt clear enable register */
  __O  uint32_t SET_EN;                     /*!< (@ 0x40040FDC) Interrupt set enable register */
  __I  uint32_t STATUS;                     /*!< (@ 0x40040FE0) Status register        */
  __I  uint32_t ENABLE;                     /*!< (@ 0x40040FE4) Enable register        */
  __O  uint32_t CLR_STAT;                   /*!< (@ 0x40040FE8) Clear register         */
  __O  uint32_t SET_STAT;                   /*!< (@ 0x40040FEC) Set register           */
} LPC_ATIMER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        REGFILE                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx rtc/REGFILE date=1/20/2011 Major revision=0 Minor revision=7  (REGFILE)
  */

typedef struct {                            /*!< (@ 0x40041000) REGFILE Structure      */
  __IO uint32_t REGFILE[64];                /*!< (@ 0x40041000) General purpose storage register */
} LPC_REGFILE_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          PMC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Power Management Controller (PMC) Modification date=1/20/2011 Major revision=0 Minor revision=7  (PMC)
  */

typedef struct {                            /*!< (@ 0x40042000) PMC Structure          */
  __IO uint32_t PD0_SLEEP0_HW_ENA;          /*!< (@ 0x40042000) Hardware sleep event enable register */
  __I  uint32_t  RESERVED0[6];
  __IO uint32_t PD0_SLEEP0_MODE;            /*!< (@ 0x4004201C) Sleep power mode register */
} LPC_PMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CREG                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Configuration Registers (CREG) Modification date=8/19/2011 Major revision=0 Minor revision=14  (CREG)
  */

typedef struct {                            /*!< (@ 0x40043000) CREG Structure         */
  __I  uint32_t  IRCTRM;                    /*!< (@ 0x40043000) IRC trim register      */
  __IO uint32_t CREG0;                      /*!< (@ 0x40043004) Chip configuration register 32 kHz oscillator output and BOD control register. */
  __I  uint32_t  RESERVED1[62];
  __IO uint32_t M3MEMMAP;                   /*!< (@ 0x40043100) ARM Cortex-M3 memory mapping */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t CREG5;                      /*!< (@ 0x40043118) Chip configuration register 5. Controls JTAG access. */
  __IO uint32_t DMAMUX;                     /*!< (@ 0x4004311C) DMA muxing control     */
  __I  uint32_t  RESERVED3[2];
  __IO uint32_t ETBCFG;                     /*!< (@ 0x40043128) ETB RAM configuration  */
  __IO uint32_t  CREG6;                     /*!< (@ 0x4004312C) Chip configuration register 6 */
  __I  uint32_t  RESERVED4[52];
  __I  uint32_t CHIPID;                     /*!< (@ 0x40043200) Part ID                */
} LPC_CREG_Type;


// ------------------------------------------------------------------------------------------------
// -----                                      EVENTROUTER                                     -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Event router Modification date=1/20/2011 Major revision=0 Minor revision=7  (EVENTROUTER)
  */

typedef struct {                            /*!< (@ 0x40044000) EVENTROUTER Structure  */
  __IO uint32_t HILO;                       /*!< (@ 0x40044000) Level configuration register */
  __IO uint32_t EDGE;                       /*!< (@ 0x40044004) Edge configuration     */
  __I  uint32_t RESERVED0[1012];
  __O  uint32_t CLR_EN;                     /*!< (@ 0x40044FD8) Event clear enable register */
  __O  uint32_t SET_EN;                     /*!< (@ 0x40044FDC) Event set enable register */
  __I  uint32_t STATUS;                     /*!< (@ 0x40044FE0) Status register        */
  __I  uint32_t ENABLE;                     /*!< (@ 0x40044FE4) Enable register        */
  __O  uint32_t CLR_STAT;                   /*!< (@ 0x40044FE8) Clear register         */
  __O  uint32_t SET_STAT;                   /*!< (@ 0x40044FEC) Set register           */
} LPC_EVENTROUTER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          RTC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Real-Time Clock (RTC) Modification date=1/20/2011 Major revision=0 Minor revision=7  (RTC)
  */

typedef struct {                            /*!< (@ 0x40046000) RTC Structure          */
  __O  uint32_t ILR;                        /*!< (@ 0x40046000) Interrupt Location Register */
  __I  uint32_t RESERVED0;
  __IO uint32_t CCR;                        /*!< (@ 0x40046008) Clock Control Register */
  __IO uint32_t CIIR;                       /*!< (@ 0x4004600C) Counter Increment Interrupt Register */
  __IO uint32_t AMR;                        /*!< (@ 0x40046010) Alarm Mask Register    */
  __I  uint32_t CTIME0;                     /*!< (@ 0x40046014) Consolidated Time Register 0 */
  __I  uint32_t CTIME1;                     /*!< (@ 0x40046018) Consolidated Time Register 1 */
  __I  uint32_t CTIME2;                     /*!< (@ 0x4004601C) Consolidated Time Register 2 */
  __IO uint32_t SEC;                        /*!< (@ 0x40046020) Seconds Register       */
  __IO uint32_t MIN;                        /*!< (@ 0x40046024) Minutes Register       */
  __IO uint32_t HRS;                        /*!< (@ 0x40046028) Hours Register         */
  __IO uint32_t DOM;                        /*!< (@ 0x4004602C) Day of Month Register  */
  __IO uint32_t DOW;                        /*!< (@ 0x40046030) Day of Week Register   */
  __IO uint32_t DOY;                        /*!< (@ 0x40046034) Day of Year Register   */
  __IO uint32_t MONTH;                      /*!< (@ 0x40046038) Months Register        */
  __IO uint32_t YEAR;                       /*!< (@ 0x4004603C) Years Register         */
  __IO uint32_t CALIBRATION;                /*!< (@ 0x40046040) Calibration Value Register */
  __I  uint32_t RESERVED1[7];
  __IO uint32_t ASEC;                       /*!< (@ 0x40046060) Alarm value for Seconds */
  __IO uint32_t AMIN;                       /*!< (@ 0x40046064) Alarm value for Minutes */
  __IO uint32_t AHRS;                       /*!< (@ 0x40046068) Alarm value for Hours  */
  __IO uint32_t ADOM;                       /*!< (@ 0x4004606C) Alarm value for Day of Month */
  __IO uint32_t ADOW;                       /*!< (@ 0x40046070) Alarm value for Day of Week */
  __IO uint32_t ADOY;                       /*!< (@ 0x40046074) Alarm value for Day of Year */
  __IO uint32_t AMON;                       /*!< (@ 0x40046078) Alarm value for Months */
  __IO uint32_t AYRS;                       /*!< (@ 0x4004607C) Alarm value for Year   */
} LPC_RTC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          CGU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10462 Chapter title=LPC18xx Clock Generation Unit (CGU) Modification date=6/1/2011 Major revision=0 Minor revision=1  (CGU)
  */

typedef struct {                            /*!< (@ 0x40050000) CGU Structure          */
  __I  uint32_t RESERVED0[5];
  __IO uint32_t FREQ_MON;                   /*!< (@ 0x40050014) Frequency monitor register */
  __IO uint32_t XTAL_OSC_CTRL;              /*!< (@ 0x40050018) Crystal oscillator control register */
  __I  uint32_t PLL0USB_STAT;               /*!< (@ 0x4005001C) PLL0 (USB) status register */
  __IO uint32_t PLL0USB_CTRL;               /*!< (@ 0x40050020) PLL0 (USB) control register */
  __IO uint32_t PLL0USB_MDIV;               /*!< (@ 0x40050024) PLL0 (USB) M-divider register */
  __IO uint32_t PLL0USB_NP_DIV;             /*!< (@ 0x40050028) PLL0 (USB) N/P-divider register */
  __I  uint32_t PLL0AUDIO_STAT;             /*!< (@ 0x4005002C) PLL0 (audio) status register */
  __IO uint32_t PLL0AUDIO_CTRL;             /*!< (@ 0x40050030) PLL0 (audio) control register */
  __IO uint32_t PLL0AUDIO_MDIV;             /*!< (@ 0x40050034) PLL0 (audio) M-divider register */
  __IO uint32_t PLL0AUDIO_NP_DIV;           /*!< (@ 0x40050038) PLL0 (audio) N/P-divider register */
  __IO uint32_t PLL0AUDIO_FRAC;             /*!< (@ 0x4005003C) PLL0 (audio)           */
  __I  uint32_t PLL1_STAT;                  /*!< (@ 0x40050040) PLL1 status register   */
  __IO uint32_t PLL1_CTRL;                  /*!< (@ 0x40050044) PLL1 control register  */
  __IO uint32_t IDIVA_CTRL;                 /*!< (@ 0x40050048) Integer divider A control register */
  __IO uint32_t IDIVB_CTRL;                 /*!< (@ 0x4005004C) Integer divider B control register */
  __IO uint32_t IDIVC_CTRL;                 /*!< (@ 0x40050050) Integer divider C control register */
  __IO uint32_t IDIVD_CTRL;                 /*!< (@ 0x40050054) Integer divider D control register */
  __IO uint32_t IDIVE_CTRL;                 /*!< (@ 0x40050058) Integer divider E control register */
  __IO uint32_t BASE_SAFE_CLK;              /*!< (@ 0x4005005C) Output stage 0 control register for base clock BASE_SAFE_CLK */
  __IO uint32_t BASE_USB0_CLK;              /*!< (@ 0x40050060) Output stage 1 control register for base clock BASE_USB0_CLK */
  __IO uint32_t BASE_PERIPH_CLK;            /*!< (@ 0x40050064) Output stage 2 control register for base clock BASE_PERIPH_CLK */
  __IO uint32_t BASE_USB1_CLK;              /*!< (@ 0x40050068) Output stage 3 control register for base clock BASE_USB1_CLK */
  __IO uint32_t BASE_M3_CLK;                /*!< (@ 0x4005006C) Output stage control register  */
  __IO uint32_t BASE_SPIFI_CLK;             /*!< (@ 0x40050070) Output stage control register  */
  __IO uint32_t RESERVED2;
  __IO uint32_t BASE_PHY_RX_CLK;            /*!< (@ 0x40050078) Output stage control register  */
  __IO uint32_t BASE_PHY_TX_CLK;            /*!< (@ 0x4005007C) Output stage control register  */
  __IO uint32_t BASE_APB1_CLK;              /*!< (@ 0x40050080) Output stage control register  */
  __IO uint32_t BASE_APB3_CLK;              /*!< (@ 0x40050084) Output stage control register  */
  __IO uint32_t BASE_LCD_CLK;               /*!< (@ 0x40050088) Output stage control register  */
  __IO uint32_t RESERVED3;
  __IO uint32_t BASE_SDIO_CLK;              /*!< (@ 0x40050090) Output stage control register  */
  __IO uint32_t BASE_SSP0_CLK;              /*!< (@ 0x40050094) Output stage control register  */
  __IO uint32_t BASE_SSP1_CLK;              /*!< (@ 0x40050098) Output stage control register  */
  __IO uint32_t BASE_UART0_CLK;             /*!< (@ 0x4005009C) Output stage control register  */
  __IO uint32_t BASE_UART1_CLK;             /*!< (@ 0x400500A0) Output stage control register  */
  __IO uint32_t BASE_UART2_CLK;             /*!< (@ 0x400500A4) Output stage control register  */
  __IO uint32_t BASE_UART3_CLK;             /*!< (@ 0x400500A8) Output stage control register  */
  __IO uint32_t BASE_OUT_CLK;               /*!< (@ 0x400500AC) Output stage 20 control register for base clock BASE_OUT_CLK */
  __I  uint32_t RESERVED4[4];
  __IO uint32_t BASE_APLL_CLK;              /*!< (@ 0x400500C0) Output stage 25 control register for base clock BASE_APLL_CLK */
  __IO uint32_t BASE_CGU_OUT0_CLK;          /*!< (@ 0x400500C4) Output stage 26 control register for base clock BASE_CGU_OUT0_CLK */
  __IO uint32_t BASE_CGU_OUT1_CLK;          /*!< (@ 0x400500C8) Output stage 27 control register for base clock BASE_CGU_OUT1_CLK */
} LPC_CGU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CCU1                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Clock Control Unit (CCU) Modification date=1/21/2011 Major revision=0 Minor revision=7  (CCU1)
  */

typedef struct {                            /*!< (@ 0x40051000) CCU1 Structure         */
  __IO uint32_t PM;                         /*!< (@ 0x40051000) CCU1 power mode register */
  __I  uint32_t BASE_STAT;                  /*!< (@ 0x40051004) CCU1 base clocks status register */
  __I  uint32_t RESERVED0[62];
  __IO uint32_t CLK_APB3_BUS_CFG;           /*!< (@ 0x40051100) CLK_APB3_BUS clock configuration register */
  __I  uint32_t CLK_APB3_BUS_STAT;          /*!< (@ 0x40051104) CLK_APB3_BUS clock status register */
  __IO uint32_t CLK_APB3_I2C1_CFG;          /*!< (@ 0x40051108) CLK_APB3_I2C1 clock configuration register */
  __I  uint32_t CLK_APB3_I2C1_STAT;         /*!< (@ 0x4005110C) CLK_APB3_I2C1 clock status register */
  __IO uint32_t CLK_APB3_DAC_CFG;           /*!< (@ 0x40051110) CLK_APB3_DAC clock configuration register */
  __I  uint32_t CLK_APB3_DAC_STAT;          /*!< (@ 0x40051114) CLK_APB3_DAC clock status register */
  __IO uint32_t CLK_APB3_ADC0_CFG;          /*!< (@ 0x40051118) CLK_APB3_ADC0 clock configuration register */
  __I  uint32_t CLK_APB3_ADC0_STAT;         /*!< (@ 0x4005111C) CLK_APB3_ADC0 clock status register */
  __IO uint32_t CLK_APB3_ADC1_CFG;          /*!< (@ 0x40051120) CLK_APB3_ADC1 clock configuration register */
  __I  uint32_t CLK_APB3_ADC1_STAT;         /*!< (@ 0x40051124) CLK_APB3_ADC1 clock status register */
  __IO uint32_t CLK_APB3_CAN0_CFG;          /*!< (@ 0x40051128) CLK_APB3_CAN0 clock configuration register */
  __I  uint32_t CLK_APB3_CAN0_STAT;         /*!< (@ 0x4005112C) CLK_APB3_CAN0 clock status register */
  __I  uint32_t  RESERVED1[52];
  __IO uint32_t CLK_APB1_BUS_CFG;           /*!< (@ 0x40051200) CLK_APB1_BUS clock configuration register */
  __I  uint32_t CLK_APB1_BUS_STAT;          /*!< (@ 0x40051204) CLK_APB1_BUS clock status register */
  __IO uint32_t CLK_APB1_MOTOCONPWM_CFG;    /*!< (@ 0x40051208) CLK_APB1_MOTOCONPWM clock configuration register */
  __I  uint32_t CLK_APB1_MOTOCONPWM_STAT;   /*!< (@ 0x4005120C) CLK_APB1_MOTOCONPWM clock status register */
  __IO uint32_t CLK_ABP1_I2C0_CFG;          /*!< (@ 0x40051210) CLK_ABP1_I2C0 clock configuration register */
  __I  uint32_t CLK_APB1_I2C0_STAT;         /*!< (@ 0x40051214) CLK_APB1_I2C0 clock status register */
  __IO uint32_t CLK_APB1_I2S_CFG;           /*!< (@ 0x40051218) CLK_APB1_I2S clock configuration register */
  __I  uint32_t CLK_APB1_I2S_STAT;          /*!< (@ 0x4005121C) CLK_APB1_I2S clock status register */
  __IO uint32_t CLK_APB1_CAN1_CFG;          /*!< (@ 0x40051220) CLK_APB1_CAN1 clock configuration register */
  __I  uint32_t CLK_APB1_CAN1_STAT;         /*!< (@ 0x40051224) CLK_APB1_CAN1 clock status register */
  __I  uint32_t  RESERVED2[54];
  __IO uint32_t CLK_SPIFI_CFG;              /*!< (@ 0x40051300) CLK_SPIFI clock configuration register */
  __I  uint32_t CLK_SPIFI_STAT;             /*!< (@ 0x40051304) CLK_APB1_SPIFI clock status register */
  __I  uint32_t RESERVED3[62];
  __IO uint32_t CLK_M3_BUS_CFG;             /*!< (@ 0x40051400) CLK_M3_BUS clock configuration register */
  __I  uint32_t CLK_M3_BUS_STAT;            /*!< (@ 0x40051404) CLK_M3_BUSclock status register */
  __IO uint32_t CLK_M3_SPIFI_CFG;           /*!< (@ 0x40051408) CLK_M3_SPIFI clock configuration register */
  __I  uint32_t CLK_M3_SPIFI_STAT;          /*!< (@ 0x4005140C) CLK_M3_SPIFI clock status register */
  __IO uint32_t CLK_M3_GPIO_CFG;            /*!< (@ 0x40051410) CLK_M3_GPIO clock configuration register */
  __I  uint32_t CLK_M3_GPIO_STAT;           /*!< (@ 0x40051414) CLK_M3_GPIO clock status register */
  __IO uint32_t CLK_M3_LCD_CFG;             /*!< (@ 0x40051418) CLK_M3_LCD clock configuration register */
  __I  uint32_t CLK_M3_LCD_STAT;            /*!< (@ 0x4005141C) CLK_M3_LCD clock status register */
  __IO uint32_t CLK_M3_ETHERNET_CFG;        /*!< (@ 0x40051420) CLK_M3_ETHERNET clock configuration register */
  __I  uint32_t CLK_M3_ETHERNET_STAT;       /*!< (@ 0x40051424) CLK_M3_ETHERNET clock status register */
  __IO uint32_t CLK_M3_USB0_CFG;            /*!< (@ 0x40051428) CLK_M3_USB0 clock configuration register */
  __I  uint32_t CLK_M3_USB0_STAT;           /*!< (@ 0x4005142C) CLK_M3_USB0 clock status register */
  __IO uint32_t CLK_M3_EMC_CFG;             /*!< (@ 0x40051430) CLK_M3_EMC clock configuration register */
  __I  uint32_t CLK_M3_EMC_STAT;            /*!< (@ 0x40051434) CLK_M3_EMC clock status register */
  __IO uint32_t CLK_M3_SDIO_CFG;            /*!< (@ 0x40051438) CLK_M3_SDIO clock configuration register */
  __I  uint32_t CLK_M3_SDIO_STAT;           /*!< (@ 0x4005143C) CLK_M3_SDIO clock status register */
  __IO uint32_t CLK_M3_DMA_CFG;             /*!< (@ 0x40051440) CLK_M3_DMA clock configuration register */
  __I  uint32_t CLK_M3_DMA_STAT;            /*!< (@ 0x40051444) CLK_M3_DMA clock status register */
  __IO uint32_t CLK_M3_M3CORE_CFG;          /*!< (@ 0x40051448) CLK_M3_M3CORE clock configuration register */
  __I  uint32_t CLK_M3_M3CORE_STAT;         /*!< (@ 0x4005144C) CLK_M3_M3CORE clock status register */
  __I  uint32_t  RESERVED4[6];
  __IO uint32_t CLK_M3_SCT_CFG;             /*!< (@ 0x40051468) CLK_M3_SCT clock configuration register */
  __I  uint32_t CLK_M3_SCT_STAT;            /*!< (@ 0x4005146C) CLK_M3_SCT clock status register */
  __IO uint32_t CLK_M3_USB1_CFG;            /*!< (@ 0x40051470) CLK_M3_USB1 clock configuration register */
  __I  uint32_t CLK_M3_USB1_STAT;           /*!< (@ 0x40051474) CLK_M3_USB1 clock status register */
  __IO uint32_t CLK_M3_EMCDIV_CFG;          /*!< (@ 0x40051478) CLK_M3_EMCDIV clock configuration register */
  __I  uint32_t CLK_M3_EMCDIV_STAT;         /*!< (@ 0x4005147C) CLK_M3_EMCDIV clock status register */
  __I  uint32_t  RESERVED5[32];
  __IO uint32_t CLK_M3_WWDT_CFG;            /*!< (@ 0x40051500) CLK_M3_WWDT clock configuration register */
  __I  uint32_t CLK_M3_WWDT_STAT;           /*!< (@ 0x40051504) CLK_M3_WWDT clock status register */
  __IO uint32_t CLK_M3_USART0_CFG;          /*!< (@ 0x40051508) CLK_M3_USART0 clock configuration register */
  __I  uint32_t CLK_M3_USART0_STAT;         /*!< (@ 0x4005150C) CLK_M3_USART0 clock status register */
  __IO uint32_t CLK_M3_UART1_CFG;           /*!< (@ 0x40051510) CLK_M3_UART1 clock configuration register */
  __I  uint32_t CLK_M3_UART1_STAT;          /*!< (@ 0x40051514) CLK_M3_UART1 clock status register */
  __IO uint32_t CLK_M3_SSP0_CFG;            /*!< (@ 0x40051518) CLK_M3_SSP0 clock configuration register */
  __I  uint32_t CLK_M3_SSP0_STAT;           /*!< (@ 0x4005151C) CLK_M3_SSP0 clock status register */
  __IO uint32_t CLK_M3_TIMER0_CFG;          /*!< (@ 0x40051520) CLK_M3_TIMER0 clock configuration register */
  __I  uint32_t CLK_M3_TIMER0_STAT;         /*!< (@ 0x40051524) CLK_M3_TIMER0 clock status register */
  __IO uint32_t CLK_M3_TIMER1_CFG;          /*!< (@ 0x40051528) CLK_M3_TIMER1clock configuration register */
  __I  uint32_t CLK_M3_TIMER1_STAT;         /*!< (@ 0x4005152C) CLK_M3_TIMER1 clock status register */
  __IO uint32_t CLK_M3_SCU_CFG;             /*!< (@ 0x40051530) CLK_M3_SCU clock configuration register */
  __I  uint32_t CLK_M3_SCU_STAT;            /*!< (@ 0x40051534) CLK_SCU_XXX clock status register */
  __IO uint32_t CLK_M3_CREG_CFG;            /*!< (@ 0x40051538) CLK_M3_CREGclock configuration register */
  __I  uint32_t CLK_M3_CREG_STAT;           /*!< (@ 0x4005153C) CLK_M3_CREG clock status register */
  __I  uint32_t  RESERVED6[48];
  __IO uint32_t CLK_M3_RITIMER_CFG;         /*!< (@ 0x40051600) CLK_M3_RITIMER clock configuration register */
  __I  uint32_t CLK_M3_RITIMER_STAT;        /*!< (@ 0x40051604) CLK_M3_RITIMER clock status register */
  __IO uint32_t CLK_M3_USART2_CFG;          /*!< (@ 0x40051608) CLK_M3_USART2 clock configuration register */
  __I  uint32_t CLK_M3_USART2_STAT;         /*!< (@ 0x4005160C) CLK_M3_USART2 clock status register */
  __IO uint32_t CLK_M3_USART3_CFG;          /*!< (@ 0x40051610) CLK_M3_USART3 clock configuration register */
  __I  uint32_t CLK_M3_USART3_STAT;         /*!< (@ 0x40051614) CLK_M3_USART3 clock status register */
  __IO uint32_t CLK_M3_TIMER2_CFG;          /*!< (@ 0x40051618) CLK_M3_TIMER2 clock configuration register */
  __I  uint32_t CLK_M3_TIMER2_STAT;         /*!< (@ 0x4005161C) CLK_M3_TIMER2 clock status register */
  __IO uint32_t CLK_M3_TIMER3_CFG;          /*!< (@ 0x40051620) CLK_M3_TIMER3 clock configuration register */
  __I  uint32_t CLK_M3_TIMER3_STAT;         /*!< (@ 0x40051624) CLK_M3_TIMER3 clock status register */
  __IO uint32_t CLK_M3_SSP1_CFG;            /*!< (@ 0x40051628) CLK_M3_SSP1 clock configuration register */
  __I  uint32_t CLK_M3_SSP1_STAT;           /*!< (@ 0x4005162C) CLK_M3_SSP1 clock status register */
  __IO uint32_t CLK_M3_QEI_CFG;             /*!< (@ 0x40051630) CLK_M3_QEIclock configuration register */
  __I  uint32_t CLK_M3_QEI_STAT;            /*!< (@ 0x40051634) CLK_M3_QEI clock status register */
  __I  uint32_t  RESERVED7[114];
  __IO uint32_t CLK_USB0_CFG;               /*!< (@ 0x40051800) CLK_M3_USB0 clock configuration register */
  __I  uint32_t CLK_USB0_STAT;              /*!< (@ 0x40051804) CLK_USB0 clock status register */
  __I  uint32_t RESERVED8[62];
  __IO uint32_t CLK_USB1_CFG;               /*!< (@ 0x40051900) CLK_USB1 clock configuration register */
  __I  uint32_t CLK_USB1_STAT;              /*!< (@ 0x40051904) CLK_USB1 clock status register */
  __I  uint32_t RESERVED9[126];
  __IO uint32_t CLK_VADC_CFG;               /*!< (@ 0x40051B00) CLK_VADC clock configuration register */
  __I  uint32_t CLK_VADC_STAT;              /*!< (@ 0x40051B04) CLK_VADC clock status register */
} LPC_CCU1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CCU2                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Clock Control Unit (CCU) Modification date=1/21/2011 Major revision=0 Minor revision=7  (CCU2)
  */

typedef struct {                            /*!< (@ 0x40052000) CCU2 Structure         */
  __IO uint32_t PM;                         /*!< (@ 0x40052000) Power mode register    */
  __I  uint32_t BASE_STAT;                  /*!< (@ 0x40052004) CCU base clocks status register */
  __I  uint32_t RESERVED0[62];
  __IO uint32_t CLK_APLL_CFG;               /*!< (@ 0x40052100) CLK_APLL clock configuration register */
  __I  uint32_t CLK_APLL_STAT;              /*!< (@ 0x40052104) CLK_APLL clock status register */
  __I  uint32_t RESERVED1[62];
  __IO uint32_t CLK_APB2_USART3_CFG;        /*!< (@ 0x40052200) CLK_APB2_USART3 clock configuration register */
  __I  uint32_t CLK_APB2_USART3_STAT;       /*!< (@ 0x40052204) CLK_APB2_USART3 clock status register */
  __I  uint32_t RESERVED2[62];
  __IO uint32_t CLK_APB2_USART2_CFG;        /*!< (@ 0x40052300) CLK_APB2_USART2 clock configuration register */
  __I  uint32_t CLK_APB2_USART2_STAT;       /*!< (@ 0x40052304) CLK_APB2_USART clock status register */
  __I  uint32_t RESERVED3[62];
  __IO uint32_t CLK_APB0_UART1_CFG;         /*!< (@ 0x40052400) CLK_APB2_UART1 clock configuration register */
  __I  uint32_t CLK_APB0_UART1_STAT;        /*!< (@ 0x40052404) CLK_APB0_UART1 clock status register */
  __I  uint32_t RESERVED4[62];
  __IO uint32_t CLK_APB0_USART0_CFG;        /*!< (@ 0x40052500) CLK_APB2_USART0 clock configuration register */
  __I  uint32_t CLK_APB0_USART0_STAT;       /*!< (@ 0x40052504) CLK_APB0_USART0 clock status register */
  __I  uint32_t RESERVED5[62];
  __IO uint32_t CLK_APB2_SSP1_CFG;          /*!< (@ 0x40052600) CLK_APB2_SSP1 clock configuration register */
  __I  uint32_t CLK_APB2_SSP1_STAT;         /*!< (@ 0x40052604) CLK_APB2_SSP1 clock status register */
  __I  uint32_t RESERVED6[62];
  __IO uint32_t CLK_APB0_SSP0_CFG;          /*!< (@ 0x40052700) CLK_APB0_SSP0 clock configuration register */
  __I  uint32_t CLK_APB0_SSP0_STAT;         /*!< (@ 0x40052704) CLK_APB0_SSP0 clock status register */
  __I  uint32_t RESERVED7[62];
  __IO uint32_t CLK_SDIO_CFG;               /*!< (@ 0x40052800) CLK_SDIO clock configuration register */
  __I  uint32_t CLK_SDIO_STAT;              /*!< (@ 0x40052804) CLK_SDIO clock status register */
} LPC_CCU2_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          RGU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Reset GenerationUnit (RGU) Modification date=7/20/2011 Major revision=0 Minor revision=13  (RGU)
  */

typedef struct {                            /*!< (@ 0x40053000) RGU Structure          */
  __I  uint32_t RESERVED0[64];
  __O  uint32_t RESET_CTRL0;                /*!< (@ 0x40053100) Reset control register 0 */
  __O  uint32_t RESET_CTRL1;                /*!< (@ 0x40053104) Reset control register 1 */
  __I  uint32_t RESERVED1[2];
  __IO uint32_t RESET_STATUS0;              /*!< (@ 0x40053110) Reset status register 0 */
  __IO uint32_t RESET_STATUS1;              /*!< (@ 0x40053114) Reset status register 1 */
  __IO uint32_t RESET_STATUS2;              /*!< (@ 0x40053118) Reset status register 2 */
  __IO uint32_t RESET_STATUS3;              /*!< (@ 0x4005311C) Reset status register 3 */
  __I  uint32_t RESERVED2[12];
  __I  uint32_t RESET_ACTIVE_STATUS0;       /*!< (@ 0x40053150) Reset active status register 0 */
  __I  uint32_t RESET_ACTIVE_STATUS1;       /*!< (@ 0x40053154) Reset active status register 1 */
  __I  uint32_t RESERVED3[170];
  __IO uint32_t RESET_EXT_STAT0;            /*!< (@ 0x40053400) Reset external status register 0 for CORE_RST */
  __IO uint32_t RESET_EXT_STAT1;            /*!< (@ 0x40053404) Reset external status register 1 for PERIPH_RST */
  __IO uint32_t RESET_EXT_STAT2;            /*!< (@ 0x40053408) Reset external status register 2 for MASTER_RST */
  __I  uint32_t RESERVED4;
  __IO uint32_t RESET_EXT_STAT4;            /*!< (@ 0x40053410) Reset external status register 4 for WWDT_RST */
  __IO uint32_t RESET_EXT_STAT5;            /*!< (@ 0x40053414) Reset external status register 5 for CREG_RST */
  __I  uint32_t RESERVED5[2];
  __IO uint32_t RESET_EXT_STAT8;            /*!< (@ 0x40053420) Reset external status register */
  __IO uint32_t RESET_EXT_STAT9;            /*!< (@ 0x40053424) Reset external status register */
  __I  uint32_t RESERVED6[3];
  __IO uint32_t RESET_EXT_STAT13;           /*!< (@ 0x40053434) Reset external status register */
  __I  uint32_t RESERVED7[2];
  __IO uint32_t RESET_EXT_STAT16;           /*!< (@ 0x40053440) Reset external status register */
  __IO uint32_t RESET_EXT_STAT17;           /*!< (@ 0x40053444) Reset external status register */
  __IO uint32_t RESET_EXT_STAT18;           /*!< (@ 0x40053448) Reset external status register */
  __IO uint32_t RESET_EXT_STAT19;           /*!< (@ 0x4005344C) Reset external status register */
  __IO uint32_t RESET_EXT_STAT20;           /*!< (@ 0x40053450) Reset external status register */
  __IO uint32_t RESET_EXT_STAT21;           /*!< (@ 0x40053454) Reset external status register */
  __IO uint32_t RESET_EXT_STAT22;           /*!< (@ 0x40053458) Reset external status register */
  __IO uint32_t RESET_EXT_STAT23;           /*!< (@ 0x4005345C) Reset external status register */
  __I  uint32_t RESERVED8[4];
  __IO uint32_t RESET_EXT_STAT28;           /*!< (@ 0x40053470) Reset external status register */
  __I  uint32_t RESERVED9[3];
  __IO uint32_t RESET_EXT_STAT32;           /*!< (@ 0x40053480) Reset external status register */
  __IO uint32_t RESET_EXT_STAT33;           /*!< (@ 0x40053484) Reset external status register */
  __IO uint32_t RESET_EXT_STAT34;           /*!< (@ 0x40053488) Reset external status register */
  __IO uint32_t RESET_EXT_STAT35;           /*!< (@ 0x4005348C) Reset external status register */
  __IO uint32_t RESET_EXT_STAT36;           /*!< (@ 0x40053490) Reset external status register */
  __IO uint32_t RESET_EXT_STAT37;           /*!< (@ 0x40053494) Reset external status register */
  __IO uint32_t RESET_EXT_STAT38;           /*!< (@ 0x40053498) Reset external status register */
  __IO uint32_t RESET_EXT_STAT39;           /*!< (@ 0x4005349C) Reset external status register */
  __IO uint32_t RESET_EXT_STAT40;           /*!< (@ 0x400534A0) Reset external status register */
  __IO uint32_t RESET_EXT_STAT41;           /*!< (@ 0x400534A4) Reset external status register */
  __IO uint32_t RESET_EXT_STAT42;           /*!< (@ 0x400534A8) Reset external status register */
  __I  uint32_t RESERVED10;
  __IO uint32_t RESET_EXT_STAT44;           /*!< (@ 0x400534B0) Reset external status register */
  __IO uint32_t RESET_EXT_STAT45;           /*!< (@ 0x400534B4) Reset external status register */
  __IO uint32_t RESET_EXT_STAT46;           /*!< (@ 0x400534B8) Reset external status register */
  __IO uint32_t RESET_EXT_STAT47;           /*!< (@ 0x400534BC) Reset external status register */
  __IO uint32_t RESET_EXT_STAT48;           /*!< (@ 0x400534C0) Reset external status register */
  __IO uint32_t RESET_EXT_STAT49;           /*!< (@ 0x400534C4) Reset external status register */
  __IO uint32_t RESET_EXT_STAT50;           /*!< (@ 0x400534C8) Reset external status register */
  __IO uint32_t RESET_EXT_STAT51;           /*!< (@ 0x400534CC) Reset external status register */
  __IO uint32_t RESET_EXT_STAT52;           /*!< (@ 0x400534D0) Reset external status register */
  __IO uint32_t RESET_EXT_STAT53;           /*!< (@ 0x400534D4) Reset external status register */
  __IO uint32_t  RESET_EXT_STAT54;          /*!< (@ 0x400534D8) Reset external status register */
  __IO uint32_t RESET_EXT_STAT55;           /*!< (@ 0x400534DC) Reset external status register */
} LPC_RGU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         WWDT                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Windowed Watchdog timer (WWDT) Modification date=1/14/2011 Major revision=0 Minor revision=7  (WWDT)
  */

typedef struct {                            /*!< (@ 0x40080000) WWDT Structure         */
  __IO uint32_t MOD;                        /*!< (@ 0x40080000) Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer. */
  __IO uint32_t TC;                         /*!< (@ 0x40080004) Watchdog timer constant register. This register determines the time-out value. */
  __O  uint32_t FEED;                       /*!< (@ 0x40080008) Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC. */
  __I  uint32_t TV;                         /*!< (@ 0x4008000C) Watchdog timer value register. This register reads out the current value of the Watchdog timer. */
  __I  uint32_t RESERVED0;
  __IO uint32_t WARNINT;                    /*!< (@ 0x40080014) Watchdog warning interrupt register. This register contains the Watchdog warning interrupt compare value. */
  __IO uint32_t WINDOW;                     /*!< (@ 0x40080018) Watchdog timer window register. This register contains the Watchdog window value. */
} LPC_WWDT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        USARTn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USART0_2_3 Modification date=1/14/2011 Major revision=0 Minor revision=7  (USARTn)
  */

typedef struct {                            /*!< (@ 0x400xx000) USARTn Structure       */

  union {
    __IO uint32_t DLL;                      /*!< (@ 0x400xx000) Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB = 1). */
    __O  uint32_t THR;                      /*!< (@ 0x400xx000) Transmit Holding Register. The next character to be transmitted is written here (DLAB = 0). */
    __I  uint32_t RBR;                      /*!< (@ 0x400xx000) Receiver Buffer Register. Contains the next received character to be read (DLAB = 0). */
  };

  union {
    __IO uint32_t IER;                      /*!< (@ 0x400xx004) Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART interrupts (DLAB = 0). */
    __IO uint32_t DLM;                      /*!< (@ 0x400xx004) Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB = 1). */
  };

  union {
    __O  uint32_t FCR;                      /*!< (@ 0x400xx008) FIFO Control Register. Controls UART FIFO usage and modes. */
    __I  uint32_t IIR;                      /*!< (@ 0x400xx008) Interrupt ID Register. Identifies which interrupt(s) are pending. */
  };
  __IO uint32_t LCR;                        /*!< (@ 0x400xx00C) Line Control Register. Contains controls for frame formatting and break generation. */
  __I  uint32_t RESERVED0[1];
  __I  uint32_t LSR;                        /*!< (@ 0x400xx014) Line Status Register. Contains flags for transmit and receive status, including line errors. */
  __I  uint32_t RESERVED1[1];
  __IO uint32_t SCR;                        /*!< (@ 0x400xx01C) Scratch Pad Register. Eight-bit temporary storage for software. */
  __IO uint32_t ACR;                        /*!< (@ 0x400xx020) Auto-baud Control Register. Contains controls for the auto-baud feature. */
  __IO uint32_t ICR;                        /*!< (@ 0x400xx024) IrDA control register (UART3 only) */
  __IO uint32_t FDR;                        /*!< (@ 0x400xx028) Fractional Divider Register. Generates a clock input for the baud rate divider. */
  __IO uint32_t OSR;                        /*!< (@ 0x400xx02C) Oversampling Register. Controls the degree of oversampling during each bit time. */
  __I  uint32_t RESERVED2[4];
  __IO uint32_t HDEN;                       /*!< (@ 0x400xx03C) Half-duplex enable Register */
  __I  uint32_t RESERVED3[1];
  __IO uint32_t SCICTRL;                    /*!< (@ 0x400xx048) Smart card interface control register */
  __IO uint32_t RS485CTRL;                  /*!< (@ 0x400xx04C) RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes. */
  __IO uint32_t RS485ADRMATCH;              /*!< (@ 0x400xx050) RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode. */
  __IO uint32_t RS485DLY;                   /*!< (@ 0x400xx054) RS-485/EIA-485 direction control delay. */
  __IO uint32_t SYNCCTRL;                   /*!< (@ 0x400xx058) Synchronous mode control register. */
  __IO uint32_t TER;                        /*!< (@ 0x400xx05C) Transmit Enable Register. Turns off UART transmitter for use with software flow control. */
} LPC_USARTn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         UART1                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx UART1 Modification date=1/14/2011 Major revision=0 Minor revision=7  (UART1)
  */

typedef struct {                            /*!< (@ 0x40082000) UART1 Structure        */

  union {
    __IO uint32_t DLL;                      /*!< (@ 0x40082000) Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1) */
    __O  uint32_t THR;                      /*!< (@ 0x40082000) Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0) */
    __I  uint32_t RBR;                      /*!< (@ 0x40082000) Receiver Buffer Register. Contains the next received character to be read. (DLAB=0) */
  };

  union {
    __IO uint32_t IER;                      /*!< (@ 0x40082004) Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART1 interrupts. (DLAB=0) */
    __IO uint32_t DLM;                      /*!< (@ 0x40082004) Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.(DLAB=1) */
  };

  union {
    __O  uint32_t FCR;                      /*!< (@ 0x40082008) FIFO Control Register. Controls UART1 FIFO usage and modes. */
    __I  uint32_t IIR;                      /*!< (@ 0x40082008) Interrupt ID Register. Identifies which interrupt(s) are pending. */
  };
  __IO uint32_t LCR;                        /*!< (@ 0x4008200C) Line Control Register. Contains controls for frame formatting and break generation. */
  __IO uint32_t MCR;                        /*!< (@ 0x40082010) Modem Control Register. Contains controls for flow control handshaking and loopback mode. */
  __I  uint32_t LSR;                        /*!< (@ 0x40082014) Line Status Register. Contains flags for transmit and receive status, including line errors. */
  __I  uint32_t MSR;                        /*!< (@ 0x40082018) Modem Status Register. Contains handshake signal status flags. */
  __IO uint32_t SCR;                        /*!< (@ 0x4008201C) Scratch Pad Register. 8-bit temporary storage for software. */
  __IO uint32_t ACR;                        /*!< (@ 0x40082020) Auto-baud Control Register. Contains controls for the auto-baud feature. */
  __I  uint32_t  RESERVED0;
  __IO uint32_t FDR;                        /*!< (@ 0x40082028) Fractional Divider Register. Generates a clock input for the baud rate divider. */
  __I  uint32_t  RESERVED1;
  __IO uint32_t TER;                        /*!< (@ 0x40082030) Transmit Enable Register. Turns off UART transmitter for use with software flow control. */
  __I  uint32_t RESERVED2[6];
  __IO uint32_t RS485CTRL;                  /*!< (@ 0x4008204C) RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes. */
  __IO uint32_t RS485ADRMATCH;              /*!< (@ 0x40082050) RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode. */
  __IO uint32_t RS485DLY;                   /*!< (@ 0x40082054) RS-485/EIA-485 direction control delay. */
  __I  uint32_t FIFOLVL;                    /*!< (@ 0x40082058) FIFO Level register. Provides the current fill levels of the transmit and receive FIFOs.  */
} LPC_UART1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         SSPn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx SSP0/1 Modification date=1/14/2011 Major revision=0 Minor revision=7  (SSP0)
  */

typedef struct {                            /*!< (@ 0x400xx000) SSPn Structure         */
  __IO uint32_t CR0;                        /*!< (@ 0x400xx000) Control Register 0. Selects the serial clock rate, bus type, and data size. */
  __IO uint32_t CR1;                        /*!< (@ 0x400xx004) Control Register 1. Selects master/slave and other modes. */
  __IO uint32_t DR;                         /*!< (@ 0x400xx008) Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO. */
  __I  uint32_t SR;                         /*!< (@ 0x400xx00C) Status Register        */
  __IO uint32_t CPSR;                       /*!< (@ 0x400xx010) Clock Prescale Register */
  __IO uint32_t IMSC;                       /*!< (@ 0x400xx014) Interrupt Mask Set and Clear Register */
  __I  uint32_t RIS;                        /*!< (@ 0x400xx018) Raw Interrupt Status Register */
  __I  uint32_t MIS;                        /*!< (@ 0x400xx01C) Masked Interrupt Status Register */
  __O  uint32_t ICR;                        /*!< (@ 0x400xx020) SSPICR Interrupt Clear Register */
  __IO uint32_t DMACR;                      /*!< (@ 0x400xx024) SSPn DMA control register */
} LPC_SSPn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        TIMERn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Timer0/1/2/3 Modification date=1/14/2011 Major revision=0 Minor revision=7  (TIMERn)
  */

typedef struct {                            /*!< (@ 0x400xx000) TIMERn Structure       */
  __IO uint32_t IR;                         /*!< (@ 0x400xx000) Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending. */
  __IO uint32_t TCR;                        /*!< (@ 0x400xx004) Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR. */
  __IO uint32_t TC;                         /*!< (@ 0x400xx008) Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR. */
  __IO uint32_t PR;                         /*!< (@ 0x400xx00C) Prescale Register. The Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC. */
  __IO uint32_t PC;                         /*!< (@ 0x400xx010) Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface. */
  __IO uint32_t MCR;                        /*!< (@ 0x400xx014) Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs. */
  __IO uint32_t MR[4];                      /*!< (@ 0x400xx018) Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC. */
  __IO uint32_t CCR;                        /*!< (@ 0x400xx028) Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place. */
  __IO uint32_t CR[4];                      /*!< (@ 0x400xx02C) Capture Register. CR is loaded with the value of TC when there is an event on the CAPn.0 input. */
  __IO uint32_t EMR;                        /*!< (@ 0x400xx03C) External Match Register. The EMR controls the external match pins MATn.0-3 (MAT0.0-3 and MAT1.0-3 respectively). */
  __I  uint32_t RESERVED0[12];
  __IO uint32_t CTCR;                       /*!< (@ 0x400xx070) Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting. */
} LPC_TIMERn_Type;




// ------------------------------------------------------------------------------------------------
// -----                                          SCU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx System Control Unit (SCU) Modification date=6/8/2011 Major revision=0 Minor revision=10  (SCU)
  */

typedef struct {                            /*!< (@ 0x40086000) SCU Structure          */
  __IO uint32_t SFSP0_0;                   /*!< (@ 0x40086000) Pin configuration register for pins P0 */
  __IO uint32_t SFSP0_1;                   /*!< (@ 0x40086004) Pin configuration register for pins P0 */
  __I  uint32_t RESERVED0[30];
  __IO uint32_t SFSP1_0;                    /*!< (@ 0x40086080) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_1;                    /*!< (@ 0x40086084) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_2;                    /*!< (@ 0x40086088) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_3;                    /*!< (@ 0x4008608C) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_4;                    /*!< (@ 0x40086090) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_5;                    /*!< (@ 0x40086094) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_6;                    /*!< (@ 0x40086098) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_7;                    /*!< (@ 0x4008609C) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_8;                    /*!< (@ 0x400860A0) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_9;                    /*!< (@ 0x400860A4) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_10;                   /*!< (@ 0x400860A8) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_11;                   /*!< (@ 0x400860AC) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_12;                   /*!< (@ 0x400860B0) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_13;                   /*!< (@ 0x400860B4) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_14;                   /*!< (@ 0x400860B8) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_15;                   /*!< (@ 0x400860BC) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_16;                   /*!< (@ 0x400860C0) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_17;                   /*!< (@ 0x400860C4) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_18;                   /*!< (@ 0x400860C8) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_19;                   /*!< (@ 0x400860CC) Pin configuration register for pins P1 */
  __IO uint32_t SFSP1_20;                   /*!< (@ 0x400860D0) Pin configuration register for pins P1 */
  __I  uint32_t RESERVED1[11];
  __IO uint32_t SFSP2_0;                    /*!< (@ 0x40086100) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_1;                    /*!< (@ 0x40086104) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_2;                    /*!< (@ 0x40086108) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_3;                    /*!< (@ 0x4008610C) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_4;                    /*!< (@ 0x40086110) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_5;                    /*!< (@ 0x40086114) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_6;                    /*!< (@ 0x40086118) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_7;                    /*!< (@ 0x4008611C) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_8;                    /*!< (@ 0x40086120) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_9;                    /*!< (@ 0x40086124) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_10;                   /*!< (@ 0x40086128) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_11;                   /*!< (@ 0x4008612C) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_12;                   /*!< (@ 0x40086130) Pin configuration register for pins P2 */
  __IO uint32_t SFSP2_13;                   /*!< (@ 0x40086134) Pin configuration register for pins P2 */
  __I  uint32_t RESERVED2[18];
  __IO uint32_t SFSP3_0;                  	/*!< (@ 0x40086180) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_1;                  	/*!< (@ 0x40086184) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_2;                  	/*!< (@ 0x40086188) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_3;                  	/*!< (@ 0x4008618C) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_4;                  	/*!< (@ 0x40086190) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_5;                  	/*!< (@ 0x40086194) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_6;                  	/*!< (@ 0x40086198) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_7;                  	/*!< (@ 0x4008619C) Pin configuration register for pins P3 */
  __IO uint32_t SFSP3_8;                  	/*!< (@ 0x400861A0) Pin configuration register for pins P3 */
  __I  uint32_t RESERVED3[23];
  __IO uint32_t SFSP4_0;                    /*!< (@ 0x40086200) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_1;                    /*!< (@ 0x40086204) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_2;                    /*!< (@ 0x40086208) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_3;                    /*!< (@ 0x4008620C) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_4;                    /*!< (@ 0x40086210) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_5;                    /*!< (@ 0x40086214) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_6;                    /*!< (@ 0x40086218) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_7;                    /*!< (@ 0x4008621C) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_8;                    /*!< (@ 0x40086220) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_9;                    /*!< (@ 0x40086224) Pin configuration register for pins P4 */
  __IO uint32_t SFSP4_10;                   /*!< (@ 0x40086228) Pin configuration register for pins P4 */
  __I  uint32_t RESERVED4[21];
  __IO uint32_t SFSP5_0;                  	/*!< (@ 0x40086280) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_1;                  	/*!< (@ 0x40086284) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_2;                  	/*!< (@ 0x40086288) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_3;                  	/*!< (@ 0x4008628C) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_4;                  	/*!< (@ 0x40086290) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_5;                  	/*!< (@ 0x40086294) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_6;                  	/*!< (@ 0x40086298) Pin configuration register for pins P5 */
  __IO uint32_t SFSP5_7;                  	/*!< (@ 0x4008629C) Pin configuration register for pins P5 */
  __I  uint32_t RESERVED5[24];
  __IO uint32_t SFSP6_0;                    /*!< (@ 0x40086300) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_1;                    /*!< (@ 0x40086304) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_2;                    /*!< (@ 0x40086308) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_3;                    /*!< (@ 0x4008630C) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_4;                    /*!< (@ 0x40086310) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_5;                    /*!< (@ 0x40086314) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_6;                    /*!< (@ 0x40086318) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_7;                    /*!< (@ 0x4008631C) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_8;                    /*!< (@ 0x40086320) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_9;                    /*!< (@ 0x40086324) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_10;                   /*!< (@ 0x40086328) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_11;                   /*!< (@ 0x4008632C) Pin configuration register for pins P6 */
  __IO uint32_t SFSP6_12;                   /*!< (@ 0x40086330) Pin configuration register for pins P6 */
  __I  uint32_t RESERVED6[19];
  __IO uint32_t SFSP7_0;                  	/*!< (@ 0x40086380) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_1;                  	/*!< (@ 0x40086384) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_2;                  	/*!< (@ 0x40086388) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_3;                  	/*!< (@ 0x4008638C) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_4;                  	/*!< (@ 0x40086390) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_5;                  	/*!< (@ 0x40086394) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_6;                  	/*!< (@ 0x40086398) Pin configuration register for pins P7 */
  __IO uint32_t SFSP7_7;                  	/*!< (@ 0x4008639C) Pin configuration register for pins P7 */
  __I  uint32_t RESERVED7[24];
  __IO uint32_t SFSP8_0;                  	/*!< (@ 0x40086400) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_1;                  	/*!< (@ 0x40086404) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_2;                  	/*!< (@ 0x40086408) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_3;                  	/*!< (@ 0x4008640C) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_4;                  	/*!< (@ 0x40086410) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_5;                  	/*!< (@ 0x40086414) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_6;                  	/*!< (@ 0x40086418) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_7;                  	/*!< (@ 0x4008641C) Pin configuration register for pins P8 */
  __IO uint32_t SFSP8_8;                  	/*!< (@ 0x40086420) Pin configuration register for pins P8 */
  __I  uint32_t RESERVED8[23];
  __IO uint32_t SFSP9_0;                  	/*!< (@ 0x40086480) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_1;                  	/*!< (@ 0x40086484) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_2;                  	/*!< (@ 0x40086488) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_3;                  	/*!< (@ 0x4008648C) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_4;                  	/*!< (@ 0x40086490) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_5;                  	/*!< (@ 0x40086494) Pin configuration register for pins P9 */
  __IO uint32_t SFSP9_6;                  	/*!< (@ 0x40086498) Pin configuration register for pins P9 */
  __I  uint32_t RESERVED9[25];
  __IO uint32_t SFSPA_0;                  	/*!< (@ 0x40086500) Pin configuration register for pins PA */
  __IO uint32_t SFSPA_1;                  	/*!< (@ 0x40086504) Pin configuration register for pins PA */
  __IO uint32_t SFSPA_2;                  	/*!< (@ 0x40086508) Pin configuration register for pins PA */
  __IO uint32_t SFSPA_3;                  	/*!< (@ 0x4008650C) Pin configuration register for pins PA */
  __IO uint32_t SFSPA_4;                  	/*!< (@ 0x40086510) Pin configuration register for pins PA */
  __I  uint32_t RESERVED10[27];
  __IO uint32_t SFSPB_0;                  	/*!< (@ 0x40086580) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_1;                  	/*!< (@ 0x40086584) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_2;                  	/*!< (@ 0x40086588) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_3;                  	/*!< (@ 0x4008658C) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_4;                  	/*!< (@ 0x40086590) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_5;                  	/*!< (@ 0x40086594) Pin configuration register for pins PB */
  __IO uint32_t SFSPB_6;                  	/*!< (@ 0x40086598) Pin configuration register for pins PB */
  __I  uint32_t RESERVED11[25];
  __IO uint32_t SFSPC_0;                    /*!< (@ 0x40086600) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_1;                    /*!< (@ 0x40086604) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_2;                    /*!< (@ 0x40086608) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_3;                    /*!< (@ 0x4008660C) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_4;                    /*!< (@ 0x40086610) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_5;                    /*!< (@ 0x40086614) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_6;                    /*!< (@ 0x40086618) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_7;                    /*!< (@ 0x4008661C) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_8;                    /*!< (@ 0x40086620) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_9;                    /*!< (@ 0x40086624) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_10;                   /*!< (@ 0x40086628) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_11;                   /*!< (@ 0x4008662C) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_12;                   /*!< (@ 0x40086630) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_13;                   /*!< (@ 0x40086634) Pin configuration register for pins PC */
  __IO uint32_t SFSPC_14;                   /*!< (@ 0x40086638) Pin configuration register for pins PC */
  __I  uint32_t RESERVED12[17];
  __IO uint32_t SFSPD_0;                    /*!< (@ 0x40086680) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_1;                    /*!< (@ 0x40086684) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_2;                    /*!< (@ 0x40086688) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_3;                    /*!< (@ 0x4008668C) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_4;                    /*!< (@ 0x40086690) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_5;                    /*!< (@ 0x40086694) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_6;                    /*!< (@ 0x40086698) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_7;                    /*!< (@ 0x4008669C) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_8;                    /*!< (@ 0x400866A0) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_9;                    /*!< (@ 0x400866A4) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_10;                   /*!< (@ 0x400866A8) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_11;                   /*!< (@ 0x400866AC) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_12;                   /*!< (@ 0x400866B0) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_13;                   /*!< (@ 0x400866B4) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_14;                   /*!< (@ 0x400866B8) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_15;                   /*!< (@ 0x400866BC) Pin configuration register for pins PD */
  __IO uint32_t SFSPD_16;                   /*!< (@ 0x400866C0) Pin configuration register for pins PD */
  __I  uint32_t RESERVED13[15];
  __IO uint32_t SFSPE_0;                    /*!< (@ 0x40086700) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_1;                    /*!< (@ 0x40086704) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_2;                    /*!< (@ 0x40086708) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_3;                    /*!< (@ 0x4008670C) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_4;                    /*!< (@ 0x40086710) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_5;                    /*!< (@ 0x40086714) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_6;                    /*!< (@ 0x40086718) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_7;                    /*!< (@ 0x4008671C) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_8;                    /*!< (@ 0x40086720) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_9;                    /*!< (@ 0x40086724) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_10;                   /*!< (@ 0x40086728) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_11;                   /*!< (@ 0x4008672C) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_12;                   /*!< (@ 0x40086730) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_13;                   /*!< (@ 0x40086734) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_14;                   /*!< (@ 0x40086738) Pin configuration register for pins PE */
  __IO uint32_t SFSPE_15;                   /*!< (@ 0x4008673C) Pin configuration register for pins PE */
  __I  uint32_t RESERVED14[16];
  __IO uint32_t SFSPF_0;                    /*!< (@ 0x40086780) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_1;                    /*!< (@ 0x40086784) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_2;                    /*!< (@ 0x40086788) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_3;                    /*!< (@ 0x4008678C) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_4;                    /*!< (@ 0x40086790) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_5;                    /*!< (@ 0x40086794) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_6;                    /*!< (@ 0x40086798) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_7;                    /*!< (@ 0x4008679C) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_8;                    /*!< (@ 0x400867A0) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_9;                    /*!< (@ 0x400867A4) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_10;                   /*!< (@ 0x400867A8) Pin configuration register for pins PF */
  __IO uint32_t SFSPF_11;                   /*!< (@ 0x400867AC) Pin configuration register for pins PF */
  __I  uint32_t RESERVED15[276];
  __IO uint32_t SFSCLK_0;                   /*!< (@ 0x40086C00) Pin configuration register for pin CLK0 */
  __IO uint32_t SFSCLK_1;                   /*!< (@ 0x40086C04) Pin configuration register for pin CLK1 */
  __IO uint32_t SFSCLK_2;                   /*!< (@ 0x40086C08) Pin configuration register for pin CLK2 */
  __IO uint32_t SFSCLK_3;                   /*!< (@ 0x40086C0C) Pin configuration register for pin CLK3 */
  __I  uint32_t RESERVED16[28];
  __IO uint32_t SFSUSB;                     /*!< (@ 0x40086C80) Pin configuration register for */
  __IO uint32_t SFSI2C0;                    /*!< (@ 0x40086C84) Pin configuration register for I 2C0-bus pins */
  __IO uint32_t ENAIO0;                     /*!< (@ 0x40086C88) ADC0 function select register */
  __IO uint32_t ENAIO1;                     /*!< (@ 0x40086C8C) ADC1 function select register */
  __IO uint32_t ENAIO2;                     /*!< (@ 0x40086C90) Analog function select register */
  __I  uint32_t RESERVED17[27];
  __IO uint32_t  EMCDELAYCLK;               /*!< (@ 0x40086D00) EMC clock delay register */
  __I  uint32_t  RESERVED18[63];
  __IO uint32_t PINTSEL0;                   /*!< (@ 0x40086E00) Pin interrupt select register for pin interrupts 0 to 3. */
  __IO uint32_t PINTSEL1;                   /*!< (@ 0x40086E04) Pin interrupt select register for pin interrupts 4 to 7. */
} LPC_SCU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                     GPIO_PIN_INT                                     -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO pin interrupt (GPIO_PIN_INT)
  */

typedef struct {                            /*!< (@ 0x40087000) GPIO_PIN_INT Structure */
  __IO uint32_t  ISEL;                      /*!< (@ 0x40087000) Pin Interrupt Mode register */
  __IO uint32_t  IENR;                      /*!< (@ 0x40087004) Pin Interrupt Enable (Rising) register */
  __O  uint32_t  SIENR;                     /*!< (@ 0x40087008) Set Pin Interrupt Enable (Rising) register */
  __O  uint32_t  CIENR;                     /*!< (@ 0x4008700C) Clear Pin Interrupt Enable (Rising) register */
  __IO uint32_t  IENF;                      /*!< (@ 0x40087010) Pin Interrupt Enable Falling Edge / Active Level register */
  __O  uint32_t  SIENF;                     /*!< (@ 0x40087014) Set Pin Interrupt Enable Falling Edge / Active Level register */
  __O  uint32_t  CIENF;                     /*!< (@ 0x40087018) Clear Pin Interrupt Enable Falling Edge / Active Level address */
  __IO uint32_t  RISE;                      /*!< (@ 0x4008701C) Pin Interrupt Rising Edge register */
  __IO uint32_t  FALL;                      /*!< (@ 0x40087020) Pin Interrupt Falling Edge register */
  __IO uint32_t  IST;                       /*!< (@ 0x40087024) Pin Interrupt Status register */
} LPC_GPIO_PIN_INT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                    GPIO_GROUP_INTn                                   -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO group interrupt 0 (GPIO_GROUP_INTn)
  */

typedef struct {                            /*!< (@ 0x40088000) GPIO_GROUP_INTn Structure */
  __IO uint32_t  CTRL;                      /*!< (@ 0x40088000) GPIO grouped interrupt control register */
  __I  uint32_t  RESERVED0[7];
  __IO uint32_t  PORT_POL0;                 /*!< (@ 0x40088020) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL1;                 /*!< (@ 0x40088024) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL2;                 /*!< (@ 0x40088028) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL3;                 /*!< (@ 0x4008802C) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL4;                 /*!< (@ 0x40088030) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL5;                 /*!< (@ 0x40088034) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL6;                 /*!< (@ 0x40088038) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_POL7;                 /*!< (@ 0x4008803C) GPIO grouped interrupt port polarity register */
  __IO uint32_t  PORT_ENA0;                 /*!< (@ 0x40088040) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA1;                 /*!< (@ 0x40088044) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA2;                 /*!< (@ 0x40088048) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA3;                 /*!< (@ 0x4008804C) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA4;                 /*!< (@ 0x40088050) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA5;                 /*!< (@ 0x40088054) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA6;                 /*!< (@ 0x40088058) GPIO grouped interrupt port m enable register */
  __IO uint32_t  PORT_ENA7;                 /*!< (@ 0x4008805C) GPIO grouped interrupt port m enable register */
} LPC_GPIO_GROUP_INTn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         MCPWM                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Motor Control PWM (MOTOCONPWM) Modification date=1/14/2011 Major revision=0 Minor revision=7  (MCPWM)
  */

typedef struct {                            /*!< (@ 0x400A0000) MCPWM Structure        */
  __I  uint32_t CON;                        /*!< (@ 0x400A0000) PWM Control read address */
  __O  uint32_t CON_SET;                    /*!< (@ 0x400A0004) PWM Control set address */
  __O  uint32_t CON_CLR;                    /*!< (@ 0x400A0008) PWM Control clear address */
  __I  uint32_t CAPCON;                     /*!< (@ 0x400A000C) Capture Control read address */
  __O  uint32_t CAPCON_SET;                 /*!< (@ 0x400A0010) Capture Control set address */
  __O  uint32_t CAPCON_CLR;                 /*!< (@ 0x400A0014) Event Control clear address */
  __IO uint32_t TC[3];                      /*!< (@ 0x400A0018) Timer Counter register */
  __IO uint32_t LIM[3];                     /*!< (@ 0x400A0024) Limit register         */
  __IO uint32_t MAT[3];                     /*!< (@ 0x400A0030) Match register         */
  __IO uint32_t DT;                         /*!< (@ 0x400A003C) Dead time register     */
  __IO uint32_t CCP;                        /*!< (@ 0x400A0040) Communication Pattern register */
  __I  uint32_t CAP[3];                     /*!< (@ 0x400A0044) Capture register       */
  __I  uint32_t INTEN;                      /*!< (@ 0x400A0050) Interrupt Enable read address */
  __O  uint32_t INTEN_SET;                  /*!< (@ 0x400A0054) Interrupt Enable set address */
  __O  uint32_t INTEN_CLR;                  /*!< (@ 0x400A0058) Interrupt Enable clear address */
  __I  uint32_t CNTCON;                     /*!< (@ 0x400A005C) Count Control read address */
  __O  uint32_t CNTCON_SET;                 /*!< (@ 0x400A0060) Count Control set address */
  __O  uint32_t CNTCON_CLR;                 /*!< (@ 0x400A0064) Count Control clear address */
  __I  uint32_t INTF;                       /*!< (@ 0x400A0068) Interrupt flags read address */
  __O  uint32_t INTF_SET;                   /*!< (@ 0x400A006C) Interrupt flags set address */
  __O  uint32_t INTF_CLR;                   /*!< (@ 0x400A0070) Interrupt flags clear address */
  __O  uint32_t CAP_CLR;                    /*!< (@ 0x400A0074) Capture clear address  */
} LPC_MCPWM_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         I2C0                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx I2C0/1-bus interface Modification date=1/14/2011 Major revision=0 Minor revision=7  (I2Cn)
  */

typedef struct {                            /*!< (@ 0x400xx000) I2C0 Structure         */
  __IO uint32_t CONSET;                     /*!< (@ 0x400xx000) I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register. */
  __I  uint32_t STAT;                       /*!< (@ 0x400xx004) I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed. */
  __IO uint32_t DAT;                        /*!< (@ 0x400xx008) I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register. */
  __IO uint32_t ADR0;                       /*!< (@ 0x400xx00C) I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address. */
  __IO uint32_t SCLH;                       /*!< (@ 0x400xx010) SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock. */
  __IO uint32_t SCLL;                       /*!< (@ 0x400xx014) SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. SCLL and SCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode. */
  __O  uint32_t CONCLR;                     /*!< (@ 0x400xx018) I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register. */
  __IO uint32_t MMCTRL;                     /*!< (@ 0x400xx01C) Monitor mode control register. */
  __IO uint32_t ADR1;                       /*!< (@ 0x400xx020) I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address. */
  __IO uint32_t ADR2;                       /*!< (@ 0x400xx024) I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address. */
  __IO uint32_t ADR3;                       /*!< (@ 0x400xx028) I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address. */
  __I  uint32_t DATA_BUFFER;                /*!< (@ 0x400xx02C) Data buffer register. The contents of the 8 MSBs of the DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus. */
  __IO uint32_t MASK[4];                    /*!< (@ 0x400xx030) I2C Slave address mask register */
} LPC_I2Cn_Type;

// ------------------------------------------------------------------------------------------------
// -----                                         I2Sn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx I2S interface Modification date=1/14/2011 Major revision=0 Minor revision=7  (I2Sn)
    0x400A2000 / 0x400A3000
  */

typedef struct {                            /*!< (@ 0x400Ax000) I2S Structure         */
  __IO uint32_t DAO;                        /*!< (@ 0x400Ax000) I2S Digital Audio Output Register. Contains control bits for the I2S transmit channel. */
  __IO uint32_t DAI;                        /*!< (@ 0x400Ax004) I2S Digital Audio Input Register. Contains control bits for the I2S receive channel. */
  __O  uint32_t TXFIFO;                     /*!< (@ 0x400Ax008) I2S Transmit FIFO. Access register for the 8 x 32-bit transmitter FIFO. */
  __I  uint32_t RXFIFO;                     /*!< (@ 0x400Ax00C) I2S Receive FIFO. Access register for the 8 x 32-bit receiver FIFO. */
  __I  uint32_t STATE;                      /*!< (@ 0x400Ax010) I2S Status Feedback Register. Contains status information about the I2S interface. */
  __IO uint32_t DMA1;                       /*!< (@ 0x400Ax014) I2S DMA Configuration Register 1. Contains control information for DMA request 1. */
  __IO uint32_t DMA2;                       /*!< (@ 0x400Ax018) I2S DMA Configuration Register 2. Contains control information for DMA request 2. */
  __IO uint32_t IRQ;                        /*!< (@ 0x400Ax01C) I2S Interrupt Request Control Register. Contains bits that control how the I2S interrupt request is generated. */
  __IO uint32_t TXRATE;                     /*!< (@ 0x400Ax020) I2S Transmit MCLK divider. This register determines the I2S TX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK. */
  __IO uint32_t RXRATE;                     /*!< (@ 0x400Ax024) I2S Receive MCLK divider. This register determines the I2S RX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK. */
  __IO uint32_t TXBITRATE;                  /*!< (@ 0x400Ax028) I2S Transmit bit rate divider. This register determines the I2S transmit bit rate by specifying the value to divide TX_MCLK by in order to produce the transmit bit clock. */
  __IO uint32_t RXBITRATE;                  /*!< (@ 0x400Ax02C) I2S Receive bit rate divider. This register determines the I2S receive bit rate by specifying the value to divide RX_MCLK by in order to produce the receive bit clock. */
  __IO uint32_t TXMODE;                     /*!< (@ 0x400Ax030) I2S Transmit mode control. */
  __IO uint32_t RXMODE;                     /*!< (@ 0x400Ax034) I2S Receive mode control. */
} LPC_I2Sn_Type;

// ------------------------------------------------------------------------------------------------
// -----                                        C_CANn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx C_CAN Modification date=1/18/2011 Major revision=0 Minor revision=7  (C_CANn)
    0x400A4000 / 0x400E2000
  */

typedef struct {                            /*!< (@ 0x400E2000) C_CAN Structure       */
  __IO uint32_t CNTL;                       /*!< (@ 0x400E2000) CAN control            */
  __IO uint32_t STAT;                       /*!< (@ 0x400E2004) Status register        */
  __I  uint32_t EC;                         /*!< (@ 0x400E2008) Error counter          */
  __IO uint32_t BT;                         /*!< (@ 0x400E200C) Bit timing register    */
  __I  uint32_t INT;                        /*!< (@ 0x400E2010) Interrupt register     */
  __IO uint32_t TEST;                       /*!< (@ 0x400E2014) Test register          */
  __IO uint32_t BRPE;                       /*!< (@ 0x400E2018) Baud rate prescaler extension register */
  __I  uint32_t RESERVED0;
  __IO uint32_t IF1_CMDREQ;                 /*!< (@ 0x400E2020) Message interface command request  */

  union {
    __IO uint32_t IF1_CMDMSK_R;             /*!< (@ 0x400E2024) Message interface command mask (read direction) */
    __IO uint32_t IF1_CMDMSK_W;             /*!< (@ 0x400E2024) Message interface command mask (write direction) */
  };
  __IO uint32_t IF1_MSK1;                   /*!< (@ 0x400E2028) Message interface mask 1 */
  __IO uint32_t IF1_MSK2;                   /*!< (@ 0x400E202C) Message interface 1 mask 2 */
  __IO uint32_t IF1_ARB1;                   /*!< (@ 0x400E2030) Message interface 1 arbitration 1 */
  __IO uint32_t IF1_ARB2;                   /*!< (@ 0x400E2034) Message interface 1 arbitration 2 */
  __IO uint32_t IF1_MCTRL;                  /*!< (@ 0x400E2038) Message interface 1 message control */
  __IO uint32_t IF1_DA1;                    /*!< (@ 0x400E203C) Message interface data A1 */
  __IO uint32_t IF1_DA2;                    /*!< (@ 0x400E2040) Message interface 1 data A2 */
  __IO uint32_t IF1_DB1;                    /*!< (@ 0x400E2044) Message interface 1 data B1 */
  __IO uint32_t IF1_DB2;                    /*!< (@ 0x400E2048) Message interface 1 data B2 */
  __I  uint32_t RESERVED1[13];
  __IO uint32_t IF2_CMDREQ;                 /*!< (@ 0x400E2080) Message interface command request  */

  union {
    __IO uint32_t IF2_CMDMSK_R;             /*!< (@ 0x400E2084) Message interface command mask (read direction) */
    __IO uint32_t IF2_CMDMSK_W;             /*!< (@ 0x400E2084) Message interface command mask (write direction) */
  };
  __IO uint32_t IF2_MSK1;                   /*!< (@ 0x400E2088) Message interface mask 1 */
  __IO uint32_t IF2_MSK2;                   /*!< (@ 0x400E208C) Message interface 1 mask 2 */
  __IO uint32_t IF2_ARB1;                   /*!< (@ 0x400E2090) Message interface 1 arbitration 1 */
  __IO uint32_t IF2_ARB2;                   /*!< (@ 0x400E2094) Message interface 1 arbitration 2 */
  __IO uint32_t IF2_MCTRL;                  /*!< (@ 0x400E2098) Message interface 1 message control */
  __IO uint32_t IF2_DA1;                    /*!< (@ 0x400E209C) Message interface data A1 */
  __IO uint32_t IF2_DA2;                    /*!< (@ 0x400E20A0) Message interface 1 data A2 */
  __IO uint32_t IF2_DB1;                    /*!< (@ 0x400E20A4) Message interface 1 data B1 */
  __IO uint32_t IF2_DB2;                    /*!< (@ 0x400E20A8) Message interface 1 data B2 */
  __I  uint32_t RESERVED2[21];
  __I  uint32_t TXREQ1;                     /*!< (@ 0x400E2100) Transmission request 1 */
  __I  uint32_t TXREQ2;                     /*!< (@ 0x400E2104) Transmission request 2 */
  __I  uint32_t RESERVED3[6];
  __I  uint32_t ND1;                        /*!< (@ 0x400E2120) New data 1             */
  __I  uint32_t ND2;                        /*!< (@ 0x400E2124) New data 2             */
  __I  uint32_t RESERVED4[6];
  __I  uint32_t IR1;                        /*!< (@ 0x400E2140) Interrupt pending 1    */
  __I  uint32_t IR2;                        /*!< (@ 0x400E2144) Interrupt pending 2    */
  __I  uint32_t RESERVED5[6];
  __I  uint32_t MSGV1;                      /*!< (@ 0x400E2160) Message valid 1        */
  __I  uint32_t MSGV2;                      /*!< (@ 0x400E2164) Message valid 2        */
  __I  uint32_t RESERVED6[6];
  __IO uint32_t CLKDIV;                     /*!< (@ 0x400E2180) CAN clock divider register */
} LPC_C_CANn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        RITIMER                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Repetitive Interrupt Timer (RIT) Modification date=1/14/2011 Major revision=0 Minor revision=7  (RITIMER)
  */

typedef struct {                            /*!< (@ 0x400C0000) RITIMER Structure      */
  __IO uint32_t COMPVAL;                    /*!< (@ 0x400C0000) Compare register       */
  __IO uint32_t MASK;                       /*!< (@ 0x400C0004) Mask register. This register holds the 32-bit mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register. */
  __IO uint32_t CTRL;                       /*!< (@ 0x400C0008) Control register.      */
  __IO uint32_t COUNTER;                    /*!< (@ 0x400C000C) 32-bit counter         */
} LPC_RITIMER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          QEI                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Quadrature Encoder Interface (QEI) Modification date=1/18/2011 Major revision=0 Minor revision=7  (QEI)
  */

typedef struct {                            /*!< (@ 0x400C6000) QEI Structure          */
  __O  uint32_t CON;                        /*!< (@ 0x400C6000) Control register       */
  __I  uint32_t STAT;                       /*!< (@ 0x400C6004) Encoder status register */
  __IO uint32_t CONF;                       /*!< (@ 0x400C6008) Configuration register */
  __I  uint32_t POS;                        /*!< (@ 0x400C600C) Position register      */
  __IO uint32_t MAXPOS;                     /*!< (@ 0x400C6010) Maximum position register */
  __IO uint32_t CMPOS0;                     /*!< (@ 0x400C6014) position compare register 0 */
  __IO uint32_t CMPOS1;                     /*!< (@ 0x400C6018) position compare register 1 */
  __IO uint32_t CMPOS2;                     /*!< (@ 0x400C601C) position compare register 2 */
  __I  uint32_t INXCNT;                     /*!< (@ 0x400C6020) Index count register   */
  __IO uint32_t INXCMP0;                    /*!< (@ 0x400C6024) Index compare register 0 */
  __IO uint32_t LOAD;                       /*!< (@ 0x400C6028) Velocity timer reload register */
  __I  uint32_t TIME;                       /*!< (@ 0x400C602C) Velocity timer register */
  __I  uint32_t VEL;                        /*!< (@ 0x400C6030) Velocity counter register */
  __I  uint32_t CAP;                        /*!< (@ 0x400C6034) Velocity capture register */
  __IO uint32_t VELCOMP;                    /*!< (@ 0x400C6038) Velocity compare register */
  __IO uint32_t FILTERPHA;                  /*!< (@ 0x400C603C) Digital filter register on input phase A (QEI_A) */
  __IO uint32_t FILTERPHB;                  /*!< (@ 0x400C6040) Digital filter register on input phase B (QEI_B) */
  __IO uint32_t FILTERINX;                  /*!< (@ 0x400C6044) Digital filter register on input index (QEI_IDX) */
  __IO uint32_t WINDOW;                     /*!< (@ 0x400C6048) Index acceptance window register */
  __IO uint32_t INXCMP1;                    /*!< (@ 0x400C604C) Index compare register 1 */
  __IO uint32_t INXCMP2;                    /*!< (@ 0x400C6050) Index compare register 2 */
  __I  uint32_t RESERVED0[993];
  __O  uint32_t IEC;                        /*!< (@ 0x400C6FD8) Interrupt enable clear register */
  __O  uint32_t IES;                        /*!< (@ 0x400C6FDC) Interrupt enable set register */
  __I  uint32_t INTSTAT;                    /*!< (@ 0x400C6FE0) Interrupt status register */
  __I  uint32_t IE;                         /*!< (@ 0x400C6FE4) Interrupt enable register */
  __O  uint32_t CLR;                        /*!< (@ 0x400C6FE8) Interrupt status clear register */
  __O  uint32_t SET;                        /*!< (@ 0x400C6FEC) Interrupt status set register */
} LPC_QEI_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         GIMA                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=Falcon Chapter title=Global Input Multiplexer Array (GIMA) Modification date=3/25/2011 Major revision=0 Minor revision=4  (GIMA)
  */

typedef struct {                            /*!< (@ 0x400C7000) GIMA Structure         */
  __IO uint32_t  CAP0_0_IN;                 /*!< (@ 0x400C7000) Timer 0 CAP0_0 capture input multiplexer */
  __IO uint32_t  CAP0_1_IN;                 /*!< (@ 0x400C7004) Timer 0 CAP0_1 capture input multiplexer */
  __IO uint32_t  CAP0_2_IN;                 /*!< (@ 0x400C7008) Timer 0 CAP0_2 capture input multiplexer */
  __IO uint32_t  CAP0_3_IN;                 /*!< (@ 0x400C700C) Timer 0 CAP0_3 capture input multiplexer */
  __IO uint32_t  CAP1_0_IN;                 /*!< (@ 0x400C7010) Timer 1 CAP1_0 capture input multiplexer */
  __IO uint32_t  CAP1_1_IN;                 /*!< (@ 0x400C7014) Timer 1 CAP1_1 capture input multiplexer */
  __IO uint32_t  CAP1_2_IN;                 /*!< (@ 0x400C7018) Timer 1 CAP1_2 capture input multiplexer */
  __IO uint32_t  CAP1_3_IN;                 /*!< (@ 0x400C701C) Timer 1 CAP1_3 capture input multiplexer */
  __IO uint32_t  CAP2_0_IN;                 /*!< (@ 0x400C7020) Timer 2 CAP2_0 capture input multiplexer */
  __IO uint32_t  CAP2_1_IN;                 /*!< (@ 0x400C7024) Timer 2 CAP2_1 capture input multiplexer */
  __IO uint32_t  CAP2_2_IN;                 /*!< (@ 0x400C7028) Timer 2 CAP2_2 capture input multiplexer */
  __IO uint32_t  CAP2_3_IN;                 /*!< (@ 0x400C702C) Timer 2 CAP2_3 capture input multiplexer */
  __IO uint32_t  CAP3_0_IN;                 /*!< (@ 0x400C7030) Timer 3 CAP3_0 capture input multiplexer */
  __IO uint32_t  CAP3_1_IN;                 /*!< (@ 0x400C7034) Timer 3 CAP3_1 capture input multiplexer */
  __IO uint32_t  CAP3_2_IN;                 /*!< (@ 0x400C7038) Timer 3 CAP3_2 capture input multiplexer */
  __IO uint32_t  CAP3_3_IN;                 /*!< (@ 0x400C703C) Timer 3 CAP3_3 capture input multiplexer */
  __IO uint32_t  CTIN_0_IN;                 /*!< (@ 0x400C7040) SCT CTIN_0 capture input multiplexer */
  __IO uint32_t  CTIN_1_IN;                 /*!< (@ 0x400C7044) SCT CTIN_1 capture input multiplexer */
  __IO uint32_t  CTIN_2_IN;                 /*!< (@ 0x400C7048) SCT CTIN_2 capture input multiplexer */
  __IO uint32_t  CTIN_3_IN;                 /*!< (@ 0x400C704C) SCT CTIN_3 capture input multiplexer */
  __IO uint32_t  CTIN_4_IN;                 /*!< (@ 0x400C7050) SCT CTIN_4 capture input multiplexer */
  __IO uint32_t  CTIN_5_IN;                 /*!< (@ 0x400C7054) SCT CTIN_5 capture input multiplexer */
  __IO uint32_t  CTIN_6_IN;                 /*!< (@ 0x400C7058) SCT CTIN_6 capture input multiplexer */
  __IO uint32_t  CTIN_7_IN;                 /*!< (@ 0x400C705C) SCT CTIN_7 capture input multiplexer */
  __IO uint32_t  VADC_TRIGGER_IN;           /*!< (@ 0x400C7060) ADC trigger input multiplexer */
  __IO uint32_t  EVENTROUTER_13_IN;         /*!< (@ 0x400C7064) Event router input 13 multiplexer */
  __IO uint32_t  EVENTROUTER_14_IN;         /*!< (@ 0x400C7068) Event router input 14 multiplexer */
  __IO uint32_t  EVENTROUTER_16_IN;         /*!< (@ 0x400C706C) Event router input 16 multiplexer */
  __IO uint32_t  ADCSTART0_IN;              /*!< (@ 0x400C7070) ADC start0 input multiplexer */
  __IO uint32_t  ADCSTART1_IN;              /*!< (@ 0x400C7074) ADC start1 input multiplexer */
} LPC_GIMA_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          DAC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx DAC Modification date=1/18/2011 Major revision=0 Minor revision=7  (DAC)
  */

typedef struct {                            /*!< (@ 0x400E1000) DAC Structure          */
  __IO uint32_t CR;                         /*!< (@ 0x400E1000) DAC register. Holds the conversion data. */
  __IO uint32_t CTRL;                       /*!< (@ 0x400E1004) DAC control register.  */
  __IO uint32_t CNTVAL;                     /*!< (@ 0x400E1008) DAC counter value register. */
} LPC_DAC_Type;



// ------------------------------------------------------------------------------------------------
// -----                                         ADCn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx 10-bit ADC0/1 Modification date=1/18/2011 Major revision=0 Minor revision=7  (ADCn)
    0x400E3000 / 0x400E4000
  */

typedef struct {                            /*!< (@ 0x400Ex000) ADCn Structure         */
  __IO uint32_t CR;                         /*!< (@ 0x400Ex000) A/D Control Register. The AD0CR register must be written to select the operating mode before A/D conversion can occur. */
  __I  uint32_t GDR;                        /*!< (@ 0x400Ex004) A/D Global Data Register. Contains the result of the most recent A/D conversion. */
  __I  uint32_t RESERVED0;
  __IO uint32_t INTEN;                      /*!< (@ 0x400Ex00C) A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt. */
  __I  uint32_t DR[8];                      /*!< (@ 0x400Ex010) A/D Channel Data Register. This register contains the result of the most recent conversion completed on channel n. */
  __I  uint32_t STAT;                       /*!< (@ 0x400Ex030) A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt flag. */
} LPC_ADCn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                       GPIO_PORT                                      -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO port  (GPIO_PORT)
  */

typedef struct {                            /*!< (@ 0x400F4000) GPIO_PORT Structure    */
  __IO uint8_t B[256];                      /*!< (@ 0x400F4000) Byte pin registers port 0 to 5; pins PIOn_0 to PIOn_31 */
  __I  uint32_t RESERVED0[960];
  __IO uint32_t W[256];                     /*!< (@ 0x400F5000) Word pin registers port 0 to 5 */
  __I  uint32_t RESERVED1[768];
  __IO uint32_t DIR[8];                     /*!< (@ 0x400F6000) Direction registers port n */
  __I  uint32_t RESERVED2[24];
  __IO uint32_t MASK[8];                    /*!< (@ 0x400F6080) Mask register port n   */
  __I  uint32_t RESERVED3[24];
  __IO uint32_t PIN[8];                     /*!< (@ 0x400F6100) Portpin register port n */
  __I  uint32_t RESERVED4[24];
  __IO uint32_t MPIN[8];                    /*!< (@ 0x400F6180) Masked port register port n */
  __I  uint32_t RESERVED5[24];
  __IO uint32_t SET[8];                     /*!< (@ 0x400F6200) Write: Set register for port n Read: output bits for port n */
  __I  uint32_t RESERVED6[24];
  __O  uint32_t CLR[8];                     /*!< (@ 0x400F6280) Clear port n           */
  __I  uint32_t RESERVED7[24];
  __O  uint32_t NOT[8];                     /*!< (@ 0x400F6300) Toggle port n          */
} LPC_GPIO_PORT_Type;



/********************************************
** End of section using anonymous unions   **
*********************************************/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma pop
#else
  #error Not supported compiler type
#endif


#ifdef CMSIS_BITPOSITIONS
// ------------------------------------------------------------------------------------------------
// -----                                  SCT Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  SCT_CONFIG  -------------------------------------------
#define SCT_CONFIG_UNIFY_Pos                                  0                                                         /*!< SCT CONFIG: UNIFY Position          */
#define SCT_CONFIG_UNIFY_Msk                                  (0x01UL << SCT_CONFIG_UNIFY_Pos)                          /*!< SCT CONFIG: UNIFY Mask              */
#define SCT_CONFIG_CLKMODE_Pos                                1                                                         /*!< SCT CONFIG: CLKMODE Position        */
#define SCT_CONFIG_CLKMODE_Msk                                (0x03UL << SCT_CONFIG_CLKMODE_Pos)                        /*!< SCT CONFIG: CLKMODE Mask            */
#define SCT_CONFIG_CLKSEL_Pos                                 3                                                         /*!< SCT CONFIG: CLKSEL Position         */
#define SCT_CONFIG_CLKSEL_Msk                                 (0x0fUL << SCT_CONFIG_CLKSEL_Pos)                         /*!< SCT CONFIG: CLKSEL Mask             */
#define SCT_CONFIG_NORELAODL_NORELOADU_Pos                    7                                                         /*!< SCT CONFIG: NORELAODL_NORELOADU Position */
#define SCT_CONFIG_NORELAODL_NORELOADU_Msk                    (0x01UL << SCT_CONFIG_NORELAODL_NORELOADU_Pos)            /*!< SCT CONFIG: NORELAODL_NORELOADU Mask */
#define SCT_CONFIG_NORELOADH_Pos                              8                                                         /*!< SCT CONFIG: NORELOADH Position      */
#define SCT_CONFIG_NORELOADH_Msk                              (0x01UL << SCT_CONFIG_NORELOADH_Pos)                      /*!< SCT CONFIG: NORELOADH Mask          */
#define SCT_CONFIG_INSYNCn_Pos                                9                                                         /*!< SCT CONFIG: INSYNCn Position        */
#define SCT_CONFIG_INSYNCn_Msk                                (0x000000ffUL << SCT_CONFIG_INSYNCn_Pos)                  /*!< SCT CONFIG: INSYNCn Mask            */

// ----------------------------------------  SCT_CTRL  --------------------------------------------
#define SCT_CTRL_DOWN_L_Pos                                   0                                                         /*!< SCT CTRL: DOWN_L Position           */
#define SCT_CTRL_DOWN_L_Msk                                   (0x01UL << SCT_CTRL_DOWN_L_Pos)                           /*!< SCT CTRL: DOWN_L Mask               */
#define SCT_CTRL_STOP_L_Pos                                   1                                                         /*!< SCT CTRL: STOP_L Position           */
#define SCT_CTRL_STOP_L_Msk                                   (0x01UL << SCT_CTRL_STOP_L_Pos)                           /*!< SCT CTRL: STOP_L Mask               */
#define SCT_CTRL_HALT_L_Pos                                   2                                                         /*!< SCT CTRL: HALT_L Position           */
#define SCT_CTRL_HALT_L_Msk                                   (0x01UL << SCT_CTRL_HALT_L_Pos)                           /*!< SCT CTRL: HALT_L Mask               */
#define SCT_CTRL_CLRCTR_L_Pos                                 3                                                         /*!< SCT CTRL: CLRCTR_L Position         */
#define SCT_CTRL_CLRCTR_L_Msk                                 (0x01UL << SCT_CTRL_CLRCTR_L_Pos)                         /*!< SCT CTRL: CLRCTR_L Mask             */
#define SCT_CTRL_BIDIR_L_Pos                                  4                                                         /*!< SCT CTRL: BIDIR_L Position          */
#define SCT_CTRL_BIDIR_L_Msk                                  (0x01UL << SCT_CTRL_BIDIR_L_Pos)                          /*!< SCT CTRL: BIDIR_L Mask              */
#define SCT_CTRL_PRE_L_Pos                                    5                                                         /*!< SCT CTRL: PRE_L Position            */
#define SCT_CTRL_PRE_L_Msk                                    (0x000000ffUL << SCT_CTRL_PRE_L_Pos)                      /*!< SCT CTRL: PRE_L Mask                */
#define SCT_CTRL_DOWN_H_Pos                                   16                                                        /*!< SCT CTRL: DOWN_H Position           */
#define SCT_CTRL_DOWN_H_Msk                                   (0x01UL << SCT_CTRL_DOWN_H_Pos)                           /*!< SCT CTRL: DOWN_H Mask               */
#define SCT_CTRL_STOP_H_Pos                                   17                                                        /*!< SCT CTRL: STOP_H Position           */
#define SCT_CTRL_STOP_H_Msk                                   (0x01UL << SCT_CTRL_STOP_H_Pos)                           /*!< SCT CTRL: STOP_H Mask               */
#define SCT_CTRL_HALT_H_Pos                                   18                                                        /*!< SCT CTRL: HALT_H Position           */
#define SCT_CTRL_HALT_H_Msk                                   (0x01UL << SCT_CTRL_HALT_H_Pos)                           /*!< SCT CTRL: HALT_H Mask               */
#define SCT_CTRL_CLRCTR_H_Pos                                 19                                                        /*!< SCT CTRL: CLRCTR_H Position         */
#define SCT_CTRL_CLRCTR_H_Msk                                 (0x01UL << SCT_CTRL_CLRCTR_H_Pos)                         /*!< SCT CTRL: CLRCTR_H Mask             */
#define SCT_CTRL_BIDIR_H_Pos                                  20                                                        /*!< SCT CTRL: BIDIR_H Position          */
#define SCT_CTRL_BIDIR_H_Msk                                  (0x01UL << SCT_CTRL_BIDIR_H_Pos)                          /*!< SCT CTRL: BIDIR_H Mask              */
#define SCT_CTRL_PRE_H_Pos                                    21                                                        /*!< SCT CTRL: PRE_H Position            */
#define SCT_CTRL_PRE_H_Msk                                    (0x000000ffUL << SCT_CTRL_PRE_H_Pos)                      /*!< SCT CTRL: PRE_H Mask                */

// ----------------------------------------  SCT_LIMIT  -------------------------------------------
#define SCT_LIMIT_LIMMSK_L_Pos                                0                                                         /*!< SCT LIMIT: LIMMSK_L Position        */
#define SCT_LIMIT_LIMMSK_L_Msk                                (0x0000ffffUL << SCT_LIMIT_LIMMSK_L_Pos)                  /*!< SCT LIMIT: LIMMSK_L Mask            */
#define SCT_LIMIT_LIMMSK_H_Pos                                16                                                        /*!< SCT LIMIT: LIMMSK_H Position        */
#define SCT_LIMIT_LIMMSK_H_Msk                                (0x0000ffffUL << SCT_LIMIT_LIMMSK_H_Pos)                  /*!< SCT LIMIT: LIMMSK_H Mask            */

// ----------------------------------------  SCT_HALT  --------------------------------------------
#define SCT_HALT_HALTMSK_L_Pos                                0                                                         /*!< SCT HALT: HALTMSK_L Position        */
#define SCT_HALT_HALTMSK_L_Msk                                (0x0000ffffUL << SCT_HALT_HALTMSK_L_Pos)                  /*!< SCT HALT: HALTMSK_L Mask            */
#define SCT_HALT_HALTMSK_H_Pos                                16                                                        /*!< SCT HALT: HALTMSK_H Position        */
#define SCT_HALT_HALTMSK_H_Msk                                (0x0000ffffUL << SCT_HALT_HALTMSK_H_Pos)                  /*!< SCT HALT: HALTMSK_H Mask            */

// ----------------------------------------  SCT_STOP  --------------------------------------------
#define SCT_STOP_STOPMSK_L_Pos                                0                                                         /*!< SCT STOP: STOPMSK_L Position        */
#define SCT_STOP_STOPMSK_L_Msk                                (0x0000ffffUL << SCT_STOP_STOPMSK_L_Pos)                  /*!< SCT STOP: STOPMSK_L Mask            */
#define SCT_STOP_STOPMSK_H_Pos                                16                                                        /*!< SCT STOP: STOPMSK_H Position        */
#define SCT_STOP_STOPMSK_H_Msk                                (0x0000ffffUL << SCT_STOP_STOPMSK_H_Pos)                  /*!< SCT STOP: STOPMSK_H Mask            */

// ----------------------------------------  SCT_START  -------------------------------------------
#define SCT_START_STARTMSK_L_Pos                              0                                                         /*!< SCT START: STARTMSK_L Position      */
#define SCT_START_STARTMSK_L_Msk                              (0x0000ffffUL << SCT_START_STARTMSK_L_Pos)                /*!< SCT START: STARTMSK_L Mask          */
#define SCT_START_STARTMSK_H_Pos                              16                                                        /*!< SCT START: STARTMSK_H Position      */
#define SCT_START_STARTMSK_H_Msk                              (0x0000ffffUL << SCT_START_STARTMSK_H_Pos)                /*!< SCT START: STARTMSK_H Mask          */

// ----------------------------------------  SCT_COUNT  -------------------------------------------
#define SCT_COUNT_CTR_L_Pos                                   0                                                         /*!< SCT COUNT: CTR_L Position           */
#define SCT_COUNT_CTR_L_Msk                                   (0x0000ffffUL << SCT_COUNT_CTR_L_Pos)                     /*!< SCT COUNT: CTR_L Mask               */
#define SCT_COUNT_CTR_H_Pos                                   16                                                        /*!< SCT COUNT: CTR_H Position           */
#define SCT_COUNT_CTR_H_Msk                                   (0x0000ffffUL << SCT_COUNT_CTR_H_Pos)                     /*!< SCT COUNT: CTR_H Mask               */

// ----------------------------------------  SCT_STATE  -------------------------------------------
#define SCT_STATE_STATE_L_Pos                                 0                                                         /*!< SCT STATE: STATE_L Position         */
#define SCT_STATE_STATE_L_Msk                                 (0x1fUL << SCT_STATE_STATE_L_Pos)                         /*!< SCT STATE: STATE_L Mask             */
#define SCT_STATE_STATE_H_Pos                                 16                                                        /*!< SCT STATE: STATE_H Position         */
#define SCT_STATE_STATE_H_Msk                                 (0x1fUL << SCT_STATE_STATE_H_Pos)                         /*!< SCT STATE: STATE_H Mask             */

// ----------------------------------------  SCT_INPUT  -------------------------------------------
#define SCT_INPUT_AIN0_Pos                                    0                                                         /*!< SCT INPUT: AIN0 Position            */
#define SCT_INPUT_AIN0_Msk                                    (0x01UL << SCT_INPUT_AIN0_Pos)                            /*!< SCT INPUT: AIN0 Mask                */
#define SCT_INPUT_AIN1_Pos                                    1                                                         /*!< SCT INPUT: AIN1 Position            */
#define SCT_INPUT_AIN1_Msk                                    (0x01UL << SCT_INPUT_AIN1_Pos)                            /*!< SCT INPUT: AIN1 Mask                */
#define SCT_INPUT_AIN2_Pos                                    2                                                         /*!< SCT INPUT: AIN2 Position            */
#define SCT_INPUT_AIN2_Msk                                    (0x01UL << SCT_INPUT_AIN2_Pos)                            /*!< SCT INPUT: AIN2 Mask                */
#define SCT_INPUT_AIN3_Pos                                    3                                                         /*!< SCT INPUT: AIN3 Position            */
#define SCT_INPUT_AIN3_Msk                                    (0x01UL << SCT_INPUT_AIN3_Pos)                            /*!< SCT INPUT: AIN3 Mask                */
#define SCT_INPUT_AIN4_Pos                                    4                                                         /*!< SCT INPUT: AIN4 Position            */
#define SCT_INPUT_AIN4_Msk                                    (0x01UL << SCT_INPUT_AIN4_Pos)                            /*!< SCT INPUT: AIN4 Mask                */
#define SCT_INPUT_AIN5_Pos                                    5                                                         /*!< SCT INPUT: AIN5 Position            */
#define SCT_INPUT_AIN5_Msk                                    (0x01UL << SCT_INPUT_AIN5_Pos)                            /*!< SCT INPUT: AIN5 Mask                */
#define SCT_INPUT_AIN6_Pos                                    6                                                         /*!< SCT INPUT: AIN6 Position            */
#define SCT_INPUT_AIN6_Msk                                    (0x01UL << SCT_INPUT_AIN6_Pos)                            /*!< SCT INPUT: AIN6 Mask                */
#define SCT_INPUT_AIN7_Pos                                    7                                                         /*!< SCT INPUT: AIN7 Position            */
#define SCT_INPUT_AIN7_Msk                                    (0x01UL << SCT_INPUT_AIN7_Pos)                            /*!< SCT INPUT: AIN7 Mask                */
#define SCT_INPUT_SIN0_Pos                                    16                                                        /*!< SCT INPUT: SIN0 Position            */
#define SCT_INPUT_SIN0_Msk                                    (0x01UL << SCT_INPUT_SIN0_Pos)                            /*!< SCT INPUT: SIN0 Mask                */
#define SCT_INPUT_SIN1_Pos                                    17                                                        /*!< SCT INPUT: SIN1 Position            */
#define SCT_INPUT_SIN1_Msk                                    (0x01UL << SCT_INPUT_SIN1_Pos)                            /*!< SCT INPUT: SIN1 Mask                */
#define SCT_INPUT_SIN2_Pos                                    18                                                        /*!< SCT INPUT: SIN2 Position            */
#define SCT_INPUT_SIN2_Msk                                    (0x01UL << SCT_INPUT_SIN2_Pos)                            /*!< SCT INPUT: SIN2 Mask                */
#define SCT_INPUT_SIN3_Pos                                    19                                                        /*!< SCT INPUT: SIN3 Position            */
#define SCT_INPUT_SIN3_Msk                                    (0x01UL << SCT_INPUT_SIN3_Pos)                            /*!< SCT INPUT: SIN3 Mask                */
#define SCT_INPUT_SIN4_Pos                                    20                                                        /*!< SCT INPUT: SIN4 Position            */
#define SCT_INPUT_SIN4_Msk                                    (0x01UL << SCT_INPUT_SIN4_Pos)                            /*!< SCT INPUT: SIN4 Mask                */
#define SCT_INPUT_SIN5_Pos                                    21                                                        /*!< SCT INPUT: SIN5 Position            */
#define SCT_INPUT_SIN5_Msk                                    (0x01UL << SCT_INPUT_SIN5_Pos)                            /*!< SCT INPUT: SIN5 Mask                */
#define SCT_INPUT_SIN6_Pos                                    22                                                        /*!< SCT INPUT: SIN6 Position            */
#define SCT_INPUT_SIN6_Msk                                    (0x01UL << SCT_INPUT_SIN6_Pos)                            /*!< SCT INPUT: SIN6 Mask                */
#define SCT_INPUT_SIN7_Pos                                    23                                                        /*!< SCT INPUT: SIN7 Position            */
#define SCT_INPUT_SIN7_Msk                                    (0x01UL << SCT_INPUT_SIN7_Pos)                            /*!< SCT INPUT: SIN7 Mask                */

// ---------------------------------------  SCT_REGMODE  ------------------------------------------
#define SCT_REGMODE_REGMOD_L0_Pos                             0                                                         /*!< SCT REGMODE: REGMOD_L0 Position     */
#define SCT_REGMODE_REGMOD_L0_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L0_Pos)                     /*!< SCT REGMODE: REGMOD_L0 Mask         */
#define SCT_REGMODE_REGMOD_L1_Pos                             1                                                         /*!< SCT REGMODE: REGMOD_L1 Position     */
#define SCT_REGMODE_REGMOD_L1_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L1_Pos)                     /*!< SCT REGMODE: REGMOD_L1 Mask         */
#define SCT_REGMODE_REGMOD_L2_Pos                             2                                                         /*!< SCT REGMODE: REGMOD_L2 Position     */
#define SCT_REGMODE_REGMOD_L2_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L2_Pos)                     /*!< SCT REGMODE: REGMOD_L2 Mask         */
#define SCT_REGMODE_REGMOD_L3_Pos                             3                                                         /*!< SCT REGMODE: REGMOD_L3 Position     */
#define SCT_REGMODE_REGMOD_L3_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L3_Pos)                     /*!< SCT REGMODE: REGMOD_L3 Mask         */
#define SCT_REGMODE_REGMOD_L4_Pos                             4                                                         /*!< SCT REGMODE: REGMOD_L4 Position     */
#define SCT_REGMODE_REGMOD_L4_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L4_Pos)                     /*!< SCT REGMODE: REGMOD_L4 Mask         */
#define SCT_REGMODE_REGMOD_L5_Pos                             5                                                         /*!< SCT REGMODE: REGMOD_L5 Position     */
#define SCT_REGMODE_REGMOD_L5_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L5_Pos)                     /*!< SCT REGMODE: REGMOD_L5 Mask         */
#define SCT_REGMODE_REGMOD_L6_Pos                             6                                                         /*!< SCT REGMODE: REGMOD_L6 Position     */
#define SCT_REGMODE_REGMOD_L6_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L6_Pos)                     /*!< SCT REGMODE: REGMOD_L6 Mask         */
#define SCT_REGMODE_REGMOD_L7_Pos                             7                                                         /*!< SCT REGMODE: REGMOD_L7 Position     */
#define SCT_REGMODE_REGMOD_L7_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L7_Pos)                     /*!< SCT REGMODE: REGMOD_L7 Mask         */
#define SCT_REGMODE_REGMOD_L8_Pos                             8                                                         /*!< SCT REGMODE: REGMOD_L8 Position     */
#define SCT_REGMODE_REGMOD_L8_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L8_Pos)                     /*!< SCT REGMODE: REGMOD_L8 Mask         */
#define SCT_REGMODE_REGMOD_L9_Pos                             9                                                         /*!< SCT REGMODE: REGMOD_L9 Position     */
#define SCT_REGMODE_REGMOD_L9_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L9_Pos)                     /*!< SCT REGMODE: REGMOD_L9 Mask         */
#define SCT_REGMODE_REGMOD_L10_Pos                            10                                                        /*!< SCT REGMODE: REGMOD_L10 Position    */
#define SCT_REGMODE_REGMOD_L10_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L10_Pos)                    /*!< SCT REGMODE: REGMOD_L10 Mask        */
#define SCT_REGMODE_REGMOD_L11_Pos                            11                                                        /*!< SCT REGMODE: REGMOD_L11 Position    */
#define SCT_REGMODE_REGMOD_L11_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L11_Pos)                    /*!< SCT REGMODE: REGMOD_L11 Mask        */
#define SCT_REGMODE_REGMOD_L12_Pos                            12                                                        /*!< SCT REGMODE: REGMOD_L12 Position    */
#define SCT_REGMODE_REGMOD_L12_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L12_Pos)                    /*!< SCT REGMODE: REGMOD_L12 Mask        */
#define SCT_REGMODE_REGMOD_L13_Pos                            13                                                        /*!< SCT REGMODE: REGMOD_L13 Position    */
#define SCT_REGMODE_REGMOD_L13_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L13_Pos)                    /*!< SCT REGMODE: REGMOD_L13 Mask        */
#define SCT_REGMODE_REGMOD_L14_Pos                            14                                                        /*!< SCT REGMODE: REGMOD_L14 Position    */
#define SCT_REGMODE_REGMOD_L14_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L14_Pos)                    /*!< SCT REGMODE: REGMOD_L14 Mask        */
#define SCT_REGMODE_REGMOD_L15_Pos                            15                                                        /*!< SCT REGMODE: REGMOD_L15 Position    */
#define SCT_REGMODE_REGMOD_L15_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L15_Pos)                    /*!< SCT REGMODE: REGMOD_L15 Mask        */
#define SCT_REGMODE_REGMOD_H16_Pos                            16                                                        /*!< SCT REGMODE: REGMOD_H16 Position    */
#define SCT_REGMODE_REGMOD_H16_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H16_Pos)                    /*!< SCT REGMODE: REGMOD_H16 Mask        */
#define SCT_REGMODE_REGMOD_H17_Pos                            17                                                        /*!< SCT REGMODE: REGMOD_H17 Position    */
#define SCT_REGMODE_REGMOD_H17_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H17_Pos)                    /*!< SCT REGMODE: REGMOD_H17 Mask        */
#define SCT_REGMODE_REGMOD_H18_Pos                            18                                                        /*!< SCT REGMODE: REGMOD_H18 Position    */
#define SCT_REGMODE_REGMOD_H18_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H18_Pos)                    /*!< SCT REGMODE: REGMOD_H18 Mask        */
#define SCT_REGMODE_REGMOD_H19_Pos                            19                                                        /*!< SCT REGMODE: REGMOD_H19 Position    */
#define SCT_REGMODE_REGMOD_H19_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H19_Pos)                    /*!< SCT REGMODE: REGMOD_H19 Mask        */
#define SCT_REGMODE_REGMOD_H20_Pos                            20                                                        /*!< SCT REGMODE: REGMOD_H20 Position    */
#define SCT_REGMODE_REGMOD_H20_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H20_Pos)                    /*!< SCT REGMODE: REGMOD_H20 Mask        */
#define SCT_REGMODE_REGMOD_H21_Pos                            21                                                        /*!< SCT REGMODE: REGMOD_H21 Position    */
#define SCT_REGMODE_REGMOD_H21_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H21_Pos)                    /*!< SCT REGMODE: REGMOD_H21 Mask        */
#define SCT_REGMODE_REGMOD_H22_Pos                            22                                                        /*!< SCT REGMODE: REGMOD_H22 Position    */
#define SCT_REGMODE_REGMOD_H22_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H22_Pos)                    /*!< SCT REGMODE: REGMOD_H22 Mask        */
#define SCT_REGMODE_REGMOD_H23_Pos                            23                                                        /*!< SCT REGMODE: REGMOD_H23 Position    */
#define SCT_REGMODE_REGMOD_H23_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H23_Pos)                    /*!< SCT REGMODE: REGMOD_H23 Mask        */
#define SCT_REGMODE_REGMOD_H24_Pos                            24                                                        /*!< SCT REGMODE: REGMOD_H24 Position    */
#define SCT_REGMODE_REGMOD_H24_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H24_Pos)                    /*!< SCT REGMODE: REGMOD_H24 Mask        */
#define SCT_REGMODE_REGMOD_H25_Pos                            25                                                        /*!< SCT REGMODE: REGMOD_H25 Position    */
#define SCT_REGMODE_REGMOD_H25_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H25_Pos)                    /*!< SCT REGMODE: REGMOD_H25 Mask        */
#define SCT_REGMODE_REGMOD_H26_Pos                            26                                                        /*!< SCT REGMODE: REGMOD_H26 Position    */
#define SCT_REGMODE_REGMOD_H26_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H26_Pos)                    /*!< SCT REGMODE: REGMOD_H26 Mask        */
#define SCT_REGMODE_REGMOD_H27_Pos                            27                                                        /*!< SCT REGMODE: REGMOD_H27 Position    */
#define SCT_REGMODE_REGMOD_H27_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H27_Pos)                    /*!< SCT REGMODE: REGMOD_H27 Mask        */
#define SCT_REGMODE_REGMOD_H28_Pos                            28                                                        /*!< SCT REGMODE: REGMOD_H28 Position    */
#define SCT_REGMODE_REGMOD_H28_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H28_Pos)                    /*!< SCT REGMODE: REGMOD_H28 Mask        */
#define SCT_REGMODE_REGMOD_H29_Pos                            29                                                        /*!< SCT REGMODE: REGMOD_H29 Position    */
#define SCT_REGMODE_REGMOD_H29_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H29_Pos)                    /*!< SCT REGMODE: REGMOD_H29 Mask        */
#define SCT_REGMODE_REGMOD_H30_Pos                            30                                                        /*!< SCT REGMODE: REGMOD_H30 Position    */
#define SCT_REGMODE_REGMOD_H30_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H30_Pos)                    /*!< SCT REGMODE: REGMOD_H30 Mask        */
#define SCT_REGMODE_REGMOD_H31_Pos                            31                                                        /*!< SCT REGMODE: REGMOD_H31 Position    */
#define SCT_REGMODE_REGMOD_H31_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H31_Pos)                    /*!< SCT REGMODE: REGMOD_H31 Mask        */

// ---------------------------------------  SCT_OUTPUT  -------------------------------------------
#define SCT_OUTPUT_OUT0_Pos                                   0                                                         /*!< SCT OUTPUT: OUT0 Position           */
#define SCT_OUTPUT_OUT0_Msk                                   (0x01UL << SCT_OUTPUT_OUT0_Pos)                           /*!< SCT OUTPUT: OUT0 Mask               */
#define SCT_OUTPUT_OUT1_Pos                                   1                                                         /*!< SCT OUTPUT: OUT1 Position           */
#define SCT_OUTPUT_OUT1_Msk                                   (0x01UL << SCT_OUTPUT_OUT1_Pos)                           /*!< SCT OUTPUT: OUT1 Mask               */
#define SCT_OUTPUT_OUT2_Pos                                   2                                                         /*!< SCT OUTPUT: OUT2 Position           */
#define SCT_OUTPUT_OUT2_Msk                                   (0x01UL << SCT_OUTPUT_OUT2_Pos)                           /*!< SCT OUTPUT: OUT2 Mask               */
#define SCT_OUTPUT_OUT3_Pos                                   3                                                         /*!< SCT OUTPUT: OUT3 Position           */
#define SCT_OUTPUT_OUT3_Msk                                   (0x01UL << SCT_OUTPUT_OUT3_Pos)                           /*!< SCT OUTPUT: OUT3 Mask               */
#define SCT_OUTPUT_OUT4_Pos                                   4                                                         /*!< SCT OUTPUT: OUT4 Position           */
#define SCT_OUTPUT_OUT4_Msk                                   (0x01UL << SCT_OUTPUT_OUT4_Pos)                           /*!< SCT OUTPUT: OUT4 Mask               */
#define SCT_OUTPUT_OUT5_Pos                                   5                                                         /*!< SCT OUTPUT: OUT5 Position           */
#define SCT_OUTPUT_OUT5_Msk                                   (0x01UL << SCT_OUTPUT_OUT5_Pos)                           /*!< SCT OUTPUT: OUT5 Mask               */
#define SCT_OUTPUT_OUT6_Pos                                   6                                                         /*!< SCT OUTPUT: OUT6 Position           */
#define SCT_OUTPUT_OUT6_Msk                                   (0x01UL << SCT_OUTPUT_OUT6_Pos)                           /*!< SCT OUTPUT: OUT6 Mask               */
#define SCT_OUTPUT_OUT7_Pos                                   7                                                         /*!< SCT OUTPUT: OUT7 Position           */
#define SCT_OUTPUT_OUT7_Msk                                   (0x01UL << SCT_OUTPUT_OUT7_Pos)                           /*!< SCT OUTPUT: OUT7 Mask               */
#define SCT_OUTPUT_OUT8_Pos                                   8                                                         /*!< SCT OUTPUT: OUT8 Position           */
#define SCT_OUTPUT_OUT8_Msk                                   (0x01UL << SCT_OUTPUT_OUT8_Pos)                           /*!< SCT OUTPUT: OUT8 Mask               */
#define SCT_OUTPUT_OUT9_Pos                                   9                                                         /*!< SCT OUTPUT: OUT9 Position           */
#define SCT_OUTPUT_OUT9_Msk                                   (0x01UL << SCT_OUTPUT_OUT9_Pos)                           /*!< SCT OUTPUT: OUT9 Mask               */
#define SCT_OUTPUT_OUT10_Pos                                  10                                                        /*!< SCT OUTPUT: OUT10 Position          */
#define SCT_OUTPUT_OUT10_Msk                                  (0x01UL << SCT_OUTPUT_OUT10_Pos)                          /*!< SCT OUTPUT: OUT10 Mask              */
#define SCT_OUTPUT_OUT11_Pos                                  11                                                        /*!< SCT OUTPUT: OUT11 Position          */
#define SCT_OUTPUT_OUT11_Msk                                  (0x01UL << SCT_OUTPUT_OUT11_Pos)                          /*!< SCT OUTPUT: OUT11 Mask              */
#define SCT_OUTPUT_OUT12_Pos                                  12                                                        /*!< SCT OUTPUT: OUT12 Position          */
#define SCT_OUTPUT_OUT12_Msk                                  (0x01UL << SCT_OUTPUT_OUT12_Pos)                          /*!< SCT OUTPUT: OUT12 Mask              */
#define SCT_OUTPUT_OUT13_Pos                                  13                                                        /*!< SCT OUTPUT: OUT13 Position          */
#define SCT_OUTPUT_OUT13_Msk                                  (0x01UL << SCT_OUTPUT_OUT13_Pos)                          /*!< SCT OUTPUT: OUT13 Mask              */
#define SCT_OUTPUT_OUT14_Pos                                  14                                                        /*!< SCT OUTPUT: OUT14 Position          */
#define SCT_OUTPUT_OUT14_Msk                                  (0x01UL << SCT_OUTPUT_OUT14_Pos)                          /*!< SCT OUTPUT: OUT14 Mask              */
#define SCT_OUTPUT_OUT15_Pos                                  15                                                        /*!< SCT OUTPUT: OUT15 Position          */
#define SCT_OUTPUT_OUT15_Msk                                  (0x01UL << SCT_OUTPUT_OUT15_Pos)                          /*!< SCT OUTPUT: OUT15 Mask              */

// ------------------------------------  SCT_OUTPUTDIRCTRL  ---------------------------------------
#define SCT_OUTPUTDIRCTRL_SETCLR0_Pos                         0                                                         /*!< SCT OUTPUTDIRCTRL: SETCLR0 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR0_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR0_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR0 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR1_Pos                         2                                                         /*!< SCT OUTPUTDIRCTRL: SETCLR1 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR1_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR1_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR1 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR2_Pos                         4                                                         /*!< SCT OUTPUTDIRCTRL: SETCLR2 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR2_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR2_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR2 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR3_Pos                         6                                                         /*!< SCT OUTPUTDIRCTRL: SETCLR3 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR3_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR3_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR3 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR4_Pos                         8                                                         /*!< SCT OUTPUTDIRCTRL: SETCLR4 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR4_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR4_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR4 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR5_Pos                         10                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR5 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR5_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR5_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR5 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR6_Pos                         12                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR6 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR6_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR6_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR6 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR7_Pos                         14                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR7 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR7_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR7_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR7 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR8_Pos                         16                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR8 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR8_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR8_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR8 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR9_Pos                         18                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR9 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR9_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR9_Pos)                 /*!< SCT OUTPUTDIRCTRL: SETCLR9 Mask     */
#define SCT_OUTPUTDIRCTRL_SETCLR10_Pos                        20                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR10 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR10_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR10_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR10 Mask    */
#define SCT_OUTPUTDIRCTRL_SETCLR11_Pos                        22                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR11 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR11_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR11_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR11 Mask    */
#define SCT_OUTPUTDIRCTRL_SETCLR12_Pos                        24                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR12 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR12_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR12_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR12 Mask    */
#define SCT_OUTPUTDIRCTRL_SETCLR13_Pos                        26                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR13 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR13_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR13_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR13 Mask    */
#define SCT_OUTPUTDIRCTRL_SETCLR14_Pos                        28                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR14 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR14_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR14_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR14 Mask    */
#define SCT_OUTPUTDIRCTRL_SETCLR15_Pos                        30                                                        /*!< SCT OUTPUTDIRCTRL: SETCLR15 Position */
#define SCT_OUTPUTDIRCTRL_SETCLR15_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR15_Pos)                /*!< SCT OUTPUTDIRCTRL: SETCLR15 Mask    */

// -----------------------------------------  SCT_RES  --------------------------------------------
#define SCT_RES_O0RES_Pos                                     0                                                         /*!< SCT RES: O0RES Position             */
#define SCT_RES_O0RES_Msk                                     (0x03UL << SCT_RES_O0RES_Pos)                             /*!< SCT RES: O0RES Mask                 */
#define SCT_RES_O1RES_Pos                                     2                                                         /*!< SCT RES: O1RES Position             */
#define SCT_RES_O1RES_Msk                                     (0x03UL << SCT_RES_O1RES_Pos)                             /*!< SCT RES: O1RES Mask                 */
#define SCT_RES_O2RES_Pos                                     4                                                         /*!< SCT RES: O2RES Position             */
#define SCT_RES_O2RES_Msk                                     (0x03UL << SCT_RES_O2RES_Pos)                             /*!< SCT RES: O2RES Mask                 */
#define SCT_RES_O3RES_Pos                                     6                                                         /*!< SCT RES: O3RES Position             */
#define SCT_RES_O3RES_Msk                                     (0x03UL << SCT_RES_O3RES_Pos)                             /*!< SCT RES: O3RES Mask                 */
#define SCT_RES_O4RES_Pos                                     8                                                         /*!< SCT RES: O4RES Position             */
#define SCT_RES_O4RES_Msk                                     (0x03UL << SCT_RES_O4RES_Pos)                             /*!< SCT RES: O4RES Mask                 */
#define SCT_RES_O5RES_Pos                                     10                                                        /*!< SCT RES: O5RES Position             */
#define SCT_RES_O5RES_Msk                                     (0x03UL << SCT_RES_O5RES_Pos)                             /*!< SCT RES: O5RES Mask                 */
#define SCT_RES_O6RES_Pos                                     12                                                        /*!< SCT RES: O6RES Position             */
#define SCT_RES_O6RES_Msk                                     (0x03UL << SCT_RES_O6RES_Pos)                             /*!< SCT RES: O6RES Mask                 */
#define SCT_RES_O7RES_Pos                                     14                                                        /*!< SCT RES: O7RES Position             */
#define SCT_RES_O7RES_Msk                                     (0x03UL << SCT_RES_O7RES_Pos)                             /*!< SCT RES: O7RES Mask                 */
#define SCT_RES_O8RES_Pos                                     16                                                        /*!< SCT RES: O8RES Position             */
#define SCT_RES_O8RES_Msk                                     (0x03UL << SCT_RES_O8RES_Pos)                             /*!< SCT RES: O8RES Mask                 */
#define SCT_RES_O9RES_Pos                                     18                                                        /*!< SCT RES: O9RES Position             */
#define SCT_RES_O9RES_Msk                                     (0x03UL << SCT_RES_O9RES_Pos)                             /*!< SCT RES: O9RES Mask                 */
#define SCT_RES_O10RES_Pos                                    20                                                        /*!< SCT RES: O10RES Position            */
#define SCT_RES_O10RES_Msk                                    (0x03UL << SCT_RES_O10RES_Pos)                            /*!< SCT RES: O10RES Mask                */
#define SCT_RES_O11RES_Pos                                    22                                                        /*!< SCT RES: O11RES Position            */
#define SCT_RES_O11RES_Msk                                    (0x03UL << SCT_RES_O11RES_Pos)                            /*!< SCT RES: O11RES Mask                */
#define SCT_RES_O12RES_Pos                                    24                                                        /*!< SCT RES: O12RES Position            */
#define SCT_RES_O12RES_Msk                                    (0x03UL << SCT_RES_O12RES_Pos)                            /*!< SCT RES: O12RES Mask                */
#define SCT_RES_O13RES_Pos                                    26                                                        /*!< SCT RES: O13RES Position            */
#define SCT_RES_O13RES_Msk                                    (0x03UL << SCT_RES_O13RES_Pos)                            /*!< SCT RES: O13RES Mask                */
#define SCT_RES_O14RES_Pos                                    28                                                        /*!< SCT RES: O14RES Position            */
#define SCT_RES_O14RES_Msk                                    (0x03UL << SCT_RES_O14RES_Pos)                            /*!< SCT RES: O14RES Mask                */
#define SCT_RES_O15RES_Pos                                    30                                                        /*!< SCT RES: O15RES Position            */
#define SCT_RES_O15RES_Msk                                    (0x03UL << SCT_RES_O15RES_Pos)                            /*!< SCT RES: O15RES Mask                */

// ---------------------------------------  SCT_DMAREQ0  ------------------------------------------
#define SCT_DMAREQ0_DEV_0_0_Pos                               0                                                         /*!< SCT DMAREQ0: DEV_0_0 Position       */
#define SCT_DMAREQ0_DEV_0_0_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_0_Pos)                       /*!< SCT DMAREQ0: DEV_0_0 Mask           */
#define SCT_DMAREQ0_DEV_0_1_Pos                               1                                                         /*!< SCT DMAREQ0: DEV_0_1 Position       */
#define SCT_DMAREQ0_DEV_0_1_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_1_Pos)                       /*!< SCT DMAREQ0: DEV_0_1 Mask           */
#define SCT_DMAREQ0_DEV_0_2_Pos                               2                                                         /*!< SCT DMAREQ0: DEV_0_2 Position       */
#define SCT_DMAREQ0_DEV_0_2_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_2_Pos)                       /*!< SCT DMAREQ0: DEV_0_2 Mask           */
#define SCT_DMAREQ0_DEV_0_3_Pos                               3                                                         /*!< SCT DMAREQ0: DEV_0_3 Position       */
#define SCT_DMAREQ0_DEV_0_3_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_3_Pos)                       /*!< SCT DMAREQ0: DEV_0_3 Mask           */
#define SCT_DMAREQ0_DEV_0_4_Pos                               4                                                         /*!< SCT DMAREQ0: DEV_0_4 Position       */
#define SCT_DMAREQ0_DEV_0_4_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_4_Pos)                       /*!< SCT DMAREQ0: DEV_0_4 Mask           */
#define SCT_DMAREQ0_DEV_0_5_Pos                               5                                                         /*!< SCT DMAREQ0: DEV_0_5 Position       */
#define SCT_DMAREQ0_DEV_0_5_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_5_Pos)                       /*!< SCT DMAREQ0: DEV_0_5 Mask           */
#define SCT_DMAREQ0_DEV_0_6_Pos                               6                                                         /*!< SCT DMAREQ0: DEV_0_6 Position       */
#define SCT_DMAREQ0_DEV_0_6_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_6_Pos)                       /*!< SCT DMAREQ0: DEV_0_6 Mask           */
#define SCT_DMAREQ0_DEV_0_7_Pos                               7                                                         /*!< SCT DMAREQ0: DEV_0_7 Position       */
#define SCT_DMAREQ0_DEV_0_7_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_7_Pos)                       /*!< SCT DMAREQ0: DEV_0_7 Mask           */
#define SCT_DMAREQ0_DEV_0_8_Pos                               8                                                         /*!< SCT DMAREQ0: DEV_0_8 Position       */
#define SCT_DMAREQ0_DEV_0_8_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_8_Pos)                       /*!< SCT DMAREQ0: DEV_0_8 Mask           */
#define SCT_DMAREQ0_DEV_0_9_Pos                               9                                                         /*!< SCT DMAREQ0: DEV_0_9 Position       */
#define SCT_DMAREQ0_DEV_0_9_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_9_Pos)                       /*!< SCT DMAREQ0: DEV_0_9 Mask           */
#define SCT_DMAREQ0_DEV_0_10_Pos                              10                                                        /*!< SCT DMAREQ0: DEV_0_10 Position      */
#define SCT_DMAREQ0_DEV_0_10_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_10_Pos)                      /*!< SCT DMAREQ0: DEV_0_10 Mask          */
#define SCT_DMAREQ0_DEV_0_11_Pos                              11                                                        /*!< SCT DMAREQ0: DEV_0_11 Position      */
#define SCT_DMAREQ0_DEV_0_11_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_11_Pos)                      /*!< SCT DMAREQ0: DEV_0_11 Mask          */
#define SCT_DMAREQ0_DEV_0_12_Pos                              12                                                        /*!< SCT DMAREQ0: DEV_0_12 Position      */
#define SCT_DMAREQ0_DEV_0_12_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_12_Pos)                      /*!< SCT DMAREQ0: DEV_0_12 Mask          */
#define SCT_DMAREQ0_DEV_0_13_Pos                              13                                                        /*!< SCT DMAREQ0: DEV_0_13 Position      */
#define SCT_DMAREQ0_DEV_0_13_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_13_Pos)                      /*!< SCT DMAREQ0: DEV_0_13 Mask          */
#define SCT_DMAREQ0_DEV_0_14_Pos                              14                                                        /*!< SCT DMAREQ0: DEV_0_14 Position      */
#define SCT_DMAREQ0_DEV_0_14_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_14_Pos)                      /*!< SCT DMAREQ0: DEV_0_14 Mask          */
#define SCT_DMAREQ0_DEV_0_15_Pos                              15                                                        /*!< SCT DMAREQ0: DEV_0_15 Position      */
#define SCT_DMAREQ0_DEV_0_15_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_15_Pos)                      /*!< SCT DMAREQ0: DEV_0_15 Mask          */
#define SCT_DMAREQ0_DRL0_Pos                                  30                                                        /*!< SCT DMAREQ0: DRL0 Position          */
#define SCT_DMAREQ0_DRL0_Msk                                  (0x01UL << SCT_DMAREQ0_DRL0_Pos)                          /*!< SCT DMAREQ0: DRL0 Mask              */
#define SCT_DMAREQ0_DRQ0_Pos                                  31                                                        /*!< SCT DMAREQ0: DRQ0 Position          */
#define SCT_DMAREQ0_DRQ0_Msk                                  (0x01UL << SCT_DMAREQ0_DRQ0_Pos)                          /*!< SCT DMAREQ0: DRQ0 Mask              */

// ---------------------------------------  SCT_DMAREQ1  ------------------------------------------
#define SCT_DMAREQ1_DEV_1_0_Pos                               0                                                         /*!< SCT DMAREQ1: DEV_1_0 Position       */
#define SCT_DMAREQ1_DEV_1_0_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_0_Pos)                       /*!< SCT DMAREQ1: DEV_1_0 Mask           */
#define SCT_DMAREQ1_DEV_1_1_Pos                               1                                                         /*!< SCT DMAREQ1: DEV_1_1 Position       */
#define SCT_DMAREQ1_DEV_1_1_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_1_Pos)                       /*!< SCT DMAREQ1: DEV_1_1 Mask           */
#define SCT_DMAREQ1_DEV_1_2_Pos                               2                                                         /*!< SCT DMAREQ1: DEV_1_2 Position       */
#define SCT_DMAREQ1_DEV_1_2_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_2_Pos)                       /*!< SCT DMAREQ1: DEV_1_2 Mask           */
#define SCT_DMAREQ1_DEV_1_3_Pos                               3                                                         /*!< SCT DMAREQ1: DEV_1_3 Position       */
#define SCT_DMAREQ1_DEV_1_3_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_3_Pos)                       /*!< SCT DMAREQ1: DEV_1_3 Mask           */
#define SCT_DMAREQ1_DEV_1_4_Pos                               4                                                         /*!< SCT DMAREQ1: DEV_1_4 Position       */
#define SCT_DMAREQ1_DEV_1_4_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_4_Pos)                       /*!< SCT DMAREQ1: DEV_1_4 Mask           */
#define SCT_DMAREQ1_DEV_1_5_Pos                               5                                                         /*!< SCT DMAREQ1: DEV_1_5 Position       */
#define SCT_DMAREQ1_DEV_1_5_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_5_Pos)                       /*!< SCT DMAREQ1: DEV_1_5 Mask           */
#define SCT_DMAREQ1_DEV_1_6_Pos                               6                                                         /*!< SCT DMAREQ1: DEV_1_6 Position       */
#define SCT_DMAREQ1_DEV_1_6_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_6_Pos)                       /*!< SCT DMAREQ1: DEV_1_6 Mask           */
#define SCT_DMAREQ1_DEV_1_7_Pos                               7                                                         /*!< SCT DMAREQ1: DEV_1_7 Position       */
#define SCT_DMAREQ1_DEV_1_7_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_7_Pos)                       /*!< SCT DMAREQ1: DEV_1_7 Mask           */
#define SCT_DMAREQ1_DEV_1_8_Pos                               8                                                         /*!< SCT DMAREQ1: DEV_1_8 Position       */
#define SCT_DMAREQ1_DEV_1_8_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_8_Pos)                       /*!< SCT DMAREQ1: DEV_1_8 Mask           */
#define SCT_DMAREQ1_DEV_1_9_Pos                               9                                                         /*!< SCT DMAREQ1: DEV_1_9 Position       */
#define SCT_DMAREQ1_DEV_1_9_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_9_Pos)                       /*!< SCT DMAREQ1: DEV_1_9 Mask           */
#define SCT_DMAREQ1_DEV_1_10_Pos                              10                                                        /*!< SCT DMAREQ1: DEV_1_10 Position      */
#define SCT_DMAREQ1_DEV_1_10_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_10_Pos)                      /*!< SCT DMAREQ1: DEV_1_10 Mask          */
#define SCT_DMAREQ1_DEV_1_11_Pos                              11                                                        /*!< SCT DMAREQ1: DEV_1_11 Position      */
#define SCT_DMAREQ1_DEV_1_11_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_11_Pos)                      /*!< SCT DMAREQ1: DEV_1_11 Mask          */
#define SCT_DMAREQ1_DEV_1_12_Pos                              12                                                        /*!< SCT DMAREQ1: DEV_1_12 Position      */
#define SCT_DMAREQ1_DEV_1_12_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_12_Pos)                      /*!< SCT DMAREQ1: DEV_1_12 Mask          */
#define SCT_DMAREQ1_DEV_1_13_Pos                              13                                                        /*!< SCT DMAREQ1: DEV_1_13 Position      */
#define SCT_DMAREQ1_DEV_1_13_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_13_Pos)                      /*!< SCT DMAREQ1: DEV_1_13 Mask          */
#define SCT_DMAREQ1_DEV_1_14_Pos                              14                                                        /*!< SCT DMAREQ1: DEV_1_14 Position      */
#define SCT_DMAREQ1_DEV_1_14_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_14_Pos)                      /*!< SCT DMAREQ1: DEV_1_14 Mask          */
#define SCT_DMAREQ1_DEV_1_15_Pos                              15                                                        /*!< SCT DMAREQ1: DEV_1_15 Position      */
#define SCT_DMAREQ1_DEV_1_15_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_15_Pos)                      /*!< SCT DMAREQ1: DEV_1_15 Mask          */
#define SCT_DMAREQ1_DRL1_Pos                                  30                                                        /*!< SCT DMAREQ1: DRL1 Position          */
#define SCT_DMAREQ1_DRL1_Msk                                  (0x01UL << SCT_DMAREQ1_DRL1_Pos)                          /*!< SCT DMAREQ1: DRL1 Mask              */
#define SCT_DMAREQ1_DRQ1_Pos                                  31                                                        /*!< SCT DMAREQ1: DRQ1 Position          */
#define SCT_DMAREQ1_DRQ1_Msk                                  (0x01UL << SCT_DMAREQ1_DRQ1_Pos)                          /*!< SCT DMAREQ1: DRQ1 Mask              */

// ----------------------------------------  SCT_EVEN  --------------------------------------------
#define SCT_EVEN_IEN0_Pos                                     0                                                         /*!< SCT EVEN: IEN0 Position             */
#define SCT_EVEN_IEN0_Msk                                     (0x01UL << SCT_EVEN_IEN0_Pos)                             /*!< SCT EVEN: IEN0 Mask                 */
#define SCT_EVEN_IEN1_Pos                                     1                                                         /*!< SCT EVEN: IEN1 Position             */
#define SCT_EVEN_IEN1_Msk                                     (0x01UL << SCT_EVEN_IEN1_Pos)                             /*!< SCT EVEN: IEN1 Mask                 */
#define SCT_EVEN_IEN2_Pos                                     2                                                         /*!< SCT EVEN: IEN2 Position             */
#define SCT_EVEN_IEN2_Msk                                     (0x01UL << SCT_EVEN_IEN2_Pos)                             /*!< SCT EVEN: IEN2 Mask                 */
#define SCT_EVEN_IEN3_Pos                                     3                                                         /*!< SCT EVEN: IEN3 Position             */
#define SCT_EVEN_IEN3_Msk                                     (0x01UL << SCT_EVEN_IEN3_Pos)                             /*!< SCT EVEN: IEN3 Mask                 */
#define SCT_EVEN_IEN4_Pos                                     4                                                         /*!< SCT EVEN: IEN4 Position             */
#define SCT_EVEN_IEN4_Msk                                     (0x01UL << SCT_EVEN_IEN4_Pos)                             /*!< SCT EVEN: IEN4 Mask                 */
#define SCT_EVEN_IEN5_Pos                                     5                                                         /*!< SCT EVEN: IEN5 Position             */
#define SCT_EVEN_IEN5_Msk                                     (0x01UL << SCT_EVEN_IEN5_Pos)                             /*!< SCT EVEN: IEN5 Mask                 */
#define SCT_EVEN_IEN6_Pos                                     6                                                         /*!< SCT EVEN: IEN6 Position             */
#define SCT_EVEN_IEN6_Msk                                     (0x01UL << SCT_EVEN_IEN6_Pos)                             /*!< SCT EVEN: IEN6 Mask                 */
#define SCT_EVEN_IEN7_Pos                                     7                                                         /*!< SCT EVEN: IEN7 Position             */
#define SCT_EVEN_IEN7_Msk                                     (0x01UL << SCT_EVEN_IEN7_Pos)                             /*!< SCT EVEN: IEN7 Mask                 */
#define SCT_EVEN_IEN8_Pos                                     8                                                         /*!< SCT EVEN: IEN8 Position             */
#define SCT_EVEN_IEN8_Msk                                     (0x01UL << SCT_EVEN_IEN8_Pos)                             /*!< SCT EVEN: IEN8 Mask                 */
#define SCT_EVEN_IEN9_Pos                                     9                                                         /*!< SCT EVEN: IEN9 Position             */
#define SCT_EVEN_IEN9_Msk                                     (0x01UL << SCT_EVEN_IEN9_Pos)                             /*!< SCT EVEN: IEN9 Mask                 */
#define SCT_EVEN_IEN10_Pos                                    10                                                        /*!< SCT EVEN: IEN10 Position            */
#define SCT_EVEN_IEN10_Msk                                    (0x01UL << SCT_EVEN_IEN10_Pos)                            /*!< SCT EVEN: IEN10 Mask                */
#define SCT_EVEN_IEN11_Pos                                    11                                                        /*!< SCT EVEN: IEN11 Position            */
#define SCT_EVEN_IEN11_Msk                                    (0x01UL << SCT_EVEN_IEN11_Pos)                            /*!< SCT EVEN: IEN11 Mask                */
#define SCT_EVEN_IEN12_Pos                                    12                                                        /*!< SCT EVEN: IEN12 Position            */
#define SCT_EVEN_IEN12_Msk                                    (0x01UL << SCT_EVEN_IEN12_Pos)                            /*!< SCT EVEN: IEN12 Mask                */
#define SCT_EVEN_IEN13_Pos                                    13                                                        /*!< SCT EVEN: IEN13 Position            */
#define SCT_EVEN_IEN13_Msk                                    (0x01UL << SCT_EVEN_IEN13_Pos)                            /*!< SCT EVEN: IEN13 Mask                */
#define SCT_EVEN_IEN14_Pos                                    14                                                        /*!< SCT EVEN: IEN14 Position            */
#define SCT_EVEN_IEN14_Msk                                    (0x01UL << SCT_EVEN_IEN14_Pos)                            /*!< SCT EVEN: IEN14 Mask                */
#define SCT_EVEN_IEN15_Pos                                    15                                                        /*!< SCT EVEN: IEN15 Position            */
#define SCT_EVEN_IEN15_Msk                                    (0x01UL << SCT_EVEN_IEN15_Pos)                            /*!< SCT EVEN: IEN15 Mask                */

// ---------------------------------------  SCT_EVFLAG  -------------------------------------------
#define SCT_EVFLAG_FLAG0_Pos                                  0                                                         /*!< SCT EVFLAG: FLAG0 Position          */
#define SCT_EVFLAG_FLAG0_Msk                                  (0x01UL << SCT_EVFLAG_FLAG0_Pos)                          /*!< SCT EVFLAG: FLAG0 Mask              */
#define SCT_EVFLAG_FLAG1_Pos                                  1                                                         /*!< SCT EVFLAG: FLAG1 Position          */
#define SCT_EVFLAG_FLAG1_Msk                                  (0x01UL << SCT_EVFLAG_FLAG1_Pos)                          /*!< SCT EVFLAG: FLAG1 Mask              */
#define SCT_EVFLAG_FLAG2_Pos                                  2                                                         /*!< SCT EVFLAG: FLAG2 Position          */
#define SCT_EVFLAG_FLAG2_Msk                                  (0x01UL << SCT_EVFLAG_FLAG2_Pos)                          /*!< SCT EVFLAG: FLAG2 Mask              */
#define SCT_EVFLAG_FLAG3_Pos                                  3                                                         /*!< SCT EVFLAG: FLAG3 Position          */
#define SCT_EVFLAG_FLAG3_Msk                                  (0x01UL << SCT_EVFLAG_FLAG3_Pos)                          /*!< SCT EVFLAG: FLAG3 Mask              */
#define SCT_EVFLAG_FLAG4_Pos                                  4                                                         /*!< SCT EVFLAG: FLAG4 Position          */
#define SCT_EVFLAG_FLAG4_Msk                                  (0x01UL << SCT_EVFLAG_FLAG4_Pos)                          /*!< SCT EVFLAG: FLAG4 Mask              */
#define SCT_EVFLAG_FLAG5_Pos                                  5                                                         /*!< SCT EVFLAG: FLAG5 Position          */
#define SCT_EVFLAG_FLAG5_Msk                                  (0x01UL << SCT_EVFLAG_FLAG5_Pos)                          /*!< SCT EVFLAG: FLAG5 Mask              */
#define SCT_EVFLAG_FLAG6_Pos                                  6                                                         /*!< SCT EVFLAG: FLAG6 Position          */
#define SCT_EVFLAG_FLAG6_Msk                                  (0x01UL << SCT_EVFLAG_FLAG6_Pos)                          /*!< SCT EVFLAG: FLAG6 Mask              */
#define SCT_EVFLAG_FLAG7_Pos                                  7                                                         /*!< SCT EVFLAG: FLAG7 Position          */
#define SCT_EVFLAG_FLAG7_Msk                                  (0x01UL << SCT_EVFLAG_FLAG7_Pos)                          /*!< SCT EVFLAG: FLAG7 Mask              */
#define SCT_EVFLAG_FLAG8_Pos                                  8                                                         /*!< SCT EVFLAG: FLAG8 Position          */
#define SCT_EVFLAG_FLAG8_Msk                                  (0x01UL << SCT_EVFLAG_FLAG8_Pos)                          /*!< SCT EVFLAG: FLAG8 Mask              */
#define SCT_EVFLAG_FLAG9_Pos                                  9                                                         /*!< SCT EVFLAG: FLAG9 Position          */
#define SCT_EVFLAG_FLAG9_Msk                                  (0x01UL << SCT_EVFLAG_FLAG9_Pos)                          /*!< SCT EVFLAG: FLAG9 Mask              */
#define SCT_EVFLAG_FLAG10_Pos                                 10                                                        /*!< SCT EVFLAG: FLAG10 Position         */
#define SCT_EVFLAG_FLAG10_Msk                                 (0x01UL << SCT_EVFLAG_FLAG10_Pos)                         /*!< SCT EVFLAG: FLAG10 Mask             */
#define SCT_EVFLAG_FLAG11_Pos                                 11                                                        /*!< SCT EVFLAG: FLAG11 Position         */
#define SCT_EVFLAG_FLAG11_Msk                                 (0x01UL << SCT_EVFLAG_FLAG11_Pos)                         /*!< SCT EVFLAG: FLAG11 Mask             */
#define SCT_EVFLAG_FLAG12_Pos                                 12                                                        /*!< SCT EVFLAG: FLAG12 Position         */
#define SCT_EVFLAG_FLAG12_Msk                                 (0x01UL << SCT_EVFLAG_FLAG12_Pos)                         /*!< SCT EVFLAG: FLAG12 Mask             */
#define SCT_EVFLAG_FLAG13_Pos                                 13                                                        /*!< SCT EVFLAG: FLAG13 Position         */
#define SCT_EVFLAG_FLAG13_Msk                                 (0x01UL << SCT_EVFLAG_FLAG13_Pos)                         /*!< SCT EVFLAG: FLAG13 Mask             */
#define SCT_EVFLAG_FLAG14_Pos                                 14                                                        /*!< SCT EVFLAG: FLAG14 Position         */
#define SCT_EVFLAG_FLAG14_Msk                                 (0x01UL << SCT_EVFLAG_FLAG14_Pos)                         /*!< SCT EVFLAG: FLAG14 Mask             */
#define SCT_EVFLAG_FLAG15_Pos                                 15                                                        /*!< SCT EVFLAG: FLAG15 Position         */
#define SCT_EVFLAG_FLAG15_Msk                                 (0x01UL << SCT_EVFLAG_FLAG15_Pos)                         /*!< SCT EVFLAG: FLAG15 Mask             */

// ----------------------------------------  SCT_CONEN  -------------------------------------------
#define SCT_CONEN_NCEN0_Pos                                   0                                                         /*!< SCT CONEN: NCEN0 Position           */
#define SCT_CONEN_NCEN0_Msk                                   (0x01UL << SCT_CONEN_NCEN0_Pos)                           /*!< SCT CONEN: NCEN0 Mask               */
#define SCT_CONEN_NCEN1_Pos                                   1                                                         /*!< SCT CONEN: NCEN1 Position           */
#define SCT_CONEN_NCEN1_Msk                                   (0x01UL << SCT_CONEN_NCEN1_Pos)                           /*!< SCT CONEN: NCEN1 Mask               */
#define SCT_CONEN_NCEN2_Pos                                   2                                                         /*!< SCT CONEN: NCEN2 Position           */
#define SCT_CONEN_NCEN2_Msk                                   (0x01UL << SCT_CONEN_NCEN2_Pos)                           /*!< SCT CONEN: NCEN2 Mask               */
#define SCT_CONEN_NCEN3_Pos                                   3                                                         /*!< SCT CONEN: NCEN3 Position           */
#define SCT_CONEN_NCEN3_Msk                                   (0x01UL << SCT_CONEN_NCEN3_Pos)                           /*!< SCT CONEN: NCEN3 Mask               */
#define SCT_CONEN_NCEN4_Pos                                   4                                                         /*!< SCT CONEN: NCEN4 Position           */
#define SCT_CONEN_NCEN4_Msk                                   (0x01UL << SCT_CONEN_NCEN4_Pos)                           /*!< SCT CONEN: NCEN4 Mask               */
#define SCT_CONEN_NCEN5_Pos                                   5                                                         /*!< SCT CONEN: NCEN5 Position           */
#define SCT_CONEN_NCEN5_Msk                                   (0x01UL << SCT_CONEN_NCEN5_Pos)                           /*!< SCT CONEN: NCEN5 Mask               */
#define SCT_CONEN_NCEN6_Pos                                   6                                                         /*!< SCT CONEN: NCEN6 Position           */
#define SCT_CONEN_NCEN6_Msk                                   (0x01UL << SCT_CONEN_NCEN6_Pos)                           /*!< SCT CONEN: NCEN6 Mask               */
#define SCT_CONEN_NCEN7_Pos                                   7                                                         /*!< SCT CONEN: NCEN7 Position           */
#define SCT_CONEN_NCEN7_Msk                                   (0x01UL << SCT_CONEN_NCEN7_Pos)                           /*!< SCT CONEN: NCEN7 Mask               */
#define SCT_CONEN_NCEN8_Pos                                   8                                                         /*!< SCT CONEN: NCEN8 Position           */
#define SCT_CONEN_NCEN8_Msk                                   (0x01UL << SCT_CONEN_NCEN8_Pos)                           /*!< SCT CONEN: NCEN8 Mask               */
#define SCT_CONEN_NCEN9_Pos                                   9                                                         /*!< SCT CONEN: NCEN9 Position           */
#define SCT_CONEN_NCEN9_Msk                                   (0x01UL << SCT_CONEN_NCEN9_Pos)                           /*!< SCT CONEN: NCEN9 Mask               */
#define SCT_CONEN_NCEN10_Pos                                  10                                                        /*!< SCT CONEN: NCEN10 Position          */
#define SCT_CONEN_NCEN10_Msk                                  (0x01UL << SCT_CONEN_NCEN10_Pos)                          /*!< SCT CONEN: NCEN10 Mask              */
#define SCT_CONEN_NCEN11_Pos                                  11                                                        /*!< SCT CONEN: NCEN11 Position          */
#define SCT_CONEN_NCEN11_Msk                                  (0x01UL << SCT_CONEN_NCEN11_Pos)                          /*!< SCT CONEN: NCEN11 Mask              */
#define SCT_CONEN_NCEN12_Pos                                  12                                                        /*!< SCT CONEN: NCEN12 Position          */
#define SCT_CONEN_NCEN12_Msk                                  (0x01UL << SCT_CONEN_NCEN12_Pos)                          /*!< SCT CONEN: NCEN12 Mask              */
#define SCT_CONEN_NCEN13_Pos                                  13                                                        /*!< SCT CONEN: NCEN13 Position          */
#define SCT_CONEN_NCEN13_Msk                                  (0x01UL << SCT_CONEN_NCEN13_Pos)                          /*!< SCT CONEN: NCEN13 Mask              */
#define SCT_CONEN_NCEN14_Pos                                  14                                                        /*!< SCT CONEN: NCEN14 Position          */
#define SCT_CONEN_NCEN14_Msk                                  (0x01UL << SCT_CONEN_NCEN14_Pos)                          /*!< SCT CONEN: NCEN14 Mask              */
#define SCT_CONEN_NCEN15_Pos                                  15                                                        /*!< SCT CONEN: NCEN15 Position          */
#define SCT_CONEN_NCEN15_Msk                                  (0x01UL << SCT_CONEN_NCEN15_Pos)                          /*!< SCT CONEN: NCEN15 Mask              */

// ---------------------------------------  SCT_CONFLAG  ------------------------------------------
#define SCT_CONFLAG_NCFLAG0_Pos                               0                                                         /*!< SCT CONFLAG: NCFLAG0 Position       */
#define SCT_CONFLAG_NCFLAG0_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG0_Pos)                       /*!< SCT CONFLAG: NCFLAG0 Mask           */
#define SCT_CONFLAG_NCFLAG1_Pos                               1                                                         /*!< SCT CONFLAG: NCFLAG1 Position       */
#define SCT_CONFLAG_NCFLAG1_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG1_Pos)                       /*!< SCT CONFLAG: NCFLAG1 Mask           */
#define SCT_CONFLAG_NCFLAG2_Pos                               2                                                         /*!< SCT CONFLAG: NCFLAG2 Position       */
#define SCT_CONFLAG_NCFLAG2_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG2_Pos)                       /*!< SCT CONFLAG: NCFLAG2 Mask           */
#define SCT_CONFLAG_NCFLAG3_Pos                               3                                                         /*!< SCT CONFLAG: NCFLAG3 Position       */
#define SCT_CONFLAG_NCFLAG3_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG3_Pos)                       /*!< SCT CONFLAG: NCFLAG3 Mask           */
#define SCT_CONFLAG_NCFLAG4_Pos                               4                                                         /*!< SCT CONFLAG: NCFLAG4 Position       */
#define SCT_CONFLAG_NCFLAG4_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG4_Pos)                       /*!< SCT CONFLAG: NCFLAG4 Mask           */
#define SCT_CONFLAG_NCFLAG5_Pos                               5                                                         /*!< SCT CONFLAG: NCFLAG5 Position       */
#define SCT_CONFLAG_NCFLAG5_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG5_Pos)                       /*!< SCT CONFLAG: NCFLAG5 Mask           */
#define SCT_CONFLAG_NCFLAG6_Pos                               6                                                         /*!< SCT CONFLAG: NCFLAG6 Position       */
#define SCT_CONFLAG_NCFLAG6_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG6_Pos)                       /*!< SCT CONFLAG: NCFLAG6 Mask           */
#define SCT_CONFLAG_NCFLAG7_Pos                               7                                                         /*!< SCT CONFLAG: NCFLAG7 Position       */
#define SCT_CONFLAG_NCFLAG7_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG7_Pos)                       /*!< SCT CONFLAG: NCFLAG7 Mask           */
#define SCT_CONFLAG_NCFLAG8_Pos                               8                                                         /*!< SCT CONFLAG: NCFLAG8 Position       */
#define SCT_CONFLAG_NCFLAG8_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG8_Pos)                       /*!< SCT CONFLAG: NCFLAG8 Mask           */
#define SCT_CONFLAG_NCFLAG9_Pos                               9                                                         /*!< SCT CONFLAG: NCFLAG9 Position       */
#define SCT_CONFLAG_NCFLAG9_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG9_Pos)                       /*!< SCT CONFLAG: NCFLAG9 Mask           */
#define SCT_CONFLAG_NCFLAG10_Pos                              10                                                        /*!< SCT CONFLAG: NCFLAG10 Position      */
#define SCT_CONFLAG_NCFLAG10_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG10_Pos)                      /*!< SCT CONFLAG: NCFLAG10 Mask          */
#define SCT_CONFLAG_NCFLAG11_Pos                              11                                                        /*!< SCT CONFLAG: NCFLAG11 Position      */
#define SCT_CONFLAG_NCFLAG11_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG11_Pos)                      /*!< SCT CONFLAG: NCFLAG11 Mask          */
#define SCT_CONFLAG_NCFLAG12_Pos                              12                                                        /*!< SCT CONFLAG: NCFLAG12 Position      */
#define SCT_CONFLAG_NCFLAG12_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG12_Pos)                      /*!< SCT CONFLAG: NCFLAG12 Mask          */
#define SCT_CONFLAG_NCFLAG13_Pos                              13                                                        /*!< SCT CONFLAG: NCFLAG13 Position      */
#define SCT_CONFLAG_NCFLAG13_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG13_Pos)                      /*!< SCT CONFLAG: NCFLAG13 Mask          */
#define SCT_CONFLAG_NCFLAG14_Pos                              14                                                        /*!< SCT CONFLAG: NCFLAG14 Position      */
#define SCT_CONFLAG_NCFLAG14_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG14_Pos)                      /*!< SCT CONFLAG: NCFLAG14 Mask          */
#define SCT_CONFLAG_NCFLAG15_Pos                              15                                                        /*!< SCT CONFLAG: NCFLAG15 Position      */
#define SCT_CONFLAG_NCFLAG15_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG15_Pos)                      /*!< SCT CONFLAG: NCFLAG15 Mask          */
#define SCT_CONFLAG_BUSERRL_Pos                               30                                                        /*!< SCT CONFLAG: BUSERRL Position       */
#define SCT_CONFLAG_BUSERRL_Msk                               (0x01UL << SCT_CONFLAG_BUSERRL_Pos)                       /*!< SCT CONFLAG: BUSERRL Mask           */
#define SCT_CONFLAG_BUSERRH_Pos                               31                                                        /*!< SCT CONFLAG: BUSERRH Position       */
#define SCT_CONFLAG_BUSERRH_Msk                               (0x01UL << SCT_CONFLAG_BUSERRH_Pos)                       /*!< SCT CONFLAG: BUSERRH Mask           */

// ---------------------------------------  SCT_MATCH0  -------------------------------------------
#define SCT_MATCH0_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH0: MATCHn_L Position       */
#define SCT_MATCH0_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH0_MATCHn_L_Pos)                 /*!< SCT MATCH0: MATCHn_L Mask           */
#define SCT_MATCH0_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH0: MATCHn_H Position       */
#define SCT_MATCH0_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH0_MATCHn_H_Pos)                 /*!< SCT MATCH0: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP0  --------------------------------------------
#define SCT_CAP0_CAPn_L_Pos                                   0                                                         /*!< SCT CAP0: CAPn_L Position           */
#define SCT_CAP0_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP0_CAPn_L_Pos)                     /*!< SCT CAP0: CAPn_L Mask               */
#define SCT_CAP0_CAPn_H_Pos                                   16                                                        /*!< SCT CAP0: CAPn_H Position           */
#define SCT_CAP0_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP0_CAPn_H_Pos)                     /*!< SCT CAP0: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH1  -------------------------------------------
#define SCT_MATCH1_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH1: MATCHn_L Position       */
#define SCT_MATCH1_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH1_MATCHn_L_Pos)                 /*!< SCT MATCH1: MATCHn_L Mask           */
#define SCT_MATCH1_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH1: MATCHn_H Position       */
#define SCT_MATCH1_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH1_MATCHn_H_Pos)                 /*!< SCT MATCH1: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP1  --------------------------------------------
#define SCT_CAP1_CAPn_L_Pos                                   0                                                         /*!< SCT CAP1: CAPn_L Position           */
#define SCT_CAP1_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP1_CAPn_L_Pos)                     /*!< SCT CAP1: CAPn_L Mask               */
#define SCT_CAP1_CAPn_H_Pos                                   16                                                        /*!< SCT CAP1: CAPn_H Position           */
#define SCT_CAP1_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP1_CAPn_H_Pos)                     /*!< SCT CAP1: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH2  -------------------------------------------
#define SCT_MATCH2_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH2: MATCHn_L Position       */
#define SCT_MATCH2_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH2_MATCHn_L_Pos)                 /*!< SCT MATCH2: MATCHn_L Mask           */
#define SCT_MATCH2_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH2: MATCHn_H Position       */
#define SCT_MATCH2_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH2_MATCHn_H_Pos)                 /*!< SCT MATCH2: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP2  --------------------------------------------
#define SCT_CAP2_CAPn_L_Pos                                   0                                                         /*!< SCT CAP2: CAPn_L Position           */
#define SCT_CAP2_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP2_CAPn_L_Pos)                     /*!< SCT CAP2: CAPn_L Mask               */
#define SCT_CAP2_CAPn_H_Pos                                   16                                                        /*!< SCT CAP2: CAPn_H Position           */
#define SCT_CAP2_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP2_CAPn_H_Pos)                     /*!< SCT CAP2: CAPn_H Mask               */

// ----------------------------------------  SCT_CAP3  --------------------------------------------
#define SCT_CAP3_CAPn_L_Pos                                   0                                                         /*!< SCT CAP3: CAPn_L Position           */
#define SCT_CAP3_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP3_CAPn_L_Pos)                     /*!< SCT CAP3: CAPn_L Mask               */
#define SCT_CAP3_CAPn_H_Pos                                   16                                                        /*!< SCT CAP3: CAPn_H Position           */
#define SCT_CAP3_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP3_CAPn_H_Pos)                     /*!< SCT CAP3: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH3  -------------------------------------------
#define SCT_MATCH3_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH3: MATCHn_L Position       */
#define SCT_MATCH3_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH3_MATCHn_L_Pos)                 /*!< SCT MATCH3: MATCHn_L Mask           */
#define SCT_MATCH3_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH3: MATCHn_H Position       */
#define SCT_MATCH3_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH3_MATCHn_H_Pos)                 /*!< SCT MATCH3: MATCHn_H Mask           */

// ---------------------------------------  SCT_MATCH4  -------------------------------------------
#define SCT_MATCH4_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH4: MATCHn_L Position       */
#define SCT_MATCH4_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH4_MATCHn_L_Pos)                 /*!< SCT MATCH4: MATCHn_L Mask           */
#define SCT_MATCH4_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH4: MATCHn_H Position       */
#define SCT_MATCH4_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH4_MATCHn_H_Pos)                 /*!< SCT MATCH4: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP4  --------------------------------------------
#define SCT_CAP4_CAPn_L_Pos                                   0                                                         /*!< SCT CAP4: CAPn_L Position           */
#define SCT_CAP4_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP4_CAPn_L_Pos)                     /*!< SCT CAP4: CAPn_L Mask               */
#define SCT_CAP4_CAPn_H_Pos                                   16                                                        /*!< SCT CAP4: CAPn_H Position           */
#define SCT_CAP4_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP4_CAPn_H_Pos)                     /*!< SCT CAP4: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH5  -------------------------------------------
#define SCT_MATCH5_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH5: MATCHn_L Position       */
#define SCT_MATCH5_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH5_MATCHn_L_Pos)                 /*!< SCT MATCH5: MATCHn_L Mask           */
#define SCT_MATCH5_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH5: MATCHn_H Position       */
#define SCT_MATCH5_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH5_MATCHn_H_Pos)                 /*!< SCT MATCH5: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP5  --------------------------------------------
#define SCT_CAP5_CAPn_L_Pos                                   0                                                         /*!< SCT CAP5: CAPn_L Position           */
#define SCT_CAP5_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP5_CAPn_L_Pos)                     /*!< SCT CAP5: CAPn_L Mask               */
#define SCT_CAP5_CAPn_H_Pos                                   16                                                        /*!< SCT CAP5: CAPn_H Position           */
#define SCT_CAP5_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP5_CAPn_H_Pos)                     /*!< SCT CAP5: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH6  -------------------------------------------
#define SCT_MATCH6_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH6: MATCHn_L Position       */
#define SCT_MATCH6_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH6_MATCHn_L_Pos)                 /*!< SCT MATCH6: MATCHn_L Mask           */
#define SCT_MATCH6_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH6: MATCHn_H Position       */
#define SCT_MATCH6_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH6_MATCHn_H_Pos)                 /*!< SCT MATCH6: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP6  --------------------------------------------
#define SCT_CAP6_CAPn_L_Pos                                   0                                                         /*!< SCT CAP6: CAPn_L Position           */
#define SCT_CAP6_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP6_CAPn_L_Pos)                     /*!< SCT CAP6: CAPn_L Mask               */
#define SCT_CAP6_CAPn_H_Pos                                   16                                                        /*!< SCT CAP6: CAPn_H Position           */
#define SCT_CAP6_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP6_CAPn_H_Pos)                     /*!< SCT CAP6: CAPn_H Mask               */

// ----------------------------------------  SCT_CAP7  --------------------------------------------
#define SCT_CAP7_CAPn_L_Pos                                   0                                                         /*!< SCT CAP7: CAPn_L Position           */
#define SCT_CAP7_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP7_CAPn_L_Pos)                     /*!< SCT CAP7: CAPn_L Mask               */
#define SCT_CAP7_CAPn_H_Pos                                   16                                                        /*!< SCT CAP7: CAPn_H Position           */
#define SCT_CAP7_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP7_CAPn_H_Pos)                     /*!< SCT CAP7: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH7  -------------------------------------------
#define SCT_MATCH7_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH7: MATCHn_L Position       */
#define SCT_MATCH7_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH7_MATCHn_L_Pos)                 /*!< SCT MATCH7: MATCHn_L Mask           */
#define SCT_MATCH7_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH7: MATCHn_H Position       */
#define SCT_MATCH7_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH7_MATCHn_H_Pos)                 /*!< SCT MATCH7: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP8  --------------------------------------------
#define SCT_CAP8_CAPn_L_Pos                                   0                                                         /*!< SCT CAP8: CAPn_L Position           */
#define SCT_CAP8_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP8_CAPn_L_Pos)                     /*!< SCT CAP8: CAPn_L Mask               */
#define SCT_CAP8_CAPn_H_Pos                                   16                                                        /*!< SCT CAP8: CAPn_H Position           */
#define SCT_CAP8_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP8_CAPn_H_Pos)                     /*!< SCT CAP8: CAPn_H Mask               */

// ---------------------------------------  SCT_MATCH8  -------------------------------------------
#define SCT_MATCH8_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH8: MATCHn_L Position       */
#define SCT_MATCH8_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH8_MATCHn_L_Pos)                 /*!< SCT MATCH8: MATCHn_L Mask           */
#define SCT_MATCH8_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH8: MATCHn_H Position       */
#define SCT_MATCH8_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH8_MATCHn_H_Pos)                 /*!< SCT MATCH8: MATCHn_H Mask           */

// ---------------------------------------  SCT_MATCH9  -------------------------------------------
#define SCT_MATCH9_MATCHn_L_Pos                               0                                                         /*!< SCT MATCH9: MATCHn_L Position       */
#define SCT_MATCH9_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH9_MATCHn_L_Pos)                 /*!< SCT MATCH9: MATCHn_L Mask           */
#define SCT_MATCH9_MATCHn_H_Pos                               16                                                        /*!< SCT MATCH9: MATCHn_H Position       */
#define SCT_MATCH9_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH9_MATCHn_H_Pos)                 /*!< SCT MATCH9: MATCHn_H Mask           */

// ----------------------------------------  SCT_CAP9  --------------------------------------------
#define SCT_CAP9_CAPn_L_Pos                                   0                                                         /*!< SCT CAP9: CAPn_L Position           */
#define SCT_CAP9_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP9_CAPn_L_Pos)                     /*!< SCT CAP9: CAPn_L Mask               */
#define SCT_CAP9_CAPn_H_Pos                                   16                                                        /*!< SCT CAP9: CAPn_H Position           */
#define SCT_CAP9_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP9_CAPn_H_Pos)                     /*!< SCT CAP9: CAPn_H Mask               */

// ----------------------------------------  SCT_CAP10  -------------------------------------------
#define SCT_CAP10_CAPn_L_Pos                                  0                                                         /*!< SCT CAP10: CAPn_L Position          */
#define SCT_CAP10_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP10_CAPn_L_Pos)                    /*!< SCT CAP10: CAPn_L Mask              */
#define SCT_CAP10_CAPn_H_Pos                                  16                                                        /*!< SCT CAP10: CAPn_H Position          */
#define SCT_CAP10_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP10_CAPn_H_Pos)                    /*!< SCT CAP10: CAPn_H Mask              */

// ---------------------------------------  SCT_MATCH10  ------------------------------------------
#define SCT_MATCH10_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH10: MATCHn_L Position      */
#define SCT_MATCH10_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH10_MATCHn_L_Pos)                /*!< SCT MATCH10: MATCHn_L Mask          */
#define SCT_MATCH10_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH10: MATCHn_H Position      */
#define SCT_MATCH10_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH10_MATCHn_H_Pos)                /*!< SCT MATCH10: MATCHn_H Mask          */

// ----------------------------------------  SCT_CAP11  -------------------------------------------
#define SCT_CAP11_CAPn_L_Pos                                  0                                                         /*!< SCT CAP11: CAPn_L Position          */
#define SCT_CAP11_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP11_CAPn_L_Pos)                    /*!< SCT CAP11: CAPn_L Mask              */
#define SCT_CAP11_CAPn_H_Pos                                  16                                                        /*!< SCT CAP11: CAPn_H Position          */
#define SCT_CAP11_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP11_CAPn_H_Pos)                    /*!< SCT CAP11: CAPn_H Mask              */

// ---------------------------------------  SCT_MATCH11  ------------------------------------------
#define SCT_MATCH11_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH11: MATCHn_L Position      */
#define SCT_MATCH11_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH11_MATCHn_L_Pos)                /*!< SCT MATCH11: MATCHn_L Mask          */
#define SCT_MATCH11_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH11: MATCHn_H Position      */
#define SCT_MATCH11_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH11_MATCHn_H_Pos)                /*!< SCT MATCH11: MATCHn_H Mask          */

// ---------------------------------------  SCT_MATCH12  ------------------------------------------
#define SCT_MATCH12_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH12: MATCHn_L Position      */
#define SCT_MATCH12_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH12_MATCHn_L_Pos)                /*!< SCT MATCH12: MATCHn_L Mask          */
#define SCT_MATCH12_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH12: MATCHn_H Position      */
#define SCT_MATCH12_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH12_MATCHn_H_Pos)                /*!< SCT MATCH12: MATCHn_H Mask          */

// ----------------------------------------  SCT_CAP12  -------------------------------------------
#define SCT_CAP12_CAPn_L_Pos                                  0                                                         /*!< SCT CAP12: CAPn_L Position          */
#define SCT_CAP12_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP12_CAPn_L_Pos)                    /*!< SCT CAP12: CAPn_L Mask              */
#define SCT_CAP12_CAPn_H_Pos                                  16                                                        /*!< SCT CAP12: CAPn_H Position          */
#define SCT_CAP12_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP12_CAPn_H_Pos)                    /*!< SCT CAP12: CAPn_H Mask              */

// ----------------------------------------  SCT_CAP13  -------------------------------------------
#define SCT_CAP13_CAPn_L_Pos                                  0                                                         /*!< SCT CAP13: CAPn_L Position          */
#define SCT_CAP13_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP13_CAPn_L_Pos)                    /*!< SCT CAP13: CAPn_L Mask              */
#define SCT_CAP13_CAPn_H_Pos                                  16                                                        /*!< SCT CAP13: CAPn_H Position          */
#define SCT_CAP13_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP13_CAPn_H_Pos)                    /*!< SCT CAP13: CAPn_H Mask              */

// ---------------------------------------  SCT_MATCH13  ------------------------------------------
#define SCT_MATCH13_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH13: MATCHn_L Position      */
#define SCT_MATCH13_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH13_MATCHn_L_Pos)                /*!< SCT MATCH13: MATCHn_L Mask          */
#define SCT_MATCH13_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH13: MATCHn_H Position      */
#define SCT_MATCH13_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH13_MATCHn_H_Pos)                /*!< SCT MATCH13: MATCHn_H Mask          */

// ---------------------------------------  SCT_MATCH14  ------------------------------------------
#define SCT_MATCH14_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH14: MATCHn_L Position      */
#define SCT_MATCH14_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH14_MATCHn_L_Pos)                /*!< SCT MATCH14: MATCHn_L Mask          */
#define SCT_MATCH14_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH14: MATCHn_H Position      */
#define SCT_MATCH14_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH14_MATCHn_H_Pos)                /*!< SCT MATCH14: MATCHn_H Mask          */

// ----------------------------------------  SCT_CAP14  -------------------------------------------
#define SCT_CAP14_CAPn_L_Pos                                  0                                                         /*!< SCT CAP14: CAPn_L Position          */
#define SCT_CAP14_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP14_CAPn_L_Pos)                    /*!< SCT CAP14: CAPn_L Mask              */
#define SCT_CAP14_CAPn_H_Pos                                  16                                                        /*!< SCT CAP14: CAPn_H Position          */
#define SCT_CAP14_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP14_CAPn_H_Pos)                    /*!< SCT CAP14: CAPn_H Mask              */

// ---------------------------------------  SCT_MATCH15  ------------------------------------------
#define SCT_MATCH15_MATCHn_L_Pos                              0                                                         /*!< SCT MATCH15: MATCHn_L Position      */
#define SCT_MATCH15_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH15_MATCHn_L_Pos)                /*!< SCT MATCH15: MATCHn_L Mask          */
#define SCT_MATCH15_MATCHn_H_Pos                              16                                                        /*!< SCT MATCH15: MATCHn_H Position      */
#define SCT_MATCH15_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH15_MATCHn_H_Pos)                /*!< SCT MATCH15: MATCHn_H Mask          */

// ----------------------------------------  SCT_CAP15  -------------------------------------------
#define SCT_CAP15_CAPn_L_Pos                                  0                                                         /*!< SCT CAP15: CAPn_L Position          */
#define SCT_CAP15_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP15_CAPn_L_Pos)                    /*!< SCT CAP15: CAPn_L Mask              */
#define SCT_CAP15_CAPn_H_Pos                                  16                                                        /*!< SCT CAP15: CAPn_H Position          */
#define SCT_CAP15_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP15_CAPn_H_Pos)                    /*!< SCT CAP15: CAPn_H Mask              */

// --------------------------------------  SCT_MATCHREL0  -----------------------------------------
#define SCT_MATCHREL0_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL0: RELOADn_L Position   */
#define SCT_MATCHREL0_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL0_RELOADn_L_Pos)             /*!< SCT MATCHREL0: RELOADn_L Mask       */
#define SCT_MATCHREL0_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL0: RELOADn_H Position   */
#define SCT_MATCHREL0_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL0_RELOADn_H_Pos)             /*!< SCT MATCHREL0: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL0  ------------------------------------------
#define SCT_CAPCTRL0_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL0: CAPCONn_L0 Position   */
#define SCT_CAPCTRL0_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL0: CAPCONn_L1 Position   */
#define SCT_CAPCTRL0_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL0: CAPCONn_L2 Position   */
#define SCT_CAPCTRL0_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL0: CAPCONn_L3 Position   */
#define SCT_CAPCTRL0_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL0: CAPCONn_L4 Position   */
#define SCT_CAPCTRL0_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL0: CAPCONn_L5 Position   */
#define SCT_CAPCTRL0_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL0: CAPCONn_L6 Position   */
#define SCT_CAPCTRL0_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL0: CAPCONn_L7 Position   */
#define SCT_CAPCTRL0_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL0: CAPCONn_L8 Position   */
#define SCT_CAPCTRL0_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL0: CAPCONn_L9 Position   */
#define SCT_CAPCTRL0_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL0: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL0_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL0: CAPCONn_L10 Position  */
#define SCT_CAPCTRL0_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL0_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL0: CAPCONn_L11 Position  */
#define SCT_CAPCTRL0_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL0_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL0: CAPCONn_L12 Position  */
#define SCT_CAPCTRL0_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL0_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL0: CAPCONn_L13 Position  */
#define SCT_CAPCTRL0_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL0_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL0: CAPCONn_L14 Position  */
#define SCT_CAPCTRL0_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL0_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL0: CAPCONn_L15 Position  */
#define SCT_CAPCTRL0_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL0: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL0_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL0: CAPCONn_H Position    */
#define SCT_CAPCTRL0_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL0_CAPCONn_H_Pos)              /*!< SCT CAPCTRL0: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL1  -----------------------------------------
#define SCT_MATCHREL1_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL1: RELOADn_L Position   */
#define SCT_MATCHREL1_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL1_RELOADn_L_Pos)             /*!< SCT MATCHREL1: RELOADn_L Mask       */
#define SCT_MATCHREL1_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL1: RELOADn_H Position   */
#define SCT_MATCHREL1_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL1_RELOADn_H_Pos)             /*!< SCT MATCHREL1: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL1  ------------------------------------------
#define SCT_CAPCTRL1_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL1: CAPCONn_L0 Position   */
#define SCT_CAPCTRL1_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL1: CAPCONn_L1 Position   */
#define SCT_CAPCTRL1_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL1: CAPCONn_L2 Position   */
#define SCT_CAPCTRL1_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL1: CAPCONn_L3 Position   */
#define SCT_CAPCTRL1_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL1: CAPCONn_L4 Position   */
#define SCT_CAPCTRL1_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL1: CAPCONn_L5 Position   */
#define SCT_CAPCTRL1_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL1: CAPCONn_L6 Position   */
#define SCT_CAPCTRL1_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL1: CAPCONn_L7 Position   */
#define SCT_CAPCTRL1_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL1: CAPCONn_L8 Position   */
#define SCT_CAPCTRL1_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL1: CAPCONn_L9 Position   */
#define SCT_CAPCTRL1_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL1: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL1_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL1: CAPCONn_L10 Position  */
#define SCT_CAPCTRL1_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL1_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL1: CAPCONn_L11 Position  */
#define SCT_CAPCTRL1_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL1_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL1: CAPCONn_L12 Position  */
#define SCT_CAPCTRL1_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL1_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL1: CAPCONn_L13 Position  */
#define SCT_CAPCTRL1_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL1_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL1: CAPCONn_L14 Position  */
#define SCT_CAPCTRL1_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL1_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL1: CAPCONn_L15 Position  */
#define SCT_CAPCTRL1_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL1: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL1_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL1: CAPCONn_H Position    */
#define SCT_CAPCTRL1_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL1_CAPCONn_H_Pos)              /*!< SCT CAPCTRL1: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL2  -----------------------------------------
#define SCT_MATCHREL2_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL2: RELOADn_L Position   */
#define SCT_MATCHREL2_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL2_RELOADn_L_Pos)             /*!< SCT MATCHREL2: RELOADn_L Mask       */
#define SCT_MATCHREL2_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL2: RELOADn_H Position   */
#define SCT_MATCHREL2_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL2_RELOADn_H_Pos)             /*!< SCT MATCHREL2: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL2  ------------------------------------------
#define SCT_CAPCTRL2_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL2: CAPCONn_L0 Position   */
#define SCT_CAPCTRL2_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL2: CAPCONn_L1 Position   */
#define SCT_CAPCTRL2_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL2: CAPCONn_L2 Position   */
#define SCT_CAPCTRL2_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL2: CAPCONn_L3 Position   */
#define SCT_CAPCTRL2_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL2: CAPCONn_L4 Position   */
#define SCT_CAPCTRL2_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL2: CAPCONn_L5 Position   */
#define SCT_CAPCTRL2_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL2: CAPCONn_L6 Position   */
#define SCT_CAPCTRL2_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL2: CAPCONn_L7 Position   */
#define SCT_CAPCTRL2_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL2: CAPCONn_L8 Position   */
#define SCT_CAPCTRL2_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL2: CAPCONn_L9 Position   */
#define SCT_CAPCTRL2_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL2: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL2_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL2: CAPCONn_L10 Position  */
#define SCT_CAPCTRL2_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL2_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL2: CAPCONn_L11 Position  */
#define SCT_CAPCTRL2_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL2_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL2: CAPCONn_L12 Position  */
#define SCT_CAPCTRL2_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL2_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL2: CAPCONn_L13 Position  */
#define SCT_CAPCTRL2_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL2_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL2: CAPCONn_L14 Position  */
#define SCT_CAPCTRL2_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL2_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL2: CAPCONn_L15 Position  */
#define SCT_CAPCTRL2_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL2: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL2_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL2: CAPCONn_H Position    */
#define SCT_CAPCTRL2_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL2_CAPCONn_H_Pos)              /*!< SCT CAPCTRL2: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL3  -----------------------------------------
#define SCT_MATCHREL3_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL3: RELOADn_L Position   */
#define SCT_MATCHREL3_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL3_RELOADn_L_Pos)             /*!< SCT MATCHREL3: RELOADn_L Mask       */
#define SCT_MATCHREL3_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL3: RELOADn_H Position   */
#define SCT_MATCHREL3_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL3_RELOADn_H_Pos)             /*!< SCT MATCHREL3: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL3  ------------------------------------------
#define SCT_CAPCTRL3_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL3: CAPCONn_L0 Position   */
#define SCT_CAPCTRL3_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL3: CAPCONn_L1 Position   */
#define SCT_CAPCTRL3_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL3: CAPCONn_L2 Position   */
#define SCT_CAPCTRL3_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL3: CAPCONn_L3 Position   */
#define SCT_CAPCTRL3_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL3: CAPCONn_L4 Position   */
#define SCT_CAPCTRL3_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL3: CAPCONn_L5 Position   */
#define SCT_CAPCTRL3_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL3: CAPCONn_L6 Position   */
#define SCT_CAPCTRL3_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL3: CAPCONn_L7 Position   */
#define SCT_CAPCTRL3_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL3: CAPCONn_L8 Position   */
#define SCT_CAPCTRL3_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL3: CAPCONn_L9 Position   */
#define SCT_CAPCTRL3_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL3: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL3_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL3: CAPCONn_L10 Position  */
#define SCT_CAPCTRL3_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL3_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL3: CAPCONn_L11 Position  */
#define SCT_CAPCTRL3_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL3_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL3: CAPCONn_L12 Position  */
#define SCT_CAPCTRL3_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL3_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL3: CAPCONn_L13 Position  */
#define SCT_CAPCTRL3_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL3_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL3: CAPCONn_L14 Position  */
#define SCT_CAPCTRL3_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL3_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL3: CAPCONn_L15 Position  */
#define SCT_CAPCTRL3_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL3: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL3_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL3: CAPCONn_H Position    */
#define SCT_CAPCTRL3_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL3_CAPCONn_H_Pos)              /*!< SCT CAPCTRL3: CAPCONn_H Mask        */

// --------------------------------------  SCT_CAPCTRL4  ------------------------------------------
#define SCT_CAPCTRL4_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL4: CAPCONn_L0 Position   */
#define SCT_CAPCTRL4_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL4: CAPCONn_L1 Position   */
#define SCT_CAPCTRL4_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL4: CAPCONn_L2 Position   */
#define SCT_CAPCTRL4_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL4: CAPCONn_L3 Position   */
#define SCT_CAPCTRL4_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL4: CAPCONn_L4 Position   */
#define SCT_CAPCTRL4_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL4: CAPCONn_L5 Position   */
#define SCT_CAPCTRL4_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL4: CAPCONn_L6 Position   */
#define SCT_CAPCTRL4_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL4: CAPCONn_L7 Position   */
#define SCT_CAPCTRL4_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL4: CAPCONn_L8 Position   */
#define SCT_CAPCTRL4_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL4: CAPCONn_L9 Position   */
#define SCT_CAPCTRL4_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL4: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL4_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL4: CAPCONn_L10 Position  */
#define SCT_CAPCTRL4_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL4_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL4: CAPCONn_L11 Position  */
#define SCT_CAPCTRL4_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL4_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL4: CAPCONn_L12 Position  */
#define SCT_CAPCTRL4_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL4_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL4: CAPCONn_L13 Position  */
#define SCT_CAPCTRL4_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL4_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL4: CAPCONn_L14 Position  */
#define SCT_CAPCTRL4_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL4_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL4: CAPCONn_L15 Position  */
#define SCT_CAPCTRL4_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL4: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL4_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL4: CAPCONn_H Position    */
#define SCT_CAPCTRL4_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL4_CAPCONn_H_Pos)              /*!< SCT CAPCTRL4: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL4  -----------------------------------------
#define SCT_MATCHREL4_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL4: RELOADn_L Position   */
#define SCT_MATCHREL4_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL4_RELOADn_L_Pos)             /*!< SCT MATCHREL4: RELOADn_L Mask       */
#define SCT_MATCHREL4_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL4: RELOADn_H Position   */
#define SCT_MATCHREL4_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL4_RELOADn_H_Pos)             /*!< SCT MATCHREL4: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL5  ------------------------------------------
#define SCT_CAPCTRL5_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL5: CAPCONn_L0 Position   */
#define SCT_CAPCTRL5_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL5: CAPCONn_L1 Position   */
#define SCT_CAPCTRL5_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL5: CAPCONn_L2 Position   */
#define SCT_CAPCTRL5_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL5: CAPCONn_L3 Position   */
#define SCT_CAPCTRL5_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL5: CAPCONn_L4 Position   */
#define SCT_CAPCTRL5_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL5: CAPCONn_L5 Position   */
#define SCT_CAPCTRL5_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL5: CAPCONn_L6 Position   */
#define SCT_CAPCTRL5_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL5: CAPCONn_L7 Position   */
#define SCT_CAPCTRL5_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL5: CAPCONn_L8 Position   */
#define SCT_CAPCTRL5_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL5: CAPCONn_L9 Position   */
#define SCT_CAPCTRL5_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL5: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL5_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL5: CAPCONn_L10 Position  */
#define SCT_CAPCTRL5_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL5_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL5: CAPCONn_L11 Position  */
#define SCT_CAPCTRL5_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL5_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL5: CAPCONn_L12 Position  */
#define SCT_CAPCTRL5_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL5_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL5: CAPCONn_L13 Position  */
#define SCT_CAPCTRL5_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL5_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL5: CAPCONn_L14 Position  */
#define SCT_CAPCTRL5_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL5_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL5: CAPCONn_L15 Position  */
#define SCT_CAPCTRL5_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL5: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL5_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL5: CAPCONn_H Position    */
#define SCT_CAPCTRL5_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL5_CAPCONn_H_Pos)              /*!< SCT CAPCTRL5: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL5  -----------------------------------------
#define SCT_MATCHREL5_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL5: RELOADn_L Position   */
#define SCT_MATCHREL5_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL5_RELOADn_L_Pos)             /*!< SCT MATCHREL5: RELOADn_L Mask       */
#define SCT_MATCHREL5_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL5: RELOADn_H Position   */
#define SCT_MATCHREL5_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL5_RELOADn_H_Pos)             /*!< SCT MATCHREL5: RELOADn_H Mask       */

// --------------------------------------  SCT_MATCHREL6  -----------------------------------------
#define SCT_MATCHREL6_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL6: RELOADn_L Position   */
#define SCT_MATCHREL6_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL6_RELOADn_L_Pos)             /*!< SCT MATCHREL6: RELOADn_L Mask       */
#define SCT_MATCHREL6_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL6: RELOADn_H Position   */
#define SCT_MATCHREL6_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL6_RELOADn_H_Pos)             /*!< SCT MATCHREL6: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL6  ------------------------------------------
#define SCT_CAPCTRL6_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL6: CAPCONn_L0 Position   */
#define SCT_CAPCTRL6_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL6: CAPCONn_L1 Position   */
#define SCT_CAPCTRL6_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL6: CAPCONn_L2 Position   */
#define SCT_CAPCTRL6_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL6: CAPCONn_L3 Position   */
#define SCT_CAPCTRL6_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL6: CAPCONn_L4 Position   */
#define SCT_CAPCTRL6_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL6: CAPCONn_L5 Position   */
#define SCT_CAPCTRL6_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL6: CAPCONn_L6 Position   */
#define SCT_CAPCTRL6_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL6: CAPCONn_L7 Position   */
#define SCT_CAPCTRL6_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL6: CAPCONn_L8 Position   */
#define SCT_CAPCTRL6_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL6: CAPCONn_L9 Position   */
#define SCT_CAPCTRL6_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL6: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL6_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL6: CAPCONn_L10 Position  */
#define SCT_CAPCTRL6_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL6_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL6: CAPCONn_L11 Position  */
#define SCT_CAPCTRL6_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL6_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL6: CAPCONn_L12 Position  */
#define SCT_CAPCTRL6_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL6_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL6: CAPCONn_L13 Position  */
#define SCT_CAPCTRL6_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL6_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL6: CAPCONn_L14 Position  */
#define SCT_CAPCTRL6_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL6_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL6: CAPCONn_L15 Position  */
#define SCT_CAPCTRL6_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL6: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL6_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL6: CAPCONn_H Position    */
#define SCT_CAPCTRL6_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL6_CAPCONn_H_Pos)              /*!< SCT CAPCTRL6: CAPCONn_H Mask        */

// --------------------------------------  SCT_CAPCTRL7  ------------------------------------------
#define SCT_CAPCTRL7_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL7: CAPCONn_L0 Position   */
#define SCT_CAPCTRL7_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL7: CAPCONn_L1 Position   */
#define SCT_CAPCTRL7_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL7: CAPCONn_L2 Position   */
#define SCT_CAPCTRL7_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL7: CAPCONn_L3 Position   */
#define SCT_CAPCTRL7_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL7: CAPCONn_L4 Position   */
#define SCT_CAPCTRL7_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL7: CAPCONn_L5 Position   */
#define SCT_CAPCTRL7_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL7: CAPCONn_L6 Position   */
#define SCT_CAPCTRL7_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL7: CAPCONn_L7 Position   */
#define SCT_CAPCTRL7_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL7: CAPCONn_L8 Position   */
#define SCT_CAPCTRL7_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL7: CAPCONn_L9 Position   */
#define SCT_CAPCTRL7_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL7: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL7_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL7: CAPCONn_L10 Position  */
#define SCT_CAPCTRL7_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL7_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL7: CAPCONn_L11 Position  */
#define SCT_CAPCTRL7_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL7_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL7: CAPCONn_L12 Position  */
#define SCT_CAPCTRL7_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL7_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL7: CAPCONn_L13 Position  */
#define SCT_CAPCTRL7_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL7_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL7: CAPCONn_L14 Position  */
#define SCT_CAPCTRL7_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL7_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL7: CAPCONn_L15 Position  */
#define SCT_CAPCTRL7_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL7: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL7_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL7: CAPCONn_H Position    */
#define SCT_CAPCTRL7_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL7_CAPCONn_H_Pos)              /*!< SCT CAPCTRL7: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL7  -----------------------------------------
#define SCT_MATCHREL7_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL7: RELOADn_L Position   */
#define SCT_MATCHREL7_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL7_RELOADn_L_Pos)             /*!< SCT MATCHREL7: RELOADn_L Mask       */
#define SCT_MATCHREL7_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL7: RELOADn_H Position   */
#define SCT_MATCHREL7_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL7_RELOADn_H_Pos)             /*!< SCT MATCHREL7: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL8  ------------------------------------------
#define SCT_CAPCTRL8_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL8: CAPCONn_L0 Position   */
#define SCT_CAPCTRL8_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL8: CAPCONn_L1 Position   */
#define SCT_CAPCTRL8_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL8: CAPCONn_L2 Position   */
#define SCT_CAPCTRL8_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL8: CAPCONn_L3 Position   */
#define SCT_CAPCTRL8_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL8: CAPCONn_L4 Position   */
#define SCT_CAPCTRL8_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL8: CAPCONn_L5 Position   */
#define SCT_CAPCTRL8_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL8: CAPCONn_L6 Position   */
#define SCT_CAPCTRL8_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL8: CAPCONn_L7 Position   */
#define SCT_CAPCTRL8_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL8: CAPCONn_L8 Position   */
#define SCT_CAPCTRL8_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL8: CAPCONn_L9 Position   */
#define SCT_CAPCTRL8_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL8: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL8_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL8: CAPCONn_L10 Position  */
#define SCT_CAPCTRL8_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL8_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL8: CAPCONn_L11 Position  */
#define SCT_CAPCTRL8_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL8_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL8: CAPCONn_L12 Position  */
#define SCT_CAPCTRL8_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL8_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL8: CAPCONn_L13 Position  */
#define SCT_CAPCTRL8_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL8_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL8: CAPCONn_L14 Position  */
#define SCT_CAPCTRL8_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL8_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL8: CAPCONn_L15 Position  */
#define SCT_CAPCTRL8_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL8: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL8_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL8: CAPCONn_H Position    */
#define SCT_CAPCTRL8_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL8_CAPCONn_H_Pos)              /*!< SCT CAPCTRL8: CAPCONn_H Mask        */

// --------------------------------------  SCT_MATCHREL8  -----------------------------------------
#define SCT_MATCHREL8_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL8: RELOADn_L Position   */
#define SCT_MATCHREL8_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL8_RELOADn_L_Pos)             /*!< SCT MATCHREL8: RELOADn_L Mask       */
#define SCT_MATCHREL8_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL8: RELOADn_H Position   */
#define SCT_MATCHREL8_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL8_RELOADn_H_Pos)             /*!< SCT MATCHREL8: RELOADn_H Mask       */

// --------------------------------------  SCT_MATCHREL9  -----------------------------------------
#define SCT_MATCHREL9_RELOADn_L_Pos                           0                                                         /*!< SCT MATCHREL9: RELOADn_L Position   */
#define SCT_MATCHREL9_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL9_RELOADn_L_Pos)             /*!< SCT MATCHREL9: RELOADn_L Mask       */
#define SCT_MATCHREL9_RELOADn_H_Pos                           16                                                        /*!< SCT MATCHREL9: RELOADn_H Position   */
#define SCT_MATCHREL9_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL9_RELOADn_H_Pos)             /*!< SCT MATCHREL9: RELOADn_H Mask       */

// --------------------------------------  SCT_CAPCTRL9  ------------------------------------------
#define SCT_CAPCTRL9_CAPCONn_L0_Pos                           0                                                         /*!< SCT CAPCTRL9: CAPCONn_L0 Position   */
#define SCT_CAPCTRL9_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L0_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L0 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L1_Pos                           1                                                         /*!< SCT CAPCTRL9: CAPCONn_L1 Position   */
#define SCT_CAPCTRL9_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L1_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L1 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L2_Pos                           2                                                         /*!< SCT CAPCTRL9: CAPCONn_L2 Position   */
#define SCT_CAPCTRL9_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L2_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L2 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L3_Pos                           3                                                         /*!< SCT CAPCTRL9: CAPCONn_L3 Position   */
#define SCT_CAPCTRL9_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L3_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L3 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L4_Pos                           4                                                         /*!< SCT CAPCTRL9: CAPCONn_L4 Position   */
#define SCT_CAPCTRL9_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L4_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L4 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L5_Pos                           5                                                         /*!< SCT CAPCTRL9: CAPCONn_L5 Position   */
#define SCT_CAPCTRL9_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L5_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L5 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L6_Pos                           6                                                         /*!< SCT CAPCTRL9: CAPCONn_L6 Position   */
#define SCT_CAPCTRL9_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L6_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L6 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L7_Pos                           7                                                         /*!< SCT CAPCTRL9: CAPCONn_L7 Position   */
#define SCT_CAPCTRL9_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L7_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L7 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L8_Pos                           8                                                         /*!< SCT CAPCTRL9: CAPCONn_L8 Position   */
#define SCT_CAPCTRL9_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L8_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L8 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L9_Pos                           9                                                         /*!< SCT CAPCTRL9: CAPCONn_L9 Position   */
#define SCT_CAPCTRL9_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L9_Pos)                   /*!< SCT CAPCTRL9: CAPCONn_L9 Mask       */
#define SCT_CAPCTRL9_CAPCONn_L10_Pos                          10                                                        /*!< SCT CAPCTRL9: CAPCONn_L10 Position  */
#define SCT_CAPCTRL9_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L10_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L10 Mask      */
#define SCT_CAPCTRL9_CAPCONn_L11_Pos                          11                                                        /*!< SCT CAPCTRL9: CAPCONn_L11 Position  */
#define SCT_CAPCTRL9_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L11_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L11 Mask      */
#define SCT_CAPCTRL9_CAPCONn_L12_Pos                          12                                                        /*!< SCT CAPCTRL9: CAPCONn_L12 Position  */
#define SCT_CAPCTRL9_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L12_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L12 Mask      */
#define SCT_CAPCTRL9_CAPCONn_L13_Pos                          13                                                        /*!< SCT CAPCTRL9: CAPCONn_L13 Position  */
#define SCT_CAPCTRL9_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L13_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L13 Mask      */
#define SCT_CAPCTRL9_CAPCONn_L14_Pos                          14                                                        /*!< SCT CAPCTRL9: CAPCONn_L14 Position  */
#define SCT_CAPCTRL9_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L14_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L14 Mask      */
#define SCT_CAPCTRL9_CAPCONn_L15_Pos                          15                                                        /*!< SCT CAPCTRL9: CAPCONn_L15 Position  */
#define SCT_CAPCTRL9_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L15_Pos)                  /*!< SCT CAPCTRL9: CAPCONn_L15 Mask      */
#define SCT_CAPCTRL9_CAPCONn_H_Pos                            16                                                        /*!< SCT CAPCTRL9: CAPCONn_H Position    */
#define SCT_CAPCTRL9_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL9_CAPCONn_H_Pos)              /*!< SCT CAPCTRL9: CAPCONn_H Mask        */

// -------------------------------------  SCT_MATCHREL10  -----------------------------------------
#define SCT_MATCHREL10_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL10: RELOADn_L Position  */
#define SCT_MATCHREL10_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL10_RELOADn_L_Pos)            /*!< SCT MATCHREL10: RELOADn_L Mask      */
#define SCT_MATCHREL10_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL10: RELOADn_H Position  */
#define SCT_MATCHREL10_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL10_RELOADn_H_Pos)            /*!< SCT MATCHREL10: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL10  -----------------------------------------
#define SCT_CAPCTRL10_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL10: CAPCONn_L0 Position  */
#define SCT_CAPCTRL10_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL10: CAPCONn_L1 Position  */
#define SCT_CAPCTRL10_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL10: CAPCONn_L2 Position  */
#define SCT_CAPCTRL10_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL10: CAPCONn_L3 Position  */
#define SCT_CAPCTRL10_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL10: CAPCONn_L4 Position  */
#define SCT_CAPCTRL10_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL10: CAPCONn_L5 Position  */
#define SCT_CAPCTRL10_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL10: CAPCONn_L6 Position  */
#define SCT_CAPCTRL10_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL10: CAPCONn_L7 Position  */
#define SCT_CAPCTRL10_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL10: CAPCONn_L8 Position  */
#define SCT_CAPCTRL10_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL10: CAPCONn_L9 Position  */
#define SCT_CAPCTRL10_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL10: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL10_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL10: CAPCONn_L10 Position */
#define SCT_CAPCTRL10_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL10_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL10: CAPCONn_L11 Position */
#define SCT_CAPCTRL10_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL10_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL10: CAPCONn_L12 Position */
#define SCT_CAPCTRL10_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL10_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL10: CAPCONn_L13 Position */
#define SCT_CAPCTRL10_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL10_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL10: CAPCONn_L14 Position */
#define SCT_CAPCTRL10_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL10_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL10: CAPCONn_L15 Position */
#define SCT_CAPCTRL10_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL10: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL10_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL10: CAPCONn_H Position   */
#define SCT_CAPCTRL10_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL10_CAPCONn_H_Pos)             /*!< SCT CAPCTRL10: CAPCONn_H Mask       */

// -------------------------------------  SCT_MATCHREL11  -----------------------------------------
#define SCT_MATCHREL11_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL11: RELOADn_L Position  */
#define SCT_MATCHREL11_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL11_RELOADn_L_Pos)            /*!< SCT MATCHREL11: RELOADn_L Mask      */
#define SCT_MATCHREL11_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL11: RELOADn_H Position  */
#define SCT_MATCHREL11_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL11_RELOADn_H_Pos)            /*!< SCT MATCHREL11: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL11  -----------------------------------------
#define SCT_CAPCTRL11_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL11: CAPCONn_L0 Position  */
#define SCT_CAPCTRL11_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL11: CAPCONn_L1 Position  */
#define SCT_CAPCTRL11_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL11: CAPCONn_L2 Position  */
#define SCT_CAPCTRL11_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL11: CAPCONn_L3 Position  */
#define SCT_CAPCTRL11_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL11: CAPCONn_L4 Position  */
#define SCT_CAPCTRL11_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL11: CAPCONn_L5 Position  */
#define SCT_CAPCTRL11_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL11: CAPCONn_L6 Position  */
#define SCT_CAPCTRL11_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL11: CAPCONn_L7 Position  */
#define SCT_CAPCTRL11_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL11: CAPCONn_L8 Position  */
#define SCT_CAPCTRL11_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL11: CAPCONn_L9 Position  */
#define SCT_CAPCTRL11_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL11: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL11_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL11: CAPCONn_L10 Position */
#define SCT_CAPCTRL11_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL11_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL11: CAPCONn_L11 Position */
#define SCT_CAPCTRL11_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL11_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL11: CAPCONn_L12 Position */
#define SCT_CAPCTRL11_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL11_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL11: CAPCONn_L13 Position */
#define SCT_CAPCTRL11_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL11_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL11: CAPCONn_L14 Position */
#define SCT_CAPCTRL11_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL11_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL11: CAPCONn_L15 Position */
#define SCT_CAPCTRL11_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL11: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL11_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL11: CAPCONn_H Position   */
#define SCT_CAPCTRL11_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL11_CAPCONn_H_Pos)             /*!< SCT CAPCTRL11: CAPCONn_H Mask       */

// -------------------------------------  SCT_MATCHREL12  -----------------------------------------
#define SCT_MATCHREL12_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL12: RELOADn_L Position  */
#define SCT_MATCHREL12_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL12_RELOADn_L_Pos)            /*!< SCT MATCHREL12: RELOADn_L Mask      */
#define SCT_MATCHREL12_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL12: RELOADn_H Position  */
#define SCT_MATCHREL12_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL12_RELOADn_H_Pos)            /*!< SCT MATCHREL12: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL12  -----------------------------------------
#define SCT_CAPCTRL12_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL12: CAPCONn_L0 Position  */
#define SCT_CAPCTRL12_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL12: CAPCONn_L1 Position  */
#define SCT_CAPCTRL12_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL12: CAPCONn_L2 Position  */
#define SCT_CAPCTRL12_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL12: CAPCONn_L3 Position  */
#define SCT_CAPCTRL12_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL12: CAPCONn_L4 Position  */
#define SCT_CAPCTRL12_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL12: CAPCONn_L5 Position  */
#define SCT_CAPCTRL12_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL12: CAPCONn_L6 Position  */
#define SCT_CAPCTRL12_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL12: CAPCONn_L7 Position  */
#define SCT_CAPCTRL12_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL12: CAPCONn_L8 Position  */
#define SCT_CAPCTRL12_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL12: CAPCONn_L9 Position  */
#define SCT_CAPCTRL12_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL12: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL12_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL12: CAPCONn_L10 Position */
#define SCT_CAPCTRL12_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL12_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL12: CAPCONn_L11 Position */
#define SCT_CAPCTRL12_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL12_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL12: CAPCONn_L12 Position */
#define SCT_CAPCTRL12_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL12_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL12: CAPCONn_L13 Position */
#define SCT_CAPCTRL12_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL12_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL12: CAPCONn_L14 Position */
#define SCT_CAPCTRL12_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL12_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL12: CAPCONn_L15 Position */
#define SCT_CAPCTRL12_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL12: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL12_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL12: CAPCONn_H Position   */
#define SCT_CAPCTRL12_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL12_CAPCONn_H_Pos)             /*!< SCT CAPCTRL12: CAPCONn_H Mask       */

// -------------------------------------  SCT_MATCHREL13  -----------------------------------------
#define SCT_MATCHREL13_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL13: RELOADn_L Position  */
#define SCT_MATCHREL13_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL13_RELOADn_L_Pos)            /*!< SCT MATCHREL13: RELOADn_L Mask      */
#define SCT_MATCHREL13_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL13: RELOADn_H Position  */
#define SCT_MATCHREL13_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL13_RELOADn_H_Pos)            /*!< SCT MATCHREL13: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL13  -----------------------------------------
#define SCT_CAPCTRL13_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL13: CAPCONn_L0 Position  */
#define SCT_CAPCTRL13_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL13: CAPCONn_L1 Position  */
#define SCT_CAPCTRL13_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL13: CAPCONn_L2 Position  */
#define SCT_CAPCTRL13_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL13: CAPCONn_L3 Position  */
#define SCT_CAPCTRL13_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL13: CAPCONn_L4 Position  */
#define SCT_CAPCTRL13_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL13: CAPCONn_L5 Position  */
#define SCT_CAPCTRL13_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL13: CAPCONn_L6 Position  */
#define SCT_CAPCTRL13_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL13: CAPCONn_L7 Position  */
#define SCT_CAPCTRL13_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL13: CAPCONn_L8 Position  */
#define SCT_CAPCTRL13_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL13: CAPCONn_L9 Position  */
#define SCT_CAPCTRL13_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL13: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL13_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL13: CAPCONn_L10 Position */
#define SCT_CAPCTRL13_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL13_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL13: CAPCONn_L11 Position */
#define SCT_CAPCTRL13_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL13_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL13: CAPCONn_L12 Position */
#define SCT_CAPCTRL13_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL13_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL13: CAPCONn_L13 Position */
#define SCT_CAPCTRL13_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL13_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL13: CAPCONn_L14 Position */
#define SCT_CAPCTRL13_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL13_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL13: CAPCONn_L15 Position */
#define SCT_CAPCTRL13_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL13: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL13_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL13: CAPCONn_H Position   */
#define SCT_CAPCTRL13_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL13_CAPCONn_H_Pos)             /*!< SCT CAPCTRL13: CAPCONn_H Mask       */

// -------------------------------------  SCT_MATCHREL14  -----------------------------------------
#define SCT_MATCHREL14_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL14: RELOADn_L Position  */
#define SCT_MATCHREL14_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL14_RELOADn_L_Pos)            /*!< SCT MATCHREL14: RELOADn_L Mask      */
#define SCT_MATCHREL14_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL14: RELOADn_H Position  */
#define SCT_MATCHREL14_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL14_RELOADn_H_Pos)            /*!< SCT MATCHREL14: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL14  -----------------------------------------
#define SCT_CAPCTRL14_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL14: CAPCONn_L0 Position  */
#define SCT_CAPCTRL14_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL14: CAPCONn_L1 Position  */
#define SCT_CAPCTRL14_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL14: CAPCONn_L2 Position  */
#define SCT_CAPCTRL14_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL14: CAPCONn_L3 Position  */
#define SCT_CAPCTRL14_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL14: CAPCONn_L4 Position  */
#define SCT_CAPCTRL14_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL14: CAPCONn_L5 Position  */
#define SCT_CAPCTRL14_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL14: CAPCONn_L6 Position  */
#define SCT_CAPCTRL14_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL14: CAPCONn_L7 Position  */
#define SCT_CAPCTRL14_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL14: CAPCONn_L8 Position  */
#define SCT_CAPCTRL14_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL14: CAPCONn_L9 Position  */
#define SCT_CAPCTRL14_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL14: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL14_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL14: CAPCONn_L10 Position */
#define SCT_CAPCTRL14_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL14_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL14: CAPCONn_L11 Position */
#define SCT_CAPCTRL14_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL14_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL14: CAPCONn_L12 Position */
#define SCT_CAPCTRL14_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL14_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL14: CAPCONn_L13 Position */
#define SCT_CAPCTRL14_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL14_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL14: CAPCONn_L14 Position */
#define SCT_CAPCTRL14_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL14_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL14: CAPCONn_L15 Position */
#define SCT_CAPCTRL14_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL14: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL14_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL14: CAPCONn_H Position   */
#define SCT_CAPCTRL14_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL14_CAPCONn_H_Pos)             /*!< SCT CAPCTRL14: CAPCONn_H Mask       */

// -------------------------------------  SCT_MATCHREL15  -----------------------------------------
#define SCT_MATCHREL15_RELOADn_L_Pos                          0                                                         /*!< SCT MATCHREL15: RELOADn_L Position  */
#define SCT_MATCHREL15_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL15_RELOADn_L_Pos)            /*!< SCT MATCHREL15: RELOADn_L Mask      */
#define SCT_MATCHREL15_RELOADn_H_Pos                          16                                                        /*!< SCT MATCHREL15: RELOADn_H Position  */
#define SCT_MATCHREL15_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL15_RELOADn_H_Pos)            /*!< SCT MATCHREL15: RELOADn_H Mask      */

// --------------------------------------  SCT_CAPCTRL15  -----------------------------------------
#define SCT_CAPCTRL15_CAPCONn_L0_Pos                          0                                                         /*!< SCT CAPCTRL15: CAPCONn_L0 Position  */
#define SCT_CAPCTRL15_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L0_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L0 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L1_Pos                          1                                                         /*!< SCT CAPCTRL15: CAPCONn_L1 Position  */
#define SCT_CAPCTRL15_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L1_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L1 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L2_Pos                          2                                                         /*!< SCT CAPCTRL15: CAPCONn_L2 Position  */
#define SCT_CAPCTRL15_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L2_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L2 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L3_Pos                          3                                                         /*!< SCT CAPCTRL15: CAPCONn_L3 Position  */
#define SCT_CAPCTRL15_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L3_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L3 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L4_Pos                          4                                                         /*!< SCT CAPCTRL15: CAPCONn_L4 Position  */
#define SCT_CAPCTRL15_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L4_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L4 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L5_Pos                          5                                                         /*!< SCT CAPCTRL15: CAPCONn_L5 Position  */
#define SCT_CAPCTRL15_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L5_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L5 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L6_Pos                          6                                                         /*!< SCT CAPCTRL15: CAPCONn_L6 Position  */
#define SCT_CAPCTRL15_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L6_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L6 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L7_Pos                          7                                                         /*!< SCT CAPCTRL15: CAPCONn_L7 Position  */
#define SCT_CAPCTRL15_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L7_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L7 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L8_Pos                          8                                                         /*!< SCT CAPCTRL15: CAPCONn_L8 Position  */
#define SCT_CAPCTRL15_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L8_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L8 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L9_Pos                          9                                                         /*!< SCT CAPCTRL15: CAPCONn_L9 Position  */
#define SCT_CAPCTRL15_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L9_Pos)                  /*!< SCT CAPCTRL15: CAPCONn_L9 Mask      */
#define SCT_CAPCTRL15_CAPCONn_L10_Pos                         10                                                        /*!< SCT CAPCTRL15: CAPCONn_L10 Position */
#define SCT_CAPCTRL15_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L10_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L10 Mask     */
#define SCT_CAPCTRL15_CAPCONn_L11_Pos                         11                                                        /*!< SCT CAPCTRL15: CAPCONn_L11 Position */
#define SCT_CAPCTRL15_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L11_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L11 Mask     */
#define SCT_CAPCTRL15_CAPCONn_L12_Pos                         12                                                        /*!< SCT CAPCTRL15: CAPCONn_L12 Position */
#define SCT_CAPCTRL15_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L12_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L12 Mask     */
#define SCT_CAPCTRL15_CAPCONn_L13_Pos                         13                                                        /*!< SCT CAPCTRL15: CAPCONn_L13 Position */
#define SCT_CAPCTRL15_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L13_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L13 Mask     */
#define SCT_CAPCTRL15_CAPCONn_L14_Pos                         14                                                        /*!< SCT CAPCTRL15: CAPCONn_L14 Position */
#define SCT_CAPCTRL15_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L14_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L14 Mask     */
#define SCT_CAPCTRL15_CAPCONn_L15_Pos                         15                                                        /*!< SCT CAPCTRL15: CAPCONn_L15 Position */
#define SCT_CAPCTRL15_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L15_Pos)                 /*!< SCT CAPCTRL15: CAPCONn_L15 Mask     */
#define SCT_CAPCTRL15_CAPCONn_H_Pos                           16                                                        /*!< SCT CAPCTRL15: CAPCONn_H Position   */
#define SCT_CAPCTRL15_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL15_CAPCONn_H_Pos)             /*!< SCT CAPCTRL15: CAPCONn_H Mask       */

// -------------------------------------  SCT_EVSTATEMSK0  ----------------------------------------
#define SCT_EVSTATEMSK0_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK0: STATEMSKn0 Position */
#define SCT_EVSTATEMSK0_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK0: STATEMSKn1 Position */
#define SCT_EVSTATEMSK0_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK0: STATEMSKn2 Position */
#define SCT_EVSTATEMSK0_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK0: STATEMSKn3 Position */
#define SCT_EVSTATEMSK0_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK0: STATEMSKn4 Position */
#define SCT_EVSTATEMSK0_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK0: STATEMSKn5 Position */
#define SCT_EVSTATEMSK0_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK0: STATEMSKn6 Position */
#define SCT_EVSTATEMSK0_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK0: STATEMSKn7 Position */
#define SCT_EVSTATEMSK0_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK0: STATEMSKn8 Position */
#define SCT_EVSTATEMSK0_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK0: STATEMSKn9 Position */
#define SCT_EVSTATEMSK0_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK0: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK0_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK0: STATEMSKn10 Position */
#define SCT_EVSTATEMSK0_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK0: STATEMSKn11 Position */
#define SCT_EVSTATEMSK0_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK0: STATEMSKn12 Position */
#define SCT_EVSTATEMSK0_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK0: STATEMSKn13 Position */
#define SCT_EVSTATEMSK0_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK0: STATEMSKn14 Position */
#define SCT_EVSTATEMSK0_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK0: STATEMSKn15 Position */
#define SCT_EVSTATEMSK0_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK0: STATEMSKn16 Position */
#define SCT_EVSTATEMSK0_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK0: STATEMSKn17 Position */
#define SCT_EVSTATEMSK0_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK0: STATEMSKn18 Position */
#define SCT_EVSTATEMSK0_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK0: STATEMSKn19 Position */
#define SCT_EVSTATEMSK0_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK0: STATEMSKn20 Position */
#define SCT_EVSTATEMSK0_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK0: STATEMSKn21 Position */
#define SCT_EVSTATEMSK0_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK0: STATEMSKn22 Position */
#define SCT_EVSTATEMSK0_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK0: STATEMSKn23 Position */
#define SCT_EVSTATEMSK0_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK0: STATEMSKn24 Position */
#define SCT_EVSTATEMSK0_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK0: STATEMSKn25 Position */
#define SCT_EVSTATEMSK0_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK0: STATEMSKn26 Position */
#define SCT_EVSTATEMSK0_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK0: STATEMSKn27 Position */
#define SCT_EVSTATEMSK0_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK0: STATEMSKn28 Position */
#define SCT_EVSTATEMSK0_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK0: STATEMSKn29 Position */
#define SCT_EVSTATEMSK0_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK0: STATEMSKn30 Position */
#define SCT_EVSTATEMSK0_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK0_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK0: STATEMSKn31 Position */
#define SCT_EVSTATEMSK0_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK0: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL0  ------------------------------------------
#define SCT_EVCTRL0_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL0: MATCHSEL Position      */
#define SCT_EVCTRL0_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL0_MATCHSEL_Pos)                      /*!< SCT EVCTRL0: MATCHSEL Mask          */
#define SCT_EVCTRL0_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL0: HEVENT Position        */
#define SCT_EVCTRL0_HEVENT_Msk                                (0x01UL << SCT_EVCTRL0_HEVENT_Pos)                        /*!< SCT EVCTRL0: HEVENT Mask            */
#define SCT_EVCTRL0_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL0: OUTSEL Position        */
#define SCT_EVCTRL0_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL0_OUTSEL_Pos)                        /*!< SCT EVCTRL0: OUTSEL Mask            */
#define SCT_EVCTRL0_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL0: IOSEL Position         */
#define SCT_EVCTRL0_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL0_IOSEL_Pos)                         /*!< SCT EVCTRL0: IOSEL Mask             */
#define SCT_EVCTRL0_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL0: IOCOND Position        */
#define SCT_EVCTRL0_IOCOND_Msk                                (0x03UL << SCT_EVCTRL0_IOCOND_Pos)                        /*!< SCT EVCTRL0: IOCOND Mask            */
#define SCT_EVCTRL0_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL0: COMBMODE Position      */
#define SCT_EVCTRL0_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL0_COMBMODE_Pos)                      /*!< SCT EVCTRL0: COMBMODE Mask          */
#define SCT_EVCTRL0_STATELD_Pos                               14                                                        /*!< SCT EVCTRL0: STATELD Position       */
#define SCT_EVCTRL0_STATELD_Msk                               (0x01UL << SCT_EVCTRL0_STATELD_Pos)                       /*!< SCT EVCTRL0: STATELD Mask           */
#define SCT_EVCTRL0_STATEV_Pos                                15                                                        /*!< SCT EVCTRL0: STATEV Position        */
#define SCT_EVCTRL0_STATEV_Msk                                (0x1fUL << SCT_EVCTRL0_STATEV_Pos)                        /*!< SCT EVCTRL0: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK1  ----------------------------------------
#define SCT_EVSTATEMSK1_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK1: STATEMSKn0 Position */
#define SCT_EVSTATEMSK1_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK1: STATEMSKn1 Position */
#define SCT_EVSTATEMSK1_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK1: STATEMSKn2 Position */
#define SCT_EVSTATEMSK1_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK1: STATEMSKn3 Position */
#define SCT_EVSTATEMSK1_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK1: STATEMSKn4 Position */
#define SCT_EVSTATEMSK1_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK1: STATEMSKn5 Position */
#define SCT_EVSTATEMSK1_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK1: STATEMSKn6 Position */
#define SCT_EVSTATEMSK1_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK1: STATEMSKn7 Position */
#define SCT_EVSTATEMSK1_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK1: STATEMSKn8 Position */
#define SCT_EVSTATEMSK1_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK1: STATEMSKn9 Position */
#define SCT_EVSTATEMSK1_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK1: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK1_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK1: STATEMSKn10 Position */
#define SCT_EVSTATEMSK1_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK1: STATEMSKn11 Position */
#define SCT_EVSTATEMSK1_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK1: STATEMSKn12 Position */
#define SCT_EVSTATEMSK1_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK1: STATEMSKn13 Position */
#define SCT_EVSTATEMSK1_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK1: STATEMSKn14 Position */
#define SCT_EVSTATEMSK1_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK1: STATEMSKn15 Position */
#define SCT_EVSTATEMSK1_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK1: STATEMSKn16 Position */
#define SCT_EVSTATEMSK1_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK1: STATEMSKn17 Position */
#define SCT_EVSTATEMSK1_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK1: STATEMSKn18 Position */
#define SCT_EVSTATEMSK1_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK1: STATEMSKn19 Position */
#define SCT_EVSTATEMSK1_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK1: STATEMSKn20 Position */
#define SCT_EVSTATEMSK1_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK1: STATEMSKn21 Position */
#define SCT_EVSTATEMSK1_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK1: STATEMSKn22 Position */
#define SCT_EVSTATEMSK1_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK1: STATEMSKn23 Position */
#define SCT_EVSTATEMSK1_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK1: STATEMSKn24 Position */
#define SCT_EVSTATEMSK1_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK1: STATEMSKn25 Position */
#define SCT_EVSTATEMSK1_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK1: STATEMSKn26 Position */
#define SCT_EVSTATEMSK1_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK1: STATEMSKn27 Position */
#define SCT_EVSTATEMSK1_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK1: STATEMSKn28 Position */
#define SCT_EVSTATEMSK1_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK1: STATEMSKn29 Position */
#define SCT_EVSTATEMSK1_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK1: STATEMSKn30 Position */
#define SCT_EVSTATEMSK1_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK1_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK1: STATEMSKn31 Position */
#define SCT_EVSTATEMSK1_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK1: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL1  ------------------------------------------
#define SCT_EVCTRL1_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL1: MATCHSEL Position      */
#define SCT_EVCTRL1_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL1_MATCHSEL_Pos)                      /*!< SCT EVCTRL1: MATCHSEL Mask          */
#define SCT_EVCTRL1_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL1: HEVENT Position        */
#define SCT_EVCTRL1_HEVENT_Msk                                (0x01UL << SCT_EVCTRL1_HEVENT_Pos)                        /*!< SCT EVCTRL1: HEVENT Mask            */
#define SCT_EVCTRL1_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL1: OUTSEL Position        */
#define SCT_EVCTRL1_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL1_OUTSEL_Pos)                        /*!< SCT EVCTRL1: OUTSEL Mask            */
#define SCT_EVCTRL1_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL1: IOSEL Position         */
#define SCT_EVCTRL1_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL1_IOSEL_Pos)                         /*!< SCT EVCTRL1: IOSEL Mask             */
#define SCT_EVCTRL1_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL1: IOCOND Position        */
#define SCT_EVCTRL1_IOCOND_Msk                                (0x03UL << SCT_EVCTRL1_IOCOND_Pos)                        /*!< SCT EVCTRL1: IOCOND Mask            */
#define SCT_EVCTRL1_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL1: COMBMODE Position      */
#define SCT_EVCTRL1_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL1_COMBMODE_Pos)                      /*!< SCT EVCTRL1: COMBMODE Mask          */
#define SCT_EVCTRL1_STATELD_Pos                               14                                                        /*!< SCT EVCTRL1: STATELD Position       */
#define SCT_EVCTRL1_STATELD_Msk                               (0x01UL << SCT_EVCTRL1_STATELD_Pos)                       /*!< SCT EVCTRL1: STATELD Mask           */
#define SCT_EVCTRL1_STATEV_Pos                                15                                                        /*!< SCT EVCTRL1: STATEV Position        */
#define SCT_EVCTRL1_STATEV_Msk                                (0x1fUL << SCT_EVCTRL1_STATEV_Pos)                        /*!< SCT EVCTRL1: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK2  ----------------------------------------
#define SCT_EVSTATEMSK2_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK2: STATEMSKn0 Position */
#define SCT_EVSTATEMSK2_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK2: STATEMSKn1 Position */
#define SCT_EVSTATEMSK2_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK2: STATEMSKn2 Position */
#define SCT_EVSTATEMSK2_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK2: STATEMSKn3 Position */
#define SCT_EVSTATEMSK2_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK2: STATEMSKn4 Position */
#define SCT_EVSTATEMSK2_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK2: STATEMSKn5 Position */
#define SCT_EVSTATEMSK2_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK2: STATEMSKn6 Position */
#define SCT_EVSTATEMSK2_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK2: STATEMSKn7 Position */
#define SCT_EVSTATEMSK2_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK2: STATEMSKn8 Position */
#define SCT_EVSTATEMSK2_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK2: STATEMSKn9 Position */
#define SCT_EVSTATEMSK2_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK2: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK2_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK2: STATEMSKn10 Position */
#define SCT_EVSTATEMSK2_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK2: STATEMSKn11 Position */
#define SCT_EVSTATEMSK2_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK2: STATEMSKn12 Position */
#define SCT_EVSTATEMSK2_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK2: STATEMSKn13 Position */
#define SCT_EVSTATEMSK2_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK2: STATEMSKn14 Position */
#define SCT_EVSTATEMSK2_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK2: STATEMSKn15 Position */
#define SCT_EVSTATEMSK2_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK2: STATEMSKn16 Position */
#define SCT_EVSTATEMSK2_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK2: STATEMSKn17 Position */
#define SCT_EVSTATEMSK2_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK2: STATEMSKn18 Position */
#define SCT_EVSTATEMSK2_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK2: STATEMSKn19 Position */
#define SCT_EVSTATEMSK2_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK2: STATEMSKn20 Position */
#define SCT_EVSTATEMSK2_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK2: STATEMSKn21 Position */
#define SCT_EVSTATEMSK2_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK2: STATEMSKn22 Position */
#define SCT_EVSTATEMSK2_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK2: STATEMSKn23 Position */
#define SCT_EVSTATEMSK2_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK2: STATEMSKn24 Position */
#define SCT_EVSTATEMSK2_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK2: STATEMSKn25 Position */
#define SCT_EVSTATEMSK2_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK2: STATEMSKn26 Position */
#define SCT_EVSTATEMSK2_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK2: STATEMSKn27 Position */
#define SCT_EVSTATEMSK2_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK2: STATEMSKn28 Position */
#define SCT_EVSTATEMSK2_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK2: STATEMSKn29 Position */
#define SCT_EVSTATEMSK2_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK2: STATEMSKn30 Position */
#define SCT_EVSTATEMSK2_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK2_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK2: STATEMSKn31 Position */
#define SCT_EVSTATEMSK2_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK2: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL2  ------------------------------------------
#define SCT_EVCTRL2_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL2: MATCHSEL Position      */
#define SCT_EVCTRL2_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL2_MATCHSEL_Pos)                      /*!< SCT EVCTRL2: MATCHSEL Mask          */
#define SCT_EVCTRL2_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL2: HEVENT Position        */
#define SCT_EVCTRL2_HEVENT_Msk                                (0x01UL << SCT_EVCTRL2_HEVENT_Pos)                        /*!< SCT EVCTRL2: HEVENT Mask            */
#define SCT_EVCTRL2_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL2: OUTSEL Position        */
#define SCT_EVCTRL2_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL2_OUTSEL_Pos)                        /*!< SCT EVCTRL2: OUTSEL Mask            */
#define SCT_EVCTRL2_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL2: IOSEL Position         */
#define SCT_EVCTRL2_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL2_IOSEL_Pos)                         /*!< SCT EVCTRL2: IOSEL Mask             */
#define SCT_EVCTRL2_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL2: IOCOND Position        */
#define SCT_EVCTRL2_IOCOND_Msk                                (0x03UL << SCT_EVCTRL2_IOCOND_Pos)                        /*!< SCT EVCTRL2: IOCOND Mask            */
#define SCT_EVCTRL2_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL2: COMBMODE Position      */
#define SCT_EVCTRL2_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL2_COMBMODE_Pos)                      /*!< SCT EVCTRL2: COMBMODE Mask          */
#define SCT_EVCTRL2_STATELD_Pos                               14                                                        /*!< SCT EVCTRL2: STATELD Position       */
#define SCT_EVCTRL2_STATELD_Msk                               (0x01UL << SCT_EVCTRL2_STATELD_Pos)                       /*!< SCT EVCTRL2: STATELD Mask           */
#define SCT_EVCTRL2_STATEV_Pos                                15                                                        /*!< SCT EVCTRL2: STATEV Position        */
#define SCT_EVCTRL2_STATEV_Msk                                (0x1fUL << SCT_EVCTRL2_STATEV_Pos)                        /*!< SCT EVCTRL2: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK3  ----------------------------------------
#define SCT_EVSTATEMSK3_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK3: STATEMSKn0 Position */
#define SCT_EVSTATEMSK3_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK3: STATEMSKn1 Position */
#define SCT_EVSTATEMSK3_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK3: STATEMSKn2 Position */
#define SCT_EVSTATEMSK3_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK3: STATEMSKn3 Position */
#define SCT_EVSTATEMSK3_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK3: STATEMSKn4 Position */
#define SCT_EVSTATEMSK3_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK3: STATEMSKn5 Position */
#define SCT_EVSTATEMSK3_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK3: STATEMSKn6 Position */
#define SCT_EVSTATEMSK3_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK3: STATEMSKn7 Position */
#define SCT_EVSTATEMSK3_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK3: STATEMSKn8 Position */
#define SCT_EVSTATEMSK3_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK3: STATEMSKn9 Position */
#define SCT_EVSTATEMSK3_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK3: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK3_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK3: STATEMSKn10 Position */
#define SCT_EVSTATEMSK3_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK3: STATEMSKn11 Position */
#define SCT_EVSTATEMSK3_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK3: STATEMSKn12 Position */
#define SCT_EVSTATEMSK3_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK3: STATEMSKn13 Position */
#define SCT_EVSTATEMSK3_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK3: STATEMSKn14 Position */
#define SCT_EVSTATEMSK3_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK3: STATEMSKn15 Position */
#define SCT_EVSTATEMSK3_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK3: STATEMSKn16 Position */
#define SCT_EVSTATEMSK3_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK3: STATEMSKn17 Position */
#define SCT_EVSTATEMSK3_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK3: STATEMSKn18 Position */
#define SCT_EVSTATEMSK3_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK3: STATEMSKn19 Position */
#define SCT_EVSTATEMSK3_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK3: STATEMSKn20 Position */
#define SCT_EVSTATEMSK3_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK3: STATEMSKn21 Position */
#define SCT_EVSTATEMSK3_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK3: STATEMSKn22 Position */
#define SCT_EVSTATEMSK3_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK3: STATEMSKn23 Position */
#define SCT_EVSTATEMSK3_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK3: STATEMSKn24 Position */
#define SCT_EVSTATEMSK3_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK3: STATEMSKn25 Position */
#define SCT_EVSTATEMSK3_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK3: STATEMSKn26 Position */
#define SCT_EVSTATEMSK3_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK3: STATEMSKn27 Position */
#define SCT_EVSTATEMSK3_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK3: STATEMSKn28 Position */
#define SCT_EVSTATEMSK3_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK3: STATEMSKn29 Position */
#define SCT_EVSTATEMSK3_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK3: STATEMSKn30 Position */
#define SCT_EVSTATEMSK3_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK3_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK3: STATEMSKn31 Position */
#define SCT_EVSTATEMSK3_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK3: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL3  ------------------------------------------
#define SCT_EVCTRL3_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL3: MATCHSEL Position      */
#define SCT_EVCTRL3_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL3_MATCHSEL_Pos)                      /*!< SCT EVCTRL3: MATCHSEL Mask          */
#define SCT_EVCTRL3_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL3: HEVENT Position        */
#define SCT_EVCTRL3_HEVENT_Msk                                (0x01UL << SCT_EVCTRL3_HEVENT_Pos)                        /*!< SCT EVCTRL3: HEVENT Mask            */
#define SCT_EVCTRL3_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL3: OUTSEL Position        */
#define SCT_EVCTRL3_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL3_OUTSEL_Pos)                        /*!< SCT EVCTRL3: OUTSEL Mask            */
#define SCT_EVCTRL3_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL3: IOSEL Position         */
#define SCT_EVCTRL3_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL3_IOSEL_Pos)                         /*!< SCT EVCTRL3: IOSEL Mask             */
#define SCT_EVCTRL3_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL3: IOCOND Position        */
#define SCT_EVCTRL3_IOCOND_Msk                                (0x03UL << SCT_EVCTRL3_IOCOND_Pos)                        /*!< SCT EVCTRL3: IOCOND Mask            */
#define SCT_EVCTRL3_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL3: COMBMODE Position      */
#define SCT_EVCTRL3_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL3_COMBMODE_Pos)                      /*!< SCT EVCTRL3: COMBMODE Mask          */
#define SCT_EVCTRL3_STATELD_Pos                               14                                                        /*!< SCT EVCTRL3: STATELD Position       */
#define SCT_EVCTRL3_STATELD_Msk                               (0x01UL << SCT_EVCTRL3_STATELD_Pos)                       /*!< SCT EVCTRL3: STATELD Mask           */
#define SCT_EVCTRL3_STATEV_Pos                                15                                                        /*!< SCT EVCTRL3: STATEV Position        */
#define SCT_EVCTRL3_STATEV_Msk                                (0x1fUL << SCT_EVCTRL3_STATEV_Pos)                        /*!< SCT EVCTRL3: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK4  ----------------------------------------
#define SCT_EVSTATEMSK4_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK4: STATEMSKn0 Position */
#define SCT_EVSTATEMSK4_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK4: STATEMSKn1 Position */
#define SCT_EVSTATEMSK4_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK4: STATEMSKn2 Position */
#define SCT_EVSTATEMSK4_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK4: STATEMSKn3 Position */
#define SCT_EVSTATEMSK4_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK4: STATEMSKn4 Position */
#define SCT_EVSTATEMSK4_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK4: STATEMSKn5 Position */
#define SCT_EVSTATEMSK4_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK4: STATEMSKn6 Position */
#define SCT_EVSTATEMSK4_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK4: STATEMSKn7 Position */
#define SCT_EVSTATEMSK4_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK4: STATEMSKn8 Position */
#define SCT_EVSTATEMSK4_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK4: STATEMSKn9 Position */
#define SCT_EVSTATEMSK4_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK4: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK4_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK4: STATEMSKn10 Position */
#define SCT_EVSTATEMSK4_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK4: STATEMSKn11 Position */
#define SCT_EVSTATEMSK4_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK4: STATEMSKn12 Position */
#define SCT_EVSTATEMSK4_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK4: STATEMSKn13 Position */
#define SCT_EVSTATEMSK4_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK4: STATEMSKn14 Position */
#define SCT_EVSTATEMSK4_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK4: STATEMSKn15 Position */
#define SCT_EVSTATEMSK4_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK4: STATEMSKn16 Position */
#define SCT_EVSTATEMSK4_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK4: STATEMSKn17 Position */
#define SCT_EVSTATEMSK4_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK4: STATEMSKn18 Position */
#define SCT_EVSTATEMSK4_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK4: STATEMSKn19 Position */
#define SCT_EVSTATEMSK4_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK4: STATEMSKn20 Position */
#define SCT_EVSTATEMSK4_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK4: STATEMSKn21 Position */
#define SCT_EVSTATEMSK4_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK4: STATEMSKn22 Position */
#define SCT_EVSTATEMSK4_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK4: STATEMSKn23 Position */
#define SCT_EVSTATEMSK4_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK4: STATEMSKn24 Position */
#define SCT_EVSTATEMSK4_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK4: STATEMSKn25 Position */
#define SCT_EVSTATEMSK4_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK4: STATEMSKn26 Position */
#define SCT_EVSTATEMSK4_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK4: STATEMSKn27 Position */
#define SCT_EVSTATEMSK4_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK4: STATEMSKn28 Position */
#define SCT_EVSTATEMSK4_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK4: STATEMSKn29 Position */
#define SCT_EVSTATEMSK4_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK4: STATEMSKn30 Position */
#define SCT_EVSTATEMSK4_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK4_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK4: STATEMSKn31 Position */
#define SCT_EVSTATEMSK4_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK4: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL4  ------------------------------------------
#define SCT_EVCTRL4_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL4: MATCHSEL Position      */
#define SCT_EVCTRL4_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL4_MATCHSEL_Pos)                      /*!< SCT EVCTRL4: MATCHSEL Mask          */
#define SCT_EVCTRL4_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL4: HEVENT Position        */
#define SCT_EVCTRL4_HEVENT_Msk                                (0x01UL << SCT_EVCTRL4_HEVENT_Pos)                        /*!< SCT EVCTRL4: HEVENT Mask            */
#define SCT_EVCTRL4_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL4: OUTSEL Position        */
#define SCT_EVCTRL4_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL4_OUTSEL_Pos)                        /*!< SCT EVCTRL4: OUTSEL Mask            */
#define SCT_EVCTRL4_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL4: IOSEL Position         */
#define SCT_EVCTRL4_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL4_IOSEL_Pos)                         /*!< SCT EVCTRL4: IOSEL Mask             */
#define SCT_EVCTRL4_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL4: IOCOND Position        */
#define SCT_EVCTRL4_IOCOND_Msk                                (0x03UL << SCT_EVCTRL4_IOCOND_Pos)                        /*!< SCT EVCTRL4: IOCOND Mask            */
#define SCT_EVCTRL4_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL4: COMBMODE Position      */
#define SCT_EVCTRL4_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL4_COMBMODE_Pos)                      /*!< SCT EVCTRL4: COMBMODE Mask          */
#define SCT_EVCTRL4_STATELD_Pos                               14                                                        /*!< SCT EVCTRL4: STATELD Position       */
#define SCT_EVCTRL4_STATELD_Msk                               (0x01UL << SCT_EVCTRL4_STATELD_Pos)                       /*!< SCT EVCTRL4: STATELD Mask           */
#define SCT_EVCTRL4_STATEV_Pos                                15                                                        /*!< SCT EVCTRL4: STATEV Position        */
#define SCT_EVCTRL4_STATEV_Msk                                (0x1fUL << SCT_EVCTRL4_STATEV_Pos)                        /*!< SCT EVCTRL4: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK5  ----------------------------------------
#define SCT_EVSTATEMSK5_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK5: STATEMSKn0 Position */
#define SCT_EVSTATEMSK5_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK5: STATEMSKn1 Position */
#define SCT_EVSTATEMSK5_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK5: STATEMSKn2 Position */
#define SCT_EVSTATEMSK5_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK5: STATEMSKn3 Position */
#define SCT_EVSTATEMSK5_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK5: STATEMSKn4 Position */
#define SCT_EVSTATEMSK5_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK5: STATEMSKn5 Position */
#define SCT_EVSTATEMSK5_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK5: STATEMSKn6 Position */
#define SCT_EVSTATEMSK5_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK5: STATEMSKn7 Position */
#define SCT_EVSTATEMSK5_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK5: STATEMSKn8 Position */
#define SCT_EVSTATEMSK5_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK5: STATEMSKn9 Position */
#define SCT_EVSTATEMSK5_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK5: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK5_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK5: STATEMSKn10 Position */
#define SCT_EVSTATEMSK5_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK5: STATEMSKn11 Position */
#define SCT_EVSTATEMSK5_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK5: STATEMSKn12 Position */
#define SCT_EVSTATEMSK5_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK5: STATEMSKn13 Position */
#define SCT_EVSTATEMSK5_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK5: STATEMSKn14 Position */
#define SCT_EVSTATEMSK5_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK5: STATEMSKn15 Position */
#define SCT_EVSTATEMSK5_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK5: STATEMSKn16 Position */
#define SCT_EVSTATEMSK5_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK5: STATEMSKn17 Position */
#define SCT_EVSTATEMSK5_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK5: STATEMSKn18 Position */
#define SCT_EVSTATEMSK5_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK5: STATEMSKn19 Position */
#define SCT_EVSTATEMSK5_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK5: STATEMSKn20 Position */
#define SCT_EVSTATEMSK5_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK5: STATEMSKn21 Position */
#define SCT_EVSTATEMSK5_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK5: STATEMSKn22 Position */
#define SCT_EVSTATEMSK5_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK5: STATEMSKn23 Position */
#define SCT_EVSTATEMSK5_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK5: STATEMSKn24 Position */
#define SCT_EVSTATEMSK5_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK5: STATEMSKn25 Position */
#define SCT_EVSTATEMSK5_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK5: STATEMSKn26 Position */
#define SCT_EVSTATEMSK5_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK5: STATEMSKn27 Position */
#define SCT_EVSTATEMSK5_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK5: STATEMSKn28 Position */
#define SCT_EVSTATEMSK5_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK5: STATEMSKn29 Position */
#define SCT_EVSTATEMSK5_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK5: STATEMSKn30 Position */
#define SCT_EVSTATEMSK5_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK5_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK5: STATEMSKn31 Position */
#define SCT_EVSTATEMSK5_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK5: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL5  ------------------------------------------
#define SCT_EVCTRL5_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL5: MATCHSEL Position      */
#define SCT_EVCTRL5_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL5_MATCHSEL_Pos)                      /*!< SCT EVCTRL5: MATCHSEL Mask          */
#define SCT_EVCTRL5_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL5: HEVENT Position        */
#define SCT_EVCTRL5_HEVENT_Msk                                (0x01UL << SCT_EVCTRL5_HEVENT_Pos)                        /*!< SCT EVCTRL5: HEVENT Mask            */
#define SCT_EVCTRL5_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL5: OUTSEL Position        */
#define SCT_EVCTRL5_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL5_OUTSEL_Pos)                        /*!< SCT EVCTRL5: OUTSEL Mask            */
#define SCT_EVCTRL5_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL5: IOSEL Position         */
#define SCT_EVCTRL5_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL5_IOSEL_Pos)                         /*!< SCT EVCTRL5: IOSEL Mask             */
#define SCT_EVCTRL5_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL5: IOCOND Position        */
#define SCT_EVCTRL5_IOCOND_Msk                                (0x03UL << SCT_EVCTRL5_IOCOND_Pos)                        /*!< SCT EVCTRL5: IOCOND Mask            */
#define SCT_EVCTRL5_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL5: COMBMODE Position      */
#define SCT_EVCTRL5_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL5_COMBMODE_Pos)                      /*!< SCT EVCTRL5: COMBMODE Mask          */
#define SCT_EVCTRL5_STATELD_Pos                               14                                                        /*!< SCT EVCTRL5: STATELD Position       */
#define SCT_EVCTRL5_STATELD_Msk                               (0x01UL << SCT_EVCTRL5_STATELD_Pos)                       /*!< SCT EVCTRL5: STATELD Mask           */
#define SCT_EVCTRL5_STATEV_Pos                                15                                                        /*!< SCT EVCTRL5: STATEV Position        */
#define SCT_EVCTRL5_STATEV_Msk                                (0x1fUL << SCT_EVCTRL5_STATEV_Pos)                        /*!< SCT EVCTRL5: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK6  ----------------------------------------
#define SCT_EVSTATEMSK6_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK6: STATEMSKn0 Position */
#define SCT_EVSTATEMSK6_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK6: STATEMSKn1 Position */
#define SCT_EVSTATEMSK6_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK6: STATEMSKn2 Position */
#define SCT_EVSTATEMSK6_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK6: STATEMSKn3 Position */
#define SCT_EVSTATEMSK6_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK6: STATEMSKn4 Position */
#define SCT_EVSTATEMSK6_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK6: STATEMSKn5 Position */
#define SCT_EVSTATEMSK6_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK6: STATEMSKn6 Position */
#define SCT_EVSTATEMSK6_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK6: STATEMSKn7 Position */
#define SCT_EVSTATEMSK6_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK6: STATEMSKn8 Position */
#define SCT_EVSTATEMSK6_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK6: STATEMSKn9 Position */
#define SCT_EVSTATEMSK6_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK6: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK6_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK6: STATEMSKn10 Position */
#define SCT_EVSTATEMSK6_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK6: STATEMSKn11 Position */
#define SCT_EVSTATEMSK6_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK6: STATEMSKn12 Position */
#define SCT_EVSTATEMSK6_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK6: STATEMSKn13 Position */
#define SCT_EVSTATEMSK6_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK6: STATEMSKn14 Position */
#define SCT_EVSTATEMSK6_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK6: STATEMSKn15 Position */
#define SCT_EVSTATEMSK6_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK6: STATEMSKn16 Position */
#define SCT_EVSTATEMSK6_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK6: STATEMSKn17 Position */
#define SCT_EVSTATEMSK6_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK6: STATEMSKn18 Position */
#define SCT_EVSTATEMSK6_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK6: STATEMSKn19 Position */
#define SCT_EVSTATEMSK6_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK6: STATEMSKn20 Position */
#define SCT_EVSTATEMSK6_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK6: STATEMSKn21 Position */
#define SCT_EVSTATEMSK6_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK6: STATEMSKn22 Position */
#define SCT_EVSTATEMSK6_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK6: STATEMSKn23 Position */
#define SCT_EVSTATEMSK6_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK6: STATEMSKn24 Position */
#define SCT_EVSTATEMSK6_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK6: STATEMSKn25 Position */
#define SCT_EVSTATEMSK6_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK6: STATEMSKn26 Position */
#define SCT_EVSTATEMSK6_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK6: STATEMSKn27 Position */
#define SCT_EVSTATEMSK6_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK6: STATEMSKn28 Position */
#define SCT_EVSTATEMSK6_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK6: STATEMSKn29 Position */
#define SCT_EVSTATEMSK6_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK6: STATEMSKn30 Position */
#define SCT_EVSTATEMSK6_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK6_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK6: STATEMSKn31 Position */
#define SCT_EVSTATEMSK6_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK6: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL6  ------------------------------------------
#define SCT_EVCTRL6_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL6: MATCHSEL Position      */
#define SCT_EVCTRL6_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL6_MATCHSEL_Pos)                      /*!< SCT EVCTRL6: MATCHSEL Mask          */
#define SCT_EVCTRL6_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL6: HEVENT Position        */
#define SCT_EVCTRL6_HEVENT_Msk                                (0x01UL << SCT_EVCTRL6_HEVENT_Pos)                        /*!< SCT EVCTRL6: HEVENT Mask            */
#define SCT_EVCTRL6_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL6: OUTSEL Position        */
#define SCT_EVCTRL6_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL6_OUTSEL_Pos)                        /*!< SCT EVCTRL6: OUTSEL Mask            */
#define SCT_EVCTRL6_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL6: IOSEL Position         */
#define SCT_EVCTRL6_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL6_IOSEL_Pos)                         /*!< SCT EVCTRL6: IOSEL Mask             */
#define SCT_EVCTRL6_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL6: IOCOND Position        */
#define SCT_EVCTRL6_IOCOND_Msk                                (0x03UL << SCT_EVCTRL6_IOCOND_Pos)                        /*!< SCT EVCTRL6: IOCOND Mask            */
#define SCT_EVCTRL6_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL6: COMBMODE Position      */
#define SCT_EVCTRL6_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL6_COMBMODE_Pos)                      /*!< SCT EVCTRL6: COMBMODE Mask          */
#define SCT_EVCTRL6_STATELD_Pos                               14                                                        /*!< SCT EVCTRL6: STATELD Position       */
#define SCT_EVCTRL6_STATELD_Msk                               (0x01UL << SCT_EVCTRL6_STATELD_Pos)                       /*!< SCT EVCTRL6: STATELD Mask           */
#define SCT_EVCTRL6_STATEV_Pos                                15                                                        /*!< SCT EVCTRL6: STATEV Position        */
#define SCT_EVCTRL6_STATEV_Msk                                (0x1fUL << SCT_EVCTRL6_STATEV_Pos)                        /*!< SCT EVCTRL6: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK7  ----------------------------------------
#define SCT_EVSTATEMSK7_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK7: STATEMSKn0 Position */
#define SCT_EVSTATEMSK7_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK7: STATEMSKn1 Position */
#define SCT_EVSTATEMSK7_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK7: STATEMSKn2 Position */
#define SCT_EVSTATEMSK7_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK7: STATEMSKn3 Position */
#define SCT_EVSTATEMSK7_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK7: STATEMSKn4 Position */
#define SCT_EVSTATEMSK7_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK7: STATEMSKn5 Position */
#define SCT_EVSTATEMSK7_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK7: STATEMSKn6 Position */
#define SCT_EVSTATEMSK7_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK7: STATEMSKn7 Position */
#define SCT_EVSTATEMSK7_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK7: STATEMSKn8 Position */
#define SCT_EVSTATEMSK7_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK7: STATEMSKn9 Position */
#define SCT_EVSTATEMSK7_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK7: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK7_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK7: STATEMSKn10 Position */
#define SCT_EVSTATEMSK7_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK7: STATEMSKn11 Position */
#define SCT_EVSTATEMSK7_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK7: STATEMSKn12 Position */
#define SCT_EVSTATEMSK7_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK7: STATEMSKn13 Position */
#define SCT_EVSTATEMSK7_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK7: STATEMSKn14 Position */
#define SCT_EVSTATEMSK7_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK7: STATEMSKn15 Position */
#define SCT_EVSTATEMSK7_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK7: STATEMSKn16 Position */
#define SCT_EVSTATEMSK7_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK7: STATEMSKn17 Position */
#define SCT_EVSTATEMSK7_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK7: STATEMSKn18 Position */
#define SCT_EVSTATEMSK7_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK7: STATEMSKn19 Position */
#define SCT_EVSTATEMSK7_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK7: STATEMSKn20 Position */
#define SCT_EVSTATEMSK7_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK7: STATEMSKn21 Position */
#define SCT_EVSTATEMSK7_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK7: STATEMSKn22 Position */
#define SCT_EVSTATEMSK7_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK7: STATEMSKn23 Position */
#define SCT_EVSTATEMSK7_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK7: STATEMSKn24 Position */
#define SCT_EVSTATEMSK7_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK7: STATEMSKn25 Position */
#define SCT_EVSTATEMSK7_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK7: STATEMSKn26 Position */
#define SCT_EVSTATEMSK7_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK7: STATEMSKn27 Position */
#define SCT_EVSTATEMSK7_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK7: STATEMSKn28 Position */
#define SCT_EVSTATEMSK7_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK7: STATEMSKn29 Position */
#define SCT_EVSTATEMSK7_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK7: STATEMSKn30 Position */
#define SCT_EVSTATEMSK7_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK7_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK7: STATEMSKn31 Position */
#define SCT_EVSTATEMSK7_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK7: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL7  ------------------------------------------
#define SCT_EVCTRL7_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL7: MATCHSEL Position      */
#define SCT_EVCTRL7_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL7_MATCHSEL_Pos)                      /*!< SCT EVCTRL7: MATCHSEL Mask          */
#define SCT_EVCTRL7_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL7: HEVENT Position        */
#define SCT_EVCTRL7_HEVENT_Msk                                (0x01UL << SCT_EVCTRL7_HEVENT_Pos)                        /*!< SCT EVCTRL7: HEVENT Mask            */
#define SCT_EVCTRL7_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL7: OUTSEL Position        */
#define SCT_EVCTRL7_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL7_OUTSEL_Pos)                        /*!< SCT EVCTRL7: OUTSEL Mask            */
#define SCT_EVCTRL7_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL7: IOSEL Position         */
#define SCT_EVCTRL7_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL7_IOSEL_Pos)                         /*!< SCT EVCTRL7: IOSEL Mask             */
#define SCT_EVCTRL7_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL7: IOCOND Position        */
#define SCT_EVCTRL7_IOCOND_Msk                                (0x03UL << SCT_EVCTRL7_IOCOND_Pos)                        /*!< SCT EVCTRL7: IOCOND Mask            */
#define SCT_EVCTRL7_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL7: COMBMODE Position      */
#define SCT_EVCTRL7_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL7_COMBMODE_Pos)                      /*!< SCT EVCTRL7: COMBMODE Mask          */
#define SCT_EVCTRL7_STATELD_Pos                               14                                                        /*!< SCT EVCTRL7: STATELD Position       */
#define SCT_EVCTRL7_STATELD_Msk                               (0x01UL << SCT_EVCTRL7_STATELD_Pos)                       /*!< SCT EVCTRL7: STATELD Mask           */
#define SCT_EVCTRL7_STATEV_Pos                                15                                                        /*!< SCT EVCTRL7: STATEV Position        */
#define SCT_EVCTRL7_STATEV_Msk                                (0x1fUL << SCT_EVCTRL7_STATEV_Pos)                        /*!< SCT EVCTRL7: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK8  ----------------------------------------
#define SCT_EVSTATEMSK8_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK8: STATEMSKn0 Position */
#define SCT_EVSTATEMSK8_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK8: STATEMSKn1 Position */
#define SCT_EVSTATEMSK8_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK8: STATEMSKn2 Position */
#define SCT_EVSTATEMSK8_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK8: STATEMSKn3 Position */
#define SCT_EVSTATEMSK8_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK8: STATEMSKn4 Position */
#define SCT_EVSTATEMSK8_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK8: STATEMSKn5 Position */
#define SCT_EVSTATEMSK8_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK8: STATEMSKn6 Position */
#define SCT_EVSTATEMSK8_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK8: STATEMSKn7 Position */
#define SCT_EVSTATEMSK8_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK8: STATEMSKn8 Position */
#define SCT_EVSTATEMSK8_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK8: STATEMSKn9 Position */
#define SCT_EVSTATEMSK8_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK8: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK8_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK8: STATEMSKn10 Position */
#define SCT_EVSTATEMSK8_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK8: STATEMSKn11 Position */
#define SCT_EVSTATEMSK8_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK8: STATEMSKn12 Position */
#define SCT_EVSTATEMSK8_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK8: STATEMSKn13 Position */
#define SCT_EVSTATEMSK8_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK8: STATEMSKn14 Position */
#define SCT_EVSTATEMSK8_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK8: STATEMSKn15 Position */
#define SCT_EVSTATEMSK8_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK8: STATEMSKn16 Position */
#define SCT_EVSTATEMSK8_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK8: STATEMSKn17 Position */
#define SCT_EVSTATEMSK8_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK8: STATEMSKn18 Position */
#define SCT_EVSTATEMSK8_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK8: STATEMSKn19 Position */
#define SCT_EVSTATEMSK8_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK8: STATEMSKn20 Position */
#define SCT_EVSTATEMSK8_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK8: STATEMSKn21 Position */
#define SCT_EVSTATEMSK8_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK8: STATEMSKn22 Position */
#define SCT_EVSTATEMSK8_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK8: STATEMSKn23 Position */
#define SCT_EVSTATEMSK8_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK8: STATEMSKn24 Position */
#define SCT_EVSTATEMSK8_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK8: STATEMSKn25 Position */
#define SCT_EVSTATEMSK8_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK8: STATEMSKn26 Position */
#define SCT_EVSTATEMSK8_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK8: STATEMSKn27 Position */
#define SCT_EVSTATEMSK8_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK8: STATEMSKn28 Position */
#define SCT_EVSTATEMSK8_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK8: STATEMSKn29 Position */
#define SCT_EVSTATEMSK8_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK8: STATEMSKn30 Position */
#define SCT_EVSTATEMSK8_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK8_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK8: STATEMSKn31 Position */
#define SCT_EVSTATEMSK8_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK8: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL8  ------------------------------------------
#define SCT_EVCTRL8_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL8: MATCHSEL Position      */
#define SCT_EVCTRL8_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL8_MATCHSEL_Pos)                      /*!< SCT EVCTRL8: MATCHSEL Mask          */
#define SCT_EVCTRL8_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL8: HEVENT Position        */
#define SCT_EVCTRL8_HEVENT_Msk                                (0x01UL << SCT_EVCTRL8_HEVENT_Pos)                        /*!< SCT EVCTRL8: HEVENT Mask            */
#define SCT_EVCTRL8_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL8: OUTSEL Position        */
#define SCT_EVCTRL8_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL8_OUTSEL_Pos)                        /*!< SCT EVCTRL8: OUTSEL Mask            */
#define SCT_EVCTRL8_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL8: IOSEL Position         */
#define SCT_EVCTRL8_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL8_IOSEL_Pos)                         /*!< SCT EVCTRL8: IOSEL Mask             */
#define SCT_EVCTRL8_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL8: IOCOND Position        */
#define SCT_EVCTRL8_IOCOND_Msk                                (0x03UL << SCT_EVCTRL8_IOCOND_Pos)                        /*!< SCT EVCTRL8: IOCOND Mask            */
#define SCT_EVCTRL8_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL8: COMBMODE Position      */
#define SCT_EVCTRL8_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL8_COMBMODE_Pos)                      /*!< SCT EVCTRL8: COMBMODE Mask          */
#define SCT_EVCTRL8_STATELD_Pos                               14                                                        /*!< SCT EVCTRL8: STATELD Position       */
#define SCT_EVCTRL8_STATELD_Msk                               (0x01UL << SCT_EVCTRL8_STATELD_Pos)                       /*!< SCT EVCTRL8: STATELD Mask           */
#define SCT_EVCTRL8_STATEV_Pos                                15                                                        /*!< SCT EVCTRL8: STATEV Position        */
#define SCT_EVCTRL8_STATEV_Msk                                (0x1fUL << SCT_EVCTRL8_STATEV_Pos)                        /*!< SCT EVCTRL8: STATEV Mask            */

// -------------------------------------  SCT_EVSTATEMSK9  ----------------------------------------
#define SCT_EVSTATEMSK9_STATEMSKn0_Pos                        0                                                         /*!< SCT EVSTATEMSK9: STATEMSKn0 Position */
#define SCT_EVSTATEMSK9_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn0_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn0 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn1_Pos                        1                                                         /*!< SCT EVSTATEMSK9: STATEMSKn1 Position */
#define SCT_EVSTATEMSK9_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn1_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn1 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn2_Pos                        2                                                         /*!< SCT EVSTATEMSK9: STATEMSKn2 Position */
#define SCT_EVSTATEMSK9_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn2_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn2 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn3_Pos                        3                                                         /*!< SCT EVSTATEMSK9: STATEMSKn3 Position */
#define SCT_EVSTATEMSK9_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn3_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn3 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn4_Pos                        4                                                         /*!< SCT EVSTATEMSK9: STATEMSKn4 Position */
#define SCT_EVSTATEMSK9_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn4_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn4 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn5_Pos                        5                                                         /*!< SCT EVSTATEMSK9: STATEMSKn5 Position */
#define SCT_EVSTATEMSK9_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn5_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn5 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn6_Pos                        6                                                         /*!< SCT EVSTATEMSK9: STATEMSKn6 Position */
#define SCT_EVSTATEMSK9_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn6_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn6 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn7_Pos                        7                                                         /*!< SCT EVSTATEMSK9: STATEMSKn7 Position */
#define SCT_EVSTATEMSK9_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn7_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn7 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn8_Pos                        8                                                         /*!< SCT EVSTATEMSK9: STATEMSKn8 Position */
#define SCT_EVSTATEMSK9_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn8_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn8 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn9_Pos                        9                                                         /*!< SCT EVSTATEMSK9: STATEMSKn9 Position */
#define SCT_EVSTATEMSK9_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn9_Pos)                /*!< SCT EVSTATEMSK9: STATEMSKn9 Mask    */
#define SCT_EVSTATEMSK9_STATEMSKn10_Pos                       10                                                        /*!< SCT EVSTATEMSK9: STATEMSKn10 Position */
#define SCT_EVSTATEMSK9_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn10_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn10 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn11_Pos                       11                                                        /*!< SCT EVSTATEMSK9: STATEMSKn11 Position */
#define SCT_EVSTATEMSK9_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn11_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn11 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn12_Pos                       12                                                        /*!< SCT EVSTATEMSK9: STATEMSKn12 Position */
#define SCT_EVSTATEMSK9_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn12_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn12 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn13_Pos                       13                                                        /*!< SCT EVSTATEMSK9: STATEMSKn13 Position */
#define SCT_EVSTATEMSK9_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn13_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn13 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn14_Pos                       14                                                        /*!< SCT EVSTATEMSK9: STATEMSKn14 Position */
#define SCT_EVSTATEMSK9_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn14_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn14 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn15_Pos                       15                                                        /*!< SCT EVSTATEMSK9: STATEMSKn15 Position */
#define SCT_EVSTATEMSK9_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn15_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn15 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn16_Pos                       16                                                        /*!< SCT EVSTATEMSK9: STATEMSKn16 Position */
#define SCT_EVSTATEMSK9_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn16_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn16 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn17_Pos                       17                                                        /*!< SCT EVSTATEMSK9: STATEMSKn17 Position */
#define SCT_EVSTATEMSK9_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn17_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn17 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn18_Pos                       18                                                        /*!< SCT EVSTATEMSK9: STATEMSKn18 Position */
#define SCT_EVSTATEMSK9_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn18_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn18 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn19_Pos                       19                                                        /*!< SCT EVSTATEMSK9: STATEMSKn19 Position */
#define SCT_EVSTATEMSK9_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn19_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn19 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn20_Pos                       20                                                        /*!< SCT EVSTATEMSK9: STATEMSKn20 Position */
#define SCT_EVSTATEMSK9_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn20_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn20 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn21_Pos                       21                                                        /*!< SCT EVSTATEMSK9: STATEMSKn21 Position */
#define SCT_EVSTATEMSK9_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn21_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn21 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn22_Pos                       22                                                        /*!< SCT EVSTATEMSK9: STATEMSKn22 Position */
#define SCT_EVSTATEMSK9_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn22_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn22 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn23_Pos                       23                                                        /*!< SCT EVSTATEMSK9: STATEMSKn23 Position */
#define SCT_EVSTATEMSK9_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn23_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn23 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn24_Pos                       24                                                        /*!< SCT EVSTATEMSK9: STATEMSKn24 Position */
#define SCT_EVSTATEMSK9_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn24_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn24 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn25_Pos                       25                                                        /*!< SCT EVSTATEMSK9: STATEMSKn25 Position */
#define SCT_EVSTATEMSK9_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn25_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn25 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn26_Pos                       26                                                        /*!< SCT EVSTATEMSK9: STATEMSKn26 Position */
#define SCT_EVSTATEMSK9_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn26_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn26 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn27_Pos                       27                                                        /*!< SCT EVSTATEMSK9: STATEMSKn27 Position */
#define SCT_EVSTATEMSK9_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn27_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn27 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn28_Pos                       28                                                        /*!< SCT EVSTATEMSK9: STATEMSKn28 Position */
#define SCT_EVSTATEMSK9_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn28_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn28 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn29_Pos                       29                                                        /*!< SCT EVSTATEMSK9: STATEMSKn29 Position */
#define SCT_EVSTATEMSK9_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn29_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn29 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn30_Pos                       30                                                        /*!< SCT EVSTATEMSK9: STATEMSKn30 Position */
#define SCT_EVSTATEMSK9_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn30_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn30 Mask   */
#define SCT_EVSTATEMSK9_STATEMSKn31_Pos                       31                                                        /*!< SCT EVSTATEMSK9: STATEMSKn31 Position */
#define SCT_EVSTATEMSK9_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn31_Pos)               /*!< SCT EVSTATEMSK9: STATEMSKn31 Mask   */

// ---------------------------------------  SCT_EVCTRL9  ------------------------------------------
#define SCT_EVCTRL9_MATCHSEL_Pos                              0                                                         /*!< SCT EVCTRL9: MATCHSEL Position      */
#define SCT_EVCTRL9_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL9_MATCHSEL_Pos)                      /*!< SCT EVCTRL9: MATCHSEL Mask          */
#define SCT_EVCTRL9_HEVENT_Pos                                4                                                         /*!< SCT EVCTRL9: HEVENT Position        */
#define SCT_EVCTRL9_HEVENT_Msk                                (0x01UL << SCT_EVCTRL9_HEVENT_Pos)                        /*!< SCT EVCTRL9: HEVENT Mask            */
#define SCT_EVCTRL9_OUTSEL_Pos                                5                                                         /*!< SCT EVCTRL9: OUTSEL Position        */
#define SCT_EVCTRL9_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL9_OUTSEL_Pos)                        /*!< SCT EVCTRL9: OUTSEL Mask            */
#define SCT_EVCTRL9_IOSEL_Pos                                 6                                                         /*!< SCT EVCTRL9: IOSEL Position         */
#define SCT_EVCTRL9_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL9_IOSEL_Pos)                         /*!< SCT EVCTRL9: IOSEL Mask             */
#define SCT_EVCTRL9_IOCOND_Pos                                10                                                        /*!< SCT EVCTRL9: IOCOND Position        */
#define SCT_EVCTRL9_IOCOND_Msk                                (0x03UL << SCT_EVCTRL9_IOCOND_Pos)                        /*!< SCT EVCTRL9: IOCOND Mask            */
#define SCT_EVCTRL9_COMBMODE_Pos                              12                                                        /*!< SCT EVCTRL9: COMBMODE Position      */
#define SCT_EVCTRL9_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL9_COMBMODE_Pos)                      /*!< SCT EVCTRL9: COMBMODE Mask          */
#define SCT_EVCTRL9_STATELD_Pos                               14                                                        /*!< SCT EVCTRL9: STATELD Position       */
#define SCT_EVCTRL9_STATELD_Msk                               (0x01UL << SCT_EVCTRL9_STATELD_Pos)                       /*!< SCT EVCTRL9: STATELD Mask           */
#define SCT_EVCTRL9_STATEV_Pos                                15                                                        /*!< SCT EVCTRL9: STATEV Position        */
#define SCT_EVCTRL9_STATEV_Msk                                (0x1fUL << SCT_EVCTRL9_STATEV_Pos)                        /*!< SCT EVCTRL9: STATEV Mask            */

// ------------------------------------  SCT_EVSTATEMSK10  ----------------------------------------
#define SCT_EVSTATEMSK10_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK10: STATEMSKn0 Position */
#define SCT_EVSTATEMSK10_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK10: STATEMSKn1 Position */
#define SCT_EVSTATEMSK10_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK10: STATEMSKn2 Position */
#define SCT_EVSTATEMSK10_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK10: STATEMSKn3 Position */
#define SCT_EVSTATEMSK10_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK10: STATEMSKn4 Position */
#define SCT_EVSTATEMSK10_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK10: STATEMSKn5 Position */
#define SCT_EVSTATEMSK10_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK10: STATEMSKn6 Position */
#define SCT_EVSTATEMSK10_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK10: STATEMSKn7 Position */
#define SCT_EVSTATEMSK10_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK10: STATEMSKn8 Position */
#define SCT_EVSTATEMSK10_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK10: STATEMSKn9 Position */
#define SCT_EVSTATEMSK10_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK10: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK10_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK10: STATEMSKn10 Position */
#define SCT_EVSTATEMSK10_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK10: STATEMSKn11 Position */
#define SCT_EVSTATEMSK10_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK10: STATEMSKn12 Position */
#define SCT_EVSTATEMSK10_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK10: STATEMSKn13 Position */
#define SCT_EVSTATEMSK10_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK10: STATEMSKn14 Position */
#define SCT_EVSTATEMSK10_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK10: STATEMSKn15 Position */
#define SCT_EVSTATEMSK10_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK10: STATEMSKn16 Position */
#define SCT_EVSTATEMSK10_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK10: STATEMSKn17 Position */
#define SCT_EVSTATEMSK10_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK10: STATEMSKn18 Position */
#define SCT_EVSTATEMSK10_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK10: STATEMSKn19 Position */
#define SCT_EVSTATEMSK10_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK10: STATEMSKn20 Position */
#define SCT_EVSTATEMSK10_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK10: STATEMSKn21 Position */
#define SCT_EVSTATEMSK10_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK10: STATEMSKn22 Position */
#define SCT_EVSTATEMSK10_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK10: STATEMSKn23 Position */
#define SCT_EVSTATEMSK10_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK10: STATEMSKn24 Position */
#define SCT_EVSTATEMSK10_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK10: STATEMSKn25 Position */
#define SCT_EVSTATEMSK10_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK10: STATEMSKn26 Position */
#define SCT_EVSTATEMSK10_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK10: STATEMSKn27 Position */
#define SCT_EVSTATEMSK10_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK10: STATEMSKn28 Position */
#define SCT_EVSTATEMSK10_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK10: STATEMSKn29 Position */
#define SCT_EVSTATEMSK10_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK10: STATEMSKn30 Position */
#define SCT_EVSTATEMSK10_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK10_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK10: STATEMSKn31 Position */
#define SCT_EVSTATEMSK10_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK10: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL10  ------------------------------------------
#define SCT_EVCTRL10_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL10: MATCHSEL Position     */
#define SCT_EVCTRL10_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL10_MATCHSEL_Pos)                     /*!< SCT EVCTRL10: MATCHSEL Mask         */
#define SCT_EVCTRL10_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL10: HEVENT Position       */
#define SCT_EVCTRL10_HEVENT_Msk                               (0x01UL << SCT_EVCTRL10_HEVENT_Pos)                       /*!< SCT EVCTRL10: HEVENT Mask           */
#define SCT_EVCTRL10_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL10: OUTSEL Position       */
#define SCT_EVCTRL10_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL10_OUTSEL_Pos)                       /*!< SCT EVCTRL10: OUTSEL Mask           */
#define SCT_EVCTRL10_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL10: IOSEL Position        */
#define SCT_EVCTRL10_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL10_IOSEL_Pos)                        /*!< SCT EVCTRL10: IOSEL Mask            */
#define SCT_EVCTRL10_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL10: IOCOND Position       */
#define SCT_EVCTRL10_IOCOND_Msk                               (0x03UL << SCT_EVCTRL10_IOCOND_Pos)                       /*!< SCT EVCTRL10: IOCOND Mask           */
#define SCT_EVCTRL10_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL10: COMBMODE Position     */
#define SCT_EVCTRL10_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL10_COMBMODE_Pos)                     /*!< SCT EVCTRL10: COMBMODE Mask         */
#define SCT_EVCTRL10_STATELD_Pos                              14                                                        /*!< SCT EVCTRL10: STATELD Position      */
#define SCT_EVCTRL10_STATELD_Msk                              (0x01UL << SCT_EVCTRL10_STATELD_Pos)                      /*!< SCT EVCTRL10: STATELD Mask          */
#define SCT_EVCTRL10_STATEV_Pos                               15                                                        /*!< SCT EVCTRL10: STATEV Position       */
#define SCT_EVCTRL10_STATEV_Msk                               (0x1fUL << SCT_EVCTRL10_STATEV_Pos)                       /*!< SCT EVCTRL10: STATEV Mask           */

// ------------------------------------  SCT_EVSTATEMSK11  ----------------------------------------
#define SCT_EVSTATEMSK11_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK11: STATEMSKn0 Position */
#define SCT_EVSTATEMSK11_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK11: STATEMSKn1 Position */
#define SCT_EVSTATEMSK11_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK11: STATEMSKn2 Position */
#define SCT_EVSTATEMSK11_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK11: STATEMSKn3 Position */
#define SCT_EVSTATEMSK11_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK11: STATEMSKn4 Position */
#define SCT_EVSTATEMSK11_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK11: STATEMSKn5 Position */
#define SCT_EVSTATEMSK11_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK11: STATEMSKn6 Position */
#define SCT_EVSTATEMSK11_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK11: STATEMSKn7 Position */
#define SCT_EVSTATEMSK11_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK11: STATEMSKn8 Position */
#define SCT_EVSTATEMSK11_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK11: STATEMSKn9 Position */
#define SCT_EVSTATEMSK11_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK11: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK11_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK11: STATEMSKn10 Position */
#define SCT_EVSTATEMSK11_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK11: STATEMSKn11 Position */
#define SCT_EVSTATEMSK11_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK11: STATEMSKn12 Position */
#define SCT_EVSTATEMSK11_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK11: STATEMSKn13 Position */
#define SCT_EVSTATEMSK11_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK11: STATEMSKn14 Position */
#define SCT_EVSTATEMSK11_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK11: STATEMSKn15 Position */
#define SCT_EVSTATEMSK11_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK11: STATEMSKn16 Position */
#define SCT_EVSTATEMSK11_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK11: STATEMSKn17 Position */
#define SCT_EVSTATEMSK11_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK11: STATEMSKn18 Position */
#define SCT_EVSTATEMSK11_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK11: STATEMSKn19 Position */
#define SCT_EVSTATEMSK11_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK11: STATEMSKn20 Position */
#define SCT_EVSTATEMSK11_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK11: STATEMSKn21 Position */
#define SCT_EVSTATEMSK11_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK11: STATEMSKn22 Position */
#define SCT_EVSTATEMSK11_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK11: STATEMSKn23 Position */
#define SCT_EVSTATEMSK11_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK11: STATEMSKn24 Position */
#define SCT_EVSTATEMSK11_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK11: STATEMSKn25 Position */
#define SCT_EVSTATEMSK11_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK11: STATEMSKn26 Position */
#define SCT_EVSTATEMSK11_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK11: STATEMSKn27 Position */
#define SCT_EVSTATEMSK11_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK11: STATEMSKn28 Position */
#define SCT_EVSTATEMSK11_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK11: STATEMSKn29 Position */
#define SCT_EVSTATEMSK11_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK11: STATEMSKn30 Position */
#define SCT_EVSTATEMSK11_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK11_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK11: STATEMSKn31 Position */
#define SCT_EVSTATEMSK11_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK11: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL11  ------------------------------------------
#define SCT_EVCTRL11_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL11: MATCHSEL Position     */
#define SCT_EVCTRL11_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL11_MATCHSEL_Pos)                     /*!< SCT EVCTRL11: MATCHSEL Mask         */
#define SCT_EVCTRL11_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL11: HEVENT Position       */
#define SCT_EVCTRL11_HEVENT_Msk                               (0x01UL << SCT_EVCTRL11_HEVENT_Pos)                       /*!< SCT EVCTRL11: HEVENT Mask           */
#define SCT_EVCTRL11_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL11: OUTSEL Position       */
#define SCT_EVCTRL11_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL11_OUTSEL_Pos)                       /*!< SCT EVCTRL11: OUTSEL Mask           */
#define SCT_EVCTRL11_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL11: IOSEL Position        */
#define SCT_EVCTRL11_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL11_IOSEL_Pos)                        /*!< SCT EVCTRL11: IOSEL Mask            */
#define SCT_EVCTRL11_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL11: IOCOND Position       */
#define SCT_EVCTRL11_IOCOND_Msk                               (0x03UL << SCT_EVCTRL11_IOCOND_Pos)                       /*!< SCT EVCTRL11: IOCOND Mask           */
#define SCT_EVCTRL11_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL11: COMBMODE Position     */
#define SCT_EVCTRL11_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL11_COMBMODE_Pos)                     /*!< SCT EVCTRL11: COMBMODE Mask         */
#define SCT_EVCTRL11_STATELD_Pos                              14                                                        /*!< SCT EVCTRL11: STATELD Position      */
#define SCT_EVCTRL11_STATELD_Msk                              (0x01UL << SCT_EVCTRL11_STATELD_Pos)                      /*!< SCT EVCTRL11: STATELD Mask          */
#define SCT_EVCTRL11_STATEV_Pos                               15                                                        /*!< SCT EVCTRL11: STATEV Position       */
#define SCT_EVCTRL11_STATEV_Msk                               (0x1fUL << SCT_EVCTRL11_STATEV_Pos)                       /*!< SCT EVCTRL11: STATEV Mask           */

// ------------------------------------  SCT_EVSTATEMSK12  ----------------------------------------
#define SCT_EVSTATEMSK12_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK12: STATEMSKn0 Position */
#define SCT_EVSTATEMSK12_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK12: STATEMSKn1 Position */
#define SCT_EVSTATEMSK12_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK12: STATEMSKn2 Position */
#define SCT_EVSTATEMSK12_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK12: STATEMSKn3 Position */
#define SCT_EVSTATEMSK12_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK12: STATEMSKn4 Position */
#define SCT_EVSTATEMSK12_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK12: STATEMSKn5 Position */
#define SCT_EVSTATEMSK12_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK12: STATEMSKn6 Position */
#define SCT_EVSTATEMSK12_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK12: STATEMSKn7 Position */
#define SCT_EVSTATEMSK12_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK12: STATEMSKn8 Position */
#define SCT_EVSTATEMSK12_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK12: STATEMSKn9 Position */
#define SCT_EVSTATEMSK12_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK12: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK12_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK12: STATEMSKn10 Position */
#define SCT_EVSTATEMSK12_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK12: STATEMSKn11 Position */
#define SCT_EVSTATEMSK12_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK12: STATEMSKn12 Position */
#define SCT_EVSTATEMSK12_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK12: STATEMSKn13 Position */
#define SCT_EVSTATEMSK12_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK12: STATEMSKn14 Position */
#define SCT_EVSTATEMSK12_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK12: STATEMSKn15 Position */
#define SCT_EVSTATEMSK12_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK12: STATEMSKn16 Position */
#define SCT_EVSTATEMSK12_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK12: STATEMSKn17 Position */
#define SCT_EVSTATEMSK12_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK12: STATEMSKn18 Position */
#define SCT_EVSTATEMSK12_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK12: STATEMSKn19 Position */
#define SCT_EVSTATEMSK12_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK12: STATEMSKn20 Position */
#define SCT_EVSTATEMSK12_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK12: STATEMSKn21 Position */
#define SCT_EVSTATEMSK12_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK12: STATEMSKn22 Position */
#define SCT_EVSTATEMSK12_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK12: STATEMSKn23 Position */
#define SCT_EVSTATEMSK12_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK12: STATEMSKn24 Position */
#define SCT_EVSTATEMSK12_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK12: STATEMSKn25 Position */
#define SCT_EVSTATEMSK12_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK12: STATEMSKn26 Position */
#define SCT_EVSTATEMSK12_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK12: STATEMSKn27 Position */
#define SCT_EVSTATEMSK12_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK12: STATEMSKn28 Position */
#define SCT_EVSTATEMSK12_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK12: STATEMSKn29 Position */
#define SCT_EVSTATEMSK12_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK12: STATEMSKn30 Position */
#define SCT_EVSTATEMSK12_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK12_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK12: STATEMSKn31 Position */
#define SCT_EVSTATEMSK12_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK12: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL12  ------------------------------------------
#define SCT_EVCTRL12_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL12: MATCHSEL Position     */
#define SCT_EVCTRL12_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL12_MATCHSEL_Pos)                     /*!< SCT EVCTRL12: MATCHSEL Mask         */
#define SCT_EVCTRL12_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL12: HEVENT Position       */
#define SCT_EVCTRL12_HEVENT_Msk                               (0x01UL << SCT_EVCTRL12_HEVENT_Pos)                       /*!< SCT EVCTRL12: HEVENT Mask           */
#define SCT_EVCTRL12_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL12: OUTSEL Position       */
#define SCT_EVCTRL12_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL12_OUTSEL_Pos)                       /*!< SCT EVCTRL12: OUTSEL Mask           */
#define SCT_EVCTRL12_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL12: IOSEL Position        */
#define SCT_EVCTRL12_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL12_IOSEL_Pos)                        /*!< SCT EVCTRL12: IOSEL Mask            */
#define SCT_EVCTRL12_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL12: IOCOND Position       */
#define SCT_EVCTRL12_IOCOND_Msk                               (0x03UL << SCT_EVCTRL12_IOCOND_Pos)                       /*!< SCT EVCTRL12: IOCOND Mask           */
#define SCT_EVCTRL12_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL12: COMBMODE Position     */
#define SCT_EVCTRL12_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL12_COMBMODE_Pos)                     /*!< SCT EVCTRL12: COMBMODE Mask         */
#define SCT_EVCTRL12_STATELD_Pos                              14                                                        /*!< SCT EVCTRL12: STATELD Position      */
#define SCT_EVCTRL12_STATELD_Msk                              (0x01UL << SCT_EVCTRL12_STATELD_Pos)                      /*!< SCT EVCTRL12: STATELD Mask          */
#define SCT_EVCTRL12_STATEV_Pos                               15                                                        /*!< SCT EVCTRL12: STATEV Position       */
#define SCT_EVCTRL12_STATEV_Msk                               (0x1fUL << SCT_EVCTRL12_STATEV_Pos)                       /*!< SCT EVCTRL12: STATEV Mask           */

// ------------------------------------  SCT_EVSTATEMSK13  ----------------------------------------
#define SCT_EVSTATEMSK13_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK13: STATEMSKn0 Position */
#define SCT_EVSTATEMSK13_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK13: STATEMSKn1 Position */
#define SCT_EVSTATEMSK13_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK13: STATEMSKn2 Position */
#define SCT_EVSTATEMSK13_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK13: STATEMSKn3 Position */
#define SCT_EVSTATEMSK13_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK13: STATEMSKn4 Position */
#define SCT_EVSTATEMSK13_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK13: STATEMSKn5 Position */
#define SCT_EVSTATEMSK13_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK13: STATEMSKn6 Position */
#define SCT_EVSTATEMSK13_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK13: STATEMSKn7 Position */
#define SCT_EVSTATEMSK13_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK13: STATEMSKn8 Position */
#define SCT_EVSTATEMSK13_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK13: STATEMSKn9 Position */
#define SCT_EVSTATEMSK13_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK13: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK13_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK13: STATEMSKn10 Position */
#define SCT_EVSTATEMSK13_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK13: STATEMSKn11 Position */
#define SCT_EVSTATEMSK13_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK13: STATEMSKn12 Position */
#define SCT_EVSTATEMSK13_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK13: STATEMSKn13 Position */
#define SCT_EVSTATEMSK13_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK13: STATEMSKn14 Position */
#define SCT_EVSTATEMSK13_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK13: STATEMSKn15 Position */
#define SCT_EVSTATEMSK13_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK13: STATEMSKn16 Position */
#define SCT_EVSTATEMSK13_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK13: STATEMSKn17 Position */
#define SCT_EVSTATEMSK13_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK13: STATEMSKn18 Position */
#define SCT_EVSTATEMSK13_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK13: STATEMSKn19 Position */
#define SCT_EVSTATEMSK13_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK13: STATEMSKn20 Position */
#define SCT_EVSTATEMSK13_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK13: STATEMSKn21 Position */
#define SCT_EVSTATEMSK13_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK13: STATEMSKn22 Position */
#define SCT_EVSTATEMSK13_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK13: STATEMSKn23 Position */
#define SCT_EVSTATEMSK13_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK13: STATEMSKn24 Position */
#define SCT_EVSTATEMSK13_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK13: STATEMSKn25 Position */
#define SCT_EVSTATEMSK13_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK13: STATEMSKn26 Position */
#define SCT_EVSTATEMSK13_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK13: STATEMSKn27 Position */
#define SCT_EVSTATEMSK13_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK13: STATEMSKn28 Position */
#define SCT_EVSTATEMSK13_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK13: STATEMSKn29 Position */
#define SCT_EVSTATEMSK13_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK13: STATEMSKn30 Position */
#define SCT_EVSTATEMSK13_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK13_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK13: STATEMSKn31 Position */
#define SCT_EVSTATEMSK13_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK13: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL13  ------------------------------------------
#define SCT_EVCTRL13_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL13: MATCHSEL Position     */
#define SCT_EVCTRL13_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL13_MATCHSEL_Pos)                     /*!< SCT EVCTRL13: MATCHSEL Mask         */
#define SCT_EVCTRL13_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL13: HEVENT Position       */
#define SCT_EVCTRL13_HEVENT_Msk                               (0x01UL << SCT_EVCTRL13_HEVENT_Pos)                       /*!< SCT EVCTRL13: HEVENT Mask           */
#define SCT_EVCTRL13_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL13: OUTSEL Position       */
#define SCT_EVCTRL13_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL13_OUTSEL_Pos)                       /*!< SCT EVCTRL13: OUTSEL Mask           */
#define SCT_EVCTRL13_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL13: IOSEL Position        */
#define SCT_EVCTRL13_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL13_IOSEL_Pos)                        /*!< SCT EVCTRL13: IOSEL Mask            */
#define SCT_EVCTRL13_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL13: IOCOND Position       */
#define SCT_EVCTRL13_IOCOND_Msk                               (0x03UL << SCT_EVCTRL13_IOCOND_Pos)                       /*!< SCT EVCTRL13: IOCOND Mask           */
#define SCT_EVCTRL13_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL13: COMBMODE Position     */
#define SCT_EVCTRL13_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL13_COMBMODE_Pos)                     /*!< SCT EVCTRL13: COMBMODE Mask         */
#define SCT_EVCTRL13_STATELD_Pos                              14                                                        /*!< SCT EVCTRL13: STATELD Position      */
#define SCT_EVCTRL13_STATELD_Msk                              (0x01UL << SCT_EVCTRL13_STATELD_Pos)                      /*!< SCT EVCTRL13: STATELD Mask          */
#define SCT_EVCTRL13_STATEV_Pos                               15                                                        /*!< SCT EVCTRL13: STATEV Position       */
#define SCT_EVCTRL13_STATEV_Msk                               (0x1fUL << SCT_EVCTRL13_STATEV_Pos)                       /*!< SCT EVCTRL13: STATEV Mask           */

// ------------------------------------  SCT_EVSTATEMSK14  ----------------------------------------
#define SCT_EVSTATEMSK14_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK14: STATEMSKn0 Position */
#define SCT_EVSTATEMSK14_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK14: STATEMSKn1 Position */
#define SCT_EVSTATEMSK14_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK14: STATEMSKn2 Position */
#define SCT_EVSTATEMSK14_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK14: STATEMSKn3 Position */
#define SCT_EVSTATEMSK14_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK14: STATEMSKn4 Position */
#define SCT_EVSTATEMSK14_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK14: STATEMSKn5 Position */
#define SCT_EVSTATEMSK14_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK14: STATEMSKn6 Position */
#define SCT_EVSTATEMSK14_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK14: STATEMSKn7 Position */
#define SCT_EVSTATEMSK14_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK14: STATEMSKn8 Position */
#define SCT_EVSTATEMSK14_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK14: STATEMSKn9 Position */
#define SCT_EVSTATEMSK14_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK14: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK14_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK14: STATEMSKn10 Position */
#define SCT_EVSTATEMSK14_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK14: STATEMSKn11 Position */
#define SCT_EVSTATEMSK14_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK14: STATEMSKn12 Position */
#define SCT_EVSTATEMSK14_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK14: STATEMSKn13 Position */
#define SCT_EVSTATEMSK14_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK14: STATEMSKn14 Position */
#define SCT_EVSTATEMSK14_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK14: STATEMSKn15 Position */
#define SCT_EVSTATEMSK14_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK14: STATEMSKn16 Position */
#define SCT_EVSTATEMSK14_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK14: STATEMSKn17 Position */
#define SCT_EVSTATEMSK14_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK14: STATEMSKn18 Position */
#define SCT_EVSTATEMSK14_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK14: STATEMSKn19 Position */
#define SCT_EVSTATEMSK14_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK14: STATEMSKn20 Position */
#define SCT_EVSTATEMSK14_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK14: STATEMSKn21 Position */
#define SCT_EVSTATEMSK14_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK14: STATEMSKn22 Position */
#define SCT_EVSTATEMSK14_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK14: STATEMSKn23 Position */
#define SCT_EVSTATEMSK14_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK14: STATEMSKn24 Position */
#define SCT_EVSTATEMSK14_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK14: STATEMSKn25 Position */
#define SCT_EVSTATEMSK14_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK14: STATEMSKn26 Position */
#define SCT_EVSTATEMSK14_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK14: STATEMSKn27 Position */
#define SCT_EVSTATEMSK14_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK14: STATEMSKn28 Position */
#define SCT_EVSTATEMSK14_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK14: STATEMSKn29 Position */
#define SCT_EVSTATEMSK14_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK14: STATEMSKn30 Position */
#define SCT_EVSTATEMSK14_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK14_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK14: STATEMSKn31 Position */
#define SCT_EVSTATEMSK14_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK14: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL14  ------------------------------------------
#define SCT_EVCTRL14_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL14: MATCHSEL Position     */
#define SCT_EVCTRL14_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL14_MATCHSEL_Pos)                     /*!< SCT EVCTRL14: MATCHSEL Mask         */
#define SCT_EVCTRL14_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL14: HEVENT Position       */
#define SCT_EVCTRL14_HEVENT_Msk                               (0x01UL << SCT_EVCTRL14_HEVENT_Pos)                       /*!< SCT EVCTRL14: HEVENT Mask           */
#define SCT_EVCTRL14_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL14: OUTSEL Position       */
#define SCT_EVCTRL14_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL14_OUTSEL_Pos)                       /*!< SCT EVCTRL14: OUTSEL Mask           */
#define SCT_EVCTRL14_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL14: IOSEL Position        */
#define SCT_EVCTRL14_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL14_IOSEL_Pos)                        /*!< SCT EVCTRL14: IOSEL Mask            */
#define SCT_EVCTRL14_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL14: IOCOND Position       */
#define SCT_EVCTRL14_IOCOND_Msk                               (0x03UL << SCT_EVCTRL14_IOCOND_Pos)                       /*!< SCT EVCTRL14: IOCOND Mask           */
#define SCT_EVCTRL14_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL14: COMBMODE Position     */
#define SCT_EVCTRL14_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL14_COMBMODE_Pos)                     /*!< SCT EVCTRL14: COMBMODE Mask         */
#define SCT_EVCTRL14_STATELD_Pos                              14                                                        /*!< SCT EVCTRL14: STATELD Position      */
#define SCT_EVCTRL14_STATELD_Msk                              (0x01UL << SCT_EVCTRL14_STATELD_Pos)                      /*!< SCT EVCTRL14: STATELD Mask          */
#define SCT_EVCTRL14_STATEV_Pos                               15                                                        /*!< SCT EVCTRL14: STATEV Position       */
#define SCT_EVCTRL14_STATEV_Msk                               (0x1fUL << SCT_EVCTRL14_STATEV_Pos)                       /*!< SCT EVCTRL14: STATEV Mask           */

// ------------------------------------  SCT_EVSTATEMSK15  ----------------------------------------
#define SCT_EVSTATEMSK15_STATEMSKn0_Pos                       0                                                         /*!< SCT EVSTATEMSK15: STATEMSKn0 Position */
#define SCT_EVSTATEMSK15_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn0_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn0 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn1_Pos                       1                                                         /*!< SCT EVSTATEMSK15: STATEMSKn1 Position */
#define SCT_EVSTATEMSK15_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn1_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn1 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn2_Pos                       2                                                         /*!< SCT EVSTATEMSK15: STATEMSKn2 Position */
#define SCT_EVSTATEMSK15_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn2_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn2 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn3_Pos                       3                                                         /*!< SCT EVSTATEMSK15: STATEMSKn3 Position */
#define SCT_EVSTATEMSK15_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn3_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn3 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn4_Pos                       4                                                         /*!< SCT EVSTATEMSK15: STATEMSKn4 Position */
#define SCT_EVSTATEMSK15_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn4_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn4 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn5_Pos                       5                                                         /*!< SCT EVSTATEMSK15: STATEMSKn5 Position */
#define SCT_EVSTATEMSK15_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn5_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn5 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn6_Pos                       6                                                         /*!< SCT EVSTATEMSK15: STATEMSKn6 Position */
#define SCT_EVSTATEMSK15_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn6_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn6 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn7_Pos                       7                                                         /*!< SCT EVSTATEMSK15: STATEMSKn7 Position */
#define SCT_EVSTATEMSK15_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn7_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn7 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn8_Pos                       8                                                         /*!< SCT EVSTATEMSK15: STATEMSKn8 Position */
#define SCT_EVSTATEMSK15_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn8_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn8 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn9_Pos                       9                                                         /*!< SCT EVSTATEMSK15: STATEMSKn9 Position */
#define SCT_EVSTATEMSK15_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn9_Pos)               /*!< SCT EVSTATEMSK15: STATEMSKn9 Mask   */
#define SCT_EVSTATEMSK15_STATEMSKn10_Pos                      10                                                        /*!< SCT EVSTATEMSK15: STATEMSKn10 Position */
#define SCT_EVSTATEMSK15_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn10_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn10 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn11_Pos                      11                                                        /*!< SCT EVSTATEMSK15: STATEMSKn11 Position */
#define SCT_EVSTATEMSK15_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn11_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn11 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn12_Pos                      12                                                        /*!< SCT EVSTATEMSK15: STATEMSKn12 Position */
#define SCT_EVSTATEMSK15_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn12_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn12 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn13_Pos                      13                                                        /*!< SCT EVSTATEMSK15: STATEMSKn13 Position */
#define SCT_EVSTATEMSK15_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn13_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn13 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn14_Pos                      14                                                        /*!< SCT EVSTATEMSK15: STATEMSKn14 Position */
#define SCT_EVSTATEMSK15_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn14_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn14 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn15_Pos                      15                                                        /*!< SCT EVSTATEMSK15: STATEMSKn15 Position */
#define SCT_EVSTATEMSK15_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn15_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn15 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn16_Pos                      16                                                        /*!< SCT EVSTATEMSK15: STATEMSKn16 Position */
#define SCT_EVSTATEMSK15_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn16_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn16 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn17_Pos                      17                                                        /*!< SCT EVSTATEMSK15: STATEMSKn17 Position */
#define SCT_EVSTATEMSK15_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn17_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn17 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn18_Pos                      18                                                        /*!< SCT EVSTATEMSK15: STATEMSKn18 Position */
#define SCT_EVSTATEMSK15_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn18_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn18 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn19_Pos                      19                                                        /*!< SCT EVSTATEMSK15: STATEMSKn19 Position */
#define SCT_EVSTATEMSK15_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn19_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn19 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn20_Pos                      20                                                        /*!< SCT EVSTATEMSK15: STATEMSKn20 Position */
#define SCT_EVSTATEMSK15_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn20_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn20 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn21_Pos                      21                                                        /*!< SCT EVSTATEMSK15: STATEMSKn21 Position */
#define SCT_EVSTATEMSK15_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn21_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn21 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn22_Pos                      22                                                        /*!< SCT EVSTATEMSK15: STATEMSKn22 Position */
#define SCT_EVSTATEMSK15_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn22_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn22 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn23_Pos                      23                                                        /*!< SCT EVSTATEMSK15: STATEMSKn23 Position */
#define SCT_EVSTATEMSK15_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn23_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn23 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn24_Pos                      24                                                        /*!< SCT EVSTATEMSK15: STATEMSKn24 Position */
#define SCT_EVSTATEMSK15_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn24_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn24 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn25_Pos                      25                                                        /*!< SCT EVSTATEMSK15: STATEMSKn25 Position */
#define SCT_EVSTATEMSK15_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn25_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn25 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn26_Pos                      26                                                        /*!< SCT EVSTATEMSK15: STATEMSKn26 Position */
#define SCT_EVSTATEMSK15_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn26_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn26 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn27_Pos                      27                                                        /*!< SCT EVSTATEMSK15: STATEMSKn27 Position */
#define SCT_EVSTATEMSK15_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn27_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn27 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn28_Pos                      28                                                        /*!< SCT EVSTATEMSK15: STATEMSKn28 Position */
#define SCT_EVSTATEMSK15_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn28_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn28 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn29_Pos                      29                                                        /*!< SCT EVSTATEMSK15: STATEMSKn29 Position */
#define SCT_EVSTATEMSK15_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn29_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn29 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn30_Pos                      30                                                        /*!< SCT EVSTATEMSK15: STATEMSKn30 Position */
#define SCT_EVSTATEMSK15_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn30_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn30 Mask  */
#define SCT_EVSTATEMSK15_STATEMSKn31_Pos                      31                                                        /*!< SCT EVSTATEMSK15: STATEMSKn31 Position */
#define SCT_EVSTATEMSK15_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn31_Pos)              /*!< SCT EVSTATEMSK15: STATEMSKn31 Mask  */

// --------------------------------------  SCT_EVCTRL15  ------------------------------------------
#define SCT_EVCTRL15_MATCHSEL_Pos                             0                                                         /*!< SCT EVCTRL15: MATCHSEL Position     */
#define SCT_EVCTRL15_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL15_MATCHSEL_Pos)                     /*!< SCT EVCTRL15: MATCHSEL Mask         */
#define SCT_EVCTRL15_HEVENT_Pos                               4                                                         /*!< SCT EVCTRL15: HEVENT Position       */
#define SCT_EVCTRL15_HEVENT_Msk                               (0x01UL << SCT_EVCTRL15_HEVENT_Pos)                       /*!< SCT EVCTRL15: HEVENT Mask           */
#define SCT_EVCTRL15_OUTSEL_Pos                               5                                                         /*!< SCT EVCTRL15: OUTSEL Position       */
#define SCT_EVCTRL15_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL15_OUTSEL_Pos)                       /*!< SCT EVCTRL15: OUTSEL Mask           */
#define SCT_EVCTRL15_IOSEL_Pos                                6                                                         /*!< SCT EVCTRL15: IOSEL Position        */
#define SCT_EVCTRL15_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL15_IOSEL_Pos)                        /*!< SCT EVCTRL15: IOSEL Mask            */
#define SCT_EVCTRL15_IOCOND_Pos                               10                                                        /*!< SCT EVCTRL15: IOCOND Position       */
#define SCT_EVCTRL15_IOCOND_Msk                               (0x03UL << SCT_EVCTRL15_IOCOND_Pos)                       /*!< SCT EVCTRL15: IOCOND Mask           */
#define SCT_EVCTRL15_COMBMODE_Pos                             12                                                        /*!< SCT EVCTRL15: COMBMODE Position     */
#define SCT_EVCTRL15_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL15_COMBMODE_Pos)                     /*!< SCT EVCTRL15: COMBMODE Mask         */
#define SCT_EVCTRL15_STATELD_Pos                              14                                                        /*!< SCT EVCTRL15: STATELD Position      */
#define SCT_EVCTRL15_STATELD_Msk                              (0x01UL << SCT_EVCTRL15_STATELD_Pos)                      /*!< SCT EVCTRL15: STATELD Mask          */
#define SCT_EVCTRL15_STATEV_Pos                               15                                                        /*!< SCT EVCTRL15: STATEV Position       */
#define SCT_EVCTRL15_STATEV_Msk                               (0x1fUL << SCT_EVCTRL15_STATEV_Pos)                       /*!< SCT EVCTRL15: STATEV Mask           */

// -------------------------------------  SCT_OUTPUTSET0  -----------------------------------------
#define SCT_OUTPUTSET0_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET0: SETn0 Position      */
#define SCT_OUTPUTSET0_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn0_Pos)                      /*!< SCT OUTPUTSET0: SETn0 Mask          */
#define SCT_OUTPUTSET0_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET0: SETn1 Position      */
#define SCT_OUTPUTSET0_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn1_Pos)                      /*!< SCT OUTPUTSET0: SETn1 Mask          */
#define SCT_OUTPUTSET0_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET0: SETn2 Position      */
#define SCT_OUTPUTSET0_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn2_Pos)                      /*!< SCT OUTPUTSET0: SETn2 Mask          */
#define SCT_OUTPUTSET0_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET0: SETn3 Position      */
#define SCT_OUTPUTSET0_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn3_Pos)                      /*!< SCT OUTPUTSET0: SETn3 Mask          */
#define SCT_OUTPUTSET0_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET0: SETn4 Position      */
#define SCT_OUTPUTSET0_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn4_Pos)                      /*!< SCT OUTPUTSET0: SETn4 Mask          */
#define SCT_OUTPUTSET0_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET0: SETn5 Position      */
#define SCT_OUTPUTSET0_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn5_Pos)                      /*!< SCT OUTPUTSET0: SETn5 Mask          */
#define SCT_OUTPUTSET0_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET0: SETn6 Position      */
#define SCT_OUTPUTSET0_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn6_Pos)                      /*!< SCT OUTPUTSET0: SETn6 Mask          */
#define SCT_OUTPUTSET0_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET0: SETn7 Position      */
#define SCT_OUTPUTSET0_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn7_Pos)                      /*!< SCT OUTPUTSET0: SETn7 Mask          */
#define SCT_OUTPUTSET0_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET0: SETn8 Position      */
#define SCT_OUTPUTSET0_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn8_Pos)                      /*!< SCT OUTPUTSET0: SETn8 Mask          */
#define SCT_OUTPUTSET0_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET0: SETn9 Position      */
#define SCT_OUTPUTSET0_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn9_Pos)                      /*!< SCT OUTPUTSET0: SETn9 Mask          */
#define SCT_OUTPUTSET0_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET0: SETn10 Position     */
#define SCT_OUTPUTSET0_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn10_Pos)                     /*!< SCT OUTPUTSET0: SETn10 Mask         */
#define SCT_OUTPUTSET0_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET0: SETn11 Position     */
#define SCT_OUTPUTSET0_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn11_Pos)                     /*!< SCT OUTPUTSET0: SETn11 Mask         */
#define SCT_OUTPUTSET0_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET0: SETn12 Position     */
#define SCT_OUTPUTSET0_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn12_Pos)                     /*!< SCT OUTPUTSET0: SETn12 Mask         */
#define SCT_OUTPUTSET0_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET0: SETn13 Position     */
#define SCT_OUTPUTSET0_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn13_Pos)                     /*!< SCT OUTPUTSET0: SETn13 Mask         */
#define SCT_OUTPUTSET0_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET0: SETn14 Position     */
#define SCT_OUTPUTSET0_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn14_Pos)                     /*!< SCT OUTPUTSET0: SETn14 Mask         */
#define SCT_OUTPUTSET0_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET0: SETn15 Position     */
#define SCT_OUTPUTSET0_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn15_Pos)                     /*!< SCT OUTPUTSET0: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR0  -----------------------------------------
#define SCT_OUTPUTCLR0_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR0: CLRn0 Position      */
#define SCT_OUTPUTCLR0_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn0_Pos)                      /*!< SCT OUTPUTCLR0: CLRn0 Mask          */
#define SCT_OUTPUTCLR0_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR0: CLRn1 Position      */
#define SCT_OUTPUTCLR0_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn1_Pos)                      /*!< SCT OUTPUTCLR0: CLRn1 Mask          */
#define SCT_OUTPUTCLR0_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR0: CLRn2 Position      */
#define SCT_OUTPUTCLR0_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn2_Pos)                      /*!< SCT OUTPUTCLR0: CLRn2 Mask          */
#define SCT_OUTPUTCLR0_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR0: CLRn3 Position      */
#define SCT_OUTPUTCLR0_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn3_Pos)                      /*!< SCT OUTPUTCLR0: CLRn3 Mask          */
#define SCT_OUTPUTCLR0_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR0: CLRn4 Position      */
#define SCT_OUTPUTCLR0_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn4_Pos)                      /*!< SCT OUTPUTCLR0: CLRn4 Mask          */
#define SCT_OUTPUTCLR0_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR0: CLRn5 Position      */
#define SCT_OUTPUTCLR0_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn5_Pos)                      /*!< SCT OUTPUTCLR0: CLRn5 Mask          */
#define SCT_OUTPUTCLR0_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR0: CLRn6 Position      */
#define SCT_OUTPUTCLR0_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn6_Pos)                      /*!< SCT OUTPUTCLR0: CLRn6 Mask          */
#define SCT_OUTPUTCLR0_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR0: CLRn7 Position      */
#define SCT_OUTPUTCLR0_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn7_Pos)                      /*!< SCT OUTPUTCLR0: CLRn7 Mask          */
#define SCT_OUTPUTCLR0_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR0: CLRn8 Position      */
#define SCT_OUTPUTCLR0_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn8_Pos)                      /*!< SCT OUTPUTCLR0: CLRn8 Mask          */
#define SCT_OUTPUTCLR0_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR0: CLRn9 Position      */
#define SCT_OUTPUTCLR0_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn9_Pos)                      /*!< SCT OUTPUTCLR0: CLRn9 Mask          */
#define SCT_OUTPUTCLR0_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR0: CLRn10 Position     */
#define SCT_OUTPUTCLR0_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn10_Pos)                     /*!< SCT OUTPUTCLR0: CLRn10 Mask         */
#define SCT_OUTPUTCLR0_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR0: CLRn11 Position     */
#define SCT_OUTPUTCLR0_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn11_Pos)                     /*!< SCT OUTPUTCLR0: CLRn11 Mask         */
#define SCT_OUTPUTCLR0_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR0: CLRn12 Position     */
#define SCT_OUTPUTCLR0_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn12_Pos)                     /*!< SCT OUTPUTCLR0: CLRn12 Mask         */
#define SCT_OUTPUTCLR0_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR0: CLRn13 Position     */
#define SCT_OUTPUTCLR0_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn13_Pos)                     /*!< SCT OUTPUTCLR0: CLRn13 Mask         */
#define SCT_OUTPUTCLR0_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR0: CLRn14 Position     */
#define SCT_OUTPUTCLR0_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn14_Pos)                     /*!< SCT OUTPUTCLR0: CLRn14 Mask         */
#define SCT_OUTPUTCLR0_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR0: CLRn15 Position     */
#define SCT_OUTPUTCLR0_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn15_Pos)                     /*!< SCT OUTPUTCLR0: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET1  -----------------------------------------
#define SCT_OUTPUTSET1_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET1: SETn0 Position      */
#define SCT_OUTPUTSET1_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn0_Pos)                      /*!< SCT OUTPUTSET1: SETn0 Mask          */
#define SCT_OUTPUTSET1_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET1: SETn1 Position      */
#define SCT_OUTPUTSET1_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn1_Pos)                      /*!< SCT OUTPUTSET1: SETn1 Mask          */
#define SCT_OUTPUTSET1_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET1: SETn2 Position      */
#define SCT_OUTPUTSET1_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn2_Pos)                      /*!< SCT OUTPUTSET1: SETn2 Mask          */
#define SCT_OUTPUTSET1_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET1: SETn3 Position      */
#define SCT_OUTPUTSET1_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn3_Pos)                      /*!< SCT OUTPUTSET1: SETn3 Mask          */
#define SCT_OUTPUTSET1_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET1: SETn4 Position      */
#define SCT_OUTPUTSET1_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn4_Pos)                      /*!< SCT OUTPUTSET1: SETn4 Mask          */
#define SCT_OUTPUTSET1_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET1: SETn5 Position      */
#define SCT_OUTPUTSET1_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn5_Pos)                      /*!< SCT OUTPUTSET1: SETn5 Mask          */
#define SCT_OUTPUTSET1_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET1: SETn6 Position      */
#define SCT_OUTPUTSET1_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn6_Pos)                      /*!< SCT OUTPUTSET1: SETn6 Mask          */
#define SCT_OUTPUTSET1_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET1: SETn7 Position      */
#define SCT_OUTPUTSET1_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn7_Pos)                      /*!< SCT OUTPUTSET1: SETn7 Mask          */
#define SCT_OUTPUTSET1_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET1: SETn8 Position      */
#define SCT_OUTPUTSET1_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn8_Pos)                      /*!< SCT OUTPUTSET1: SETn8 Mask          */
#define SCT_OUTPUTSET1_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET1: SETn9 Position      */
#define SCT_OUTPUTSET1_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn9_Pos)                      /*!< SCT OUTPUTSET1: SETn9 Mask          */
#define SCT_OUTPUTSET1_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET1: SETn10 Position     */
#define SCT_OUTPUTSET1_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn10_Pos)                     /*!< SCT OUTPUTSET1: SETn10 Mask         */
#define SCT_OUTPUTSET1_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET1: SETn11 Position     */
#define SCT_OUTPUTSET1_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn11_Pos)                     /*!< SCT OUTPUTSET1: SETn11 Mask         */
#define SCT_OUTPUTSET1_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET1: SETn12 Position     */
#define SCT_OUTPUTSET1_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn12_Pos)                     /*!< SCT OUTPUTSET1: SETn12 Mask         */
#define SCT_OUTPUTSET1_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET1: SETn13 Position     */
#define SCT_OUTPUTSET1_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn13_Pos)                     /*!< SCT OUTPUTSET1: SETn13 Mask         */
#define SCT_OUTPUTSET1_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET1: SETn14 Position     */
#define SCT_OUTPUTSET1_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn14_Pos)                     /*!< SCT OUTPUTSET1: SETn14 Mask         */
#define SCT_OUTPUTSET1_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET1: SETn15 Position     */
#define SCT_OUTPUTSET1_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn15_Pos)                     /*!< SCT OUTPUTSET1: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR1  -----------------------------------------
#define SCT_OUTPUTCLR1_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR1: CLRn0 Position      */
#define SCT_OUTPUTCLR1_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn0_Pos)                      /*!< SCT OUTPUTCLR1: CLRn0 Mask          */
#define SCT_OUTPUTCLR1_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR1: CLRn1 Position      */
#define SCT_OUTPUTCLR1_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn1_Pos)                      /*!< SCT OUTPUTCLR1: CLRn1 Mask          */
#define SCT_OUTPUTCLR1_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR1: CLRn2 Position      */
#define SCT_OUTPUTCLR1_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn2_Pos)                      /*!< SCT OUTPUTCLR1: CLRn2 Mask          */
#define SCT_OUTPUTCLR1_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR1: CLRn3 Position      */
#define SCT_OUTPUTCLR1_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn3_Pos)                      /*!< SCT OUTPUTCLR1: CLRn3 Mask          */
#define SCT_OUTPUTCLR1_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR1: CLRn4 Position      */
#define SCT_OUTPUTCLR1_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn4_Pos)                      /*!< SCT OUTPUTCLR1: CLRn4 Mask          */
#define SCT_OUTPUTCLR1_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR1: CLRn5 Position      */
#define SCT_OUTPUTCLR1_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn5_Pos)                      /*!< SCT OUTPUTCLR1: CLRn5 Mask          */
#define SCT_OUTPUTCLR1_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR1: CLRn6 Position      */
#define SCT_OUTPUTCLR1_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn6_Pos)                      /*!< SCT OUTPUTCLR1: CLRn6 Mask          */
#define SCT_OUTPUTCLR1_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR1: CLRn7 Position      */
#define SCT_OUTPUTCLR1_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn7_Pos)                      /*!< SCT OUTPUTCLR1: CLRn7 Mask          */
#define SCT_OUTPUTCLR1_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR1: CLRn8 Position      */
#define SCT_OUTPUTCLR1_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn8_Pos)                      /*!< SCT OUTPUTCLR1: CLRn8 Mask          */
#define SCT_OUTPUTCLR1_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR1: CLRn9 Position      */
#define SCT_OUTPUTCLR1_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn9_Pos)                      /*!< SCT OUTPUTCLR1: CLRn9 Mask          */
#define SCT_OUTPUTCLR1_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR1: CLRn10 Position     */
#define SCT_OUTPUTCLR1_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn10_Pos)                     /*!< SCT OUTPUTCLR1: CLRn10 Mask         */
#define SCT_OUTPUTCLR1_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR1: CLRn11 Position     */
#define SCT_OUTPUTCLR1_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn11_Pos)                     /*!< SCT OUTPUTCLR1: CLRn11 Mask         */
#define SCT_OUTPUTCLR1_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR1: CLRn12 Position     */
#define SCT_OUTPUTCLR1_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn12_Pos)                     /*!< SCT OUTPUTCLR1: CLRn12 Mask         */
#define SCT_OUTPUTCLR1_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR1: CLRn13 Position     */
#define SCT_OUTPUTCLR1_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn13_Pos)                     /*!< SCT OUTPUTCLR1: CLRn13 Mask         */
#define SCT_OUTPUTCLR1_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR1: CLRn14 Position     */
#define SCT_OUTPUTCLR1_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn14_Pos)                     /*!< SCT OUTPUTCLR1: CLRn14 Mask         */
#define SCT_OUTPUTCLR1_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR1: CLRn15 Position     */
#define SCT_OUTPUTCLR1_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn15_Pos)                     /*!< SCT OUTPUTCLR1: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET2  -----------------------------------------
#define SCT_OUTPUTSET2_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET2: SETn0 Position      */
#define SCT_OUTPUTSET2_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn0_Pos)                      /*!< SCT OUTPUTSET2: SETn0 Mask          */
#define SCT_OUTPUTSET2_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET2: SETn1 Position      */
#define SCT_OUTPUTSET2_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn1_Pos)                      /*!< SCT OUTPUTSET2: SETn1 Mask          */
#define SCT_OUTPUTSET2_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET2: SETn2 Position      */
#define SCT_OUTPUTSET2_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn2_Pos)                      /*!< SCT OUTPUTSET2: SETn2 Mask          */
#define SCT_OUTPUTSET2_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET2: SETn3 Position      */
#define SCT_OUTPUTSET2_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn3_Pos)                      /*!< SCT OUTPUTSET2: SETn3 Mask          */
#define SCT_OUTPUTSET2_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET2: SETn4 Position      */
#define SCT_OUTPUTSET2_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn4_Pos)                      /*!< SCT OUTPUTSET2: SETn4 Mask          */
#define SCT_OUTPUTSET2_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET2: SETn5 Position      */
#define SCT_OUTPUTSET2_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn5_Pos)                      /*!< SCT OUTPUTSET2: SETn5 Mask          */
#define SCT_OUTPUTSET2_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET2: SETn6 Position      */
#define SCT_OUTPUTSET2_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn6_Pos)                      /*!< SCT OUTPUTSET2: SETn6 Mask          */
#define SCT_OUTPUTSET2_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET2: SETn7 Position      */
#define SCT_OUTPUTSET2_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn7_Pos)                      /*!< SCT OUTPUTSET2: SETn7 Mask          */
#define SCT_OUTPUTSET2_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET2: SETn8 Position      */
#define SCT_OUTPUTSET2_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn8_Pos)                      /*!< SCT OUTPUTSET2: SETn8 Mask          */
#define SCT_OUTPUTSET2_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET2: SETn9 Position      */
#define SCT_OUTPUTSET2_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn9_Pos)                      /*!< SCT OUTPUTSET2: SETn9 Mask          */
#define SCT_OUTPUTSET2_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET2: SETn10 Position     */
#define SCT_OUTPUTSET2_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn10_Pos)                     /*!< SCT OUTPUTSET2: SETn10 Mask         */
#define SCT_OUTPUTSET2_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET2: SETn11 Position     */
#define SCT_OUTPUTSET2_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn11_Pos)                     /*!< SCT OUTPUTSET2: SETn11 Mask         */
#define SCT_OUTPUTSET2_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET2: SETn12 Position     */
#define SCT_OUTPUTSET2_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn12_Pos)                     /*!< SCT OUTPUTSET2: SETn12 Mask         */
#define SCT_OUTPUTSET2_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET2: SETn13 Position     */
#define SCT_OUTPUTSET2_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn13_Pos)                     /*!< SCT OUTPUTSET2: SETn13 Mask         */
#define SCT_OUTPUTSET2_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET2: SETn14 Position     */
#define SCT_OUTPUTSET2_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn14_Pos)                     /*!< SCT OUTPUTSET2: SETn14 Mask         */
#define SCT_OUTPUTSET2_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET2: SETn15 Position     */
#define SCT_OUTPUTSET2_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn15_Pos)                     /*!< SCT OUTPUTSET2: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR2  -----------------------------------------
#define SCT_OUTPUTCLR2_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR2: CLRn0 Position      */
#define SCT_OUTPUTCLR2_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn0_Pos)                      /*!< SCT OUTPUTCLR2: CLRn0 Mask          */
#define SCT_OUTPUTCLR2_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR2: CLRn1 Position      */
#define SCT_OUTPUTCLR2_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn1_Pos)                      /*!< SCT OUTPUTCLR2: CLRn1 Mask          */
#define SCT_OUTPUTCLR2_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR2: CLRn2 Position      */
#define SCT_OUTPUTCLR2_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn2_Pos)                      /*!< SCT OUTPUTCLR2: CLRn2 Mask          */
#define SCT_OUTPUTCLR2_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR2: CLRn3 Position      */
#define SCT_OUTPUTCLR2_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn3_Pos)                      /*!< SCT OUTPUTCLR2: CLRn3 Mask          */
#define SCT_OUTPUTCLR2_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR2: CLRn4 Position      */
#define SCT_OUTPUTCLR2_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn4_Pos)                      /*!< SCT OUTPUTCLR2: CLRn4 Mask          */
#define SCT_OUTPUTCLR2_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR2: CLRn5 Position      */
#define SCT_OUTPUTCLR2_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn5_Pos)                      /*!< SCT OUTPUTCLR2: CLRn5 Mask          */
#define SCT_OUTPUTCLR2_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR2: CLRn6 Position      */
#define SCT_OUTPUTCLR2_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn6_Pos)                      /*!< SCT OUTPUTCLR2: CLRn6 Mask          */
#define SCT_OUTPUTCLR2_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR2: CLRn7 Position      */
#define SCT_OUTPUTCLR2_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn7_Pos)                      /*!< SCT OUTPUTCLR2: CLRn7 Mask          */
#define SCT_OUTPUTCLR2_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR2: CLRn8 Position      */
#define SCT_OUTPUTCLR2_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn8_Pos)                      /*!< SCT OUTPUTCLR2: CLRn8 Mask          */
#define SCT_OUTPUTCLR2_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR2: CLRn9 Position      */
#define SCT_OUTPUTCLR2_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn9_Pos)                      /*!< SCT OUTPUTCLR2: CLRn9 Mask          */
#define SCT_OUTPUTCLR2_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR2: CLRn10 Position     */
#define SCT_OUTPUTCLR2_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn10_Pos)                     /*!< SCT OUTPUTCLR2: CLRn10 Mask         */
#define SCT_OUTPUTCLR2_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR2: CLRn11 Position     */
#define SCT_OUTPUTCLR2_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn11_Pos)                     /*!< SCT OUTPUTCLR2: CLRn11 Mask         */
#define SCT_OUTPUTCLR2_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR2: CLRn12 Position     */
#define SCT_OUTPUTCLR2_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn12_Pos)                     /*!< SCT OUTPUTCLR2: CLRn12 Mask         */
#define SCT_OUTPUTCLR2_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR2: CLRn13 Position     */
#define SCT_OUTPUTCLR2_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn13_Pos)                     /*!< SCT OUTPUTCLR2: CLRn13 Mask         */
#define SCT_OUTPUTCLR2_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR2: CLRn14 Position     */
#define SCT_OUTPUTCLR2_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn14_Pos)                     /*!< SCT OUTPUTCLR2: CLRn14 Mask         */
#define SCT_OUTPUTCLR2_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR2: CLRn15 Position     */
#define SCT_OUTPUTCLR2_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn15_Pos)                     /*!< SCT OUTPUTCLR2: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET3  -----------------------------------------
#define SCT_OUTPUTSET3_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET3: SETn0 Position      */
#define SCT_OUTPUTSET3_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn0_Pos)                      /*!< SCT OUTPUTSET3: SETn0 Mask          */
#define SCT_OUTPUTSET3_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET3: SETn1 Position      */
#define SCT_OUTPUTSET3_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn1_Pos)                      /*!< SCT OUTPUTSET3: SETn1 Mask          */
#define SCT_OUTPUTSET3_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET3: SETn2 Position      */
#define SCT_OUTPUTSET3_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn2_Pos)                      /*!< SCT OUTPUTSET3: SETn2 Mask          */
#define SCT_OUTPUTSET3_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET3: SETn3 Position      */
#define SCT_OUTPUTSET3_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn3_Pos)                      /*!< SCT OUTPUTSET3: SETn3 Mask          */
#define SCT_OUTPUTSET3_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET3: SETn4 Position      */
#define SCT_OUTPUTSET3_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn4_Pos)                      /*!< SCT OUTPUTSET3: SETn4 Mask          */
#define SCT_OUTPUTSET3_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET3: SETn5 Position      */
#define SCT_OUTPUTSET3_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn5_Pos)                      /*!< SCT OUTPUTSET3: SETn5 Mask          */
#define SCT_OUTPUTSET3_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET3: SETn6 Position      */
#define SCT_OUTPUTSET3_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn6_Pos)                      /*!< SCT OUTPUTSET3: SETn6 Mask          */
#define SCT_OUTPUTSET3_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET3: SETn7 Position      */
#define SCT_OUTPUTSET3_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn7_Pos)                      /*!< SCT OUTPUTSET3: SETn7 Mask          */
#define SCT_OUTPUTSET3_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET3: SETn8 Position      */
#define SCT_OUTPUTSET3_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn8_Pos)                      /*!< SCT OUTPUTSET3: SETn8 Mask          */
#define SCT_OUTPUTSET3_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET3: SETn9 Position      */
#define SCT_OUTPUTSET3_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn9_Pos)                      /*!< SCT OUTPUTSET3: SETn9 Mask          */
#define SCT_OUTPUTSET3_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET3: SETn10 Position     */
#define SCT_OUTPUTSET3_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn10_Pos)                     /*!< SCT OUTPUTSET3: SETn10 Mask         */
#define SCT_OUTPUTSET3_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET3: SETn11 Position     */
#define SCT_OUTPUTSET3_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn11_Pos)                     /*!< SCT OUTPUTSET3: SETn11 Mask         */
#define SCT_OUTPUTSET3_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET3: SETn12 Position     */
#define SCT_OUTPUTSET3_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn12_Pos)                     /*!< SCT OUTPUTSET3: SETn12 Mask         */
#define SCT_OUTPUTSET3_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET3: SETn13 Position     */
#define SCT_OUTPUTSET3_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn13_Pos)                     /*!< SCT OUTPUTSET3: SETn13 Mask         */
#define SCT_OUTPUTSET3_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET3: SETn14 Position     */
#define SCT_OUTPUTSET3_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn14_Pos)                     /*!< SCT OUTPUTSET3: SETn14 Mask         */
#define SCT_OUTPUTSET3_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET3: SETn15 Position     */
#define SCT_OUTPUTSET3_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn15_Pos)                     /*!< SCT OUTPUTSET3: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR3  -----------------------------------------
#define SCT_OUTPUTCLR3_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR3: CLRn0 Position      */
#define SCT_OUTPUTCLR3_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn0_Pos)                      /*!< SCT OUTPUTCLR3: CLRn0 Mask          */
#define SCT_OUTPUTCLR3_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR3: CLRn1 Position      */
#define SCT_OUTPUTCLR3_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn1_Pos)                      /*!< SCT OUTPUTCLR3: CLRn1 Mask          */
#define SCT_OUTPUTCLR3_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR3: CLRn2 Position      */
#define SCT_OUTPUTCLR3_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn2_Pos)                      /*!< SCT OUTPUTCLR3: CLRn2 Mask          */
#define SCT_OUTPUTCLR3_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR3: CLRn3 Position      */
#define SCT_OUTPUTCLR3_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn3_Pos)                      /*!< SCT OUTPUTCLR3: CLRn3 Mask          */
#define SCT_OUTPUTCLR3_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR3: CLRn4 Position      */
#define SCT_OUTPUTCLR3_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn4_Pos)                      /*!< SCT OUTPUTCLR3: CLRn4 Mask          */
#define SCT_OUTPUTCLR3_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR3: CLRn5 Position      */
#define SCT_OUTPUTCLR3_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn5_Pos)                      /*!< SCT OUTPUTCLR3: CLRn5 Mask          */
#define SCT_OUTPUTCLR3_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR3: CLRn6 Position      */
#define SCT_OUTPUTCLR3_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn6_Pos)                      /*!< SCT OUTPUTCLR3: CLRn6 Mask          */
#define SCT_OUTPUTCLR3_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR3: CLRn7 Position      */
#define SCT_OUTPUTCLR3_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn7_Pos)                      /*!< SCT OUTPUTCLR3: CLRn7 Mask          */
#define SCT_OUTPUTCLR3_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR3: CLRn8 Position      */
#define SCT_OUTPUTCLR3_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn8_Pos)                      /*!< SCT OUTPUTCLR3: CLRn8 Mask          */
#define SCT_OUTPUTCLR3_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR3: CLRn9 Position      */
#define SCT_OUTPUTCLR3_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn9_Pos)                      /*!< SCT OUTPUTCLR3: CLRn9 Mask          */
#define SCT_OUTPUTCLR3_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR3: CLRn10 Position     */
#define SCT_OUTPUTCLR3_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn10_Pos)                     /*!< SCT OUTPUTCLR3: CLRn10 Mask         */
#define SCT_OUTPUTCLR3_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR3: CLRn11 Position     */
#define SCT_OUTPUTCLR3_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn11_Pos)                     /*!< SCT OUTPUTCLR3: CLRn11 Mask         */
#define SCT_OUTPUTCLR3_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR3: CLRn12 Position     */
#define SCT_OUTPUTCLR3_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn12_Pos)                     /*!< SCT OUTPUTCLR3: CLRn12 Mask         */
#define SCT_OUTPUTCLR3_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR3: CLRn13 Position     */
#define SCT_OUTPUTCLR3_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn13_Pos)                     /*!< SCT OUTPUTCLR3: CLRn13 Mask         */
#define SCT_OUTPUTCLR3_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR3: CLRn14 Position     */
#define SCT_OUTPUTCLR3_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn14_Pos)                     /*!< SCT OUTPUTCLR3: CLRn14 Mask         */
#define SCT_OUTPUTCLR3_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR3: CLRn15 Position     */
#define SCT_OUTPUTCLR3_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn15_Pos)                     /*!< SCT OUTPUTCLR3: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET4  -----------------------------------------
#define SCT_OUTPUTSET4_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET4: SETn0 Position      */
#define SCT_OUTPUTSET4_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn0_Pos)                      /*!< SCT OUTPUTSET4: SETn0 Mask          */
#define SCT_OUTPUTSET4_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET4: SETn1 Position      */
#define SCT_OUTPUTSET4_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn1_Pos)                      /*!< SCT OUTPUTSET4: SETn1 Mask          */
#define SCT_OUTPUTSET4_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET4: SETn2 Position      */
#define SCT_OUTPUTSET4_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn2_Pos)                      /*!< SCT OUTPUTSET4: SETn2 Mask          */
#define SCT_OUTPUTSET4_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET4: SETn3 Position      */
#define SCT_OUTPUTSET4_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn3_Pos)                      /*!< SCT OUTPUTSET4: SETn3 Mask          */
#define SCT_OUTPUTSET4_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET4: SETn4 Position      */
#define SCT_OUTPUTSET4_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn4_Pos)                      /*!< SCT OUTPUTSET4: SETn4 Mask          */
#define SCT_OUTPUTSET4_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET4: SETn5 Position      */
#define SCT_OUTPUTSET4_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn5_Pos)                      /*!< SCT OUTPUTSET4: SETn5 Mask          */
#define SCT_OUTPUTSET4_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET4: SETn6 Position      */
#define SCT_OUTPUTSET4_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn6_Pos)                      /*!< SCT OUTPUTSET4: SETn6 Mask          */
#define SCT_OUTPUTSET4_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET4: SETn7 Position      */
#define SCT_OUTPUTSET4_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn7_Pos)                      /*!< SCT OUTPUTSET4: SETn7 Mask          */
#define SCT_OUTPUTSET4_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET4: SETn8 Position      */
#define SCT_OUTPUTSET4_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn8_Pos)                      /*!< SCT OUTPUTSET4: SETn8 Mask          */
#define SCT_OUTPUTSET4_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET4: SETn9 Position      */
#define SCT_OUTPUTSET4_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn9_Pos)                      /*!< SCT OUTPUTSET4: SETn9 Mask          */
#define SCT_OUTPUTSET4_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET4: SETn10 Position     */
#define SCT_OUTPUTSET4_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn10_Pos)                     /*!< SCT OUTPUTSET4: SETn10 Mask         */
#define SCT_OUTPUTSET4_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET4: SETn11 Position     */
#define SCT_OUTPUTSET4_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn11_Pos)                     /*!< SCT OUTPUTSET4: SETn11 Mask         */
#define SCT_OUTPUTSET4_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET4: SETn12 Position     */
#define SCT_OUTPUTSET4_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn12_Pos)                     /*!< SCT OUTPUTSET4: SETn12 Mask         */
#define SCT_OUTPUTSET4_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET4: SETn13 Position     */
#define SCT_OUTPUTSET4_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn13_Pos)                     /*!< SCT OUTPUTSET4: SETn13 Mask         */
#define SCT_OUTPUTSET4_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET4: SETn14 Position     */
#define SCT_OUTPUTSET4_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn14_Pos)                     /*!< SCT OUTPUTSET4: SETn14 Mask         */
#define SCT_OUTPUTSET4_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET4: SETn15 Position     */
#define SCT_OUTPUTSET4_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn15_Pos)                     /*!< SCT OUTPUTSET4: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR4  -----------------------------------------
#define SCT_OUTPUTCLR4_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR4: CLRn0 Position      */
#define SCT_OUTPUTCLR4_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn0_Pos)                      /*!< SCT OUTPUTCLR4: CLRn0 Mask          */
#define SCT_OUTPUTCLR4_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR4: CLRn1 Position      */
#define SCT_OUTPUTCLR4_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn1_Pos)                      /*!< SCT OUTPUTCLR4: CLRn1 Mask          */
#define SCT_OUTPUTCLR4_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR4: CLRn2 Position      */
#define SCT_OUTPUTCLR4_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn2_Pos)                      /*!< SCT OUTPUTCLR4: CLRn2 Mask          */
#define SCT_OUTPUTCLR4_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR4: CLRn3 Position      */
#define SCT_OUTPUTCLR4_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn3_Pos)                      /*!< SCT OUTPUTCLR4: CLRn3 Mask          */
#define SCT_OUTPUTCLR4_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR4: CLRn4 Position      */
#define SCT_OUTPUTCLR4_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn4_Pos)                      /*!< SCT OUTPUTCLR4: CLRn4 Mask          */
#define SCT_OUTPUTCLR4_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR4: CLRn5 Position      */
#define SCT_OUTPUTCLR4_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn5_Pos)                      /*!< SCT OUTPUTCLR4: CLRn5 Mask          */
#define SCT_OUTPUTCLR4_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR4: CLRn6 Position      */
#define SCT_OUTPUTCLR4_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn6_Pos)                      /*!< SCT OUTPUTCLR4: CLRn6 Mask          */
#define SCT_OUTPUTCLR4_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR4: CLRn7 Position      */
#define SCT_OUTPUTCLR4_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn7_Pos)                      /*!< SCT OUTPUTCLR4: CLRn7 Mask          */
#define SCT_OUTPUTCLR4_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR4: CLRn8 Position      */
#define SCT_OUTPUTCLR4_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn8_Pos)                      /*!< SCT OUTPUTCLR4: CLRn8 Mask          */
#define SCT_OUTPUTCLR4_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR4: CLRn9 Position      */
#define SCT_OUTPUTCLR4_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn9_Pos)                      /*!< SCT OUTPUTCLR4: CLRn9 Mask          */
#define SCT_OUTPUTCLR4_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR4: CLRn10 Position     */
#define SCT_OUTPUTCLR4_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn10_Pos)                     /*!< SCT OUTPUTCLR4: CLRn10 Mask         */
#define SCT_OUTPUTCLR4_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR4: CLRn11 Position     */
#define SCT_OUTPUTCLR4_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn11_Pos)                     /*!< SCT OUTPUTCLR4: CLRn11 Mask         */
#define SCT_OUTPUTCLR4_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR4: CLRn12 Position     */
#define SCT_OUTPUTCLR4_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn12_Pos)                     /*!< SCT OUTPUTCLR4: CLRn12 Mask         */
#define SCT_OUTPUTCLR4_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR4: CLRn13 Position     */
#define SCT_OUTPUTCLR4_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn13_Pos)                     /*!< SCT OUTPUTCLR4: CLRn13 Mask         */
#define SCT_OUTPUTCLR4_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR4: CLRn14 Position     */
#define SCT_OUTPUTCLR4_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn14_Pos)                     /*!< SCT OUTPUTCLR4: CLRn14 Mask         */
#define SCT_OUTPUTCLR4_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR4: CLRn15 Position     */
#define SCT_OUTPUTCLR4_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn15_Pos)                     /*!< SCT OUTPUTCLR4: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET5  -----------------------------------------
#define SCT_OUTPUTSET5_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET5: SETn0 Position      */
#define SCT_OUTPUTSET5_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn0_Pos)                      /*!< SCT OUTPUTSET5: SETn0 Mask          */
#define SCT_OUTPUTSET5_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET5: SETn1 Position      */
#define SCT_OUTPUTSET5_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn1_Pos)                      /*!< SCT OUTPUTSET5: SETn1 Mask          */
#define SCT_OUTPUTSET5_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET5: SETn2 Position      */
#define SCT_OUTPUTSET5_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn2_Pos)                      /*!< SCT OUTPUTSET5: SETn2 Mask          */
#define SCT_OUTPUTSET5_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET5: SETn3 Position      */
#define SCT_OUTPUTSET5_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn3_Pos)                      /*!< SCT OUTPUTSET5: SETn3 Mask          */
#define SCT_OUTPUTSET5_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET5: SETn4 Position      */
#define SCT_OUTPUTSET5_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn4_Pos)                      /*!< SCT OUTPUTSET5: SETn4 Mask          */
#define SCT_OUTPUTSET5_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET5: SETn5 Position      */
#define SCT_OUTPUTSET5_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn5_Pos)                      /*!< SCT OUTPUTSET5: SETn5 Mask          */
#define SCT_OUTPUTSET5_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET5: SETn6 Position      */
#define SCT_OUTPUTSET5_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn6_Pos)                      /*!< SCT OUTPUTSET5: SETn6 Mask          */
#define SCT_OUTPUTSET5_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET5: SETn7 Position      */
#define SCT_OUTPUTSET5_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn7_Pos)                      /*!< SCT OUTPUTSET5: SETn7 Mask          */
#define SCT_OUTPUTSET5_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET5: SETn8 Position      */
#define SCT_OUTPUTSET5_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn8_Pos)                      /*!< SCT OUTPUTSET5: SETn8 Mask          */
#define SCT_OUTPUTSET5_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET5: SETn9 Position      */
#define SCT_OUTPUTSET5_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn9_Pos)                      /*!< SCT OUTPUTSET5: SETn9 Mask          */
#define SCT_OUTPUTSET5_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET5: SETn10 Position     */
#define SCT_OUTPUTSET5_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn10_Pos)                     /*!< SCT OUTPUTSET5: SETn10 Mask         */
#define SCT_OUTPUTSET5_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET5: SETn11 Position     */
#define SCT_OUTPUTSET5_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn11_Pos)                     /*!< SCT OUTPUTSET5: SETn11 Mask         */
#define SCT_OUTPUTSET5_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET5: SETn12 Position     */
#define SCT_OUTPUTSET5_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn12_Pos)                     /*!< SCT OUTPUTSET5: SETn12 Mask         */
#define SCT_OUTPUTSET5_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET5: SETn13 Position     */
#define SCT_OUTPUTSET5_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn13_Pos)                     /*!< SCT OUTPUTSET5: SETn13 Mask         */
#define SCT_OUTPUTSET5_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET5: SETn14 Position     */
#define SCT_OUTPUTSET5_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn14_Pos)                     /*!< SCT OUTPUTSET5: SETn14 Mask         */
#define SCT_OUTPUTSET5_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET5: SETn15 Position     */
#define SCT_OUTPUTSET5_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn15_Pos)                     /*!< SCT OUTPUTSET5: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR5  -----------------------------------------
#define SCT_OUTPUTCLR5_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR5: CLRn0 Position      */
#define SCT_OUTPUTCLR5_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn0_Pos)                      /*!< SCT OUTPUTCLR5: CLRn0 Mask          */
#define SCT_OUTPUTCLR5_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR5: CLRn1 Position      */
#define SCT_OUTPUTCLR5_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn1_Pos)                      /*!< SCT OUTPUTCLR5: CLRn1 Mask          */
#define SCT_OUTPUTCLR5_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR5: CLRn2 Position      */
#define SCT_OUTPUTCLR5_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn2_Pos)                      /*!< SCT OUTPUTCLR5: CLRn2 Mask          */
#define SCT_OUTPUTCLR5_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR5: CLRn3 Position      */
#define SCT_OUTPUTCLR5_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn3_Pos)                      /*!< SCT OUTPUTCLR5: CLRn3 Mask          */
#define SCT_OUTPUTCLR5_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR5: CLRn4 Position      */
#define SCT_OUTPUTCLR5_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn4_Pos)                      /*!< SCT OUTPUTCLR5: CLRn4 Mask          */
#define SCT_OUTPUTCLR5_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR5: CLRn5 Position      */
#define SCT_OUTPUTCLR5_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn5_Pos)                      /*!< SCT OUTPUTCLR5: CLRn5 Mask          */
#define SCT_OUTPUTCLR5_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR5: CLRn6 Position      */
#define SCT_OUTPUTCLR5_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn6_Pos)                      /*!< SCT OUTPUTCLR5: CLRn6 Mask          */
#define SCT_OUTPUTCLR5_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR5: CLRn7 Position      */
#define SCT_OUTPUTCLR5_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn7_Pos)                      /*!< SCT OUTPUTCLR5: CLRn7 Mask          */
#define SCT_OUTPUTCLR5_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR5: CLRn8 Position      */
#define SCT_OUTPUTCLR5_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn8_Pos)                      /*!< SCT OUTPUTCLR5: CLRn8 Mask          */
#define SCT_OUTPUTCLR5_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR5: CLRn9 Position      */
#define SCT_OUTPUTCLR5_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn9_Pos)                      /*!< SCT OUTPUTCLR5: CLRn9 Mask          */
#define SCT_OUTPUTCLR5_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR5: CLRn10 Position     */
#define SCT_OUTPUTCLR5_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn10_Pos)                     /*!< SCT OUTPUTCLR5: CLRn10 Mask         */
#define SCT_OUTPUTCLR5_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR5: CLRn11 Position     */
#define SCT_OUTPUTCLR5_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn11_Pos)                     /*!< SCT OUTPUTCLR5: CLRn11 Mask         */
#define SCT_OUTPUTCLR5_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR5: CLRn12 Position     */
#define SCT_OUTPUTCLR5_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn12_Pos)                     /*!< SCT OUTPUTCLR5: CLRn12 Mask         */
#define SCT_OUTPUTCLR5_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR5: CLRn13 Position     */
#define SCT_OUTPUTCLR5_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn13_Pos)                     /*!< SCT OUTPUTCLR5: CLRn13 Mask         */
#define SCT_OUTPUTCLR5_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR5: CLRn14 Position     */
#define SCT_OUTPUTCLR5_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn14_Pos)                     /*!< SCT OUTPUTCLR5: CLRn14 Mask         */
#define SCT_OUTPUTCLR5_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR5: CLRn15 Position     */
#define SCT_OUTPUTCLR5_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn15_Pos)                     /*!< SCT OUTPUTCLR5: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET6  -----------------------------------------
#define SCT_OUTPUTSET6_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET6: SETn0 Position      */
#define SCT_OUTPUTSET6_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn0_Pos)                      /*!< SCT OUTPUTSET6: SETn0 Mask          */
#define SCT_OUTPUTSET6_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET6: SETn1 Position      */
#define SCT_OUTPUTSET6_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn1_Pos)                      /*!< SCT OUTPUTSET6: SETn1 Mask          */
#define SCT_OUTPUTSET6_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET6: SETn2 Position      */
#define SCT_OUTPUTSET6_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn2_Pos)                      /*!< SCT OUTPUTSET6: SETn2 Mask          */
#define SCT_OUTPUTSET6_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET6: SETn3 Position      */
#define SCT_OUTPUTSET6_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn3_Pos)                      /*!< SCT OUTPUTSET6: SETn3 Mask          */
#define SCT_OUTPUTSET6_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET6: SETn4 Position      */
#define SCT_OUTPUTSET6_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn4_Pos)                      /*!< SCT OUTPUTSET6: SETn4 Mask          */
#define SCT_OUTPUTSET6_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET6: SETn5 Position      */
#define SCT_OUTPUTSET6_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn5_Pos)                      /*!< SCT OUTPUTSET6: SETn5 Mask          */
#define SCT_OUTPUTSET6_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET6: SETn6 Position      */
#define SCT_OUTPUTSET6_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn6_Pos)                      /*!< SCT OUTPUTSET6: SETn6 Mask          */
#define SCT_OUTPUTSET6_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET6: SETn7 Position      */
#define SCT_OUTPUTSET6_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn7_Pos)                      /*!< SCT OUTPUTSET6: SETn7 Mask          */
#define SCT_OUTPUTSET6_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET6: SETn8 Position      */
#define SCT_OUTPUTSET6_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn8_Pos)                      /*!< SCT OUTPUTSET6: SETn8 Mask          */
#define SCT_OUTPUTSET6_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET6: SETn9 Position      */
#define SCT_OUTPUTSET6_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn9_Pos)                      /*!< SCT OUTPUTSET6: SETn9 Mask          */
#define SCT_OUTPUTSET6_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET6: SETn10 Position     */
#define SCT_OUTPUTSET6_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn10_Pos)                     /*!< SCT OUTPUTSET6: SETn10 Mask         */
#define SCT_OUTPUTSET6_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET6: SETn11 Position     */
#define SCT_OUTPUTSET6_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn11_Pos)                     /*!< SCT OUTPUTSET6: SETn11 Mask         */
#define SCT_OUTPUTSET6_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET6: SETn12 Position     */
#define SCT_OUTPUTSET6_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn12_Pos)                     /*!< SCT OUTPUTSET6: SETn12 Mask         */
#define SCT_OUTPUTSET6_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET6: SETn13 Position     */
#define SCT_OUTPUTSET6_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn13_Pos)                     /*!< SCT OUTPUTSET6: SETn13 Mask         */
#define SCT_OUTPUTSET6_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET6: SETn14 Position     */
#define SCT_OUTPUTSET6_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn14_Pos)                     /*!< SCT OUTPUTSET6: SETn14 Mask         */
#define SCT_OUTPUTSET6_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET6: SETn15 Position     */
#define SCT_OUTPUTSET6_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn15_Pos)                     /*!< SCT OUTPUTSET6: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR6  -----------------------------------------
#define SCT_OUTPUTCLR6_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR6: CLRn0 Position      */
#define SCT_OUTPUTCLR6_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn0_Pos)                      /*!< SCT OUTPUTCLR6: CLRn0 Mask          */
#define SCT_OUTPUTCLR6_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR6: CLRn1 Position      */
#define SCT_OUTPUTCLR6_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn1_Pos)                      /*!< SCT OUTPUTCLR6: CLRn1 Mask          */
#define SCT_OUTPUTCLR6_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR6: CLRn2 Position      */
#define SCT_OUTPUTCLR6_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn2_Pos)                      /*!< SCT OUTPUTCLR6: CLRn2 Mask          */
#define SCT_OUTPUTCLR6_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR6: CLRn3 Position      */
#define SCT_OUTPUTCLR6_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn3_Pos)                      /*!< SCT OUTPUTCLR6: CLRn3 Mask          */
#define SCT_OUTPUTCLR6_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR6: CLRn4 Position      */
#define SCT_OUTPUTCLR6_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn4_Pos)                      /*!< SCT OUTPUTCLR6: CLRn4 Mask          */
#define SCT_OUTPUTCLR6_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR6: CLRn5 Position      */
#define SCT_OUTPUTCLR6_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn5_Pos)                      /*!< SCT OUTPUTCLR6: CLRn5 Mask          */
#define SCT_OUTPUTCLR6_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR6: CLRn6 Position      */
#define SCT_OUTPUTCLR6_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn6_Pos)                      /*!< SCT OUTPUTCLR6: CLRn6 Mask          */
#define SCT_OUTPUTCLR6_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR6: CLRn7 Position      */
#define SCT_OUTPUTCLR6_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn7_Pos)                      /*!< SCT OUTPUTCLR6: CLRn7 Mask          */
#define SCT_OUTPUTCLR6_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR6: CLRn8 Position      */
#define SCT_OUTPUTCLR6_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn8_Pos)                      /*!< SCT OUTPUTCLR6: CLRn8 Mask          */
#define SCT_OUTPUTCLR6_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR6: CLRn9 Position      */
#define SCT_OUTPUTCLR6_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn9_Pos)                      /*!< SCT OUTPUTCLR6: CLRn9 Mask          */
#define SCT_OUTPUTCLR6_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR6: CLRn10 Position     */
#define SCT_OUTPUTCLR6_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn10_Pos)                     /*!< SCT OUTPUTCLR6: CLRn10 Mask         */
#define SCT_OUTPUTCLR6_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR6: CLRn11 Position     */
#define SCT_OUTPUTCLR6_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn11_Pos)                     /*!< SCT OUTPUTCLR6: CLRn11 Mask         */
#define SCT_OUTPUTCLR6_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR6: CLRn12 Position     */
#define SCT_OUTPUTCLR6_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn12_Pos)                     /*!< SCT OUTPUTCLR6: CLRn12 Mask         */
#define SCT_OUTPUTCLR6_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR6: CLRn13 Position     */
#define SCT_OUTPUTCLR6_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn13_Pos)                     /*!< SCT OUTPUTCLR6: CLRn13 Mask         */
#define SCT_OUTPUTCLR6_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR6: CLRn14 Position     */
#define SCT_OUTPUTCLR6_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn14_Pos)                     /*!< SCT OUTPUTCLR6: CLRn14 Mask         */
#define SCT_OUTPUTCLR6_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR6: CLRn15 Position     */
#define SCT_OUTPUTCLR6_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn15_Pos)                     /*!< SCT OUTPUTCLR6: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET7  -----------------------------------------
#define SCT_OUTPUTSET7_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET7: SETn0 Position      */
#define SCT_OUTPUTSET7_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn0_Pos)                      /*!< SCT OUTPUTSET7: SETn0 Mask          */
#define SCT_OUTPUTSET7_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET7: SETn1 Position      */
#define SCT_OUTPUTSET7_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn1_Pos)                      /*!< SCT OUTPUTSET7: SETn1 Mask          */
#define SCT_OUTPUTSET7_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET7: SETn2 Position      */
#define SCT_OUTPUTSET7_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn2_Pos)                      /*!< SCT OUTPUTSET7: SETn2 Mask          */
#define SCT_OUTPUTSET7_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET7: SETn3 Position      */
#define SCT_OUTPUTSET7_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn3_Pos)                      /*!< SCT OUTPUTSET7: SETn3 Mask          */
#define SCT_OUTPUTSET7_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET7: SETn4 Position      */
#define SCT_OUTPUTSET7_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn4_Pos)                      /*!< SCT OUTPUTSET7: SETn4 Mask          */
#define SCT_OUTPUTSET7_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET7: SETn5 Position      */
#define SCT_OUTPUTSET7_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn5_Pos)                      /*!< SCT OUTPUTSET7: SETn5 Mask          */
#define SCT_OUTPUTSET7_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET7: SETn6 Position      */
#define SCT_OUTPUTSET7_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn6_Pos)                      /*!< SCT OUTPUTSET7: SETn6 Mask          */
#define SCT_OUTPUTSET7_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET7: SETn7 Position      */
#define SCT_OUTPUTSET7_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn7_Pos)                      /*!< SCT OUTPUTSET7: SETn7 Mask          */
#define SCT_OUTPUTSET7_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET7: SETn8 Position      */
#define SCT_OUTPUTSET7_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn8_Pos)                      /*!< SCT OUTPUTSET7: SETn8 Mask          */
#define SCT_OUTPUTSET7_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET7: SETn9 Position      */
#define SCT_OUTPUTSET7_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn9_Pos)                      /*!< SCT OUTPUTSET7: SETn9 Mask          */
#define SCT_OUTPUTSET7_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET7: SETn10 Position     */
#define SCT_OUTPUTSET7_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn10_Pos)                     /*!< SCT OUTPUTSET7: SETn10 Mask         */
#define SCT_OUTPUTSET7_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET7: SETn11 Position     */
#define SCT_OUTPUTSET7_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn11_Pos)                     /*!< SCT OUTPUTSET7: SETn11 Mask         */
#define SCT_OUTPUTSET7_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET7: SETn12 Position     */
#define SCT_OUTPUTSET7_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn12_Pos)                     /*!< SCT OUTPUTSET7: SETn12 Mask         */
#define SCT_OUTPUTSET7_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET7: SETn13 Position     */
#define SCT_OUTPUTSET7_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn13_Pos)                     /*!< SCT OUTPUTSET7: SETn13 Mask         */
#define SCT_OUTPUTSET7_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET7: SETn14 Position     */
#define SCT_OUTPUTSET7_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn14_Pos)                     /*!< SCT OUTPUTSET7: SETn14 Mask         */
#define SCT_OUTPUTSET7_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET7: SETn15 Position     */
#define SCT_OUTPUTSET7_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn15_Pos)                     /*!< SCT OUTPUTSET7: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR7  -----------------------------------------
#define SCT_OUTPUTCLR7_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR7: CLRn0 Position      */
#define SCT_OUTPUTCLR7_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn0_Pos)                      /*!< SCT OUTPUTCLR7: CLRn0 Mask          */
#define SCT_OUTPUTCLR7_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR7: CLRn1 Position      */
#define SCT_OUTPUTCLR7_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn1_Pos)                      /*!< SCT OUTPUTCLR7: CLRn1 Mask          */
#define SCT_OUTPUTCLR7_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR7: CLRn2 Position      */
#define SCT_OUTPUTCLR7_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn2_Pos)                      /*!< SCT OUTPUTCLR7: CLRn2 Mask          */
#define SCT_OUTPUTCLR7_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR7: CLRn3 Position      */
#define SCT_OUTPUTCLR7_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn3_Pos)                      /*!< SCT OUTPUTCLR7: CLRn3 Mask          */
#define SCT_OUTPUTCLR7_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR7: CLRn4 Position      */
#define SCT_OUTPUTCLR7_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn4_Pos)                      /*!< SCT OUTPUTCLR7: CLRn4 Mask          */
#define SCT_OUTPUTCLR7_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR7: CLRn5 Position      */
#define SCT_OUTPUTCLR7_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn5_Pos)                      /*!< SCT OUTPUTCLR7: CLRn5 Mask          */
#define SCT_OUTPUTCLR7_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR7: CLRn6 Position      */
#define SCT_OUTPUTCLR7_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn6_Pos)                      /*!< SCT OUTPUTCLR7: CLRn6 Mask          */
#define SCT_OUTPUTCLR7_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR7: CLRn7 Position      */
#define SCT_OUTPUTCLR7_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn7_Pos)                      /*!< SCT OUTPUTCLR7: CLRn7 Mask          */
#define SCT_OUTPUTCLR7_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR7: CLRn8 Position      */
#define SCT_OUTPUTCLR7_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn8_Pos)                      /*!< SCT OUTPUTCLR7: CLRn8 Mask          */
#define SCT_OUTPUTCLR7_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR7: CLRn9 Position      */
#define SCT_OUTPUTCLR7_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn9_Pos)                      /*!< SCT OUTPUTCLR7: CLRn9 Mask          */
#define SCT_OUTPUTCLR7_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR7: CLRn10 Position     */
#define SCT_OUTPUTCLR7_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn10_Pos)                     /*!< SCT OUTPUTCLR7: CLRn10 Mask         */
#define SCT_OUTPUTCLR7_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR7: CLRn11 Position     */
#define SCT_OUTPUTCLR7_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn11_Pos)                     /*!< SCT OUTPUTCLR7: CLRn11 Mask         */
#define SCT_OUTPUTCLR7_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR7: CLRn12 Position     */
#define SCT_OUTPUTCLR7_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn12_Pos)                     /*!< SCT OUTPUTCLR7: CLRn12 Mask         */
#define SCT_OUTPUTCLR7_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR7: CLRn13 Position     */
#define SCT_OUTPUTCLR7_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn13_Pos)                     /*!< SCT OUTPUTCLR7: CLRn13 Mask         */
#define SCT_OUTPUTCLR7_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR7: CLRn14 Position     */
#define SCT_OUTPUTCLR7_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn14_Pos)                     /*!< SCT OUTPUTCLR7: CLRn14 Mask         */
#define SCT_OUTPUTCLR7_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR7: CLRn15 Position     */
#define SCT_OUTPUTCLR7_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn15_Pos)                     /*!< SCT OUTPUTCLR7: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET8  -----------------------------------------
#define SCT_OUTPUTSET8_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET8: SETn0 Position      */
#define SCT_OUTPUTSET8_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn0_Pos)                      /*!< SCT OUTPUTSET8: SETn0 Mask          */
#define SCT_OUTPUTSET8_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET8: SETn1 Position      */
#define SCT_OUTPUTSET8_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn1_Pos)                      /*!< SCT OUTPUTSET8: SETn1 Mask          */
#define SCT_OUTPUTSET8_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET8: SETn2 Position      */
#define SCT_OUTPUTSET8_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn2_Pos)                      /*!< SCT OUTPUTSET8: SETn2 Mask          */
#define SCT_OUTPUTSET8_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET8: SETn3 Position      */
#define SCT_OUTPUTSET8_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn3_Pos)                      /*!< SCT OUTPUTSET8: SETn3 Mask          */
#define SCT_OUTPUTSET8_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET8: SETn4 Position      */
#define SCT_OUTPUTSET8_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn4_Pos)                      /*!< SCT OUTPUTSET8: SETn4 Mask          */
#define SCT_OUTPUTSET8_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET8: SETn5 Position      */
#define SCT_OUTPUTSET8_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn5_Pos)                      /*!< SCT OUTPUTSET8: SETn5 Mask          */
#define SCT_OUTPUTSET8_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET8: SETn6 Position      */
#define SCT_OUTPUTSET8_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn6_Pos)                      /*!< SCT OUTPUTSET8: SETn6 Mask          */
#define SCT_OUTPUTSET8_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET8: SETn7 Position      */
#define SCT_OUTPUTSET8_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn7_Pos)                      /*!< SCT OUTPUTSET8: SETn7 Mask          */
#define SCT_OUTPUTSET8_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET8: SETn8 Position      */
#define SCT_OUTPUTSET8_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn8_Pos)                      /*!< SCT OUTPUTSET8: SETn8 Mask          */
#define SCT_OUTPUTSET8_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET8: SETn9 Position      */
#define SCT_OUTPUTSET8_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn9_Pos)                      /*!< SCT OUTPUTSET8: SETn9 Mask          */
#define SCT_OUTPUTSET8_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET8: SETn10 Position     */
#define SCT_OUTPUTSET8_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn10_Pos)                     /*!< SCT OUTPUTSET8: SETn10 Mask         */
#define SCT_OUTPUTSET8_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET8: SETn11 Position     */
#define SCT_OUTPUTSET8_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn11_Pos)                     /*!< SCT OUTPUTSET8: SETn11 Mask         */
#define SCT_OUTPUTSET8_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET8: SETn12 Position     */
#define SCT_OUTPUTSET8_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn12_Pos)                     /*!< SCT OUTPUTSET8: SETn12 Mask         */
#define SCT_OUTPUTSET8_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET8: SETn13 Position     */
#define SCT_OUTPUTSET8_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn13_Pos)                     /*!< SCT OUTPUTSET8: SETn13 Mask         */
#define SCT_OUTPUTSET8_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET8: SETn14 Position     */
#define SCT_OUTPUTSET8_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn14_Pos)                     /*!< SCT OUTPUTSET8: SETn14 Mask         */
#define SCT_OUTPUTSET8_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET8: SETn15 Position     */
#define SCT_OUTPUTSET8_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn15_Pos)                     /*!< SCT OUTPUTSET8: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR8  -----------------------------------------
#define SCT_OUTPUTCLR8_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR8: CLRn0 Position      */
#define SCT_OUTPUTCLR8_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn0_Pos)                      /*!< SCT OUTPUTCLR8: CLRn0 Mask          */
#define SCT_OUTPUTCLR8_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR8: CLRn1 Position      */
#define SCT_OUTPUTCLR8_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn1_Pos)                      /*!< SCT OUTPUTCLR8: CLRn1 Mask          */
#define SCT_OUTPUTCLR8_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR8: CLRn2 Position      */
#define SCT_OUTPUTCLR8_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn2_Pos)                      /*!< SCT OUTPUTCLR8: CLRn2 Mask          */
#define SCT_OUTPUTCLR8_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR8: CLRn3 Position      */
#define SCT_OUTPUTCLR8_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn3_Pos)                      /*!< SCT OUTPUTCLR8: CLRn3 Mask          */
#define SCT_OUTPUTCLR8_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR8: CLRn4 Position      */
#define SCT_OUTPUTCLR8_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn4_Pos)                      /*!< SCT OUTPUTCLR8: CLRn4 Mask          */
#define SCT_OUTPUTCLR8_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR8: CLRn5 Position      */
#define SCT_OUTPUTCLR8_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn5_Pos)                      /*!< SCT OUTPUTCLR8: CLRn5 Mask          */
#define SCT_OUTPUTCLR8_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR8: CLRn6 Position      */
#define SCT_OUTPUTCLR8_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn6_Pos)                      /*!< SCT OUTPUTCLR8: CLRn6 Mask          */
#define SCT_OUTPUTCLR8_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR8: CLRn7 Position      */
#define SCT_OUTPUTCLR8_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn7_Pos)                      /*!< SCT OUTPUTCLR8: CLRn7 Mask          */
#define SCT_OUTPUTCLR8_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR8: CLRn8 Position      */
#define SCT_OUTPUTCLR8_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn8_Pos)                      /*!< SCT OUTPUTCLR8: CLRn8 Mask          */
#define SCT_OUTPUTCLR8_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR8: CLRn9 Position      */
#define SCT_OUTPUTCLR8_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn9_Pos)                      /*!< SCT OUTPUTCLR8: CLRn9 Mask          */
#define SCT_OUTPUTCLR8_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR8: CLRn10 Position     */
#define SCT_OUTPUTCLR8_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn10_Pos)                     /*!< SCT OUTPUTCLR8: CLRn10 Mask         */
#define SCT_OUTPUTCLR8_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR8: CLRn11 Position     */
#define SCT_OUTPUTCLR8_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn11_Pos)                     /*!< SCT OUTPUTCLR8: CLRn11 Mask         */
#define SCT_OUTPUTCLR8_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR8: CLRn12 Position     */
#define SCT_OUTPUTCLR8_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn12_Pos)                     /*!< SCT OUTPUTCLR8: CLRn12 Mask         */
#define SCT_OUTPUTCLR8_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR8: CLRn13 Position     */
#define SCT_OUTPUTCLR8_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn13_Pos)                     /*!< SCT OUTPUTCLR8: CLRn13 Mask         */
#define SCT_OUTPUTCLR8_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR8: CLRn14 Position     */
#define SCT_OUTPUTCLR8_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn14_Pos)                     /*!< SCT OUTPUTCLR8: CLRn14 Mask         */
#define SCT_OUTPUTCLR8_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR8: CLRn15 Position     */
#define SCT_OUTPUTCLR8_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn15_Pos)                     /*!< SCT OUTPUTCLR8: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET9  -----------------------------------------
#define SCT_OUTPUTSET9_SETn0_Pos                              0                                                         /*!< SCT OUTPUTSET9: SETn0 Position      */
#define SCT_OUTPUTSET9_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn0_Pos)                      /*!< SCT OUTPUTSET9: SETn0 Mask          */
#define SCT_OUTPUTSET9_SETn1_Pos                              1                                                         /*!< SCT OUTPUTSET9: SETn1 Position      */
#define SCT_OUTPUTSET9_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn1_Pos)                      /*!< SCT OUTPUTSET9: SETn1 Mask          */
#define SCT_OUTPUTSET9_SETn2_Pos                              2                                                         /*!< SCT OUTPUTSET9: SETn2 Position      */
#define SCT_OUTPUTSET9_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn2_Pos)                      /*!< SCT OUTPUTSET9: SETn2 Mask          */
#define SCT_OUTPUTSET9_SETn3_Pos                              3                                                         /*!< SCT OUTPUTSET9: SETn3 Position      */
#define SCT_OUTPUTSET9_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn3_Pos)                      /*!< SCT OUTPUTSET9: SETn3 Mask          */
#define SCT_OUTPUTSET9_SETn4_Pos                              4                                                         /*!< SCT OUTPUTSET9: SETn4 Position      */
#define SCT_OUTPUTSET9_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn4_Pos)                      /*!< SCT OUTPUTSET9: SETn4 Mask          */
#define SCT_OUTPUTSET9_SETn5_Pos                              5                                                         /*!< SCT OUTPUTSET9: SETn5 Position      */
#define SCT_OUTPUTSET9_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn5_Pos)                      /*!< SCT OUTPUTSET9: SETn5 Mask          */
#define SCT_OUTPUTSET9_SETn6_Pos                              6                                                         /*!< SCT OUTPUTSET9: SETn6 Position      */
#define SCT_OUTPUTSET9_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn6_Pos)                      /*!< SCT OUTPUTSET9: SETn6 Mask          */
#define SCT_OUTPUTSET9_SETn7_Pos                              7                                                         /*!< SCT OUTPUTSET9: SETn7 Position      */
#define SCT_OUTPUTSET9_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn7_Pos)                      /*!< SCT OUTPUTSET9: SETn7 Mask          */
#define SCT_OUTPUTSET9_SETn8_Pos                              8                                                         /*!< SCT OUTPUTSET9: SETn8 Position      */
#define SCT_OUTPUTSET9_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn8_Pos)                      /*!< SCT OUTPUTSET9: SETn8 Mask          */
#define SCT_OUTPUTSET9_SETn9_Pos                              9                                                         /*!< SCT OUTPUTSET9: SETn9 Position      */
#define SCT_OUTPUTSET9_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn9_Pos)                      /*!< SCT OUTPUTSET9: SETn9 Mask          */
#define SCT_OUTPUTSET9_SETn10_Pos                             10                                                        /*!< SCT OUTPUTSET9: SETn10 Position     */
#define SCT_OUTPUTSET9_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn10_Pos)                     /*!< SCT OUTPUTSET9: SETn10 Mask         */
#define SCT_OUTPUTSET9_SETn11_Pos                             11                                                        /*!< SCT OUTPUTSET9: SETn11 Position     */
#define SCT_OUTPUTSET9_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn11_Pos)                     /*!< SCT OUTPUTSET9: SETn11 Mask         */
#define SCT_OUTPUTSET9_SETn12_Pos                             12                                                        /*!< SCT OUTPUTSET9: SETn12 Position     */
#define SCT_OUTPUTSET9_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn12_Pos)                     /*!< SCT OUTPUTSET9: SETn12 Mask         */
#define SCT_OUTPUTSET9_SETn13_Pos                             13                                                        /*!< SCT OUTPUTSET9: SETn13 Position     */
#define SCT_OUTPUTSET9_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn13_Pos)                     /*!< SCT OUTPUTSET9: SETn13 Mask         */
#define SCT_OUTPUTSET9_SETn14_Pos                             14                                                        /*!< SCT OUTPUTSET9: SETn14 Position     */
#define SCT_OUTPUTSET9_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn14_Pos)                     /*!< SCT OUTPUTSET9: SETn14 Mask         */
#define SCT_OUTPUTSET9_SETn15_Pos                             15                                                        /*!< SCT OUTPUTSET9: SETn15 Position     */
#define SCT_OUTPUTSET9_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn15_Pos)                     /*!< SCT OUTPUTSET9: SETn15 Mask         */

// -------------------------------------  SCT_OUTPUTCLR9  -----------------------------------------
#define SCT_OUTPUTCLR9_CLRn0_Pos                              0                                                         /*!< SCT OUTPUTCLR9: CLRn0 Position      */
#define SCT_OUTPUTCLR9_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn0_Pos)                      /*!< SCT OUTPUTCLR9: CLRn0 Mask          */
#define SCT_OUTPUTCLR9_CLRn1_Pos                              1                                                         /*!< SCT OUTPUTCLR9: CLRn1 Position      */
#define SCT_OUTPUTCLR9_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn1_Pos)                      /*!< SCT OUTPUTCLR9: CLRn1 Mask          */
#define SCT_OUTPUTCLR9_CLRn2_Pos                              2                                                         /*!< SCT OUTPUTCLR9: CLRn2 Position      */
#define SCT_OUTPUTCLR9_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn2_Pos)                      /*!< SCT OUTPUTCLR9: CLRn2 Mask          */
#define SCT_OUTPUTCLR9_CLRn3_Pos                              3                                                         /*!< SCT OUTPUTCLR9: CLRn3 Position      */
#define SCT_OUTPUTCLR9_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn3_Pos)                      /*!< SCT OUTPUTCLR9: CLRn3 Mask          */
#define SCT_OUTPUTCLR9_CLRn4_Pos                              4                                                         /*!< SCT OUTPUTCLR9: CLRn4 Position      */
#define SCT_OUTPUTCLR9_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn4_Pos)                      /*!< SCT OUTPUTCLR9: CLRn4 Mask          */
#define SCT_OUTPUTCLR9_CLRn5_Pos                              5                                                         /*!< SCT OUTPUTCLR9: CLRn5 Position      */
#define SCT_OUTPUTCLR9_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn5_Pos)                      /*!< SCT OUTPUTCLR9: CLRn5 Mask          */
#define SCT_OUTPUTCLR9_CLRn6_Pos                              6                                                         /*!< SCT OUTPUTCLR9: CLRn6 Position      */
#define SCT_OUTPUTCLR9_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn6_Pos)                      /*!< SCT OUTPUTCLR9: CLRn6 Mask          */
#define SCT_OUTPUTCLR9_CLRn7_Pos                              7                                                         /*!< SCT OUTPUTCLR9: CLRn7 Position      */
#define SCT_OUTPUTCLR9_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn7_Pos)                      /*!< SCT OUTPUTCLR9: CLRn7 Mask          */
#define SCT_OUTPUTCLR9_CLRn8_Pos                              8                                                         /*!< SCT OUTPUTCLR9: CLRn8 Position      */
#define SCT_OUTPUTCLR9_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn8_Pos)                      /*!< SCT OUTPUTCLR9: CLRn8 Mask          */
#define SCT_OUTPUTCLR9_CLRn9_Pos                              9                                                         /*!< SCT OUTPUTCLR9: CLRn9 Position      */
#define SCT_OUTPUTCLR9_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn9_Pos)                      /*!< SCT OUTPUTCLR9: CLRn9 Mask          */
#define SCT_OUTPUTCLR9_CLRn10_Pos                             10                                                        /*!< SCT OUTPUTCLR9: CLRn10 Position     */
#define SCT_OUTPUTCLR9_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn10_Pos)                     /*!< SCT OUTPUTCLR9: CLRn10 Mask         */
#define SCT_OUTPUTCLR9_CLRn11_Pos                             11                                                        /*!< SCT OUTPUTCLR9: CLRn11 Position     */
#define SCT_OUTPUTCLR9_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn11_Pos)                     /*!< SCT OUTPUTCLR9: CLRn11 Mask         */
#define SCT_OUTPUTCLR9_CLRn12_Pos                             12                                                        /*!< SCT OUTPUTCLR9: CLRn12 Position     */
#define SCT_OUTPUTCLR9_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn12_Pos)                     /*!< SCT OUTPUTCLR9: CLRn12 Mask         */
#define SCT_OUTPUTCLR9_CLRn13_Pos                             13                                                        /*!< SCT OUTPUTCLR9: CLRn13 Position     */
#define SCT_OUTPUTCLR9_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn13_Pos)                     /*!< SCT OUTPUTCLR9: CLRn13 Mask         */
#define SCT_OUTPUTCLR9_CLRn14_Pos                             14                                                        /*!< SCT OUTPUTCLR9: CLRn14 Position     */
#define SCT_OUTPUTCLR9_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn14_Pos)                     /*!< SCT OUTPUTCLR9: CLRn14 Mask         */
#define SCT_OUTPUTCLR9_CLRn15_Pos                             15                                                        /*!< SCT OUTPUTCLR9: CLRn15 Position     */
#define SCT_OUTPUTCLR9_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn15_Pos)                     /*!< SCT OUTPUTCLR9: CLRn15 Mask         */

// -------------------------------------  SCT_OUTPUTSET10  ----------------------------------------
#define SCT_OUTPUTSET10_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET10: SETn0 Position     */
#define SCT_OUTPUTSET10_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn0_Pos)                     /*!< SCT OUTPUTSET10: SETn0 Mask         */
#define SCT_OUTPUTSET10_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET10: SETn1 Position     */
#define SCT_OUTPUTSET10_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn1_Pos)                     /*!< SCT OUTPUTSET10: SETn1 Mask         */
#define SCT_OUTPUTSET10_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET10: SETn2 Position     */
#define SCT_OUTPUTSET10_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn2_Pos)                     /*!< SCT OUTPUTSET10: SETn2 Mask         */
#define SCT_OUTPUTSET10_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET10: SETn3 Position     */
#define SCT_OUTPUTSET10_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn3_Pos)                     /*!< SCT OUTPUTSET10: SETn3 Mask         */
#define SCT_OUTPUTSET10_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET10: SETn4 Position     */
#define SCT_OUTPUTSET10_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn4_Pos)                     /*!< SCT OUTPUTSET10: SETn4 Mask         */
#define SCT_OUTPUTSET10_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET10: SETn5 Position     */
#define SCT_OUTPUTSET10_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn5_Pos)                     /*!< SCT OUTPUTSET10: SETn5 Mask         */
#define SCT_OUTPUTSET10_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET10: SETn6 Position     */
#define SCT_OUTPUTSET10_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn6_Pos)                     /*!< SCT OUTPUTSET10: SETn6 Mask         */
#define SCT_OUTPUTSET10_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET10: SETn7 Position     */
#define SCT_OUTPUTSET10_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn7_Pos)                     /*!< SCT OUTPUTSET10: SETn7 Mask         */
#define SCT_OUTPUTSET10_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET10: SETn8 Position     */
#define SCT_OUTPUTSET10_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn8_Pos)                     /*!< SCT OUTPUTSET10: SETn8 Mask         */
#define SCT_OUTPUTSET10_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET10: SETn9 Position     */
#define SCT_OUTPUTSET10_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn9_Pos)                     /*!< SCT OUTPUTSET10: SETn9 Mask         */
#define SCT_OUTPUTSET10_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET10: SETn10 Position    */
#define SCT_OUTPUTSET10_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn10_Pos)                    /*!< SCT OUTPUTSET10: SETn10 Mask        */
#define SCT_OUTPUTSET10_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET10: SETn11 Position    */
#define SCT_OUTPUTSET10_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn11_Pos)                    /*!< SCT OUTPUTSET10: SETn11 Mask        */
#define SCT_OUTPUTSET10_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET10: SETn12 Position    */
#define SCT_OUTPUTSET10_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn12_Pos)                    /*!< SCT OUTPUTSET10: SETn12 Mask        */
#define SCT_OUTPUTSET10_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET10: SETn13 Position    */
#define SCT_OUTPUTSET10_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn13_Pos)                    /*!< SCT OUTPUTSET10: SETn13 Mask        */
#define SCT_OUTPUTSET10_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET10: SETn14 Position    */
#define SCT_OUTPUTSET10_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn14_Pos)                    /*!< SCT OUTPUTSET10: SETn14 Mask        */
#define SCT_OUTPUTSET10_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET10: SETn15 Position    */
#define SCT_OUTPUTSET10_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn15_Pos)                    /*!< SCT OUTPUTSET10: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR10  ----------------------------------------
#define SCT_OUTPUTCLR10_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR10: CLRn0 Position     */
#define SCT_OUTPUTCLR10_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn0_Pos)                     /*!< SCT OUTPUTCLR10: CLRn0 Mask         */
#define SCT_OUTPUTCLR10_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR10: CLRn1 Position     */
#define SCT_OUTPUTCLR10_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn1_Pos)                     /*!< SCT OUTPUTCLR10: CLRn1 Mask         */
#define SCT_OUTPUTCLR10_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR10: CLRn2 Position     */
#define SCT_OUTPUTCLR10_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn2_Pos)                     /*!< SCT OUTPUTCLR10: CLRn2 Mask         */
#define SCT_OUTPUTCLR10_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR10: CLRn3 Position     */
#define SCT_OUTPUTCLR10_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn3_Pos)                     /*!< SCT OUTPUTCLR10: CLRn3 Mask         */
#define SCT_OUTPUTCLR10_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR10: CLRn4 Position     */
#define SCT_OUTPUTCLR10_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn4_Pos)                     /*!< SCT OUTPUTCLR10: CLRn4 Mask         */
#define SCT_OUTPUTCLR10_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR10: CLRn5 Position     */
#define SCT_OUTPUTCLR10_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn5_Pos)                     /*!< SCT OUTPUTCLR10: CLRn5 Mask         */
#define SCT_OUTPUTCLR10_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR10: CLRn6 Position     */
#define SCT_OUTPUTCLR10_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn6_Pos)                     /*!< SCT OUTPUTCLR10: CLRn6 Mask         */
#define SCT_OUTPUTCLR10_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR10: CLRn7 Position     */
#define SCT_OUTPUTCLR10_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn7_Pos)                     /*!< SCT OUTPUTCLR10: CLRn7 Mask         */
#define SCT_OUTPUTCLR10_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR10: CLRn8 Position     */
#define SCT_OUTPUTCLR10_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn8_Pos)                     /*!< SCT OUTPUTCLR10: CLRn8 Mask         */
#define SCT_OUTPUTCLR10_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR10: CLRn9 Position     */
#define SCT_OUTPUTCLR10_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn9_Pos)                     /*!< SCT OUTPUTCLR10: CLRn9 Mask         */
#define SCT_OUTPUTCLR10_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR10: CLRn10 Position    */
#define SCT_OUTPUTCLR10_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn10_Pos)                    /*!< SCT OUTPUTCLR10: CLRn10 Mask        */
#define SCT_OUTPUTCLR10_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR10: CLRn11 Position    */
#define SCT_OUTPUTCLR10_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn11_Pos)                    /*!< SCT OUTPUTCLR10: CLRn11 Mask        */
#define SCT_OUTPUTCLR10_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR10: CLRn12 Position    */
#define SCT_OUTPUTCLR10_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn12_Pos)                    /*!< SCT OUTPUTCLR10: CLRn12 Mask        */
#define SCT_OUTPUTCLR10_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR10: CLRn13 Position    */
#define SCT_OUTPUTCLR10_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn13_Pos)                    /*!< SCT OUTPUTCLR10: CLRn13 Mask        */
#define SCT_OUTPUTCLR10_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR10: CLRn14 Position    */
#define SCT_OUTPUTCLR10_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn14_Pos)                    /*!< SCT OUTPUTCLR10: CLRn14 Mask        */
#define SCT_OUTPUTCLR10_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR10: CLRn15 Position    */
#define SCT_OUTPUTCLR10_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn15_Pos)                    /*!< SCT OUTPUTCLR10: CLRn15 Mask        */

// -------------------------------------  SCT_OUTPUTSET11  ----------------------------------------
#define SCT_OUTPUTSET11_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET11: SETn0 Position     */
#define SCT_OUTPUTSET11_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn0_Pos)                     /*!< SCT OUTPUTSET11: SETn0 Mask         */
#define SCT_OUTPUTSET11_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET11: SETn1 Position     */
#define SCT_OUTPUTSET11_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn1_Pos)                     /*!< SCT OUTPUTSET11: SETn1 Mask         */
#define SCT_OUTPUTSET11_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET11: SETn2 Position     */
#define SCT_OUTPUTSET11_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn2_Pos)                     /*!< SCT OUTPUTSET11: SETn2 Mask         */
#define SCT_OUTPUTSET11_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET11: SETn3 Position     */
#define SCT_OUTPUTSET11_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn3_Pos)                     /*!< SCT OUTPUTSET11: SETn3 Mask         */
#define SCT_OUTPUTSET11_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET11: SETn4 Position     */
#define SCT_OUTPUTSET11_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn4_Pos)                     /*!< SCT OUTPUTSET11: SETn4 Mask         */
#define SCT_OUTPUTSET11_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET11: SETn5 Position     */
#define SCT_OUTPUTSET11_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn5_Pos)                     /*!< SCT OUTPUTSET11: SETn5 Mask         */
#define SCT_OUTPUTSET11_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET11: SETn6 Position     */
#define SCT_OUTPUTSET11_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn6_Pos)                     /*!< SCT OUTPUTSET11: SETn6 Mask         */
#define SCT_OUTPUTSET11_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET11: SETn7 Position     */
#define SCT_OUTPUTSET11_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn7_Pos)                     /*!< SCT OUTPUTSET11: SETn7 Mask         */
#define SCT_OUTPUTSET11_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET11: SETn8 Position     */
#define SCT_OUTPUTSET11_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn8_Pos)                     /*!< SCT OUTPUTSET11: SETn8 Mask         */
#define SCT_OUTPUTSET11_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET11: SETn9 Position     */
#define SCT_OUTPUTSET11_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn9_Pos)                     /*!< SCT OUTPUTSET11: SETn9 Mask         */
#define SCT_OUTPUTSET11_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET11: SETn10 Position    */
#define SCT_OUTPUTSET11_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn10_Pos)                    /*!< SCT OUTPUTSET11: SETn10 Mask        */
#define SCT_OUTPUTSET11_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET11: SETn11 Position    */
#define SCT_OUTPUTSET11_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn11_Pos)                    /*!< SCT OUTPUTSET11: SETn11 Mask        */
#define SCT_OUTPUTSET11_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET11: SETn12 Position    */
#define SCT_OUTPUTSET11_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn12_Pos)                    /*!< SCT OUTPUTSET11: SETn12 Mask        */
#define SCT_OUTPUTSET11_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET11: SETn13 Position    */
#define SCT_OUTPUTSET11_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn13_Pos)                    /*!< SCT OUTPUTSET11: SETn13 Mask        */
#define SCT_OUTPUTSET11_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET11: SETn14 Position    */
#define SCT_OUTPUTSET11_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn14_Pos)                    /*!< SCT OUTPUTSET11: SETn14 Mask        */
#define SCT_OUTPUTSET11_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET11: SETn15 Position    */
#define SCT_OUTPUTSET11_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn15_Pos)                    /*!< SCT OUTPUTSET11: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR11  ----------------------------------------
#define SCT_OUTPUTCLR11_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR11: CLRn0 Position     */
#define SCT_OUTPUTCLR11_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn0_Pos)                     /*!< SCT OUTPUTCLR11: CLRn0 Mask         */
#define SCT_OUTPUTCLR11_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR11: CLRn1 Position     */
#define SCT_OUTPUTCLR11_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn1_Pos)                     /*!< SCT OUTPUTCLR11: CLRn1 Mask         */
#define SCT_OUTPUTCLR11_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR11: CLRn2 Position     */
#define SCT_OUTPUTCLR11_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn2_Pos)                     /*!< SCT OUTPUTCLR11: CLRn2 Mask         */
#define SCT_OUTPUTCLR11_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR11: CLRn3 Position     */
#define SCT_OUTPUTCLR11_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn3_Pos)                     /*!< SCT OUTPUTCLR11: CLRn3 Mask         */
#define SCT_OUTPUTCLR11_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR11: CLRn4 Position     */
#define SCT_OUTPUTCLR11_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn4_Pos)                     /*!< SCT OUTPUTCLR11: CLRn4 Mask         */
#define SCT_OUTPUTCLR11_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR11: CLRn5 Position     */
#define SCT_OUTPUTCLR11_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn5_Pos)                     /*!< SCT OUTPUTCLR11: CLRn5 Mask         */
#define SCT_OUTPUTCLR11_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR11: CLRn6 Position     */
#define SCT_OUTPUTCLR11_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn6_Pos)                     /*!< SCT OUTPUTCLR11: CLRn6 Mask         */
#define SCT_OUTPUTCLR11_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR11: CLRn7 Position     */
#define SCT_OUTPUTCLR11_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn7_Pos)                     /*!< SCT OUTPUTCLR11: CLRn7 Mask         */
#define SCT_OUTPUTCLR11_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR11: CLRn8 Position     */
#define SCT_OUTPUTCLR11_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn8_Pos)                     /*!< SCT OUTPUTCLR11: CLRn8 Mask         */
#define SCT_OUTPUTCLR11_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR11: CLRn9 Position     */
#define SCT_OUTPUTCLR11_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn9_Pos)                     /*!< SCT OUTPUTCLR11: CLRn9 Mask         */
#define SCT_OUTPUTCLR11_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR11: CLRn10 Position    */
#define SCT_OUTPUTCLR11_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn10_Pos)                    /*!< SCT OUTPUTCLR11: CLRn10 Mask        */
#define SCT_OUTPUTCLR11_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR11: CLRn11 Position    */
#define SCT_OUTPUTCLR11_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn11_Pos)                    /*!< SCT OUTPUTCLR11: CLRn11 Mask        */
#define SCT_OUTPUTCLR11_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR11: CLRn12 Position    */
#define SCT_OUTPUTCLR11_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn12_Pos)                    /*!< SCT OUTPUTCLR11: CLRn12 Mask        */
#define SCT_OUTPUTCLR11_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR11: CLRn13 Position    */
#define SCT_OUTPUTCLR11_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn13_Pos)                    /*!< SCT OUTPUTCLR11: CLRn13 Mask        */
#define SCT_OUTPUTCLR11_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR11: CLRn14 Position    */
#define SCT_OUTPUTCLR11_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn14_Pos)                    /*!< SCT OUTPUTCLR11: CLRn14 Mask        */
#define SCT_OUTPUTCLR11_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR11: CLRn15 Position    */
#define SCT_OUTPUTCLR11_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn15_Pos)                    /*!< SCT OUTPUTCLR11: CLRn15 Mask        */

// -------------------------------------  SCT_OUTPUTSET12  ----------------------------------------
#define SCT_OUTPUTSET12_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET12: SETn0 Position     */
#define SCT_OUTPUTSET12_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn0_Pos)                     /*!< SCT OUTPUTSET12: SETn0 Mask         */
#define SCT_OUTPUTSET12_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET12: SETn1 Position     */
#define SCT_OUTPUTSET12_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn1_Pos)                     /*!< SCT OUTPUTSET12: SETn1 Mask         */
#define SCT_OUTPUTSET12_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET12: SETn2 Position     */
#define SCT_OUTPUTSET12_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn2_Pos)                     /*!< SCT OUTPUTSET12: SETn2 Mask         */
#define SCT_OUTPUTSET12_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET12: SETn3 Position     */
#define SCT_OUTPUTSET12_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn3_Pos)                     /*!< SCT OUTPUTSET12: SETn3 Mask         */
#define SCT_OUTPUTSET12_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET12: SETn4 Position     */
#define SCT_OUTPUTSET12_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn4_Pos)                     /*!< SCT OUTPUTSET12: SETn4 Mask         */
#define SCT_OUTPUTSET12_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET12: SETn5 Position     */
#define SCT_OUTPUTSET12_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn5_Pos)                     /*!< SCT OUTPUTSET12: SETn5 Mask         */
#define SCT_OUTPUTSET12_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET12: SETn6 Position     */
#define SCT_OUTPUTSET12_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn6_Pos)                     /*!< SCT OUTPUTSET12: SETn6 Mask         */
#define SCT_OUTPUTSET12_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET12: SETn7 Position     */
#define SCT_OUTPUTSET12_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn7_Pos)                     /*!< SCT OUTPUTSET12: SETn7 Mask         */
#define SCT_OUTPUTSET12_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET12: SETn8 Position     */
#define SCT_OUTPUTSET12_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn8_Pos)                     /*!< SCT OUTPUTSET12: SETn8 Mask         */
#define SCT_OUTPUTSET12_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET12: SETn9 Position     */
#define SCT_OUTPUTSET12_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn9_Pos)                     /*!< SCT OUTPUTSET12: SETn9 Mask         */
#define SCT_OUTPUTSET12_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET12: SETn10 Position    */
#define SCT_OUTPUTSET12_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn10_Pos)                    /*!< SCT OUTPUTSET12: SETn10 Mask        */
#define SCT_OUTPUTSET12_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET12: SETn11 Position    */
#define SCT_OUTPUTSET12_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn11_Pos)                    /*!< SCT OUTPUTSET12: SETn11 Mask        */
#define SCT_OUTPUTSET12_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET12: SETn12 Position    */
#define SCT_OUTPUTSET12_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn12_Pos)                    /*!< SCT OUTPUTSET12: SETn12 Mask        */
#define SCT_OUTPUTSET12_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET12: SETn13 Position    */
#define SCT_OUTPUTSET12_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn13_Pos)                    /*!< SCT OUTPUTSET12: SETn13 Mask        */
#define SCT_OUTPUTSET12_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET12: SETn14 Position    */
#define SCT_OUTPUTSET12_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn14_Pos)                    /*!< SCT OUTPUTSET12: SETn14 Mask        */
#define SCT_OUTPUTSET12_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET12: SETn15 Position    */
#define SCT_OUTPUTSET12_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn15_Pos)                    /*!< SCT OUTPUTSET12: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR12  ----------------------------------------
#define SCT_OUTPUTCLR12_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR12: CLRn0 Position     */
#define SCT_OUTPUTCLR12_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn0_Pos)                     /*!< SCT OUTPUTCLR12: CLRn0 Mask         */
#define SCT_OUTPUTCLR12_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR12: CLRn1 Position     */
#define SCT_OUTPUTCLR12_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn1_Pos)                     /*!< SCT OUTPUTCLR12: CLRn1 Mask         */
#define SCT_OUTPUTCLR12_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR12: CLRn2 Position     */
#define SCT_OUTPUTCLR12_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn2_Pos)                     /*!< SCT OUTPUTCLR12: CLRn2 Mask         */
#define SCT_OUTPUTCLR12_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR12: CLRn3 Position     */
#define SCT_OUTPUTCLR12_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn3_Pos)                     /*!< SCT OUTPUTCLR12: CLRn3 Mask         */
#define SCT_OUTPUTCLR12_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR12: CLRn4 Position     */
#define SCT_OUTPUTCLR12_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn4_Pos)                     /*!< SCT OUTPUTCLR12: CLRn4 Mask         */
#define SCT_OUTPUTCLR12_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR12: CLRn5 Position     */
#define SCT_OUTPUTCLR12_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn5_Pos)                     /*!< SCT OUTPUTCLR12: CLRn5 Mask         */
#define SCT_OUTPUTCLR12_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR12: CLRn6 Position     */
#define SCT_OUTPUTCLR12_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn6_Pos)                     /*!< SCT OUTPUTCLR12: CLRn6 Mask         */
#define SCT_OUTPUTCLR12_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR12: CLRn7 Position     */
#define SCT_OUTPUTCLR12_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn7_Pos)                     /*!< SCT OUTPUTCLR12: CLRn7 Mask         */
#define SCT_OUTPUTCLR12_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR12: CLRn8 Position     */
#define SCT_OUTPUTCLR12_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn8_Pos)                     /*!< SCT OUTPUTCLR12: CLRn8 Mask         */
#define SCT_OUTPUTCLR12_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR12: CLRn9 Position     */
#define SCT_OUTPUTCLR12_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn9_Pos)                     /*!< SCT OUTPUTCLR12: CLRn9 Mask         */
#define SCT_OUTPUTCLR12_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR12: CLRn10 Position    */
#define SCT_OUTPUTCLR12_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn10_Pos)                    /*!< SCT OUTPUTCLR12: CLRn10 Mask        */
#define SCT_OUTPUTCLR12_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR12: CLRn11 Position    */
#define SCT_OUTPUTCLR12_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn11_Pos)                    /*!< SCT OUTPUTCLR12: CLRn11 Mask        */
#define SCT_OUTPUTCLR12_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR12: CLRn12 Position    */
#define SCT_OUTPUTCLR12_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn12_Pos)                    /*!< SCT OUTPUTCLR12: CLRn12 Mask        */
#define SCT_OUTPUTCLR12_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR12: CLRn13 Position    */
#define SCT_OUTPUTCLR12_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn13_Pos)                    /*!< SCT OUTPUTCLR12: CLRn13 Mask        */
#define SCT_OUTPUTCLR12_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR12: CLRn14 Position    */
#define SCT_OUTPUTCLR12_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn14_Pos)                    /*!< SCT OUTPUTCLR12: CLRn14 Mask        */
#define SCT_OUTPUTCLR12_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR12: CLRn15 Position    */
#define SCT_OUTPUTCLR12_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn15_Pos)                    /*!< SCT OUTPUTCLR12: CLRn15 Mask        */

// -------------------------------------  SCT_OUTPUTSET13  ----------------------------------------
#define SCT_OUTPUTSET13_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET13: SETn0 Position     */
#define SCT_OUTPUTSET13_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn0_Pos)                     /*!< SCT OUTPUTSET13: SETn0 Mask         */
#define SCT_OUTPUTSET13_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET13: SETn1 Position     */
#define SCT_OUTPUTSET13_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn1_Pos)                     /*!< SCT OUTPUTSET13: SETn1 Mask         */
#define SCT_OUTPUTSET13_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET13: SETn2 Position     */
#define SCT_OUTPUTSET13_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn2_Pos)                     /*!< SCT OUTPUTSET13: SETn2 Mask         */
#define SCT_OUTPUTSET13_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET13: SETn3 Position     */
#define SCT_OUTPUTSET13_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn3_Pos)                     /*!< SCT OUTPUTSET13: SETn3 Mask         */
#define SCT_OUTPUTSET13_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET13: SETn4 Position     */
#define SCT_OUTPUTSET13_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn4_Pos)                     /*!< SCT OUTPUTSET13: SETn4 Mask         */
#define SCT_OUTPUTSET13_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET13: SETn5 Position     */
#define SCT_OUTPUTSET13_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn5_Pos)                     /*!< SCT OUTPUTSET13: SETn5 Mask         */
#define SCT_OUTPUTSET13_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET13: SETn6 Position     */
#define SCT_OUTPUTSET13_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn6_Pos)                     /*!< SCT OUTPUTSET13: SETn6 Mask         */
#define SCT_OUTPUTSET13_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET13: SETn7 Position     */
#define SCT_OUTPUTSET13_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn7_Pos)                     /*!< SCT OUTPUTSET13: SETn7 Mask         */
#define SCT_OUTPUTSET13_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET13: SETn8 Position     */
#define SCT_OUTPUTSET13_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn8_Pos)                     /*!< SCT OUTPUTSET13: SETn8 Mask         */
#define SCT_OUTPUTSET13_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET13: SETn9 Position     */
#define SCT_OUTPUTSET13_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn9_Pos)                     /*!< SCT OUTPUTSET13: SETn9 Mask         */
#define SCT_OUTPUTSET13_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET13: SETn10 Position    */
#define SCT_OUTPUTSET13_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn10_Pos)                    /*!< SCT OUTPUTSET13: SETn10 Mask        */
#define SCT_OUTPUTSET13_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET13: SETn11 Position    */
#define SCT_OUTPUTSET13_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn11_Pos)                    /*!< SCT OUTPUTSET13: SETn11 Mask        */
#define SCT_OUTPUTSET13_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET13: SETn12 Position    */
#define SCT_OUTPUTSET13_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn12_Pos)                    /*!< SCT OUTPUTSET13: SETn12 Mask        */
#define SCT_OUTPUTSET13_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET13: SETn13 Position    */
#define SCT_OUTPUTSET13_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn13_Pos)                    /*!< SCT OUTPUTSET13: SETn13 Mask        */
#define SCT_OUTPUTSET13_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET13: SETn14 Position    */
#define SCT_OUTPUTSET13_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn14_Pos)                    /*!< SCT OUTPUTSET13: SETn14 Mask        */
#define SCT_OUTPUTSET13_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET13: SETn15 Position    */
#define SCT_OUTPUTSET13_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn15_Pos)                    /*!< SCT OUTPUTSET13: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR13  ----------------------------------------
#define SCT_OUTPUTCLR13_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR13: CLRn0 Position     */
#define SCT_OUTPUTCLR13_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn0_Pos)                     /*!< SCT OUTPUTCLR13: CLRn0 Mask         */
#define SCT_OUTPUTCLR13_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR13: CLRn1 Position     */
#define SCT_OUTPUTCLR13_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn1_Pos)                     /*!< SCT OUTPUTCLR13: CLRn1 Mask         */
#define SCT_OUTPUTCLR13_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR13: CLRn2 Position     */
#define SCT_OUTPUTCLR13_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn2_Pos)                     /*!< SCT OUTPUTCLR13: CLRn2 Mask         */
#define SCT_OUTPUTCLR13_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR13: CLRn3 Position     */
#define SCT_OUTPUTCLR13_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn3_Pos)                     /*!< SCT OUTPUTCLR13: CLRn3 Mask         */
#define SCT_OUTPUTCLR13_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR13: CLRn4 Position     */
#define SCT_OUTPUTCLR13_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn4_Pos)                     /*!< SCT OUTPUTCLR13: CLRn4 Mask         */
#define SCT_OUTPUTCLR13_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR13: CLRn5 Position     */
#define SCT_OUTPUTCLR13_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn5_Pos)                     /*!< SCT OUTPUTCLR13: CLRn5 Mask         */
#define SCT_OUTPUTCLR13_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR13: CLRn6 Position     */
#define SCT_OUTPUTCLR13_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn6_Pos)                     /*!< SCT OUTPUTCLR13: CLRn6 Mask         */
#define SCT_OUTPUTCLR13_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR13: CLRn7 Position     */
#define SCT_OUTPUTCLR13_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn7_Pos)                     /*!< SCT OUTPUTCLR13: CLRn7 Mask         */
#define SCT_OUTPUTCLR13_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR13: CLRn8 Position     */
#define SCT_OUTPUTCLR13_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn8_Pos)                     /*!< SCT OUTPUTCLR13: CLRn8 Mask         */
#define SCT_OUTPUTCLR13_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR13: CLRn9 Position     */
#define SCT_OUTPUTCLR13_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn9_Pos)                     /*!< SCT OUTPUTCLR13: CLRn9 Mask         */
#define SCT_OUTPUTCLR13_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR13: CLRn10 Position    */
#define SCT_OUTPUTCLR13_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn10_Pos)                    /*!< SCT OUTPUTCLR13: CLRn10 Mask        */
#define SCT_OUTPUTCLR13_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR13: CLRn11 Position    */
#define SCT_OUTPUTCLR13_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn11_Pos)                    /*!< SCT OUTPUTCLR13: CLRn11 Mask        */
#define SCT_OUTPUTCLR13_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR13: CLRn12 Position    */
#define SCT_OUTPUTCLR13_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn12_Pos)                    /*!< SCT OUTPUTCLR13: CLRn12 Mask        */
#define SCT_OUTPUTCLR13_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR13: CLRn13 Position    */
#define SCT_OUTPUTCLR13_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn13_Pos)                    /*!< SCT OUTPUTCLR13: CLRn13 Mask        */
#define SCT_OUTPUTCLR13_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR13: CLRn14 Position    */
#define SCT_OUTPUTCLR13_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn14_Pos)                    /*!< SCT OUTPUTCLR13: CLRn14 Mask        */
#define SCT_OUTPUTCLR13_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR13: CLRn15 Position    */
#define SCT_OUTPUTCLR13_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn15_Pos)                    /*!< SCT OUTPUTCLR13: CLRn15 Mask        */

// -------------------------------------  SCT_OUTPUTSET14  ----------------------------------------
#define SCT_OUTPUTSET14_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET14: SETn0 Position     */
#define SCT_OUTPUTSET14_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn0_Pos)                     /*!< SCT OUTPUTSET14: SETn0 Mask         */
#define SCT_OUTPUTSET14_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET14: SETn1 Position     */
#define SCT_OUTPUTSET14_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn1_Pos)                     /*!< SCT OUTPUTSET14: SETn1 Mask         */
#define SCT_OUTPUTSET14_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET14: SETn2 Position     */
#define SCT_OUTPUTSET14_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn2_Pos)                     /*!< SCT OUTPUTSET14: SETn2 Mask         */
#define SCT_OUTPUTSET14_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET14: SETn3 Position     */
#define SCT_OUTPUTSET14_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn3_Pos)                     /*!< SCT OUTPUTSET14: SETn3 Mask         */
#define SCT_OUTPUTSET14_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET14: SETn4 Position     */
#define SCT_OUTPUTSET14_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn4_Pos)                     /*!< SCT OUTPUTSET14: SETn4 Mask         */
#define SCT_OUTPUTSET14_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET14: SETn5 Position     */
#define SCT_OUTPUTSET14_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn5_Pos)                     /*!< SCT OUTPUTSET14: SETn5 Mask         */
#define SCT_OUTPUTSET14_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET14: SETn6 Position     */
#define SCT_OUTPUTSET14_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn6_Pos)                     /*!< SCT OUTPUTSET14: SETn6 Mask         */
#define SCT_OUTPUTSET14_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET14: SETn7 Position     */
#define SCT_OUTPUTSET14_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn7_Pos)                     /*!< SCT OUTPUTSET14: SETn7 Mask         */
#define SCT_OUTPUTSET14_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET14: SETn8 Position     */
#define SCT_OUTPUTSET14_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn8_Pos)                     /*!< SCT OUTPUTSET14: SETn8 Mask         */
#define SCT_OUTPUTSET14_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET14: SETn9 Position     */
#define SCT_OUTPUTSET14_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn9_Pos)                     /*!< SCT OUTPUTSET14: SETn9 Mask         */
#define SCT_OUTPUTSET14_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET14: SETn10 Position    */
#define SCT_OUTPUTSET14_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn10_Pos)                    /*!< SCT OUTPUTSET14: SETn10 Mask        */
#define SCT_OUTPUTSET14_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET14: SETn11 Position    */
#define SCT_OUTPUTSET14_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn11_Pos)                    /*!< SCT OUTPUTSET14: SETn11 Mask        */
#define SCT_OUTPUTSET14_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET14: SETn12 Position    */
#define SCT_OUTPUTSET14_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn12_Pos)                    /*!< SCT OUTPUTSET14: SETn12 Mask        */
#define SCT_OUTPUTSET14_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET14: SETn13 Position    */
#define SCT_OUTPUTSET14_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn13_Pos)                    /*!< SCT OUTPUTSET14: SETn13 Mask        */
#define SCT_OUTPUTSET14_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET14: SETn14 Position    */
#define SCT_OUTPUTSET14_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn14_Pos)                    /*!< SCT OUTPUTSET14: SETn14 Mask        */
#define SCT_OUTPUTSET14_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET14: SETn15 Position    */
#define SCT_OUTPUTSET14_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn15_Pos)                    /*!< SCT OUTPUTSET14: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR14  ----------------------------------------
#define SCT_OUTPUTCLR14_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR14: CLRn0 Position     */
#define SCT_OUTPUTCLR14_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn0_Pos)                     /*!< SCT OUTPUTCLR14: CLRn0 Mask         */
#define SCT_OUTPUTCLR14_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR14: CLRn1 Position     */
#define SCT_OUTPUTCLR14_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn1_Pos)                     /*!< SCT OUTPUTCLR14: CLRn1 Mask         */
#define SCT_OUTPUTCLR14_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR14: CLRn2 Position     */
#define SCT_OUTPUTCLR14_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn2_Pos)                     /*!< SCT OUTPUTCLR14: CLRn2 Mask         */
#define SCT_OUTPUTCLR14_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR14: CLRn3 Position     */
#define SCT_OUTPUTCLR14_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn3_Pos)                     /*!< SCT OUTPUTCLR14: CLRn3 Mask         */
#define SCT_OUTPUTCLR14_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR14: CLRn4 Position     */
#define SCT_OUTPUTCLR14_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn4_Pos)                     /*!< SCT OUTPUTCLR14: CLRn4 Mask         */
#define SCT_OUTPUTCLR14_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR14: CLRn5 Position     */
#define SCT_OUTPUTCLR14_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn5_Pos)                     /*!< SCT OUTPUTCLR14: CLRn5 Mask         */
#define SCT_OUTPUTCLR14_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR14: CLRn6 Position     */
#define SCT_OUTPUTCLR14_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn6_Pos)                     /*!< SCT OUTPUTCLR14: CLRn6 Mask         */
#define SCT_OUTPUTCLR14_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR14: CLRn7 Position     */
#define SCT_OUTPUTCLR14_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn7_Pos)                     /*!< SCT OUTPUTCLR14: CLRn7 Mask         */
#define SCT_OUTPUTCLR14_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR14: CLRn8 Position     */
#define SCT_OUTPUTCLR14_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn8_Pos)                     /*!< SCT OUTPUTCLR14: CLRn8 Mask         */
#define SCT_OUTPUTCLR14_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR14: CLRn9 Position     */
#define SCT_OUTPUTCLR14_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn9_Pos)                     /*!< SCT OUTPUTCLR14: CLRn9 Mask         */
#define SCT_OUTPUTCLR14_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR14: CLRn10 Position    */
#define SCT_OUTPUTCLR14_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn10_Pos)                    /*!< SCT OUTPUTCLR14: CLRn10 Mask        */
#define SCT_OUTPUTCLR14_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR14: CLRn11 Position    */
#define SCT_OUTPUTCLR14_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn11_Pos)                    /*!< SCT OUTPUTCLR14: CLRn11 Mask        */
#define SCT_OUTPUTCLR14_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR14: CLRn12 Position    */
#define SCT_OUTPUTCLR14_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn12_Pos)                    /*!< SCT OUTPUTCLR14: CLRn12 Mask        */
#define SCT_OUTPUTCLR14_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR14: CLRn13 Position    */
#define SCT_OUTPUTCLR14_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn13_Pos)                    /*!< SCT OUTPUTCLR14: CLRn13 Mask        */
#define SCT_OUTPUTCLR14_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR14: CLRn14 Position    */
#define SCT_OUTPUTCLR14_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn14_Pos)                    /*!< SCT OUTPUTCLR14: CLRn14 Mask        */
#define SCT_OUTPUTCLR14_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR14: CLRn15 Position    */
#define SCT_OUTPUTCLR14_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn15_Pos)                    /*!< SCT OUTPUTCLR14: CLRn15 Mask        */

// -------------------------------------  SCT_OUTPUTSET15  ----------------------------------------
#define SCT_OUTPUTSET15_SETn0_Pos                             0                                                         /*!< SCT OUTPUTSET15: SETn0 Position     */
#define SCT_OUTPUTSET15_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn0_Pos)                     /*!< SCT OUTPUTSET15: SETn0 Mask         */
#define SCT_OUTPUTSET15_SETn1_Pos                             1                                                         /*!< SCT OUTPUTSET15: SETn1 Position     */
#define SCT_OUTPUTSET15_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn1_Pos)                     /*!< SCT OUTPUTSET15: SETn1 Mask         */
#define SCT_OUTPUTSET15_SETn2_Pos                             2                                                         /*!< SCT OUTPUTSET15: SETn2 Position     */
#define SCT_OUTPUTSET15_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn2_Pos)                     /*!< SCT OUTPUTSET15: SETn2 Mask         */
#define SCT_OUTPUTSET15_SETn3_Pos                             3                                                         /*!< SCT OUTPUTSET15: SETn3 Position     */
#define SCT_OUTPUTSET15_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn3_Pos)                     /*!< SCT OUTPUTSET15: SETn3 Mask         */
#define SCT_OUTPUTSET15_SETn4_Pos                             4                                                         /*!< SCT OUTPUTSET15: SETn4 Position     */
#define SCT_OUTPUTSET15_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn4_Pos)                     /*!< SCT OUTPUTSET15: SETn4 Mask         */
#define SCT_OUTPUTSET15_SETn5_Pos                             5                                                         /*!< SCT OUTPUTSET15: SETn5 Position     */
#define SCT_OUTPUTSET15_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn5_Pos)                     /*!< SCT OUTPUTSET15: SETn5 Mask         */
#define SCT_OUTPUTSET15_SETn6_Pos                             6                                                         /*!< SCT OUTPUTSET15: SETn6 Position     */
#define SCT_OUTPUTSET15_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn6_Pos)                     /*!< SCT OUTPUTSET15: SETn6 Mask         */
#define SCT_OUTPUTSET15_SETn7_Pos                             7                                                         /*!< SCT OUTPUTSET15: SETn7 Position     */
#define SCT_OUTPUTSET15_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn7_Pos)                     /*!< SCT OUTPUTSET15: SETn7 Mask         */
#define SCT_OUTPUTSET15_SETn8_Pos                             8                                                         /*!< SCT OUTPUTSET15: SETn8 Position     */
#define SCT_OUTPUTSET15_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn8_Pos)                     /*!< SCT OUTPUTSET15: SETn8 Mask         */
#define SCT_OUTPUTSET15_SETn9_Pos                             9                                                         /*!< SCT OUTPUTSET15: SETn9 Position     */
#define SCT_OUTPUTSET15_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn9_Pos)                     /*!< SCT OUTPUTSET15: SETn9 Mask         */
#define SCT_OUTPUTSET15_SETn10_Pos                            10                                                        /*!< SCT OUTPUTSET15: SETn10 Position    */
#define SCT_OUTPUTSET15_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn10_Pos)                    /*!< SCT OUTPUTSET15: SETn10 Mask        */
#define SCT_OUTPUTSET15_SETn11_Pos                            11                                                        /*!< SCT OUTPUTSET15: SETn11 Position    */
#define SCT_OUTPUTSET15_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn11_Pos)                    /*!< SCT OUTPUTSET15: SETn11 Mask        */
#define SCT_OUTPUTSET15_SETn12_Pos                            12                                                        /*!< SCT OUTPUTSET15: SETn12 Position    */
#define SCT_OUTPUTSET15_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn12_Pos)                    /*!< SCT OUTPUTSET15: SETn12 Mask        */
#define SCT_OUTPUTSET15_SETn13_Pos                            13                                                        /*!< SCT OUTPUTSET15: SETn13 Position    */
#define SCT_OUTPUTSET15_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn13_Pos)                    /*!< SCT OUTPUTSET15: SETn13 Mask        */
#define SCT_OUTPUTSET15_SETn14_Pos                            14                                                        /*!< SCT OUTPUTSET15: SETn14 Position    */
#define SCT_OUTPUTSET15_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn14_Pos)                    /*!< SCT OUTPUTSET15: SETn14 Mask        */
#define SCT_OUTPUTSET15_SETn15_Pos                            15                                                        /*!< SCT OUTPUTSET15: SETn15 Position    */
#define SCT_OUTPUTSET15_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn15_Pos)                    /*!< SCT OUTPUTSET15: SETn15 Mask        */

// -------------------------------------  SCT_OUTPUTCLR15  ----------------------------------------
#define SCT_OUTPUTCLR15_CLRn0_Pos                             0                                                         /*!< SCT OUTPUTCLR15: CLRn0 Position     */
#define SCT_OUTPUTCLR15_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn0_Pos)                     /*!< SCT OUTPUTCLR15: CLRn0 Mask         */
#define SCT_OUTPUTCLR15_CLRn1_Pos                             1                                                         /*!< SCT OUTPUTCLR15: CLRn1 Position     */
#define SCT_OUTPUTCLR15_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn1_Pos)                     /*!< SCT OUTPUTCLR15: CLRn1 Mask         */
#define SCT_OUTPUTCLR15_CLRn2_Pos                             2                                                         /*!< SCT OUTPUTCLR15: CLRn2 Position     */
#define SCT_OUTPUTCLR15_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn2_Pos)                     /*!< SCT OUTPUTCLR15: CLRn2 Mask         */
#define SCT_OUTPUTCLR15_CLRn3_Pos                             3                                                         /*!< SCT OUTPUTCLR15: CLRn3 Position     */
#define SCT_OUTPUTCLR15_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn3_Pos)                     /*!< SCT OUTPUTCLR15: CLRn3 Mask         */
#define SCT_OUTPUTCLR15_CLRn4_Pos                             4                                                         /*!< SCT OUTPUTCLR15: CLRn4 Position     */
#define SCT_OUTPUTCLR15_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn4_Pos)                     /*!< SCT OUTPUTCLR15: CLRn4 Mask         */
#define SCT_OUTPUTCLR15_CLRn5_Pos                             5                                                         /*!< SCT OUTPUTCLR15: CLRn5 Position     */
#define SCT_OUTPUTCLR15_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn5_Pos)                     /*!< SCT OUTPUTCLR15: CLRn5 Mask         */
#define SCT_OUTPUTCLR15_CLRn6_Pos                             6                                                         /*!< SCT OUTPUTCLR15: CLRn6 Position     */
#define SCT_OUTPUTCLR15_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn6_Pos)                     /*!< SCT OUTPUTCLR15: CLRn6 Mask         */
#define SCT_OUTPUTCLR15_CLRn7_Pos                             7                                                         /*!< SCT OUTPUTCLR15: CLRn7 Position     */
#define SCT_OUTPUTCLR15_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn7_Pos)                     /*!< SCT OUTPUTCLR15: CLRn7 Mask         */
#define SCT_OUTPUTCLR15_CLRn8_Pos                             8                                                         /*!< SCT OUTPUTCLR15: CLRn8 Position     */
#define SCT_OUTPUTCLR15_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn8_Pos)                     /*!< SCT OUTPUTCLR15: CLRn8 Mask         */
#define SCT_OUTPUTCLR15_CLRn9_Pos                             9                                                         /*!< SCT OUTPUTCLR15: CLRn9 Position     */
#define SCT_OUTPUTCLR15_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn9_Pos)                     /*!< SCT OUTPUTCLR15: CLRn9 Mask         */
#define SCT_OUTPUTCLR15_CLRn10_Pos                            10                                                        /*!< SCT OUTPUTCLR15: CLRn10 Position    */
#define SCT_OUTPUTCLR15_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn10_Pos)                    /*!< SCT OUTPUTCLR15: CLRn10 Mask        */
#define SCT_OUTPUTCLR15_CLRn11_Pos                            11                                                        /*!< SCT OUTPUTCLR15: CLRn11 Position    */
#define SCT_OUTPUTCLR15_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn11_Pos)                    /*!< SCT OUTPUTCLR15: CLRn11 Mask        */
#define SCT_OUTPUTCLR15_CLRn12_Pos                            12                                                        /*!< SCT OUTPUTCLR15: CLRn12 Position    */
#define SCT_OUTPUTCLR15_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn12_Pos)                    /*!< SCT OUTPUTCLR15: CLRn12 Mask        */
#define SCT_OUTPUTCLR15_CLRn13_Pos                            13                                                        /*!< SCT OUTPUTCLR15: CLRn13 Position    */
#define SCT_OUTPUTCLR15_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn13_Pos)                    /*!< SCT OUTPUTCLR15: CLRn13 Mask        */
#define SCT_OUTPUTCLR15_CLRn14_Pos                            14                                                        /*!< SCT OUTPUTCLR15: CLRn14 Position    */
#define SCT_OUTPUTCLR15_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn14_Pos)                    /*!< SCT OUTPUTCLR15: CLRn14 Mask        */
#define SCT_OUTPUTCLR15_CLRn15_Pos                            15                                                        /*!< SCT OUTPUTCLR15: CLRn15 Position    */
#define SCT_OUTPUTCLR15_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn15_Pos)                    /*!< SCT OUTPUTCLR15: CLRn15 Mask        */


// ------------------------------------------------------------------------------------------------
// -----                                 GPDMA Position & Mask                                -----
// ------------------------------------------------------------------------------------------------


// --------------------------------------  GPDMA_INTSTAT  -----------------------------------------
#define GPDMA_INTSTAT_INTSTAT0_Pos                            0                                                         /*!< GPDMA INTSTAT: INTSTAT0 Position    */
#define GPDMA_INTSTAT_INTSTAT0_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT0_Pos)                    /*!< GPDMA INTSTAT: INTSTAT0 Mask        */
#define GPDMA_INTSTAT_INTSTAT1_Pos                            1                                                         /*!< GPDMA INTSTAT: INTSTAT1 Position    */
#define GPDMA_INTSTAT_INTSTAT1_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT1_Pos)                    /*!< GPDMA INTSTAT: INTSTAT1 Mask        */
#define GPDMA_INTSTAT_INTSTAT2_Pos                            2                                                         /*!< GPDMA INTSTAT: INTSTAT2 Position    */
#define GPDMA_INTSTAT_INTSTAT2_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT2_Pos)                    /*!< GPDMA INTSTAT: INTSTAT2 Mask        */
#define GPDMA_INTSTAT_INTSTAT3_Pos                            3                                                         /*!< GPDMA INTSTAT: INTSTAT3 Position    */
#define GPDMA_INTSTAT_INTSTAT3_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT3_Pos)                    /*!< GPDMA INTSTAT: INTSTAT3 Mask        */
#define GPDMA_INTSTAT_INTSTAT4_Pos                            4                                                         /*!< GPDMA INTSTAT: INTSTAT4 Position    */
#define GPDMA_INTSTAT_INTSTAT4_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT4_Pos)                    /*!< GPDMA INTSTAT: INTSTAT4 Mask        */
#define GPDMA_INTSTAT_INTSTAT5_Pos                            5                                                         /*!< GPDMA INTSTAT: INTSTAT5 Position    */
#define GPDMA_INTSTAT_INTSTAT5_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT5_Pos)                    /*!< GPDMA INTSTAT: INTSTAT5 Mask        */
#define GPDMA_INTSTAT_INTSTAT6_Pos                            6                                                         /*!< GPDMA INTSTAT: INTSTAT6 Position    */
#define GPDMA_INTSTAT_INTSTAT6_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT6_Pos)                    /*!< GPDMA INTSTAT: INTSTAT6 Mask        */
#define GPDMA_INTSTAT_INTSTAT7_Pos                            7                                                         /*!< GPDMA INTSTAT: INTSTAT7 Position    */
#define GPDMA_INTSTAT_INTSTAT7_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT7_Pos)                    /*!< GPDMA INTSTAT: INTSTAT7 Mask        */

// -------------------------------------  GPDMA_INTTCSTAT  ----------------------------------------
#define GPDMA_INTTCSTAT_INTTCSTAT0_Pos                        0                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT0 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT0_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT0_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT0 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT1_Pos                        1                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT1 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT1_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT1_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT1 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT2_Pos                        2                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT2 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT2_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT2_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT2 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT3_Pos                        3                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT3 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT3_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT3_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT3 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT4_Pos                        4                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT4 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT4_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT4_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT4 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT5_Pos                        5                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT5 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT5_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT5_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT5 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT6_Pos                        6                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT6 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT6_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT6_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT6 Mask    */
#define GPDMA_INTTCSTAT_INTTCSTAT7_Pos                        7                                                         /*!< GPDMA INTTCSTAT: INTTCSTAT7 Position */
#define GPDMA_INTTCSTAT_INTTCSTAT7_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT7_Pos)                /*!< GPDMA INTTCSTAT: INTTCSTAT7 Mask    */

// ------------------------------------  GPDMA_INTTCCLEAR  ----------------------------------------
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos                      0                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR0 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR0 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos                      1                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR1 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR1 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos                      2                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR2 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR2 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos                      3                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR3 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR3 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos                      4                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR4 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR4 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos                      5                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR5 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR5 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos                      6                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR6 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR6 Mask  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos                      7                                                         /*!< GPDMA INTTCCLEAR: INTTCCLEAR7 Position */
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos)              /*!< GPDMA INTTCCLEAR: INTTCCLEAR7 Mask  */

// ------------------------------------  GPDMA_INTERRSTAT  ----------------------------------------
#define GPDMA_INTERRSTAT_INTERRSTAT0_Pos                      0                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT0 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT0_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT0_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT0 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT1_Pos                      1                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT1 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT1_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT1_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT1 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT2_Pos                      2                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT2 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT2_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT2_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT2 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT3_Pos                      3                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT3 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT3_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT3_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT3 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT4_Pos                      4                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT4 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT4_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT4_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT4 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT5_Pos                      5                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT5 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT5_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT5_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT5 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT6_Pos                      6                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT6 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT6_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT6_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT6 Mask  */
#define GPDMA_INTERRSTAT_INTERRSTAT7_Pos                      7                                                         /*!< GPDMA INTERRSTAT: INTERRSTAT7 Position */
#define GPDMA_INTERRSTAT_INTERRSTAT7_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT7_Pos)              /*!< GPDMA INTERRSTAT: INTERRSTAT7 Mask  */

// -------------------------------------  GPDMA_INTERRCLR  ----------------------------------------
#define GPDMA_INTERRCLR_INTERRCLR0_Pos                        0                                                         /*!< GPDMA INTERRCLR: INTERRCLR0 Position */
#define GPDMA_INTERRCLR_INTERRCLR0_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR0_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR0 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR1_Pos                        1                                                         /*!< GPDMA INTERRCLR: INTERRCLR1 Position */
#define GPDMA_INTERRCLR_INTERRCLR1_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR1_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR1 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR2_Pos                        2                                                         /*!< GPDMA INTERRCLR: INTERRCLR2 Position */
#define GPDMA_INTERRCLR_INTERRCLR2_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR2_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR2 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR3_Pos                        3                                                         /*!< GPDMA INTERRCLR: INTERRCLR3 Position */
#define GPDMA_INTERRCLR_INTERRCLR3_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR3_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR3 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR4_Pos                        4                                                         /*!< GPDMA INTERRCLR: INTERRCLR4 Position */
#define GPDMA_INTERRCLR_INTERRCLR4_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR4_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR4 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR5_Pos                        5                                                         /*!< GPDMA INTERRCLR: INTERRCLR5 Position */
#define GPDMA_INTERRCLR_INTERRCLR5_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR5_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR5 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR6_Pos                        6                                                         /*!< GPDMA INTERRCLR: INTERRCLR6 Position */
#define GPDMA_INTERRCLR_INTERRCLR6_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR6_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR6 Mask    */
#define GPDMA_INTERRCLR_INTERRCLR7_Pos                        7                                                         /*!< GPDMA INTERRCLR: INTERRCLR7 Position */
#define GPDMA_INTERRCLR_INTERRCLR7_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR7_Pos)                /*!< GPDMA INTERRCLR: INTERRCLR7 Mask    */

// -----------------------------------  GPDMA_RAWINTTCSTAT  ---------------------------------------
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos                  0                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT0 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT0 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos                  1                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT1 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT1 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos                  2                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT2 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT2 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos                  3                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT3 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT3 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos                  4                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT4 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT4 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos                  5                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT5 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT5 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos                  6                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT6 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT6 Mask */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos                  7                                                         /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT7 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos)          /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT7 Mask */

// -----------------------------------  GPDMA_RAWINTERRSTAT  --------------------------------------
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos                0                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT0 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT0 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos                1                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT1 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT1 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos                2                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT2 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT2 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos                3                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT3 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT3 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos                4                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT4 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT4 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos                5                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT5 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT5 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos                6                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT6 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT6 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos                7                                                         /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT7 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos)        /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT7 Mask */

// -------------------------------------  GPDMA_ENBLDCHNS  ----------------------------------------
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos                  0                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS0 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS0 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos                  1                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS1 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS1 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos                  2                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS2 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS2 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos                  3                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS3 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS3 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos                  4                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS4 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS4 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos                  5                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS5 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS5 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos                  6                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS6 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS6 Mask */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos                  7                                                         /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS7 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos)          /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS7 Mask */

// -------------------------------------  GPDMA_SOFTBREQ  -----------------------------------------
#define GPDMA_SOFTBREQ_SOFTBREQ0_Pos                          0                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ0 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ0_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ0_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ0 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ1_Pos                          1                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ1 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ1_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ1_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ1 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ2_Pos                          2                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ2 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ2_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ2_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ2 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ3_Pos                          3                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ3 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ3_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ3_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ3 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ4_Pos                          4                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ4 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ4_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ4_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ4 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ5_Pos                          5                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ5 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ5_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ5_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ5 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ6_Pos                          6                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ6 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ6_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ6_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ6 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ7_Pos                          7                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ7 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ7_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ7_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ7 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ8_Pos                          8                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ8 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ8_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ8_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ8 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ9_Pos                          9                                                         /*!< GPDMA SOFTBREQ: SOFTBREQ9 Position  */
#define GPDMA_SOFTBREQ_SOFTBREQ9_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ9_Pos)                  /*!< GPDMA SOFTBREQ: SOFTBREQ9 Mask      */
#define GPDMA_SOFTBREQ_SOFTBREQ10_Pos                         10                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ10 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ10_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ10_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ10 Mask     */
#define GPDMA_SOFTBREQ_SOFTBREQ11_Pos                         11                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ11 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ11_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ11_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ11 Mask     */
#define GPDMA_SOFTBREQ_SOFTBREQ12_Pos                         12                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ12 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ12_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ12_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ12 Mask     */
#define GPDMA_SOFTBREQ_SOFTBREQ13_Pos                         13                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ13 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ13_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ13_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ13 Mask     */
#define GPDMA_SOFTBREQ_SOFTBREQ14_Pos                         14                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ14 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ14_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ14_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ14 Mask     */
#define GPDMA_SOFTBREQ_SOFTBREQ15_Pos                         15                                                        /*!< GPDMA SOFTBREQ: SOFTBREQ15 Position */
#define GPDMA_SOFTBREQ_SOFTBREQ15_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ15_Pos)                 /*!< GPDMA SOFTBREQ: SOFTBREQ15 Mask     */

// -------------------------------------  GPDMA_SOFTSREQ  -----------------------------------------
#define GPDMA_SOFTSREQ_SOFTSREQ0_Pos                          0                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ0 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ0_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ0_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ0 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ1_Pos                          1                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ1 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ1_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ1_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ1 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ2_Pos                          2                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ2 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ2_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ2_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ2 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ3_Pos                          3                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ3 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ3_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ3_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ3 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ4_Pos                          4                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ4 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ4_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ4_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ4 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ5_Pos                          5                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ5 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ5_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ5_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ5 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ6_Pos                          6                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ6 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ6_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ6_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ6 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ7_Pos                          7                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ7 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ7_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ7_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ7 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ8_Pos                          8                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ8 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ8_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ8_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ8 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ9_Pos                          9                                                         /*!< GPDMA SOFTSREQ: SOFTSREQ9 Position  */
#define GPDMA_SOFTSREQ_SOFTSREQ9_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ9_Pos)                  /*!< GPDMA SOFTSREQ: SOFTSREQ9 Mask      */
#define GPDMA_SOFTSREQ_SOFTSREQ10_Pos                         10                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ10 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ10_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ10_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ10 Mask     */
#define GPDMA_SOFTSREQ_SOFTSREQ11_Pos                         11                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ11 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ11_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ11_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ11 Mask     */
#define GPDMA_SOFTSREQ_SOFTSREQ12_Pos                         12                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ12 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ12_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ12_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ12 Mask     */
#define GPDMA_SOFTSREQ_SOFTSREQ13_Pos                         13                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ13 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ13_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ13_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ13 Mask     */
#define GPDMA_SOFTSREQ_SOFTSREQ14_Pos                         14                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ14 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ14_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ14_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ14 Mask     */
#define GPDMA_SOFTSREQ_SOFTSREQ15_Pos                         15                                                        /*!< GPDMA SOFTSREQ: SOFTSREQ15 Position */
#define GPDMA_SOFTSREQ_SOFTSREQ15_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ15_Pos)                 /*!< GPDMA SOFTSREQ: SOFTSREQ15 Mask     */

// -------------------------------------  GPDMA_SOFTLBREQ  ----------------------------------------
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos                        0                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ0 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ0 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos                        1                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ1 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ1 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos                        2                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ2 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ2 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos                        3                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ3 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ3 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos                        4                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ4 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ4 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos                        5                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ5 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ5 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos                        6                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ6 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ6 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos                        7                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ7 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ7 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos                        8                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ8 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ8 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos                        9                                                         /*!< GPDMA SOFTLBREQ: SOFTLBREQ9 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos)                /*!< GPDMA SOFTLBREQ: SOFTLBREQ9 Mask    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos                       10                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ10 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ10 Mask   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos                       11                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ11 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ11 Mask   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos                       12                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ12 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ12 Mask   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos                       13                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ13 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ13 Mask   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos                       14                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ14 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ14 Mask   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos                       15                                                        /*!< GPDMA SOFTLBREQ: SOFTLBREQ15 Position */
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos)               /*!< GPDMA SOFTLBREQ: SOFTLBREQ15 Mask   */

// -------------------------------------  GPDMA_SOFTLSREQ  ----------------------------------------
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos                        0                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ0 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ0 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos                        1                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ1 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ1 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos                        2                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ2 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ2 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos                        3                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ3 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ3 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos                        4                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ4 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ4 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos                        5                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ5 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ5 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos                        6                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ6 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ6 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos                        7                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ7 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ7 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos                        8                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ8 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ8 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos                        9                                                         /*!< GPDMA SOFTLSREQ: SOFTLSREQ9 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos)                /*!< GPDMA SOFTLSREQ: SOFTLSREQ9 Mask    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos                       10                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ10 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ10 Mask   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos                       11                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ11 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ11 Mask   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos                       12                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ12 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ12 Mask   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos                       13                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ13 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ13 Mask   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos                       14                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ14 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ14 Mask   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos                       15                                                        /*!< GPDMA SOFTLSREQ: SOFTLSREQ15 Position */
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos)               /*!< GPDMA SOFTLSREQ: SOFTLSREQ15 Mask   */

// --------------------------------------  GPDMA_CONFIG  ------------------------------------------
#define GPDMA_CONFIG_E_Pos                                    0                                                         /*!< GPDMA CONFIG: E Position            */
#define GPDMA_CONFIG_E_Msk                                    (0x01UL << GPDMA_CONFIG_E_Pos)                            /*!< GPDMA CONFIG: E Mask                */
#define GPDMA_CONFIG_M0_Pos                                   1                                                         /*!< GPDMA CONFIG: M0 Position           */
#define GPDMA_CONFIG_M0_Msk                                   (0x01UL << GPDMA_CONFIG_M0_Pos)                           /*!< GPDMA CONFIG: M0 Mask               */
#define GPDMA_CONFIG_M1_Pos                                   2                                                         /*!< GPDMA CONFIG: M1 Position           */
#define GPDMA_CONFIG_M1_Msk                                   (0x01UL << GPDMA_CONFIG_M1_Pos)                           /*!< GPDMA CONFIG: M1 Mask               */

// ---------------------------------------  GPDMA_SYNC  -------------------------------------------
#define GPDMA_SYNC_DMACSYNC0_Pos                              0                                                         /*!< GPDMA SYNC: DMACSYNC0 Position      */
#define GPDMA_SYNC_DMACSYNC0_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC0_Pos)                      /*!< GPDMA SYNC: DMACSYNC0 Mask          */
#define GPDMA_SYNC_DMACSYNC1_Pos                              1                                                         /*!< GPDMA SYNC: DMACSYNC1 Position      */
#define GPDMA_SYNC_DMACSYNC1_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC1_Pos)                      /*!< GPDMA SYNC: DMACSYNC1 Mask          */
#define GPDMA_SYNC_DMACSYNC2_Pos                              2                                                         /*!< GPDMA SYNC: DMACSYNC2 Position      */
#define GPDMA_SYNC_DMACSYNC2_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC2_Pos)                      /*!< GPDMA SYNC: DMACSYNC2 Mask          */
#define GPDMA_SYNC_DMACSYNC3_Pos                              3                                                         /*!< GPDMA SYNC: DMACSYNC3 Position      */
#define GPDMA_SYNC_DMACSYNC3_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC3_Pos)                      /*!< GPDMA SYNC: DMACSYNC3 Mask          */
#define GPDMA_SYNC_DMACSYNC4_Pos                              4                                                         /*!< GPDMA SYNC: DMACSYNC4 Position      */
#define GPDMA_SYNC_DMACSYNC4_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC4_Pos)                      /*!< GPDMA SYNC: DMACSYNC4 Mask          */
#define GPDMA_SYNC_DMACSYNC5_Pos                              5                                                         /*!< GPDMA SYNC: DMACSYNC5 Position      */
#define GPDMA_SYNC_DMACSYNC5_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC5_Pos)                      /*!< GPDMA SYNC: DMACSYNC5 Mask          */
#define GPDMA_SYNC_DMACSYNC6_Pos                              6                                                         /*!< GPDMA SYNC: DMACSYNC6 Position      */
#define GPDMA_SYNC_DMACSYNC6_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC6_Pos)                      /*!< GPDMA SYNC: DMACSYNC6 Mask          */
#define GPDMA_SYNC_DMACSYNC7_Pos                              7                                                         /*!< GPDMA SYNC: DMACSYNC7 Position      */
#define GPDMA_SYNC_DMACSYNC7_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC7_Pos)                      /*!< GPDMA SYNC: DMACSYNC7 Mask          */
#define GPDMA_SYNC_DMACSYNC8_Pos                              8                                                         /*!< GPDMA SYNC: DMACSYNC8 Position      */
#define GPDMA_SYNC_DMACSYNC8_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC8_Pos)                      /*!< GPDMA SYNC: DMACSYNC8 Mask          */
#define GPDMA_SYNC_DMACSYNC9_Pos                              9                                                         /*!< GPDMA SYNC: DMACSYNC9 Position      */
#define GPDMA_SYNC_DMACSYNC9_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC9_Pos)                      /*!< GPDMA SYNC: DMACSYNC9 Mask          */
#define GPDMA_SYNC_DMACSYNC10_Pos                             10                                                        /*!< GPDMA SYNC: DMACSYNC10 Position     */
#define GPDMA_SYNC_DMACSYNC10_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC10_Pos)                     /*!< GPDMA SYNC: DMACSYNC10 Mask         */
#define GPDMA_SYNC_DMACSYNC11_Pos                             11                                                        /*!< GPDMA SYNC: DMACSYNC11 Position     */
#define GPDMA_SYNC_DMACSYNC11_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC11_Pos)                     /*!< GPDMA SYNC: DMACSYNC11 Mask         */
#define GPDMA_SYNC_DMACSYNC12_Pos                             12                                                        /*!< GPDMA SYNC: DMACSYNC12 Position     */
#define GPDMA_SYNC_DMACSYNC12_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC12_Pos)                     /*!< GPDMA SYNC: DMACSYNC12 Mask         */
#define GPDMA_SYNC_DMACSYNC13_Pos                             13                                                        /*!< GPDMA SYNC: DMACSYNC13 Position     */
#define GPDMA_SYNC_DMACSYNC13_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC13_Pos)                     /*!< GPDMA SYNC: DMACSYNC13 Mask         */
#define GPDMA_SYNC_DMACSYNC14_Pos                             14                                                        /*!< GPDMA SYNC: DMACSYNC14 Position     */
#define GPDMA_SYNC_DMACSYNC14_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC14_Pos)                     /*!< GPDMA SYNC: DMACSYNC14 Mask         */
#define GPDMA_SYNC_DMACSYNC15_Pos                             15                                                        /*!< GPDMA SYNC: DMACSYNC15 Position     */
#define GPDMA_SYNC_DMACSYNC15_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC15_Pos)                     /*!< GPDMA SYNC: DMACSYNC15 Mask         */

// -------------------------------------  GPDMA_C0SRCADDR  ----------------------------------------
#define GPDMA_C0SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C0SRCADDR: SRCADDR Position   */
#define GPDMA_C0SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C0SRCADDR_SRCADDR_Pos)             /*!< GPDMA C0SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C0DESTADDR  ----------------------------------------
#define GPDMA_C0DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C0DESTADDR: DESTADDR Position */
#define GPDMA_C0DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C0DESTADDR_DESTADDR_Pos)           /*!< GPDMA C0DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C0LLI  ------------------------------------------
#define GPDMA_C0LLI_LM_Pos                                    0                                                         /*!< GPDMA C0LLI: LM Position            */
#define GPDMA_C0LLI_LM_Msk                                    (0x01UL << GPDMA_C0LLI_LM_Pos)                            /*!< GPDMA C0LLI: LM Mask                */
#define GPDMA_C0LLI_R_Pos                                     1                                                         /*!< GPDMA C0LLI: R Position             */
#define GPDMA_C0LLI_R_Msk                                     (0x01UL << GPDMA_C0LLI_R_Pos)                             /*!< GPDMA C0LLI: R Mask                 */
#define GPDMA_C0LLI_LLI_Pos                                   2                                                         /*!< GPDMA C0LLI: LLI Position           */
#define GPDMA_C0LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C0LLI_LLI_Pos)                     /*!< GPDMA C0LLI: LLI Mask               */

// -------------------------------------  GPDMA_C0CONTROL  ----------------------------------------
#define GPDMA_C0CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C0CONTROL: TRANSFERSIZE Position */
#define GPDMA_C0CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C0CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C0CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C0CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C0CONTROL: SBSIZE Position    */
#define GPDMA_C0CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C0CONTROL_SBSIZE_Pos)                    /*!< GPDMA C0CONTROL: SBSIZE Mask        */
#define GPDMA_C0CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C0CONTROL: DBSIZE Position    */
#define GPDMA_C0CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C0CONTROL_DBSIZE_Pos)                    /*!< GPDMA C0CONTROL: DBSIZE Mask        */
#define GPDMA_C0CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C0CONTROL: SWIDTH Position    */
#define GPDMA_C0CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C0CONTROL_SWIDTH_Pos)                    /*!< GPDMA C0CONTROL: SWIDTH Mask        */
#define GPDMA_C0CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C0CONTROL: DWIDTH Position    */
#define GPDMA_C0CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C0CONTROL_DWIDTH_Pos)                    /*!< GPDMA C0CONTROL: DWIDTH Mask        */
#define GPDMA_C0CONTROL_S_Pos                                 24                                                        /*!< GPDMA C0CONTROL: S Position         */
#define GPDMA_C0CONTROL_S_Msk                                 (0x01UL << GPDMA_C0CONTROL_S_Pos)                         /*!< GPDMA C0CONTROL: S Mask             */
#define GPDMA_C0CONTROL_D_Pos                                 25                                                        /*!< GPDMA C0CONTROL: D Position         */
#define GPDMA_C0CONTROL_D_Msk                                 (0x01UL << GPDMA_C0CONTROL_D_Pos)                         /*!< GPDMA C0CONTROL: D Mask             */
#define GPDMA_C0CONTROL_SI_Pos                                26                                                        /*!< GPDMA C0CONTROL: SI Position        */
#define GPDMA_C0CONTROL_SI_Msk                                (0x01UL << GPDMA_C0CONTROL_SI_Pos)                        /*!< GPDMA C0CONTROL: SI Mask            */
#define GPDMA_C0CONTROL_DI_Pos                                27                                                        /*!< GPDMA C0CONTROL: DI Position        */
#define GPDMA_C0CONTROL_DI_Msk                                (0x01UL << GPDMA_C0CONTROL_DI_Pos)                        /*!< GPDMA C0CONTROL: DI Mask            */
#define GPDMA_C0CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C0CONTROL: PROT1 Position     */
#define GPDMA_C0CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT1_Pos)                     /*!< GPDMA C0CONTROL: PROT1 Mask         */
#define GPDMA_C0CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C0CONTROL: PROT2 Position     */
#define GPDMA_C0CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT2_Pos)                     /*!< GPDMA C0CONTROL: PROT2 Mask         */
#define GPDMA_C0CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C0CONTROL: PROT3 Position     */
#define GPDMA_C0CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT3_Pos)                     /*!< GPDMA C0CONTROL: PROT3 Mask         */
#define GPDMA_C0CONTROL_I_Pos                                 31                                                        /*!< GPDMA C0CONTROL: I Position         */
#define GPDMA_C0CONTROL_I_Msk                                 (0x01UL << GPDMA_C0CONTROL_I_Pos)                         /*!< GPDMA C0CONTROL: I Mask             */

// -------------------------------------  GPDMA_C0CONFIG  -----------------------------------------
#define GPDMA_C0CONFIG_E_Pos                                  0                                                         /*!< GPDMA C0CONFIG: E Position          */
#define GPDMA_C0CONFIG_E_Msk                                  (0x01UL << GPDMA_C0CONFIG_E_Pos)                          /*!< GPDMA C0CONFIG: E Mask              */
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C0CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C0CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C0CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C0CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C0CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C0CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C0CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C0CONFIG: FLOWCNTRL Position  */
#define GPDMA_C0CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C0CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C0CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C0CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C0CONFIG: IE Position         */
#define GPDMA_C0CONFIG_IE_Msk                                 (0x01UL << GPDMA_C0CONFIG_IE_Pos)                         /*!< GPDMA C0CONFIG: IE Mask             */
#define GPDMA_C0CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C0CONFIG: ITC Position        */
#define GPDMA_C0CONFIG_ITC_Msk                                (0x01UL << GPDMA_C0CONFIG_ITC_Pos)                        /*!< GPDMA C0CONFIG: ITC Mask            */
#define GPDMA_C0CONFIG_L_Pos                                  16                                                        /*!< GPDMA C0CONFIG: L Position          */
#define GPDMA_C0CONFIG_L_Msk                                  (0x01UL << GPDMA_C0CONFIG_L_Pos)                          /*!< GPDMA C0CONFIG: L Mask              */
#define GPDMA_C0CONFIG_A_Pos                                  17                                                        /*!< GPDMA C0CONFIG: A Position          */
#define GPDMA_C0CONFIG_A_Msk                                  (0x01UL << GPDMA_C0CONFIG_A_Pos)                          /*!< GPDMA C0CONFIG: A Mask              */
#define GPDMA_C0CONFIG_H_Pos                                  18                                                        /*!< GPDMA C0CONFIG: H Position          */
#define GPDMA_C0CONFIG_H_Msk                                  (0x01UL << GPDMA_C0CONFIG_H_Pos)                          /*!< GPDMA C0CONFIG: H Mask              */

// -------------------------------------  GPDMA_C1SRCADDR  ----------------------------------------
#define GPDMA_C1SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C1SRCADDR: SRCADDR Position   */
#define GPDMA_C1SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C1SRCADDR_SRCADDR_Pos)             /*!< GPDMA C1SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C1DESTADDR  ----------------------------------------
#define GPDMA_C1DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C1DESTADDR: DESTADDR Position */
#define GPDMA_C1DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C1DESTADDR_DESTADDR_Pos)           /*!< GPDMA C1DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C1LLI  ------------------------------------------
#define GPDMA_C1LLI_LM_Pos                                    0                                                         /*!< GPDMA C1LLI: LM Position            */
#define GPDMA_C1LLI_LM_Msk                                    (0x01UL << GPDMA_C1LLI_LM_Pos)                            /*!< GPDMA C1LLI: LM Mask                */
#define GPDMA_C1LLI_R_Pos                                     1                                                         /*!< GPDMA C1LLI: R Position             */
#define GPDMA_C1LLI_R_Msk                                     (0x01UL << GPDMA_C1LLI_R_Pos)                             /*!< GPDMA C1LLI: R Mask                 */
#define GPDMA_C1LLI_LLI_Pos                                   2                                                         /*!< GPDMA C1LLI: LLI Position           */
#define GPDMA_C1LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C1LLI_LLI_Pos)                     /*!< GPDMA C1LLI: LLI Mask               */

// -------------------------------------  GPDMA_C1CONTROL  ----------------------------------------
#define GPDMA_C1CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C1CONTROL: TRANSFERSIZE Position */
#define GPDMA_C1CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C1CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C1CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C1CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C1CONTROL: SBSIZE Position    */
#define GPDMA_C1CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C1CONTROL_SBSIZE_Pos)                    /*!< GPDMA C1CONTROL: SBSIZE Mask        */
#define GPDMA_C1CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C1CONTROL: DBSIZE Position    */
#define GPDMA_C1CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C1CONTROL_DBSIZE_Pos)                    /*!< GPDMA C1CONTROL: DBSIZE Mask        */
#define GPDMA_C1CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C1CONTROL: SWIDTH Position    */
#define GPDMA_C1CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C1CONTROL_SWIDTH_Pos)                    /*!< GPDMA C1CONTROL: SWIDTH Mask        */
#define GPDMA_C1CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C1CONTROL: DWIDTH Position    */
#define GPDMA_C1CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C1CONTROL_DWIDTH_Pos)                    /*!< GPDMA C1CONTROL: DWIDTH Mask        */
#define GPDMA_C1CONTROL_S_Pos                                 24                                                        /*!< GPDMA C1CONTROL: S Position         */
#define GPDMA_C1CONTROL_S_Msk                                 (0x01UL << GPDMA_C1CONTROL_S_Pos)                         /*!< GPDMA C1CONTROL: S Mask             */
#define GPDMA_C1CONTROL_D_Pos                                 25                                                        /*!< GPDMA C1CONTROL: D Position         */
#define GPDMA_C1CONTROL_D_Msk                                 (0x01UL << GPDMA_C1CONTROL_D_Pos)                         /*!< GPDMA C1CONTROL: D Mask             */
#define GPDMA_C1CONTROL_SI_Pos                                26                                                        /*!< GPDMA C1CONTROL: SI Position        */
#define GPDMA_C1CONTROL_SI_Msk                                (0x01UL << GPDMA_C1CONTROL_SI_Pos)                        /*!< GPDMA C1CONTROL: SI Mask            */
#define GPDMA_C1CONTROL_DI_Pos                                27                                                        /*!< GPDMA C1CONTROL: DI Position        */
#define GPDMA_C1CONTROL_DI_Msk                                (0x01UL << GPDMA_C1CONTROL_DI_Pos)                        /*!< GPDMA C1CONTROL: DI Mask            */
#define GPDMA_C1CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C1CONTROL: PROT1 Position     */
#define GPDMA_C1CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT1_Pos)                     /*!< GPDMA C1CONTROL: PROT1 Mask         */
#define GPDMA_C1CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C1CONTROL: PROT2 Position     */
#define GPDMA_C1CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT2_Pos)                     /*!< GPDMA C1CONTROL: PROT2 Mask         */
#define GPDMA_C1CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C1CONTROL: PROT3 Position     */
#define GPDMA_C1CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT3_Pos)                     /*!< GPDMA C1CONTROL: PROT3 Mask         */
#define GPDMA_C1CONTROL_I_Pos                                 31                                                        /*!< GPDMA C1CONTROL: I Position         */
#define GPDMA_C1CONTROL_I_Msk                                 (0x01UL << GPDMA_C1CONTROL_I_Pos)                         /*!< GPDMA C1CONTROL: I Mask             */

// -------------------------------------  GPDMA_C1CONFIG  -----------------------------------------
#define GPDMA_C1CONFIG_E_Pos                                  0                                                         /*!< GPDMA C1CONFIG: E Position          */
#define GPDMA_C1CONFIG_E_Msk                                  (0x01UL << GPDMA_C1CONFIG_E_Pos)                          /*!< GPDMA C1CONFIG: E Mask              */
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C1CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C1CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C1CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C1CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C1CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C1CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C1CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C1CONFIG: FLOWCNTRL Position  */
#define GPDMA_C1CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C1CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C1CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C1CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C1CONFIG: IE Position         */
#define GPDMA_C1CONFIG_IE_Msk                                 (0x01UL << GPDMA_C1CONFIG_IE_Pos)                         /*!< GPDMA C1CONFIG: IE Mask             */
#define GPDMA_C1CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C1CONFIG: ITC Position        */
#define GPDMA_C1CONFIG_ITC_Msk                                (0x01UL << GPDMA_C1CONFIG_ITC_Pos)                        /*!< GPDMA C1CONFIG: ITC Mask            */
#define GPDMA_C1CONFIG_L_Pos                                  16                                                        /*!< GPDMA C1CONFIG: L Position          */
#define GPDMA_C1CONFIG_L_Msk                                  (0x01UL << GPDMA_C1CONFIG_L_Pos)                          /*!< GPDMA C1CONFIG: L Mask              */
#define GPDMA_C1CONFIG_A_Pos                                  17                                                        /*!< GPDMA C1CONFIG: A Position          */
#define GPDMA_C1CONFIG_A_Msk                                  (0x01UL << GPDMA_C1CONFIG_A_Pos)                          /*!< GPDMA C1CONFIG: A Mask              */
#define GPDMA_C1CONFIG_H_Pos                                  18                                                        /*!< GPDMA C1CONFIG: H Position          */
#define GPDMA_C1CONFIG_H_Msk                                  (0x01UL << GPDMA_C1CONFIG_H_Pos)                          /*!< GPDMA C1CONFIG: H Mask              */

// -------------------------------------  GPDMA_C2SRCADDR  ----------------------------------------
#define GPDMA_C2SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C2SRCADDR: SRCADDR Position   */
#define GPDMA_C2SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C2SRCADDR_SRCADDR_Pos)             /*!< GPDMA C2SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C2DESTADDR  ----------------------------------------
#define GPDMA_C2DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C2DESTADDR: DESTADDR Position */
#define GPDMA_C2DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C2DESTADDR_DESTADDR_Pos)           /*!< GPDMA C2DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C2LLI  ------------------------------------------
#define GPDMA_C2LLI_LM_Pos                                    0                                                         /*!< GPDMA C2LLI: LM Position            */
#define GPDMA_C2LLI_LM_Msk                                    (0x01UL << GPDMA_C2LLI_LM_Pos)                            /*!< GPDMA C2LLI: LM Mask                */
#define GPDMA_C2LLI_R_Pos                                     1                                                         /*!< GPDMA C2LLI: R Position             */
#define GPDMA_C2LLI_R_Msk                                     (0x01UL << GPDMA_C2LLI_R_Pos)                             /*!< GPDMA C2LLI: R Mask                 */
#define GPDMA_C2LLI_LLI_Pos                                   2                                                         /*!< GPDMA C2LLI: LLI Position           */
#define GPDMA_C2LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C2LLI_LLI_Pos)                     /*!< GPDMA C2LLI: LLI Mask               */

// -------------------------------------  GPDMA_C2CONTROL  ----------------------------------------
#define GPDMA_C2CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C2CONTROL: TRANSFERSIZE Position */
#define GPDMA_C2CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C2CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C2CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C2CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C2CONTROL: SBSIZE Position    */
#define GPDMA_C2CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C2CONTROL_SBSIZE_Pos)                    /*!< GPDMA C2CONTROL: SBSIZE Mask        */
#define GPDMA_C2CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C2CONTROL: DBSIZE Position    */
#define GPDMA_C2CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C2CONTROL_DBSIZE_Pos)                    /*!< GPDMA C2CONTROL: DBSIZE Mask        */
#define GPDMA_C2CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C2CONTROL: SWIDTH Position    */
#define GPDMA_C2CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C2CONTROL_SWIDTH_Pos)                    /*!< GPDMA C2CONTROL: SWIDTH Mask        */
#define GPDMA_C2CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C2CONTROL: DWIDTH Position    */
#define GPDMA_C2CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C2CONTROL_DWIDTH_Pos)                    /*!< GPDMA C2CONTROL: DWIDTH Mask        */
#define GPDMA_C2CONTROL_S_Pos                                 24                                                        /*!< GPDMA C2CONTROL: S Position         */
#define GPDMA_C2CONTROL_S_Msk                                 (0x01UL << GPDMA_C2CONTROL_S_Pos)                         /*!< GPDMA C2CONTROL: S Mask             */
#define GPDMA_C2CONTROL_D_Pos                                 25                                                        /*!< GPDMA C2CONTROL: D Position         */
#define GPDMA_C2CONTROL_D_Msk                                 (0x01UL << GPDMA_C2CONTROL_D_Pos)                         /*!< GPDMA C2CONTROL: D Mask             */
#define GPDMA_C2CONTROL_SI_Pos                                26                                                        /*!< GPDMA C2CONTROL: SI Position        */
#define GPDMA_C2CONTROL_SI_Msk                                (0x01UL << GPDMA_C2CONTROL_SI_Pos)                        /*!< GPDMA C2CONTROL: SI Mask            */
#define GPDMA_C2CONTROL_DI_Pos                                27                                                        /*!< GPDMA C2CONTROL: DI Position        */
#define GPDMA_C2CONTROL_DI_Msk                                (0x01UL << GPDMA_C2CONTROL_DI_Pos)                        /*!< GPDMA C2CONTROL: DI Mask            */
#define GPDMA_C2CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C2CONTROL: PROT1 Position     */
#define GPDMA_C2CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT1_Pos)                     /*!< GPDMA C2CONTROL: PROT1 Mask         */
#define GPDMA_C2CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C2CONTROL: PROT2 Position     */
#define GPDMA_C2CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT2_Pos)                     /*!< GPDMA C2CONTROL: PROT2 Mask         */
#define GPDMA_C2CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C2CONTROL: PROT3 Position     */
#define GPDMA_C2CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT3_Pos)                     /*!< GPDMA C2CONTROL: PROT3 Mask         */
#define GPDMA_C2CONTROL_I_Pos                                 31                                                        /*!< GPDMA C2CONTROL: I Position         */
#define GPDMA_C2CONTROL_I_Msk                                 (0x01UL << GPDMA_C2CONTROL_I_Pos)                         /*!< GPDMA C2CONTROL: I Mask             */

// -------------------------------------  GPDMA_C2CONFIG  -----------------------------------------
#define GPDMA_C2CONFIG_E_Pos                                  0                                                         /*!< GPDMA C2CONFIG: E Position          */
#define GPDMA_C2CONFIG_E_Msk                                  (0x01UL << GPDMA_C2CONFIG_E_Pos)                          /*!< GPDMA C2CONFIG: E Mask              */
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C2CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C2CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C2CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C2CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C2CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C2CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C2CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C2CONFIG: FLOWCNTRL Position  */
#define GPDMA_C2CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C2CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C2CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C2CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C2CONFIG: IE Position         */
#define GPDMA_C2CONFIG_IE_Msk                                 (0x01UL << GPDMA_C2CONFIG_IE_Pos)                         /*!< GPDMA C2CONFIG: IE Mask             */
#define GPDMA_C2CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C2CONFIG: ITC Position        */
#define GPDMA_C2CONFIG_ITC_Msk                                (0x01UL << GPDMA_C2CONFIG_ITC_Pos)                        /*!< GPDMA C2CONFIG: ITC Mask            */
#define GPDMA_C2CONFIG_L_Pos                                  16                                                        /*!< GPDMA C2CONFIG: L Position          */
#define GPDMA_C2CONFIG_L_Msk                                  (0x01UL << GPDMA_C2CONFIG_L_Pos)                          /*!< GPDMA C2CONFIG: L Mask              */
#define GPDMA_C2CONFIG_A_Pos                                  17                                                        /*!< GPDMA C2CONFIG: A Position          */
#define GPDMA_C2CONFIG_A_Msk                                  (0x01UL << GPDMA_C2CONFIG_A_Pos)                          /*!< GPDMA C2CONFIG: A Mask              */
#define GPDMA_C2CONFIG_H_Pos                                  18                                                        /*!< GPDMA C2CONFIG: H Position          */
#define GPDMA_C2CONFIG_H_Msk                                  (0x01UL << GPDMA_C2CONFIG_H_Pos)                          /*!< GPDMA C2CONFIG: H Mask              */

// -------------------------------------  GPDMA_C3SRCADDR  ----------------------------------------
#define GPDMA_C3SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C3SRCADDR: SRCADDR Position   */
#define GPDMA_C3SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C3SRCADDR_SRCADDR_Pos)             /*!< GPDMA C3SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C3DESTADDR  ----------------------------------------
#define GPDMA_C3DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C3DESTADDR: DESTADDR Position */
#define GPDMA_C3DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C3DESTADDR_DESTADDR_Pos)           /*!< GPDMA C3DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C3LLI  ------------------------------------------
#define GPDMA_C3LLI_LM_Pos                                    0                                                         /*!< GPDMA C3LLI: LM Position            */
#define GPDMA_C3LLI_LM_Msk                                    (0x01UL << GPDMA_C3LLI_LM_Pos)                            /*!< GPDMA C3LLI: LM Mask                */
#define GPDMA_C3LLI_R_Pos                                     1                                                         /*!< GPDMA C3LLI: R Position             */
#define GPDMA_C3LLI_R_Msk                                     (0x01UL << GPDMA_C3LLI_R_Pos)                             /*!< GPDMA C3LLI: R Mask                 */
#define GPDMA_C3LLI_LLI_Pos                                   2                                                         /*!< GPDMA C3LLI: LLI Position           */
#define GPDMA_C3LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C3LLI_LLI_Pos)                     /*!< GPDMA C3LLI: LLI Mask               */

// -------------------------------------  GPDMA_C3CONTROL  ----------------------------------------
#define GPDMA_C3CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C3CONTROL: TRANSFERSIZE Position */
#define GPDMA_C3CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C3CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C3CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C3CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C3CONTROL: SBSIZE Position    */
#define GPDMA_C3CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C3CONTROL_SBSIZE_Pos)                    /*!< GPDMA C3CONTROL: SBSIZE Mask        */
#define GPDMA_C3CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C3CONTROL: DBSIZE Position    */
#define GPDMA_C3CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C3CONTROL_DBSIZE_Pos)                    /*!< GPDMA C3CONTROL: DBSIZE Mask        */
#define GPDMA_C3CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C3CONTROL: SWIDTH Position    */
#define GPDMA_C3CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C3CONTROL_SWIDTH_Pos)                    /*!< GPDMA C3CONTROL: SWIDTH Mask        */
#define GPDMA_C3CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C3CONTROL: DWIDTH Position    */
#define GPDMA_C3CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C3CONTROL_DWIDTH_Pos)                    /*!< GPDMA C3CONTROL: DWIDTH Mask        */
#define GPDMA_C3CONTROL_S_Pos                                 24                                                        /*!< GPDMA C3CONTROL: S Position         */
#define GPDMA_C3CONTROL_S_Msk                                 (0x01UL << GPDMA_C3CONTROL_S_Pos)                         /*!< GPDMA C3CONTROL: S Mask             */
#define GPDMA_C3CONTROL_D_Pos                                 25                                                        /*!< GPDMA C3CONTROL: D Position         */
#define GPDMA_C3CONTROL_D_Msk                                 (0x01UL << GPDMA_C3CONTROL_D_Pos)                         /*!< GPDMA C3CONTROL: D Mask             */
#define GPDMA_C3CONTROL_SI_Pos                                26                                                        /*!< GPDMA C3CONTROL: SI Position        */
#define GPDMA_C3CONTROL_SI_Msk                                (0x01UL << GPDMA_C3CONTROL_SI_Pos)                        /*!< GPDMA C3CONTROL: SI Mask            */
#define GPDMA_C3CONTROL_DI_Pos                                27                                                        /*!< GPDMA C3CONTROL: DI Position        */
#define GPDMA_C3CONTROL_DI_Msk                                (0x01UL << GPDMA_C3CONTROL_DI_Pos)                        /*!< GPDMA C3CONTROL: DI Mask            */
#define GPDMA_C3CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C3CONTROL: PROT1 Position     */
#define GPDMA_C3CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT1_Pos)                     /*!< GPDMA C3CONTROL: PROT1 Mask         */
#define GPDMA_C3CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C3CONTROL: PROT2 Position     */
#define GPDMA_C3CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT2_Pos)                     /*!< GPDMA C3CONTROL: PROT2 Mask         */
#define GPDMA_C3CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C3CONTROL: PROT3 Position     */
#define GPDMA_C3CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT3_Pos)                     /*!< GPDMA C3CONTROL: PROT3 Mask         */
#define GPDMA_C3CONTROL_I_Pos                                 31                                                        /*!< GPDMA C3CONTROL: I Position         */
#define GPDMA_C3CONTROL_I_Msk                                 (0x01UL << GPDMA_C3CONTROL_I_Pos)                         /*!< GPDMA C3CONTROL: I Mask             */

// -------------------------------------  GPDMA_C3CONFIG  -----------------------------------------
#define GPDMA_C3CONFIG_E_Pos                                  0                                                         /*!< GPDMA C3CONFIG: E Position          */
#define GPDMA_C3CONFIG_E_Msk                                  (0x01UL << GPDMA_C3CONFIG_E_Pos)                          /*!< GPDMA C3CONFIG: E Mask              */
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C3CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C3CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C3CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C3CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C3CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C3CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C3CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C3CONFIG: FLOWCNTRL Position  */
#define GPDMA_C3CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C3CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C3CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C3CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C3CONFIG: IE Position         */
#define GPDMA_C3CONFIG_IE_Msk                                 (0x01UL << GPDMA_C3CONFIG_IE_Pos)                         /*!< GPDMA C3CONFIG: IE Mask             */
#define GPDMA_C3CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C3CONFIG: ITC Position        */
#define GPDMA_C3CONFIG_ITC_Msk                                (0x01UL << GPDMA_C3CONFIG_ITC_Pos)                        /*!< GPDMA C3CONFIG: ITC Mask            */
#define GPDMA_C3CONFIG_L_Pos                                  16                                                        /*!< GPDMA C3CONFIG: L Position          */
#define GPDMA_C3CONFIG_L_Msk                                  (0x01UL << GPDMA_C3CONFIG_L_Pos)                          /*!< GPDMA C3CONFIG: L Mask              */
#define GPDMA_C3CONFIG_A_Pos                                  17                                                        /*!< GPDMA C3CONFIG: A Position          */
#define GPDMA_C3CONFIG_A_Msk                                  (0x01UL << GPDMA_C3CONFIG_A_Pos)                          /*!< GPDMA C3CONFIG: A Mask              */
#define GPDMA_C3CONFIG_H_Pos                                  18                                                        /*!< GPDMA C3CONFIG: H Position          */
#define GPDMA_C3CONFIG_H_Msk                                  (0x01UL << GPDMA_C3CONFIG_H_Pos)                          /*!< GPDMA C3CONFIG: H Mask              */

// -------------------------------------  GPDMA_C4SRCADDR  ----------------------------------------
#define GPDMA_C4SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C4SRCADDR: SRCADDR Position   */
#define GPDMA_C4SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C4SRCADDR_SRCADDR_Pos)             /*!< GPDMA C4SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C4DESTADDR  ----------------------------------------
#define GPDMA_C4DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C4DESTADDR: DESTADDR Position */
#define GPDMA_C4DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C4DESTADDR_DESTADDR_Pos)           /*!< GPDMA C4DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C4LLI  ------------------------------------------
#define GPDMA_C4LLI_LM_Pos                                    0                                                         /*!< GPDMA C4LLI: LM Position            */
#define GPDMA_C4LLI_LM_Msk                                    (0x01UL << GPDMA_C4LLI_LM_Pos)                            /*!< GPDMA C4LLI: LM Mask                */
#define GPDMA_C4LLI_R_Pos                                     1                                                         /*!< GPDMA C4LLI: R Position             */
#define GPDMA_C4LLI_R_Msk                                     (0x01UL << GPDMA_C4LLI_R_Pos)                             /*!< GPDMA C4LLI: R Mask                 */
#define GPDMA_C4LLI_LLI_Pos                                   2                                                         /*!< GPDMA C4LLI: LLI Position           */
#define GPDMA_C4LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C4LLI_LLI_Pos)                     /*!< GPDMA C4LLI: LLI Mask               */

// -------------------------------------  GPDMA_C4CONTROL  ----------------------------------------
#define GPDMA_C4CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C4CONTROL: TRANSFERSIZE Position */
#define GPDMA_C4CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C4CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C4CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C4CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C4CONTROL: SBSIZE Position    */
#define GPDMA_C4CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C4CONTROL_SBSIZE_Pos)                    /*!< GPDMA C4CONTROL: SBSIZE Mask        */
#define GPDMA_C4CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C4CONTROL: DBSIZE Position    */
#define GPDMA_C4CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C4CONTROL_DBSIZE_Pos)                    /*!< GPDMA C4CONTROL: DBSIZE Mask        */
#define GPDMA_C4CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C4CONTROL: SWIDTH Position    */
#define GPDMA_C4CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C4CONTROL_SWIDTH_Pos)                    /*!< GPDMA C4CONTROL: SWIDTH Mask        */
#define GPDMA_C4CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C4CONTROL: DWIDTH Position    */
#define GPDMA_C4CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C4CONTROL_DWIDTH_Pos)                    /*!< GPDMA C4CONTROL: DWIDTH Mask        */
#define GPDMA_C4CONTROL_S_Pos                                 24                                                        /*!< GPDMA C4CONTROL: S Position         */
#define GPDMA_C4CONTROL_S_Msk                                 (0x01UL << GPDMA_C4CONTROL_S_Pos)                         /*!< GPDMA C4CONTROL: S Mask             */
#define GPDMA_C4CONTROL_D_Pos                                 25                                                        /*!< GPDMA C4CONTROL: D Position         */
#define GPDMA_C4CONTROL_D_Msk                                 (0x01UL << GPDMA_C4CONTROL_D_Pos)                         /*!< GPDMA C4CONTROL: D Mask             */
#define GPDMA_C4CONTROL_SI_Pos                                26                                                        /*!< GPDMA C4CONTROL: SI Position        */
#define GPDMA_C4CONTROL_SI_Msk                                (0x01UL << GPDMA_C4CONTROL_SI_Pos)                        /*!< GPDMA C4CONTROL: SI Mask            */
#define GPDMA_C4CONTROL_DI_Pos                                27                                                        /*!< GPDMA C4CONTROL: DI Position        */
#define GPDMA_C4CONTROL_DI_Msk                                (0x01UL << GPDMA_C4CONTROL_DI_Pos)                        /*!< GPDMA C4CONTROL: DI Mask            */
#define GPDMA_C4CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C4CONTROL: PROT1 Position     */
#define GPDMA_C4CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT1_Pos)                     /*!< GPDMA C4CONTROL: PROT1 Mask         */
#define GPDMA_C4CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C4CONTROL: PROT2 Position     */
#define GPDMA_C4CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT2_Pos)                     /*!< GPDMA C4CONTROL: PROT2 Mask         */
#define GPDMA_C4CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C4CONTROL: PROT3 Position     */
#define GPDMA_C4CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT3_Pos)                     /*!< GPDMA C4CONTROL: PROT3 Mask         */
#define GPDMA_C4CONTROL_I_Pos                                 31                                                        /*!< GPDMA C4CONTROL: I Position         */
#define GPDMA_C4CONTROL_I_Msk                                 (0x01UL << GPDMA_C4CONTROL_I_Pos)                         /*!< GPDMA C4CONTROL: I Mask             */

// -------------------------------------  GPDMA_C4CONFIG  -----------------------------------------
#define GPDMA_C4CONFIG_E_Pos                                  0                                                         /*!< GPDMA C4CONFIG: E Position          */
#define GPDMA_C4CONFIG_E_Msk                                  (0x01UL << GPDMA_C4CONFIG_E_Pos)                          /*!< GPDMA C4CONFIG: E Mask              */
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C4CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C4CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C4CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C4CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C4CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C4CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C4CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C4CONFIG: FLOWCNTRL Position  */
#define GPDMA_C4CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C4CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C4CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C4CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C4CONFIG: IE Position         */
#define GPDMA_C4CONFIG_IE_Msk                                 (0x01UL << GPDMA_C4CONFIG_IE_Pos)                         /*!< GPDMA C4CONFIG: IE Mask             */
#define GPDMA_C4CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C4CONFIG: ITC Position        */
#define GPDMA_C4CONFIG_ITC_Msk                                (0x01UL << GPDMA_C4CONFIG_ITC_Pos)                        /*!< GPDMA C4CONFIG: ITC Mask            */
#define GPDMA_C4CONFIG_L_Pos                                  16                                                        /*!< GPDMA C4CONFIG: L Position          */
#define GPDMA_C4CONFIG_L_Msk                                  (0x01UL << GPDMA_C4CONFIG_L_Pos)                          /*!< GPDMA C4CONFIG: L Mask              */
#define GPDMA_C4CONFIG_A_Pos                                  17                                                        /*!< GPDMA C4CONFIG: A Position          */
#define GPDMA_C4CONFIG_A_Msk                                  (0x01UL << GPDMA_C4CONFIG_A_Pos)                          /*!< GPDMA C4CONFIG: A Mask              */
#define GPDMA_C4CONFIG_H_Pos                                  18                                                        /*!< GPDMA C4CONFIG: H Position          */
#define GPDMA_C4CONFIG_H_Msk                                  (0x01UL << GPDMA_C4CONFIG_H_Pos)                          /*!< GPDMA C4CONFIG: H Mask              */

// -------------------------------------  GPDMA_C5SRCADDR  ----------------------------------------
#define GPDMA_C5SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C5SRCADDR: SRCADDR Position   */
#define GPDMA_C5SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C5SRCADDR_SRCADDR_Pos)             /*!< GPDMA C5SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C5DESTADDR  ----------------------------------------
#define GPDMA_C5DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C5DESTADDR: DESTADDR Position */
#define GPDMA_C5DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C5DESTADDR_DESTADDR_Pos)           /*!< GPDMA C5DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C5LLI  ------------------------------------------
#define GPDMA_C5LLI_LM_Pos                                    0                                                         /*!< GPDMA C5LLI: LM Position            */
#define GPDMA_C5LLI_LM_Msk                                    (0x01UL << GPDMA_C5LLI_LM_Pos)                            /*!< GPDMA C5LLI: LM Mask                */
#define GPDMA_C5LLI_R_Pos                                     1                                                         /*!< GPDMA C5LLI: R Position             */
#define GPDMA_C5LLI_R_Msk                                     (0x01UL << GPDMA_C5LLI_R_Pos)                             /*!< GPDMA C5LLI: R Mask                 */
#define GPDMA_C5LLI_LLI_Pos                                   2                                                         /*!< GPDMA C5LLI: LLI Position           */
#define GPDMA_C5LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C5LLI_LLI_Pos)                     /*!< GPDMA C5LLI: LLI Mask               */

// -------------------------------------  GPDMA_C5CONTROL  ----------------------------------------
#define GPDMA_C5CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C5CONTROL: TRANSFERSIZE Position */
#define GPDMA_C5CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C5CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C5CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C5CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C5CONTROL: SBSIZE Position    */
#define GPDMA_C5CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C5CONTROL_SBSIZE_Pos)                    /*!< GPDMA C5CONTROL: SBSIZE Mask        */
#define GPDMA_C5CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C5CONTROL: DBSIZE Position    */
#define GPDMA_C5CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C5CONTROL_DBSIZE_Pos)                    /*!< GPDMA C5CONTROL: DBSIZE Mask        */
#define GPDMA_C5CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C5CONTROL: SWIDTH Position    */
#define GPDMA_C5CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C5CONTROL_SWIDTH_Pos)                    /*!< GPDMA C5CONTROL: SWIDTH Mask        */
#define GPDMA_C5CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C5CONTROL: DWIDTH Position    */
#define GPDMA_C5CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C5CONTROL_DWIDTH_Pos)                    /*!< GPDMA C5CONTROL: DWIDTH Mask        */
#define GPDMA_C5CONTROL_S_Pos                                 24                                                        /*!< GPDMA C5CONTROL: S Position         */
#define GPDMA_C5CONTROL_S_Msk                                 (0x01UL << GPDMA_C5CONTROL_S_Pos)                         /*!< GPDMA C5CONTROL: S Mask             */
#define GPDMA_C5CONTROL_D_Pos                                 25                                                        /*!< GPDMA C5CONTROL: D Position         */
#define GPDMA_C5CONTROL_D_Msk                                 (0x01UL << GPDMA_C5CONTROL_D_Pos)                         /*!< GPDMA C5CONTROL: D Mask             */
#define GPDMA_C5CONTROL_SI_Pos                                26                                                        /*!< GPDMA C5CONTROL: SI Position        */
#define GPDMA_C5CONTROL_SI_Msk                                (0x01UL << GPDMA_C5CONTROL_SI_Pos)                        /*!< GPDMA C5CONTROL: SI Mask            */
#define GPDMA_C5CONTROL_DI_Pos                                27                                                        /*!< GPDMA C5CONTROL: DI Position        */
#define GPDMA_C5CONTROL_DI_Msk                                (0x01UL << GPDMA_C5CONTROL_DI_Pos)                        /*!< GPDMA C5CONTROL: DI Mask            */
#define GPDMA_C5CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C5CONTROL: PROT1 Position     */
#define GPDMA_C5CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT1_Pos)                     /*!< GPDMA C5CONTROL: PROT1 Mask         */
#define GPDMA_C5CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C5CONTROL: PROT2 Position     */
#define GPDMA_C5CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT2_Pos)                     /*!< GPDMA C5CONTROL: PROT2 Mask         */
#define GPDMA_C5CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C5CONTROL: PROT3 Position     */
#define GPDMA_C5CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT3_Pos)                     /*!< GPDMA C5CONTROL: PROT3 Mask         */
#define GPDMA_C5CONTROL_I_Pos                                 31                                                        /*!< GPDMA C5CONTROL: I Position         */
#define GPDMA_C5CONTROL_I_Msk                                 (0x01UL << GPDMA_C5CONTROL_I_Pos)                         /*!< GPDMA C5CONTROL: I Mask             */

// -------------------------------------  GPDMA_C5CONFIG  -----------------------------------------
#define GPDMA_C5CONFIG_E_Pos                                  0                                                         /*!< GPDMA C5CONFIG: E Position          */
#define GPDMA_C5CONFIG_E_Msk                                  (0x01UL << GPDMA_C5CONFIG_E_Pos)                          /*!< GPDMA C5CONFIG: E Mask              */
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C5CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C5CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C5CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C5CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C5CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C5CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C5CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C5CONFIG: FLOWCNTRL Position  */
#define GPDMA_C5CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C5CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C5CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C5CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C5CONFIG: IE Position         */
#define GPDMA_C5CONFIG_IE_Msk                                 (0x01UL << GPDMA_C5CONFIG_IE_Pos)                         /*!< GPDMA C5CONFIG: IE Mask             */
#define GPDMA_C5CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C5CONFIG: ITC Position        */
#define GPDMA_C5CONFIG_ITC_Msk                                (0x01UL << GPDMA_C5CONFIG_ITC_Pos)                        /*!< GPDMA C5CONFIG: ITC Mask            */
#define GPDMA_C5CONFIG_L_Pos                                  16                                                        /*!< GPDMA C5CONFIG: L Position          */
#define GPDMA_C5CONFIG_L_Msk                                  (0x01UL << GPDMA_C5CONFIG_L_Pos)                          /*!< GPDMA C5CONFIG: L Mask              */
#define GPDMA_C5CONFIG_A_Pos                                  17                                                        /*!< GPDMA C5CONFIG: A Position          */
#define GPDMA_C5CONFIG_A_Msk                                  (0x01UL << GPDMA_C5CONFIG_A_Pos)                          /*!< GPDMA C5CONFIG: A Mask              */
#define GPDMA_C5CONFIG_H_Pos                                  18                                                        /*!< GPDMA C5CONFIG: H Position          */
#define GPDMA_C5CONFIG_H_Msk                                  (0x01UL << GPDMA_C5CONFIG_H_Pos)                          /*!< GPDMA C5CONFIG: H Mask              */

// -------------------------------------  GPDMA_C6SRCADDR  ----------------------------------------
#define GPDMA_C6SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C6SRCADDR: SRCADDR Position   */
#define GPDMA_C6SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C6SRCADDR_SRCADDR_Pos)             /*!< GPDMA C6SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C6DESTADDR  ----------------------------------------
#define GPDMA_C6DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C6DESTADDR: DESTADDR Position */
#define GPDMA_C6DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C6DESTADDR_DESTADDR_Pos)           /*!< GPDMA C6DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C6LLI  ------------------------------------------
#define GPDMA_C6LLI_LM_Pos                                    0                                                         /*!< GPDMA C6LLI: LM Position            */
#define GPDMA_C6LLI_LM_Msk                                    (0x01UL << GPDMA_C6LLI_LM_Pos)                            /*!< GPDMA C6LLI: LM Mask                */
#define GPDMA_C6LLI_R_Pos                                     1                                                         /*!< GPDMA C6LLI: R Position             */
#define GPDMA_C6LLI_R_Msk                                     (0x01UL << GPDMA_C6LLI_R_Pos)                             /*!< GPDMA C6LLI: R Mask                 */
#define GPDMA_C6LLI_LLI_Pos                                   2                                                         /*!< GPDMA C6LLI: LLI Position           */
#define GPDMA_C6LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C6LLI_LLI_Pos)                     /*!< GPDMA C6LLI: LLI Mask               */

// -------------------------------------  GPDMA_C6CONTROL  ----------------------------------------
#define GPDMA_C6CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C6CONTROL: TRANSFERSIZE Position */
#define GPDMA_C6CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C6CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C6CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C6CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C6CONTROL: SBSIZE Position    */
#define GPDMA_C6CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C6CONTROL_SBSIZE_Pos)                    /*!< GPDMA C6CONTROL: SBSIZE Mask        */
#define GPDMA_C6CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C6CONTROL: DBSIZE Position    */
#define GPDMA_C6CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C6CONTROL_DBSIZE_Pos)                    /*!< GPDMA C6CONTROL: DBSIZE Mask        */
#define GPDMA_C6CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C6CONTROL: SWIDTH Position    */
#define GPDMA_C6CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C6CONTROL_SWIDTH_Pos)                    /*!< GPDMA C6CONTROL: SWIDTH Mask        */
#define GPDMA_C6CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C6CONTROL: DWIDTH Position    */
#define GPDMA_C6CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C6CONTROL_DWIDTH_Pos)                    /*!< GPDMA C6CONTROL: DWIDTH Mask        */
#define GPDMA_C6CONTROL_S_Pos                                 24                                                        /*!< GPDMA C6CONTROL: S Position         */
#define GPDMA_C6CONTROL_S_Msk                                 (0x01UL << GPDMA_C6CONTROL_S_Pos)                         /*!< GPDMA C6CONTROL: S Mask             */
#define GPDMA_C6CONTROL_D_Pos                                 25                                                        /*!< GPDMA C6CONTROL: D Position         */
#define GPDMA_C6CONTROL_D_Msk                                 (0x01UL << GPDMA_C6CONTROL_D_Pos)                         /*!< GPDMA C6CONTROL: D Mask             */
#define GPDMA_C6CONTROL_SI_Pos                                26                                                        /*!< GPDMA C6CONTROL: SI Position        */
#define GPDMA_C6CONTROL_SI_Msk                                (0x01UL << GPDMA_C6CONTROL_SI_Pos)                        /*!< GPDMA C6CONTROL: SI Mask            */
#define GPDMA_C6CONTROL_DI_Pos                                27                                                        /*!< GPDMA C6CONTROL: DI Position        */
#define GPDMA_C6CONTROL_DI_Msk                                (0x01UL << GPDMA_C6CONTROL_DI_Pos)                        /*!< GPDMA C6CONTROL: DI Mask            */
#define GPDMA_C6CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C6CONTROL: PROT1 Position     */
#define GPDMA_C6CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT1_Pos)                     /*!< GPDMA C6CONTROL: PROT1 Mask         */
#define GPDMA_C6CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C6CONTROL: PROT2 Position     */
#define GPDMA_C6CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT2_Pos)                     /*!< GPDMA C6CONTROL: PROT2 Mask         */
#define GPDMA_C6CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C6CONTROL: PROT3 Position     */
#define GPDMA_C6CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT3_Pos)                     /*!< GPDMA C6CONTROL: PROT3 Mask         */
#define GPDMA_C6CONTROL_I_Pos                                 31                                                        /*!< GPDMA C6CONTROL: I Position         */
#define GPDMA_C6CONTROL_I_Msk                                 (0x01UL << GPDMA_C6CONTROL_I_Pos)                         /*!< GPDMA C6CONTROL: I Mask             */

// -------------------------------------  GPDMA_C6CONFIG  -----------------------------------------
#define GPDMA_C6CONFIG_E_Pos                                  0                                                         /*!< GPDMA C6CONFIG: E Position          */
#define GPDMA_C6CONFIG_E_Msk                                  (0x01UL << GPDMA_C6CONFIG_E_Pos)                          /*!< GPDMA C6CONFIG: E Mask              */
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C6CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C6CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C6CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C6CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C6CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C6CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C6CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C6CONFIG: FLOWCNTRL Position  */
#define GPDMA_C6CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C6CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C6CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C6CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C6CONFIG: IE Position         */
#define GPDMA_C6CONFIG_IE_Msk                                 (0x01UL << GPDMA_C6CONFIG_IE_Pos)                         /*!< GPDMA C6CONFIG: IE Mask             */
#define GPDMA_C6CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C6CONFIG: ITC Position        */
#define GPDMA_C6CONFIG_ITC_Msk                                (0x01UL << GPDMA_C6CONFIG_ITC_Pos)                        /*!< GPDMA C6CONFIG: ITC Mask            */
#define GPDMA_C6CONFIG_L_Pos                                  16                                                        /*!< GPDMA C6CONFIG: L Position          */
#define GPDMA_C6CONFIG_L_Msk                                  (0x01UL << GPDMA_C6CONFIG_L_Pos)                          /*!< GPDMA C6CONFIG: L Mask              */
#define GPDMA_C6CONFIG_A_Pos                                  17                                                        /*!< GPDMA C6CONFIG: A Position          */
#define GPDMA_C6CONFIG_A_Msk                                  (0x01UL << GPDMA_C6CONFIG_A_Pos)                          /*!< GPDMA C6CONFIG: A Mask              */
#define GPDMA_C6CONFIG_H_Pos                                  18                                                        /*!< GPDMA C6CONFIG: H Position          */
#define GPDMA_C6CONFIG_H_Msk                                  (0x01UL << GPDMA_C6CONFIG_H_Pos)                          /*!< GPDMA C6CONFIG: H Mask              */

// -------------------------------------  GPDMA_C7SRCADDR  ----------------------------------------
#define GPDMA_C7SRCADDR_SRCADDR_Pos                           0                                                         /*!< GPDMA C7SRCADDR: SRCADDR Position   */
#define GPDMA_C7SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C7SRCADDR_SRCADDR_Pos)             /*!< GPDMA C7SRCADDR: SRCADDR Mask       */

// ------------------------------------  GPDMA_C7DESTADDR  ----------------------------------------
#define GPDMA_C7DESTADDR_DESTADDR_Pos                         0                                                         /*!< GPDMA C7DESTADDR: DESTADDR Position */
#define GPDMA_C7DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C7DESTADDR_DESTADDR_Pos)           /*!< GPDMA C7DESTADDR: DESTADDR Mask     */

// ---------------------------------------  GPDMA_C7LLI  ------------------------------------------
#define GPDMA_C7LLI_LM_Pos                                    0                                                         /*!< GPDMA C7LLI: LM Position            */
#define GPDMA_C7LLI_LM_Msk                                    (0x01UL << GPDMA_C7LLI_LM_Pos)                            /*!< GPDMA C7LLI: LM Mask                */
#define GPDMA_C7LLI_R_Pos                                     1                                                         /*!< GPDMA C7LLI: R Position             */
#define GPDMA_C7LLI_R_Msk                                     (0x01UL << GPDMA_C7LLI_R_Pos)                             /*!< GPDMA C7LLI: R Mask                 */
#define GPDMA_C7LLI_LLI_Pos                                   2                                                         /*!< GPDMA C7LLI: LLI Position           */
#define GPDMA_C7LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C7LLI_LLI_Pos)                     /*!< GPDMA C7LLI: LLI Mask               */

// -------------------------------------  GPDMA_C7CONTROL  ----------------------------------------
#define GPDMA_C7CONTROL_TRANSFERSIZE_Pos                      0                                                         /*!< GPDMA C7CONTROL: TRANSFERSIZE Position */
#define GPDMA_C7CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C7CONTROL_TRANSFERSIZE_Pos)        /*!< GPDMA C7CONTROL: TRANSFERSIZE Mask  */
#define GPDMA_C7CONTROL_SBSIZE_Pos                            12                                                        /*!< GPDMA C7CONTROL: SBSIZE Position    */
#define GPDMA_C7CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C7CONTROL_SBSIZE_Pos)                    /*!< GPDMA C7CONTROL: SBSIZE Mask        */
#define GPDMA_C7CONTROL_DBSIZE_Pos                            15                                                        /*!< GPDMA C7CONTROL: DBSIZE Position    */
#define GPDMA_C7CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C7CONTROL_DBSIZE_Pos)                    /*!< GPDMA C7CONTROL: DBSIZE Mask        */
#define GPDMA_C7CONTROL_SWIDTH_Pos                            18                                                        /*!< GPDMA C7CONTROL: SWIDTH Position    */
#define GPDMA_C7CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C7CONTROL_SWIDTH_Pos)                    /*!< GPDMA C7CONTROL: SWIDTH Mask        */
#define GPDMA_C7CONTROL_DWIDTH_Pos                            21                                                        /*!< GPDMA C7CONTROL: DWIDTH Position    */
#define GPDMA_C7CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C7CONTROL_DWIDTH_Pos)                    /*!< GPDMA C7CONTROL: DWIDTH Mask        */
#define GPDMA_C7CONTROL_S_Pos                                 24                                                        /*!< GPDMA C7CONTROL: S Position         */
#define GPDMA_C7CONTROL_S_Msk                                 (0x01UL << GPDMA_C7CONTROL_S_Pos)                         /*!< GPDMA C7CONTROL: S Mask             */
#define GPDMA_C7CONTROL_D_Pos                                 25                                                        /*!< GPDMA C7CONTROL: D Position         */
#define GPDMA_C7CONTROL_D_Msk                                 (0x01UL << GPDMA_C7CONTROL_D_Pos)                         /*!< GPDMA C7CONTROL: D Mask             */
#define GPDMA_C7CONTROL_SI_Pos                                26                                                        /*!< GPDMA C7CONTROL: SI Position        */
#define GPDMA_C7CONTROL_SI_Msk                                (0x01UL << GPDMA_C7CONTROL_SI_Pos)                        /*!< GPDMA C7CONTROL: SI Mask            */
#define GPDMA_C7CONTROL_DI_Pos                                27                                                        /*!< GPDMA C7CONTROL: DI Position        */
#define GPDMA_C7CONTROL_DI_Msk                                (0x01UL << GPDMA_C7CONTROL_DI_Pos)                        /*!< GPDMA C7CONTROL: DI Mask            */
#define GPDMA_C7CONTROL_PROT1_Pos                             28                                                        /*!< GPDMA C7CONTROL: PROT1 Position     */
#define GPDMA_C7CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT1_Pos)                     /*!< GPDMA C7CONTROL: PROT1 Mask         */
#define GPDMA_C7CONTROL_PROT2_Pos                             29                                                        /*!< GPDMA C7CONTROL: PROT2 Position     */
#define GPDMA_C7CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT2_Pos)                     /*!< GPDMA C7CONTROL: PROT2 Mask         */
#define GPDMA_C7CONTROL_PROT3_Pos                             30                                                        /*!< GPDMA C7CONTROL: PROT3 Position     */
#define GPDMA_C7CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT3_Pos)                     /*!< GPDMA C7CONTROL: PROT3 Mask         */
#define GPDMA_C7CONTROL_I_Pos                                 31                                                        /*!< GPDMA C7CONTROL: I Position         */
#define GPDMA_C7CONTROL_I_Msk                                 (0x01UL << GPDMA_C7CONTROL_I_Pos)                         /*!< GPDMA C7CONTROL: I Mask             */

// -------------------------------------  GPDMA_C7CONFIG  -----------------------------------------
#define GPDMA_C7CONFIG_E_Pos                                  0                                                         /*!< GPDMA C7CONFIG: E Position          */
#define GPDMA_C7CONFIG_E_Msk                                  (0x01UL << GPDMA_C7CONFIG_E_Pos)                          /*!< GPDMA C7CONFIG: E Mask              */
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Pos                      1                                                         /*!< GPDMA C7CONFIG: SRCPERIPHERAL Position */
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C7CONFIG_SRCPERIPHERAL_Pos)              /*!< GPDMA C7CONFIG: SRCPERIPHERAL Mask  */
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Pos                     6                                                         /*!< GPDMA C7CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C7CONFIG_DESTPERIPHERAL_Pos)             /*!< GPDMA C7CONFIG: DESTPERIPHERAL Mask */
#define GPDMA_C7CONFIG_FLOWCNTRL_Pos                          11                                                        /*!< GPDMA C7CONFIG: FLOWCNTRL Position  */
#define GPDMA_C7CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C7CONFIG_FLOWCNTRL_Pos)                  /*!< GPDMA C7CONFIG: FLOWCNTRL Mask      */
#define GPDMA_C7CONFIG_IE_Pos                                 14                                                        /*!< GPDMA C7CONFIG: IE Position         */
#define GPDMA_C7CONFIG_IE_Msk                                 (0x01UL << GPDMA_C7CONFIG_IE_Pos)                         /*!< GPDMA C7CONFIG: IE Mask             */
#define GPDMA_C7CONFIG_ITC_Pos                                15                                                        /*!< GPDMA C7CONFIG: ITC Position        */
#define GPDMA_C7CONFIG_ITC_Msk                                (0x01UL << GPDMA_C7CONFIG_ITC_Pos)                        /*!< GPDMA C7CONFIG: ITC Mask            */
#define GPDMA_C7CONFIG_L_Pos                                  16                                                        /*!< GPDMA C7CONFIG: L Position          */
#define GPDMA_C7CONFIG_L_Msk                                  (0x01UL << GPDMA_C7CONFIG_L_Pos)                          /*!< GPDMA C7CONFIG: L Mask              */
#define GPDMA_C7CONFIG_A_Pos                                  17                                                        /*!< GPDMA C7CONFIG: A Position          */
#define GPDMA_C7CONFIG_A_Msk                                  (0x01UL << GPDMA_C7CONFIG_A_Pos)                          /*!< GPDMA C7CONFIG: A Mask              */
#define GPDMA_C7CONFIG_H_Pos                                  18                                                        /*!< GPDMA C7CONFIG: H Position          */
#define GPDMA_C7CONFIG_H_Msk                                  (0x01UL << GPDMA_C7CONFIG_H_Pos)                          /*!< GPDMA C7CONFIG: H Mask              */


// ------------------------------------------------------------------------------------------------
// -----                                 SDMMC Position & Mask                                -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  SDMMC_CTRL  -------------------------------------------
#define SDMMC_CTRL_CONTROLLER_RESET_Pos                       0                                                         /*!< SDMMC CTRL: CONTROLLER_RESET Position */
#define SDMMC_CTRL_CONTROLLER_RESET_Msk                       (0x01UL << SDMMC_CTRL_CONTROLLER_RESET_Pos)               /*!< SDMMC CTRL: CONTROLLER_RESET Mask   */
#define SDMMC_CTRL_FIFO_RESET_Pos                             1                                                         /*!< SDMMC CTRL: FIFO_RESET Position     */
#define SDMMC_CTRL_FIFO_RESET_Msk                             (0x01UL << SDMMC_CTRL_FIFO_RESET_Pos)                     /*!< SDMMC CTRL: FIFO_RESET Mask         */
#define SDMMC_CTRL_DMA_RESET_Pos                              2                                                         /*!< SDMMC CTRL: DMA_RESET Position      */
#define SDMMC_CTRL_DMA_RESET_Msk                              (0x01UL << SDMMC_CTRL_DMA_RESET_Pos)                      /*!< SDMMC CTRL: DMA_RESET Mask          */
#define SDMMC_CTRL_INT_ENABLE_Pos                             4                                                         /*!< SDMMC CTRL: INT_ENABLE Position     */
#define SDMMC_CTRL_INT_ENABLE_Msk                             (0x01UL << SDMMC_CTRL_INT_ENABLE_Pos)                     /*!< SDMMC CTRL: INT_ENABLE Mask         */
#define SDMMC_CTRL_DMA_ENABLE_Pos                             5                                                         /*!< SDMMC CTRL: DMA_ENABLE Position     */
#define SDMMC_CTRL_DMA_ENABLE_Msk                             (0x01UL << SDMMC_CTRL_DMA_ENABLE_Pos)                     /*!< SDMMC CTRL: DMA_ENABLE Mask         */
#define SDMMC_CTRL_READ_WAIT_Pos                              6                                                         /*!< SDMMC CTRL: READ_WAIT Position      */
#define SDMMC_CTRL_READ_WAIT_Msk                              (0x01UL << SDMMC_CTRL_READ_WAIT_Pos)                      /*!< SDMMC CTRL: READ_WAIT Mask          */
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos                      7                                                         /*!< SDMMC CTRL: SEND_IRQ_RESPONSE Position */
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Msk                      (0x01UL << SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos)              /*!< SDMMC CTRL: SEND_IRQ_RESPONSE Mask  */
#define SDMMC_CTRL_ABORT_READ_DATA_Pos                        8                                                         /*!< SDMMC CTRL: ABORT_READ_DATA Position */
#define SDMMC_CTRL_ABORT_READ_DATA_Msk                        (0x01UL << SDMMC_CTRL_ABORT_READ_DATA_Pos)                /*!< SDMMC CTRL: ABORT_READ_DATA Mask    */
#define SDMMC_CTRL_SEND_CCSD_Pos                              9                                                         /*!< SDMMC CTRL: SEND_CCSD Position      */
#define SDMMC_CTRL_SEND_CCSD_Msk                              (0x01UL << SDMMC_CTRL_SEND_CCSD_Pos)                      /*!< SDMMC CTRL: SEND_CCSD Mask          */
#define SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Pos                    10                                                        /*!< SDMMC CTRL: SEND_AUTO_STOP_CCSD Position */
#define SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Msk                    (0x01UL << SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Pos)            /*!< SDMMC CTRL: SEND_AUTO_STOP_CCSD Mask */
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos          11                                                        /*!< SDMMC CTRL: CEATA_DEVICE_INTERRUPT_STATUS Position */
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Msk          (0x01UL << SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos)  /*!< SDMMC CTRL: CEATA_DEVICE_INTERRUPT_STATUS Mask */
#define SDMMC_CTRL_CARD_VOLTAGE_A_Pos                         16                                                        /*!< SDMMC CTRL: CARD_VOLTAGE_A Position */
#define SDMMC_CTRL_CARD_VOLTAGE_A_Msk                         (0x0fUL << SDMMC_CTRL_CARD_VOLTAGE_A_Pos)                 /*!< SDMMC CTRL: CARD_VOLTAGE_A Mask     */
#define SDMMC_CTRL_CARD_VOLTAGE_B_Pos                         20                                                        /*!< SDMMC CTRL: CARD_VOLTAGE_B Position */
#define SDMMC_CTRL_CARD_VOLTAGE_B_Msk                         (0x0fUL << SDMMC_CTRL_CARD_VOLTAGE_B_Pos)                 /*!< SDMMC CTRL: CARD_VOLTAGE_B Mask     */
#define SDMMC_CTRL_ENABLE_OD_PULLUP_Pos                       24                                                        /*!< SDMMC CTRL: ENABLE_OD_PULLUP Position */
#define SDMMC_CTRL_ENABLE_OD_PULLUP_Msk                       (0x01UL << SDMMC_CTRL_ENABLE_OD_PULLUP_Pos)               /*!< SDMMC CTRL: ENABLE_OD_PULLUP Mask   */
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Pos                      25                                                        /*!< SDMMC CTRL: USE_INTERNAL_DMAC Position */
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Msk                      (0x01UL << SDMMC_CTRL_USE_INTERNAL_DMAC_Pos)              /*!< SDMMC CTRL: USE_INTERNAL_DMAC Mask  */

// ---------------------------------------  SDMMC_PWREN  ------------------------------------------
#define SDMMC_PWREN_POWER_ENABLE_Pos                          0                                                         /*!< SDMMC PWREN: POWER_ENABLE Position  */
#define SDMMC_PWREN_POWER_ENABLE_Msk                          (0x3fffffffUL << SDMMC_PWREN_POWER_ENABLE_Pos)            /*!< SDMMC PWREN: POWER_ENABLE Mask      */

// --------------------------------------  SDMMC_CLKDIV  ------------------------------------------
#define SDMMC_CLKDIV_CLK_DIVIDER0_Pos                         0                                                         /*!< SDMMC CLKDIV: CLK_DIVIDER0 Position */
#define SDMMC_CLKDIV_CLK_DIVIDER0_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER0_Pos)           /*!< SDMMC CLKDIV: CLK_DIVIDER0 Mask     */
#define SDMMC_CLKDIV_CLK_DIVIDER1_Pos                         8                                                         /*!< SDMMC CLKDIV: CLK_DIVIDER1 Position */
#define SDMMC_CLKDIV_CLK_DIVIDER1_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER1_Pos)           /*!< SDMMC CLKDIV: CLK_DIVIDER1 Mask     */
#define SDMMC_CLKDIV_CLK_DIVIDER2_Pos                         16                                                        /*!< SDMMC CLKDIV: CLK_DIVIDER2 Position */
#define SDMMC_CLKDIV_CLK_DIVIDER2_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER2_Pos)           /*!< SDMMC CLKDIV: CLK_DIVIDER2 Mask     */
#define SDMMC_CLKDIV_CLK_DIVIDER3_Pos                         24                                                        /*!< SDMMC CLKDIV: CLK_DIVIDER3 Position */
#define SDMMC_CLKDIV_CLK_DIVIDER3_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER3_Pos)           /*!< SDMMC CLKDIV: CLK_DIVIDER3 Mask     */

// --------------------------------------  SDMMC_CLKSRC  ------------------------------------------
#define SDMMC_CLKSRC_CLK_SOURCE_Pos                           0                                                         /*!< SDMMC CLKSRC: CLK_SOURCE Position   */
#define SDMMC_CLKSRC_CLK_SOURCE_Msk                           (0xffffffffUL << SDMMC_CLKSRC_CLK_SOURCE_Pos)             /*!< SDMMC CLKSRC: CLK_SOURCE Mask       */

// --------------------------------------  SDMMC_CLKENA  ------------------------------------------
#define SDMMC_CLKENA_CCLK_ENABLE_Pos                          0                                                         /*!< SDMMC CLKENA: CCLK_ENABLE Position  */
#define SDMMC_CLKENA_CCLK_ENABLE_Msk                          (0x0000ffffUL << SDMMC_CLKENA_CCLK_ENABLE_Pos)            /*!< SDMMC CLKENA: CCLK_ENABLE Mask      */
#define SDMMC_CLKENA_CCLK_LOW_POWER_Pos                       16                                                        /*!< SDMMC CLKENA: CCLK_LOW_POWER Position */
#define SDMMC_CLKENA_CCLK_LOW_POWER_Msk                       (0x0000ffffUL << SDMMC_CLKENA_CCLK_LOW_POWER_Pos)         /*!< SDMMC CLKENA: CCLK_LOW_POWER Mask   */

// ---------------------------------------  SDMMC_TMOUT  ------------------------------------------
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos                      0                                                         /*!< SDMMC TMOUT: RESPONSE_TIMEOUT Position */
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Msk                      (0x000000ffUL << SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos)        /*!< SDMMC TMOUT: RESPONSE_TIMEOUT Mask  */
#define SDMMC_TMOUT_DATA_TIMEOUT_Pos                          8                                                         /*!< SDMMC TMOUT: DATA_TIMEOUT Position  */
#define SDMMC_TMOUT_DATA_TIMEOUT_Msk                          (0x00ffffffUL << SDMMC_TMOUT_DATA_TIMEOUT_Pos)            /*!< SDMMC TMOUT: DATA_TIMEOUT Mask      */

// ---------------------------------------  SDMMC_CTYPE  ------------------------------------------
#define SDMMC_CTYPE_CARD_WIDTH0_Pos                           0                                                         /*!< SDMMC CTYPE: CARD_WIDTH0 Position   */
#define SDMMC_CTYPE_CARD_WIDTH0_Msk                           (0x0000ffffUL << SDMMC_CTYPE_CARD_WIDTH0_Pos)             /*!< SDMMC CTYPE: CARD_WIDTH0 Mask       */
#define SDMMC_CTYPE_CARD_WIDTH1_Pos                           16                                                        /*!< SDMMC CTYPE: CARD_WIDTH1 Position   */
#define SDMMC_CTYPE_CARD_WIDTH1_Msk                           (0x0000ffffUL << SDMMC_CTYPE_CARD_WIDTH1_Pos)             /*!< SDMMC CTYPE: CARD_WIDTH1 Mask       */

// --------------------------------------  SDMMC_BLKSIZ  ------------------------------------------
#define SDMMC_BLKSIZ_BLOCK_SIZE_Pos                           0                                                         /*!< SDMMC BLKSIZ: BLOCK_SIZE Position   */
#define SDMMC_BLKSIZ_BLOCK_SIZE_Msk                           (0x0000ffffUL << SDMMC_BLKSIZ_BLOCK_SIZE_Pos)             /*!< SDMMC BLKSIZ: BLOCK_SIZE Mask       */

// --------------------------------------  SDMMC_BYTCNT  ------------------------------------------
#define SDMMC_BYTCNT_BYTE_COUNT_Pos                           0                                                         /*!< SDMMC BYTCNT: BYTE_COUNT Position   */
#define SDMMC_BYTCNT_BYTE_COUNT_Msk                           (0xffffffffUL << SDMMC_BYTCNT_BYTE_COUNT_Pos)             /*!< SDMMC BYTCNT: BYTE_COUNT Mask       */

// --------------------------------------  SDMMC_INTMASK  -----------------------------------------
#define SDMMC_INTMASK_CDET_Pos                                0                                                         /*!< SDMMC INTMASK: CDET Position        */
#define SDMMC_INTMASK_CDET_Msk                                (0x01UL << SDMMC_INTMASK_CDET_Pos)                        /*!< SDMMC INTMASK: CDET Mask            */
#define SDMMC_INTMASK_RE_Pos                                  1                                                         /*!< SDMMC INTMASK: RE Position          */
#define SDMMC_INTMASK_RE_Msk                                  (0x01UL << SDMMC_INTMASK_RE_Pos)                          /*!< SDMMC INTMASK: RE Mask              */
#define SDMMC_INTMASK_CDONE_Pos                               2                                                         /*!< SDMMC INTMASK: CDONE Position       */
#define SDMMC_INTMASK_CDONE_Msk                               (0x01UL << SDMMC_INTMASK_CDONE_Pos)                       /*!< SDMMC INTMASK: CDONE Mask           */
#define SDMMC_INTMASK_DTO_Pos                                 3                                                         /*!< SDMMC INTMASK: DTO Position         */
#define SDMMC_INTMASK_DTO_Msk                                 (0x01UL << SDMMC_INTMASK_DTO_Pos)                         /*!< SDMMC INTMASK: DTO Mask             */
#define SDMMC_INTMASK_TXDR_Pos                                4                                                         /*!< SDMMC INTMASK: TXDR Position        */
#define SDMMC_INTMASK_TXDR_Msk                                (0x01UL << SDMMC_INTMASK_TXDR_Pos)                        /*!< SDMMC INTMASK: TXDR Mask            */
#define SDMMC_INTMASK_RXDR_Pos                                5                                                         /*!< SDMMC INTMASK: RXDR Position        */
#define SDMMC_INTMASK_RXDR_Msk                                (0x01UL << SDMMC_INTMASK_RXDR_Pos)                        /*!< SDMMC INTMASK: RXDR Mask            */
#define SDMMC_INTMASK_RCRC_Pos                                6                                                         /*!< SDMMC INTMASK: RCRC Position        */
#define SDMMC_INTMASK_RCRC_Msk                                (0x01UL << SDMMC_INTMASK_RCRC_Pos)                        /*!< SDMMC INTMASK: RCRC Mask            */
#define SDMMC_INTMASK_DCRC_Pos                                7                                                         /*!< SDMMC INTMASK: DCRC Position        */
#define SDMMC_INTMASK_DCRC_Msk                                (0x01UL << SDMMC_INTMASK_DCRC_Pos)                        /*!< SDMMC INTMASK: DCRC Mask            */
#define SDMMC_INTMASK_RTO_Pos                                 8                                                         /*!< SDMMC INTMASK: RTO Position         */
#define SDMMC_INTMASK_RTO_Msk                                 (0x01UL << SDMMC_INTMASK_RTO_Pos)                         /*!< SDMMC INTMASK: RTO Mask             */
#define SDMMC_INTMASK_DRTO_Pos                                9                                                         /*!< SDMMC INTMASK: DRTO Position        */
#define SDMMC_INTMASK_DRTO_Msk                                (0x01UL << SDMMC_INTMASK_DRTO_Pos)                        /*!< SDMMC INTMASK: DRTO Mask            */
#define SDMMC_INTMASK_HTO_Pos                                 10                                                        /*!< SDMMC INTMASK: HTO Position         */
#define SDMMC_INTMASK_HTO_Msk                                 (0x01UL << SDMMC_INTMASK_HTO_Pos)                         /*!< SDMMC INTMASK: HTO Mask             */
#define SDMMC_INTMASK_FRUN_Pos                                11                                                        /*!< SDMMC INTMASK: FRUN Position        */
#define SDMMC_INTMASK_FRUN_Msk                                (0x01UL << SDMMC_INTMASK_FRUN_Pos)                        /*!< SDMMC INTMASK: FRUN Mask            */
#define SDMMC_INTMASK_HLE_Pos                                 12                                                        /*!< SDMMC INTMASK: HLE Position         */
#define SDMMC_INTMASK_HLE_Msk                                 (0x01UL << SDMMC_INTMASK_HLE_Pos)                         /*!< SDMMC INTMASK: HLE Mask             */
#define SDMMC_INTMASK_SBE_Pos                                 13                                                        /*!< SDMMC INTMASK: SBE Position         */
#define SDMMC_INTMASK_SBE_Msk                                 (0x01UL << SDMMC_INTMASK_SBE_Pos)                         /*!< SDMMC INTMASK: SBE Mask             */
#define SDMMC_INTMASK_ACD_Pos                                 14                                                        /*!< SDMMC INTMASK: ACD Position         */
#define SDMMC_INTMASK_ACD_Msk                                 (0x01UL << SDMMC_INTMASK_ACD_Pos)                         /*!< SDMMC INTMASK: ACD Mask             */
#define SDMMC_INTMASK_EBE_Pos                                 15                                                        /*!< SDMMC INTMASK: EBE Position         */
#define SDMMC_INTMASK_EBE_Msk                                 (0x01UL << SDMMC_INTMASK_EBE_Pos)                         /*!< SDMMC INTMASK: EBE Mask             */
#define SDMMC_INTMASK_SDIO_INT_MASK_Pos                       16                                                        /*!< SDMMC INTMASK: SDIO_INT_MASK Position */
#define SDMMC_INTMASK_SDIO_INT_MASK_Msk                       (0x0000ffffUL << SDMMC_INTMASK_SDIO_INT_MASK_Pos)         /*!< SDMMC INTMASK: SDIO_INT_MASK Mask   */

// --------------------------------------  SDMMC_CMDARG  ------------------------------------------
#define SDMMC_CMDARG_CMD_ARG_Pos                              0                                                         /*!< SDMMC CMDARG: CMD_ARG Position      */
#define SDMMC_CMDARG_CMD_ARG_Msk                              (0xffffffffUL << SDMMC_CMDARG_CMD_ARG_Pos)                /*!< SDMMC CMDARG: CMD_ARG Mask          */

// ----------------------------------------  SDMMC_CMD  -------------------------------------------
#define SDMMC_CMD_CMD_INDEX_Pos                               0                                                         /*!< SDMMC CMD: CMD_INDEX Position       */
#define SDMMC_CMD_CMD_INDEX_Msk                               (0x3fUL << SDMMC_CMD_CMD_INDEX_Pos)                       /*!< SDMMC CMD: CMD_INDEX Mask           */
#define SDMMC_CMD_RESPONSE_EXPECT_Pos                         6                                                         /*!< SDMMC CMD: RESPONSE_EXPECT Position */
#define SDMMC_CMD_RESPONSE_EXPECT_Msk                         (0x01UL << SDMMC_CMD_RESPONSE_EXPECT_Pos)                 /*!< SDMMC CMD: RESPONSE_EXPECT Mask     */
#define SDMMC_CMD_RESPONSE_LENGTH_Pos                         7                                                         /*!< SDMMC CMD: RESPONSE_LENGTH Position */
#define SDMMC_CMD_RESPONSE_LENGTH_Msk                         (0x01UL << SDMMC_CMD_RESPONSE_LENGTH_Pos)                 /*!< SDMMC CMD: RESPONSE_LENGTH Mask     */
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Pos                      8                                                         /*!< SDMMC CMD: CHECK_RESPONSE_CRC Position */
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Msk                      (0x01UL << SDMMC_CMD_CHECK_RESPONSE_CRC_Pos)              /*!< SDMMC CMD: CHECK_RESPONSE_CRC Mask  */
#define SDMMC_CMD_DATA_EXPECTED_Pos                           9                                                         /*!< SDMMC CMD: DATA_EXPECTED Position   */
#define SDMMC_CMD_DATA_EXPECTED_Msk                           (0x01UL << SDMMC_CMD_DATA_EXPECTED_Pos)                   /*!< SDMMC CMD: DATA_EXPECTED Mask       */
#define SDMMC_CMD_READ_WRITE_Pos                              10                                                        /*!< SDMMC CMD: READ_WRITE Position      */
#define SDMMC_CMD_READ_WRITE_Msk                              (0x01UL << SDMMC_CMD_READ_WRITE_Pos)                      /*!< SDMMC CMD: READ_WRITE Mask          */
#define SDMMC_CMD_TRANSFER_MODE_Pos                           11                                                        /*!< SDMMC CMD: TRANSFER_MODE Position   */
#define SDMMC_CMD_TRANSFER_MODE_Msk                           (0x01UL << SDMMC_CMD_TRANSFER_MODE_Pos)                   /*!< SDMMC CMD: TRANSFER_MODE Mask       */
#define SDMMC_CMD_SEND_AUTO_STOP_Pos                          12                                                        /*!< SDMMC CMD: SEND_AUTO_STOP Position  */
#define SDMMC_CMD_SEND_AUTO_STOP_Msk                          (0x01UL << SDMMC_CMD_SEND_AUTO_STOP_Pos)                  /*!< SDMMC CMD: SEND_AUTO_STOP Mask      */
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos                   13                                                        /*!< SDMMC CMD: WAIT_PRVDATA_COMPLETE Position */
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Msk                   (0x01UL << SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos)           /*!< SDMMC CMD: WAIT_PRVDATA_COMPLETE Mask */
#define SDMMC_CMD_STOP_ABORT_CMd_Pos                          14                                                        /*!< SDMMC CMD: STOP_ABORT_CMd Position  */
#define SDMMC_CMD_STOP_ABORT_CMd_Msk                          (0x01UL << SDMMC_CMD_STOP_ABORT_CMd_Pos)                  /*!< SDMMC CMD: STOP_ABORT_CMd Mask      */
#define SDMMC_CMD_SEND_INITIALIZATION_Pos                     15                                                        /*!< SDMMC CMD: SEND_INITIALIZATION Position */
#define SDMMC_CMD_SEND_INITIALIZATION_Msk                     (0x01UL << SDMMC_CMD_SEND_INITIALIZATION_Pos)             /*!< SDMMC CMD: SEND_INITIALIZATION Mask */
#define SDMMC_CMD_CARD_NUMBER_Pos                             16                                                        /*!< SDMMC CMD: CARD_NUMBER Position     */
#define SDMMC_CMD_CARD_NUMBER_Msk                             (0x1fUL << SDMMC_CMD_CARD_NUMBER_Pos)                     /*!< SDMMC CMD: CARD_NUMBER Mask         */
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos             21                                                        /*!< SDMMC CMD: UPDATE_CLOCK_REGISTERS_ONLY Position */
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Msk             (0x01UL << SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos)     /*!< SDMMC CMD: UPDATE_CLOCK_REGISTERS_ONLY Mask */
#define SDMMC_CMD_READ_CEATA_DEVICE_Pos                       22                                                        /*!< SDMMC CMD: READ_CEATA_DEVICE Position */
#define SDMMC_CMD_READ_CEATA_DEVICE_Msk                       (0x01UL << SDMMC_CMD_READ_CEATA_DEVICE_Pos)               /*!< SDMMC CMD: READ_CEATA_DEVICE Mask   */
#define SDMMC_CMD_CCS_EXPECTED_Pos                            23                                                        /*!< SDMMC CMD: CCS_EXPECTED Position    */
#define SDMMC_CMD_CCS_EXPECTED_Msk                            (0x01UL << SDMMC_CMD_CCS_EXPECTED_Pos)                    /*!< SDMMC CMD: CCS_EXPECTED Mask        */
#define SDMMC_CMD_ENABLE_BOOT_Pos                             24                                                        /*!< SDMMC CMD: ENABLE_BOOT Position     */
#define SDMMC_CMD_ENABLE_BOOT_Msk                             (0x01UL << SDMMC_CMD_ENABLE_BOOT_Pos)                     /*!< SDMMC CMD: ENABLE_BOOT Mask         */
#define SDMMC_CMD_EXPECT_BOOT_ACK_Pos                         25                                                        /*!< SDMMC CMD: EXPECT_BOOT_ACK Position */
#define SDMMC_CMD_EXPECT_BOOT_ACK_Msk                         (0x01UL << SDMMC_CMD_EXPECT_BOOT_ACK_Pos)                 /*!< SDMMC CMD: EXPECT_BOOT_ACK Mask     */
#define SDMMC_CMD_DISABLE_BOOT_Pos                            26                                                        /*!< SDMMC CMD: DISABLE_BOOT Position    */
#define SDMMC_CMD_DISABLE_BOOT_Msk                            (0x01UL << SDMMC_CMD_DISABLE_BOOT_Pos)                    /*!< SDMMC CMD: DISABLE_BOOT Mask        */
#define SDMMC_CMD_BOOT_MODE_Pos                               27                                                        /*!< SDMMC CMD: BOOT_MODE Position       */
#define SDMMC_CMD_BOOT_MODE_Msk                               (0x01UL << SDMMC_CMD_BOOT_MODE_Pos)                       /*!< SDMMC CMD: BOOT_MODE Mask           */
#define SDMMC_CMD_VOLT_SWITCH_Pos                             28                                                        /*!< SDMMC CMD: VOLT_SWITCH Position     */
#define SDMMC_CMD_VOLT_SWITCH_Msk                             (0x01UL << SDMMC_CMD_VOLT_SWITCH_Pos)                     /*!< SDMMC CMD: VOLT_SWITCH Mask         */
#define SDMMC_CMD_START_CMD_Pos                               31                                                        /*!< SDMMC CMD: START_CMD Position       */
#define SDMMC_CMD_START_CMD_Msk                               (0x01UL << SDMMC_CMD_START_CMD_Pos)                       /*!< SDMMC CMD: START_CMD Mask           */

// ---------------------------------------  SDMMC_RESP0  ------------------------------------------
#define SDMMC_RESP0_RESPONSE0_Pos                             0                                                         /*!< SDMMC RESP0: RESPONSE0 Position     */
#define SDMMC_RESP0_RESPONSE0_Msk                             (0xffffffffUL << SDMMC_RESP0_RESPONSE0_Pos)               /*!< SDMMC RESP0: RESPONSE0 Mask         */

// ---------------------------------------  SDMMC_RESP1  ------------------------------------------
#define SDMMC_RESP1_RESPONSE1_Pos                             0                                                         /*!< SDMMC RESP1: RESPONSE1 Position     */
#define SDMMC_RESP1_RESPONSE1_Msk                             (0xffffffffUL << SDMMC_RESP1_RESPONSE1_Pos)               /*!< SDMMC RESP1: RESPONSE1 Mask         */

// ---------------------------------------  SDMMC_RESP2  ------------------------------------------
#define SDMMC_RESP2_RESPONSE2_Pos                             0                                                         /*!< SDMMC RESP2: RESPONSE2 Position     */
#define SDMMC_RESP2_RESPONSE2_Msk                             (0xffffffffUL << SDMMC_RESP2_RESPONSE2_Pos)               /*!< SDMMC RESP2: RESPONSE2 Mask         */

// ---------------------------------------  SDMMC_RESP3  ------------------------------------------
#define SDMMC_RESP3_RESPONSE3_Pos                             0                                                         /*!< SDMMC RESP3: RESPONSE3 Position     */
#define SDMMC_RESP3_RESPONSE3_Msk                             (0xffffffffUL << SDMMC_RESP3_RESPONSE3_Pos)               /*!< SDMMC RESP3: RESPONSE3 Mask         */

// --------------------------------------  SDMMC_MINTSTS  -----------------------------------------
#define SDMMC_MINTSTS_CDET_Pos                                0                                                         /*!< SDMMC MINTSTS: CDET Position        */
#define SDMMC_MINTSTS_CDET_Msk                                (0x01UL << SDMMC_MINTSTS_CDET_Pos)                        /*!< SDMMC MINTSTS: CDET Mask            */
#define SDMMC_MINTSTS_RE_Pos                                  1                                                         /*!< SDMMC MINTSTS: RE Position          */
#define SDMMC_MINTSTS_RE_Msk                                  (0x01UL << SDMMC_MINTSTS_RE_Pos)                          /*!< SDMMC MINTSTS: RE Mask              */
#define SDMMC_MINTSTS_CDONE_Pos                               2                                                         /*!< SDMMC MINTSTS: CDONE Position       */
#define SDMMC_MINTSTS_CDONE_Msk                               (0x01UL << SDMMC_MINTSTS_CDONE_Pos)                       /*!< SDMMC MINTSTS: CDONE Mask           */
#define SDMMC_MINTSTS_DTO_Pos                                 3                                                         /*!< SDMMC MINTSTS: DTO Position         */
#define SDMMC_MINTSTS_DTO_Msk                                 (0x01UL << SDMMC_MINTSTS_DTO_Pos)                         /*!< SDMMC MINTSTS: DTO Mask             */
#define SDMMC_MINTSTS_TXDR_Pos                                4                                                         /*!< SDMMC MINTSTS: TXDR Position        */
#define SDMMC_MINTSTS_TXDR_Msk                                (0x01UL << SDMMC_MINTSTS_TXDR_Pos)                        /*!< SDMMC MINTSTS: TXDR Mask            */
#define SDMMC_MINTSTS_RXDR_Pos                                5                                                         /*!< SDMMC MINTSTS: RXDR Position        */
#define SDMMC_MINTSTS_RXDR_Msk                                (0x01UL << SDMMC_MINTSTS_RXDR_Pos)                        /*!< SDMMC MINTSTS: RXDR Mask            */
#define SDMMC_MINTSTS_RCRC_Pos                                6                                                         /*!< SDMMC MINTSTS: RCRC Position        */
#define SDMMC_MINTSTS_RCRC_Msk                                (0x01UL << SDMMC_MINTSTS_RCRC_Pos)                        /*!< SDMMC MINTSTS: RCRC Mask            */
#define SDMMC_MINTSTS_DCRC_Pos                                7                                                         /*!< SDMMC MINTSTS: DCRC Position        */
#define SDMMC_MINTSTS_DCRC_Msk                                (0x01UL << SDMMC_MINTSTS_DCRC_Pos)                        /*!< SDMMC MINTSTS: DCRC Mask            */
#define SDMMC_MINTSTS_RTO_Pos                                 8                                                         /*!< SDMMC MINTSTS: RTO Position         */
#define SDMMC_MINTSTS_RTO_Msk                                 (0x01UL << SDMMC_MINTSTS_RTO_Pos)                         /*!< SDMMC MINTSTS: RTO Mask             */
#define SDMMC_MINTSTS_DRTO_Pos                                9                                                         /*!< SDMMC MINTSTS: DRTO Position        */
#define SDMMC_MINTSTS_DRTO_Msk                                (0x01UL << SDMMC_MINTSTS_DRTO_Pos)                        /*!< SDMMC MINTSTS: DRTO Mask            */
#define SDMMC_MINTSTS_HTO_Pos                                 10                                                        /*!< SDMMC MINTSTS: HTO Position         */
#define SDMMC_MINTSTS_HTO_Msk                                 (0x01UL << SDMMC_MINTSTS_HTO_Pos)                         /*!< SDMMC MINTSTS: HTO Mask             */
#define SDMMC_MINTSTS_FRUN_Pos                                11                                                        /*!< SDMMC MINTSTS: FRUN Position        */
#define SDMMC_MINTSTS_FRUN_Msk                                (0x01UL << SDMMC_MINTSTS_FRUN_Pos)                        /*!< SDMMC MINTSTS: FRUN Mask            */
#define SDMMC_MINTSTS_HLE_Pos                                 12                                                        /*!< SDMMC MINTSTS: HLE Position         */
#define SDMMC_MINTSTS_HLE_Msk                                 (0x01UL << SDMMC_MINTSTS_HLE_Pos)                         /*!< SDMMC MINTSTS: HLE Mask             */
#define SDMMC_MINTSTS_SBE_Pos                                 13                                                        /*!< SDMMC MINTSTS: SBE Position         */
#define SDMMC_MINTSTS_SBE_Msk                                 (0x01UL << SDMMC_MINTSTS_SBE_Pos)                         /*!< SDMMC MINTSTS: SBE Mask             */
#define SDMMC_MINTSTS_ACD_Pos                                 14                                                        /*!< SDMMC MINTSTS: ACD Position         */
#define SDMMC_MINTSTS_ACD_Msk                                 (0x01UL << SDMMC_MINTSTS_ACD_Pos)                         /*!< SDMMC MINTSTS: ACD Mask             */
#define SDMMC_MINTSTS_EBE_Pos                                 15                                                        /*!< SDMMC MINTSTS: EBE Position         */
#define SDMMC_MINTSTS_EBE_Msk                                 (0x01UL << SDMMC_MINTSTS_EBE_Pos)                         /*!< SDMMC MINTSTS: EBE Mask             */
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Pos                      16                                                        /*!< SDMMC MINTSTS: SDIO_INTERRUPT Position */
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Msk                      (0x0000ffffUL << SDMMC_MINTSTS_SDIO_INTERRUPT_Pos)        /*!< SDMMC MINTSTS: SDIO_INTERRUPT Mask  */

// --------------------------------------  SDMMC_RINTSTS  -----------------------------------------
#define SDMMC_RINTSTS_CDET_Pos                                0                                                         /*!< SDMMC RINTSTS: CDET Position        */
#define SDMMC_RINTSTS_CDET_Msk                                (0x01UL << SDMMC_RINTSTS_CDET_Pos)                        /*!< SDMMC RINTSTS: CDET Mask            */
#define SDMMC_RINTSTS_RE_Pos                                  1                                                         /*!< SDMMC RINTSTS: RE Position          */
#define SDMMC_RINTSTS_RE_Msk                                  (0x01UL << SDMMC_RINTSTS_RE_Pos)                          /*!< SDMMC RINTSTS: RE Mask              */
#define SDMMC_RINTSTS_CDONE_Pos                               2                                                         /*!< SDMMC RINTSTS: CDONE Position       */
#define SDMMC_RINTSTS_CDONE_Msk                               (0x01UL << SDMMC_RINTSTS_CDONE_Pos)                       /*!< SDMMC RINTSTS: CDONE Mask           */
#define SDMMC_RINTSTS_DTO_Pos                                 3                                                         /*!< SDMMC RINTSTS: DTO Position         */
#define SDMMC_RINTSTS_DTO_Msk                                 (0x01UL << SDMMC_RINTSTS_DTO_Pos)                         /*!< SDMMC RINTSTS: DTO Mask             */
#define SDMMC_RINTSTS_TXDR_Pos                                4                                                         /*!< SDMMC RINTSTS: TXDR Position        */
#define SDMMC_RINTSTS_TXDR_Msk                                (0x01UL << SDMMC_RINTSTS_TXDR_Pos)                        /*!< SDMMC RINTSTS: TXDR Mask            */
#define SDMMC_RINTSTS_RXDR_Pos                                5                                                         /*!< SDMMC RINTSTS: RXDR Position        */
#define SDMMC_RINTSTS_RXDR_Msk                                (0x01UL << SDMMC_RINTSTS_RXDR_Pos)                        /*!< SDMMC RINTSTS: RXDR Mask            */
#define SDMMC_RINTSTS_RCRC_Pos                                6                                                         /*!< SDMMC RINTSTS: RCRC Position        */
#define SDMMC_RINTSTS_RCRC_Msk                                (0x01UL << SDMMC_RINTSTS_RCRC_Pos)                        /*!< SDMMC RINTSTS: RCRC Mask            */
#define SDMMC_RINTSTS_DCRC_Pos                                7                                                         /*!< SDMMC RINTSTS: DCRC Position        */
#define SDMMC_RINTSTS_DCRC_Msk                                (0x01UL << SDMMC_RINTSTS_DCRC_Pos)                        /*!< SDMMC RINTSTS: DCRC Mask            */
#define SDMMC_RINTSTS_RTO_BAR_Pos                             8                                                         /*!< SDMMC RINTSTS: RTO_BAR Position     */
#define SDMMC_RINTSTS_RTO_BAR_Msk                             (0x01UL << SDMMC_RINTSTS_RTO_BAR_Pos)                     /*!< SDMMC RINTSTS: RTO_BAR Mask         */
#define SDMMC_RINTSTS_DRTO_BDS_Pos                            9                                                         /*!< SDMMC RINTSTS: DRTO_BDS Position    */
#define SDMMC_RINTSTS_DRTO_BDS_Msk                            (0x01UL << SDMMC_RINTSTS_DRTO_BDS_Pos)                    /*!< SDMMC RINTSTS: DRTO_BDS Mask        */
#define SDMMC_RINTSTS_HTO_Pos                                 10                                                        /*!< SDMMC RINTSTS: HTO Position         */
#define SDMMC_RINTSTS_HTO_Msk                                 (0x01UL << SDMMC_RINTSTS_HTO_Pos)                         /*!< SDMMC RINTSTS: HTO Mask             */
#define SDMMC_RINTSTS_FRUN_Pos                                11                                                        /*!< SDMMC RINTSTS: FRUN Position        */
#define SDMMC_RINTSTS_FRUN_Msk                                (0x01UL << SDMMC_RINTSTS_FRUN_Pos)                        /*!< SDMMC RINTSTS: FRUN Mask            */
#define SDMMC_RINTSTS_HLE_Pos                                 12                                                        /*!< SDMMC RINTSTS: HLE Position         */
#define SDMMC_RINTSTS_HLE_Msk                                 (0x01UL << SDMMC_RINTSTS_HLE_Pos)                         /*!< SDMMC RINTSTS: HLE Mask             */
#define SDMMC_RINTSTS_SBE_Pos                                 13                                                        /*!< SDMMC RINTSTS: SBE Position         */
#define SDMMC_RINTSTS_SBE_Msk                                 (0x01UL << SDMMC_RINTSTS_SBE_Pos)                         /*!< SDMMC RINTSTS: SBE Mask             */
#define SDMMC_RINTSTS_ACD_Pos                                 14                                                        /*!< SDMMC RINTSTS: ACD Position         */
#define SDMMC_RINTSTS_ACD_Msk                                 (0x01UL << SDMMC_RINTSTS_ACD_Pos)                         /*!< SDMMC RINTSTS: ACD Mask             */
#define SDMMC_RINTSTS_EBE_Pos                                 15                                                        /*!< SDMMC RINTSTS: EBE Position         */
#define SDMMC_RINTSTS_EBE_Msk                                 (0x01UL << SDMMC_RINTSTS_EBE_Pos)                         /*!< SDMMC RINTSTS: EBE Mask             */
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Pos                      16                                                        /*!< SDMMC RINTSTS: SDIO_INTERRUPT Position */
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Msk                      (0x0000ffffUL << SDMMC_RINTSTS_SDIO_INTERRUPT_Pos)        /*!< SDMMC RINTSTS: SDIO_INTERRUPT Mask  */

// --------------------------------------  SDMMC_STATUS  ------------------------------------------
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Pos                    0                                                         /*!< SDMMC STATUS: FIFO_RX_WATERMARK Position */
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Msk                    (0x01UL << SDMMC_STATUS_FIFO_RX_WATERMARK_Pos)            /*!< SDMMC STATUS: FIFO_RX_WATERMARK Mask */
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Pos                    1                                                         /*!< SDMMC STATUS: FIFO_TX_WATERMARK Position */
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Msk                    (0x01UL << SDMMC_STATUS_FIFO_TX_WATERMARK_Pos)            /*!< SDMMC STATUS: FIFO_TX_WATERMARK Mask */
#define SDMMC_STATUS_FIFO_EMPTY_Pos                           2                                                         /*!< SDMMC STATUS: FIFO_EMPTY Position   */
#define SDMMC_STATUS_FIFO_EMPTY_Msk                           (0x01UL << SDMMC_STATUS_FIFO_EMPTY_Pos)                   /*!< SDMMC STATUS: FIFO_EMPTY Mask       */
#define SDMMC_STATUS_FIFO_FULL_Pos                            3                                                         /*!< SDMMC STATUS: FIFO_FULL Position    */
#define SDMMC_STATUS_FIFO_FULL_Msk                            (0x01UL << SDMMC_STATUS_FIFO_FULL_Pos)                    /*!< SDMMC STATUS: FIFO_FULL Mask        */
#define SDMMC_STATUS_CMDFSMSTATES_Pos                         4                                                         /*!< SDMMC STATUS: CMDFSMSTATES Position */
#define SDMMC_STATUS_CMDFSMSTATES_Msk                         (0x0fUL << SDMMC_STATUS_CMDFSMSTATES_Pos)                 /*!< SDMMC STATUS: CMDFSMSTATES Mask     */
#define SDMMC_STATUS_DATA_3_STATUS_Pos                        8                                                         /*!< SDMMC STATUS: DATA_3_STATUS Position */
#define SDMMC_STATUS_DATA_3_STATUS_Msk                        (0x01UL << SDMMC_STATUS_DATA_3_STATUS_Pos)                /*!< SDMMC STATUS: DATA_3_STATUS Mask    */
#define SDMMC_STATUS_DATA_BUSY_Pos                            9                                                         /*!< SDMMC STATUS: DATA_BUSY Position    */
#define SDMMC_STATUS_DATA_BUSY_Msk                            (0x01UL << SDMMC_STATUS_DATA_BUSY_Pos)                    /*!< SDMMC STATUS: DATA_BUSY Mask        */
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos                   10                                                        /*!< SDMMC STATUS: DATA_STATE_MC_BUSY Position */
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Msk                   (0x01UL << SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos)           /*!< SDMMC STATUS: DATA_STATE_MC_BUSY Mask */
#define SDMMC_STATUS_RESPONSE_INDEX_Pos                       11                                                        /*!< SDMMC STATUS: RESPONSE_INDEX Position */
#define SDMMC_STATUS_RESPONSE_INDEX_Msk                       (0x3fUL << SDMMC_STATUS_RESPONSE_INDEX_Pos)               /*!< SDMMC STATUS: RESPONSE_INDEX Mask   */
#define SDMMC_STATUS_FIFO_COUNT_Pos                           17                                                        /*!< SDMMC STATUS: FIFO_COUNT Position   */
#define SDMMC_STATUS_FIFO_COUNT_Msk                           (0x00001fffUL << SDMMC_STATUS_FIFO_COUNT_Pos)             /*!< SDMMC STATUS: FIFO_COUNT Mask       */
#define SDMMC_STATUS_DMA_ACK_Pos                              30                                                        /*!< SDMMC STATUS: DMA_ACK Position      */
#define SDMMC_STATUS_DMA_ACK_Msk                              (0x01UL << SDMMC_STATUS_DMA_ACK_Pos)                      /*!< SDMMC STATUS: DMA_ACK Mask          */
#define SDMMC_STATUS_DMA_REQ_Pos                              31                                                        /*!< SDMMC STATUS: DMA_REQ Position      */
#define SDMMC_STATUS_DMA_REQ_Msk                              (0x01UL << SDMMC_STATUS_DMA_REQ_Pos)                      /*!< SDMMC STATUS: DMA_REQ Mask          */

// --------------------------------------  SDMMC_FIFOTH  ------------------------------------------
#define SDMMC_FIFOTH_TX_WMARK_Pos                             0                                                         /*!< SDMMC FIFOTH: TX_WMARK Position     */
#define SDMMC_FIFOTH_TX_WMARK_Msk                             (0x00000fffUL << SDMMC_FIFOTH_TX_WMARK_Pos)               /*!< SDMMC FIFOTH: TX_WMARK Mask         */
#define SDMMC_FIFOTH_RX_WMARK_Pos                             16                                                        /*!< SDMMC FIFOTH: RX_WMARK Position     */
#define SDMMC_FIFOTH_RX_WMARK_Msk                             (0x00000fffUL << SDMMC_FIFOTH_RX_WMARK_Pos)               /*!< SDMMC FIFOTH: RX_WMARK Mask         */
#define SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Pos      28                                                        /*!< SDMMC FIFOTH: DW_DMA_MUTIPLE_TRANSACTION_SIZE Position */
#define SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Msk      (0x07UL << SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Pos)/*!< SDMMC FIFOTH: DW_DMA_MUTIPLE_TRANSACTION_SIZE Mask */

// --------------------------------------  SDMMC_CDETECT  -----------------------------------------
#define SDMMC_CDETECT_CARD_DETECT_N_Pos                       0                                                         /*!< SDMMC CDETECT: CARD_DETECT_N Position */
#define SDMMC_CDETECT_CARD_DETECT_N_Msk                       (0x3fffffffUL << SDMMC_CDETECT_CARD_DETECT_N_Pos)         /*!< SDMMC CDETECT: CARD_DETECT_N Mask   */

// --------------------------------------  SDMMC_WRTPRT  ------------------------------------------
#define SDMMC_WRTPRT_WRITE_PROTECT_Pos                        0                                                         /*!< SDMMC WRTPRT: WRITE_PROTECT Position */
#define SDMMC_WRTPRT_WRITE_PROTECT_Msk                        (0x3fffffffUL << SDMMC_WRTPRT_WRITE_PROTECT_Pos)          /*!< SDMMC WRTPRT: WRITE_PROTECT Mask    */

// ---------------------------------------  SDMMC_GPIO  -------------------------------------------
#define SDMMC_GPIO_GPI_Pos                                    0                                                         /*!< SDMMC GPIO: GPI Position            */
#define SDMMC_GPIO_GPI_Msk                                    (0x000000ffUL << SDMMC_GPIO_GPI_Pos)                      /*!< SDMMC GPIO: GPI Mask                */
#define SDMMC_GPIO_GPO_Pos                                    8                                                         /*!< SDMMC GPIO: GPO Position            */
#define SDMMC_GPIO_GPO_Msk                                    (0x0000ffffUL << SDMMC_GPIO_GPO_Pos)                      /*!< SDMMC GPIO: GPO Mask                */

// --------------------------------------  SDMMC_TCBCNT  ------------------------------------------
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos                0                                                         /*!< SDMMC TCBCNT: TRANS_CARD_BYTE_COUNT Position */
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Msk                (0xffffffffUL << SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos)  /*!< SDMMC TCBCNT: TRANS_CARD_BYTE_COUNT Mask */

// --------------------------------------  SDMMC_TBBCNT  ------------------------------------------
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos                0                                                         /*!< SDMMC TBBCNT: TRANS_FIFO_BYTE_COUNT Position */
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Msk                (0xffffffffUL << SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos)  /*!< SDMMC TBBCNT: TRANS_FIFO_BYTE_COUNT Mask */

// --------------------------------------  SDMMC_DEBNCE  ------------------------------------------
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos                       0                                                         /*!< SDMMC DEBNCE: DEBOUNCE_COUNT Position */
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Msk                       (0x00ffffffUL << SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos)         /*!< SDMMC DEBNCE: DEBOUNCE_COUNT Mask   */

// ---------------------------------------  SDMMC_USRID  ------------------------------------------
#define SDMMC_USRID_USRID_Pos                                 0                                                         /*!< SDMMC USRID: USRID Position         */
#define SDMMC_USRID_USRID_Msk                                 (0xffffffffUL << SDMMC_USRID_USRID_Pos)                   /*!< SDMMC USRID: USRID Mask             */

// ---------------------------------------  SDMMC_VERID  ------------------------------------------
#define SDMMC_VERID_VERID_Pos                                 0                                                         /*!< SDMMC VERID: VERID Position         */
#define SDMMC_VERID_VERID_Msk                                 (0xffffffffUL << SDMMC_VERID_VERID_Pos)                   /*!< SDMMC VERID: VERID Mask             */

// --------------------------------------  SDMMC_UHS_REG  -----------------------------------------
#define SDMMC_UHS_REG_VOLT_REG_Pos                            0                                                         /*!< SDMMC UHS_REG: VOLT_REG Position    */
#define SDMMC_UHS_REG_VOLT_REG_Msk                            (0x0000ffffUL << SDMMC_UHS_REG_VOLT_REG_Pos)              /*!< SDMMC UHS_REG: VOLT_REG Mask        */
#define SDMMC_UHS_REG_DDR_REG_Pos                             16                                                        /*!< SDMMC UHS_REG: DDR_REG Position     */
#define SDMMC_UHS_REG_DDR_REG_Msk                             (0x0000ffffUL << SDMMC_UHS_REG_DDR_REG_Pos)               /*!< SDMMC UHS_REG: DDR_REG Mask         */

// ---------------------------------------  SDMMC_RST_N  ------------------------------------------
#define SDMMC_RST_N_CARD_RESET_Pos                            0                                                         /*!< SDMMC RST_N: CARD_RESET Position    */
#define SDMMC_RST_N_CARD_RESET_Msk                            (0x0000ffffUL << SDMMC_RST_N_CARD_RESET_Pos)              /*!< SDMMC RST_N: CARD_RESET Mask        */

// ---------------------------------------  SDMMC_BMOD  -------------------------------------------
#define SDMMC_BMOD_SWR_Pos                                    0                                                         /*!< SDMMC BMOD: SWR Position            */
#define SDMMC_BMOD_SWR_Msk                                    (0x01UL << SDMMC_BMOD_SWR_Pos)                            /*!< SDMMC BMOD: SWR Mask                */
#define SDMMC_BMOD_FB_Pos                                     1                                                         /*!< SDMMC BMOD: FB Position             */
#define SDMMC_BMOD_FB_Msk                                     (0x01UL << SDMMC_BMOD_FB_Pos)                             /*!< SDMMC BMOD: FB Mask                 */
#define SDMMC_BMOD_DSL_Pos                                    2                                                         /*!< SDMMC BMOD: DSL Position            */
#define SDMMC_BMOD_DSL_Msk                                    (0x1fUL << SDMMC_BMOD_DSL_Pos)                            /*!< SDMMC BMOD: DSL Mask                */
#define SDMMC_BMOD_DE_Pos                                     7                                                         /*!< SDMMC BMOD: DE Position             */
#define SDMMC_BMOD_DE_Msk                                     (0x01UL << SDMMC_BMOD_DE_Pos)                             /*!< SDMMC BMOD: DE Mask                 */
#define SDMMC_BMOD_PBL_Pos                                    8                                                         /*!< SDMMC BMOD: PBL Position            */
#define SDMMC_BMOD_PBL_Msk                                    (0x07UL << SDMMC_BMOD_PBL_Pos)                            /*!< SDMMC BMOD: PBL Mask                */

// --------------------------------------  SDMMC_PLDMND  ------------------------------------------
#define SDMMC_PLDMND_PD_Pos                                   0                                                         /*!< SDMMC PLDMND: PD Position           */
#define SDMMC_PLDMND_PD_Msk                                   (0xffffffffUL << SDMMC_PLDMND_PD_Pos)                     /*!< SDMMC PLDMND: PD Mask               */

// --------------------------------------  SDMMC_DBADDR  ------------------------------------------
#define SDMMC_DBADDR_SDL_Pos                                  0                                                         /*!< SDMMC DBADDR: SDL Position          */
#define SDMMC_DBADDR_SDL_Msk                                  (0xffffffffUL << SDMMC_DBADDR_SDL_Pos)                    /*!< SDMMC DBADDR: SDL Mask              */

// ---------------------------------------  SDMMC_IDSTS  ------------------------------------------
#define SDMMC_IDSTS_TI_Pos                                    0                                                         /*!< SDMMC IDSTS: TI Position            */
#define SDMMC_IDSTS_TI_Msk                                    (0x01UL << SDMMC_IDSTS_TI_Pos)                            /*!< SDMMC IDSTS: TI Mask                */
#define SDMMC_IDSTS_RI_Pos                                    1                                                         /*!< SDMMC IDSTS: RI Position            */
#define SDMMC_IDSTS_RI_Msk                                    (0x01UL << SDMMC_IDSTS_RI_Pos)                            /*!< SDMMC IDSTS: RI Mask                */
#define SDMMC_IDSTS_FBE_Pos                                   2                                                         /*!< SDMMC IDSTS: FBE Position           */
#define SDMMC_IDSTS_FBE_Msk                                   (0x01UL << SDMMC_IDSTS_FBE_Pos)                           /*!< SDMMC IDSTS: FBE Mask               */
#define SDMMC_IDSTS_DU_Pos                                    4                                                         /*!< SDMMC IDSTS: DU Position            */
#define SDMMC_IDSTS_DU_Msk                                    (0x01UL << SDMMC_IDSTS_DU_Pos)                            /*!< SDMMC IDSTS: DU Mask                */
#define SDMMC_IDSTS_CES_Pos                                   5                                                         /*!< SDMMC IDSTS: CES Position           */
#define SDMMC_IDSTS_CES_Msk                                   (0x01UL << SDMMC_IDSTS_CES_Pos)                           /*!< SDMMC IDSTS: CES Mask               */
#define SDMMC_IDSTS_NIS_Pos                                   8                                                         /*!< SDMMC IDSTS: NIS Position           */
#define SDMMC_IDSTS_NIS_Msk                                   (0x01UL << SDMMC_IDSTS_NIS_Pos)                           /*!< SDMMC IDSTS: NIS Mask               */
#define SDMMC_IDSTS_AIS_Pos                                   9                                                         /*!< SDMMC IDSTS: AIS Position           */
#define SDMMC_IDSTS_AIS_Msk                                   (0x01UL << SDMMC_IDSTS_AIS_Pos)                           /*!< SDMMC IDSTS: AIS Mask               */
#define SDMMC_IDSTS_EB_Pos                                    10                                                        /*!< SDMMC IDSTS: EB Position            */
#define SDMMC_IDSTS_EB_Msk                                    (0x07UL << SDMMC_IDSTS_EB_Pos)                            /*!< SDMMC IDSTS: EB Mask                */
#define SDMMC_IDSTS_FSM_Pos                                   13                                                        /*!< SDMMC IDSTS: FSM Position           */
#define SDMMC_IDSTS_FSM_Msk                                   (0x0fUL << SDMMC_IDSTS_FSM_Pos)                           /*!< SDMMC IDSTS: FSM Mask               */

// --------------------------------------  SDMMC_IDINTEN  -----------------------------------------
#define SDMMC_IDINTEN_TI_Pos                                  0                                                         /*!< SDMMC IDINTEN: TI Position          */
#define SDMMC_IDINTEN_TI_Msk                                  (0x01UL << SDMMC_IDINTEN_TI_Pos)                          /*!< SDMMC IDINTEN: TI Mask              */
#define SDMMC_IDINTEN_RI_Pos                                  1                                                         /*!< SDMMC IDINTEN: RI Position          */
#define SDMMC_IDINTEN_RI_Msk                                  (0x01UL << SDMMC_IDINTEN_RI_Pos)                          /*!< SDMMC IDINTEN: RI Mask              */
#define SDMMC_IDINTEN_FBE_Pos                                 2                                                         /*!< SDMMC IDINTEN: FBE Position         */
#define SDMMC_IDINTEN_FBE_Msk                                 (0x01UL << SDMMC_IDINTEN_FBE_Pos)                         /*!< SDMMC IDINTEN: FBE Mask             */
#define SDMMC_IDINTEN_DU_Pos                                  4                                                         /*!< SDMMC IDINTEN: DU Position          */
#define SDMMC_IDINTEN_DU_Msk                                  (0x01UL << SDMMC_IDINTEN_DU_Pos)                          /*!< SDMMC IDINTEN: DU Mask              */
#define SDMMC_IDINTEN_CES_Pos                                 5                                                         /*!< SDMMC IDINTEN: CES Position         */
#define SDMMC_IDINTEN_CES_Msk                                 (0x01UL << SDMMC_IDINTEN_CES_Pos)                         /*!< SDMMC IDINTEN: CES Mask             */
#define SDMMC_IDINTEN_NIS_Pos                                 8                                                         /*!< SDMMC IDINTEN: NIS Position         */
#define SDMMC_IDINTEN_NIS_Msk                                 (0x01UL << SDMMC_IDINTEN_NIS_Pos)                         /*!< SDMMC IDINTEN: NIS Mask             */
#define SDMMC_IDINTEN_AIS_Pos                                 9                                                         /*!< SDMMC IDINTEN: AIS Position         */
#define SDMMC_IDINTEN_AIS_Msk                                 (0x01UL << SDMMC_IDINTEN_AIS_Pos)                         /*!< SDMMC IDINTEN: AIS Mask             */

// --------------------------------------  SDMMC_DSCADDR  -----------------------------------------
#define SDMMC_DSCADDR_HDA_Pos                                 0                                                         /*!< SDMMC DSCADDR: HDA Position         */
#define SDMMC_DSCADDR_HDA_Msk                                 (0xffffffffUL << SDMMC_DSCADDR_HDA_Pos)                   /*!< SDMMC DSCADDR: HDA Mask             */

// --------------------------------------  SDMMC_BUFADDR  -----------------------------------------
#define SDMMC_BUFADDR_HBA_Pos                                 0                                                         /*!< SDMMC BUFADDR: HBA Position         */
#define SDMMC_BUFADDR_HBA_Msk                                 (0xffffffffUL << SDMMC_BUFADDR_HBA_Pos)                   /*!< SDMMC BUFADDR: HBA Mask             */


// ------------------------------------------------------------------------------------------------
// -----                                  EMC Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  EMC_CONTROL  ------------------------------------------
#define EMC_CONTROL_E_Pos                                     0                                                         /*!< EMC CONTROL: E Position             */
#define EMC_CONTROL_E_Msk                                     (0x01UL << EMC_CONTROL_E_Pos)                             /*!< EMC CONTROL: E Mask                 */
#define EMC_CONTROL_M_Pos                                     1                                                         /*!< EMC CONTROL: M Position             */
#define EMC_CONTROL_M_Msk                                     (0x01UL << EMC_CONTROL_M_Pos)                             /*!< EMC CONTROL: M Mask                 */
#define EMC_CONTROL_L_Pos                                     2                                                         /*!< EMC CONTROL: L Position             */
#define EMC_CONTROL_L_Msk                                     (0x01UL << EMC_CONTROL_L_Pos)                             /*!< EMC CONTROL: L Mask                 */

// ---------------------------------------  EMC_STATUS  -------------------------------------------
#define EMC_STATUS_B_Pos                                      0                                                         /*!< EMC STATUS: B Position              */
#define EMC_STATUS_B_Msk                                      (0x01UL << EMC_STATUS_B_Pos)                              /*!< EMC STATUS: B Mask                  */
#define EMC_STATUS_S_Pos                                      1                                                         /*!< EMC STATUS: S Position              */
#define EMC_STATUS_S_Msk                                      (0x01UL << EMC_STATUS_S_Pos)                              /*!< EMC STATUS: S Mask                  */
#define EMC_STATUS_SA_Pos                                     2                                                         /*!< EMC STATUS: SA Position             */
#define EMC_STATUS_SA_Msk                                     (0x01UL << EMC_STATUS_SA_Pos)                             /*!< EMC STATUS: SA Mask                 */

// ---------------------------------------  EMC_CONFIG  -------------------------------------------
#define EMC_CONFIG_EM_Pos                                     0                                                         /*!< EMC CONFIG: EM Position             */
#define EMC_CONFIG_EM_Msk                                     (0x01UL << EMC_CONFIG_EM_Pos)                             /*!< EMC CONFIG: EM Mask                 */
#define EMC_CONFIG_CR_Pos                                     8                                                         /*!< EMC CONFIG: CR Position             */
#define EMC_CONFIG_CR_Msk                                     (0x01UL << EMC_CONFIG_CR_Pos)                             /*!< EMC CONFIG: CR Mask                 */

// -----------------------------------  EMC_DYNAMICCONTROL  ---------------------------------------
#define EMC_DYNAMICCONTROL_CE_Pos                             0                                                         /*!< EMC DYNAMICCONTROL: CE Position     */
#define EMC_DYNAMICCONTROL_CE_Msk                             (0x01UL << EMC_DYNAMICCONTROL_CE_Pos)                     /*!< EMC DYNAMICCONTROL: CE Mask         */
#define EMC_DYNAMICCONTROL_CS_Pos                             1                                                         /*!< EMC DYNAMICCONTROL: CS Position     */
#define EMC_DYNAMICCONTROL_CS_Msk                             (0x01UL << EMC_DYNAMICCONTROL_CS_Pos)                     /*!< EMC DYNAMICCONTROL: CS Mask         */
#define EMC_DYNAMICCONTROL_SR_Pos                             2                                                         /*!< EMC DYNAMICCONTROL: SR Position     */
#define EMC_DYNAMICCONTROL_SR_Msk                             (0x01UL << EMC_DYNAMICCONTROL_SR_Pos)                     /*!< EMC DYNAMICCONTROL: SR Mask         */
#define EMC_DYNAMICCONTROL_MMC_Pos                            5                                                         /*!< EMC DYNAMICCONTROL: MMC Position    */
#define EMC_DYNAMICCONTROL_MMC_Msk                            (0x01UL << EMC_DYNAMICCONTROL_MMC_Pos)                    /*!< EMC DYNAMICCONTROL: MMC Mask        */
#define EMC_DYNAMICCONTROL_I_Pos                              7                                                         /*!< EMC DYNAMICCONTROL: I Position      */
#define EMC_DYNAMICCONTROL_I_Msk                              (0x03UL << EMC_DYNAMICCONTROL_I_Pos)                      /*!< EMC DYNAMICCONTROL: I Mask          */
#define EMC_DYNAMICCONTROL_DP_Pos                             13                                                        /*!< EMC DYNAMICCONTROL: DP Position     */
#define EMC_DYNAMICCONTROL_DP_Msk                             (0x01UL << EMC_DYNAMICCONTROL_DP_Pos)                     /*!< EMC DYNAMICCONTROL: DP Mask         */

// -----------------------------------  EMC_DYNAMICREFRESH  ---------------------------------------
#define EMC_DYNAMICREFRESH_REFRESH_Pos                        0                                                         /*!< EMC DYNAMICREFRESH: REFRESH Position */
#define EMC_DYNAMICREFRESH_REFRESH_Msk                        (0x000007ffUL << EMC_DYNAMICREFRESH_REFRESH_Pos)          /*!< EMC DYNAMICREFRESH: REFRESH Mask    */

// ----------------------------------  EMC_DYNAMICREADCONFIG  -------------------------------------
#define EMC_DYNAMICREADCONFIG_RD_Pos                          0                                                         /*!< EMC DYNAMICREADCONFIG: RD Position  */
#define EMC_DYNAMICREADCONFIG_RD_Msk                          (0x03UL << EMC_DYNAMICREADCONFIG_RD_Pos)                  /*!< EMC DYNAMICREADCONFIG: RD Mask      */

// --------------------------------------  EMC_DYNAMICRP  -----------------------------------------
#define EMC_DYNAMICRP_tRP_Pos                                 0                                                         /*!< EMC DYNAMICRP: tRP Position         */
#define EMC_DYNAMICRP_tRP_Msk                                 (0x0fUL << EMC_DYNAMICRP_tRP_Pos)                         /*!< EMC DYNAMICRP: tRP Mask             */

// -------------------------------------  EMC_DYNAMICRAS  -----------------------------------------
#define EMC_DYNAMICRAS_tRAS_Pos                               0                                                         /*!< EMC DYNAMICRAS: tRAS Position       */
#define EMC_DYNAMICRAS_tRAS_Msk                               (0x0fUL << EMC_DYNAMICRAS_tRAS_Pos)                       /*!< EMC DYNAMICRAS: tRAS Mask           */

// -------------------------------------  EMC_DYNAMICSREX  ----------------------------------------
#define EMC_DYNAMICSREX_tSREX_Pos                             0                                                         /*!< EMC DYNAMICSREX: tSREX Position     */
#define EMC_DYNAMICSREX_tSREX_Msk                             (0x0fUL << EMC_DYNAMICSREX_tSREX_Pos)                     /*!< EMC DYNAMICSREX: tSREX Mask         */

// -------------------------------------  EMC_DYNAMICAPR  -----------------------------------------
#define EMC_DYNAMICAPR_tAPR_Pos                               0                                                         /*!< EMC DYNAMICAPR: tAPR Position       */
#define EMC_DYNAMICAPR_tAPR_Msk                               (0x0fUL << EMC_DYNAMICAPR_tAPR_Pos)                       /*!< EMC DYNAMICAPR: tAPR Mask           */

// -------------------------------------  EMC_DYNAMICDAL  -----------------------------------------
#define EMC_DYNAMICDAL_tDAL_Pos                               0                                                         /*!< EMC DYNAMICDAL: tDAL Position       */
#define EMC_DYNAMICDAL_tDAL_Msk                               (0x0fUL << EMC_DYNAMICDAL_tDAL_Pos)                       /*!< EMC DYNAMICDAL: tDAL Mask           */

// --------------------------------------  EMC_DYNAMICWR  -----------------------------------------
#define EMC_DYNAMICWR_tWR_Pos                                 0                                                         /*!< EMC DYNAMICWR: tWR Position         */
#define EMC_DYNAMICWR_tWR_Msk                                 (0x0fUL << EMC_DYNAMICWR_tWR_Pos)                         /*!< EMC DYNAMICWR: tWR Mask             */

// --------------------------------------  EMC_DYNAMICRC  -----------------------------------------
#define EMC_DYNAMICRC_tRC_Pos                                 0                                                         /*!< EMC DYNAMICRC: tRC Position         */
#define EMC_DYNAMICRC_tRC_Msk                                 (0x1fUL << EMC_DYNAMICRC_tRC_Pos)                         /*!< EMC DYNAMICRC: tRC Mask             */

// -------------------------------------  EMC_DYNAMICRFC  -----------------------------------------
#define EMC_DYNAMICRFC_tRFC_Pos                               0                                                         /*!< EMC DYNAMICRFC: tRFC Position       */
#define EMC_DYNAMICRFC_tRFC_Msk                               (0x1fUL << EMC_DYNAMICRFC_tRFC_Pos)                       /*!< EMC DYNAMICRFC: tRFC Mask           */

// -------------------------------------  EMC_DYNAMICXSR  -----------------------------------------
#define EMC_DYNAMICXSR_tXSR_Pos                               0                                                         /*!< EMC DYNAMICXSR: tXSR Position       */
#define EMC_DYNAMICXSR_tXSR_Msk                               (0x1fUL << EMC_DYNAMICXSR_tXSR_Pos)                       /*!< EMC DYNAMICXSR: tXSR Mask           */

// -------------------------------------  EMC_DYNAMICRRD  -----------------------------------------
#define EMC_DYNAMICRRD_tRRD_Pos                               0                                                         /*!< EMC DYNAMICRRD: tRRD Position       */
#define EMC_DYNAMICRRD_tRRD_Msk                               (0x0fUL << EMC_DYNAMICRRD_tRRD_Pos)                       /*!< EMC DYNAMICRRD: tRRD Mask           */

// -------------------------------------  EMC_DYNAMICMRD  -----------------------------------------
#define EMC_DYNAMICMRD_tMRD_Pos                               0                                                         /*!< EMC DYNAMICMRD: tMRD Position       */
#define EMC_DYNAMICMRD_tMRD_Msk                               (0x0fUL << EMC_DYNAMICMRD_tMRD_Pos)                       /*!< EMC DYNAMICMRD: tMRD Mask           */

// ---------------------------------  EMC_STATICEXTENDEDWAIT  -------------------------------------
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos               0                                                         /*!< EMC STATICEXTENDEDWAIT: EXTENDEDWAIT Position */
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Msk               (0x000003ffUL << EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos) /*!< EMC STATICEXTENDEDWAIT: EXTENDEDWAIT Mask */

// -----------------------------------  EMC_DYNAMICCONFIG0  ---------------------------------------
#define EMC_DYNAMICCONFIG0_MD_Pos                             3                                                         /*!< EMC DYNAMICCONFIG0: MD Position     */
#define EMC_DYNAMICCONFIG0_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG0_MD_Pos)                     /*!< EMC DYNAMICCONFIG0: MD Mask         */
#define EMC_DYNAMICCONFIG0_AM0_Pos                            7                                                         /*!< EMC DYNAMICCONFIG0: AM0 Position    */
#define EMC_DYNAMICCONFIG0_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG0_AM0_Pos)                    /*!< EMC DYNAMICCONFIG0: AM0 Mask        */
#define EMC_DYNAMICCONFIG0_AM1_Pos                            14                                                        /*!< EMC DYNAMICCONFIG0: AM1 Position    */
#define EMC_DYNAMICCONFIG0_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG0_AM1_Pos)                    /*!< EMC DYNAMICCONFIG0: AM1 Mask        */
#define EMC_DYNAMICCONFIG0_B_Pos                              19                                                        /*!< EMC DYNAMICCONFIG0: B Position      */
#define EMC_DYNAMICCONFIG0_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG0_B_Pos)                      /*!< EMC DYNAMICCONFIG0: B Mask          */
#define EMC_DYNAMICCONFIG0_P_Pos                              20                                                        /*!< EMC DYNAMICCONFIG0: P Position      */
#define EMC_DYNAMICCONFIG0_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG0_P_Pos)                      /*!< EMC DYNAMICCONFIG0: P Mask          */

// -----------------------------------  EMC_DYNAMICRASCAS0  ---------------------------------------
#define EMC_DYNAMICRASCAS0_RAS_Pos                            0                                                         /*!< EMC DYNAMICRASCAS0: RAS Position    */
#define EMC_DYNAMICRASCAS0_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS0_RAS_Pos)                    /*!< EMC DYNAMICRASCAS0: RAS Mask        */
#define EMC_DYNAMICRASCAS0_CAS_Pos                            8                                                         /*!< EMC DYNAMICRASCAS0: CAS Position    */
#define EMC_DYNAMICRASCAS0_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS0_CAS_Pos)                    /*!< EMC DYNAMICRASCAS0: CAS Mask        */

// -----------------------------------  EMC_DYNAMICCONFIG1  ---------------------------------------
#define EMC_DYNAMICCONFIG1_MD_Pos                             3                                                         /*!< EMC DYNAMICCONFIG1: MD Position     */
#define EMC_DYNAMICCONFIG1_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG1_MD_Pos)                     /*!< EMC DYNAMICCONFIG1: MD Mask         */
#define EMC_DYNAMICCONFIG1_AM0_Pos                            7                                                         /*!< EMC DYNAMICCONFIG1: AM0 Position    */
#define EMC_DYNAMICCONFIG1_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG1_AM0_Pos)                    /*!< EMC DYNAMICCONFIG1: AM0 Mask        */
#define EMC_DYNAMICCONFIG1_AM1_Pos                            14                                                        /*!< EMC DYNAMICCONFIG1: AM1 Position    */
#define EMC_DYNAMICCONFIG1_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG1_AM1_Pos)                    /*!< EMC DYNAMICCONFIG1: AM1 Mask        */
#define EMC_DYNAMICCONFIG1_B_Pos                              19                                                        /*!< EMC DYNAMICCONFIG1: B Position      */
#define EMC_DYNAMICCONFIG1_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG1_B_Pos)                      /*!< EMC DYNAMICCONFIG1: B Mask          */
#define EMC_DYNAMICCONFIG1_P_Pos                              20                                                        /*!< EMC DYNAMICCONFIG1: P Position      */
#define EMC_DYNAMICCONFIG1_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG1_P_Pos)                      /*!< EMC DYNAMICCONFIG1: P Mask          */

// -----------------------------------  EMC_DYNAMICRASCAS1  ---------------------------------------
#define EMC_DYNAMICRASCAS1_RAS_Pos                            0                                                         /*!< EMC DYNAMICRASCAS1: RAS Position    */
#define EMC_DYNAMICRASCAS1_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS1_RAS_Pos)                    /*!< EMC DYNAMICRASCAS1: RAS Mask        */
#define EMC_DYNAMICRASCAS1_CAS_Pos                            8                                                         /*!< EMC DYNAMICRASCAS1: CAS Position    */
#define EMC_DYNAMICRASCAS1_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS1_CAS_Pos)                    /*!< EMC DYNAMICRASCAS1: CAS Mask        */

// -----------------------------------  EMC_DYNAMICCONFIG2  ---------------------------------------
#define EMC_DYNAMICCONFIG2_MD_Pos                             3                                                         /*!< EMC DYNAMICCONFIG2: MD Position     */
#define EMC_DYNAMICCONFIG2_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG2_MD_Pos)                     /*!< EMC DYNAMICCONFIG2: MD Mask         */
#define EMC_DYNAMICCONFIG2_AM0_Pos                            7                                                         /*!< EMC DYNAMICCONFIG2: AM0 Position    */
#define EMC_DYNAMICCONFIG2_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG2_AM0_Pos)                    /*!< EMC DYNAMICCONFIG2: AM0 Mask        */
#define EMC_DYNAMICCONFIG2_AM1_Pos                            14                                                        /*!< EMC DYNAMICCONFIG2: AM1 Position    */
#define EMC_DYNAMICCONFIG2_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG2_AM1_Pos)                    /*!< EMC DYNAMICCONFIG2: AM1 Mask        */
#define EMC_DYNAMICCONFIG2_B_Pos                              19                                                        /*!< EMC DYNAMICCONFIG2: B Position      */
#define EMC_DYNAMICCONFIG2_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG2_B_Pos)                      /*!< EMC DYNAMICCONFIG2: B Mask          */
#define EMC_DYNAMICCONFIG2_P_Pos                              20                                                        /*!< EMC DYNAMICCONFIG2: P Position      */
#define EMC_DYNAMICCONFIG2_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG2_P_Pos)                      /*!< EMC DYNAMICCONFIG2: P Mask          */

// -----------------------------------  EMC_DYNAMICRASCAS2  ---------------------------------------
#define EMC_DYNAMICRASCAS2_RAS_Pos                            0                                                         /*!< EMC DYNAMICRASCAS2: RAS Position    */
#define EMC_DYNAMICRASCAS2_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS2_RAS_Pos)                    /*!< EMC DYNAMICRASCAS2: RAS Mask        */
#define EMC_DYNAMICRASCAS2_CAS_Pos                            8                                                         /*!< EMC DYNAMICRASCAS2: CAS Position    */
#define EMC_DYNAMICRASCAS2_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS2_CAS_Pos)                    /*!< EMC DYNAMICRASCAS2: CAS Mask        */

// -----------------------------------  EMC_DYNAMICCONFIG3  ---------------------------------------
#define EMC_DYNAMICCONFIG3_MD_Pos                             3                                                         /*!< EMC DYNAMICCONFIG3: MD Position     */
#define EMC_DYNAMICCONFIG3_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG3_MD_Pos)                     /*!< EMC DYNAMICCONFIG3: MD Mask         */
#define EMC_DYNAMICCONFIG3_AM0_Pos                            7                                                         /*!< EMC DYNAMICCONFIG3: AM0 Position    */
#define EMC_DYNAMICCONFIG3_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG3_AM0_Pos)                    /*!< EMC DYNAMICCONFIG3: AM0 Mask        */
#define EMC_DYNAMICCONFIG3_AM1_Pos                            14                                                        /*!< EMC DYNAMICCONFIG3: AM1 Position    */
#define EMC_DYNAMICCONFIG3_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG3_AM1_Pos)                    /*!< EMC DYNAMICCONFIG3: AM1 Mask        */
#define EMC_DYNAMICCONFIG3_B_Pos                              19                                                        /*!< EMC DYNAMICCONFIG3: B Position      */
#define EMC_DYNAMICCONFIG3_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG3_B_Pos)                      /*!< EMC DYNAMICCONFIG3: B Mask          */
#define EMC_DYNAMICCONFIG3_P_Pos                              20                                                        /*!< EMC DYNAMICCONFIG3: P Position      */
#define EMC_DYNAMICCONFIG3_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG3_P_Pos)                      /*!< EMC DYNAMICCONFIG3: P Mask          */

// -----------------------------------  EMC_DYNAMICRASCAS3  ---------------------------------------
#define EMC_DYNAMICRASCAS3_RAS_Pos                            0                                                         /*!< EMC DYNAMICRASCAS3: RAS Position    */
#define EMC_DYNAMICRASCAS3_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS3_RAS_Pos)                    /*!< EMC DYNAMICRASCAS3: RAS Mask        */
#define EMC_DYNAMICRASCAS3_CAS_Pos                            8                                                         /*!< EMC DYNAMICRASCAS3: CAS Position    */
#define EMC_DYNAMICRASCAS3_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS3_CAS_Pos)                    /*!< EMC DYNAMICRASCAS3: CAS Mask        */

// ------------------------------------  EMC_STATICCONFIG0  ---------------------------------------
#define EMC_STATICCONFIG0_MW_Pos                              0                                                         /*!< EMC STATICCONFIG0: MW Position      */
#define EMC_STATICCONFIG0_MW_Msk                              (0x03UL << EMC_STATICCONFIG0_MW_Pos)                      /*!< EMC STATICCONFIG0: MW Mask          */
#define EMC_STATICCONFIG0_PM_Pos                              3                                                         /*!< EMC STATICCONFIG0: PM Position      */
#define EMC_STATICCONFIG0_PM_Msk                              (0x01UL << EMC_STATICCONFIG0_PM_Pos)                      /*!< EMC STATICCONFIG0: PM Mask          */
#define EMC_STATICCONFIG0_PC_Pos                              6                                                         /*!< EMC STATICCONFIG0: PC Position      */
#define EMC_STATICCONFIG0_PC_Msk                              (0x01UL << EMC_STATICCONFIG0_PC_Pos)                      /*!< EMC STATICCONFIG0: PC Mask          */
#define EMC_STATICCONFIG0_PB_Pos                              7                                                         /*!< EMC STATICCONFIG0: PB Position      */
#define EMC_STATICCONFIG0_PB_Msk                              (0x01UL << EMC_STATICCONFIG0_PB_Pos)                      /*!< EMC STATICCONFIG0: PB Mask          */
#define EMC_STATICCONFIG0_EW_Pos                              8                                                         /*!< EMC STATICCONFIG0: EW Position      */
#define EMC_STATICCONFIG0_EW_Msk                              (0x01UL << EMC_STATICCONFIG0_EW_Pos)                      /*!< EMC STATICCONFIG0: EW Mask          */
#define EMC_STATICCONFIG0_B_Pos                               19                                                        /*!< EMC STATICCONFIG0: B Position       */
#define EMC_STATICCONFIG0_B_Msk                               (0x01UL << EMC_STATICCONFIG0_B_Pos)                       /*!< EMC STATICCONFIG0: B Mask           */
#define EMC_STATICCONFIG0_P_Pos                               20                                                        /*!< EMC STATICCONFIG0: P Position       */
#define EMC_STATICCONFIG0_P_Msk                               (0x01UL << EMC_STATICCONFIG0_P_Pos)                       /*!< EMC STATICCONFIG0: P Mask           */

// -----------------------------------  EMC_STATICWAITWEN0  ---------------------------------------
#define EMC_STATICWAITWEN0_WAITWEN_Pos                        0                                                         /*!< EMC STATICWAITWEN0: WAITWEN Position */
#define EMC_STATICWAITWEN0_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN0_WAITWEN_Pos)                /*!< EMC STATICWAITWEN0: WAITWEN Mask    */

// -----------------------------------  EMC_STATICWAITOEN0  ---------------------------------------
#define EMC_STATICWAITOEN0_WAITOEN_Pos                        0                                                         /*!< EMC STATICWAITOEN0: WAITOEN Position */
#define EMC_STATICWAITOEN0_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN0_WAITOEN_Pos)                /*!< EMC STATICWAITOEN0: WAITOEN Mask    */

// ------------------------------------  EMC_STATICWAITRD0  ---------------------------------------
#define EMC_STATICWAITRD0_WAITRD_Pos                          0                                                         /*!< EMC STATICWAITRD0: WAITRD Position  */
#define EMC_STATICWAITRD0_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD0_WAITRD_Pos)                  /*!< EMC STATICWAITRD0: WAITRD Mask      */

// -----------------------------------  EMC_STATICWAITPAG0  ---------------------------------------
#define EMC_STATICWAITPAG0_WAITPAGE_Pos                       0                                                         /*!< EMC STATICWAITPAG0: WAITPAGE Position */
#define EMC_STATICWAITPAG0_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG0_WAITPAGE_Pos)               /*!< EMC STATICWAITPAG0: WAITPAGE Mask   */

// ------------------------------------  EMC_STATICWAITWR0  ---------------------------------------
#define EMC_STATICWAITWR0_WAITWR_Pos                          0                                                         /*!< EMC STATICWAITWR0: WAITWR Position  */
#define EMC_STATICWAITWR0_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR0_WAITWR_Pos)                  /*!< EMC STATICWAITWR0: WAITWR Mask      */

// -----------------------------------  EMC_STATICWAITTURN0  --------------------------------------
#define EMC_STATICWAITTURN0_WAITTURN_Pos                      0                                                         /*!< EMC STATICWAITTURN0: WAITTURN Position */
#define EMC_STATICWAITTURN0_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN0_WAITTURN_Pos)              /*!< EMC STATICWAITTURN0: WAITTURN Mask  */

// ------------------------------------  EMC_STATICCONFIG1  ---------------------------------------
#define EMC_STATICCONFIG1_MW_Pos                              0                                                         /*!< EMC STATICCONFIG1: MW Position      */
#define EMC_STATICCONFIG1_MW_Msk                              (0x03UL << EMC_STATICCONFIG1_MW_Pos)                      /*!< EMC STATICCONFIG1: MW Mask          */
#define EMC_STATICCONFIG1_PM_Pos                              3                                                         /*!< EMC STATICCONFIG1: PM Position      */
#define EMC_STATICCONFIG1_PM_Msk                              (0x01UL << EMC_STATICCONFIG1_PM_Pos)                      /*!< EMC STATICCONFIG1: PM Mask          */
#define EMC_STATICCONFIG1_PC_Pos                              6                                                         /*!< EMC STATICCONFIG1: PC Position      */
#define EMC_STATICCONFIG1_PC_Msk                              (0x01UL << EMC_STATICCONFIG1_PC_Pos)                      /*!< EMC STATICCONFIG1: PC Mask          */
#define EMC_STATICCONFIG1_PB_Pos                              7                                                         /*!< EMC STATICCONFIG1: PB Position      */
#define EMC_STATICCONFIG1_PB_Msk                              (0x01UL << EMC_STATICCONFIG1_PB_Pos)                      /*!< EMC STATICCONFIG1: PB Mask          */
#define EMC_STATICCONFIG1_EW_Pos                              8                                                         /*!< EMC STATICCONFIG1: EW Position      */
#define EMC_STATICCONFIG1_EW_Msk                              (0x01UL << EMC_STATICCONFIG1_EW_Pos)                      /*!< EMC STATICCONFIG1: EW Mask          */
#define EMC_STATICCONFIG1_B_Pos                               19                                                        /*!< EMC STATICCONFIG1: B Position       */
#define EMC_STATICCONFIG1_B_Msk                               (0x01UL << EMC_STATICCONFIG1_B_Pos)                       /*!< EMC STATICCONFIG1: B Mask           */
#define EMC_STATICCONFIG1_P_Pos                               20                                                        /*!< EMC STATICCONFIG1: P Position       */
#define EMC_STATICCONFIG1_P_Msk                               (0x01UL << EMC_STATICCONFIG1_P_Pos)                       /*!< EMC STATICCONFIG1: P Mask           */

// -----------------------------------  EMC_STATICWAITWEN1  ---------------------------------------
#define EMC_STATICWAITWEN1_WAITWEN_Pos                        0                                                         /*!< EMC STATICWAITWEN1: WAITWEN Position */
#define EMC_STATICWAITWEN1_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN1_WAITWEN_Pos)                /*!< EMC STATICWAITWEN1: WAITWEN Mask    */

// -----------------------------------  EMC_STATICWAITOEN1  ---------------------------------------
#define EMC_STATICWAITOEN1_WAITOEN_Pos                        0                                                         /*!< EMC STATICWAITOEN1: WAITOEN Position */
#define EMC_STATICWAITOEN1_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN1_WAITOEN_Pos)                /*!< EMC STATICWAITOEN1: WAITOEN Mask    */

// ------------------------------------  EMC_STATICWAITRD1  ---------------------------------------
#define EMC_STATICWAITRD1_WAITRD_Pos                          0                                                         /*!< EMC STATICWAITRD1: WAITRD Position  */
#define EMC_STATICWAITRD1_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD1_WAITRD_Pos)                  /*!< EMC STATICWAITRD1: WAITRD Mask      */

// -----------------------------------  EMC_STATICWAITPAG1  ---------------------------------------
#define EMC_STATICWAITPAG1_WAITPAGE_Pos                       0                                                         /*!< EMC STATICWAITPAG1: WAITPAGE Position */
#define EMC_STATICWAITPAG1_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG1_WAITPAGE_Pos)               /*!< EMC STATICWAITPAG1: WAITPAGE Mask   */

// ------------------------------------  EMC_STATICWAITWR1  ---------------------------------------
#define EMC_STATICWAITWR1_WAITWR_Pos                          0                                                         /*!< EMC STATICWAITWR1: WAITWR Position  */
#define EMC_STATICWAITWR1_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR1_WAITWR_Pos)                  /*!< EMC STATICWAITWR1: WAITWR Mask      */

// -----------------------------------  EMC_STATICWAITTURN1  --------------------------------------
#define EMC_STATICWAITTURN1_WAITTURN_Pos                      0                                                         /*!< EMC STATICWAITTURN1: WAITTURN Position */
#define EMC_STATICWAITTURN1_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN1_WAITTURN_Pos)              /*!< EMC STATICWAITTURN1: WAITTURN Mask  */

// ------------------------------------  EMC_STATICCONFIG2  ---------------------------------------
#define EMC_STATICCONFIG2_MW_Pos                              0                                                         /*!< EMC STATICCONFIG2: MW Position      */
#define EMC_STATICCONFIG2_MW_Msk                              (0x03UL << EMC_STATICCONFIG2_MW_Pos)                      /*!< EMC STATICCONFIG2: MW Mask          */
#define EMC_STATICCONFIG2_PM_Pos                              3                                                         /*!< EMC STATICCONFIG2: PM Position      */
#define EMC_STATICCONFIG2_PM_Msk                              (0x01UL << EMC_STATICCONFIG2_PM_Pos)                      /*!< EMC STATICCONFIG2: PM Mask          */
#define EMC_STATICCONFIG2_PC_Pos                              6                                                         /*!< EMC STATICCONFIG2: PC Position      */
#define EMC_STATICCONFIG2_PC_Msk                              (0x01UL << EMC_STATICCONFIG2_PC_Pos)                      /*!< EMC STATICCONFIG2: PC Mask          */
#define EMC_STATICCONFIG2_PB_Pos                              7                                                         /*!< EMC STATICCONFIG2: PB Position      */
#define EMC_STATICCONFIG2_PB_Msk                              (0x01UL << EMC_STATICCONFIG2_PB_Pos)                      /*!< EMC STATICCONFIG2: PB Mask          */
#define EMC_STATICCONFIG2_EW_Pos                              8                                                         /*!< EMC STATICCONFIG2: EW Position      */
#define EMC_STATICCONFIG2_EW_Msk                              (0x01UL << EMC_STATICCONFIG2_EW_Pos)                      /*!< EMC STATICCONFIG2: EW Mask          */
#define EMC_STATICCONFIG2_B_Pos                               19                                                        /*!< EMC STATICCONFIG2: B Position       */
#define EMC_STATICCONFIG2_B_Msk                               (0x01UL << EMC_STATICCONFIG2_B_Pos)                       /*!< EMC STATICCONFIG2: B Mask           */
#define EMC_STATICCONFIG2_P_Pos                               20                                                        /*!< EMC STATICCONFIG2: P Position       */
#define EMC_STATICCONFIG2_P_Msk                               (0x01UL << EMC_STATICCONFIG2_P_Pos)                       /*!< EMC STATICCONFIG2: P Mask           */

// -----------------------------------  EMC_STATICWAITWEN2  ---------------------------------------
#define EMC_STATICWAITWEN2_WAITWEN_Pos                        0                                                         /*!< EMC STATICWAITWEN2: WAITWEN Position */
#define EMC_STATICWAITWEN2_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN2_WAITWEN_Pos)                /*!< EMC STATICWAITWEN2: WAITWEN Mask    */

// -----------------------------------  EMC_STATICWAITOEN2  ---------------------------------------
#define EMC_STATICWAITOEN2_WAITOEN_Pos                        0                                                         /*!< EMC STATICWAITOEN2: WAITOEN Position */
#define EMC_STATICWAITOEN2_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN2_WAITOEN_Pos)                /*!< EMC STATICWAITOEN2: WAITOEN Mask    */

// ------------------------------------  EMC_STATICWAITRD2  ---------------------------------------
#define EMC_STATICWAITRD2_WAITRD_Pos                          0                                                         /*!< EMC STATICWAITRD2: WAITRD Position  */
#define EMC_STATICWAITRD2_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD2_WAITRD_Pos)                  /*!< EMC STATICWAITRD2: WAITRD Mask      */

// -----------------------------------  EMC_STATICWAITPAG2  ---------------------------------------
#define EMC_STATICWAITPAG2_WAITPAGE_Pos                       0                                                         /*!< EMC STATICWAITPAG2: WAITPAGE Position */
#define EMC_STATICWAITPAG2_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG2_WAITPAGE_Pos)               /*!< EMC STATICWAITPAG2: WAITPAGE Mask   */

// ------------------------------------  EMC_STATICWAITWR2  ---------------------------------------
#define EMC_STATICWAITWR2_WAITWR_Pos                          0                                                         /*!< EMC STATICWAITWR2: WAITWR Position  */
#define EMC_STATICWAITWR2_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR2_WAITWR_Pos)                  /*!< EMC STATICWAITWR2: WAITWR Mask      */

// -----------------------------------  EMC_STATICWAITTURN2  --------------------------------------
#define EMC_STATICWAITTURN2_WAITTURN_Pos                      0                                                         /*!< EMC STATICWAITTURN2: WAITTURN Position */
#define EMC_STATICWAITTURN2_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN2_WAITTURN_Pos)              /*!< EMC STATICWAITTURN2: WAITTURN Mask  */

// ------------------------------------  EMC_STATICCONFIG3  ---------------------------------------
#define EMC_STATICCONFIG3_MW_Pos                              0                                                         /*!< EMC STATICCONFIG3: MW Position      */
#define EMC_STATICCONFIG3_MW_Msk                              (0x03UL << EMC_STATICCONFIG3_MW_Pos)                      /*!< EMC STATICCONFIG3: MW Mask          */
#define EMC_STATICCONFIG3_PM_Pos                              3                                                         /*!< EMC STATICCONFIG3: PM Position      */
#define EMC_STATICCONFIG3_PM_Msk                              (0x01UL << EMC_STATICCONFIG3_PM_Pos)                      /*!< EMC STATICCONFIG3: PM Mask          */
#define EMC_STATICCONFIG3_PC_Pos                              6                                                         /*!< EMC STATICCONFIG3: PC Position      */
#define EMC_STATICCONFIG3_PC_Msk                              (0x01UL << EMC_STATICCONFIG3_PC_Pos)                      /*!< EMC STATICCONFIG3: PC Mask          */
#define EMC_STATICCONFIG3_PB_Pos                              7                                                         /*!< EMC STATICCONFIG3: PB Position      */
#define EMC_STATICCONFIG3_PB_Msk                              (0x01UL << EMC_STATICCONFIG3_PB_Pos)                      /*!< EMC STATICCONFIG3: PB Mask          */
#define EMC_STATICCONFIG3_EW_Pos                              8                                                         /*!< EMC STATICCONFIG3: EW Position      */
#define EMC_STATICCONFIG3_EW_Msk                              (0x01UL << EMC_STATICCONFIG3_EW_Pos)                      /*!< EMC STATICCONFIG3: EW Mask          */
#define EMC_STATICCONFIG3_B_Pos                               19                                                        /*!< EMC STATICCONFIG3: B Position       */
#define EMC_STATICCONFIG3_B_Msk                               (0x01UL << EMC_STATICCONFIG3_B_Pos)                       /*!< EMC STATICCONFIG3: B Mask           */
#define EMC_STATICCONFIG3_P_Pos                               20                                                        /*!< EMC STATICCONFIG3: P Position       */
#define EMC_STATICCONFIG3_P_Msk                               (0x01UL << EMC_STATICCONFIG3_P_Pos)                       /*!< EMC STATICCONFIG3: P Mask           */

// -----------------------------------  EMC_STATICWAITWEN3  ---------------------------------------
#define EMC_STATICWAITWEN3_WAITWEN_Pos                        0                                                         /*!< EMC STATICWAITWEN3: WAITWEN Position */
#define EMC_STATICWAITWEN3_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN3_WAITWEN_Pos)                /*!< EMC STATICWAITWEN3: WAITWEN Mask    */

// -----------------------------------  EMC_STATICWAITOEN3  ---------------------------------------
#define EMC_STATICWAITOEN3_WAITOEN_Pos                        0                                                         /*!< EMC STATICWAITOEN3: WAITOEN Position */
#define EMC_STATICWAITOEN3_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN3_WAITOEN_Pos)                /*!< EMC STATICWAITOEN3: WAITOEN Mask    */

// ------------------------------------  EMC_STATICWAITRD3  ---------------------------------------
#define EMC_STATICWAITRD3_WAITRD_Pos                          0                                                         /*!< EMC STATICWAITRD3: WAITRD Position  */
#define EMC_STATICWAITRD3_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD3_WAITRD_Pos)                  /*!< EMC STATICWAITRD3: WAITRD Mask      */

// -----------------------------------  EMC_STATICWAITPAG3  ---------------------------------------
#define EMC_STATICWAITPAG3_WAITPAGE_Pos                       0                                                         /*!< EMC STATICWAITPAG3: WAITPAGE Position */
#define EMC_STATICWAITPAG3_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG3_WAITPAGE_Pos)               /*!< EMC STATICWAITPAG3: WAITPAGE Mask   */

// ------------------------------------  EMC_STATICWAITWR3  ---------------------------------------
#define EMC_STATICWAITWR3_WAITWR_Pos                          0                                                         /*!< EMC STATICWAITWR3: WAITWR Position  */
#define EMC_STATICWAITWR3_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR3_WAITWR_Pos)                  /*!< EMC STATICWAITWR3: WAITWR Mask      */

// -----------------------------------  EMC_STATICWAITTURN3  --------------------------------------
#define EMC_STATICWAITTURN3_WAITTURN_Pos                      0                                                         /*!< EMC STATICWAITTURN3: WAITTURN Position */
#define EMC_STATICWAITTURN3_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN3_WAITTURN_Pos)              /*!< EMC STATICWAITTURN3: WAITTURN Mask  */


// ------------------------------------------------------------------------------------------------
// -----                                 USB0 Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// -------------------------------------  USB0_CAPLENGTH  -----------------------------------------
#define USB0_CAPLENGTH_CAPLENGTH_Pos                          0                                                         /*!< USB0 CAPLENGTH: CAPLENGTH Position  */
#define USB0_CAPLENGTH_CAPLENGTH_Msk                          (0x000000ffUL << USB0_CAPLENGTH_CAPLENGTH_Pos)            /*!< USB0 CAPLENGTH: CAPLENGTH Mask      */
#define USB0_CAPLENGTH_HCIVERSION_Pos                         8                                                         /*!< USB0 CAPLENGTH: HCIVERSION Position */
#define USB0_CAPLENGTH_HCIVERSION_Msk                         (0x0000ffffUL << USB0_CAPLENGTH_HCIVERSION_Pos)           /*!< USB0 CAPLENGTH: HCIVERSION Mask     */

// -------------------------------------  USB0_HCSPARAMS  -----------------------------------------
#define USB0_HCSPARAMS_N_PORTS_Pos                            0                                                         /*!< USB0 HCSPARAMS: N_PORTS Position    */
#define USB0_HCSPARAMS_N_PORTS_Msk                            (0x0fUL << USB0_HCSPARAMS_N_PORTS_Pos)                    /*!< USB0 HCSPARAMS: N_PORTS Mask        */
#define USB0_HCSPARAMS_PPC_Pos                                4                                                         /*!< USB0 HCSPARAMS: PPC Position        */
#define USB0_HCSPARAMS_PPC_Msk                                (0x01UL << USB0_HCSPARAMS_PPC_Pos)                        /*!< USB0 HCSPARAMS: PPC Mask            */
#define USB0_HCSPARAMS_N_PCC_Pos                              8                                                         /*!< USB0 HCSPARAMS: N_PCC Position      */
#define USB0_HCSPARAMS_N_PCC_Msk                              (0x0fUL << USB0_HCSPARAMS_N_PCC_Pos)                      /*!< USB0 HCSPARAMS: N_PCC Mask          */
#define USB0_HCSPARAMS_N_CC_Pos                               12                                                        /*!< USB0 HCSPARAMS: N_CC Position       */
#define USB0_HCSPARAMS_N_CC_Msk                               (0x0fUL << USB0_HCSPARAMS_N_CC_Pos)                       /*!< USB0 HCSPARAMS: N_CC Mask           */
#define USB0_HCSPARAMS_PI_Pos                                 16                                                        /*!< USB0 HCSPARAMS: PI Position         */
#define USB0_HCSPARAMS_PI_Msk                                 (0x01UL << USB0_HCSPARAMS_PI_Pos)                         /*!< USB0 HCSPARAMS: PI Mask             */
#define USB0_HCSPARAMS_N_PTT_Pos                              20                                                        /*!< USB0 HCSPARAMS: N_PTT Position      */
#define USB0_HCSPARAMS_N_PTT_Msk                              (0x0fUL << USB0_HCSPARAMS_N_PTT_Pos)                      /*!< USB0 HCSPARAMS: N_PTT Mask          */
#define USB0_HCSPARAMS_N_TT_Pos                               24                                                        /*!< USB0 HCSPARAMS: N_TT Position       */
#define USB0_HCSPARAMS_N_TT_Msk                               (0x0fUL << USB0_HCSPARAMS_N_TT_Pos)                       /*!< USB0 HCSPARAMS: N_TT Mask           */

// -------------------------------------  USB0_HCCPARAMS  -----------------------------------------
#define USB0_HCCPARAMS_ADC_Pos                                0                                                         /*!< USB0 HCCPARAMS: ADC Position        */
#define USB0_HCCPARAMS_ADC_Msk                                (0x01UL << USB0_HCCPARAMS_ADC_Pos)                        /*!< USB0 HCCPARAMS: ADC Mask            */
#define USB0_HCCPARAMS_PFL_Pos                                1                                                         /*!< USB0 HCCPARAMS: PFL Position        */
#define USB0_HCCPARAMS_PFL_Msk                                (0x01UL << USB0_HCCPARAMS_PFL_Pos)                        /*!< USB0 HCCPARAMS: PFL Mask            */
#define USB0_HCCPARAMS_ASP_Pos                                2                                                         /*!< USB0 HCCPARAMS: ASP Position        */
#define USB0_HCCPARAMS_ASP_Msk                                (0x01UL << USB0_HCCPARAMS_ASP_Pos)                        /*!< USB0 HCCPARAMS: ASP Mask            */
#define USB0_HCCPARAMS_IST_Pos                                4                                                         /*!< USB0 HCCPARAMS: IST Position        */
#define USB0_HCCPARAMS_IST_Msk                                (0x0fUL << USB0_HCCPARAMS_IST_Pos)                        /*!< USB0 HCCPARAMS: IST Mask            */
#define USB0_HCCPARAMS_EECP_Pos                               8                                                         /*!< USB0 HCCPARAMS: EECP Position       */
#define USB0_HCCPARAMS_EECP_Msk                               (0x000000ffUL << USB0_HCCPARAMS_EECP_Pos)                 /*!< USB0 HCCPARAMS: EECP Mask           */

// -------------------------------------  USB0_DCIVERSION  ----------------------------------------
#define USB0_DCIVERSION_DCIVERSION_Pos                        0                                                         /*!< USB0 DCIVERSION: DCIVERSION Position */
#define USB0_DCIVERSION_DCIVERSION_Msk                        (0x0000ffffUL << USB0_DCIVERSION_DCIVERSION_Pos)          /*!< USB0 DCIVERSION: DCIVERSION Mask    */

// --------------------------------------  USB0_USBCMD_D  -----------------------------------------
#define USB0_USBCMD_D_RS_Pos                                  0                                                         /*!< USB0 USBCMD_D: RS Position          */
#define USB0_USBCMD_D_RS_Msk                                  (0x01UL << USB0_USBCMD_D_RS_Pos)                          /*!< USB0 USBCMD_D: RS Mask              */
#define USB0_USBCMD_D_RST_Pos                                 1                                                         /*!< USB0 USBCMD_D: RST Position         */
#define USB0_USBCMD_D_RST_Msk                                 (0x01UL << USB0_USBCMD_D_RST_Pos)                         /*!< USB0 USBCMD_D: RST Mask             */
#define USB0_USBCMD_D_SUTW_Pos                                13                                                        /*!< USB0 USBCMD_D: SUTW Position        */
#define USB0_USBCMD_D_SUTW_Msk                                (0x01UL << USB0_USBCMD_D_SUTW_Pos)                        /*!< USB0 USBCMD_D: SUTW Mask            */
#define USB0_USBCMD_D_ATDTW_Pos                               14                                                        /*!< USB0 USBCMD_D: ATDTW Position       */
#define USB0_USBCMD_D_ATDTW_Msk                               (0x01UL << USB0_USBCMD_D_ATDTW_Pos)                       /*!< USB0 USBCMD_D: ATDTW Mask           */
#define USB0_USBCMD_D_ITC_Pos                                 16                                                        /*!< USB0 USBCMD_D: ITC Position         */
#define USB0_USBCMD_D_ITC_Msk                                 (0x000000ffUL << USB0_USBCMD_D_ITC_Pos)                   /*!< USB0 USBCMD_D: ITC Mask             */

// --------------------------------------  USB0_USBCMD_H  -----------------------------------------
#define USB0_USBCMD_H_RS_Pos                                  0                                                         /*!< USB0 USBCMD_H: RS Position          */
#define USB0_USBCMD_H_RS_Msk                                  (0x01UL << USB0_USBCMD_H_RS_Pos)                          /*!< USB0 USBCMD_H: RS Mask              */
#define USB0_USBCMD_H_RST_Pos                                 1                                                         /*!< USB0 USBCMD_H: RST Position         */
#define USB0_USBCMD_H_RST_Msk                                 (0x01UL << USB0_USBCMD_H_RST_Pos)                         /*!< USB0 USBCMD_H: RST Mask             */
#define USB0_USBCMD_H_FS0_Pos                                 2                                                         /*!< USB0 USBCMD_H: FS0 Position         */
#define USB0_USBCMD_H_FS0_Msk                                 (0x01UL << USB0_USBCMD_H_FS0_Pos)                         /*!< USB0 USBCMD_H: FS0 Mask             */
#define USB0_USBCMD_H_FS1_Pos                                 3                                                         /*!< USB0 USBCMD_H: FS1 Position         */
#define USB0_USBCMD_H_FS1_Msk                                 (0x01UL << USB0_USBCMD_H_FS1_Pos)                         /*!< USB0 USBCMD_H: FS1 Mask             */
#define USB0_USBCMD_H_PSE_Pos                                 4                                                         /*!< USB0 USBCMD_H: PSE Position         */
#define USB0_USBCMD_H_PSE_Msk                                 (0x01UL << USB0_USBCMD_H_PSE_Pos)                         /*!< USB0 USBCMD_H: PSE Mask             */
#define USB0_USBCMD_H_ASE_Pos                                 5                                                         /*!< USB0 USBCMD_H: ASE Position         */
#define USB0_USBCMD_H_ASE_Msk                                 (0x01UL << USB0_USBCMD_H_ASE_Pos)                         /*!< USB0 USBCMD_H: ASE Mask             */
#define USB0_USBCMD_H_IAA_Pos                                 6                                                         /*!< USB0 USBCMD_H: IAA Position         */
#define USB0_USBCMD_H_IAA_Msk                                 (0x01UL << USB0_USBCMD_H_IAA_Pos)                         /*!< USB0 USBCMD_H: IAA Mask             */
#define USB0_USBCMD_H_ASP1_0_Pos                              8                                                         /*!< USB0 USBCMD_H: ASP1_0 Position      */
#define USB0_USBCMD_H_ASP1_0_Msk                              (0x03UL << USB0_USBCMD_H_ASP1_0_Pos)                      /*!< USB0 USBCMD_H: ASP1_0 Mask          */
#define USB0_USBCMD_H_ASPE_Pos                                11                                                        /*!< USB0 USBCMD_H: ASPE Position        */
#define USB0_USBCMD_H_ASPE_Msk                                (0x01UL << USB0_USBCMD_H_ASPE_Pos)                        /*!< USB0 USBCMD_H: ASPE Mask            */
#define USB0_USBCMD_H_FS2_Pos                                 15                                                        /*!< USB0 USBCMD_H: FS2 Position         */
#define USB0_USBCMD_H_FS2_Msk                                 (0x01UL << USB0_USBCMD_H_FS2_Pos)                         /*!< USB0 USBCMD_H: FS2 Mask             */
#define USB0_USBCMD_H_ITC_Pos                                 16                                                        /*!< USB0 USBCMD_H: ITC Position         */
#define USB0_USBCMD_H_ITC_Msk                                 (0x000000ffUL << USB0_USBCMD_H_ITC_Pos)                   /*!< USB0 USBCMD_H: ITC Mask             */

// --------------------------------------  USB0_USBSTS_D  -----------------------------------------
#define USB0_USBSTS_D_UI_Pos                                  0                                                         /*!< USB0 USBSTS_D: UI Position          */
#define USB0_USBSTS_D_UI_Msk                                  (0x01UL << USB0_USBSTS_D_UI_Pos)                          /*!< USB0 USBSTS_D: UI Mask              */
#define USB0_USBSTS_D_UEI_Pos                                 1                                                         /*!< USB0 USBSTS_D: UEI Position         */
#define USB0_USBSTS_D_UEI_Msk                                 (0x01UL << USB0_USBSTS_D_UEI_Pos)                         /*!< USB0 USBSTS_D: UEI Mask             */
#define USB0_USBSTS_D_PCI_Pos                                 2                                                         /*!< USB0 USBSTS_D: PCI Position         */
#define USB0_USBSTS_D_PCI_Msk                                 (0x01UL << USB0_USBSTS_D_PCI_Pos)                         /*!< USB0 USBSTS_D: PCI Mask             */
#define USB0_USBSTS_D_AAI_Pos                                 5                                                         /*!< USB0 USBSTS_D: AAI Position         */
#define USB0_USBSTS_D_AAI_Msk                                 (0x01UL << USB0_USBSTS_D_AAI_Pos)                         /*!< USB0 USBSTS_D: AAI Mask             */
#define USB0_USBSTS_D_URI_Pos                                 6                                                         /*!< USB0 USBSTS_D: URI Position         */
#define USB0_USBSTS_D_URI_Msk                                 (0x01UL << USB0_USBSTS_D_URI_Pos)                         /*!< USB0 USBSTS_D: URI Mask             */
#define USB0_USBSTS_D_SRI_Pos                                 7                                                         /*!< USB0 USBSTS_D: SRI Position         */
#define USB0_USBSTS_D_SRI_Msk                                 (0x01UL << USB0_USBSTS_D_SRI_Pos)                         /*!< USB0 USBSTS_D: SRI Mask             */
#define USB0_USBSTS_D_SLI_Pos                                 8                                                         /*!< USB0 USBSTS_D: SLI Position         */
#define USB0_USBSTS_D_SLI_Msk                                 (0x01UL << USB0_USBSTS_D_SLI_Pos)                         /*!< USB0 USBSTS_D: SLI Mask             */
#define USB0_USBSTS_D_NAKI_Pos                                16                                                        /*!< USB0 USBSTS_D: NAKI Position        */
#define USB0_USBSTS_D_NAKI_Msk                                (0x01UL << USB0_USBSTS_D_NAKI_Pos)                        /*!< USB0 USBSTS_D: NAKI Mask            */

// --------------------------------------  USB0_USBSTS_H  -----------------------------------------
#define USB0_USBSTS_H_UI_Pos                                  0                                                         /*!< USB0 USBSTS_H: UI Position          */
#define USB0_USBSTS_H_UI_Msk                                  (0x01UL << USB0_USBSTS_H_UI_Pos)                          /*!< USB0 USBSTS_H: UI Mask              */
#define USB0_USBSTS_H_UEI_Pos                                 1                                                         /*!< USB0 USBSTS_H: UEI Position         */
#define USB0_USBSTS_H_UEI_Msk                                 (0x01UL << USB0_USBSTS_H_UEI_Pos)                         /*!< USB0 USBSTS_H: UEI Mask             */
#define USB0_USBSTS_H_PCI_Pos                                 2                                                         /*!< USB0 USBSTS_H: PCI Position         */
#define USB0_USBSTS_H_PCI_Msk                                 (0x01UL << USB0_USBSTS_H_PCI_Pos)                         /*!< USB0 USBSTS_H: PCI Mask             */
#define USB0_USBSTS_H_FRI_Pos                                 3                                                         /*!< USB0 USBSTS_H: FRI Position         */
#define USB0_USBSTS_H_FRI_Msk                                 (0x01UL << USB0_USBSTS_H_FRI_Pos)                         /*!< USB0 USBSTS_H: FRI Mask             */
#define USB0_USBSTS_H_AAI_Pos                                 5                                                         /*!< USB0 USBSTS_H: AAI Position         */
#define USB0_USBSTS_H_AAI_Msk                                 (0x01UL << USB0_USBSTS_H_AAI_Pos)                         /*!< USB0 USBSTS_H: AAI Mask             */
#define USB0_USBSTS_H_SRI_Pos                                 7                                                         /*!< USB0 USBSTS_H: SRI Position         */
#define USB0_USBSTS_H_SRI_Msk                                 (0x01UL << USB0_USBSTS_H_SRI_Pos)                         /*!< USB0 USBSTS_H: SRI Mask             */
#define USB0_USBSTS_H_HCH_Pos                                 12                                                        /*!< USB0 USBSTS_H: HCH Position         */
#define USB0_USBSTS_H_HCH_Msk                                 (0x01UL << USB0_USBSTS_H_HCH_Pos)                         /*!< USB0 USBSTS_H: HCH Mask             */
#define USB0_USBSTS_H_RCL_Pos                                 13                                                        /*!< USB0 USBSTS_H: RCL Position         */
#define USB0_USBSTS_H_RCL_Msk                                 (0x01UL << USB0_USBSTS_H_RCL_Pos)                         /*!< USB0 USBSTS_H: RCL Mask             */
#define USB0_USBSTS_H_PS_Pos                                  14                                                        /*!< USB0 USBSTS_H: PS Position          */
#define USB0_USBSTS_H_PS_Msk                                  (0x01UL << USB0_USBSTS_H_PS_Pos)                          /*!< USB0 USBSTS_H: PS Mask              */
#define USB0_USBSTS_H_AS_Pos                                  15                                                        /*!< USB0 USBSTS_H: AS Position          */
#define USB0_USBSTS_H_AS_Msk                                  (0x01UL << USB0_USBSTS_H_AS_Pos)                          /*!< USB0 USBSTS_H: AS Mask              */
#define USB0_USBSTS_H_UAI_Pos                                 18                                                        /*!< USB0 USBSTS_H: UAI Position         */
#define USB0_USBSTS_H_UAI_Msk                                 (0x01UL << USB0_USBSTS_H_UAI_Pos)                         /*!< USB0 USBSTS_H: UAI Mask             */
#define USB0_USBSTS_H_UPI_Pos                                 19                                                        /*!< USB0 USBSTS_H: UPI Position         */
#define USB0_USBSTS_H_UPI_Msk                                 (0x01UL << USB0_USBSTS_H_UPI_Pos)                         /*!< USB0 USBSTS_H: UPI Mask             */

// -------------------------------------  USB0_USBINTR_D  -----------------------------------------
#define USB0_USBINTR_D_UE_Pos                                 0                                                         /*!< USB0 USBINTR_D: UE Position         */
#define USB0_USBINTR_D_UE_Msk                                 (0x01UL << USB0_USBINTR_D_UE_Pos)                         /*!< USB0 USBINTR_D: UE Mask             */
#define USB0_USBINTR_D_UEE_Pos                                1                                                         /*!< USB0 USBINTR_D: UEE Position        */
#define USB0_USBINTR_D_UEE_Msk                                (0x01UL << USB0_USBINTR_D_UEE_Pos)                        /*!< USB0 USBINTR_D: UEE Mask            */
#define USB0_USBINTR_D_PCE_Pos                                2                                                         /*!< USB0 USBINTR_D: PCE Position        */
#define USB0_USBINTR_D_PCE_Msk                                (0x01UL << USB0_USBINTR_D_PCE_Pos)                        /*!< USB0 USBINTR_D: PCE Mask            */
#define USB0_USBINTR_D_URE_Pos                                6                                                         /*!< USB0 USBINTR_D: URE Position        */
#define USB0_USBINTR_D_URE_Msk                                (0x01UL << USB0_USBINTR_D_URE_Pos)                        /*!< USB0 USBINTR_D: URE Mask            */
#define USB0_USBINTR_D_SRE_Pos                                7                                                         /*!< USB0 USBINTR_D: SRE Position        */
#define USB0_USBINTR_D_SRE_Msk                                (0x01UL << USB0_USBINTR_D_SRE_Pos)                        /*!< USB0 USBINTR_D: SRE Mask            */
#define USB0_USBINTR_D_SLE_Pos                                8                                                         /*!< USB0 USBINTR_D: SLE Position        */
#define USB0_USBINTR_D_SLE_Msk                                (0x01UL << USB0_USBINTR_D_SLE_Pos)                        /*!< USB0 USBINTR_D: SLE Mask            */
#define USB0_USBINTR_D_NAKE_Pos                               16                                                        /*!< USB0 USBINTR_D: NAKE Position       */
#define USB0_USBINTR_D_NAKE_Msk                               (0x01UL << USB0_USBINTR_D_NAKE_Pos)                       /*!< USB0 USBINTR_D: NAKE Mask           */

// -------------------------------------  USB0_USBINTR_H  -----------------------------------------
#define USB0_USBINTR_H_UE_Pos                                 0                                                         /*!< USB0 USBINTR_H: UE Position         */
#define USB0_USBINTR_H_UE_Msk                                 (0x01UL << USB0_USBINTR_H_UE_Pos)                         /*!< USB0 USBINTR_H: UE Mask             */
#define USB0_USBINTR_H_UEE_Pos                                1                                                         /*!< USB0 USBINTR_H: UEE Position        */
#define USB0_USBINTR_H_UEE_Msk                                (0x01UL << USB0_USBINTR_H_UEE_Pos)                        /*!< USB0 USBINTR_H: UEE Mask            */
#define USB0_USBINTR_H_PCE_Pos                                2                                                         /*!< USB0 USBINTR_H: PCE Position        */
#define USB0_USBINTR_H_PCE_Msk                                (0x01UL << USB0_USBINTR_H_PCE_Pos)                        /*!< USB0 USBINTR_H: PCE Mask            */
#define USB0_USBINTR_H_FRE_Pos                                3                                                         /*!< USB0 USBINTR_H: FRE Position        */
#define USB0_USBINTR_H_FRE_Msk                                (0x01UL << USB0_USBINTR_H_FRE_Pos)                        /*!< USB0 USBINTR_H: FRE Mask            */
#define USB0_USBINTR_H_AAE_Pos                                5                                                         /*!< USB0 USBINTR_H: AAE Position        */
#define USB0_USBINTR_H_AAE_Msk                                (0x01UL << USB0_USBINTR_H_AAE_Pos)                        /*!< USB0 USBINTR_H: AAE Mask            */
#define USB0_USBINTR_H_SRE_Pos                                7                                                         /*!< USB0 USBINTR_H: SRE Position        */
#define USB0_USBINTR_H_SRE_Msk                                (0x01UL << USB0_USBINTR_H_SRE_Pos)                        /*!< USB0 USBINTR_H: SRE Mask            */
#define USB0_USBINTR_H_UAIE_Pos                               18                                                        /*!< USB0 USBINTR_H: UAIE Position       */
#define USB0_USBINTR_H_UAIE_Msk                               (0x01UL << USB0_USBINTR_H_UAIE_Pos)                       /*!< USB0 USBINTR_H: UAIE Mask           */
#define USB0_USBINTR_H_UPIA_Pos                               19                                                        /*!< USB0 USBINTR_H: UPIA Position       */
#define USB0_USBINTR_H_UPIA_Msk                               (0x01UL << USB0_USBINTR_H_UPIA_Pos)                       /*!< USB0 USBINTR_H: UPIA Mask           */

// -------------------------------------  USB0_FRINDEX_D  -----------------------------------------
#define USB0_FRINDEX_D_FRINDEX2_0_Pos                         0                                                         /*!< USB0 FRINDEX_D: FRINDEX2_0 Position */
#define USB0_FRINDEX_D_FRINDEX2_0_Msk                         (0x07UL << USB0_FRINDEX_D_FRINDEX2_0_Pos)                 /*!< USB0 FRINDEX_D: FRINDEX2_0 Mask     */
#define USB0_FRINDEX_D_FRINDEX13_3_Pos                        3                                                         /*!< USB0 FRINDEX_D: FRINDEX13_3 Position */
#define USB0_FRINDEX_D_FRINDEX13_3_Msk                        (0x000007ffUL << USB0_FRINDEX_D_FRINDEX13_3_Pos)          /*!< USB0 FRINDEX_D: FRINDEX13_3 Mask    */

// -------------------------------------  USB0_FRINDEX_H  -----------------------------------------
#define USB0_FRINDEX_H_FRINDEX2_0_Pos                         0                                                         /*!< USB0 FRINDEX_H: FRINDEX2_0 Position */
#define USB0_FRINDEX_H_FRINDEX2_0_Msk                         (0x07UL << USB0_FRINDEX_H_FRINDEX2_0_Pos)                 /*!< USB0 FRINDEX_H: FRINDEX2_0 Mask     */
#define USB0_FRINDEX_H_FRINDEX12_3_Pos                        3                                                         /*!< USB0 FRINDEX_H: FRINDEX12_3 Position */
#define USB0_FRINDEX_H_FRINDEX12_3_Msk                        (0x000003ffUL << USB0_FRINDEX_H_FRINDEX12_3_Pos)          /*!< USB0 FRINDEX_H: FRINDEX12_3 Mask    */

// -------------------------------------  USB0_DEVICEADDR  ----------------------------------------
#define USB0_DEVICEADDR_USBADRA_Pos                           24                                                        /*!< USB0 DEVICEADDR: USBADRA Position   */
#define USB0_DEVICEADDR_USBADRA_Msk                           (0x01UL << USB0_DEVICEADDR_USBADRA_Pos)                   /*!< USB0 DEVICEADDR: USBADRA Mask       */
#define USB0_DEVICEADDR_USBADR_Pos                            25                                                        /*!< USB0 DEVICEADDR: USBADR Position    */
#define USB0_DEVICEADDR_USBADR_Msk                            (0x7fUL << USB0_DEVICEADDR_USBADR_Pos)                    /*!< USB0 DEVICEADDR: USBADR Mask        */

// ----------------------------------  USB0_PERIODICLISTBASE  -------------------------------------
#define USB0_PERIODICLISTBASE_PERBASE31_12_Pos                12                                                        /*!< USB0 PERIODICLISTBASE: PERBASE31_12 Position */
#define USB0_PERIODICLISTBASE_PERBASE31_12_Msk                (0x000fffffUL << USB0_PERIODICLISTBASE_PERBASE31_12_Pos)  /*!< USB0 PERIODICLISTBASE: PERBASE31_12 Mask */

// ----------------------------------  USB0_ENDPOINTLISTADDR  -------------------------------------
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos                 11                                                        /*!< USB0 ENDPOINTLISTADDR: EPBASE31_11 Position */
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Msk                 (0x001fffffUL << USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos)   /*!< USB0 ENDPOINTLISTADDR: EPBASE31_11 Mask */

// -----------------------------------  USB0_ASYNCLISTADDR  ---------------------------------------
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Pos                    5                                                         /*!< USB0 ASYNCLISTADDR: ASYBASE31_5 Position */
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Msk                    (0x07ffffffUL << USB0_ASYNCLISTADDR_ASYBASE31_5_Pos)      /*!< USB0 ASYNCLISTADDR: ASYBASE31_5 Mask */

// ---------------------------------------  USB0_TTCTRL  ------------------------------------------
#define USB0_TTCTRL_TTHA_Pos                                  24                                                        /*!< USB0 TTCTRL: TTHA Position          */
#define USB0_TTCTRL_TTHA_Msk                                  (0x7fUL << USB0_TTCTRL_TTHA_Pos)                          /*!< USB0 TTCTRL: TTHA Mask              */

// -------------------------------------  USB0_BURSTSIZE  -----------------------------------------
#define USB0_BURSTSIZE_RXPBURST_Pos                           0                                                         /*!< USB0 BURSTSIZE: RXPBURST Position   */
#define USB0_BURSTSIZE_RXPBURST_Msk                           (0x000000ffUL << USB0_BURSTSIZE_RXPBURST_Pos)             /*!< USB0 BURSTSIZE: RXPBURST Mask       */
#define USB0_BURSTSIZE_TXPBURST_Pos                           8                                                         /*!< USB0 BURSTSIZE: TXPBURST Position   */
#define USB0_BURSTSIZE_TXPBURST_Msk                           (0x000000ffUL << USB0_BURSTSIZE_TXPBURST_Pos)             /*!< USB0 BURSTSIZE: TXPBURST Mask       */

// ------------------------------------  USB0_TXFILLTUNING  ---------------------------------------
#define USB0_TXFILLTUNING_TXSCHOH_Pos                         0                                                         /*!< USB0 TXFILLTUNING: TXSCHOH Position */
#define USB0_TXFILLTUNING_TXSCHOH_Msk                         (0x000000ffUL << USB0_TXFILLTUNING_TXSCHOH_Pos)           /*!< USB0 TXFILLTUNING: TXSCHOH Mask     */
#define USB0_TXFILLTUNING_TXSCHEATLTH_Pos                     8                                                         /*!< USB0 TXFILLTUNING: TXSCHEATLTH Position */
#define USB0_TXFILLTUNING_TXSCHEATLTH_Msk                     (0x1fUL << USB0_TXFILLTUNING_TXSCHEATLTH_Pos)             /*!< USB0 TXFILLTUNING: TXSCHEATLTH Mask */
#define USB0_TXFILLTUNING_TXFIFOTHRES_Pos                     16                                                        /*!< USB0 TXFILLTUNING: TXFIFOTHRES Position */
#define USB0_TXFILLTUNING_TXFIFOTHRES_Msk                     (0x3fUL << USB0_TXFILLTUNING_TXFIFOTHRES_Pos)             /*!< USB0 TXFILLTUNING: TXFIFOTHRES Mask */

// -------------------------------------  USB0_BINTERVAL  -----------------------------------------
#define USB0_BINTERVAL_BINT_Pos                               0                                                         /*!< USB0 BINTERVAL: BINT Position       */
#define USB0_BINTERVAL_BINT_Msk                               (0x0fUL << USB0_BINTERVAL_BINT_Pos)                       /*!< USB0 BINTERVAL: BINT Mask           */

// --------------------------------------  USB0_ENDPTNAK  -----------------------------------------
#define USB0_ENDPTNAK_EPRN0_Pos                               0                                                         /*!< USB0 ENDPTNAK: EPRN0 Position       */
#define USB0_ENDPTNAK_EPRN0_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN0_Pos)                       /*!< USB0 ENDPTNAK: EPRN0 Mask           */
#define USB0_ENDPTNAK_EPRN1_Pos                               1                                                         /*!< USB0 ENDPTNAK: EPRN1 Position       */
#define USB0_ENDPTNAK_EPRN1_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN1_Pos)                       /*!< USB0 ENDPTNAK: EPRN1 Mask           */
#define USB0_ENDPTNAK_EPRN2_Pos                               2                                                         /*!< USB0 ENDPTNAK: EPRN2 Position       */
#define USB0_ENDPTNAK_EPRN2_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN2_Pos)                       /*!< USB0 ENDPTNAK: EPRN2 Mask           */
#define USB0_ENDPTNAK_EPRN3_Pos                               3                                                         /*!< USB0 ENDPTNAK: EPRN3 Position       */
#define USB0_ENDPTNAK_EPRN3_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN3_Pos)                       /*!< USB0 ENDPTNAK: EPRN3 Mask           */
#define USB0_ENDPTNAK_EPRN4_Pos                               4                                                         /*!< USB0 ENDPTNAK: EPRN4 Position       */
#define USB0_ENDPTNAK_EPRN4_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN4_Pos)                       /*!< USB0 ENDPTNAK: EPRN4 Mask           */
#define USB0_ENDPTNAK_EPRN5_Pos                               5                                                         /*!< USB0 ENDPTNAK: EPRN5 Position       */
#define USB0_ENDPTNAK_EPRN5_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN5_Pos)                       /*!< USB0 ENDPTNAK: EPRN5 Mask           */
#define USB0_ENDPTNAK_EPTN0_Pos                               16                                                        /*!< USB0 ENDPTNAK: EPTN0 Position       */
#define USB0_ENDPTNAK_EPTN0_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN0_Pos)                       /*!< USB0 ENDPTNAK: EPTN0 Mask           */
#define USB0_ENDPTNAK_EPTN1_Pos                               17                                                        /*!< USB0 ENDPTNAK: EPTN1 Position       */
#define USB0_ENDPTNAK_EPTN1_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN1_Pos)                       /*!< USB0 ENDPTNAK: EPTN1 Mask           */
#define USB0_ENDPTNAK_EPTN2_Pos                               18                                                        /*!< USB0 ENDPTNAK: EPTN2 Position       */
#define USB0_ENDPTNAK_EPTN2_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN2_Pos)                       /*!< USB0 ENDPTNAK: EPTN2 Mask           */
#define USB0_ENDPTNAK_EPTN3_Pos                               19                                                        /*!< USB0 ENDPTNAK: EPTN3 Position       */
#define USB0_ENDPTNAK_EPTN3_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN3_Pos)                       /*!< USB0 ENDPTNAK: EPTN3 Mask           */
#define USB0_ENDPTNAK_EPTN4_Pos                               20                                                        /*!< USB0 ENDPTNAK: EPTN4 Position       */
#define USB0_ENDPTNAK_EPTN4_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN4_Pos)                       /*!< USB0 ENDPTNAK: EPTN4 Mask           */
#define USB0_ENDPTNAK_EPTN5_Pos                               21                                                        /*!< USB0 ENDPTNAK: EPTN5 Position       */
#define USB0_ENDPTNAK_EPTN5_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN5_Pos)                       /*!< USB0 ENDPTNAK: EPTN5 Mask           */

// -------------------------------------  USB0_ENDPTNAKEN  ----------------------------------------
#define USB0_ENDPTNAKEN_EPRNE0_Pos                            0                                                         /*!< USB0 ENDPTNAKEN: EPRNE0 Position    */
#define USB0_ENDPTNAKEN_EPRNE0_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE0_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE0 Mask        */
#define USB0_ENDPTNAKEN_EPRNE1_Pos                            1                                                         /*!< USB0 ENDPTNAKEN: EPRNE1 Position    */
#define USB0_ENDPTNAKEN_EPRNE1_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE1_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE1 Mask        */
#define USB0_ENDPTNAKEN_EPRNE2_Pos                            2                                                         /*!< USB0 ENDPTNAKEN: EPRNE2 Position    */
#define USB0_ENDPTNAKEN_EPRNE2_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE2_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE2 Mask        */
#define USB0_ENDPTNAKEN_EPRNE3_Pos                            3                                                         /*!< USB0 ENDPTNAKEN: EPRNE3 Position    */
#define USB0_ENDPTNAKEN_EPRNE3_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE3_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE3 Mask        */
#define USB0_ENDPTNAKEN_EPRNE4_Pos                            4                                                         /*!< USB0 ENDPTNAKEN: EPRNE4 Position    */
#define USB0_ENDPTNAKEN_EPRNE4_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE4_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE4 Mask        */
#define USB0_ENDPTNAKEN_EPRNE5_Pos                            5                                                         /*!< USB0 ENDPTNAKEN: EPRNE5 Position    */
#define USB0_ENDPTNAKEN_EPRNE5_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE5_Pos)                    /*!< USB0 ENDPTNAKEN: EPRNE5 Mask        */
#define USB0_ENDPTNAKEN_EPTNE0_Pos                            16                                                        /*!< USB0 ENDPTNAKEN: EPTNE0 Position    */
#define USB0_ENDPTNAKEN_EPTNE0_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE0_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE0 Mask        */
#define USB0_ENDPTNAKEN_EPTNE1_Pos                            17                                                        /*!< USB0 ENDPTNAKEN: EPTNE1 Position    */
#define USB0_ENDPTNAKEN_EPTNE1_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE1_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE1 Mask        */
#define USB0_ENDPTNAKEN_EPTNE2_Pos                            18                                                        /*!< USB0 ENDPTNAKEN: EPTNE2 Position    */
#define USB0_ENDPTNAKEN_EPTNE2_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE2_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE2 Mask        */
#define USB0_ENDPTNAKEN_EPTNE3_Pos                            19                                                        /*!< USB0 ENDPTNAKEN: EPTNE3 Position    */
#define USB0_ENDPTNAKEN_EPTNE3_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE3_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE3 Mask        */
#define USB0_ENDPTNAKEN_EPTNE4_Pos                            20                                                        /*!< USB0 ENDPTNAKEN: EPTNE4 Position    */
#define USB0_ENDPTNAKEN_EPTNE4_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE4_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE4 Mask        */
#define USB0_ENDPTNAKEN_EPTNE5_Pos                            21                                                        /*!< USB0 ENDPTNAKEN: EPTNE5 Position    */
#define USB0_ENDPTNAKEN_EPTNE5_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE5_Pos)                    /*!< USB0 ENDPTNAKEN: EPTNE5 Mask        */

// -------------------------------------  USB0_PORTSC1_D  -----------------------------------------
#define USB0_PORTSC1_D_CCS_Pos                                0                                                         /*!< USB0 PORTSC1_D: CCS Position        */
#define USB0_PORTSC1_D_CCS_Msk                                (0x01UL << USB0_PORTSC1_D_CCS_Pos)                        /*!< USB0 PORTSC1_D: CCS Mask            */
#define USB0_PORTSC1_D_PE_Pos                                 2                                                         /*!< USB0 PORTSC1_D: PE Position         */
#define USB0_PORTSC1_D_PE_Msk                                 (0x01UL << USB0_PORTSC1_D_PE_Pos)                         /*!< USB0 PORTSC1_D: PE Mask             */
#define USB0_PORTSC1_D_PEC_Pos                                3                                                         /*!< USB0 PORTSC1_D: PEC Position        */
#define USB0_PORTSC1_D_PEC_Msk                                (0x01UL << USB0_PORTSC1_D_PEC_Pos)                        /*!< USB0 PORTSC1_D: PEC Mask            */
#define USB0_PORTSC1_D_FPR_Pos                                6                                                         /*!< USB0 PORTSC1_D: FPR Position        */
#define USB0_PORTSC1_D_FPR_Msk                                (0x01UL << USB0_PORTSC1_D_FPR_Pos)                        /*!< USB0 PORTSC1_D: FPR Mask            */
#define USB0_PORTSC1_D_SUSP_Pos                               7                                                         /*!< USB0 PORTSC1_D: SUSP Position       */
#define USB0_PORTSC1_D_SUSP_Msk                               (0x01UL << USB0_PORTSC1_D_SUSP_Pos)                       /*!< USB0 PORTSC1_D: SUSP Mask           */
#define USB0_PORTSC1_D_PR_Pos                                 8                                                         /*!< USB0 PORTSC1_D: PR Position         */
#define USB0_PORTSC1_D_PR_Msk                                 (0x01UL << USB0_PORTSC1_D_PR_Pos)                         /*!< USB0 PORTSC1_D: PR Mask             */
#define USB0_PORTSC1_D_HSP_Pos                                9                                                         /*!< USB0 PORTSC1_D: HSP Position        */
#define USB0_PORTSC1_D_HSP_Msk                                (0x01UL << USB0_PORTSC1_D_HSP_Pos)                        /*!< USB0 PORTSC1_D: HSP Mask            */
#define USB0_PORTSC1_D_PIC1_0_Pos                             14                                                        /*!< USB0 PORTSC1_D: PIC1_0 Position     */
#define USB0_PORTSC1_D_PIC1_0_Msk                             (0x03UL << USB0_PORTSC1_D_PIC1_0_Pos)                     /*!< USB0 PORTSC1_D: PIC1_0 Mask         */
#define USB0_PORTSC1_D_PTC3_0_Pos                             16                                                        /*!< USB0 PORTSC1_D: