/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef EVENT_H
#define EVENT_H

#include "base/testsuite.h"
#include "base/singleton.h"

#include <list>

    //٥ȥեåμޤȤ
template<typename T>
class Event
{
public:
    typedef void (*handler_type)(T &);

    class handler_list_type : public std::list<handler_type>
    {   public: SINGLETON_CONSTRUCTOR(handler_list_type) throw() {}   };

    /*
     *   饹Υϥɥ
     */

    class Handler
    {
    friend class Event;
    public:
        class instance_list_type : public std::list<Handler *>
        {   public: SINGLETON_CONSTRUCTOR(instance_list_type) throw() {}   };

        virtual void handler(T & ev) = 0;

    protected:
            //Ͽ
        Handler(void) throw()
        {   Singleton<instance_list_type>::getInstance()->push_back(this);   }
        
            //Ͽ
        virtual ~Handler(void) throw()
        {
            typename Event<T>::Handler::instance_list_type * list = Singleton<instance_list_type>::getInstance(std::nothrow);
            typename Event<T>::Handler::instance_list_type::iterator scope;

            if(list != 0) {
                scope = list->begin();
                while(scope != list->end()) {
                    if(*scope == this) {
                        typename Event<T>::Handler::instance_list_type::iterator target = scope;
                        ++ scope;
                        list->erase(target);
                    }
                    else
                        ++ scope;
                }
            }
        }
    };

public:
    typedef T value_type;

    Event(void) {}
    virtual ~Event(void) {}

    /*
     *  ƥåʥϥɥ
     */

        //٥Ȥ˥ϥɥɲ
    inline static void add(handler_type func) throw(std::bad_alloc)
    {   Singleton<handler_list_type>::getInstance()->push_back(func);   }

        //٥Ȥϥɥ
    static void remove(handler_type func) throw()
    {
        typename Event<T>::handler_list_type * list;
        typename Event<T>::handler_list_type::iterator scope;

        list = Singleton<handler_list_type>::getInstance(std::nothrow);
        if(list != 0) {
            scope = list->begin();
            while(scope != list->end()) {
                if(*scope == func) {
                    typename handler_list_type::iterator target = scope;
                    ++ scope;
                    list->erase(target);
                }
                else
                    ++ scope;
            }
        }
    }

    /*
     *  
     */
        //٥Ȥȯ
    static void raise(T & ev)
    {
            typedef typename Event<T>::handler_list_type handler_list_type_t; 
            typedef typename Event<T>::Handler::instance_list_type instance_list_type_t;

        /* Ͽ줿Ūʴؿ˥٥Ȥȯ */ {
           handler_list_type_t * list;
            typename handler_list_type_t::iterator scope;

            list = Singleton<handler_list_type_t>::getInstance();   //throw(bad_cast)

            scope = list->begin();
            while(scope != list->end()) {
                (**scope)(ev);
                ++ scope;
            }
        }

        /* Ͽ줿饹󥹥󥹤˥٥Ȥȯ */ {
            instance_list_type_t * list;
            typename instance_list_type_t::iterator scope;

            list = Singleton<instance_list_type_t>::getInstance();  //throw(bad_cast)

            scope = list->begin();
            while(scope != list->end()) {
                (*scope)->handler(ev);
                ++ scope;
            }
        }
    }

        //٥Ȥȯ (ʤ)
    inline static void raise(void)
    {
        T ev;
        raise(ev);
    }
};


    /*
     *  ѥ٥
     */

    //󥹥ȥ饯ưäȡ˵륤٥
class StartupEvent {};


    //Ԥ鷺ץबȤ˵륤٥
struct ShutdownEvent
{
    int exit_code;
};

#endif



