/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: option.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/option.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "base/option.h"
#include <assert.h>
#include <algorithm>

using namespace std;

    //̤OptionItemĥѥ᡼ʬɲä
void OptionParameter::OptionItem::mergeItem(const OptionItem & src)
{
    vector<string>::const_iterator scope;

        //ƤΥѥ᡼ʬθɲ
    scope = src.param.begin();
    while(scope != src.param.end()) {
        param.push_back(*scope);
        ++ scope;
    }
}

    //ʸƬˤʸ
namespace {
    void TrimString(string & src)
    {
        string::size_type pos;

        pos = src.find_first_not_of(" \t\r\n");
        if(pos != 0)
            src.erase(0, pos);
    }
}

    //ץѥ᡼ϤOptionItem
bool OptionParameter::OptionItem::createItem(OptionItem & _dest, string & argv)
{
    bool              result;
    string            param;
    string::size_type pos;
    OptionItem        dest;

    result = true;

    TrimString(argv);
    if(argv.empty())
        result = false;     //Ȥä
    else {
            //ץΥå
        if(argv[0] == '-') {
            pos = argv.find_first_of(" =");

            if(argv.substr(0,pos).compare("-") == 0) {  // - Υץϼդʤ
                result = false;
            }
            else {
                if(pos != 1) {
                    if(pos != string::npos) {
                        dest = argv.substr(1, pos - 1);
                        argv.erase(0, pos + 1);
                    }
                    else {
                        dest = argv.substr(1);
                        argv.erase();
                    }
                }
            }
        }

        TrimString(argv);
        while(!argv.empty() && argv[0] != '-') {
            if(argv[0] == '"') {

                    //Фˤʤ֥륯Ȥõ
                pos = argv.find_first_of('"',1);
                if(pos == string::npos) {
                    result = false;
                    break;
                }

                    //֥륯ȤȤ
                param = argv.substr(1, pos - 1);

                    //֥륯Ȥä
                ++ pos;
            }
            else {

                    //ζڤõ
                pos = argv.find_first_of(" \t\r\n");
                if(pos == string::npos)
                    param = argv;
                else
                    param = argv.substr(0,pos);
            }

            dest.addParameter(param);
            argv.erase(0, pos);
            
            TrimString(argv);
        }
    }

    if(result)
        _dest = dest;

    return result;
}

    //̵ʥץ󥢥ƥ
OptionParameter::OptionItem OptionParameter::OptionItem::createInvalidItem(void) throw()
{
    OptionItem result;

    result.assign("");
    return result;
}


    //ƤΥѥ᡼礷Τ
string OptionParameter::OptionItem::getParameters(string punctuator) const throw()
{
    string result;

    vector<string>::const_iterator scope;

    if(isValid()) {
        scope = param.begin();
        while(scope != param.end()) {
            result += punctuator;
            result += *scope;
            ++ scope;
        }

        if(!result.empty())
            result.erase(0, punctuator.size()); //ƬζڤҤ
    }

    return result;
}

    //ץθĿΥå
bool OptionParameter::OptionItem::checkParameterCount(size_t required, bool allow_zero) const throw()
{
    bool result = true;
    if(isValid()) {
        size_t count = countParameter();
        if(count != required || (!allow_zero && count == 0))
            result = false;
    }
    else
        result = false;
    return result;
}

        //ץѥ᡼Υѡ
bool OptionParameter::parseOption(int _argc, char const * const * _argv, char const * _default) throw()
{
    bool        result;
    string      arguments;
    OptionItem  work;
    int         i;

    map<string, OptionItem>::iterator scope;

        //ץ̾μ
    if(_argc > 0)
        program_name.assign(_argv[0]);

        //ƤĤʤ
    for(i=1;i<_argc;++i) {
        arguments += _argv[i];
        arguments += ' ';
    }

    if(arguments.empty() && _default != 0)
        arguments.assign(_default);

    cmdline += arguments;

    result = true;

        //ƥץβ
    while(!arguments.empty()) {

        if(!OptionItem::createItem(work, arguments)) {
            result = false;
            break;
        }

            //ƱΥץ󤬤ޡ
        scope = container.find(work);
        if(scope != container.end())
            scope->second.mergeItem(work);
        else
            container.insert(std::map<std::string, OptionItem>::value_type(work, work));
    }

    return result;
}

    //Ǥθ
map<string, OptionParameter::OptionItem>::iterator OptionParameter::_find(const std::string & name, bool check) throw()
{
    map<string, OptionParameter::OptionItem>::iterator scope;

    scope = container.find(name);

        //ǤѤȤϿƤ
    if(check && scope != container.end())
        scope->second._check();

    return scope;
}


    //ץ󥢥ƥλ
OptionParameter::OptionItem OptionParameter::get(const std::string & name, bool check) throw()
{
    OptionItem                        result;
    map<string, OptionItem>::iterator scope;

    scope = _find(name, check);
    if(scope != container.end())
        result = scope->second;
    else
        result = OptionItem::createInvalidItem();

    return result;
}


    //ƤΥץ󤬻Ѥ줿ɤγǧ
bool OptionParameter::validateOption(void) const throw()
{
    map<string, OptionItem>::const_iterator scope;
    bool result = true;

        //ƤΥץ󤬥åѤߤǤ뤳Ȥǧ
    scope = container.begin();
    while(scope != container.end()) {
        if(!scope->second.isChecked()) {
            result = false;
            break;
        }
        ++ scope;
    }

    return result;
}


    //Ѥʤäץ
string OptionParameter::getInvalidOptions(void) const throw()
{
    map<string, OptionItem>::const_iterator scope;
    string result;

        //ѤʤäƤΥץФ
    scope = container.begin();
    while(scope != container.end()) {
        const OptionItem & item = scope->second;
        if(!item.isChecked()) {
            result += " -";
            result += item;

                //ץѥ᡼
            size_t params = item.countParameter();
            for(size_t i=0; i<params; ++i) {
                result += " \"";
                result += item[i];
                result += '\"';
            }
        }
        ++ scope;
    }

        //Ƭζ
    if(!result.empty())
        result = result.substr(1);

    return result;
}

/***************** ƥȥ *****************/

#ifdef TESTSUITE
#include "coverage_undefs.h"


TESTSUITE_(main,OptionItem,OptionParameter)
{
    BEGIN_CASE("01","ǥեȥѥ᡼" DEFAULT_PARAMETER "ˤʤäƤ") {
        OptionItem work;
        if(work.compare(DEFAULT_PARAMETER) != 0)
            TEST_FAIL;
    } END_CASE;

    //----

    BEGIN_CASE("02","󥹥ȥ饯å (checked == false, ѥ᡼̾)") {

        BEGIN_CASE("1","OptionItem(void)") {
            OptionItem work;
            if(work.checked != false)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","OptionItem(const string &)") {
            OptionItem work("test");
            if(work.compare("test") != 0 || work.checked != false)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","OptionItem(const OptionItem &)") {
            OptionItem dummy("test");
            OptionItem work(dummy);
            if(work.compare("test") != 0 || work.checked != false)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    //----

    BEGIN_CASE("03", "addParameter / countParameter / operator []") {
        const char * container[] = { "first", "second", "third", "forth", "fifth", NULL };
        const char ** param = container;
        int i;

        OptionItem work;

        BEGIN_CASE("1", "äľcountParameter0") {
            if(work.countParameter() != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "addParameter뤿Ӥ1Ϥ") {
            while(*param != NULL) {
                size_t count = work.countParameter();

                work.addParameter(*param);

                if(work.countParameter() != count + 1)
                    TEST_FAIL;

                ++ param;
            }
        } END_CASE;

        BEGIN_CASE("3", "줿ΤϤäƤ") {
            i = 0;
            param = container;
            while(*param != NULL) {
                if(work[i].compare(*param) != 0)
                    TEST_FAIL;

                ++ i;
                ++ param;
            }
        } END_CASE;

        BEGIN_CASE("4", "operator[]ϰϳΥѥ᡼ȶʸ֤") {
            if(!work[10000].empty())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    //----

    BEGIN_CASE("04", "hasParameter") {
        OptionItem work;

        BEGIN_CASE("1", "ȤʤȤfalse֤") {
            if(work.hasParameter())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "ȤȤtrue֤") {
            work.addParameter("dummy");
            if(!work.hasParameter())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;
        
    //----

    BEGIN_CASE("mergeItem", "mergeItem") {
        OptionItem work;
        OptionItem work2;

        work.addParameter("one");
        work2.addParameter("two");
        
        work.mergeItem(work2);

        BEGIN_CASE("1","ޡƤ") {
            if(work[0].compare("one") != 0 || work[1].compare("two") != 0 || work.countParameter() != 2)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ѹѲʤ") {
            if(work2[0].compare("two") != 0 || work2.countParameter() != 1)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;
        
    //----

    BEGIN_CASE("isChecked/checked", "isChecked/check") {
        OptionItem work;

        BEGIN_CASE("1","ǽunchecked") {
            if(work.isChecked() != false)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","checkĤ") {
            work._check();
            if(work.isChecked() != true)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","⤦äƤȥˤʤʤ") {
            work._check();
            if(work.isChecked() != true)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    //----

    BEGIN_CASE("CopyConstructor", "ԡ󥹥ȥ饯ǥѥ᡼ܤ뤫") {
        OptionItem src;
        src.addParameter("one");

        OptionItem dest(src);

        if(dest.countParameter() != 1 || dest[0].compare("one") != 0)
            TEST_FAIL;
    } END_CASE;

    //----

    BEGIN_CASE("TrimString", "TrinStringư") {
        BEGIN_CASE("1","Ƭζʸä") {
            string work(" \r\n\ttest");
            TrimString(work);
            if(work.compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ʸʸ") {
            string work("     ");
            TrimString(work);
            if(!work.empty())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    //----

    BEGIN_CASE("createItem", "createItemؿư") {
        BEGIN_CASE("1", "äݤʸ򤤤ȼԤ") {
            OptionItem work;
            string param("");
            if(OptionItem::createItem(work, param))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "ʤץ") {
            OptionItem work;
            string     arg("-test");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(work.compare("test") != 0 || work.hasParameter())
                TEST_FAIL;
            if(!arg.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "Ϣ³ʤץ") {
            OptionItem work;
            string     arg("-test -test2");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(arg.compare("-test2") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4", "Ĥץ(-test param)") {
            OptionItem work;
            string     arg("-test param");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(work.compare("test") != 0)
                TEST_FAIL;
            if(work.countParameter() != 1 || work[0].compare("param") != 0)
                TEST_FAIL;
            if(!arg.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("5", "Ĥץ(-test=param)") {
            OptionItem work;
            string     arg("-test=param");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(work.compare("test") != 0)
                TEST_FAIL;
            if(work.countParameter() != 1 || work[0].compare("param") != 0)
                TEST_FAIL;
            if(!arg.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("6", "Ĥץ(-test=\"a b c\")") {
            OptionItem work;
            string     arg("-test=\"a b c\"");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(work.compare("test") != 0)
                TEST_FAIL;
            if(work.countParameter() != 1 || work[0].compare("a b c") != 0)
                TEST_FAIL;
            if(!arg.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("7", "Ϣ³Ĥץ(-test one two)") {
            OptionItem work;
            string     arg("-test one two");
            if(!OptionItem::createItem(work, arg))
                TEST_FAIL;
            if(work.compare("test") != 0)
                TEST_FAIL;
            if(work.countParameter() != 2 || work[0].compare("one") != 0 || work[1].compare("two") != 0)
                TEST_FAIL;
            if(!arg.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("8", "ϥե") {
            BEGIN_CASE("1", "ϥեΰϼդʤ") {
                OptionItem work;
                string     arg("-");
                if(OptionItem::createItem(work, arg))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2", "ϥեΰϼդʤ(Ϣ³)") {
                OptionItem work;
                string     arg("- - -");
                if(OptionItem::createItem(work, arg))
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("3", "֥륯ȤǤ줿ϥեϼդ") {
                OptionItem work;
                string     arg("\"-\"");
                if(!OptionItem::createItem(work, arg))
                    TEST_FAIL;
                if(work.compare(DEFAULT_PARAMETER) != 0 || work.countParameter() != 1 || work[0].compare("-") != 0)
                    TEST_FAIL;
            } END_CASE;
    
        } END_CASE;

        BEGIN_CASE("9", "Фˤʤ֥륯Ȥ礱ϼդʤ") {
            OptionItem work;
            string     arg("-test=\"a b c");
            if(OptionItem::createItem(work, arg))
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("isValid/createInvalidItem", "̵򼨤󥹥󥹤ǤȽǤ") {
        OptionItem work;

        BEGIN_CASE("1","ǥեȥ󥹥ȥ饯֥Ȥͭ") {
            if(!work.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","̵󥹥󥹤̵") {
            work = OptionItem::createInvalidItem();
            if(work.isValid())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("getParameters","getParameters") {
        BEGIN_CASE("1","ץǤ") {
            OptionItem work;
            string     arg("-test a b c d e f g");

            TEST_CASE("0","[]ץϤ", OptionItem::createItem(work,arg));
            TEST_CASE("1","Ǥ", work.getParameters().compare("a b c d e f g") == 0);
            TEST_CASE("2","ڤꤷƷǤ", work.getParameters(",").compare("a,b,c,d,e,f,g") == 0);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("checkParameterCount","checkParameterCount") {
        BEGIN_CASE("1","ץοäƤtrue") {
            OptionItem work;
            string     arg("-test a b c d e f g");

            TEST_CASE("0","[]ץϤ", OptionItem::createItem(work,arg));

            if(!work.checkParameterCount(7))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ץοְäƤfalse") {
            OptionItem work;
            string     arg("-test a b c d e f g");

            TEST_CASE("0","[]ץϤ", OptionItem::createItem(work,arg));

            if(work.checkParameterCount(2))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ץ󤬤ʤơ!allow_zeroʤfalse") {
            OptionItem work;
            string     arg("-test");

            TEST_CASE("0","[]ץϤ", OptionItem::createItem(work,arg));

            if(work.checkParameterCount(1,false))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","ץ󤬤ʤơallow_zeroʤtrue") {
            OptionItem work;
            string     arg("-test");

            TEST_CASE("0","[]ץϤ", OptionItem::createItem(work,arg));

            if(work.checkParameterCount(1,true))
                TEST_FAIL;
        } END_CASE;

    } END_CASE;
}

/********************************* ƥȥ *********************************/

TESTSUITE(main,OptionParameter)
{
    SINGLETON(OptionParameter);

    BEGIN_CASE("countItem","ץ󥢥ƥοǤ") {
        OptionParameter param;
        if(param.countItem() != 0)
            TEST_FAIL;

        param.container.insert(pair<string, OptionItem>(DEFAULT_PARAMETER, OptionItem()));
        if(param.countItem() != 1)
            TEST_FAIL;
    } END_CASE;

    BEGIN_CASE("opeator []","operator []Ǥ˥Ǥ") {
        OptionParameter param;
        OptionItem work;
        string arg("-test param");

        OptionItem::createItem(work, arg);
        param.container.insert(pair<string, OptionItem>(work, work));

        BEGIN_CASE("1", "operator [] (const string &)Ĥ˥Ǥ") {
            if(param[string("test")][0].compare("param") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "operator [] (const char *)Ĥ˥Ǥ") {
            if(param["test"][0].compare("param") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "operator []ǿȡcheck") {
            if(!param["test"].isChecked())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4", "operator []̵ʥȡ̵ʥǡ֤äƤ") {
            if(param["nonexist"].isValid())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("get","ǤؤΥ") {
        OptionParameter param;
        OptionItem work;

        OptionItem::createItem(work, string("-test param"));
        param.container.insert(pair<string, OptionItem>(work, work));
        OptionItem::createItem(work, string("-test2 param2"));
        param.container.insert(pair<string, OptionItem>(work, work));

        BEGIN_CASE("1","get(test)ǤǤå") {
            TEST_CASE("1","Ǥ¸ߤ", (work = param.get("test")).isValid());
            TEST_CASE("2","åäƤ", work.isChecked() );
            TEST_CASE("3","Ǥϥѥ᡼", work.hasParameter() );
        } END_CASE;

        BEGIN_CASE("2","get(test2,false)ǤǤåϤĤʤ") {
            TEST_CASE("1","Ǥ¸ߤ", (work = param.get("test2",false)).isValid());
            TEST_CASE("2","åäƤʤ", !work.isChecked() );
        } END_CASE;

        BEGIN_CASE("3","Ǥ˥åΤĤtestФget(test,false)ǤǤåѤ") {
            TEST_CASE("1","Ǥ¸ߤ", (work = param.get("test",false)).isValid());
            TEST_CASE("2","åäƤʤ", work.isChecked() );
        } END_CASE;

        BEGIN_CASE("4","get(̵̾)̵Ǥ֤") {
            TEST_CASE("1","Ǥ¸ߤ", !param.get("unknown").isValid());
        } END_CASE;
    } END_CASE;


    BEGIN_CASE("parseOption","ѥ᡼ΥѡˤǤ뤫") {
        BEGIN_CASE("01","Ȥʤѥ᡼ͿƤ") {
            OptionParameter param;
            char ** argv = { NULL };

            if(!param.parseOption(0, argv))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("02","ץ̾ϥץȤƲϤʤ") {
            OptionParameter param;
            char * argv[] = { "test.exe", NULL };

            if(!param.parseOption(1, argv))
                TEST_FAIL;
            if(param.countItem() != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("03","ѥ᡼ʤ˲Ϥ") {
            OptionParameter param;
            char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

            if(!param.parseOption(4, argv))
                TEST_FAIL;
            if(param.countItem() != 2)
                TEST_FAIL;
            
            if(param[string("test")][0].compare("param") != 0)
                TEST_FAIL;

            if(param["test2"][0].compare("dummy") != 0)
                TEST_FAIL;

            if(param.getProgramName().compare("test.exe") != 0)
                TEST_FAIL;

        } END_CASE;

        BEGIN_CASE("04","󤬼") {
            OptionParameter param;
            char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

            if(!param.parseOption(4, argv))
                TEST_FAIL;

            if(param.getCommandLine().compare("-test param -test2=\"dummy\" ") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("05","̵ȤˤϥǥեȰҤƤ") {
            OptionParameter param;
            char * argv[] = { "test.exe", NULL };

            if(!param.parseOption(1, argv, "-default=parameter"))
                TEST_FAIL;

            if(param.getCommandLine().compare("-default=parameter ") != 0)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("04","ȥޡĤ") {
        OptionParameter param;
        char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

        if(!param.parseOption(4, argv))
            TEST_FAIL;

        if(param.container.find(string("test"))->second.isChecked())
            TEST_FAIL;

        param.check("test");
        if(!param.container.find(string("test"))->second.isChecked())
            TEST_FAIL;
    } END_CASE;

    BEGIN_CASE("05","validateOption") {
        OptionParameter param;
        char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

        if(!param.parseOption(4, argv))
            TEST_FAIL;

        BEGIN_CASE("1","ѤƤʤȤˤfalse") {
            if(param.validateOption())
                TEST_FAIL;
        } END_CASE;

        param["test"]._check();
        BEGIN_CASE("2","ۤ˥åƤʤץ󤬤false") {
            if(param.validateOption())
                TEST_FAIL;
        } END_CASE;

        param["test2"]._check();
        BEGIN_CASE("3","ƻѤtrue") {
            if(!param.validateOption())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("06","getInvalidOptions") {
        OptionParameter param;
        char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

        if(!param.parseOption(4, argv))
            TEST_FAIL;

        BEGIN_CASE("1","ѤƤʤȤˤƤΥץ̵") {
            if(param.getInvalidOptions().compare("-test \"param\" -test2 \"dummy\"") != 0)
                TEST_FAIL;
        } END_CASE;

        param["test"]._check();
        BEGIN_CASE("2","ۤ˥åƤʤץ󤬤Ф줬") {
            if(param.getInvalidOptions().compare("-test2 \"dummy\"") != 0)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("07","find") {
        OptionParameter param;
        char * argv[] = { "test.exe", "-test", "param", "-test2=\"dummy\"", NULL };

        if(!param.parseOption(4, argv))
            TEST_FAIL;

        BEGIN_CASE("1","¸ߤ륪ץФtrue֤") {
            if(!param.find("test") || !param.find("test2"))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","¸ߤʤץФfalse֤") {
            if(param.find("unknown"))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ʸФfalse֤") {
            if(param.find(""))
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    Singleton<OptionParameter>::restoreContext(context);
}

#endif


