/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *
 */


/*
 *	åȥƥ˰¸ADSP-BF534,6,7ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CHIP_DEFS_H_
#define _CHIP_DEFS_H_

/*
 * ƥ¸ѤMMR
 */
#define __PLL_CTL			0xFFC00000
#define __PLL_DIV			0xFFC00004

#define __SWRST			0xFFC00100
#define __SYSCR			0xFFC00104
#define __SIC_IMASK		0xFFC0010C
#define __SIC_IAR0			0xFFC00110
#define __SIC_IAR1			0xFFC00114
#define __SIC_IAR2			0xFFC00118
#define __SIC_IAR3			0xFFC0011C
#define __SIC_ISR			0xFFC00120
#define __SIC_IWR			0xFFC00124

#define __TIMER7_CONFIG     0xFFC00670
#define __TIMER7_COUNTER    0xFFC00674
#define __TIMER7_PERIOD     0xFFC00678
#define __TIMER7_WIDTH      0xFFC0067C

#define __TIMER_ENABLE		0xFFC00680
#define __TIMER_DISABLE	0xFFC00684
#define __TIMER_STATUS		0xFFC00688

#define __EBIU_SDBCTL		0xFFC00A14

#define __PORTF_FER		0xFFC03200
#define __PORTG_FER		0xFFC03204
#define __PORTH_FER		0xFFC03208
#define __PORT_MUX			0xFFC0320C


#define __pPLL_CTL 		((volatile unsigned short *)__PLL_CTL)
#define __pPLL_DIV 		((volatile unsigned short *)__PLL_DIV)

#define __pSWRST 			((volatile unsigned short *)__SWRST)
#define __pSYSCR 			((volatile unsigned short *)__SYSCR)
#define __pSIC_IMASK 		((volatile unsigned long *)__SIC_IMASK)
#define __pSIC_IAR0 		((volatile unsigned long *)__SIC_IAR0)
#define __pSIC_IAR1 		((volatile unsigned long *)__SIC_IAR1)
#define __pSIC_IAR2 		((volatile unsigned long *)__SIC_IAR2)
#define __pSIC_IAR3 		((volatile unsigned long *)__SIC_IAR2)
#define __pSIC_ISR 		((volatile unsigned long *)__SIC_ISR)
#define __pSIC_IWR 		((volatile unsigned long *)__SIC_IWR)

#define __pTIMER7_CONFIG 	((volatile unsigned short *)__TIMER7_CONFIG)
#define __pTIMER7_COUNTER ((volatile unsigned long *)__TIMER7_COUNTER)
#define __pTIMER7_PERIOD 	((volatile unsigned long *)__TIMER7_PERIOD)
#define __pTIMER7_WIDTH 	((volatile unsigned long *)__TIMER7_WIDTH)

#define __pTIMER_ENABLE 	((volatile unsigned short *)__TIMER_ENABLE)
#define __pTIMER_DISABLE 	((volatile unsigned short *)__TIMER_DISABLE)
#define __pTIMER_STATUS 	((volatile unsigned long  *)__TIMER_STATUS)

#define __pEBIU_SDBCTL 	((volatile unsigned short *)__EBIU_SDBCTL)

#define __pPORTF_FER		((volatile unsigned short *)__PORTF_FER)
#define __pPORTG_FER		((volatile unsigned short *)__PORTG_FER)
#define __pPORTH_FER		((volatile unsigned short *)__PORTH_FER)
#define __pPORT_MUX		((volatile unsigned short *)__PORT_MUX)


/*
 *  ƥå
 */
#define	TIC_NUME	1u	/* ƥåμʬ */
#define	TIC_DENO	1u	/* ƥåμʬ */

/*
 *  ˲ɤ߽Ф쥸Ƚ̼
 *  Ϳ줿ɥ쥹 iop ˲ɤ߽Ф쥸
 *  ˤϿ֤
 */
#ifndef DESTRUCTIVE_READ
#define DESTRUCTIVE_READ( iop ) (iop<(VP)0xF0000000)
#endif

#ifndef _MACRO_ONLY

/*
 *  ƥ߽
 */

Inline void
kernel_abort()
{
}

#endif /* _MACRO_ONLY */
#endif /* _SYS_DEFS_H_ */
