/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: queue.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	塼饤֥
 *
 *  Υ塼饤֥Ǥϡ塼إåޤ󥰹¤Υ֥
 *  󥯥塼򰷤Ūˤϡ塼إåμȥϥ塼
 *  ƬΥȥꡤȥϥ塼ΥȥȤ롥ޤ
 *  塼ƬΥȥȥȡ塼Υȥμ
 *  ȥϡ塼إåȤ롥Υ塼ϡȥꡤȥ
 *  ⼫ʬȤؤ塼إåǤ魯
 */

#ifndef	_QUEUE_H_
#define	_QUEUE_H_

/*
 *  塼Υǡ¤
 */
typedef struct queue {
	struct queue *next;		/* ȥؤΥݥ */
	struct queue *prev;		/* ȥؤΥݥ */
} QUEUE;

/*
 *  塼ν
 *
 *  queue ˤϥ塼إåꤹ롥
 */
Inline void
queue_initialize(QUEUE *queue)
{
	queue->prev = queue->next = queue;
}

/*
 *  塼ȥؤ
 *
 *  queue  entry 롥queue ˥塼إåꤷ
 *  ˤϡ塼 entry 뤳Ȥˤʤ롥
 */
Inline void
queue_insert_prev(QUEUE *queue, QUEUE *entry)
{
	entry->prev = queue->prev;
	entry->next = queue;
	queue->prev->next = entry;
	queue->prev = entry;
}

/*
 *  ȥκ
 *
 *  entry 򥭥塼롥
 */
Inline void
queue_delete(QUEUE *entry)
{
	entry->prev->next = entry->next;
	entry->next->prev = entry->prev;
}

/*
 *  塼μȥμФ
 *
 *  queue μȥ򥭥塼ȥ֤queue
 *  ˥塼إåꤷˤϡ塼ƬΥȥФ
 *  Ȥˤʤ롥queue ˶Υ塼ꤷƸƤӽФƤϤʤʤ
 */
Inline QUEUE *
queue_delete_next(QUEUE *queue)
{
	QUEUE	*entry;

	assert(queue->next != queue);
	entry = queue->next;
	queue->next = entry->next;
	entry->next->prev = queue;
	return(entry);
}

/*
 *  塼ɤΥå
 *
 *  queue ˤϥ塼إåꤹ롥
 */
Inline BOOL
queue_empty(QUEUE *queue)
{
	if (queue->next == queue) {
		assert(queue->prev == queue);
		return(TRUE);
	}
	return(FALSE);
}

#endif /* _QUEUE_H_ */
