/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: singleton.h,v 1.2 2009/06/12 13:30:29 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/singleton.h,v 1.2 2009/06/12 13:30:29 suikan Exp $

#include "base/testsuite.h"

#ifndef SINGLETON_H
#define SINGLETON_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B
#  pragma warning(disable:4291) //R|hOX|ƁA'new' ZqgpĂƃ܂B
#  pragma warning(disable:4786) //fobOŎʎq 255 ɐ؂̂Ă܂B
#endif

#include <new>
#include <stdexcept>
#include <cstdlib>

/*
 *  VOgp^[ 
 */

    //VOgNX
    //  #gccfriend class SingletonHĂȂ̂Ŋ
class SingletonBase {
public:
        //fXgN^̃`F[
    struct chain {
        struct chain * next;
        void (*destructor)(void);
    };

        //VOgŃCX^X𐶐Ƃ߂̃NX
        //    ̃NXSingleton炵̉łȂ̂ŁA
        //    ق̃NX炱ɂRXgN^gp邱Ƃ͂łȂ
    class SingletonConstructionLocker
    {
    friend class SingletonBase;
    protected:
        SingletonConstructionLocker() {}
    };

private:
    static bool   initialize;       //ς݂ (atexitĂ񂾂ǂ)
    static bool   is_valid;         //ɎsVOgK邩ǂ
    static struct chain * top;      //fXgN^`F[

        //fXgN^̋N
    static void final_release(void) throw()
    {
            //擪폜 (o)
        while(top != 0) {
            struct chain * node = top;
            top = node->next;

            (*node->destructor)();

            delete node;
        }
    }

protected:
        //`F[ɃfXgN^ǉ
    static bool addDestructor(void (* destructor)(void)) throw()
    {
        bool result = false;
        struct SingletonBase::chain * node = new(std::nothrow) struct SingletonBase::chain;
        if(node != 0) {

                //Vvf擪ɒǉ
            node->next       = top;
            node->destructor = destructor;
            
            top = node;

            result = true;

                //vfĵ߂ɍŌɔj[`N
            if(!initialize) {
                atexit(final_release);
                initialize = true;
            }
        }
        return result;
    }

        //SingletonConstructionLockert@Ng
    inline static SingletonConstructionLocker getLocker(void)
    {   return SingletonConstructionLocker();   }

public:
        //ɎsVOgȂƂ擾
    static bool isValid(void) throw()
    {   return is_valid;   }

#ifdef TESTSUITE
        /*
         *   ReLXg`F[ (eXgpVOgReLXgޔ`F[)
         */
    class ContextChain {
    protected:
        struct chain {
            struct chain * next;
            void * context;
            void (*restore)(void * & context) throw();
            void (*renew)(void) throw();
            void (*clear)(void);
        } * top;

    public:
        ContextChain(void) throw() : top(0)
        {}

        ~ContextChain(void) throw()
        {   restoreContext();   }

            /* ReLXg̕A */
        void restoreContext(void) throw()
        {
            while(top != 0) {
                struct chain * node = top;
                top = top->next;

                (*node->restore)(node->context);
                delete node;
            }
        }

            /* SẴCX^XĐ */
        void renewInstance(void) throw(std::bad_alloc)
        {
            struct chain * node = top;
            while(node != 0) {
                (*node->renew)();
                node = node->next;
            }
        }
            
            /* SẴCX^Xj */
        void clearInstance(void) throw(std::bad_alloc)
        {
            struct chain * node = top;
            while(node != 0) {
                (*node->clear)();
                node = node->next;
            }
        }
            
            /* ReLXg̑ޔ */
        template<class T> void saveContext(void) throw(std::bad_alloc)
        {
            struct chain * node = new struct chain;

            node->next = top;
            node->restore = reinterpret_cast<void(*)(void*&)>(Singleton<T>::restoreContext);
            node->renew   = Singleton<T>::renewInstance;
            node->clear   = Singleton<T>::clearInstance;

            Singleton<T>::saveContext(reinterpret_cast<Singleton<T>::Context &>(node->context));

            top = node;
        }
    };
#endif


    TESTSUITE_PROTOTYPE(main)
};


template<class T>
class Singleton : SingletonBase
{
protected:
    Singleton(void);
    ~Singleton(void);

    static T * instance;

        //fXgN^
    static void destructor(void) throw()
    {
        if(instance != 0) {
            try{ delete instance; } catch(...) {}
            instance = 0;
        }
    }

        //CX^X̐ (CX^X + fXgN^o^ + G[)
    static T * createInstance(std::nothrow_t) throw()
    {
        T * instance = 0;
        try {
            instance = new(std::nothrow) T(getLocker());

            if(instance != 0) {
                if(!addDestructor(destructor))
                    throw false;    //catch߂s
            }
        }
        catch(...) {
            if(instance != 0) {
                try { delete instance; } catch(...) {}
                instance = 0;
            }
        }
        return instance;
    }

        //CX^X (bad_allocOX[)
    static T * createInstance(void) throw(std::bad_alloc)
    {
        instance = createInstance(std::nothrow);
        if(instance == 0)
            throw std::bad_alloc();
        return instance;
    }

public:
        //CX^X̎擾
    inline static T * getInstance(void) throw(std::bad_alloc)
    {
        if(instance == 0)
            instance = createInstance();
        return instance;
    }

        //CX^X̎擾
    inline static T * getInstance(std::nothrow_t) throw()
    {
        if(instance == 0)
            instance = createInstance(std::nothrow);
        return instance;
    }

#ifdef TESTSUITE    /* eXgp */

    typedef T * Context;    //ޔp

        //VCX^X̐
    static void renewInstance(void) throw(std::bad_alloc)
    {
        destructor();                     //̃CX^Xj
        instance = new T(getLocker());    //VCX^X𐶐 (fXgN^o^Ă܂̂createInstanceĂł͂Ȃ)
    }

        //CX^Xj
    static void clearInstance(void) throw()
    {   destructor();   }

        //ReLXgޔ
    static void saveContext(Context & context) throw()
    {
        context  = instance;
        instance = 0;
    }

        //ReLXgA
    static void restoreContext(Context & context) throw()
    {
        destructor();           //̃CX^Xj
        instance = context;     //ޔCX^X𕜋A
    }

#endif /* TESTSUITE */

};



    //Singleton ÓIϐ
template<class T> T * Singleton<T>::instance = 0;

#define SINGLETON_CONSTRUCTOR(x)  explicit x(const SingletonBase::SingletonConstructionLocker &)
#define SINGLETON_CONSTRUCTOR_(x) explicit x(const SingletonBase::SingletonConstructionLocker & _singleton)

#define SINGLETON_WRAPPER(derived, base) class derived : public base { public: SINGLETON_CONSTRUCTOR_(derived) throw() : base(_singleton) {} };

#endif /* SINGLETON_H */

