/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: jsp_staticapi.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/jsp/jsp_staticapi.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "jsp/jsp_defs.h"

#include "base/parser.h"
#include "base/mpstrstream.h"
#include <iostream>

using namespace std;

DECLARE_API(INCLUDE,"INCLUDE")
{
    Token token;
    Directory * node;
    Directory * scope;

    last = NULL;
    p.getToken(token, Token::STRINGLITERAL);
    token.chopLiteral();

    if( (token[0] != '\"' || token[token.size()-1] != '\"') &&
        (token[0] != '<' || token[token.size()-1] != '>') )
        ExceptionMessage("An include filename must be enclosed with \"...\" or <...>","t@C \"...\"  <...> ̌`łȂ΂Ȃ܂").throwException();

    node = container.openChild(OBJECTTREE,INCLUDEFILE,NULL);
    last = node;

        //d`FbN
    scope = node->getFirstChild();
    while(scope != 0)
    {
        if(token.compare((*scope).toString()) == 0)
        {
            cerr << p.getStreamLocation() << ' ' << (Message("Include file % was already specified (ignored).","CN[ht@C%w肳܂ (܂)") << token) << endl;
            return;
        }
        scope = scope->getNext();
    }
    
    node->addChild(new Directory(token));
}

DECLARE_API(CRE_TSK,"CRE_TSK")
{
    Token token;
    string work;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, TASK);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"tskatr,exinf,task,itskpri,stksz");
    p.getToken(",","NULL","}",NULL);

    (*node)["texatr"] = "TA_NULL";
    (*node)["texrtn"] = "NULL";

    if(container["/cpu"].toString().compare("nios32") == 0) 
    {
        (*node)["hi_limit"] = "TSK_HI_LIMIT";
        (*node)["lo_limit"] = "TSK_LO_LIMIT";
    }
}

DECLARE_API(VATT_TRW,"VATT_TRW")
{
    Token token;
    Directory * node;

    if(container["/cpu"].toString().compare("nios32") != 0)
        ExceptionMessage("VATT_TRW is not supported except for the processor 'nios32'.","VATT_TRWnios32vZbTł̂݃T|[g܂").throwException();

    p.getToken(token);
    node = find(container[OBJECTTREE], token, TASK);

    p.getToken(",","{",NULL);
    parseParameters(p, node, "hi_limit,lo_limit");
    p.getToken("}");
}

DECLARE_API(DEF_TEX,"DEF_TEX")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = find(container[OBJECTTREE], token, TASK);

    p.getToken(",","{",NULL);
    parseParameters(p, node, "texatr,texrtn");
    p.getToken("}");
}

DECLARE_API(CRE_SEM,"CRE_SEM")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, SEMAPHORE);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"sematr,isemcnt,maxsem");
    p.getToken("}");
}

DECLARE_API(CRE_FLG,"CRE_FLG")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, EVENTFLAG);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"flgatr,iflgptn");
    p.getToken("}");
}

DECLARE_API(CRE_DTQ,"CRE_DTQ")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, DATAQUEUE);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"dtqatr,dtqcnt");
    p.getToken(",","NULL","}",NULL);
}

DECLARE_API(CRE_MBX,"CRE_MBX")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, MAILBOX);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"mbxatr,maxmpri");
    p.getToken(",","NULL","}",NULL);
}

DECLARE_API(CRE_MPF,"CRE_MPF")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, FIXEDSIZEMEMORYPOOL);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"mpfatr,blkcnt,blksz");
    p.getToken(",","NULL","}",NULL);
}

DECLARE_API(CRE_CYC,"CRE_CYC")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, CYCLICHANDLER);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"cycatr,exinf,cychdr,cyctim,cycphs");
    p.getToken("}");
}

DECLARE_API(DEF_INH,"DEF_INH")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, INTERRUPTHANDLER, false);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"inhatr,inthdr");
    p.getToken("}");
}

DECLARE_API(DEF_EXC,"DEF_EXC")
{
    Token token;
    Directory * node;

    p.getToken(token);
    node = allocate(container[OBJECTTREE], token, EXCEPTIONHANDLER, false);
    (*node)["position"] = p.getStreamLocation();

    p.getToken(",","{",NULL);
    parseParameters(p,node,"excatr,exchdr");
    p.getToken("}");
}

DECLARE_API(ATT_INI,"ATT_INI")
{
    Token token;
    Directory * node;

    node = container.openChild(OBJECTTREE,INITIALIZER,NULL)->addChild();
    last = node;

    (*node)["position"] = p.getStreamLocation();

    p.getToken("{",NULL);
    parseParameters(p,node,"iniatr,exinf,inirtn");
    p.getToken("}");
}

DECLARE_API(ATT_FIN, "VATT_TER")
{
    Token token;
    Directory * node;

    node = container.openChild(OBJECTTREE,TERMINATOR,NULL)->addChild();
    last = node;

    (*node)["position"] = p.getStreamLocation();

    p.getToken("{",NULL);
    parseParameters(p,node,"teratr,exinf,terrtn");
    p.getToken("}");
}


