/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *
 */

/*
 *	^[QbgVXeˑW[iADSP-BF531/2/3pj
 */

#include "jsp_kernel.h"
#include <sil.h>



#define SYSCFG_VALUE 0x36

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
	// BF531/2/3̃Am[}[΍ rev 0.1, 0.2p
	Asm( "SYSCFG=%0;"  : :"d"(SYSCFG_VALUE) ) ;

	/*
	 *  PLL̐ݒ
	 *
	 */
	/*
	 *  27MHz*22{=594MHzɐݒ肷(600MHz)
	 *  27MHz*28{=756MHzɐݒ肷(750MHz)
	 *  CSEL = 1; SSEL = 5 (600MHz)
	 *  CSEL = 1; SSEL = 6 (750MHz)
	 */
#ifndef FORCE_PLL_INITIALIZE
	 	// PLLl̂܂܂łAASDRAMpłȂPLL
	// EBE	0x00000001
	 if ( ( *__pPLL_CTL == 0x1400 ) && ( !(*__pEBIU_SDBCTL & 0x00000001 /* EBE */ ) ) )
#endif
	 {

		*__pSIC_IWR = 1<<0;				// PLL̂IWR
	// CCLK_DIV1			0x0000
	// CCLK_DIV2			0x0010
	// CCLK_DIV4			0x0020
	// CCLK_DIV8			0x0030
#if CSELVAL == 1
		*__pPLL_DIV = 0x0000 | (SSELVAL);	// CCLK_DIV1
#elif CSELVAL == 2
		*__pPLL_DIV = 0x0010 | (SSELVAL);	// CCLK_DIV2
#elif CSELVAL == 4
		*__pPLL_DIV = 0x0020 | (SSELVAL);	// CCLK_DIV4
#elif CSELVAL == 8
		*__pPLL_DIV = 0x0030 | (SSELVAL);	// CCLK_DIV8
#else
#error Wrong CSELVAL. Must be one of 1,2,4,8.
#endif

		*__pPLL_CTL = MSELVAL << 9;

		asm("cli r0; csync; idle; sti r0;": : :"R0");
		*__pSIC_IWR = 0xFFFFFFFF;	// IWR_ENABLE_ALL;
	}

}


unsigned int priority_mask[16]={
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x0000007F,
0x00000180,
0x00001E00,
0x0000E000,
0x00070000,
0x00180000,
0x00E00000,
0x00000000,
0x00000000
};


/*
* SIC_IARx͂āACxgʂƂɊ蓖ĂĂ銄荞
* ̃rbg}bvBSIC_IARx̃tB[hl͗D揇-7Ȃ̂
* ̕␳B
*/
#define INSTALL_PRIORITY    \
    for ( i=0; i<8; i++ ){ \
        priority = iar & 0xf;                         /* IARD揇ʂo */ \
        priority_mask[priority + 7] |= device;        /* oD揇ʂɊÂfoCXo^ */ \
        device <<= 1;                                 /* ̃foCX */ \
        iar >>= 4;                                    /* IARtB[h */ \
    }

void make_priority_mask( void )
{
	unsigned int i, priority, device, iar;


	/*
 *  荞ݏʂƂISRrbg}bv̍쐬
 *  SIC_IARx̐ݒ͂̕Oɍς܂邱
 */

 	for ( i=0; i<16; i++ ){
 		priority_mask[i] = 0;
 	}

	device = 1;
	iar = *__pSIC_IAR0;
    INSTALL_PRIORITY

	iar = *__pSIC_IAR1;
    INSTALL_PRIORITY

	iar = *__pSIC_IAR2;
    INSTALL_PRIORITY

}


/*
 * 荞݂̋A֎~
 *
 */
ER ena_int( INTNO intno )
{
	unsigned int mask;

	if ( intno >= DEVICE_INTERRUPT_COUNT )
		return ( E_PAR );
	else {
		SIL_PRE_LOC;

		mask = 1 << intno;
		SIL_LOC_INT();			// ǗO荞݂܂ŋ֎~
		*__pSIC_IMASK |= mask;
		asm volatile( "ssync;" );
		SIL_UNL_INT();			// 荞ݍċ
		return (0);
	}
}
/*
 * dis_int()́A̎łSIC_IMASK̎wrbgNAB
 *
 * ASIC_IMASK̃NA̓AvP[Vsɂ͊댯łA
 * Blackfiñ}jAłUȓIɋ֎~ĂB̂߁ATOPPERS/JSP for Blackfin
 * ł́Å֐ȂB
 *
ER dis_int( INTNO intno )
{
	unsigned int mask;

	if ( intno >= DEVICE_INTERRUPT_COUNT )
		return ( E_PAR );
	else {
		mask = 1 << intno;
		mask = ~mask;
		*__pSIC_IMASK &= mask;
		return (0);
	}
}
*/

/*
 * chg_ims()́A̎łSIC_IMASKύXB
 *
 * ASIC_IMASK̃rbg̃NA̓AvP[Vsɂ͊댯łA
 * Blackfiñ}jAłUȓIɋ֎~ĂB̂߁ATOPPERS/JSP for
 * Blackfinł́Å֐ȂB
 *
ER chg_ims( IMS ims )
{
	*__pSIC_IMASK = ims;
	return( 0 );
}
*/


extern ER get_ims( IMS * p_ims )
{
	*p_ims = *__pSIC_IMASK;
	return( 0 );;
}


/*
 *  荞݂foCXɊ蓖Ă
 */
void device_dispatcher(  unsigned int priority, unsigned int imask )
{
	unsigned int candidates, device;

	candidates = priority_mask[priority] & *__pSIC_ISR & *__pSIC_IMASK;	// ݂̃vCIeBɑ銄݌肷

	asm volatile("sti %0;": : "d"(imask) );

	if ( ! candidates ) // 荞݌łȂȂARARł
	{
		if ( priority == ik_hardware_err)
			dev_vector[INHNO_HW_ERROR]();
		else
			if ( priority == ik_timer)
			dev_vector[INHNO_TIMER]();
		else
			dev_vector[INHNO_RAISE]();		//@\tgEFA荞

	}
	else
	{
		if ( candidates & 0x80000000 )
			device = 31;
		else
		{
#ifdef __GNUC__
	asm ( "r1.L = signbits %1; %0 = r1.L(z);":"=d"(device) :"d"(candidates): "R1"  );
#elif defined(__ECC__)
	asm( "%0 = signbits %1;" : "=l"( device ) : "d"( candidates ) );
#else
#error "Compiler is not supported"
#endif
			device = 30 - device;		// bit mask is converted to bit number
		}
		dev_vector[device]();
	}
}



/*
 *  ^[QbgVXȅI
 */
void
sys_exit()
{
	while(1)
		;
}
/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
}



