/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *
 */


/*
 *	vZbTˑW[ AZuꕔiBLACKfinpj
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 */

			// 32bit WX^ɑl[h}N
#ifdef __GNUC__
#define LOADLABEL( reg, value32 ) reg##.h = value32; reg##.l = value32;
#define LOADVALUE( reg, value32 ) reg##.h = ( value32 >> 16 ) &0xFFFF; reg##.l = value32 & 0xFFFF;
#elif defined(__ECC__)
#define LOADVALUE( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);
#define LOADLABEL LOADVALUE
#else
#error "Compiler is not supported"
#endif



#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 *
 *  dispatch ́C݋֎~ԂŌĂяoȂ΂Ȃ
 *  Dexit_and_dispatch C݋֎~ԂŌĂяoB
 *  p0 : &runtsk
 *  p1 : &schedtsk
 *  p2 : runtsk
 *  p3 : schedtsk
 *  p4 : &reqflg
 */
#ifdef __GNUC__
.section .text;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.global _dispatch;
.global _exit_and_dispatch;
.extern ldf_stack_end;
.extern _reqflg;
.extern _call_texrtn;
.extern _runtsk, _schedtsk;
#ifdef __GNUC__
.type _dispatch, STT_FUNC;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif
_dispatch:
	[--sp] = (r7:4, p5:3);
	[--sp] = rets;
	[--sp] = fp;
	LOADLABEL( p0,  _runtsk )
	LOADLABEL( p1,  _schedtsk)
	p2 = [p0];					// p2  runtsk 
	[p2+TCB_sp] = sp;			// ^XNX^bNۑ
	LOADLABEL( r1, dispatch_r )	// sĊJԒnۑ
	[p2+TCB_pc] = r1;
			// XPW[ꂽ^XNo
dispatcher:
	r0 = [p1];
	[p0] = r0;					// runtsk = schedtsk
	cc = r0;
	if !cc jump dispatcher_1;	// runtskΊ荞ݑ҂ɁB
	p3 = r0;					// p3schedtsk
	sp = [p3+TCB_sp];			// ^XNX^bNA
	p5 = [p3+TCB_pc];			// sĊJԒnA
	jump (p5);					// sĊJԒn֔

			// ready ^XNȂꍇ̊ݑ҂
dispatcher_1:
	LOADLABEL( r0, ldf_stack_end)	// CxgX^bN|C^ݒ
	sp = r0;
	LOADLABEL( p4, _reqflg )
wait_for_intr:
	csync;
	raise 14;					// 荞ݑ҂ԂɈڍs
	csync;
	/*
	 *  荞ݑ҂IVG14̊荞ݏԂōsBIVG14ɑJڂ̂
	 *  ǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  ݂҂Ԃ́Cruntsk  NULLi=0jɐݒ肵Ȃ΂Ȃ
	 *  ȂD̂悤ɐݒ肵ȂƁC݃nh iget_tid
	 *  Ăяoۂ̓삪dlɍvȂȂD
	 *
	 *  荞ݑ҂ԂidleɂȂ邽߁Aۂɂ͊荞݂ł͂Ȃwakeup
	 *  CxgߑAɔ荞݂邱ƂɂȂB
	 *  Ċ荞ݑ҂Ȃ߂ɂ́AΉSIC_IWR̃rbg
    *  1ɂĂȂ΂ȂȂB
	 *  ̓AvP[VvO}̐ӔCōsB
	 */
	r0 = [p4];					// reqflag擾
	cc = r0;
	if !cc jump wait_for_intr;	// reqflg0Ȃ犄荞ݑ҂
	r0 = 0;
	[p4] = r0;					// reqflgNA
	jump dispatcher;


			// ^XN̍ĊJԒnB^XNȌȂA
			// dispatch()߂
			// ̃AhXւ͕K dispatcherłB
			// āAp3͕Kschedtsk̓eɂȂĂB
dispatch_r:
	fp = [sp++];
	r2 = [p3+TCB_texptn];		// schedtsk->texptn
	cc = r2 == 0;				// texptrn0Ȃcc => 1
//	r0 = [p3+TCB_enatex];
//	LOADVALUE( r1, TCB_enatex_mask )
	r0 = b[p3+TCB_enatex](z);
	r1 = TCB_enatex_mask;
	r0 = r0 & r1;				// enatex0ȂAaz => 1
	cc |= az;					// cc = ( !enatex || ! texptn ) = !( enatex && texptn )
	if cc jump dispatch_r_1(bp);	// if ( !enatex || !texptn ) ^[
	sp += -12;					// _~[̈m
	call _call_texrtn;
	sp += 12;					// _~[̈J
dispatch_r_1:
	rets = [sp++];
	(r7:4, p5:3) = [sp++];
	rts;
_dispatch.end:

#ifdef __GNUC__
.size	_dispatch, .-_dispatch
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif


/*
 *	TOPPERS/JSPJn:
 *	 start.asm  kernel_startCPUbNԁA^XND揇ʂŌĂԁB
 *	 kernel_start͂̂܂exit_and_dispatchĂԁB
 *	 _exit_and_dispatch́A܂ł̃X^bNԂȂǂPɔpA
 *	 XPW[ꂽ^XNJnB
*/
_exit_and_dispatch:
		// dispatcherȍ~Ŏg|C^ݒ
	LOADLABEL( p0,  _runtsk )
	LOADLABEL( p1,  _schedtsk)
	jump dispatcher;
_exit_and_dispatch.end:

/*
 *  ^XNN
 *  _activate_rւ͂Ȃ炸dispatcherłB̂߁ACPUbN
 * ͂Ȃ΂ȂȂB
 */

	.global _activate_r;
_activate_r:
	r1 = 0xffff(z);
    cli r0;         // ݂̃}XNoB
                        // ǗO荞݂gȂƂɂA荞݋֎~̂cliKv
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r2 = ~r2;					// t}XN
	r1 = r1 & r2;				//
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;				// CPU AbN
	p0 = [sp++];		// ^XNGg[o
	r0 = [sp++];		// ext_tsk̔Ԓno
	rets = r0;			// ext_tsk_~[̖߂Ԓnɂ
	r0 = [sp++];		// ext_info : r0 ͈1
	sp += -12;
	jump (p0);			// ^XN̊Jn
_activate_r.end:


/*
*	ݏ̃Gg
*
*	interrupt_handlerւivgXXEntryWvĂBp0WX^ɂ
*	荞݃xԍi[ĂB
*	荞݂Ƃ̃lXg֌W𒲂ׁAlXgĂȂȂCxgX^bNZbgB
*		p2 : reqflg̃AhX
*		r6 : ^XNX^bN
*		r7 : ASTAT̑ޔ
*
*/

#include "saverestore.h"

.global interrupt_dispatcher;
.global task_context;
.extern _device_dispatcher, _enadsp;
.extern _event_fp;

#ifdef __GNUC__
.type interrupt_dispatcher, STT_FUNC;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif
interrupt_dispatcher:
				// save all task context register
	save_regs;					// [U[WX^̑ޔ
	r0 = 0;
	l0 = r0;
	l1 = r0;
	l2 = r0;
	l3 = r0;
	lc0 = r0;					// \ቺ}̂߂LCxNA
	lc1 = r0;
	LOADVALUE( p1, __IPEND )			// IPENDWX^̃AhX
	r0 = [p1];					// IPEND̒l擾
	r1 = 0x7fef;				//
	r0 = r0 & r1;				// IVG15GIDȊO𒲂ׂ
	r0.L = ones r0;				// ̃Cxg̐𐔂
	r0 += -1;					// Cxg̐-1BlXgĂȂ0ɂȂB
	cc = az;					// lXgĂȂΐ^
	if !cc jump call_interrupt;	// lXgĂ΃nhĂ
								// lXgĂȂ荞݂ȂAX^bN؂ւ
	r6 = sp;					// ^XNX^bN|C^ޔ
	LOADLABEL( r0, ldf_stack_end)	// CxgX^bN|C^ݒ
	sp = r0;

call_interrupt:
	cli r1;						// IMASǨÂlp[^
	[--sp] = reti;				// Ŋ荞݉\ɂȂ
	r7 = astat;					// ccɂ̓lXg񂪓ĂBޔ
	r0 = p0;					// 荞ݏʂp[^
	LOADLABEL( p0, _device_dispatcher)
	sp += -12;					// _~[m (A)
	call	(p0);				// CŏꂽfoCXfBXpb`Ă
	sp += 12;					// _~[J (A)
	astat = r7;					// cc𕜋A
	reti = [sp++];				// ōĂъ荞݋֎~
	if !cc jump get_back;		// lXgĂȂ΁Â܂܋A

								// ł͊荞݂̓lXgĂȂ
	sp = r6;					// X^bN^XNX^bNɐݒ

	LOADLABEL( p2, _reqflg)			// reqflg̃AhX
	r0 = [p2];					// reqflg̒l擾
	cc = r0;					// fBXpb`^XNO̗v͏oĂ邩
	if !cc jump get_back(bp);	// oĂȂȂΊ荞܂ꂽ^XNɖ߂

								// ReLXg؂ւƊJn
	r0 = 0;						//
	[p2] = r0;					// reqflgNA.
	r0 = reti;					// ^XN̖߂Ԓno
	r1 = 1;
	r0 = r1 | r0; 				// ZtElXgłƋU
	[--sp] = r0;				// ߂ԒnX^bNɂ
	LOADLABEL( p0, task_context)

	cli r0;						// ݂CPUbNԂ擾
	[--sp] = r0;				// bNԂޔ

	r1 = 0xC01F(z);				// ^XNReLXg͂CPUbNԂŎs
#ifdef UNMANAGED_INT
    r2 = UNMANAGED_INT(z);
    r0 = r0 & r2;				// ǗO荞݂̃}XNԂ𒊏o
    r1 = r0 | r1;				// ^XNReLXgCPUbNԂŎs
#endif
	sti r1;						// CPUbN (B)

	reti = p0;					// x"task_context"荞݂̖߂Ԓnɂ
	rti;						// 荞݂߂BReLXg̓^XNɂȂ
	csync;
task_context:					// ̓^XNReLXgŁACPUbNԂł
	LOADLABEL( p0, _enadsp)
	LOADLABEL( p1, _runtsk)


	r2 = [p0];					// load enadsp
	cc = r2;					// fBXpb`\H
	if !cc jump go_tex;			// fBXpb`֎~ȂO`FbN

	LOADLABEL( p0, _schedtsk)		// fBXpb`\̏ꍇ
	r1 = [p1];					// runtsk
	r0 = [p0];					// schedtsk
	cc = r0 == r1;				// schedtsk == runtsk@H
	if cc jump go_tex(bp);		//  schedtsk == runtsk@Ȃ΁A^XNOɍs
								// łȂ΃fBXpb`
	sp += -12;					// _~[̈m (C)
	call _dispatch;				// bcS[
	sp += 12;					// _~[̈J (C)
	jump return_as_task;		// ^XNɖ߂

go_tex:
	p1 = [p1];					// runtsk
	r0 = [p1 + TCB_texptn];		// runtsk->texptrn擾 ( UINT )
	cc = r0 == 0;				// texptn0Ȃ1
//	r0 = [p1 + TCB_enatex];		// runtsk->enatex擾
//	LOADVALUE( r1, TCB_enatex_mask)
	r0 = b[p1 + TCB_enatex](z);		// runtsk->enatex擾
	r1 = TCB_enatex_mask;
	r1 = r0 & r1;				// ^XNOĂȂ1
	cc |= az;					// OĂȂAtexptn0ȂΑA
	if cc jump return_as_task(bp);	// ĂȂ΃^XNɖ߂
	sp += -12;					// _~[̈m (D)
	call _call_texrtn;			// ̂Ń^XNOsB
	sp += 12;					// _~[̈J (D)

return_as_task:					// ^XNReLXgԂł̖߂
	r0 = [sp++];				// ޔĂbN
	reti = [sp++];				// ߂Ԓn𕜋ABȌrti܂Ŋ݋֎~
    cli r1;               // ݂̃bNԂo
                                // ǗO荞݂gȂꍇcli͕ی̂ߕKv
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r1 = r1 & r2;				// s̃}XNǗO荞݂̏Ԃ𒊏o
	r2 = ~ r2;					// UNMANAGED_INT̋t}XN
	r0 = r0 & r2;				// ޔ𒆂̃bNԂǗO荞݃}XNNA
	r0 = r0 | r1;				// ޔĂbNԂAbvf[g
#endif
	sti r0;						// CPUbN(B)(F)


get_back:						// ^XNReLXgԂł̖߂
	restore_regs;				// ޔWX^SĖ߂
	p0=[sp++];
	rti;						// ^XNɖ߂


#ifdef __GNUC__
.size	interrupt_dispatcher, .-interrupt_dispatcher
#elif defined(__ECC__)
interrupt_dispatcher.end:
#else
#error "Compiler is not supported"
#endif


.global expEntry
.global expEntry;
.global nmiEntry;
.global ivHWEntry;
.global ivTMREntry;
.global ivg7Entry;
.global ivg8Entry;
.global ivg9Entry;
.global ivg10Entry;
.global ivg11Entry;
.global ivg12Entry;
.global ivg13Entry;
.global ivg14Entry;
#ifdef __GNUC__
.section .text;
.type expEntry, STT_FUNC;
.type nmiEntry, STT_FUNC;
.type ivTMREntry, STT_FUNC;
.type ivHWEntry, STT_FUNC;
.type ivg7Entry, STT_FUNC;
.type ivg8Entry, STT_FUNC;
.type ivg9Entry, STT_FUNC;
.type ivg10Entry, STT_FUNC;
.type ivg11Entry, STT_FUNC;
.type ivg12Entry, STT_FUNC;
.type ivg13Entry, STT_FUNC;
.type ivg14Entry, STT_FUNC;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif


/*
*	ÕGg
*
*	荞݂Ƃ̃lXg֌W𒲂ׁAlXgĂȂȂCxgX^bNZbgB
*		p0 : [U[`̗Onh̃AhX
*		p1 : IPEND̃AhX
*		p2 : reqflg̃AhX
*		r6 : ^XNX^bN
*		r7 : ASTAT̑ޔ
*
*/
expEntry:
	[--sp] = p0;
	save_regs;					// [U[WX^̑ޔ

	LOADLABEL( p0, _exc_vector)		// [U[`Onh̊i[AhX
	LOADVALUE( p1, __IPEND )			// IPENDWX^̃AhX

	l0 = r0;
	l1 = r0;
	l2 = r0;
	l3 = r0;
	lc0 = r0;					// \ቺ}̂߂LCxNA
	lc1 = r0;

	p0 = [p0];					// p0 = exc_vector
	r0 = [p1];					// IPEND̒l擾
	r1 = 0x7fef;				//
	r0 = r0 & r1;				// IVG15GIDȊO𒲂ׂ. r0.H͕K0
	r0.L = ones r0;				// ̃Cxg̐𐔂
	r0 += -1;					// Cxg̐-1BlXgĂȂ0ɂȂB
	cc = r0 == 0;				// lXgĂȂΐ^
	if !cc jump call_exception; // lXgĂ΃nhĂ
								// lXgĂȂCxgȂAX^bN؂ւ
	r6 = sp;					// ^XNX^bN|C^ޔ
	LOADLABEL( r0, ldf_stack_end)	// CxgX^bN|C^ݒ
	sp = r0;

call_exception:
	r7 = astat;					// ccɂ̓lXg񂪓ĂBޔ
	r0 = p1;					// IPEND̃AhX
	sp += -12;					// _~[̈m (E)
	call	(p0);				// CŏꂽOnhĂ
	sp += 12;					// _~[̈J (E)
	astat = r7;					// cc𕜋A
	if !cc jump get_back_x;		// lXgĂȂ΁Â܂܋A

								// ł̓Cxg̓lXgĂȂ
	sp = r6;					// X^bN^XNX^bNɐݒ

	LOADLABEL( p2, _reqflg )
	r0 = [p2];					// reqflg̒l擾
	cc = r0;					// fBXpb`^XNO̗v͏oĂ邩
	if !cc jump get_back_x;		// oĂȂȂΊ荞܂ꂽ^XNɖ߂

								// ReLXg؂ւƊJn
	r0 = 0;						//
	[p2] = r0;					// reqflgNA.
	r0 = retx;					// ^XN̖߂Ԓno
	r1 = 1;
	r0 = r1 | r0; 				// ZtElXgłƋU
	[--sp] = r0;				// ߂ԒnX^bNɂ
	LOADLABEL( p0, task_context)

	cli r0;						// ݂CPUbNԂ擾
	[--sp] = r0;				// bNԂޔ
	r1 = 0xC01F(z);				// ^XNReLXg͂CPUbNԂŎs

#ifdef UNMANAGED_INT
    r2 = UNMANAGED_INT(z);
    r0 = r0 & r2;				// ǗO荞݂̃}XNԂ𒊏o
    r1 = r0 | r1;				// ^XNReLXgCPUbNԂŎs
#endif
	sti r1;						// CPUbN (F)

	retx = p0;					// x"taskiv_context"O̖߂Ԓnɂ
	rtx;						// O߂BReLXg̓^XNɂȂ

get_back_x:
	restore_regs;				// ޔWX^SĖ߂
	p0=[sp++];
	rtx;


#ifdef __GNUC__
.size	expEntry, .-expEntry
#elif defined(__ECC__)
expEntry.end:
#else
#error "Compiler is not supported"
#endif



// Cxgnh̃Gg[R[hQB
// EVT̃Ggɂ͑Ήȉ̃R[h̃xi[B
// ꂼ̃R[h̓Cxgɂp0Ɋi[A
// interrupt_dispatcherɃWv
// evtvector̓[U[nhւ̃|C^̔z




ivHWEntry:
	[--sp] = p0;
	p0 = 5;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivHWEntry, .-ivHWEntry
#elif defined(__ECC__)
ivHWEntry.end:
#else
#error "Compiler is not supported"
#endif


ivTMREntry:
	[--sp] = p0;
	p0 = 6;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivTMREntry, .-ivTMREntry
#elif defined(__ECC__)
ivTMREntry.end:
#else
#error "Compiler is not supported"
#endif


ivg7Entry:
	[--sp] = p0;
	p0 = 7;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg7Entry, .-ivg7Entry
#elif defined(__ECC__)
ivg7Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg8Entry:
	[--sp] = p0;
	p0 = 8;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg8Entry, .-ivg8Entry
#elif defined(__ECC__)
ivg8Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg9Entry:
	[--sp] = p0;
	p0 = 9;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg9Entry, .-ivg8Entry
#elif defined(__ECC__)
ivg9Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg10Entry:
	[--sp] = p0;
	p0 = 10;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg10Entry, .-ivg10Entry
#elif defined(__ECC__)
ivg10Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg11Entry:
	[--sp] = p0;
	p0 = 11;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg11Entry, .-ivg11Entry
#elif defined(__ECC__)
ivg11Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg12Entry:
	[--sp] = p0;
	p0 = 12;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg12Entry, .-ivg12Entry
#elif defined(__ECC__)
ivg12Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg13Entry:
	[--sp] = p0;
	p0 = 13;
	jump.x interrupt_dispatcher;
#ifdef __GNUC__
.size	ivg13Entry, .-ivg13Entry
#elif defined(__ECC__)
ivg13Entry.end:
#else
#error "Compiler is not supported"
#endif

ivg14Entry:					// dispatch()̊荞ݑ҂
								// USE_HW_ERRORׂ͌݊̈ɎcĂB
#if !defined(USE_TIC_CORE) && !defined(USE_HW_ERROR) && !defined(QUICK_HW_ERROR)
	csync;						// RA^C}[ŃeBbNނƂɂidle߂gȂB
	idle;						// Cxg҂
	csync;
#endif
	[--sp] = reti;				// ݃lXg
	r1 = 0xffff(z);				// CPU AbNpp^[
#ifdef UNMANAGED_INT
    cli r0;               // ݂̃}XNo
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r2 = ~r2;					// t}XN
	r1 = r1 & r2;				//
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;						// CPU AbN
	r1 = 0xC01F(z);				// CPU bNpp^[
    cli r0;               // ݂̃}XNo
                                // ǗO荞݂gȂꍇAی̂ߕKv
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;
	reti=[sp++];				// ݃lXg֎~
	rti;
#ifdef __GNUC__
.size	ivg14Entry, .-ivg14Entry
#elif defined(__ECC__)
ivg14Entry.end:
#else
#error "Compiler is not supported"
#endif


nmiEntry:
	jump	nmiEntry;
	rtn;
#ifdef __GNUC__
.size	nmiEntry, .-nmiEntry
#elif defined(__ECC__)
nmiEntry.end:
#else
#error "Compiler is not supported"
#endif




/*
 *  ԑ҂
 *  ̃[v12TCNŉB
 */
	.global _sil_dly_nse;
_sil_dly_nse:
	r1 = SIL_DLY_TIM1;
	r2 = SIL_DLY_TIM2;
	r0 = r0 - r1;			// dilay - SIL_DLY_TIM1
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse_1:
	r0 = r0 - r2;
	nop;
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse.end:

