/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[iDVE68K/40pj
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <dve68k_dga.h>

/*
 *  vZbTʂ̂߂̕ϐi}`vZbTΉj
 */
UINT	board_id;		/* {[hID */
VP	board_addr;		/* [J̐擪AhX */

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
	/*
	 *  vZbTʂ̂߂̕ϐ̏
	 */
	board_id = ((UINT)(sil_rew_mem((VP) TADR_BOARD_REG0)) & 0x1f);
	board_addr = (VP)(board_id << 24);

	/*
	 *  ݊֘Ȁ
	 *
	 *  ׂĂ݂̊}XNENAC݃xNgݒ肷D
	 */
	dga_write((VP) TADR_DGA_CSR21, 0);
	dga_write((VP) TADR_DGA_CSR23, ~0);
	dga_write((VP) TADR_DGA_CSR19, (TVEC_G0I << 24) | (TVEC_G1I << 16)
					| (TVEC_SWI << 8) | TVEC_SPRI);

	/*
	 *  A{[g݂̐ݒiNMIj
	 *
	 *  A{[g݂̊݃xݒ肵CvNAC
	 *  }XND
	 */
	dga_set_ilv((VP) TADR_DGA_CSR24, TBIT_ABTIL, TIRQ_NMI);
	dga_write((VP) TADR_DGA_CSR23, TBIT_ABT);
	dga_bit_or((VP) TADR_DGA_CSR21, TBIT_ABT);

	/*
	 *  ̈̐ݒ
	 *
	 *  [JVMEoXł̐擪AhXƃTCYi16MBj
	 *  CANZX󂯕t悤ɐݒ肷D܂CVMEoX
	 *  gAhXANZX󂯕t悤ɂɐݒ肷D
	 */
	dga_write((VP) TADR_DGA_CSR4, (UW) board_addr | 0x00ff);
	dga_write((VP) TADR_DGA_CSR5, 0x0000012fu);

	/*
	 *  C^tF[XWX^iIFRj̐ݒ
	 *
	 *  C^tF[XWX^̃x[XAhXݒ肷D܂CC
	 *  ^tF[XWX^0̃T[rXNGXgtONAD
	 *  C^tF[XWX^3Ƀ{[hIDԍݒD
	 */
	dga_write((VP) TADR_DGA_CSR3, (board_id << 4) | 0x3);
	dga_write((VP) TADR_DGA_IFR0, 0x80000000u);
	dga_write((VP) TADR_DGA_IFR3, board_id);

	/*
	 *  Ehr[hɐݒi}`vZbTΉj
	 */
	dga_write((VP) TADR_DGA_CSR1, (dga_read((VP) TADR_DGA_CSR1)
			& 0xffeffcff) | (1u << 20) | ((board_id % 4) << 8));
}

/*
 *  ^[QbgVXȅI
 */
void
sys_exit()
{
	dve68k_exit();
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		dve68k_putc('\r');
	}
	dve68k_putc(c);
}
