/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: startup.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	J[l̏ƏI
 */

#include "jsp_kernel.h"
#include "time_event.h"
#include "syslog.h"

/*
 *  J[lԃtO
 */
BOOL	iniflg;

/*
 *  J[l̏
 */
void
kernel_start()
{
	/*
	 *  ^[Qbgˑ̏
	 */
	cpu_initialize();
	sys_initialize();
	tool_initialize();

	/*
	 *  VXeO@\̏
	 */
	syslog_initialize();

	/*
	 *  NbZ[W̕\
	 */
	print_banner();

	/*
	 *  eW[̏
	 *
	 *  ^CCxgǗW[͑̃W[ɏ
	 *  KvD
	 */
	tmevt_initialize();
	object_initialize();

	/*
	 *  [`̎s
	 */ 
	call_inirtn();

	/*
	 *  J[l̊Jn
	 */
	iniflg = TRUE;
	exit_and_dispatch();
}

/*
 *  J[l̏I
 */
void
kernel_exit()
{
	/*
	 *  ݂֎~
	 */
	if (!sense_lock()) {
		if (sense_context()) {
			i_lock_cpu();
		}
		else  {
			t_lock_cpu();
		}
	}
	iniflg = FALSE;

	/*
	 *  I[`̎s
	 */
	call_terrtn();

	/*
	 *  atexit ̏ƃfXgN^̎s
	 */
	call_atexit();

	/*
	 *  VXeO@\̏I
	 */
	syslog_terminate();

	/*
	 *  ^[Qbgˑ̏I
	 */
	cpu_terminate();
	sys_exit();
}
