/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: time_event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	^CCxgǗW[
 */

#ifndef _TIME_EVENT_H_
#define _TIME_EVENT_H_

/*
 *  Cxg̃f[^^̒`
 *
 *  EVTTIM ́CRELTIM ƂĎwł͈͂L͈͂\łK
 *  vDX^_[hvt@Cł́CRELTIM  16bit ȏłȂ
 *  ΂ȂȂ߁CEVTTIM  17bit ȏł邱ƂKvłD
 *  ߁C16bit ̏ꍇ UINT ł͂ȂCUW ɒ`ĂD
 */
typedef UW	EVTTIM;

/*
 *  ΎԁiRELTIMjɎwłől
 */
#define	TMAX_RELTIM	((((EVTTIM) 1) << (sizeof(EVTTIM) * CHAR_BIT - 1)) - 1)

/* 
 *  ^CCxgubÑf[^^̒`
 */
typedef void	(*CBACK)(VP);	/* R[obN֐̌^ */

typedef struct time_event_block {
	UINT	index;		/* ^CCxgq[vł̈ʒu */
	CBACK	callback;	/* R[obN֐ */
	VP	arg;		/* R[obN֐֓n */
} TMEVTB;

/*
 *  ^CCxgq[ṽm[h̃f[^^̒`
 */
typedef struct time_event_node {
	EVTTIM	time;		/* Cxg */
	TMEVTB	*tmevtb;	/* Ή^CCxgubN */
} TMEVTN;

/*
 *  ^CCxgq[vikernel_cfg.cj
 */
extern TMEVTN	tmevt_heap[];

/*
 *  VXẽItZbg
 */
extern SYSTIM	systim_offset;

/*
 *  ݂̃VXeiP: ~bj
 *
 *  VXeN 0 ɏCȍ~Cisig_tim Ă΂xɒP
 *  ɑDset_tim ɂĕύXȂD
 */
extern SYSTIM	current_time;

/*
 *  ̃^CeBbÑVXeiP: 1~bj
 */
extern SYSTIM	next_time;

/*
 *  VXeώZpϐiP: 1/TIM_DENO~bj
 *
 *  ̃^CeBbÑVXẻʌiʌ next_timejD
 *  TIC_DENO  1 ̎́Cʌ͏ 0 ł邽߁C̕ϐ͕KvȂD
 */
#if TIC_DENO != 1
extern UINT	next_subtime;
#endif /* TIC_DENO != 1 */

/*
 *  ΎԂ̃x[XiP: 1~bj
 *
 *  ̃^CeBbÑVXe؂グDTIC_DENO  1 
 *  ́Cnext_time  EVTTIM ɕϊ̂ɈvD
 */
#if TIC_DENO == 1
#define	base_time	((EVTTIM) next_time)
#else /* TIC_DENO == 1 */
#define	base_time	((EVTTIM)(next_time + (next_subtime > 0 ? 1 : 0)))
#endif /* TIC_DENO == 1 */

/*
 *  ^CCxgq[v̍Ō̎gp̈̃CfbNX
 *
 *  ^CCxgq[vɓo^Ă^CCxg̐ɈvD
 */
extern UINT	last_index;

/*
 *  ^CCxgǗW[̏
 */
extern void	tmevt_initialize(void);

/*
 *  ^CCxg̑}ʒu̒T
 */
extern UINT	tmevt_up(UINT index, EVTTIM time);
extern UINT	tmevt_down(UINT index, EVTTIM time);

/*
 *  ^CCxgq[vւ̓o^ƍ폜
 */
extern void	tmevtb_insert(TMEVTB *tmevtb, EVTTIM time);
extern void	tmevtb_delete(TMEVTB *tmevtb);

/*
 *  ^CCxgubN̓o^iΎԎwj
 *
 *  time Ŏw肵ΎԂoߌɁCarg Ƃ callback 
 *  яo悤ɁC^CCxgubN tmevtb o^D
 */
Inline void
tmevtb_enqueue(TMEVTB *tmevtb, RELTIM time, CBACK callback, VP arg)
{
	assert(time <= TMAX_RELTIM);

	tmevtb->callback = callback;
	tmevtb->arg = arg;
	tmevtb_insert(tmevtb, base_time + time);
}

/*
 *  ^CCxgubN̓o^iCxgwj
 *
 *  time Ŏw肵CxgɁCarg Ƃ callback 
 *  яo悤ɁC^CCxgubN tmevtb o^D
 */
Inline void
tmevtb_enqueue_evttim(TMEVTB *tmevtb, EVTTIM time, CBACK callback, VP arg)
{
	tmevtb->callback = callback;
	tmevtb->arg = arg;
	tmevtb_insert(tmevtb, time);
}

/*
 *  ^CCxgubN̓o^
 */
Inline void
tmevtb_dequeue(TMEVTB *tmevtb)
{
	tmevtb_delete(tmevtb);
}

#endif /* _TIME_EVENT_H_ */
