/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: st16c2550.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *   ST16C2550 p ȈSIOhCo
 */
#ifndef _ST16C2550_H_
#define _ST16C2550_H_

#include <t_config.h>

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block {
    UW reg_base;    /* WX^̃x[XAhX */
    UB lcr_val;     /* [hWX^̐ݒl   */
    UB dlm_val;     /* {[[gʂ̐ݒl   */
    UB dll_val;     /* {[[gʂ̐ݒl   */
    UW pinter_val;  /* ݋rbg   */    
} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
typedef struct sio_port_control_block {
    const SIOPINIB  *siopinib; /* VAI/O|[gubN */
    VP_INT          exinf;     /* g */
    BOOL    openflag;          /* I[vς݃tO */
    BOOL    sendflag;          /* M݃Cl[utO */
    BOOL    getready;          /* M */
    BOOL    putready;          /* 𑗐Mł */
}SIOPCB;


/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND    1u      /* M\R[obN */
#define SIO_ERDY_RCV    2u      /* MʒmR[obN */


/*
 * J[lNp̏(sys_putcgp邽)
 */
extern void st16c2550_init(void);

/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
extern void st16c2550_pol_putc(char c, ID siopid);


/*
 *  SIOhCȍ[`
 */
extern void st16c2550_initialize(void);


/*
 *  I[vĂ|[g邩H
 */
extern BOOL st16c2550_openflag(void);


/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB   *st16c2550_opn_por(ID siopid, VP_INT exinf);


/*
 *  VAI/O|[g̃N[Y
 */
extern void st16c2550_cls_por(SIOPCB *siopcb);


/*
 *  VAI/O|[gւ̕M
 */
extern BOOL st16c2550_snd_chr(SIOPCB *siopcb, char c);


/*
 *  VAI/O|[g̕M
 */
extern INT  st16c2550_rcv_chr(SIOPCB *siopcb);


/*
 *  VAI/O|[g̃R[obN̋
 */
extern void st16c2550_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void st16c2550_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  SIO̊݃T[rX[`
 */
extern void st16c2550_isr(void);


/*
 *  VAI/O|[g̑M\R[obN
 */
extern void st16c2550_ierdy_snd(VP_INT exinf);


/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void st16c2550_ierdy_rcv(VP_INT exinf);


#endif /* _FDC37C935A_H_ */
