/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

#include <tl16pir552.h>

/*
 *	TL16PIR552(TI)p ȈSIOhCo
 */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	VP	channel_addr;	/* VA|[g̊JnԒn */

	UB	lcr_def;	/* LCRݒl b0-b6;
				(MrbgAXgbvrbgCpeB) */
	UB	scr_def;	/* SCRݒlivXP[Gj*/
	UB	boud_hi_def;	/* DLMݒli{[[gʂ̐ݒlj */
	UB	boud_lo_def;	/* DLLݒli{[[gʂ̐ݒlj */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
	BOOL		getready;	/* M */
	BOOL		putready;	/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 *    ID = 1 |[g1CID = 2 |[g2ɑΉĂD
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (VP)  UART_CH01,
	  (UB)	WORD_LENGTH_8 | STOP_BITS_1 | PARITY_NON,
	  (UB)	PRE_DIVISOR,
	  (UB)	HI8(DIVISOR),
	  (UB)	LO8(DIVISOR) },
#if TNUM_SIOP >= 2
	{ (VP)  UART_CH02,
	  (UB)	WORD_LENGTH_8 | STOP_BITS_1 | PARITY_NON,
	  (UB)	PRE_DIVISOR,
	  (UB)	HI8(DIVISOR),
	  (UB)	LO8(DIVISOR) },
#endif /* TNUM_SIOP >= 2 */
};

/*
 *  VAI/O|[gubN̎o
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))


/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOpWX^֐
 */
Inline void
tl16pir552_orb( VP addr, UW reg, UB val )
{
	tl16pir552_wrb( addr, reg, tl16pir552_reb( addr, reg ) | val );
}

Inline void
tl16pir552_andb( VP addr, UW reg, UB val )
{
	tl16pir552_wrb( addr, reg, tl16pir552_reb( addr, reg ) & val );
}


/*
 *  Ԃ̓ǏoiIIR̓Ǐoj
 */
static void
tl16pir552_get_stat(SIOPCB *siopcb)
{
	UB	iir;

	iir = tl16pir552_reb( siopcb->siopinib->channel_addr, IIR) & INT_MASK;

	switch( iir ) {
		case INT_TRANS_EMPTY :
			siopcb->putready = TRUE;
			break;
		case INT_RECEIVE_DATA :
		case INT_CHAR_TIME_OUT :
			siopcb->getready = TRUE;
			break;
		default :
			break;
	}

}

/*
 *  Mł邩H
 */
Inline BOOL
tl16pir552_getready(SIOPCB *siopcb)
{
	return(siopcb->getready);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
tl16pir552_putready(SIOPCB *siopcb)
{
	return(siopcb->putready);
}

/*
 *  M̎o
 */
Inline char
tl16pir552_getchar(SIOPCB *siopcb)
{
	siopcb->getready = FALSE;
	return((char) tl16pir552_reb( siopcb->siopinib->channel_addr, RBR ));
	/* 1byte Pʂł̎̕os邽߁Atl16pir552_opn_por
	   Mobt@ݒ𑝂₵ƂĂ\̌͌ȂB
	   \̌ɂ́Aobt@Ŝ̃ubN]sȂǂ̏CKvB*/
}

/*
 *  M镶̏
 */
Inline void
tl16pir552_putchar(SIOPCB *siopcb, char c)
{
	siopcb->putready = FALSE;
	tl16pir552_wrb( siopcb->siopinib->channel_addr, THR, c );
}

/*
 *  SIOhCȍ[`
 */
void
tl16pir552_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  SIOWX^[`
 */
void
tl16pir552_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * SIOWX^̏
	 */
	/*  */
	tl16pir552_wrb( siopinib->channel_addr, IER, DIS_INT );

	tl16pir552_wrb( siopinib->channel_addr, MCR, ENABLE_EXT_INT );

	/* {[[g̐ݒ */
	tl16pir552_wrb( siopinib->channel_addr, LCR, siopinib->lcr_def | DIVISOR_LATCH_ACC );

	tl16pir552_wrb( siopinib->channel_addr, SCR, siopinib->scr_def );

	tl16pir552_wrb( siopinib->channel_addr, DLL, siopinib->boud_lo_def );
	tl16pir552_wrb( siopinib->channel_addr, DLM, siopinib->boud_hi_def );

	/* [h̐ݒ */
	tl16pir552_wrb( siopinib->channel_addr, LCR, siopinib->lcr_def );

	/* FIFO̐ݒ */
	tl16pir552_wrb( siopinib->channel_addr, FCR, FIFO_ENABLE );
	tl16pir552_wrb( siopinib->channel_addr, FCR, FIFO_ENABLE | RECEIVE_FIFO_RESET | TRANS_FIFO_RESET | RECEIVE_TRIG_1_BYTE );
	tl16pir552_wrb( siopinib->channel_addr, FCR, FIFO_ENABLE | RECEIVE_TRIG_1_BYTE );

	/* I */
	tl16pir552_wrb( siopinib->channel_addr, MCR, DTR | RTS | ENABLE_EXT_INT );

	tl16pir552_wrb( siopinib->channel_addr, IER, RECEIVE_DATA_AVAILABLE);
}

/*
 *  J[lÑo[i[o͗p̏
 */
void
tl16pir552_init(void)
{
	tl16pir552_init_siopinib( get_siopinib(1) );
#if TNUM_SIOP >= 2
	tl16pir552_init_siopinib( get_siopinib(2) );
#endif /* TNUM_SIOP >= 2 */
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
tl16pir552_openflag(void)
{
#if TNUM_SIOP < 2
	return(siopcb_table[0].openflag);
#else /* TNUM_SIOP < 2 */
	return(siopcb_table[0].openflag || siopcb_table[1].openflag);
#endif /* TNUM_SIOP < 2 */
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
tl16pir552_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb = get_siopcb(siopid);
	const SIOPINIB	*siopinib = siopcb->siopinib;

	/* VARg[̏ */
	tl16pir552_init_siopinib( siopinib );

	/* ݃xݒAݗvNÁAsio_opn_por(hw_serial.h)ōsB */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
tl16pir552_cls_por(SIOPCB *siopcb)
{
	tl16pir552_wrb( siopcb->siopinib->channel_addr, IER, DIS_INT );

	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
tl16pir552_snd_chr(SIOPCB *siopcb, char c)
{
	if (tl16pir552_putready(siopcb)) {
		tl16pir552_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
tl16pir552_rcv_chr(SIOPCB *siopcb)
{
	if (tl16pir552_getready(siopcb)) {
		return((INT)(UB) tl16pir552_getchar(siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
tl16pir552_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ier_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		ier_bit = TRANS_REG_EMPTY;
		break;
	case SIO_ERDY_RCV:
		ier_bit = (RECEIVE_DATA_AVAILABLE | RECEIVE_LINE_STATUS);
		break;
	}

	tl16pir552_orb( siopcb->siopinib->channel_addr, IER, ier_bit );
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
tl16pir552_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ier_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		ier_bit = TRANS_REG_EMPTY;
		break;
	case SIO_ERDY_RCV:
		ier_bit = (RECEIVE_DATA_AVAILABLE | RECEIVE_LINE_STATUS);
		break;
	}

	tl16pir552_andb( siopcb->siopinib->channel_addr, IER, ~ier_bit );
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
tl16pir552_isr_siop(SIOPCB *siopcb)
{
	tl16pir552_get_stat(siopcb);

	if ( tl16pir552_getready(siopcb) ) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		tl16pir552_ierdy_rcv(siopcb->exinf);
	} else if ( tl16pir552_putready(siopcb) ) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		tl16pir552_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
tl16pir552_uart0_isr()
{
	if (siopcb_table[0].openflag) {
		tl16pir552_isr_siop(&(siopcb_table[0]));
	}
}

#if TNUM_SIOP >= 2
void
tl16pir552_uart1_isr()
{
	if (siopcb_table[1].openflag) {
		tl16pir552_isr_siop(&(siopcb_table[1]));
	}
}
#endif /* TNUM_SIOP >= 2 */

/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
void
tl16pir552_putchar_pol( char val ) {

	const SIOPINIB  *siopinib = get_siopinib( LOGTASK_PORTID );

	/* MGveBɂȂ܂ő҂B */
	while( (tl16pir552_reb( siopinib->channel_addr, LSR ) & (TEMT) ) == 0 );

	tl16pir552_wrb( siopinib->channel_addr, THR, val );
}
