/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ConditionPart.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_CONDITION_PART_HPP_
#define _TOPS_CONDITION_PART_HPP_

#include "tops/common/Printable.hpp"

#include <map>
#include <string>
#include <vector>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Condition;
	typedef boost::shared_ptr<Condition> ConditionPtr;

	/**
	 * łBv_NV[̋Lqł́Aɂ̂Left Hand SideƂ܂B
	 *
	 * @author gDC[
	 */
	class ConditionPart : public Printable {
	private:
		typedef std::vector<ConditionPtr> ConditionVector;
		typedef ConditionVector::iterator iterator;
		typedef ConditionVector::const_iterator const_iterator;

		/**
		 * łB
		 */
		ConditionVector m_conditions;

		typedef std::map<std::string, size_t> ConditionMap;
		typedef ConditionMap::iterator mapIterator;
		typedef ConditionMap::const_iterator const_mapIterator;

		/**
		 * xtłB
		 */
		ConditionMap m_labeledConditions;

	public:
		/**
		 * TCY擾܂B
		 */
		size_t size() const {
			return m_conditions.size();
		}

		/**
		 * ǉ܂B
		 */
		void add(const ConditionPtr& condition);

		/**
		 * x̔ԍ擾܂B
		 */
		int getLabeledConditionNumber(const std::string& label) const;

		/**
		 * 擾܂B
		 */
		const ConditionPtr& operator[](size_t index);

		/**
		 * 擾܂B
		 */
		ConditionPtr operator[](const std::string& label);

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
