/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ProductionSystem.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PRODUCTION_SYSTEM_HPP_
#define _TOPS_PRODUCTION_SYSTEM_HPP_

#include "tops/PSListener.hpp"
#include "tops/RuleBase.hpp"
#include "tops/WorkingMemory.hpp"

#include "tops/utilities/CloseContainer.hpp"

#include <boost/shared_ptr.hpp>

namespace tops {

	class AttributeOfFact;
	class Constant;
	typedef boost::shared_ptr<Constant> ConstantPtr;
	class Instance;
	class PSListener;
	typedef boost::shared_ptr<PSListener> PSListenerPtr;

	class ProductionSystem;
	typedef boost::shared_ptr<ProductionSystem> ProductionSystemPtr;

	/**
	 * v_NVVXełB
	 *
	 * @author gDC[
	 */
	class ProductionSystem {
	private:
		typedef Utility::CloseList<PSListener*> ListenerContainer;
		typedef ListenerContainer::iterator listener_iterator;
		typedef ListenerContainer::const_iterator listener_const_iterator;

		ListenerContainer m_listeners;

	protected:
		/**
		 * [x[XłB
		 */
		RuleBase m_ruleBase;

		/**
		 * [LOłB
		 */
		WorkingMemory m_workingMemory;

	public:
		/**
		 * [x[X擾܂B
		 */
		const RuleBase& getRuleBase() const {
			return m_ruleBase;
		}

		/**
		 * [LO擾܂B
		 */
		const WorkingMemory& getWorkingMemory() const {
			return m_workingMemory;
		}

	public:
		/**
		 * v_NVVXej܂B
		 */
		virtual ~ProductionSystem() {
		}

	public:
		/**
		 * [ǉ܂B
		 *
		 * @param rule ǉ郋[w肵܂B
		 *
		 * @return
		 * ǉꍇ͒ǉꂽv_NV[AȊȌꍇNULLԂ܂B
		 * ŕԂꂽv_NV[́A
		 * v_NVVXeɂĊǗ邽߁AdeleteKv͂܂B
		 */
		ProductionRule* add(const RulePtr& rule);

		/**
		 * ǉ܂B
		 *
		 * @param fact ǉ鎖w肵܂B
		 * @param source CX^Xw肵܂B
		 *
		 * @return
		 * ǉꍇ͒ǉꂽ[LOvfAȊȌꍇNULLԂ܂B
		 * ŕԂꂽ[LOvf́A
		 * v_NVVXeɂĊǗ邽߁AdeleteKv͂܂B
		 */
		WMElement* add(const FactPtr& fact, const Instance* source = 0);

		/**
		 * ǉ܂B
		 *
		 * @param element ̒ǉΏۂƂȂ郏[LOvfw肵܂B
		 * @param name ǉ鑮̑w肵܂B
		 * @param constant ǉ鑮̑lƂȂ萔w肵܂B
		 * @param source CX^Xw肵܂B
		 *
		 * @return ǉꍇ͒ǉꂽAȊȌꍇNULLԂ܂B
		 */
		AttributeOfFact* add(
				WMElement& element,
				const std::string& name,
				const ConstantPtr& constant,
				const Instance* source = 0);

	public:
		/**
		 * ɑΉ郏[LOvf擾܂B
		 *
		 * @return ݂ꍇ͑Ή郏[LOvfA݂ȂꍇNULLԂ܂B
		 */
		WMElement* find(const FactPtr& fact);

	public:
		/**
		 * CxgXiǉ܂B
		 */
		void addListener(const PSListenerPtr& listener) {
			m_listeners.push_front(listener.get());
		}

		/**
		 * CxgXiǉ܂B
		 */
		void addListener(PSListener& listener) {
			m_listeners.push_front(&listener);
		}

	private:
		/**
		 * v_NV[ǉꂽƂCxgXiɒʒm܂B
		 */
		void notifyAdded(ProductionRule& rule);

		/**
		 * [LOvfǉꂽƂCxgXiɒʒm܂B
		 */
		void notifyAdded(WMElement& element);

		/**
		 * ǉꂽƂCxgXiɒʒm܂B
		 */
		void notifyAdded(WMElement& element, const std::string& name, const ConstantPtr& constant);

	public:
		virtual void update() {
		}
	};

}  // namespace tops

#endif
