/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Rule.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_RULE_HPP_
#define _TOPS_RULE_HPP_

#include "tops/ActionPart.hpp"
#include "tops/ConditionPart.hpp"

#include "tops/common/Printable.hpp"

#include <string>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Rule;
	typedef boost::shared_ptr<Rule> RulePtr;

	/**
	 * [łB
	 *
	 * @author gDC[
	 */
	class Rule : public Printable {
	private:
		/**
		 * OłB
		 */
		std::string m_name;

		/**
		 * łB
		 */
		ConditionPart m_lhs;

		/**
		 * słB
		 */
		ActionPart m_rhs;

	public:
		/**
		 * [\z܂B
		 *
		 * @param name Kw肵܂B
		 * @param lhs w肵܂B
		 * @param rhs sw肵܂B
		 */
		Rule(const std::string& name, const ConditionPart& lhs, const ActionPart& rhs) :
		m_name(name), m_lhs(lhs), m_rhs(rhs) {
		}

	public:
		/**
		 * O擾܂B
		 */
		const std::string& getName() const {
			return m_name;
		}

		/**
		 * 擾܂B
		 */
		ConditionPart& getConditionPart() {
			return m_lhs;
		}

		ActionPart& getActionPart() {
			return m_rhs;
		}

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
