/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: UnificatedElements.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_UNIFICATED_ELEMENTS_
#define _TOPS_UNIFICATED_ELEMENTS_

#include "tops/common/Printable.hpp"

#include <deque>

#include <boost/shared_ptr.hpp>

namespace tops {

	class Contradiction;

	class UnificatedElement;
	typedef boost::shared_ptr<UnificatedElement> UnificatedElementPtr;
	class UnificatedElements;
	typedef boost::shared_ptr<UnificatedElements> UnificatedElementsPtr;

	/**
	 * PꉻςݗvfłB
	 *
	 * @author gDC[
	 */
	class UnificatedElements : public Printable {
	private:
		typedef std::deque<UnificatedElementPtr> ElementContainer;
		typedef ElementContainer::iterator iterator;
		typedef ElementContainer::const_iterator const_iterator;

		ElementContainer m_elements;

	public:
		/**
		 * TCY擾܂B
		 */
		size_t size() const {
			return m_elements.size();
		}

		/**
		 * [LOvf擾܂B
		 */
		UnificatedElementPtr& operator[](size_t i) {
			return m_elements[i];
		}

		/**
		 * [LOvf擾܂B
		 */
		const UnificatedElementPtr& operator[](size_t i) const {
			return m_elements[i];
		}

		/**
		 * ̃[LOvf擾܂B
		 */
		const UnificatedElementPtr& back() const {
			return m_elements.back();
		}

		/**
		 * Ƀ[LOvfǉ܂B
		 */
		void push(const UnificatedElementPtr& element) {
			m_elements.push_back(element);
		}

		/**
		 * 烏[LOvf폜܂B
		 */
		void pop() {
			m_elements.pop_back();
		}

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
