/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: AddAttributeAction.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_ADD_ATTRIBUTE_ACTION_HPP_
#define _TOPS_ADD_ATTRIBUTE_ACTION_HPP_

#include "tops/Action.hpp"
#include "tops/FireableAction.hpp"

#include "tops/attribute/AttributesOfObjectInAction.hpp"

#include <boost/shared_ptr.hpp>

namespace tops {

	class AttributesOfFact;
	typedef boost::shared_ptr<AttributesOfFact> AttributesOfFactPtr;

	/**
	 * ǉsłB
	 *
	 * @author gDC[
	 */
	class AddAttributeAction : public Action {
	private:
		/**
		 * xłB
		 */
		std::string m_label;

		/**
		 * ǉ鑮łB
		 */
		AttributesOfObjectInAction m_attributes;

	public:
		/**
		 * s\z܂B
		 *
		 * @param label sΏۂƂȂ鎖̃xw肵܂B
		 * @param attributes ǉ鑮w肵܂B
		 */
		AddAttributeAction(const std::string& label, const AttributesOfObjectInAction& attributes) :
		m_label(label), m_attributes(attributes) {
		}

	public:
		/**
		 * CX^XāAs\ȍs擾܂B
		 *
		 * @param variables ̉Ɏgpϐ\w肵܂B
		 */
		FireableActionPtr instantiate(const Variables& variables) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

	/**
	 * s\ǉsłB
	 *
	 * @author gDC[
	 */
	class FireableAddAttributeAction : public FireableAction {
	private:
		/**
		 * xłB
		 */
		std::string m_label;

		/**
		 * ǉ鑮łB
		 */
		AttributesOfFactPtr m_attributes;

	public:
		/**
		 * s\z܂B
		 *
		 * @param label sΏۂƂȂ鎖̃xw肵܂B
		 * @param attributes ǉ鑮w肵܂B
		 */
		FireableAddAttributeAction(const std::string& label, const AttributesOfFactPtr& attributes) :
		m_label(label), m_attributes(attributes) {
		}

	public:
		/**
		 * ss܂B
		 *
		 * @param system sΏۂƂȂv_NVVXew肵܂B
		 * @param instance ssCX^Xw肵܂B
		 * @return sꍇtrueAsꍇfalseԂB
		 */
		bool fire(ProductionSystem& system, const Instance& instance);

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
