/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ProgressiveProductionSystem.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PROGRESSIVE_PRODUCTION_SYSTEM_HPP_
#define _TOPS_PROGRESSIVE_PRODUCTION_SYSTEM_HPP_

#include "tops/ProductionSystem.hpp"
#include "tops/PSListener.hpp"

#include "tops/system/progressive/ProgressiveRuleBase.hpp"

#include "tops/utilities/CloseContainer.hpp"

#include <map>

#include <boost/shared_ptr.hpp>

namespace tops {

	class ProgressiveProductionSystem;
	typedef boost::shared_ptr<ProgressiveProductionSystem> ProgressiveProductionSystemPtr;

	/**
	 * isv_NVVXełB
	 *
	 * @author gDC[
	 */
	class ProgressiveProductionSystem : public ProductionSystem, public PSListener {
	private:
		ProgressiveRuleBase m_progressiveRuleBase;

		typedef std::multimap<std::string, ProgressiveRulePtr> ProgressiveRuleMap;
		ProgressiveRuleMap m_misfireRules;

	public:
		/**
		 * isv_NVVXe\z܂B
		 */
		ProgressiveProductionSystem();

	public:
		/**
		 * is[x[X擾܂B
		 */
		const ProgressiveRuleBase& getProgressiveRuleBase() const {
			return m_progressiveRuleBase;
		}

	private:
		/**
		 * w肵[LOvfis[x[XƒPꉻ܂B
		 */
		void unificateToRuleBase(WMElement& element);

		/**
		 * w肵isv_NV[[LOƒPꉻ܂B
		 */
		void unificateToWorkingMemory(const ProgressiveRulePtr& rule);

	public:
		/**
		 * [LOvfǉꂽƂɌĂяo܂B
		 */
		void added(ProductionSystem& system, WMElement& element);

		/**
		 * v_NV[ǉꂽƂɌĂяo܂B
		 */
		void added(ProductionSystem& system, ProductionRule& productionRule);

		/**
		 * ǉꂽƂɌĂяo܂B
		 */
		void added(ProductionSystem& system,
		           WMElement& element, const std::string& name, const ConstantPtr& constant);

	public:
		/**
		 * isv_NV[\z܂B
		 */
		ProgressiveRulePtr createProgressiveRule(ProductionRule& rule);

		/**
		 * isv_NV[\z܂B
		 */
		ProgressiveRulePtr createProgressiveRule(
				ProgressiveRule& parent,
				const UnificatedElementPtr& lastElement,
				const Variables& variables);

	private:
		/**
		 * isv_NV[ǉ܂B
		 *
		 * @param rule ǉisv_NV[w肵܂B
		 */
		bool addProgressiveRule(const ProgressiveRulePtr& rule);

	public:
		void update();
	};

}  // namespace tops

#endif
