/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ProgressiveRuleBase.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PROGRESSIVE_RULE_BASE_HPP_
#define _TOPS_PROGRESSIVE_RULE_BASE_HPP_

#include "tops/common/Printable.hpp"
#include "tops/system/progressive/ProgressiveRule.hpp"

#include <map>
// #include "tops/utilities/CloseMap.hpp"

#include <string>

namespace tops {

	/**
	 * is[x[XłB
	 *
	 * @author gDC[
	 */
	class ProgressiveRuleBase : public Printable {
	private:
		typedef std::multimap<std::string, ProgressiveRulePtr> ProgressiveRuleMap;
		// TODO(2004/12/10): CloseMap NX upperBound Ƃ͈͂Ɋ֌W郁\bhKvB
		// typedef Utility::CloseMap<std::string, ProgressiveRulePtr> ProgressiveRuleMap;

		/**
		 * is҂ɂĎQƉ\ȃ[}bvłB
		 */
		ProgressiveRuleMap m_ruleMap;

	public:
		typedef ProgressiveRuleMap::iterator mapIterator;
		typedef ProgressiveRuleMap::const_iterator const_mapIterator;

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return 󂾂trueA󂶂ȂfalseԂ܂B
		 */
		bool empty() const;

		/**
		 * TCY擾܂B
		 */
		size_t size() const;

		/**
		 * isv_NV[ǉ܂B
		 */
		void add(const ProgressiveRulePtr& rule);

	public:
		mapIterator begin() {
			return m_ruleMap.begin();
		}

		const_mapIterator begin() const {
			return m_ruleMap.begin();
		}

		mapIterator end() {
			return m_ruleMap.end();
		}

		const_mapIterator end() const {
			return m_ruleMap.end();
		}

	public:
		/**
		 * is҂ŗvfi荞݂܂B
		 */
		std::pair< mapIterator, mapIterator > range(const std::string &name);

		/**
		 * is҂ŗvfi荞݂܂B
		 */
		std::pair< const_mapIterator, const_mapIterator > range(const std::string &name) const;

	public:
		/**
		 * is҂ɑΉŏ̗vfwq擾܂B
		 */
		mapIterator lower_bound(const std::string& name);

		/**
		 * is҂ɑΉŏ̗vfwq擾܂B
		 */
		const_mapIterator lower_bound(const std::string& name) const;

	public:
		/**
		 * is҂傫ŏ̗vfwq擾܂B
		 */
		mapIterator upper_bound(const std::string& name);

		/**
		 * is҂傫ŏ̗vfwq擾܂B
		 */
		const_mapIterator upper_bound(const std::string& name) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
