/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: CloseMap.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_CLOSE_MAP_HPP_
#define _UTILITY_CLOSE_MAP_HPP_

#include "tops/utilities/CloseContainer/CloseContainer.hpp"
#include "tops/utilities/CloseContainer/CloseRelationImpl.hpp"

#include <map>

namespace Utility {

	/**
	 * }bvev[głB
	 * ̃ev[ǵA^ɃL[^ƖReivf̃|C^^iX}[g|C^jKvƂ܂B
	 * L[^ɂ͔Cӂ̌^wł܂B
	 * Reivf̃|C^^ɕKvƂȂ鐫ȉɎ܂B
     *
     * 1. CloseContainerElement ̃|C^i̓X}[g|C^jł邱ƁB
	 *
	 * ̖}bvev[ǵA STL  std::map 𗘗pĂ܂B
	 *
	 * @author gDC[
	 */
	template<typename KeyType, typename PtrType>
	class CloseMap : public CloseContainer {
	private:
		typedef std::map<KeyType, PtrType> ValueMap;
		ValueMap m_values;
		typedef std::pair<KeyType, PtrType> ValuePair;

	public:
		/**
		 * q^łB
		 */
		typedef typename ValueMap::iterator iterator;

		/**
		 * 萔q^łB
		 */
		typedef typename ValueMap::const_iterator const_iterator;

	public:
		/**
		 * }bv\z܂B
		 */
		CloseMap() {
		}

		/**
		 * }bvj܂B
		 */
		~CloseMap() {
			clear();
		}

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return ̏ꍇ trueAȊȌꍇ falseB
		 */
		bool empty() const {
			return m_values.empty();
		}

		/**
		 * L[̑ݐiO܂͂PjԂ܂B
		 *
		 * @param key L[B
		 * @return L[݂ꍇ͂PAȊȌꍇ͂OB
		 */
		size_t count(const KeyType& key) const {
			return m_values.count();
		}

		/**
		 * TCY擾܂B
		 *
		 * @return TCYB
		 */
		size_t size() const {
			return m_values.size();
		}

		/**
		 * vf̐擪q擾܂B
		 *
		 * @return qB
		 */
		iterator begin() {
			return m_values.begin();
		}

		/**
		 * vf̐擪萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator begin() const {
			return m_values.begin();
		}

		/**
		 * vf̖q擾܂B
		 *
		 * @return qB
		 */
		iterator end() {
			return m_values.end();
		}

		/**
		 * vf̖萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator end() const {
			return m_values.end();
		}

	public:
		/**
		 * SĂ̗vf폜܂B
		 */
		void clear() {
			while (!empty()) {
				iterator i = begin();
				i->second->release(*this);
			}
		}

	public:
		/**
		 * L[ɑΉ锽q擾܂B
		 *
		 * @param key L[B
		 * @return qBL[ɑΉ锽qȂꍇ end()B
		 */
		iterator find(const KeyType& key) {
			return m_values.find(key);
		}

		/**
		 * L[ɑΉ萔q擾܂B
		 *
		 * @param key L[B
		 * @return 萔qBL[ɑΉ锽qȂꍇ end()B
		 */
		const_iterator find(const KeyType& key) const {
			return m_values.find(key);
		}

	public:
		/**
		 * L[w肵Ēl擾܂B
		 *
		 * @param key L[B
		 * @return L[ɑΉl݂ꍇ͂̒lAȊȌꍇ NULLB
		 */
		PtrType operator[](const KeyType& key) const {
			const_iterator i = m_values.find(key);
			return (i != m_values.end()) ? i->second : PtrType();
		}

		/**
		 * vfǉ܂B
		 * AɃL[ɑΉl݂ꍇ͒ǉɎs܂B
		 *
		 * @param pair L[ƒl̃yAB
		 * @return ǉɐꍇ trueAsꍇ falseB
		 */
		bool insert(const ValuePair& pair) {
			std::pair<iterator, bool> i = m_values.insert(pair);
			if (i.second && !!i.first->second) {
				addRelation(*i.first->second, CloseRelationPtr(new CloseRelationImpl<ValueMap>(
					m_values, i.first, this)));
			}
			return i.second;
		}
	};

}  // namespace Utility

#endif
