/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: CloseMultiMap.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_CLOSE_MULTI_MAP_HPP_
#define _UTILITY_CLOSE_MULTI_MAP_HPP_

#include "tops/utilities/CloseContainer/CloseContainer.hpp"
#include "tops/utilities/CloseContainer/CloseRelationImpl.hpp"

#include <map>

namespace Utility {

	/**
	 * }`}bvev[głB
	 * ̃ev[ǵA^ɃL[^ƖReivf̃|C^^iX}[g|C^jKvƂ܂B
	 * L[^ɂ͔Cӂ̌^wł܂B
	 * Reivf̃|C^^ɕKvƂȂ鐫ȉɎ܂B
     *
     * 1. CloseContainerElement ̃|C^i̓X}[g|C^jł邱ƁB
	 *
	 * ̖}`}bvev[ǵA STL  std::multimap 𗘗pĂ܂B
	 *
	 * @author gDC[
	 */
	template<typename KeyType, typename PtrType>
	class CloseMultiMap : public CloseContainer {
	private:
		typedef std::multimap<KeyType, PtrType> ValueMap;
		ValueMap m_values;
		typedef std::pair<KeyType, PtrType> ValuePair;

	public:
		/**
		 * q^łB
		 */
		typedef typename ValueMap::iterator iterator;

		/**
		 * 萔q^łB
		 */
		typedef typename ValueMap::const_iterator const_iterator;

	public:
		/**
		 * }`}bv\z܂B
		 */
		CloseMultiMap() {
		}

		/**
		 * }`}bvj܂B
		 */
		~CloseMultiMap() {
			clear();
		}

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return ̏ꍇ trueAȊȌꍇ falseB
		 */
		bool empty() const {
			return m_values.empty();
		}

		/**
		 * L[̑ݐԂ܂B
		 *
		 * @param key L[B
		 * @return L[̑ݐB
		 */
		size_t count(const KeyType& key) const {
			return m_values.count(key);
		}

		/**
		 * TCY擾܂B
		 *
		 * @return TCYB
		 */
		size_t size() const {
			return m_values.size();
		}

		/**
		 * vf̐擪q擾܂B
		 *
		 * @return qB
		 */
		iterator begin() {
			return m_values.begin();
		}

		/**
		 * vf̐擪萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator begin() const {
			return m_values.begin();
		}

		/**
		 * vf̖q擾܂B
		 *
		 * @return qB
		 */
		iterator end() {
			return m_values.end();
		}

		/**
		 * vf̖萔q擾܂B
		 *
		 * @return 萔qB
		 */
		const_iterator end() const {
			return m_values.end();
		}

	public:
		/**
		 * SĂ̗vf폜܂B
		 */
		void clear() {
			while (!empty()) {
				iterator i = begin();
				i->second->release(*this);
			}
		}

	public:
		/**
		 * vfǉ܂B
		 *
		 * @param pair L[ƒl̃yAB
		 */
		void insert(const ValuePair& pair) {
			iterator i = m_values.insert(pair);
			if (i->second) {
				addRelation(*i->second, CloseRelationPtr(new CloseRelationImpl<ValueMap>(
					m_values, i, this)));
			}
		}

		/**
		 * vfǉ܂B
		 *
		 * @param pos vfǉۂ̃qgB
		 * @param pair L[ƒl̃yAB
		 */
		void insert(iterator pos, const ValuePair& pair) {
			iterator i = m_values.insert(pos, pair);
			if (i->second) {
				addRelation(*i->second, CloseRelationPtr(new CloseRelationImpl<ValueMap>(
					m_values, i, this)));
			}
		}

		/**
		 * w肳ꂽL[ɑΉ͈͂擾܂B
		 *
		 * @param key L[B
		 * @return ͈͂̐擪Ɩq̃yAB
		 */
		std::pair<iterator, iterator> equal_range(const KeyType& key) {
			return m_values.equal_range(key);
		}

		/**
		 * w肳ꂽL[ɑΉ͈͂擾܂B
		 *
		 * @param key L[B
		 * @return ͈͂̐擪Ɩ萔q̃yAB
		 */
		std::pair<const_iterator, const_iterator> equal_range(const KeyType& key) const {
			return m_values.equal_range(key);
		}

		/**
		 * w肳ꂽL[ɑΉŏ̗vf擾܂B
		 *
		 * @param key L[B
		 * @return qBvfȂꍇ end()B
		 */
		iterator lower_bound(const KeyType& key) {
			return m_values.lower_bound(key);
		}

		/**
		 * w肳ꂽL[ɑΉŏ̗vf擾܂B
		 *
		 * @param key L[B
		 * @return 萔qBvfȂꍇ end()B
		 */
		const_iterator lower_bound(const KeyType& key) const {
			return m_values.lower_bound(key);
		}

		/**
		 * w肳ꂽL[傫L[ɑΉŏ̗vf擾܂B
		 *
		 * @param key L[B
		 * @return qBvfȂꍇ end()B
		 */
		iterator upper_bound(const KeyType& key) {
			return m_values.upper_bound(key);
		}

		/**
		 * w肳ꂽL[傫L[ɑΉŏ̗vf擾܂B
		 *
		 * @param key L[B
		 * @return 萔qBvfȂꍇ end()B
		 */
		const_iterator upper_bound(const KeyType& key) const {
			return m_values.upper_bound(key);
		}
	};

}  // namespace Utility

#endif
