/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: RelationController.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_RELEASE_POLICY_HPP_
#define _UTILITY_RELEASE_POLICY_HPP_

#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>

namespace Utility {

	class CloseContainer;
	class CloseRelation;
	typedef boost::shared_ptr<CloseRelation> CloseRelationPtr;

	/**
	 * ֘A̗LԂ𐧌䂷閧֘AC^[tFCXłB
	 * ̃C^[tFCX́A
	 * ̖ReivfSĂ̖֘A̗LԂ𐧌䂷邽߂̂̂łB
	 * ֘A̎҂́A
	 * ̃C^[tFCXgpĖ֘A̗LԂɍ킹֘ANXKv܂B
	 * 
	 * ֘ANX́AaddRelation  release \bhĂяo^C~O
	 * ΏۖReivf̖֘A𐧌䂵܂B
	 * isOwned \bh́A֘AsĂ邩ǂ̖₢킹s߂̃\bhłB
	 * ֘ANX̎҂́ASẴ\bhK؂ɎKv܂B
	 *
	 * @author gDC[
	 */
	class RelationController : public boost::noncopyable {
	public:
		/**
		 * ֘AĂ邩ǂ𔻒f܂B
		 *
		 * @return ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		virtual bool isOwned() const = 0;

		/**
		 * ΏۖReiw肵āA֘AĂ邩ǂ𔻒f܂B
		 *
		 * @param owner ReiB
		 * @return ΏۖReiƖ֘AĂꍇ trueAȊȌꍇ falseB
		 */
		virtual bool isOwned(CloseContainer& owner) const = 0;

		/**
		 * ֘A܂B֘AĂȂꍇ͉܂B
		 * ̃\bh́AReivfSĂ̖֘AƂɌĂяo܂B
		 */
		virtual void release() = 0;

		/**
		 * ΏۖReiw肵Ė֘A܂B
		 * ΏۖReiƖ֘AĂȂꍇ͉܂B
		 * ̃\bh́AReivf̖ReiƖ֘AƂɌĂяo܂B
		 *
		 * @param from ReiB
		 */
		virtual void release(CloseContainer& from) = 0;

		/**
		 * ֘Aǉ܂B
		 * ̃\bh́AReivfReivfƖ֘AƂɌĂяo܂B
		 *
		 * @param relation ֘AB
		 */
		virtual void addRelation(const CloseRelationPtr& relation) = 0;
	};

}  // namespace Utility

#endif
