/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: SharedToPointerIterator.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _UTILITY_SHARED_TO_POINTER_ITERATOR_HPP_
#define _UTILITY_SHARED_TO_POINTER_ITERATOR_HPP_

namespace Utility {

	/**
	 * shared_ptr<T>qT*̔qɕϊ܂B
	 *
	 * @author gDC[
	 */
	template<class Iterator, class ValueType>
	class SharedToPointerIterator {
	private:
		/**
		 * bv锽qłB
		 */
		Iterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		SharedToPointerIterator(Iterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		SharedToPointerIterator<Iterator, ValueType>& operator++() {
			++m_i;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		SharedToPointerIterator<Iterator, ValueType>& operator++(int dummy) {
			++m_i;
			return *this;
		}

		/**
		 * q̓e擾܂B
		 */
		ValueType* operator*() const {
			return (*m_i).get();
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const SharedToPointerIterator<Iterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const SharedToPointerIterator<Iterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

	/**
	 * shared_ptr<T>萔qconst T*̒萔qɕϊ܂B
	 *
	 * @author gDC[
	 */
	template<class ConstIterator, class ValueType>
	class ConstSharedToPointerIterator {
	private:
		/**
		 * bv锽qłB
		 */
		ConstIterator m_i;

	public:
		/**
		 * bp[\z܂B
		 */
		ConstSharedToPointerIterator(ConstIterator i) : m_i(i) {
		}

	public:
		/**
		 * q(Ou)CNg܂B
		 */
		ConstSharedToPointerIterator<ConstIterator, ValueType>& operator++() {
			++m_i;
			return *this;
		}

		/**
		 * q(u)CNg܂B
		 */
		ConstSharedToPointerIterator<ConstIterator, ValueType>& operator++(int dummy) {
			++m_i;
			return *this;
		}

		/**
		 * q̓e擾܂B
		 */
		ValueType* const operator*() const {
			return (*m_i).get();
		}

	public:
		/**
		 * łB
		 */
		bool operator==(const ConstSharedToPointerIterator<ConstIterator, ValueType>& i) {
			return m_i == i.m_i;
		}

		/**
		 * słB
		 */
		bool operator!=(const ConstSharedToPointerIterator<ConstIterator, ValueType>& i) {
			return m_i != i.m_i;
		}
	};

}  // namespace Utility

#endif
