/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: RefCountArray.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TEMPLATES_REF_COUNT_ARRAY_HPP_
#define _TEMPLATES_REF_COUNT_ARRAY_HPP_

#include "tops/utilities/Pointer/MessageCounter.hpp"

namespace Utility {

	/**
	 * QƃJEg^̃X}[g|C^izpjłB
	 *
	 * @author gDC[
	 */
	template<class T>
	class RefCountArray {
	private:
		T* m_ptr;
		MessageCounter* m_count;

	public:
		/**
		 * X}[g|C^\z܂B
		 */
		explicit RefCountArray(T *p = 0) : m_ptr(p), m_count(new MessageCounter(1)) {
		}

		/**
		 * z̃TCYw肵ăX}[g|C^\z܂B
		 */
		explicit RefCountArray(unsigned int size) : m_ptr(0), m_count(new MessageCounter(1)) {
			if (size) {
				m_ptr = new T[size];
			}
		}

		/**
		 * plRs[RXgN^łB
		 */
		template<class R>
		RefCountArray(const RefCountArray<R>& rhs) : m_ptr(rhs.get()), m_count(rhs.getCounter()) {
			++(*m_count);
		}

		/**
		 * Rs[RXgN^łB
		 */
		RefCountArray(const RefCountArray<T>& rhs) : m_ptr(rhs.m_ptr), m_count(rhs.m_count) {
			++(*m_count);
		}

		/**
		 * X}[g|C^j܂B
		 */
		virtual ~RefCountArray() {
			refcountdec();
		}

	public:
		/**
		 * plZqłB
		 */
		template<class R>
		RefCountArray<T>& operator=(const RefCountArray<R>& rhs) {
			if (m_ptr != rhs.m_ptr) {
				refcountdec();
				m_ptr = rhs.m_ptr;
				m_count = rhs.m_count;
				++(*m_count);
			}

			return *this;
		}

		/**
		 * ZqłB
		 */
		RefCountArray<T>& operator=(const RefCountArray<T>& rhs) {
			if (m_ptr != rhs.m_ptr) {
				refcountdec();
				m_ptr = rhs.m_ptr;
				m_count = rhs.m_count;
				++(*m_count);
			}

			return *this;
		}

	public:
		/**
		 * |C^lǂ𔻒肵܂B
		 *
		 * @return |C^lꍇtrueANULL̏ꍇfalseԂ܂B
		 */
		operator bool() const {
			return 0 != m_ptr;
		}

		/**
		 * |C^NULLlǂ𔻒肵܂B
		 *
		 * @return |C^NULL̏ꍇtrueAlꍇfalseԂ܂B
		 */
		bool operator!() const {
			return 0 == m_ptr;
		}

	public:
		/**
		 * YZqiCXyN^jłB
		 */
		const T& operator[](unsigned int index) const {
			return m_ptr[index];
		}

		/**
		 * YZqi~[e[^jłB
		 */
		T& operator[](unsigned int index) {
			return m_ptr[index];
		}

		/**
		 * |C^擾܂B
		 */
		T* get() const {
			return m_ptr;
		}

		/**
		 * JEg|C^擾܂B
		 */
		MessageCounter* getCounter() const {
			return m_count;
		}

	private:
		void refcountdec() {
			--(*m_count);

			if (!(*m_count)) {
				delete [] m_ptr;
				m_ptr = 0;
				delete m_count;
				m_count = 0;
			}
		}
	};

}  // namespace Utility

#endif
