/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Variable.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_VARIABLE_HPP_
#define _TOPS_VARIABLE_HPP_

#include "tops/value/Value.hpp"

#include <string>

#include <boost/shared_ptr.hpp>

namespace tops {

	/**
	 * ϐłB
	 *
	 * @author gDC[
	 */
	class Variable : public Value {
	private:
		/**
		 * ϐłB
		 */
		std::string m_name;

	public:
		/**
		 * ϐ\z܂B
		 *
		 * @param name ϐw肵܂B
		 */
		Variable(const std::string& name);

	public:
		/**
		 * ϐl󂩂ǂ𔻒f܂B
		 *
		 * @return ̏ꍇtrueA󂶂ȂꍇfalseԂ܂B
		 */
		bool empty(const Variables& variables) const {
			return !getValue(variables);
		}

		/**
		 * ϐ擾܂B
		 */
		const std::string& getName() const {
			return m_name;
		}

		/**
		 * ϐl擾܂B
		 */
		const Constant* getValue(const Variables& variables) const;

	public:
		/**
		 * w肳ꂽ萔ƒPꉻs܂B
		 *
		 * @param value PꉻΏۂƂȂ萔w肵܂B
		 * @param variables PꉻɎgpϐ\w肵܂B
		 * @return PꉻɐtrueAsfalseԂ܂B
		 */
		bool unificate(const Constant& value, Variables& variables) const;

		/**
		 * l̉܂B
		 *
		 * @param variables ̉Ɏgpϐ\w肵܂B
		 */
		ConstantPtr instantiate(const Variables& variables) const;

	public:
		// ConditionVariableɗRrZqQłB

		bool operator==(const ConstantAndVariables& a) const;
		bool operator!=(const ConstantAndVariables& a) const;
		bool operator< (const ConstantAndVariables& a) const;
		bool operator> (const ConstantAndVariables& a) const;
		bool operator<=(const ConstantAndVariables& a) const;
		bool operator>=(const ConstantAndVariables& a) const;

		// ł͕Еivaluej萔ł邱Ƃ킩̂ŁA
		// Zq̏ԂuЂԂv܂B

		bool operator==(const ValueAndVariables& a) const;
		bool operator!=(const ValueAndVariables& a) const;
		bool operator< (const ValueAndVariables& a) const;
		bool operator> (const ValueAndVariables& a) const;
		bool operator<=(const ValueAndVariables& a) const;
		bool operator>=(const ValueAndVariables& a) const;

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

	typedef boost::shared_ptr<Variable> VariablePtr;

}  // namespace tops

#endif
